<?php
/**
 * 支付宝接口类
 */
namespace pay;

class Yue{
	
    public function __construct($config=array()){
    	foreach ($config as $k => $v) {
    		$this->$k=$v;
    	}
    }
    


	/**
	 * app支付  2018-04-04
	 * $param 数组
	 * title  商品标题
	 * orderno 订单号
	 * amount 付款金额
	 * notify_url 支付回调地址
	 * return_url 支付成功跳转地址
	 * other 其它参数
	 */
	function pc($param){
		$uid=session("user_auth.id");
		$yue=M('money')->where(array('uid'=>$uid))->sum('price');
		if($yue>$param['amount']){
		    D('pub/money')->create(array(
				'price'=>-$param['amount'],
				'charge'=>0,
				'uid'=>$uid,
				'no'=>$param['orderno'],
				'type'=>3,
				'about'=>'网盘购买',
				'amount'=>-$param['amount'],
				'ctime'=>time(),
			));
			$id=D('pub/money')->add();
			if($id){
				$data=array(
					'orderno'=>$param['orderno'],
					'amount'=>$param['amount'],
					'id'=>$id,
				);
			    wd_http($param['notify_url'],'',$data,'POST');
				sleep(1);
				header("location:".$param['return_url']);
			}
			
		}
	}

	/**
    * 生成手机版网页支付代码
    * @param   array   $param      订单信息
    */
	function wap($param){
		$orderno = $param['order_no'];
		$title = isset($param['title'])?$param['title']:'订单'.$orderno;//订单名称，必填
		$amount = $param['amount'];//付款金额，必填
		$body = isset($param['body'])?$param['body']:'订单'.$orderno;//商品描述，可空
	    $timeout_express="1m";//超时时间
	
	    $payRequestBuilder = new \alipay\wappay\buildermodel\AlipayTradeWapPayContentBuilder();
	    $payRequestBuilder->setBody($body);
	    $payRequestBuilder->settitle($title);
	    $payRequestBuilder->setOutTradeNo($orderno);
	    $payRequestBuilder->setTotalAmount($amount);
	    $payRequestBuilder->setTimeExpress($timeout_express);
	
	    $payResponse = new \alipay\wappay\service\AlipayTradeService($this->config);
	    $result=$payResponse->wapPay($payRequestBuilder,$this->config['return_url'],$this->config['notify_url']);
	}
	
	/**
	 * app支付  2018-04-02
	 * $param 数组
	 * title  商品标题
	 * orderno 订单号
	 * amount 付款金额
	 * notify_url 支付回调地址
	 */
   	public function app($param){
   		vendor('autoload');
		$request = new \alipay\aop\request\AlipayTradeAppPayRequest();
		$param['product_code']='QUICK_MSECURITY_PAY';
		$request->setNotifyUrl($param['notify_url']);
		$bizcontent = json_encode($param);
		$request->setBizContent($bizcontent);
		$response = $this->aop->sdkExecute($request);
		return $response;//就是orderString 可以直接给客户端请求，无需再做处理。
	}
	
	/**
	 * 验签方法 2018-04-04
	 * @return boolean
	 */
	function check(){
		$id=I('id');
		$orderno=I('orderno');
		$amount=I('amount');
		$info=M('money')->find($id);
		if($info['no']==$orderno && $info['amount']==-$amount){
		    $redata=array(
				'orderno'=>$info['no'],
				'amount'=>$amount,
				'other'=>'',
				'pay_id'=>$info['no'],
				'pay_way'=>'余额',
				'pay_time'=>time(),
			);
			return $redata;
		}else{
			return false;
		}
	}
	
	/**
	 * 回调通知
	 */
	function notifyReturn(){
		return 'success';
	}
	
	
}