<?php
require_once "DzPay.Exception.php";
require_once "DzPay.Config.php";
require_once "DzPay.Data.php";

class Pay
{
	public function Payment($inputObj,$timeOut = 10)
	{
		try
		{
			//检测必填参数
			if(!$inputObj->IsAppidSet() || $inputObj->GetAppid()=='')
			{
				throw new DzPayException("缺少必填参数AppId");
			}
			else if(!$inputObj->IsProductNameSet() || $inputObj->GetProductName()=='')
			{
				throw new DzPayException("缺少必填参数ProductName");
			}
			else if(!$inputObj->IsProductDescriptionSet() || $inputObj->GetProductDescription()=='')
			{
				throw new DzPayException("缺少必填参数ProductDescription");
			}
			else if(!$inputObj->IsMerchantOrderNoSet() || $inputObj->GetMerchantOrderNo()=='')
			{
				throw new DzPayException("缺少必填参数MerchantOrderNo");
			}
			else if(!$inputObj->IsAmountSet() || $inputObj->GetAmount()=='')
			{
				throw new DzPayException("缺少必填参数Amount");
			}
			else if(!$inputObj->IsNotifyUrlSet() || $inputObj->GetNotifyUrl()=='')
			{
				throw new DzPayException("缺少必填参数NotifyUrl");
			}
			
			if(!$inputObj->IsPayChannelSet() || $inputObj->GetPayChannel()=='')
			{
				throw new DzPayException("缺少必填参数PayChannel");
			}

			switch($inputObj->GetPayChannel())
			{
				case "1102":
				case "1202":
				case "1301":
					break;
				case "1103":
				case "1205":
				case "1302":
					if(!$inputObj->IsAuthCodeSet() || $inputObj->GetAuthCode()=='')
					{
						throw new DzPayException("缺少必填参数AuthCode");            
					}
					break;
				case "1203":
					if(!$inputObj->IsWechatAppIdSet() || $inputObj->GetWechatAppId()=='')
					{
						throw new DzPayException("缺少必填参数WechatAppId");            
					}
					if(!$inputObj->IsBuyerIdSet() || $inputObj->GetBuyerId()=='')
					{
						throw new DzPayException("缺少必填参数BuyerId");            
					}
					break;
				case "1206":
					if(!$inputObj->IsWechatAppIdSet() || $inputObj->GetWechatAppId()=='')
					{
						throw new DzPayException("缺少必填参数WechatAppId");            
					}
					if(!$inputObj->IsBuyerIdSet() || $inputObj->GetBuyerId()=='')
					{
						throw new DzPayException("缺少必填参数BuyerId");            
					}
					break;
				case "1201":
					if(!$inputObj->IsSceneInfoSet() || $inputObj->GetSceneInfo()=='')
					{
						throw new DzPayException("缺少必填参数SceneInfo");            
					}
					break;
				case "1104":
					break;
				case "1107":
					break;
				default:
					throw new DzPayException("PayChannel不正确");
			}

			$inputObj->SetReqDate(date("YmdHis"));
			$inputObj->SetSign();//签名
			$reqParams = $inputObj->ToUrlParams().'&Sign='.$inputObj->GetSign();
			$url = DzPayConfig::APIHOST.'/Order/ToPay';
			$response = self::postCurl($reqParams, $url, $timeOut);
			$result = Respbase::Init($response);
			return $result;
		}
		catch(Exception $ex)
		{
			$result = new Respbase();
			$result->SetData("RespType","-1");
			$result->SetData("RespMessage",$ex->getMessage());

			return $result;
		}
	}

	public function Query($inputObj,$timeOut = 10)
	{
		try
		{
			$url = DzPayConfig::APIHOST.'/Order/Query';
			//检测必填参数
			if(!$inputObj->IsAppidSet() || $inputObj->GetAppid()=='')
			{
				throw new DzPayException("缺少必填参数AppId");
			}
			else if(!$inputObj->IsChannelOrderNoSet() && !$inputObj->IsMerchantOrderNoSet()) {
				throw new DzPayException("订单查询接口中，ChannelOrderNo、MerchantOrderNo至少填一个！");
			}
			
			$inputObj->SetAppid(DzPayConfig::APPID);
			$inputObj->SetReqDate(date("YmdHis"));
			$inputObj->SetSign();//签名
			$reqParams = $inputObj->ToUrlParams().'&Sign='.$inputObj->GetSign();
			
			$response = self::postCurl($reqParams, $url, $timeOut);
			$result = Respbase::Init($response);

			return $result;
		 }
		 catch(Exception $ex)
		 {
			$result = new Respbase();
			$result->SetData("RespType","-1");
			$result->SetData("RespMessage",$ex->getMessage());

			return $result;
		 }
	}

	public function Close($inputObj,$timeOut = 10)
	{
		try
		{
			$url = DzPayConfig::APIHOST.'/Order/Close';
				//检测必填参数
			if(!$inputObj->IsAppidSet() || $inputObj->GetAppid()=='')
			{
				throw new DzPayException("缺少必填参数AppId");
			}
			else if(!$inputObj->IsMerchantOrderNoSet())
			{
				throw new DzPayException("缺少必填参数MerchantOrderNo");
			}
			
			$inputObj->SetAppid(DzPayConfig::APPID);
			$inputObj->SetReqDate(date("YmdHis"));
			$inputObj->SetSign();//签名
			$reqParams = $inputObj->ToUrlParams().'&Sign='.$inputObj->GetSign();
			
			$response = self::postCurl($reqParams, $url, $timeOut);
			$result = Respbase::Init($response);

			return $result;
		 }
		 catch(Exception $ex)
		 {
			$result = new Respbase();
			$result->SetData("RespType","-1");
			$result->SetData("RespMessage",$ex->getMessage());

			return $result;
		 }
	}

	public function Refund($inputObj,$timeOut = 10)
	{
		try
		{
			$url = DzPayConfig::APIHOST.'/Order/Refund';
			//检测必填参数
			if(!$inputObj->IsAppidSet() || $inputObj->GetAppid()=='')
			{
				throw new DzPayException("缺少必填参数AppId");
			}
			else if(!$inputObj->IsMerchantOrderNoSet())
			{
				throw new DzPayException("缺少必填参数MerchantOrderNo");
			}
			else if(!$inputObj->IsRefundMoneySet())
			{
				throw new DzPayException("缺少必填参数RefundMoney");
			}
			 
			$inputObj->SetAppid(DzPayConfig::APPID);
			$inputObj->SetReqDate(date("YmdHis"));
			$inputObj->SetSign();//签名
			$reqParams = $inputObj->ToUrlParams().'&Sign='.$inputObj->GetSign();
			
			$response = self::postCurl($reqParams, $url, $timeOut);
			$result = Respbase::Init($response);

			return $result;
		 }
		 catch(Exception $ex)
		 {
			$result = new Respbase();
			$result->SetData("RespType","-1");
			$result->SetData("RespMessage",$ex->getMessage());

			return $result;
		 }
	}

	public static function postCurl($param, $url, $second = 30)
	{		
		$ch = curl_init();
		//设置超时
		curl_setopt($ch,CURLOPT_TIMEOUT, $second);
		curl_setopt($ch,CURLOPT_URL, $url);
		//设置header
		curl_setopt($ch, CURLOPT_HEADER, FALSE);
		//要求结果为字符串且输出到屏幕上
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		//post提交方式
		curl_setopt($ch, CURLOPT_POST, TRUE);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $param);
		//运行curl
		$data = curl_exec($ch);
		//返回结果
		if($data){
			curl_close($ch);
			return $data;
		} else { 
			$error = curl_errno($ch);
			curl_close($ch);
			throw new Exception("curl出错，错误码:$error");
		}
	}
}