/*
Navicat MySQL Data Transfer

Source Server         : localhost_3306
Source Server Version : 50553
Source Host           : localhost:3306
Source Database       : test00001

Target Server Type    : MYSQL
Target Server Version : 50553
File Encoding         : 65001

Date: 2018-07-21 18:41:17
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `wp_action`
-- ----------------------------
DROP TABLE IF EXISTS `wp_action`;
CREATE TABLE `wp_action` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` char(30) NOT NULL DEFAULT '' COMMENT '行为唯一标识',
  `title` char(80) NOT NULL DEFAULT '' COMMENT '行为说明',
  `remark` char(140) NOT NULL DEFAULT '' COMMENT '行为描述',
  `rule` text COMMENT '行为规则',
  `log` text COMMENT '日志规则',
  `type` tinyint(2) unsigned NOT NULL DEFAULT '1' COMMENT '类型',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '状态',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '修改时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='系统行为表';

-- ----------------------------
-- Records of wp_action
-- ----------------------------
INSERT INTO `wp_action` VALUES ('1', 'user_login', '用户登录', '积分+10，每天一次', 'table:member|field:score|condition:uid={$self} AND status>-1|rule:score+10|cycle:24|max:1;', '[user|get_nickname]在[time|time_format]登录了后台', '1', '1', '1387181220');
INSERT INTO `wp_action` VALUES ('2', 'add_article', '发布文章', '积分+5，每天上限5次', 'table:member|field:score|condition:uid={$self}|rule:score+5|cycle:24|max:5', '', '2', '0', '1380173180');
INSERT INTO `wp_action` VALUES ('3', 'review', '评论', '评论积分+1，无限制', 'table:member|field:score|condition:uid={$self}|rule:score+1', '', '2', '1', '1383285646');
INSERT INTO `wp_action` VALUES ('4', 'add_document', '发表文档', '积分+10，每天上限5次', 'table:member|field:score|condition:uid={$self}|rule:score+10|cycle:24|max:5', '[user|get_nickname]在[time|time_format]发表了一篇文章。\r\n表[model]，记录编号[record]。', '2', '0', '1386139726');
INSERT INTO `wp_action` VALUES ('5', 'add_document_topic', '发表讨论', '积分+5，每天上限10次', 'table:member|field:score|condition:uid={$self}|rule:score+5|cycle:24|max:10', '', '2', '0', '1383285551');
INSERT INTO `wp_action` VALUES ('6', 'update_config', '更新配置', '新增或修改或删除配置', '', '', '1', '1', '1383294988');
INSERT INTO `wp_action` VALUES ('7', 'update_model', '更新模型', '新增或修改模型', '', '', '1', '1', '1383295057');
INSERT INTO `wp_action` VALUES ('8', 'update_attribute', '更新属性', '新增或更新或删除属性', '', '', '1', '1', '1383295963');
INSERT INTO `wp_action` VALUES ('9', 'update_channel', '更新导航', '新增或修改或删除导航', '', '', '1', '1', '1383296301');
INSERT INTO `wp_action` VALUES ('10', 'update_menu', '更新菜单', '新增或修改或删除菜单', '', '', '1', '1', '1383296392');
INSERT INTO `wp_action` VALUES ('11', 'update_category', '更新分类', '新增或修改或删除分类', '', '', '1', '1', '1383296765');

-- ----------------------------
-- Table structure for `wp_action_log`
-- ----------------------------
DROP TABLE IF EXISTS `wp_action_log`;
CREATE TABLE `wp_action_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `action_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '行为id',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '执行用户id',
  `action_ip` bigint(20) NOT NULL COMMENT '执行行为者ip',
  `model` varchar(50) NOT NULL DEFAULT '' COMMENT '触发行为的表',
  `record_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '触发行为的数据id',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '日志备注',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '执行行为的时间',
  PRIMARY KEY (`id`),
  KEY `action_ip_ix` (`action_ip`) USING BTREE,
  KEY `action_id_ix` (`action_id`) USING BTREE,
  KEY `user_id_ix` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='行为日志表';

-- ----------------------------
-- Records of wp_action_log
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_addons`
-- ----------------------------
DROP TABLE IF EXISTS `wp_addons`;
CREATE TABLE `wp_addons` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(40) NOT NULL COMMENT '插件名或标识',
  `title` varchar(20) NOT NULL DEFAULT '' COMMENT '中文名',
  `description` text COMMENT '插件描述',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  `config` text COMMENT '配置',
  `author` varchar(40) DEFAULT '' COMMENT '作者',
  `version` varchar(20) DEFAULT '' COMMENT '版本号',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '安装时间',
  `has_adminlist` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否有后台列表',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='插件表';

-- ----------------------------
-- Records of wp_addons
-- ----------------------------
INSERT INTO `wp_addons` VALUES ('2', 'SiteStat', '站点统计信息', '统计站点的基础信息', '1', '{\"title\":\"\\u7cfb\\u7edf\\u4fe1\\u606f\",\"width\":\"1\",\"display\":\"1\",\"status\":\"0\"}', 'thinkphp', '0.1', '1379512015', '0');
INSERT INTO `wp_addons` VALUES ('3', 'DevTeam', '开发团队信息', '开发团队成员信息', '1', '{\"title\":\"OneThink\\u5f00\\u53d1\\u56e2\\u961f\",\"width\":\"2\",\"display\":\"1\"}', 'thinkphp', '0.1', '1379512022', '0');
INSERT INTO `wp_addons` VALUES ('4', 'SystemInfo', '系统环境信息', '用于显示一些服务器的信息', '1', '{\"title\":\"\\u7cfb\\u7edf\\u4fe1\\u606f\",\"width\":\"2\",\"display\":\"1\"}', 'thinkphp', '0.1', '1379512036', '0');
INSERT INTO `wp_addons` VALUES ('5', 'Editor', '前台编辑器', '用于增强整站长文本的输入和显示', '1', '{\"editor_type\":\"2\",\"editor_wysiwyg\":\"1\",\"editor_height\":\"300px\",\"editor_resize_type\":\"1\"}', 'thinkphp', '0.1', '1379830910', '0');
INSERT INTO `wp_addons` VALUES ('6', 'Attachment', '附件', '用于文档模型上传附件', '1', 'null', 'thinkphp', '0.1', '1379842319', '1');
INSERT INTO `wp_addons` VALUES ('9', 'SocialComment', '通用社交化评论', '集成了各种社交化评论插件，轻松集成到系统中。', '1', '{\"comment_type\":\"1\",\"comment_uid_youyan\":\"\",\"comment_short_name_duoshuo\":\"\",\"comment_data_list_duoshuo\":\"\"}', 'thinkphp', '0.1', '1380273962', '0');
INSERT INTO `wp_addons` VALUES ('15', 'EditorForAdmin', '后台编辑器', '用于增强整站长文本的输入和显示', '1', '{\"editor_type\":\"2\",\"editor_wysiwyg\":\"1\",\"editor_markdownpreview\":\"0\",\"editor_height\":\"500px\",\"editor_resize_type\":\"1\"}', 'thinkphp', '0.1', '1383126253', '0');
INSERT INTO `wp_addons` VALUES ('16', 'WdUpload', '上传', '图片、文件上传', '1', '{\"dirver\":\"local\",\"maxSize\":\"5\",\"exts\":\"jpg,gif,png,jpeg,zip,rar,tar,gz,7z,doc,docx,txt,xml\",\"accessKey\":\"ukW8SuXp861Y6j_zSutaOHN-BU2XUSrMtaW3iFgj\",\"secrectKey\":\"_TyRtLmuv2-wIf8b20A2kzzT1Oiw5NPEqh9AfBR5\",\"bucket\":\"test002\",\"domain\":\"7xlcch.com2.z0.glb.qiniucdn.com\"}', '建站宝', '0.1', '1436933268', '0');
INSERT INTO `wp_addons` VALUES ('20', 'WdForm', '后台发布表单扩展', '后台发布表单扩展', '1', 'null', '建站宝', '0.1', '1445073685', '0');

-- ----------------------------
-- Table structure for `wp_address`
-- ----------------------------
DROP TABLE IF EXISTS `wp_address`;
CREATE TABLE `wp_address` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `linkman` varchar(100) NOT NULL COMMENT '联系人',
  `tel` varchar(50) NOT NULL COMMENT '电话',
  `address` varchar(255) NOT NULL COMMENT '地址',
  `zipcode` varchar(50) NOT NULL COMMENT '邮编',
  `uid` int(11) NOT NULL COMMENT '用户id',
  `default` tinyint(4) NOT NULL DEFAULT '0' COMMENT '默认',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of wp_address
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_advert`
-- ----------------------------
DROP TABLE IF EXISTS `wp_advert`;
CREATE TABLE `wp_advert` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `title` varchar(255) NOT NULL COMMENT '广告标题',
  `stime` int(10) NOT NULL COMMENT '开始时间',
  `etime` int(10) NOT NULL COMMENT '结束时间',
  `position` varchar(255) NOT NULL COMMENT '广告位置',
  `category_id` varchar(255) NOT NULL COMMENT '栏目id',
  `content` text NOT NULL COMMENT '详情',
  `sort` int(10) unsigned NOT NULL COMMENT '排序',
  `isrand` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否随机',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=87 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_advert
-- ----------------------------
INSERT INTO `wp_advert` VALUES ('27', '下载说明', '1525594290', '2087892413', 'A3', '0', '<p>\r\n	<span style=\"color:#E53333;\"><strong>【1】 为营造绿色健康的网络环境,欢迎您对106网盘进行监督，如发现木马病毒、色情淫秽、暴恐等不良信息以及涉侵权的文件请立即举报，我们会在第一时间对违规网盘作出相应处罚，严重永久封禁的措施，如对106网盘造成不良影响，我公司会将移交给有关机关进行处理。</strong></span> \r\n</p>\r\n<p>\r\n	<span><strong><span style=\"color:#337FE5;\">【2】</span></strong></span><strong><span style=\"color:#337FE5;\">建设文明的网络环境，亦需每个人从自身做起。再此呼吁大家对于侵权（国家禁止转载）文件以及不良信息做到“三不原则”—不上传、不分享、不转存！我们欢迎广大用户对相关的违规信息进行投诉、举报。对于举报内容，我们将第一时间认真核查、及时处理。</span></strong> \r\n</p>\r\n<p>\r\n	<span><strong></strong></span> \r\n</p>', '0', '0');
INSERT INTO `wp_advert` VALUES ('32', '免费网盘首页文字广告1', '1522147881', '1834394813', '9', '', '<a href=\"http://www.106pan.com/advert/isement#search\" target=\"_blank\"><span style=\"color:#E53333;\">免费网盘漂浮文字广告位600元每月</span></a>', '99', '0');
INSERT INTO `wp_advert` VALUES ('48', '底部图片广告(老榕树)', '1520926852', '1711814400', 'L1', '', '<script src=\"http://wm.lrswl.com/page/s.php?s=277080&w=250&h=250\"></script>', '1', '1');
INSERT INTO `wp_advert` VALUES ('54', '下载页文字广告1QQ10865528', '1528164028', '1530756034', 'A2', '', ' &nbsp;&nbsp;&nbsp;&nbsp;<a href=\"http://swk97.888ka.cn\" target=\"_blank\"><span style=\"color:#E53333;\">K97卡盟 辅助资源 全网最低价</span></a>', '1', '0');
INSERT INTO `wp_advert` VALUES ('67', '购买声明', '1522373659', '2147483647', 'A4', '', '<p>\r\n	【1】 订单支付成功后，即可在网页上获得赠品或卡密，也可通过“订单查询”来获取赠品或卡密信息，同时系统也会发送到邮箱一份关于订单信息。\r\n</p>\r\n<p>\r\n	【2】 如果发现上当受骗可以在交易的第二天早8点前联系官方客服人员为您处理挽救损失，订单超过24小时或隔天概不受理，否则造成的经济损失自负！\r\n</p>', '1', '0');
INSERT INTO `wp_advert` VALUES ('79', '免费网盘--爱发资源网', '0', '2147483647', '9', '', '<a href=\"http://www.a8tg.com\" target=\"_blank\"><span style=\"color:#CC33E5;\">爱发科技论坛（资源论坛）</span></a>', '1', '0');
INSERT INTO `wp_advert` VALUES ('81', '免费网盘-素材网', '1527609600', '2124720000', '9', '', '<a href=\"http://www.zlv8.com\" target=\"_blank\"><span style=\"color:#006600;\">素材网特效最全网页模板和网站模板</span></a>', '4', '0');
INSERT INTO `wp_advert` VALUES ('84', '下载页面文字广告为', '1529802234', '1845939837', 'A2', '', '<a href=\"http://www.106pan.com/advert/isement#text\" target=\"_blank\"><span style=\"color:#00D5FF;\">文字广告位15字/300元每月</span></a>', '100', '0');
INSERT INTO `wp_advert` VALUES ('85', '永硕网盘同步克隆软件', '1529804375', '1814284800', '9', '', '<a href=\"tencent://message/?uin=617884838\"><span style=\"color:#4C33E5;\">永硕网盘同步克隆软件</span></a><span style=\"color:#4C33E5;\">&nbsp;&nbsp;</span>', '5', '0');
INSERT INTO `wp_advert` VALUES ('86', '免费网盘会员注册广告', '1529804530', '1845907200', '9', '', '<span style=\"color:#009900;\"><a href=\"http://member.106pan.com/\" target=\"_blank\"><span style=\"color:#E53333;\">注册会员获得推广及销售分成/点击进入</span></a></span>', '98', '0');

-- ----------------------------
-- Table structure for `wp_area`
-- ----------------------------
DROP TABLE IF EXISTS `wp_area`;
CREATE TABLE `wp_area` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL DEFAULT '',
  `reid` int(10) unsigned NOT NULL DEFAULT '0',
  `disorder` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `reid` (`reid`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3242 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_area
-- ----------------------------
INSERT INTO `wp_area` VALUES ('1', '北京市', '0', '1');
INSERT INTO `wp_area` VALUES ('3', '东城区', '1', '1');
INSERT INTO `wp_area` VALUES ('4', '西城区', '1', '2');
INSERT INTO `wp_area` VALUES ('5', '崇文区', '1', '3');
INSERT INTO `wp_area` VALUES ('6', '宣武区', '1', '4');
INSERT INTO `wp_area` VALUES ('7', '朝阳区', '1', '5');
INSERT INTO `wp_area` VALUES ('8', '丰台区', '1', '6');
INSERT INTO `wp_area` VALUES ('9', '石景山区', '1', '7');
INSERT INTO `wp_area` VALUES ('10', '海淀区', '1', '8');
INSERT INTO `wp_area` VALUES ('11', '门头沟区', '1', '9');
INSERT INTO `wp_area` VALUES ('12', '房山区', '1', '10');
INSERT INTO `wp_area` VALUES ('13', '通州区', '1', '11');
INSERT INTO `wp_area` VALUES ('14', '顺义区', '1', '12');
INSERT INTO `wp_area` VALUES ('15', '昌平区', '1', '13');
INSERT INTO `wp_area` VALUES ('16', '大兴区', '1', '14');
INSERT INTO `wp_area` VALUES ('17', '怀柔区', '1', '15');
INSERT INTO `wp_area` VALUES ('18', '平谷区', '1', '16');
INSERT INTO `wp_area` VALUES ('19', '密云县', '1', '17');
INSERT INTO `wp_area` VALUES ('20', '延庆县', '1', '18');
INSERT INTO `wp_area` VALUES ('21', '天津市', '0', '2');
INSERT INTO `wp_area` VALUES ('23', '和平区', '21', '19');
INSERT INTO `wp_area` VALUES ('24', '河东区', '21', '20');
INSERT INTO `wp_area` VALUES ('25', '河西区', '21', '21');
INSERT INTO `wp_area` VALUES ('26', '南开区', '21', '22');
INSERT INTO `wp_area` VALUES ('27', '河北区', '21', '23');
INSERT INTO `wp_area` VALUES ('28', '红桥区', '21', '24');
INSERT INTO `wp_area` VALUES ('29', '塘沽区', '21', '25');
INSERT INTO `wp_area` VALUES ('30', '汉沽区', '21', '26');
INSERT INTO `wp_area` VALUES ('31', '大港区', '21', '27');
INSERT INTO `wp_area` VALUES ('32', '东丽区', '21', '28');
INSERT INTO `wp_area` VALUES ('33', '西青区', '21', '29');
INSERT INTO `wp_area` VALUES ('34', '津南区', '21', '30');
INSERT INTO `wp_area` VALUES ('35', '北辰区', '21', '31');
INSERT INTO `wp_area` VALUES ('36', '武清区', '21', '32');
INSERT INTO `wp_area` VALUES ('37', '宝坻区', '21', '33');
INSERT INTO `wp_area` VALUES ('38', '宁河县', '21', '34');
INSERT INTO `wp_area` VALUES ('39', '静海县', '21', '35');
INSERT INTO `wp_area` VALUES ('40', '蓟县', '21', '36');
INSERT INTO `wp_area` VALUES ('41', '河北省', '0', '3');
INSERT INTO `wp_area` VALUES ('42', '石家庄市', '41', '3');
INSERT INTO `wp_area` VALUES ('43', '长安区', '42', '37');
INSERT INTO `wp_area` VALUES ('44', '桥东区', '42', '38');
INSERT INTO `wp_area` VALUES ('45', '桥西区', '42', '39');
INSERT INTO `wp_area` VALUES ('46', '新华区', '42', '40');
INSERT INTO `wp_area` VALUES ('47', '井陉矿区', '42', '41');
INSERT INTO `wp_area` VALUES ('48', '裕华区', '42', '42');
INSERT INTO `wp_area` VALUES ('49', '井陉县', '42', '43');
INSERT INTO `wp_area` VALUES ('50', '正定县', '42', '44');
INSERT INTO `wp_area` VALUES ('51', '栾城县', '42', '45');
INSERT INTO `wp_area` VALUES ('52', '行唐县', '42', '46');
INSERT INTO `wp_area` VALUES ('53', '灵寿县', '42', '47');
INSERT INTO `wp_area` VALUES ('54', '高邑县', '42', '48');
INSERT INTO `wp_area` VALUES ('55', '深泽县', '42', '49');
INSERT INTO `wp_area` VALUES ('56', '赞皇县', '42', '50');
INSERT INTO `wp_area` VALUES ('57', '无极县', '42', '51');
INSERT INTO `wp_area` VALUES ('58', '平山县', '42', '52');
INSERT INTO `wp_area` VALUES ('59', '元氏县', '42', '53');
INSERT INTO `wp_area` VALUES ('60', '赵县', '42', '54');
INSERT INTO `wp_area` VALUES ('61', '辛集市', '42', '55');
INSERT INTO `wp_area` VALUES ('62', '藁城市', '42', '56');
INSERT INTO `wp_area` VALUES ('63', '晋州市', '42', '57');
INSERT INTO `wp_area` VALUES ('64', '新乐市', '42', '58');
INSERT INTO `wp_area` VALUES ('65', '鹿泉市', '42', '59');
INSERT INTO `wp_area` VALUES ('66', '唐山市', '41', '4');
INSERT INTO `wp_area` VALUES ('67', '路南区', '66', '60');
INSERT INTO `wp_area` VALUES ('68', '路北区', '66', '61');
INSERT INTO `wp_area` VALUES ('69', '古冶区', '66', '62');
INSERT INTO `wp_area` VALUES ('70', '开平区', '66', '63');
INSERT INTO `wp_area` VALUES ('71', '丰南区', '66', '64');
INSERT INTO `wp_area` VALUES ('72', '丰润区', '66', '65');
INSERT INTO `wp_area` VALUES ('73', '滦县', '66', '66');
INSERT INTO `wp_area` VALUES ('74', '滦南县', '66', '67');
INSERT INTO `wp_area` VALUES ('75', '乐亭县', '66', '68');
INSERT INTO `wp_area` VALUES ('76', '迁西县', '66', '69');
INSERT INTO `wp_area` VALUES ('77', '玉田县', '66', '70');
INSERT INTO `wp_area` VALUES ('78', '唐海县', '66', '71');
INSERT INTO `wp_area` VALUES ('79', '遵化市', '66', '72');
INSERT INTO `wp_area` VALUES ('80', '迁安市', '66', '73');
INSERT INTO `wp_area` VALUES ('81', '秦皇岛市', '41', '5');
INSERT INTO `wp_area` VALUES ('82', '海港区', '81', '74');
INSERT INTO `wp_area` VALUES ('83', '山海关区', '81', '75');
INSERT INTO `wp_area` VALUES ('84', '北戴河区', '81', '76');
INSERT INTO `wp_area` VALUES ('85', '青龙满族自治县', '81', '77');
INSERT INTO `wp_area` VALUES ('86', '昌黎县', '81', '78');
INSERT INTO `wp_area` VALUES ('87', '抚宁县', '81', '79');
INSERT INTO `wp_area` VALUES ('88', '卢龙县', '81', '80');
INSERT INTO `wp_area` VALUES ('89', '邯郸市', '41', '6');
INSERT INTO `wp_area` VALUES ('90', '邯山区', '89', '81');
INSERT INTO `wp_area` VALUES ('91', '丛台区', '89', '82');
INSERT INTO `wp_area` VALUES ('92', '复兴区', '89', '83');
INSERT INTO `wp_area` VALUES ('93', '峰峰矿区', '89', '84');
INSERT INTO `wp_area` VALUES ('94', '邯郸县', '89', '85');
INSERT INTO `wp_area` VALUES ('95', '临漳县', '89', '86');
INSERT INTO `wp_area` VALUES ('96', '成安县', '89', '87');
INSERT INTO `wp_area` VALUES ('97', '大名县', '89', '88');
INSERT INTO `wp_area` VALUES ('98', '涉县', '89', '89');
INSERT INTO `wp_area` VALUES ('99', '磁县', '89', '90');
INSERT INTO `wp_area` VALUES ('100', '肥乡县', '89', '91');
INSERT INTO `wp_area` VALUES ('101', '永年县', '89', '92');
INSERT INTO `wp_area` VALUES ('102', '邱县', '89', '93');
INSERT INTO `wp_area` VALUES ('103', '鸡泽县', '89', '94');
INSERT INTO `wp_area` VALUES ('104', '广平县', '89', '95');
INSERT INTO `wp_area` VALUES ('105', '馆陶县', '89', '96');
INSERT INTO `wp_area` VALUES ('106', '魏县', '89', '97');
INSERT INTO `wp_area` VALUES ('107', '曲周县', '89', '98');
INSERT INTO `wp_area` VALUES ('108', '武安市', '89', '99');
INSERT INTO `wp_area` VALUES ('109', '邢台市', '41', '7');
INSERT INTO `wp_area` VALUES ('110', '桥东区', '109', '100');
INSERT INTO `wp_area` VALUES ('111', '桥西区', '109', '101');
INSERT INTO `wp_area` VALUES ('112', '邢台县', '109', '102');
INSERT INTO `wp_area` VALUES ('113', '临城县', '109', '103');
INSERT INTO `wp_area` VALUES ('114', '内丘县', '109', '104');
INSERT INTO `wp_area` VALUES ('115', '柏乡县', '109', '105');
INSERT INTO `wp_area` VALUES ('116', '隆尧县', '109', '106');
INSERT INTO `wp_area` VALUES ('117', '任县', '109', '107');
INSERT INTO `wp_area` VALUES ('118', '南和县', '109', '108');
INSERT INTO `wp_area` VALUES ('119', '宁晋县', '109', '109');
INSERT INTO `wp_area` VALUES ('120', '巨鹿县', '109', '110');
INSERT INTO `wp_area` VALUES ('121', '新河县', '109', '111');
INSERT INTO `wp_area` VALUES ('122', '广宗县', '109', '112');
INSERT INTO `wp_area` VALUES ('123', '平乡县', '109', '113');
INSERT INTO `wp_area` VALUES ('124', '威县', '109', '114');
INSERT INTO `wp_area` VALUES ('125', '清河县', '109', '115');
INSERT INTO `wp_area` VALUES ('126', '临西县', '109', '116');
INSERT INTO `wp_area` VALUES ('127', '南宫市', '109', '117');
INSERT INTO `wp_area` VALUES ('128', '沙河市', '109', '118');
INSERT INTO `wp_area` VALUES ('129', '保定市', '41', '8');
INSERT INTO `wp_area` VALUES ('130', '新市区', '129', '119');
INSERT INTO `wp_area` VALUES ('131', '北市区', '129', '120');
INSERT INTO `wp_area` VALUES ('132', '南市区', '129', '121');
INSERT INTO `wp_area` VALUES ('133', '满城县', '129', '122');
INSERT INTO `wp_area` VALUES ('134', '清苑县', '129', '123');
INSERT INTO `wp_area` VALUES ('135', '涞水县', '129', '124');
INSERT INTO `wp_area` VALUES ('136', '阜平县', '129', '125');
INSERT INTO `wp_area` VALUES ('137', '徐水县', '129', '126');
INSERT INTO `wp_area` VALUES ('138', '定兴县', '129', '127');
INSERT INTO `wp_area` VALUES ('139', '唐县', '129', '128');
INSERT INTO `wp_area` VALUES ('140', '高阳县', '129', '129');
INSERT INTO `wp_area` VALUES ('141', '容城县', '129', '130');
INSERT INTO `wp_area` VALUES ('142', '涞源县', '129', '131');
INSERT INTO `wp_area` VALUES ('143', '望都县', '129', '132');
INSERT INTO `wp_area` VALUES ('144', '安新县', '129', '133');
INSERT INTO `wp_area` VALUES ('145', '易县', '129', '134');
INSERT INTO `wp_area` VALUES ('146', '曲阳县', '129', '135');
INSERT INTO `wp_area` VALUES ('147', '蠡县', '129', '136');
INSERT INTO `wp_area` VALUES ('148', '顺平县', '129', '137');
INSERT INTO `wp_area` VALUES ('149', '博野县', '129', '138');
INSERT INTO `wp_area` VALUES ('150', '雄县', '129', '139');
INSERT INTO `wp_area` VALUES ('151', '涿州市', '129', '140');
INSERT INTO `wp_area` VALUES ('152', '定州市', '129', '141');
INSERT INTO `wp_area` VALUES ('153', '安国市', '129', '142');
INSERT INTO `wp_area` VALUES ('154', '高碑店市', '129', '143');
INSERT INTO `wp_area` VALUES ('155', '张家口市', '41', '9');
INSERT INTO `wp_area` VALUES ('156', '桥东区', '155', '144');
INSERT INTO `wp_area` VALUES ('157', '桥西区', '155', '145');
INSERT INTO `wp_area` VALUES ('158', '宣化区', '155', '146');
INSERT INTO `wp_area` VALUES ('159', '下花园区', '155', '147');
INSERT INTO `wp_area` VALUES ('160', '宣化县', '155', '148');
INSERT INTO `wp_area` VALUES ('161', '张北县', '155', '149');
INSERT INTO `wp_area` VALUES ('162', '康保县', '155', '150');
INSERT INTO `wp_area` VALUES ('163', '沽源县', '155', '151');
INSERT INTO `wp_area` VALUES ('164', '尚义县', '155', '152');
INSERT INTO `wp_area` VALUES ('165', '蔚县', '155', '153');
INSERT INTO `wp_area` VALUES ('166', '阳原县', '155', '154');
INSERT INTO `wp_area` VALUES ('167', '怀安县', '155', '155');
INSERT INTO `wp_area` VALUES ('168', '万全县', '155', '156');
INSERT INTO `wp_area` VALUES ('169', '怀来县', '155', '157');
INSERT INTO `wp_area` VALUES ('170', '涿鹿县', '155', '158');
INSERT INTO `wp_area` VALUES ('171', '赤城县', '155', '159');
INSERT INTO `wp_area` VALUES ('172', '崇礼县', '155', '160');
INSERT INTO `wp_area` VALUES ('173', '承德市', '41', '10');
INSERT INTO `wp_area` VALUES ('174', '双桥区', '173', '161');
INSERT INTO `wp_area` VALUES ('175', '双滦区', '173', '162');
INSERT INTO `wp_area` VALUES ('176', '鹰手营子矿区', '173', '163');
INSERT INTO `wp_area` VALUES ('177', '承德县', '173', '164');
INSERT INTO `wp_area` VALUES ('178', '兴隆县', '173', '165');
INSERT INTO `wp_area` VALUES ('179', '平泉县', '173', '166');
INSERT INTO `wp_area` VALUES ('180', '滦平县', '173', '167');
INSERT INTO `wp_area` VALUES ('181', '隆化县', '173', '168');
INSERT INTO `wp_area` VALUES ('182', '丰宁满族自治县', '173', '169');
INSERT INTO `wp_area` VALUES ('183', '宽城满族自治县', '173', '170');
INSERT INTO `wp_area` VALUES ('184', '围场满族蒙古族自治县', '173', '171');
INSERT INTO `wp_area` VALUES ('185', '沧州市', '41', '11');
INSERT INTO `wp_area` VALUES ('186', '新华区', '185', '172');
INSERT INTO `wp_area` VALUES ('187', '运河区', '185', '173');
INSERT INTO `wp_area` VALUES ('188', '沧县', '185', '174');
INSERT INTO `wp_area` VALUES ('189', '青县', '185', '175');
INSERT INTO `wp_area` VALUES ('190', '东光县', '185', '176');
INSERT INTO `wp_area` VALUES ('191', '海兴县', '185', '177');
INSERT INTO `wp_area` VALUES ('192', '盐山县', '185', '178');
INSERT INTO `wp_area` VALUES ('193', '肃宁县', '185', '179');
INSERT INTO `wp_area` VALUES ('194', '南皮县', '185', '180');
INSERT INTO `wp_area` VALUES ('195', '吴桥县', '185', '181');
INSERT INTO `wp_area` VALUES ('196', '献县', '185', '182');
INSERT INTO `wp_area` VALUES ('197', '孟村回族自治县', '185', '183');
INSERT INTO `wp_area` VALUES ('198', '泊头市', '185', '184');
INSERT INTO `wp_area` VALUES ('199', '任丘市', '185', '185');
INSERT INTO `wp_area` VALUES ('200', '黄骅市', '185', '186');
INSERT INTO `wp_area` VALUES ('201', '河间市', '185', '187');
INSERT INTO `wp_area` VALUES ('202', '廊坊市', '41', '12');
INSERT INTO `wp_area` VALUES ('203', '安次区', '202', '188');
INSERT INTO `wp_area` VALUES ('204', '广阳区', '202', '189');
INSERT INTO `wp_area` VALUES ('205', '固安县', '202', '190');
INSERT INTO `wp_area` VALUES ('206', '永清县', '202', '191');
INSERT INTO `wp_area` VALUES ('207', '香河县', '202', '192');
INSERT INTO `wp_area` VALUES ('208', '大城县', '202', '193');
INSERT INTO `wp_area` VALUES ('209', '文安县', '202', '194');
INSERT INTO `wp_area` VALUES ('210', '大厂回族自治县', '202', '195');
INSERT INTO `wp_area` VALUES ('211', '霸州市', '202', '196');
INSERT INTO `wp_area` VALUES ('212', '三河市', '202', '197');
INSERT INTO `wp_area` VALUES ('213', '衡水市', '41', '13');
INSERT INTO `wp_area` VALUES ('214', '桃城区', '213', '198');
INSERT INTO `wp_area` VALUES ('215', '枣强县', '213', '199');
INSERT INTO `wp_area` VALUES ('216', '武邑县', '213', '200');
INSERT INTO `wp_area` VALUES ('217', '武强县', '213', '201');
INSERT INTO `wp_area` VALUES ('218', '饶阳县', '213', '202');
INSERT INTO `wp_area` VALUES ('219', '安平县', '213', '203');
INSERT INTO `wp_area` VALUES ('220', '故城县', '213', '204');
INSERT INTO `wp_area` VALUES ('221', '景县', '213', '205');
INSERT INTO `wp_area` VALUES ('222', '阜城县', '213', '206');
INSERT INTO `wp_area` VALUES ('223', '冀州市', '213', '207');
INSERT INTO `wp_area` VALUES ('224', '深州市', '213', '208');
INSERT INTO `wp_area` VALUES ('225', '山西省', '0', '4');
INSERT INTO `wp_area` VALUES ('226', '太原市', '225', '14');
INSERT INTO `wp_area` VALUES ('227', '小店区', '226', '209');
INSERT INTO `wp_area` VALUES ('228', '迎泽区', '226', '210');
INSERT INTO `wp_area` VALUES ('229', '杏花岭区', '226', '211');
INSERT INTO `wp_area` VALUES ('230', '尖草坪区', '226', '212');
INSERT INTO `wp_area` VALUES ('231', '万柏林区', '226', '213');
INSERT INTO `wp_area` VALUES ('232', '晋源区', '226', '214');
INSERT INTO `wp_area` VALUES ('233', '清徐县', '226', '215');
INSERT INTO `wp_area` VALUES ('234', '阳曲县', '226', '216');
INSERT INTO `wp_area` VALUES ('235', '娄烦县', '226', '217');
INSERT INTO `wp_area` VALUES ('236', '古交市', '226', '218');
INSERT INTO `wp_area` VALUES ('237', '大同市', '225', '15');
INSERT INTO `wp_area` VALUES ('238', '城区', '237', '219');
INSERT INTO `wp_area` VALUES ('239', '矿区', '237', '220');
INSERT INTO `wp_area` VALUES ('240', '南郊区', '237', '221');
INSERT INTO `wp_area` VALUES ('241', '新荣区', '237', '222');
INSERT INTO `wp_area` VALUES ('242', '阳高县', '237', '223');
INSERT INTO `wp_area` VALUES ('243', '天镇县', '237', '224');
INSERT INTO `wp_area` VALUES ('244', '广灵县', '237', '225');
INSERT INTO `wp_area` VALUES ('245', '灵丘县', '237', '226');
INSERT INTO `wp_area` VALUES ('246', '浑源县', '237', '227');
INSERT INTO `wp_area` VALUES ('247', '左云县', '237', '228');
INSERT INTO `wp_area` VALUES ('248', '大同县', '237', '229');
INSERT INTO `wp_area` VALUES ('249', '阳泉市', '225', '16');
INSERT INTO `wp_area` VALUES ('250', '城区', '249', '230');
INSERT INTO `wp_area` VALUES ('251', '矿区', '249', '231');
INSERT INTO `wp_area` VALUES ('252', '郊区', '249', '232');
INSERT INTO `wp_area` VALUES ('253', '平定县', '249', '233');
INSERT INTO `wp_area` VALUES ('254', '盂县', '249', '234');
INSERT INTO `wp_area` VALUES ('255', '长治市', '225', '17');
INSERT INTO `wp_area` VALUES ('256', '城区', '255', '235');
INSERT INTO `wp_area` VALUES ('257', '郊区', '255', '236');
INSERT INTO `wp_area` VALUES ('258', '长治县', '255', '237');
INSERT INTO `wp_area` VALUES ('259', '襄垣县', '255', '238');
INSERT INTO `wp_area` VALUES ('260', '屯留县', '255', '239');
INSERT INTO `wp_area` VALUES ('261', '平顺县', '255', '240');
INSERT INTO `wp_area` VALUES ('262', '黎城县', '255', '241');
INSERT INTO `wp_area` VALUES ('263', '壶关县', '255', '242');
INSERT INTO `wp_area` VALUES ('264', '长子县', '255', '243');
INSERT INTO `wp_area` VALUES ('265', '武乡县', '255', '244');
INSERT INTO `wp_area` VALUES ('266', '沁县', '255', '245');
INSERT INTO `wp_area` VALUES ('267', '沁源县', '255', '246');
INSERT INTO `wp_area` VALUES ('268', '潞城市', '255', '247');
INSERT INTO `wp_area` VALUES ('269', '晋城市', '225', '18');
INSERT INTO `wp_area` VALUES ('270', '城区', '269', '248');
INSERT INTO `wp_area` VALUES ('271', '沁水县', '269', '249');
INSERT INTO `wp_area` VALUES ('272', '阳城县', '269', '250');
INSERT INTO `wp_area` VALUES ('273', '陵川县', '269', '251');
INSERT INTO `wp_area` VALUES ('274', '泽州县', '269', '252');
INSERT INTO `wp_area` VALUES ('275', '高平市', '269', '253');
INSERT INTO `wp_area` VALUES ('276', '朔州市', '225', '19');
INSERT INTO `wp_area` VALUES ('277', '朔城区', '276', '254');
INSERT INTO `wp_area` VALUES ('278', '平鲁区', '276', '255');
INSERT INTO `wp_area` VALUES ('279', '山阴县', '276', '256');
INSERT INTO `wp_area` VALUES ('280', '应县', '276', '257');
INSERT INTO `wp_area` VALUES ('281', '右玉县', '276', '258');
INSERT INTO `wp_area` VALUES ('282', '怀仁县', '276', '259');
INSERT INTO `wp_area` VALUES ('283', '晋中市', '225', '20');
INSERT INTO `wp_area` VALUES ('284', '榆次区', '283', '260');
INSERT INTO `wp_area` VALUES ('285', '榆社县', '283', '261');
INSERT INTO `wp_area` VALUES ('286', '左权县', '283', '262');
INSERT INTO `wp_area` VALUES ('287', '和顺县', '283', '263');
INSERT INTO `wp_area` VALUES ('288', '昔阳县', '283', '264');
INSERT INTO `wp_area` VALUES ('289', '寿阳县', '283', '265');
INSERT INTO `wp_area` VALUES ('290', '太谷县', '283', '266');
INSERT INTO `wp_area` VALUES ('291', '祁县', '283', '267');
INSERT INTO `wp_area` VALUES ('292', '平遥县', '283', '268');
INSERT INTO `wp_area` VALUES ('293', '灵石县', '283', '269');
INSERT INTO `wp_area` VALUES ('294', '介休市', '283', '270');
INSERT INTO `wp_area` VALUES ('295', '运城市', '225', '21');
INSERT INTO `wp_area` VALUES ('296', '盐湖区', '295', '271');
INSERT INTO `wp_area` VALUES ('297', '临猗县', '295', '272');
INSERT INTO `wp_area` VALUES ('298', '万荣县', '295', '273');
INSERT INTO `wp_area` VALUES ('299', '闻喜县', '295', '274');
INSERT INTO `wp_area` VALUES ('300', '稷山县', '295', '275');
INSERT INTO `wp_area` VALUES ('301', '新绛县', '295', '276');
INSERT INTO `wp_area` VALUES ('302', '绛县', '295', '277');
INSERT INTO `wp_area` VALUES ('303', '垣曲县', '295', '278');
INSERT INTO `wp_area` VALUES ('304', '夏县', '295', '279');
INSERT INTO `wp_area` VALUES ('305', '平陆县', '295', '280');
INSERT INTO `wp_area` VALUES ('306', '芮城县', '295', '281');
INSERT INTO `wp_area` VALUES ('307', '永济市', '295', '282');
INSERT INTO `wp_area` VALUES ('308', '河津市', '295', '283');
INSERT INTO `wp_area` VALUES ('309', '忻州市', '225', '22');
INSERT INTO `wp_area` VALUES ('310', '忻府区', '309', '284');
INSERT INTO `wp_area` VALUES ('311', '定襄县', '309', '285');
INSERT INTO `wp_area` VALUES ('312', '五台县', '309', '286');
INSERT INTO `wp_area` VALUES ('313', '代县', '309', '287');
INSERT INTO `wp_area` VALUES ('314', '繁峙县', '309', '288');
INSERT INTO `wp_area` VALUES ('315', '宁武县', '309', '289');
INSERT INTO `wp_area` VALUES ('316', '静乐县', '309', '290');
INSERT INTO `wp_area` VALUES ('317', '神池县', '309', '291');
INSERT INTO `wp_area` VALUES ('318', '五寨县', '309', '292');
INSERT INTO `wp_area` VALUES ('319', '岢岚县', '309', '293');
INSERT INTO `wp_area` VALUES ('320', '河曲县', '309', '294');
INSERT INTO `wp_area` VALUES ('321', '保德县', '309', '295');
INSERT INTO `wp_area` VALUES ('322', '偏关县', '309', '296');
INSERT INTO `wp_area` VALUES ('323', '原平市', '309', '297');
INSERT INTO `wp_area` VALUES ('324', '临汾市', '225', '23');
INSERT INTO `wp_area` VALUES ('325', '尧都区', '324', '298');
INSERT INTO `wp_area` VALUES ('326', '曲沃县', '324', '299');
INSERT INTO `wp_area` VALUES ('327', '翼城县', '324', '300');
INSERT INTO `wp_area` VALUES ('328', '襄汾县', '324', '301');
INSERT INTO `wp_area` VALUES ('329', '洪洞县', '324', '302');
INSERT INTO `wp_area` VALUES ('330', '古县', '324', '303');
INSERT INTO `wp_area` VALUES ('331', '安泽县', '324', '304');
INSERT INTO `wp_area` VALUES ('332', '浮山县', '324', '305');
INSERT INTO `wp_area` VALUES ('333', '吉县', '324', '306');
INSERT INTO `wp_area` VALUES ('334', '乡宁县', '324', '307');
INSERT INTO `wp_area` VALUES ('335', '大宁县', '324', '308');
INSERT INTO `wp_area` VALUES ('336', '隰县', '324', '309');
INSERT INTO `wp_area` VALUES ('337', '永和县', '324', '310');
INSERT INTO `wp_area` VALUES ('338', '蒲县', '324', '311');
INSERT INTO `wp_area` VALUES ('339', '汾西县', '324', '312');
INSERT INTO `wp_area` VALUES ('340', '侯马市', '324', '313');
INSERT INTO `wp_area` VALUES ('341', '霍州市', '324', '314');
INSERT INTO `wp_area` VALUES ('342', '吕梁市', '225', '24');
INSERT INTO `wp_area` VALUES ('343', '离石区', '342', '315');
INSERT INTO `wp_area` VALUES ('344', '文水县', '342', '316');
INSERT INTO `wp_area` VALUES ('345', '交城县', '342', '317');
INSERT INTO `wp_area` VALUES ('346', '兴县', '342', '318');
INSERT INTO `wp_area` VALUES ('347', '临县', '342', '319');
INSERT INTO `wp_area` VALUES ('348', '柳林县', '342', '320');
INSERT INTO `wp_area` VALUES ('349', '石楼县', '342', '321');
INSERT INTO `wp_area` VALUES ('350', '岚县', '342', '322');
INSERT INTO `wp_area` VALUES ('351', '方山县', '342', '323');
INSERT INTO `wp_area` VALUES ('352', '中阳县', '342', '324');
INSERT INTO `wp_area` VALUES ('353', '交口县', '342', '325');
INSERT INTO `wp_area` VALUES ('354', '孝义市', '342', '326');
INSERT INTO `wp_area` VALUES ('355', '汾阳市', '342', '327');
INSERT INTO `wp_area` VALUES ('356', '内蒙古自治区', '0', '5');
INSERT INTO `wp_area` VALUES ('357', '呼和浩特市', '356', '25');
INSERT INTO `wp_area` VALUES ('358', '新城区', '357', '328');
INSERT INTO `wp_area` VALUES ('359', '回民区', '357', '329');
INSERT INTO `wp_area` VALUES ('360', '玉泉区', '357', '330');
INSERT INTO `wp_area` VALUES ('361', '赛罕区', '357', '331');
INSERT INTO `wp_area` VALUES ('362', '土默特左旗', '357', '332');
INSERT INTO `wp_area` VALUES ('363', '托克托县', '357', '333');
INSERT INTO `wp_area` VALUES ('364', '和林格尔县', '357', '334');
INSERT INTO `wp_area` VALUES ('365', '清水河县', '357', '335');
INSERT INTO `wp_area` VALUES ('366', '武川县', '357', '336');
INSERT INTO `wp_area` VALUES ('367', '包头市', '356', '26');
INSERT INTO `wp_area` VALUES ('368', '东河区', '367', '337');
INSERT INTO `wp_area` VALUES ('369', '昆都仑区', '367', '338');
INSERT INTO `wp_area` VALUES ('370', '青山区', '367', '339');
INSERT INTO `wp_area` VALUES ('371', '石拐区', '367', '340');
INSERT INTO `wp_area` VALUES ('372', '白云矿区', '367', '341');
INSERT INTO `wp_area` VALUES ('373', '九原区', '367', '342');
INSERT INTO `wp_area` VALUES ('374', '土默特右旗', '367', '343');
INSERT INTO `wp_area` VALUES ('375', '固阳县', '367', '344');
INSERT INTO `wp_area` VALUES ('376', '达尔罕茂明安联合旗', '367', '345');
INSERT INTO `wp_area` VALUES ('377', '乌海市', '356', '27');
INSERT INTO `wp_area` VALUES ('378', '海勃湾区', '377', '346');
INSERT INTO `wp_area` VALUES ('379', '海南区', '377', '347');
INSERT INTO `wp_area` VALUES ('380', '乌达区', '377', '348');
INSERT INTO `wp_area` VALUES ('381', '赤峰市', '356', '28');
INSERT INTO `wp_area` VALUES ('382', '红山区', '381', '349');
INSERT INTO `wp_area` VALUES ('383', '元宝山区', '381', '350');
INSERT INTO `wp_area` VALUES ('384', '松山区', '381', '351');
INSERT INTO `wp_area` VALUES ('385', '阿鲁科尔沁旗', '381', '352');
INSERT INTO `wp_area` VALUES ('386', '巴林左旗', '381', '353');
INSERT INTO `wp_area` VALUES ('387', '巴林右旗', '381', '354');
INSERT INTO `wp_area` VALUES ('388', '林西县', '381', '355');
INSERT INTO `wp_area` VALUES ('389', '克什克腾旗', '381', '356');
INSERT INTO `wp_area` VALUES ('390', '翁牛特旗', '381', '357');
INSERT INTO `wp_area` VALUES ('391', '喀喇沁旗', '381', '358');
INSERT INTO `wp_area` VALUES ('392', '宁城县', '381', '359');
INSERT INTO `wp_area` VALUES ('393', '敖汉旗', '381', '360');
INSERT INTO `wp_area` VALUES ('394', '通辽市', '356', '29');
INSERT INTO `wp_area` VALUES ('395', '科尔沁区', '394', '361');
INSERT INTO `wp_area` VALUES ('396', '科尔沁左翼中旗', '394', '362');
INSERT INTO `wp_area` VALUES ('397', '科尔沁左翼后旗', '394', '363');
INSERT INTO `wp_area` VALUES ('398', '开鲁县', '394', '364');
INSERT INTO `wp_area` VALUES ('399', '库伦旗', '394', '365');
INSERT INTO `wp_area` VALUES ('400', '奈曼旗', '394', '366');
INSERT INTO `wp_area` VALUES ('401', '扎鲁特旗', '394', '367');
INSERT INTO `wp_area` VALUES ('402', '霍林郭勒市', '394', '368');
INSERT INTO `wp_area` VALUES ('403', '鄂尔多斯市', '356', '30');
INSERT INTO `wp_area` VALUES ('404', '东胜区', '403', '369');
INSERT INTO `wp_area` VALUES ('405', '达拉特旗', '403', '370');
INSERT INTO `wp_area` VALUES ('406', '准格尔旗', '403', '371');
INSERT INTO `wp_area` VALUES ('407', '鄂托克前旗', '403', '372');
INSERT INTO `wp_area` VALUES ('408', '鄂托克旗', '403', '373');
INSERT INTO `wp_area` VALUES ('409', '杭锦旗', '403', '374');
INSERT INTO `wp_area` VALUES ('410', '乌审旗', '403', '375');
INSERT INTO `wp_area` VALUES ('411', '伊金霍洛旗', '403', '376');
INSERT INTO `wp_area` VALUES ('412', '呼伦贝尔市', '356', '31');
INSERT INTO `wp_area` VALUES ('413', '海拉尔区', '412', '377');
INSERT INTO `wp_area` VALUES ('414', '阿荣旗', '412', '378');
INSERT INTO `wp_area` VALUES ('415', '莫力达瓦达斡尔族自治旗', '412', '379');
INSERT INTO `wp_area` VALUES ('416', '鄂伦春自治旗', '412', '380');
INSERT INTO `wp_area` VALUES ('417', '鄂温克族自治旗', '412', '381');
INSERT INTO `wp_area` VALUES ('418', '陈巴尔虎旗', '412', '382');
INSERT INTO `wp_area` VALUES ('419', '新巴尔虎左旗', '412', '383');
INSERT INTO `wp_area` VALUES ('420', '新巴尔虎右旗', '412', '384');
INSERT INTO `wp_area` VALUES ('421', '满洲里市', '412', '385');
INSERT INTO `wp_area` VALUES ('422', '牙克石市', '412', '386');
INSERT INTO `wp_area` VALUES ('423', '扎兰屯市', '412', '387');
INSERT INTO `wp_area` VALUES ('424', '额尔古纳市', '412', '388');
INSERT INTO `wp_area` VALUES ('425', '根河市', '412', '389');
INSERT INTO `wp_area` VALUES ('426', '巴彦淖尔市', '356', '32');
INSERT INTO `wp_area` VALUES ('427', '临河区', '426', '390');
INSERT INTO `wp_area` VALUES ('428', '五原县', '426', '391');
INSERT INTO `wp_area` VALUES ('429', '磴口县', '426', '392');
INSERT INTO `wp_area` VALUES ('430', '乌拉特前旗', '426', '393');
INSERT INTO `wp_area` VALUES ('431', '乌拉特中旗', '426', '394');
INSERT INTO `wp_area` VALUES ('432', '乌拉特后旗', '426', '395');
INSERT INTO `wp_area` VALUES ('433', '杭锦后旗', '426', '396');
INSERT INTO `wp_area` VALUES ('434', '乌兰察布市', '356', '33');
INSERT INTO `wp_area` VALUES ('435', '集宁区', '434', '397');
INSERT INTO `wp_area` VALUES ('436', '卓资县', '434', '398');
INSERT INTO `wp_area` VALUES ('437', '化德县', '434', '399');
INSERT INTO `wp_area` VALUES ('438', '商都县', '434', '400');
INSERT INTO `wp_area` VALUES ('439', '兴和县', '434', '401');
INSERT INTO `wp_area` VALUES ('440', '凉城县', '434', '402');
INSERT INTO `wp_area` VALUES ('441', '察哈尔右翼前旗', '434', '403');
INSERT INTO `wp_area` VALUES ('442', '察哈尔右翼中旗', '434', '404');
INSERT INTO `wp_area` VALUES ('443', '察哈尔右翼后旗', '434', '405');
INSERT INTO `wp_area` VALUES ('444', '四子王旗', '434', '406');
INSERT INTO `wp_area` VALUES ('445', '丰镇市', '434', '407');
INSERT INTO `wp_area` VALUES ('446', '兴安盟', '356', '34');
INSERT INTO `wp_area` VALUES ('447', '乌兰浩特市', '446', '408');
INSERT INTO `wp_area` VALUES ('448', '阿尔山市', '446', '409');
INSERT INTO `wp_area` VALUES ('449', '科尔沁右翼前旗', '446', '410');
INSERT INTO `wp_area` VALUES ('450', '科尔沁右翼中旗', '446', '411');
INSERT INTO `wp_area` VALUES ('451', '扎赉特旗', '446', '412');
INSERT INTO `wp_area` VALUES ('452', '突泉县', '446', '413');
INSERT INTO `wp_area` VALUES ('453', '锡林郭勒盟', '356', '35');
INSERT INTO `wp_area` VALUES ('454', '二连浩特市', '453', '414');
INSERT INTO `wp_area` VALUES ('455', '锡林浩特市', '453', '415');
INSERT INTO `wp_area` VALUES ('456', '阿巴嘎旗', '453', '416');
INSERT INTO `wp_area` VALUES ('457', '苏尼特左旗', '453', '417');
INSERT INTO `wp_area` VALUES ('458', '苏尼特右旗', '453', '418');
INSERT INTO `wp_area` VALUES ('459', '东乌珠穆沁旗', '453', '419');
INSERT INTO `wp_area` VALUES ('460', '西乌珠穆沁旗', '453', '420');
INSERT INTO `wp_area` VALUES ('461', '太仆寺旗', '453', '421');
INSERT INTO `wp_area` VALUES ('462', '镶黄旗', '453', '422');
INSERT INTO `wp_area` VALUES ('463', '正镶白旗', '453', '423');
INSERT INTO `wp_area` VALUES ('464', '正蓝旗', '453', '424');
INSERT INTO `wp_area` VALUES ('465', '多伦县', '453', '425');
INSERT INTO `wp_area` VALUES ('466', '阿拉善盟', '356', '36');
INSERT INTO `wp_area` VALUES ('467', '阿拉善左旗', '466', '426');
INSERT INTO `wp_area` VALUES ('468', '阿拉善右旗', '466', '427');
INSERT INTO `wp_area` VALUES ('469', '额济纳旗', '466', '428');
INSERT INTO `wp_area` VALUES ('470', '辽宁省', '0', '6');
INSERT INTO `wp_area` VALUES ('471', '沈阳市', '470', '37');
INSERT INTO `wp_area` VALUES ('472', '和平区', '471', '429');
INSERT INTO `wp_area` VALUES ('473', '沈河区', '471', '430');
INSERT INTO `wp_area` VALUES ('474', '大东区', '471', '431');
INSERT INTO `wp_area` VALUES ('475', '皇姑区', '471', '432');
INSERT INTO `wp_area` VALUES ('476', '铁西区', '471', '433');
INSERT INTO `wp_area` VALUES ('477', '苏家屯区', '471', '434');
INSERT INTO `wp_area` VALUES ('478', '东陵区', '471', '435');
INSERT INTO `wp_area` VALUES ('479', '新城子区', '471', '436');
INSERT INTO `wp_area` VALUES ('480', '于洪区', '471', '437');
INSERT INTO `wp_area` VALUES ('481', '辽中县', '471', '438');
INSERT INTO `wp_area` VALUES ('482', '康平县', '471', '439');
INSERT INTO `wp_area` VALUES ('483', '法库县', '471', '440');
INSERT INTO `wp_area` VALUES ('484', '新民市', '471', '441');
INSERT INTO `wp_area` VALUES ('485', '大连市', '470', '38');
INSERT INTO `wp_area` VALUES ('486', '中山区', '485', '442');
INSERT INTO `wp_area` VALUES ('487', '西岗区', '485', '443');
INSERT INTO `wp_area` VALUES ('488', '沙河口区', '485', '444');
INSERT INTO `wp_area` VALUES ('489', '甘井子区', '485', '445');
INSERT INTO `wp_area` VALUES ('490', '旅顺口区', '485', '446');
INSERT INTO `wp_area` VALUES ('491', '金州区', '485', '447');
INSERT INTO `wp_area` VALUES ('492', '长海县', '485', '448');
INSERT INTO `wp_area` VALUES ('493', '瓦房店市', '485', '449');
INSERT INTO `wp_area` VALUES ('494', '普兰店市', '485', '450');
INSERT INTO `wp_area` VALUES ('495', '庄河市', '485', '451');
INSERT INTO `wp_area` VALUES ('496', '鞍山市', '470', '39');
INSERT INTO `wp_area` VALUES ('497', '铁东区', '496', '452');
INSERT INTO `wp_area` VALUES ('498', '铁西区', '496', '453');
INSERT INTO `wp_area` VALUES ('499', '立山区', '496', '454');
INSERT INTO `wp_area` VALUES ('500', '千山区', '496', '455');
INSERT INTO `wp_area` VALUES ('501', '台安县', '496', '456');
INSERT INTO `wp_area` VALUES ('502', '岫岩满族自治县', '496', '457');
INSERT INTO `wp_area` VALUES ('503', '海城市', '496', '458');
INSERT INTO `wp_area` VALUES ('504', '抚顺市', '470', '40');
INSERT INTO `wp_area` VALUES ('505', '新抚区', '504', '459');
INSERT INTO `wp_area` VALUES ('506', '东洲区', '504', '460');
INSERT INTO `wp_area` VALUES ('507', '望花区', '504', '461');
INSERT INTO `wp_area` VALUES ('508', '顺城区', '504', '462');
INSERT INTO `wp_area` VALUES ('509', '抚顺县', '504', '463');
INSERT INTO `wp_area` VALUES ('510', '新宾满族自治县', '504', '464');
INSERT INTO `wp_area` VALUES ('511', '清原满族自治县', '504', '465');
INSERT INTO `wp_area` VALUES ('512', '本溪市', '470', '41');
INSERT INTO `wp_area` VALUES ('513', '平山区', '512', '466');
INSERT INTO `wp_area` VALUES ('514', '溪湖区', '512', '467');
INSERT INTO `wp_area` VALUES ('515', '明山区', '512', '468');
INSERT INTO `wp_area` VALUES ('516', '南芬区', '512', '469');
INSERT INTO `wp_area` VALUES ('517', '本溪满族自治县', '512', '470');
INSERT INTO `wp_area` VALUES ('518', '桓仁满族自治县', '512', '471');
INSERT INTO `wp_area` VALUES ('519', '丹东市', '470', '42');
INSERT INTO `wp_area` VALUES ('520', '元宝区', '519', '472');
INSERT INTO `wp_area` VALUES ('521', '振兴区', '519', '473');
INSERT INTO `wp_area` VALUES ('522', '振安区', '519', '474');
INSERT INTO `wp_area` VALUES ('523', '宽甸满族自治县', '519', '475');
INSERT INTO `wp_area` VALUES ('524', '东港市', '519', '476');
INSERT INTO `wp_area` VALUES ('525', '凤城市', '519', '477');
INSERT INTO `wp_area` VALUES ('526', '锦州市', '470', '43');
INSERT INTO `wp_area` VALUES ('527', '古塔区', '526', '478');
INSERT INTO `wp_area` VALUES ('528', '凌河区', '526', '479');
INSERT INTO `wp_area` VALUES ('529', '太和区', '526', '480');
INSERT INTO `wp_area` VALUES ('530', '黑山县', '526', '481');
INSERT INTO `wp_area` VALUES ('531', '义县', '526', '482');
INSERT INTO `wp_area` VALUES ('532', '凌海市', '526', '483');
INSERT INTO `wp_area` VALUES ('533', '北宁市', '526', '484');
INSERT INTO `wp_area` VALUES ('534', '营口市', '470', '44');
INSERT INTO `wp_area` VALUES ('535', '站前区', '534', '485');
INSERT INTO `wp_area` VALUES ('536', '西市区', '534', '486');
INSERT INTO `wp_area` VALUES ('537', '鲅鱼圈区', '534', '487');
INSERT INTO `wp_area` VALUES ('538', '老边区', '534', '488');
INSERT INTO `wp_area` VALUES ('539', '盖州市', '534', '489');
INSERT INTO `wp_area` VALUES ('540', '大石桥市', '534', '490');
INSERT INTO `wp_area` VALUES ('541', '阜新市', '470', '45');
INSERT INTO `wp_area` VALUES ('542', '海州区', '541', '491');
INSERT INTO `wp_area` VALUES ('543', '新邱区', '541', '492');
INSERT INTO `wp_area` VALUES ('544', '太平区', '541', '493');
INSERT INTO `wp_area` VALUES ('545', '清河门区', '541', '494');
INSERT INTO `wp_area` VALUES ('546', '细河区', '541', '495');
INSERT INTO `wp_area` VALUES ('547', '阜新蒙古族自治县', '541', '496');
INSERT INTO `wp_area` VALUES ('548', '彰武县', '541', '497');
INSERT INTO `wp_area` VALUES ('549', '辽阳市', '470', '46');
INSERT INTO `wp_area` VALUES ('550', '白塔区', '549', '498');
INSERT INTO `wp_area` VALUES ('551', '文圣区', '549', '499');
INSERT INTO `wp_area` VALUES ('552', '宏伟区', '549', '500');
INSERT INTO `wp_area` VALUES ('553', '弓长岭区', '549', '501');
INSERT INTO `wp_area` VALUES ('554', '太子河区', '549', '502');
INSERT INTO `wp_area` VALUES ('555', '辽阳县', '549', '503');
INSERT INTO `wp_area` VALUES ('556', '灯塔市', '549', '504');
INSERT INTO `wp_area` VALUES ('557', '盘锦市', '470', '47');
INSERT INTO `wp_area` VALUES ('558', '双台子区', '557', '505');
INSERT INTO `wp_area` VALUES ('559', '兴隆台区', '557', '506');
INSERT INTO `wp_area` VALUES ('560', '大洼县', '557', '507');
INSERT INTO `wp_area` VALUES ('561', '盘山县', '557', '508');
INSERT INTO `wp_area` VALUES ('562', '铁岭市', '470', '48');
INSERT INTO `wp_area` VALUES ('563', '银州区', '562', '509');
INSERT INTO `wp_area` VALUES ('564', '清河区', '562', '510');
INSERT INTO `wp_area` VALUES ('565', '铁岭县', '562', '511');
INSERT INTO `wp_area` VALUES ('566', '西丰县', '562', '512');
INSERT INTO `wp_area` VALUES ('567', '昌图县', '562', '513');
INSERT INTO `wp_area` VALUES ('568', '调兵山市', '562', '514');
INSERT INTO `wp_area` VALUES ('569', '开原市', '562', '515');
INSERT INTO `wp_area` VALUES ('570', '朝阳市', '470', '49');
INSERT INTO `wp_area` VALUES ('571', '双塔区', '570', '516');
INSERT INTO `wp_area` VALUES ('572', '龙城区', '570', '517');
INSERT INTO `wp_area` VALUES ('573', '朝阳县', '570', '518');
INSERT INTO `wp_area` VALUES ('574', '建平县', '570', '519');
INSERT INTO `wp_area` VALUES ('575', '喀喇沁左翼蒙古族自治县', '570', '520');
INSERT INTO `wp_area` VALUES ('576', '北票市', '570', '521');
INSERT INTO `wp_area` VALUES ('577', '凌源市', '570', '522');
INSERT INTO `wp_area` VALUES ('578', '葫芦岛市', '470', '50');
INSERT INTO `wp_area` VALUES ('579', '连山区', '578', '523');
INSERT INTO `wp_area` VALUES ('580', '龙港区', '578', '524');
INSERT INTO `wp_area` VALUES ('581', '南票区', '578', '525');
INSERT INTO `wp_area` VALUES ('582', '绥中县', '578', '526');
INSERT INTO `wp_area` VALUES ('583', '建昌县', '578', '527');
INSERT INTO `wp_area` VALUES ('584', '兴城市', '578', '528');
INSERT INTO `wp_area` VALUES ('585', '吉林省', '0', '7');
INSERT INTO `wp_area` VALUES ('586', '长春市', '585', '51');
INSERT INTO `wp_area` VALUES ('587', '南关区', '586', '529');
INSERT INTO `wp_area` VALUES ('588', '宽城区', '586', '530');
INSERT INTO `wp_area` VALUES ('589', '朝阳区', '586', '531');
INSERT INTO `wp_area` VALUES ('590', '二道区', '586', '532');
INSERT INTO `wp_area` VALUES ('591', '绿园区', '586', '533');
INSERT INTO `wp_area` VALUES ('592', '双阳区', '586', '534');
INSERT INTO `wp_area` VALUES ('593', '农安县', '586', '535');
INSERT INTO `wp_area` VALUES ('594', '九台市', '586', '536');
INSERT INTO `wp_area` VALUES ('595', '榆树市', '586', '537');
INSERT INTO `wp_area` VALUES ('596', '德惠市', '586', '538');
INSERT INTO `wp_area` VALUES ('597', '吉林市', '585', '52');
INSERT INTO `wp_area` VALUES ('598', '昌邑区', '597', '539');
INSERT INTO `wp_area` VALUES ('599', '龙潭区', '597', '540');
INSERT INTO `wp_area` VALUES ('600', '船营区', '597', '541');
INSERT INTO `wp_area` VALUES ('601', '丰满区', '597', '542');
INSERT INTO `wp_area` VALUES ('602', '永吉县', '597', '543');
INSERT INTO `wp_area` VALUES ('603', '蛟河市', '597', '544');
INSERT INTO `wp_area` VALUES ('604', '桦甸市', '597', '545');
INSERT INTO `wp_area` VALUES ('605', '舒兰市', '597', '546');
INSERT INTO `wp_area` VALUES ('606', '磐石市', '597', '547');
INSERT INTO `wp_area` VALUES ('607', '四平市', '585', '53');
INSERT INTO `wp_area` VALUES ('608', '铁西区', '607', '548');
INSERT INTO `wp_area` VALUES ('609', '铁东区', '607', '549');
INSERT INTO `wp_area` VALUES ('610', '梨树县', '607', '550');
INSERT INTO `wp_area` VALUES ('611', '伊通满族自治县', '607', '551');
INSERT INTO `wp_area` VALUES ('612', '公主岭市', '607', '552');
INSERT INTO `wp_area` VALUES ('613', '双辽市', '607', '553');
INSERT INTO `wp_area` VALUES ('614', '辽源市', '585', '54');
INSERT INTO `wp_area` VALUES ('615', '龙山区', '614', '554');
INSERT INTO `wp_area` VALUES ('616', '西安区', '614', '555');
INSERT INTO `wp_area` VALUES ('617', '东丰县', '614', '556');
INSERT INTO `wp_area` VALUES ('618', '东辽县', '614', '557');
INSERT INTO `wp_area` VALUES ('619', '通化市', '585', '55');
INSERT INTO `wp_area` VALUES ('620', '东昌区', '619', '558');
INSERT INTO `wp_area` VALUES ('621', '二道江区', '619', '559');
INSERT INTO `wp_area` VALUES ('622', '通化县', '619', '560');
INSERT INTO `wp_area` VALUES ('623', '辉南县', '619', '561');
INSERT INTO `wp_area` VALUES ('624', '柳河县', '619', '562');
INSERT INTO `wp_area` VALUES ('625', '梅河口市', '619', '563');
INSERT INTO `wp_area` VALUES ('626', '集安市', '619', '564');
INSERT INTO `wp_area` VALUES ('627', '白山市', '585', '56');
INSERT INTO `wp_area` VALUES ('628', '八道江区', '627', '565');
INSERT INTO `wp_area` VALUES ('629', '抚松县', '627', '566');
INSERT INTO `wp_area` VALUES ('630', '靖宇县', '627', '567');
INSERT INTO `wp_area` VALUES ('631', '长白朝鲜族自治县', '627', '568');
INSERT INTO `wp_area` VALUES ('632', '江源县', '627', '569');
INSERT INTO `wp_area` VALUES ('633', '临江市', '627', '570');
INSERT INTO `wp_area` VALUES ('634', '松原市', '585', '57');
INSERT INTO `wp_area` VALUES ('635', '宁江区', '634', '571');
INSERT INTO `wp_area` VALUES ('636', '前郭尔罗斯蒙古族自治县', '634', '572');
INSERT INTO `wp_area` VALUES ('637', '长岭县', '634', '573');
INSERT INTO `wp_area` VALUES ('638', '乾安县', '634', '574');
INSERT INTO `wp_area` VALUES ('639', '扶余县', '634', '575');
INSERT INTO `wp_area` VALUES ('640', '白城市', '585', '58');
INSERT INTO `wp_area` VALUES ('641', '洮北区', '640', '576');
INSERT INTO `wp_area` VALUES ('642', '镇赉县', '640', '577');
INSERT INTO `wp_area` VALUES ('643', '通榆县', '640', '578');
INSERT INTO `wp_area` VALUES ('644', '洮南市', '640', '579');
INSERT INTO `wp_area` VALUES ('645', '大安市', '640', '580');
INSERT INTO `wp_area` VALUES ('646', '延边朝鲜族自治州', '585', '59');
INSERT INTO `wp_area` VALUES ('647', '延吉市', '646', '581');
INSERT INTO `wp_area` VALUES ('648', '图们市', '646', '582');
INSERT INTO `wp_area` VALUES ('649', '敦化市', '646', '583');
INSERT INTO `wp_area` VALUES ('650', '珲春市', '646', '584');
INSERT INTO `wp_area` VALUES ('651', '龙井市', '646', '585');
INSERT INTO `wp_area` VALUES ('652', '和龙市', '646', '586');
INSERT INTO `wp_area` VALUES ('653', '汪清县', '646', '587');
INSERT INTO `wp_area` VALUES ('654', '安图县', '646', '588');
INSERT INTO `wp_area` VALUES ('655', '黑龙江省', '0', '8');
INSERT INTO `wp_area` VALUES ('656', '哈尔滨市', '655', '60');
INSERT INTO `wp_area` VALUES ('657', '道里区', '656', '589');
INSERT INTO `wp_area` VALUES ('658', '南岗区', '656', '590');
INSERT INTO `wp_area` VALUES ('659', '道外区', '656', '591');
INSERT INTO `wp_area` VALUES ('660', '香坊区', '656', '592');
INSERT INTO `wp_area` VALUES ('661', '动力区', '656', '593');
INSERT INTO `wp_area` VALUES ('662', '平房区', '656', '594');
INSERT INTO `wp_area` VALUES ('663', '松北区', '656', '595');
INSERT INTO `wp_area` VALUES ('664', '呼兰区', '656', '596');
INSERT INTO `wp_area` VALUES ('665', '依兰县', '656', '597');
INSERT INTO `wp_area` VALUES ('666', '方正县', '656', '598');
INSERT INTO `wp_area` VALUES ('667', '宾县', '656', '599');
INSERT INTO `wp_area` VALUES ('668', '巴彦县', '656', '600');
INSERT INTO `wp_area` VALUES ('669', '木兰县', '656', '601');
INSERT INTO `wp_area` VALUES ('670', '通河县', '656', '602');
INSERT INTO `wp_area` VALUES ('671', '延寿县', '656', '603');
INSERT INTO `wp_area` VALUES ('672', '阿城市', '656', '604');
INSERT INTO `wp_area` VALUES ('673', '双城市', '656', '605');
INSERT INTO `wp_area` VALUES ('674', '尚志市', '656', '606');
INSERT INTO `wp_area` VALUES ('675', '五常市', '656', '607');
INSERT INTO `wp_area` VALUES ('676', '齐齐哈尔市', '655', '61');
INSERT INTO `wp_area` VALUES ('677', '龙沙区', '676', '608');
INSERT INTO `wp_area` VALUES ('678', '建华区', '676', '609');
INSERT INTO `wp_area` VALUES ('679', '铁锋区', '676', '610');
INSERT INTO `wp_area` VALUES ('680', '昂昂溪区', '676', '611');
INSERT INTO `wp_area` VALUES ('681', '富拉尔基区', '676', '612');
INSERT INTO `wp_area` VALUES ('682', '碾子山区', '676', '613');
INSERT INTO `wp_area` VALUES ('683', '梅里斯达斡尔族区', '676', '614');
INSERT INTO `wp_area` VALUES ('684', '龙江县', '676', '615');
INSERT INTO `wp_area` VALUES ('685', '依安县', '676', '616');
INSERT INTO `wp_area` VALUES ('686', '泰来县', '676', '617');
INSERT INTO `wp_area` VALUES ('687', '甘南县', '676', '618');
INSERT INTO `wp_area` VALUES ('688', '富裕县', '676', '619');
INSERT INTO `wp_area` VALUES ('689', '克山县', '676', '620');
INSERT INTO `wp_area` VALUES ('690', '克东县', '676', '621');
INSERT INTO `wp_area` VALUES ('691', '拜泉县', '676', '622');
INSERT INTO `wp_area` VALUES ('692', '讷河市', '676', '623');
INSERT INTO `wp_area` VALUES ('693', '鸡西市', '655', '62');
INSERT INTO `wp_area` VALUES ('694', '鸡冠区', '693', '624');
INSERT INTO `wp_area` VALUES ('695', '恒山区', '693', '625');
INSERT INTO `wp_area` VALUES ('696', '滴道区', '693', '626');
INSERT INTO `wp_area` VALUES ('697', '梨树区', '693', '627');
INSERT INTO `wp_area` VALUES ('698', '城子河区', '693', '628');
INSERT INTO `wp_area` VALUES ('699', '麻山区', '693', '629');
INSERT INTO `wp_area` VALUES ('700', '鸡东县', '693', '630');
INSERT INTO `wp_area` VALUES ('701', '虎林市', '693', '631');
INSERT INTO `wp_area` VALUES ('702', '密山市', '693', '632');
INSERT INTO `wp_area` VALUES ('703', '鹤岗市', '655', '63');
INSERT INTO `wp_area` VALUES ('704', '向阳区', '703', '633');
INSERT INTO `wp_area` VALUES ('705', '工农区', '703', '634');
INSERT INTO `wp_area` VALUES ('706', '南山区', '703', '635');
INSERT INTO `wp_area` VALUES ('707', '兴安区', '703', '636');
INSERT INTO `wp_area` VALUES ('708', '东山区', '703', '637');
INSERT INTO `wp_area` VALUES ('709', '兴山区', '703', '638');
INSERT INTO `wp_area` VALUES ('710', '萝北县', '703', '639');
INSERT INTO `wp_area` VALUES ('711', '绥滨县', '703', '640');
INSERT INTO `wp_area` VALUES ('712', '双鸭山市', '655', '64');
INSERT INTO `wp_area` VALUES ('713', '尖山区', '712', '641');
INSERT INTO `wp_area` VALUES ('714', '岭东区', '712', '642');
INSERT INTO `wp_area` VALUES ('715', '四方台区', '712', '643');
INSERT INTO `wp_area` VALUES ('716', '宝山区', '712', '644');
INSERT INTO `wp_area` VALUES ('717', '集贤县', '712', '645');
INSERT INTO `wp_area` VALUES ('718', '友谊县', '712', '646');
INSERT INTO `wp_area` VALUES ('719', '宝清县', '712', '647');
INSERT INTO `wp_area` VALUES ('720', '饶河县', '712', '648');
INSERT INTO `wp_area` VALUES ('721', '大庆市', '655', '65');
INSERT INTO `wp_area` VALUES ('722', '萨尔图区', '721', '649');
INSERT INTO `wp_area` VALUES ('723', '龙凤区', '721', '650');
INSERT INTO `wp_area` VALUES ('724', '让胡路区', '721', '651');
INSERT INTO `wp_area` VALUES ('725', '红岗区', '721', '652');
INSERT INTO `wp_area` VALUES ('726', '大同区', '721', '653');
INSERT INTO `wp_area` VALUES ('727', '肇州县', '721', '654');
INSERT INTO `wp_area` VALUES ('728', '肇源县', '721', '655');
INSERT INTO `wp_area` VALUES ('729', '林甸县', '721', '656');
INSERT INTO `wp_area` VALUES ('730', '杜尔伯特蒙古族自治县', '721', '657');
INSERT INTO `wp_area` VALUES ('731', '伊春市', '655', '66');
INSERT INTO `wp_area` VALUES ('732', '伊春区', '731', '658');
INSERT INTO `wp_area` VALUES ('733', '南岔区', '731', '659');
INSERT INTO `wp_area` VALUES ('734', '友好区', '731', '660');
INSERT INTO `wp_area` VALUES ('735', '西林区', '731', '661');
INSERT INTO `wp_area` VALUES ('736', '翠峦区', '731', '662');
INSERT INTO `wp_area` VALUES ('737', '新青区', '731', '663');
INSERT INTO `wp_area` VALUES ('738', '美溪区', '731', '664');
INSERT INTO `wp_area` VALUES ('739', '金山屯区', '731', '665');
INSERT INTO `wp_area` VALUES ('740', '五营区', '731', '666');
INSERT INTO `wp_area` VALUES ('741', '乌马河区', '731', '667');
INSERT INTO `wp_area` VALUES ('742', '汤旺河区', '731', '668');
INSERT INTO `wp_area` VALUES ('743', '带岭区', '731', '669');
INSERT INTO `wp_area` VALUES ('744', '乌伊岭区', '731', '670');
INSERT INTO `wp_area` VALUES ('745', '红星区', '731', '671');
INSERT INTO `wp_area` VALUES ('746', '上甘岭区', '731', '672');
INSERT INTO `wp_area` VALUES ('747', '嘉荫县', '731', '673');
INSERT INTO `wp_area` VALUES ('748', '铁力市', '731', '674');
INSERT INTO `wp_area` VALUES ('749', '佳木斯市', '655', '67');
INSERT INTO `wp_area` VALUES ('750', '永红区', '749', '675');
INSERT INTO `wp_area` VALUES ('751', '向阳区', '749', '676');
INSERT INTO `wp_area` VALUES ('752', '前进区', '749', '677');
INSERT INTO `wp_area` VALUES ('753', '东风区', '749', '678');
INSERT INTO `wp_area` VALUES ('754', '郊区', '749', '679');
INSERT INTO `wp_area` VALUES ('755', '桦南县', '749', '680');
INSERT INTO `wp_area` VALUES ('756', '桦川县', '749', '681');
INSERT INTO `wp_area` VALUES ('757', '汤原县', '749', '682');
INSERT INTO `wp_area` VALUES ('758', '抚远县', '749', '683');
INSERT INTO `wp_area` VALUES ('759', '同江市', '749', '684');
INSERT INTO `wp_area` VALUES ('760', '富锦市', '749', '685');
INSERT INTO `wp_area` VALUES ('761', '七台河市', '655', '68');
INSERT INTO `wp_area` VALUES ('762', '新兴区', '761', '686');
INSERT INTO `wp_area` VALUES ('763', '桃山区', '761', '687');
INSERT INTO `wp_area` VALUES ('764', '茄子河区', '761', '688');
INSERT INTO `wp_area` VALUES ('765', '勃利县', '761', '689');
INSERT INTO `wp_area` VALUES ('766', '牡丹江市', '655', '69');
INSERT INTO `wp_area` VALUES ('767', '东安区', '766', '690');
INSERT INTO `wp_area` VALUES ('768', '阳明区', '766', '691');
INSERT INTO `wp_area` VALUES ('769', '爱民区', '766', '692');
INSERT INTO `wp_area` VALUES ('770', '西安区', '766', '693');
INSERT INTO `wp_area` VALUES ('771', '东宁县', '766', '694');
INSERT INTO `wp_area` VALUES ('772', '林口县', '766', '695');
INSERT INTO `wp_area` VALUES ('773', '绥芬河市', '766', '696');
INSERT INTO `wp_area` VALUES ('774', '海林市', '766', '697');
INSERT INTO `wp_area` VALUES ('775', '宁安市', '766', '698');
INSERT INTO `wp_area` VALUES ('776', '穆棱市', '766', '699');
INSERT INTO `wp_area` VALUES ('777', '黑河市', '655', '70');
INSERT INTO `wp_area` VALUES ('778', '爱辉区', '777', '700');
INSERT INTO `wp_area` VALUES ('779', '嫩江县', '777', '701');
INSERT INTO `wp_area` VALUES ('780', '逊克县', '777', '702');
INSERT INTO `wp_area` VALUES ('781', '孙吴县', '777', '703');
INSERT INTO `wp_area` VALUES ('782', '北安市', '777', '704');
INSERT INTO `wp_area` VALUES ('783', '五大连池市', '777', '705');
INSERT INTO `wp_area` VALUES ('784', '绥化市', '655', '71');
INSERT INTO `wp_area` VALUES ('785', '北林区', '784', '706');
INSERT INTO `wp_area` VALUES ('786', '望奎县', '784', '707');
INSERT INTO `wp_area` VALUES ('787', '兰西县', '784', '708');
INSERT INTO `wp_area` VALUES ('788', '青冈县', '784', '709');
INSERT INTO `wp_area` VALUES ('789', '庆安县', '784', '710');
INSERT INTO `wp_area` VALUES ('790', '明水县', '784', '711');
INSERT INTO `wp_area` VALUES ('791', '绥棱县', '784', '712');
INSERT INTO `wp_area` VALUES ('792', '安达市', '784', '713');
INSERT INTO `wp_area` VALUES ('793', '肇东市', '784', '714');
INSERT INTO `wp_area` VALUES ('794', '海伦市', '784', '715');
INSERT INTO `wp_area` VALUES ('795', '大兴安岭地区', '655', '72');
INSERT INTO `wp_area` VALUES ('796', '呼玛县', '795', '716');
INSERT INTO `wp_area` VALUES ('797', '塔河县', '795', '717');
INSERT INTO `wp_area` VALUES ('798', '漠河县', '795', '718');
INSERT INTO `wp_area` VALUES ('799', '上海市', '0', '9');
INSERT INTO `wp_area` VALUES ('801', '黄浦区', '799', '719');
INSERT INTO `wp_area` VALUES ('802', '卢湾区', '799', '720');
INSERT INTO `wp_area` VALUES ('803', '徐汇区', '799', '721');
INSERT INTO `wp_area` VALUES ('804', '长宁区', '799', '722');
INSERT INTO `wp_area` VALUES ('805', '静安区', '799', '723');
INSERT INTO `wp_area` VALUES ('806', '普陀区', '799', '724');
INSERT INTO `wp_area` VALUES ('807', '闸北区', '799', '725');
INSERT INTO `wp_area` VALUES ('808', '虹口区', '799', '726');
INSERT INTO `wp_area` VALUES ('809', '杨浦区', '799', '727');
INSERT INTO `wp_area` VALUES ('810', '闵行区', '799', '728');
INSERT INTO `wp_area` VALUES ('811', '宝山区', '799', '729');
INSERT INTO `wp_area` VALUES ('812', '嘉定区', '799', '730');
INSERT INTO `wp_area` VALUES ('813', '浦东新区', '799', '731');
INSERT INTO `wp_area` VALUES ('814', '金山区', '799', '732');
INSERT INTO `wp_area` VALUES ('815', '松江区', '799', '733');
INSERT INTO `wp_area` VALUES ('816', '青浦区', '799', '734');
INSERT INTO `wp_area` VALUES ('817', '南汇区', '799', '735');
INSERT INTO `wp_area` VALUES ('818', '奉贤区', '799', '736');
INSERT INTO `wp_area` VALUES ('819', '崇明县', '799', '737');
INSERT INTO `wp_area` VALUES ('820', '江苏省', '0', '10');
INSERT INTO `wp_area` VALUES ('821', '南京市', '820', '74');
INSERT INTO `wp_area` VALUES ('822', '玄武区', '821', '738');
INSERT INTO `wp_area` VALUES ('823', '白下区', '821', '739');
INSERT INTO `wp_area` VALUES ('824', '秦淮区', '821', '740');
INSERT INTO `wp_area` VALUES ('825', '建邺区', '821', '741');
INSERT INTO `wp_area` VALUES ('826', '鼓楼区', '821', '742');
INSERT INTO `wp_area` VALUES ('827', '下关区', '821', '743');
INSERT INTO `wp_area` VALUES ('828', '浦口区', '821', '744');
INSERT INTO `wp_area` VALUES ('829', '栖霞区', '821', '745');
INSERT INTO `wp_area` VALUES ('830', '雨花台区', '821', '746');
INSERT INTO `wp_area` VALUES ('831', '江宁区', '821', '747');
INSERT INTO `wp_area` VALUES ('832', '六合区', '821', '748');
INSERT INTO `wp_area` VALUES ('833', '溧水县', '821', '749');
INSERT INTO `wp_area` VALUES ('834', '高淳县', '821', '750');
INSERT INTO `wp_area` VALUES ('835', '无锡市', '820', '75');
INSERT INTO `wp_area` VALUES ('836', '崇安区', '835', '751');
INSERT INTO `wp_area` VALUES ('837', '南长区', '835', '752');
INSERT INTO `wp_area` VALUES ('838', '北塘区', '835', '753');
INSERT INTO `wp_area` VALUES ('839', '锡山区', '835', '754');
INSERT INTO `wp_area` VALUES ('840', '惠山区', '835', '755');
INSERT INTO `wp_area` VALUES ('841', '滨湖区', '835', '756');
INSERT INTO `wp_area` VALUES ('842', '江阴市', '835', '757');
INSERT INTO `wp_area` VALUES ('843', '宜兴市', '835', '758');
INSERT INTO `wp_area` VALUES ('844', '徐州市', '820', '76');
INSERT INTO `wp_area` VALUES ('845', '鼓楼区', '844', '759');
INSERT INTO `wp_area` VALUES ('846', '云龙区', '844', '760');
INSERT INTO `wp_area` VALUES ('847', '九里区', '844', '761');
INSERT INTO `wp_area` VALUES ('848', '贾汪区', '844', '762');
INSERT INTO `wp_area` VALUES ('849', '泉山区', '844', '763');
INSERT INTO `wp_area` VALUES ('850', '丰县', '844', '764');
INSERT INTO `wp_area` VALUES ('851', '沛县', '844', '765');
INSERT INTO `wp_area` VALUES ('852', '铜山县', '844', '766');
INSERT INTO `wp_area` VALUES ('853', '睢宁县', '844', '767');
INSERT INTO `wp_area` VALUES ('854', '新沂市', '844', '768');
INSERT INTO `wp_area` VALUES ('855', '邳州市', '844', '769');
INSERT INTO `wp_area` VALUES ('856', '常州市', '820', '77');
INSERT INTO `wp_area` VALUES ('857', '天宁区', '856', '770');
INSERT INTO `wp_area` VALUES ('858', '钟楼区', '856', '771');
INSERT INTO `wp_area` VALUES ('859', '戚墅堰区', '856', '772');
INSERT INTO `wp_area` VALUES ('860', '新北区', '856', '773');
INSERT INTO `wp_area` VALUES ('861', '武进区', '856', '774');
INSERT INTO `wp_area` VALUES ('862', '溧阳市', '856', '775');
INSERT INTO `wp_area` VALUES ('863', '金坛市', '856', '776');
INSERT INTO `wp_area` VALUES ('864', '苏州市', '820', '78');
INSERT INTO `wp_area` VALUES ('865', '沧浪区', '864', '777');
INSERT INTO `wp_area` VALUES ('866', '平江区', '864', '778');
INSERT INTO `wp_area` VALUES ('867', '金阊区', '864', '779');
INSERT INTO `wp_area` VALUES ('868', '虎丘区', '864', '780');
INSERT INTO `wp_area` VALUES ('869', '吴中区', '864', '781');
INSERT INTO `wp_area` VALUES ('870', '相城区', '864', '782');
INSERT INTO `wp_area` VALUES ('871', '常熟市', '864', '783');
INSERT INTO `wp_area` VALUES ('872', '张家港市', '864', '784');
INSERT INTO `wp_area` VALUES ('873', '昆山市', '864', '785');
INSERT INTO `wp_area` VALUES ('874', '吴江市', '864', '786');
INSERT INTO `wp_area` VALUES ('875', '太仓市', '864', '787');
INSERT INTO `wp_area` VALUES ('876', '南通市', '820', '79');
INSERT INTO `wp_area` VALUES ('877', '崇川区', '876', '788');
INSERT INTO `wp_area` VALUES ('878', '港闸区', '876', '789');
INSERT INTO `wp_area` VALUES ('879', '海安县', '876', '790');
INSERT INTO `wp_area` VALUES ('880', '如东县', '876', '791');
INSERT INTO `wp_area` VALUES ('881', '启东市', '876', '792');
INSERT INTO `wp_area` VALUES ('882', '如皋市', '876', '793');
INSERT INTO `wp_area` VALUES ('883', '通州市', '876', '794');
INSERT INTO `wp_area` VALUES ('884', '海门市', '876', '795');
INSERT INTO `wp_area` VALUES ('885', '连云港市', '820', '80');
INSERT INTO `wp_area` VALUES ('886', '连云区', '885', '796');
INSERT INTO `wp_area` VALUES ('887', '新浦区', '885', '797');
INSERT INTO `wp_area` VALUES ('888', '海州区', '885', '798');
INSERT INTO `wp_area` VALUES ('889', '赣榆县', '885', '799');
INSERT INTO `wp_area` VALUES ('890', '东海县', '885', '800');
INSERT INTO `wp_area` VALUES ('891', '灌云县', '885', '801');
INSERT INTO `wp_area` VALUES ('892', '灌南县', '885', '802');
INSERT INTO `wp_area` VALUES ('893', '淮安市', '820', '81');
INSERT INTO `wp_area` VALUES ('894', '清河区', '893', '803');
INSERT INTO `wp_area` VALUES ('895', '楚州区', '893', '804');
INSERT INTO `wp_area` VALUES ('896', '淮阴区', '893', '805');
INSERT INTO `wp_area` VALUES ('897', '清浦区', '893', '806');
INSERT INTO `wp_area` VALUES ('898', '涟水县', '893', '807');
INSERT INTO `wp_area` VALUES ('899', '洪泽县', '893', '808');
INSERT INTO `wp_area` VALUES ('900', '盱眙县', '893', '809');
INSERT INTO `wp_area` VALUES ('901', '金湖县', '893', '810');
INSERT INTO `wp_area` VALUES ('902', '盐城市', '820', '82');
INSERT INTO `wp_area` VALUES ('903', '亭湖区', '902', '811');
INSERT INTO `wp_area` VALUES ('904', '盐都区', '902', '812');
INSERT INTO `wp_area` VALUES ('905', '响水县', '902', '813');
INSERT INTO `wp_area` VALUES ('906', '滨海县', '902', '814');
INSERT INTO `wp_area` VALUES ('907', '阜宁县', '902', '815');
INSERT INTO `wp_area` VALUES ('908', '射阳县', '902', '816');
INSERT INTO `wp_area` VALUES ('909', '建湖县', '902', '817');
INSERT INTO `wp_area` VALUES ('910', '东台市', '902', '818');
INSERT INTO `wp_area` VALUES ('911', '大丰市', '902', '819');
INSERT INTO `wp_area` VALUES ('912', '扬州市', '820', '83');
INSERT INTO `wp_area` VALUES ('913', '广陵区', '912', '820');
INSERT INTO `wp_area` VALUES ('914', '邗江区', '912', '821');
INSERT INTO `wp_area` VALUES ('915', '维扬区', '912', '822');
INSERT INTO `wp_area` VALUES ('916', '宝应县', '912', '823');
INSERT INTO `wp_area` VALUES ('917', '仪征市', '912', '824');
INSERT INTO `wp_area` VALUES ('918', '高邮市', '912', '825');
INSERT INTO `wp_area` VALUES ('919', '江都市', '912', '826');
INSERT INTO `wp_area` VALUES ('920', '镇江市', '820', '84');
INSERT INTO `wp_area` VALUES ('921', '京口区', '920', '827');
INSERT INTO `wp_area` VALUES ('922', '润州区', '920', '828');
INSERT INTO `wp_area` VALUES ('923', '丹徒区', '920', '829');
INSERT INTO `wp_area` VALUES ('924', '丹阳市', '920', '830');
INSERT INTO `wp_area` VALUES ('925', '扬中市', '920', '831');
INSERT INTO `wp_area` VALUES ('926', '句容市', '920', '832');
INSERT INTO `wp_area` VALUES ('927', '泰州市', '820', '85');
INSERT INTO `wp_area` VALUES ('928', '海陵区', '927', '833');
INSERT INTO `wp_area` VALUES ('929', '高港区', '927', '834');
INSERT INTO `wp_area` VALUES ('930', '兴化市', '927', '835');
INSERT INTO `wp_area` VALUES ('931', '靖江市', '927', '836');
INSERT INTO `wp_area` VALUES ('932', '泰兴市', '927', '837');
INSERT INTO `wp_area` VALUES ('933', '姜堰市', '927', '838');
INSERT INTO `wp_area` VALUES ('934', '宿迁市', '820', '86');
INSERT INTO `wp_area` VALUES ('935', '宿城区', '934', '839');
INSERT INTO `wp_area` VALUES ('936', '宿豫区', '934', '840');
INSERT INTO `wp_area` VALUES ('937', '沭阳县', '934', '841');
INSERT INTO `wp_area` VALUES ('938', '泗阳县', '934', '842');
INSERT INTO `wp_area` VALUES ('939', '泗洪县', '934', '843');
INSERT INTO `wp_area` VALUES ('940', '浙江省', '0', '11');
INSERT INTO `wp_area` VALUES ('941', '杭州市', '940', '87');
INSERT INTO `wp_area` VALUES ('942', '上城区', '941', '844');
INSERT INTO `wp_area` VALUES ('943', '下城区', '941', '845');
INSERT INTO `wp_area` VALUES ('944', '江干区', '941', '846');
INSERT INTO `wp_area` VALUES ('945', '拱墅区', '941', '847');
INSERT INTO `wp_area` VALUES ('946', '西湖区', '941', '848');
INSERT INTO `wp_area` VALUES ('947', '滨江区', '941', '849');
INSERT INTO `wp_area` VALUES ('948', '萧山区', '941', '850');
INSERT INTO `wp_area` VALUES ('949', '余杭区', '941', '851');
INSERT INTO `wp_area` VALUES ('950', '桐庐县', '941', '852');
INSERT INTO `wp_area` VALUES ('951', '淳安县', '941', '853');
INSERT INTO `wp_area` VALUES ('952', '建德市', '941', '854');
INSERT INTO `wp_area` VALUES ('953', '富阳市', '941', '855');
INSERT INTO `wp_area` VALUES ('954', '临安市', '941', '856');
INSERT INTO `wp_area` VALUES ('955', '宁波市', '940', '88');
INSERT INTO `wp_area` VALUES ('956', '海曙区', '955', '857');
INSERT INTO `wp_area` VALUES ('957', '江东区', '955', '858');
INSERT INTO `wp_area` VALUES ('958', '江北区', '955', '859');
INSERT INTO `wp_area` VALUES ('959', '北仑区', '955', '860');
INSERT INTO `wp_area` VALUES ('960', '镇海区', '955', '861');
INSERT INTO `wp_area` VALUES ('961', '鄞州区', '955', '862');
INSERT INTO `wp_area` VALUES ('962', '象山县', '955', '863');
INSERT INTO `wp_area` VALUES ('963', '宁海县', '955', '864');
INSERT INTO `wp_area` VALUES ('964', '余姚市', '955', '865');
INSERT INTO `wp_area` VALUES ('965', '慈溪市', '955', '866');
INSERT INTO `wp_area` VALUES ('966', '奉化市', '955', '867');
INSERT INTO `wp_area` VALUES ('967', '温州市', '940', '89');
INSERT INTO `wp_area` VALUES ('968', '鹿城区', '967', '868');
INSERT INTO `wp_area` VALUES ('969', '龙湾区', '967', '869');
INSERT INTO `wp_area` VALUES ('970', '瓯海区', '967', '870');
INSERT INTO `wp_area` VALUES ('971', '洞头县', '967', '871');
INSERT INTO `wp_area` VALUES ('972', '永嘉县', '967', '872');
INSERT INTO `wp_area` VALUES ('973', '平阳县', '967', '873');
INSERT INTO `wp_area` VALUES ('974', '苍南县', '967', '874');
INSERT INTO `wp_area` VALUES ('975', '文成县', '967', '875');
INSERT INTO `wp_area` VALUES ('976', '泰顺县', '967', '876');
INSERT INTO `wp_area` VALUES ('977', '瑞安市', '967', '877');
INSERT INTO `wp_area` VALUES ('978', '乐清市', '967', '878');
INSERT INTO `wp_area` VALUES ('979', '嘉兴市', '940', '90');
INSERT INTO `wp_area` VALUES ('980', '秀城区', '979', '879');
INSERT INTO `wp_area` VALUES ('981', '秀洲区', '979', '880');
INSERT INTO `wp_area` VALUES ('982', '嘉善县', '979', '881');
INSERT INTO `wp_area` VALUES ('983', '海盐县', '979', '882');
INSERT INTO `wp_area` VALUES ('984', '海宁市', '979', '883');
INSERT INTO `wp_area` VALUES ('985', '平湖市', '979', '884');
INSERT INTO `wp_area` VALUES ('986', '桐乡市', '979', '885');
INSERT INTO `wp_area` VALUES ('987', '湖州市', '940', '91');
INSERT INTO `wp_area` VALUES ('988', '吴兴区', '987', '886');
INSERT INTO `wp_area` VALUES ('989', '南浔区', '987', '887');
INSERT INTO `wp_area` VALUES ('990', '德清县', '987', '888');
INSERT INTO `wp_area` VALUES ('991', '长兴县', '987', '889');
INSERT INTO `wp_area` VALUES ('992', '安吉县', '987', '890');
INSERT INTO `wp_area` VALUES ('993', '绍兴市', '940', '92');
INSERT INTO `wp_area` VALUES ('994', '越城区', '993', '891');
INSERT INTO `wp_area` VALUES ('995', '绍兴县', '993', '892');
INSERT INTO `wp_area` VALUES ('996', '新昌县', '993', '893');
INSERT INTO `wp_area` VALUES ('997', '诸暨市', '993', '894');
INSERT INTO `wp_area` VALUES ('998', '上虞市', '993', '895');
INSERT INTO `wp_area` VALUES ('999', '嵊州市', '993', '896');
INSERT INTO `wp_area` VALUES ('1000', '金华市', '940', '93');
INSERT INTO `wp_area` VALUES ('1001', '婺城区', '1000', '897');
INSERT INTO `wp_area` VALUES ('1002', '金东区', '1000', '898');
INSERT INTO `wp_area` VALUES ('1003', '武义县', '1000', '899');
INSERT INTO `wp_area` VALUES ('1004', '浦江县', '1000', '900');
INSERT INTO `wp_area` VALUES ('1005', '磐安县', '1000', '901');
INSERT INTO `wp_area` VALUES ('1006', '兰溪市', '1000', '902');
INSERT INTO `wp_area` VALUES ('1007', '义乌市', '1000', '903');
INSERT INTO `wp_area` VALUES ('1008', '东阳市', '1000', '904');
INSERT INTO `wp_area` VALUES ('1009', '永康市', '1000', '905');
INSERT INTO `wp_area` VALUES ('1010', '衢州市', '940', '94');
INSERT INTO `wp_area` VALUES ('1011', '柯城区', '1010', '906');
INSERT INTO `wp_area` VALUES ('1012', '衢江区', '1010', '907');
INSERT INTO `wp_area` VALUES ('1013', '常山县', '1010', '908');
INSERT INTO `wp_area` VALUES ('1014', '开化县', '1010', '909');
INSERT INTO `wp_area` VALUES ('1015', '龙游县', '1010', '910');
INSERT INTO `wp_area` VALUES ('1016', '江山市', '1010', '911');
INSERT INTO `wp_area` VALUES ('1017', '舟山市', '940', '95');
INSERT INTO `wp_area` VALUES ('1018', '定海区', '1017', '912');
INSERT INTO `wp_area` VALUES ('1019', '普陀区', '1017', '913');
INSERT INTO `wp_area` VALUES ('1020', '岱山县', '1017', '914');
INSERT INTO `wp_area` VALUES ('1021', '嵊泗县', '1017', '915');
INSERT INTO `wp_area` VALUES ('1022', '台州市', '940', '96');
INSERT INTO `wp_area` VALUES ('1023', '椒江区', '1022', '916');
INSERT INTO `wp_area` VALUES ('1024', '黄岩区', '1022', '917');
INSERT INTO `wp_area` VALUES ('1025', '路桥区', '1022', '918');
INSERT INTO `wp_area` VALUES ('1026', '玉环县', '1022', '919');
INSERT INTO `wp_area` VALUES ('1027', '三门县', '1022', '920');
INSERT INTO `wp_area` VALUES ('1028', '天台县', '1022', '921');
INSERT INTO `wp_area` VALUES ('1029', '仙居县', '1022', '922');
INSERT INTO `wp_area` VALUES ('1030', '温岭市', '1022', '923');
INSERT INTO `wp_area` VALUES ('1031', '临海市', '1022', '924');
INSERT INTO `wp_area` VALUES ('1032', '丽水市', '940', '97');
INSERT INTO `wp_area` VALUES ('1033', '莲都区', '1032', '925');
INSERT INTO `wp_area` VALUES ('1034', '青田县', '1032', '926');
INSERT INTO `wp_area` VALUES ('1035', '缙云县', '1032', '927');
INSERT INTO `wp_area` VALUES ('1036', '遂昌县', '1032', '928');
INSERT INTO `wp_area` VALUES ('1037', '松阳县', '1032', '929');
INSERT INTO `wp_area` VALUES ('1038', '云和县', '1032', '930');
INSERT INTO `wp_area` VALUES ('1039', '庆元县', '1032', '931');
INSERT INTO `wp_area` VALUES ('1040', '景宁畲族自治县', '1032', '932');
INSERT INTO `wp_area` VALUES ('1041', '龙泉市', '1032', '933');
INSERT INTO `wp_area` VALUES ('1042', '安徽省', '0', '12');
INSERT INTO `wp_area` VALUES ('1043', '合肥市', '1042', '98');
INSERT INTO `wp_area` VALUES ('1044', '瑶海区', '1043', '934');
INSERT INTO `wp_area` VALUES ('1045', '庐阳区', '1043', '935');
INSERT INTO `wp_area` VALUES ('1046', '蜀山区', '1043', '936');
INSERT INTO `wp_area` VALUES ('1047', '包河区', '1043', '937');
INSERT INTO `wp_area` VALUES ('1048', '长丰县', '1043', '938');
INSERT INTO `wp_area` VALUES ('1049', '肥东县', '1043', '939');
INSERT INTO `wp_area` VALUES ('1050', '肥西县', '1043', '940');
INSERT INTO `wp_area` VALUES ('1051', '芜湖市', '1042', '99');
INSERT INTO `wp_area` VALUES ('1052', '镜湖区', '1051', '941');
INSERT INTO `wp_area` VALUES ('1053', '马塘区', '1051', '942');
INSERT INTO `wp_area` VALUES ('1054', '新芜区', '1051', '943');
INSERT INTO `wp_area` VALUES ('1055', '鸠江区', '1051', '944');
INSERT INTO `wp_area` VALUES ('1056', '芜湖县', '1051', '945');
INSERT INTO `wp_area` VALUES ('1057', '繁昌县', '1051', '946');
INSERT INTO `wp_area` VALUES ('1058', '南陵县', '1051', '947');
INSERT INTO `wp_area` VALUES ('1059', '蚌埠市', '1042', '100');
INSERT INTO `wp_area` VALUES ('1060', '龙子湖区', '1059', '948');
INSERT INTO `wp_area` VALUES ('1061', '蚌山区', '1059', '949');
INSERT INTO `wp_area` VALUES ('1062', '禹会区', '1059', '950');
INSERT INTO `wp_area` VALUES ('1063', '淮上区', '1059', '951');
INSERT INTO `wp_area` VALUES ('1064', '怀远县', '1059', '952');
INSERT INTO `wp_area` VALUES ('1065', '五河县', '1059', '953');
INSERT INTO `wp_area` VALUES ('1066', '固镇县', '1059', '954');
INSERT INTO `wp_area` VALUES ('1067', '淮南市', '1042', '101');
INSERT INTO `wp_area` VALUES ('1068', '大通区', '1067', '955');
INSERT INTO `wp_area` VALUES ('1069', '田家庵区', '1067', '956');
INSERT INTO `wp_area` VALUES ('1070', '谢家集区', '1067', '957');
INSERT INTO `wp_area` VALUES ('1071', '八公山区', '1067', '958');
INSERT INTO `wp_area` VALUES ('1072', '潘集区', '1067', '959');
INSERT INTO `wp_area` VALUES ('1073', '凤台县', '1067', '960');
INSERT INTO `wp_area` VALUES ('1074', '马鞍山市', '1042', '102');
INSERT INTO `wp_area` VALUES ('1075', '金家庄区', '1074', '961');
INSERT INTO `wp_area` VALUES ('1076', '花山区', '1074', '962');
INSERT INTO `wp_area` VALUES ('1077', '雨山区', '1074', '963');
INSERT INTO `wp_area` VALUES ('1078', '当涂县', '1074', '964');
INSERT INTO `wp_area` VALUES ('1079', '淮北市', '1042', '103');
INSERT INTO `wp_area` VALUES ('1080', '杜集区', '1079', '965');
INSERT INTO `wp_area` VALUES ('1081', '相山区', '1079', '966');
INSERT INTO `wp_area` VALUES ('1082', '烈山区', '1079', '967');
INSERT INTO `wp_area` VALUES ('1083', '濉溪县', '1079', '968');
INSERT INTO `wp_area` VALUES ('1084', '铜陵市', '1042', '104');
INSERT INTO `wp_area` VALUES ('1085', '铜官山区', '1084', '969');
INSERT INTO `wp_area` VALUES ('1086', '狮子山区', '1084', '970');
INSERT INTO `wp_area` VALUES ('1087', '郊区', '1084', '971');
INSERT INTO `wp_area` VALUES ('1088', '铜陵县', '1084', '972');
INSERT INTO `wp_area` VALUES ('1089', '安庆市', '1042', '105');
INSERT INTO `wp_area` VALUES ('1090', '迎江区', '1089', '973');
INSERT INTO `wp_area` VALUES ('1091', '大观区', '1089', '974');
INSERT INTO `wp_area` VALUES ('1092', '郊区', '1089', '975');
INSERT INTO `wp_area` VALUES ('1093', '怀宁县', '1089', '976');
INSERT INTO `wp_area` VALUES ('1094', '枞阳县', '1089', '977');
INSERT INTO `wp_area` VALUES ('1095', '潜山县', '1089', '978');
INSERT INTO `wp_area` VALUES ('1096', '太湖县', '1089', '979');
INSERT INTO `wp_area` VALUES ('1097', '宿松县', '1089', '980');
INSERT INTO `wp_area` VALUES ('1098', '望江县', '1089', '981');
INSERT INTO `wp_area` VALUES ('1099', '岳西县', '1089', '982');
INSERT INTO `wp_area` VALUES ('1100', '桐城市', '1089', '983');
INSERT INTO `wp_area` VALUES ('1101', '黄山市', '1042', '106');
INSERT INTO `wp_area` VALUES ('1102', '屯溪区', '1101', '984');
INSERT INTO `wp_area` VALUES ('1103', '黄山区', '1101', '985');
INSERT INTO `wp_area` VALUES ('1104', '徽州区', '1101', '986');
INSERT INTO `wp_area` VALUES ('1105', '歙县', '1101', '987');
INSERT INTO `wp_area` VALUES ('1106', '休宁县', '1101', '988');
INSERT INTO `wp_area` VALUES ('1107', '黟县', '1101', '989');
INSERT INTO `wp_area` VALUES ('1108', '祁门县', '1101', '990');
INSERT INTO `wp_area` VALUES ('1109', '滁州市', '1042', '107');
INSERT INTO `wp_area` VALUES ('1110', '琅琊区', '1109', '991');
INSERT INTO `wp_area` VALUES ('1111', '南谯区', '1109', '992');
INSERT INTO `wp_area` VALUES ('1112', '来安县', '1109', '993');
INSERT INTO `wp_area` VALUES ('1113', '全椒县', '1109', '994');
INSERT INTO `wp_area` VALUES ('1114', '定远县', '1109', '995');
INSERT INTO `wp_area` VALUES ('1115', '凤阳县', '1109', '996');
INSERT INTO `wp_area` VALUES ('1116', '天长市', '1109', '997');
INSERT INTO `wp_area` VALUES ('1117', '明光市', '1109', '998');
INSERT INTO `wp_area` VALUES ('1118', '阜阳市', '1042', '108');
INSERT INTO `wp_area` VALUES ('1119', '颍州区', '1118', '999');
INSERT INTO `wp_area` VALUES ('1120', '颍东区', '1118', '1000');
INSERT INTO `wp_area` VALUES ('1121', '颍泉区', '1118', '1001');
INSERT INTO `wp_area` VALUES ('1122', '临泉县', '1118', '1002');
INSERT INTO `wp_area` VALUES ('1123', '太和县', '1118', '1003');
INSERT INTO `wp_area` VALUES ('1124', '阜南县', '1118', '1004');
INSERT INTO `wp_area` VALUES ('1125', '颍上县', '1118', '1005');
INSERT INTO `wp_area` VALUES ('1126', '界首市', '1118', '1006');
INSERT INTO `wp_area` VALUES ('1127', '宿州市', '1042', '109');
INSERT INTO `wp_area` VALUES ('1128', '埇桥区', '1127', '1007');
INSERT INTO `wp_area` VALUES ('1129', '砀山县', '1127', '1008');
INSERT INTO `wp_area` VALUES ('1130', '萧县', '1127', '1009');
INSERT INTO `wp_area` VALUES ('1131', '灵璧县', '1127', '1010');
INSERT INTO `wp_area` VALUES ('1132', '泗县', '1127', '1011');
INSERT INTO `wp_area` VALUES ('1133', '巢湖市', '1042', '110');
INSERT INTO `wp_area` VALUES ('1134', '居巢区', '1133', '1012');
INSERT INTO `wp_area` VALUES ('1135', '庐江县', '1133', '1013');
INSERT INTO `wp_area` VALUES ('1136', '无为县', '1133', '1014');
INSERT INTO `wp_area` VALUES ('1137', '含山县', '1133', '1015');
INSERT INTO `wp_area` VALUES ('1138', '和县', '1133', '1016');
INSERT INTO `wp_area` VALUES ('1139', '六安市', '1042', '111');
INSERT INTO `wp_area` VALUES ('1140', '金安区', '1139', '1017');
INSERT INTO `wp_area` VALUES ('1141', '裕安区', '1139', '1018');
INSERT INTO `wp_area` VALUES ('1142', '寿县', '1139', '1019');
INSERT INTO `wp_area` VALUES ('1143', '霍邱县', '1139', '1020');
INSERT INTO `wp_area` VALUES ('1144', '舒城县', '1139', '1021');
INSERT INTO `wp_area` VALUES ('1145', '金寨县', '1139', '1022');
INSERT INTO `wp_area` VALUES ('1146', '霍山县', '1139', '1023');
INSERT INTO `wp_area` VALUES ('1147', '亳州市', '1042', '112');
INSERT INTO `wp_area` VALUES ('1148', '谯城区', '1147', '1024');
INSERT INTO `wp_area` VALUES ('1149', '涡阳县', '1147', '1025');
INSERT INTO `wp_area` VALUES ('1150', '蒙城县', '1147', '1026');
INSERT INTO `wp_area` VALUES ('1151', '利辛县', '1147', '1027');
INSERT INTO `wp_area` VALUES ('1152', '池州市', '1042', '113');
INSERT INTO `wp_area` VALUES ('1153', '贵池区', '1152', '1028');
INSERT INTO `wp_area` VALUES ('1154', '东至县', '1152', '1029');
INSERT INTO `wp_area` VALUES ('1155', '石台县', '1152', '1030');
INSERT INTO `wp_area` VALUES ('1156', '青阳县', '1152', '1031');
INSERT INTO `wp_area` VALUES ('1157', '宣城市', '1042', '114');
INSERT INTO `wp_area` VALUES ('1158', '宣州区', '1157', '1032');
INSERT INTO `wp_area` VALUES ('1159', '郎溪县', '1157', '1033');
INSERT INTO `wp_area` VALUES ('1160', '广德县', '1157', '1034');
INSERT INTO `wp_area` VALUES ('1161', '泾县', '1157', '1035');
INSERT INTO `wp_area` VALUES ('1162', '绩溪县', '1157', '1036');
INSERT INTO `wp_area` VALUES ('1163', '旌德县', '1157', '1037');
INSERT INTO `wp_area` VALUES ('1164', '宁国市', '1157', '1038');
INSERT INTO `wp_area` VALUES ('1165', '福建省', '0', '13');
INSERT INTO `wp_area` VALUES ('1166', '福州市', '1165', '115');
INSERT INTO `wp_area` VALUES ('1167', '鼓楼区', '1166', '1039');
INSERT INTO `wp_area` VALUES ('1168', '台江区', '1166', '1040');
INSERT INTO `wp_area` VALUES ('1169', '仓山区', '1166', '1041');
INSERT INTO `wp_area` VALUES ('1170', '马尾区', '1166', '1042');
INSERT INTO `wp_area` VALUES ('1171', '晋安区', '1166', '1043');
INSERT INTO `wp_area` VALUES ('1172', '闽侯县', '1166', '1044');
INSERT INTO `wp_area` VALUES ('1173', '连江县', '1166', '1045');
INSERT INTO `wp_area` VALUES ('1174', '罗源县', '1166', '1046');
INSERT INTO `wp_area` VALUES ('1175', '闽清县', '1166', '1047');
INSERT INTO `wp_area` VALUES ('1176', '永泰县', '1166', '1048');
INSERT INTO `wp_area` VALUES ('1177', '平潭县', '1166', '1049');
INSERT INTO `wp_area` VALUES ('1178', '福清市', '1166', '1050');
INSERT INTO `wp_area` VALUES ('1179', '长乐市', '1166', '1051');
INSERT INTO `wp_area` VALUES ('1180', '厦门市', '1165', '116');
INSERT INTO `wp_area` VALUES ('1181', '思明区', '1180', '1052');
INSERT INTO `wp_area` VALUES ('1182', '海沧区', '1180', '1053');
INSERT INTO `wp_area` VALUES ('1183', '湖里区', '1180', '1054');
INSERT INTO `wp_area` VALUES ('1184', '集美区', '1180', '1055');
INSERT INTO `wp_area` VALUES ('1185', '同安区', '1180', '1056');
INSERT INTO `wp_area` VALUES ('1186', '翔安区', '1180', '1057');
INSERT INTO `wp_area` VALUES ('1187', '莆田市', '1165', '117');
INSERT INTO `wp_area` VALUES ('1188', '城厢区', '1187', '1058');
INSERT INTO `wp_area` VALUES ('1189', '涵江区', '1187', '1059');
INSERT INTO `wp_area` VALUES ('1190', '荔城区', '1187', '1060');
INSERT INTO `wp_area` VALUES ('1191', '秀屿区', '1187', '1061');
INSERT INTO `wp_area` VALUES ('1192', '仙游县', '1187', '1062');
INSERT INTO `wp_area` VALUES ('1193', '三明市', '1165', '118');
INSERT INTO `wp_area` VALUES ('1194', '梅列区', '1193', '1063');
INSERT INTO `wp_area` VALUES ('1195', '三元区', '1193', '1064');
INSERT INTO `wp_area` VALUES ('1196', '明溪县', '1193', '1065');
INSERT INTO `wp_area` VALUES ('1197', '清流县', '1193', '1066');
INSERT INTO `wp_area` VALUES ('1198', '宁化县', '1193', '1067');
INSERT INTO `wp_area` VALUES ('1199', '大田县', '1193', '1068');
INSERT INTO `wp_area` VALUES ('1200', '尤溪县', '1193', '1069');
INSERT INTO `wp_area` VALUES ('1201', '沙县', '1193', '1070');
INSERT INTO `wp_area` VALUES ('1202', '将乐县', '1193', '1071');
INSERT INTO `wp_area` VALUES ('1203', '泰宁县', '1193', '1072');
INSERT INTO `wp_area` VALUES ('1204', '建宁县', '1193', '1073');
INSERT INTO `wp_area` VALUES ('1205', '永安市', '1193', '1074');
INSERT INTO `wp_area` VALUES ('1206', '泉州市', '1165', '119');
INSERT INTO `wp_area` VALUES ('1207', '鲤城区', '1206', '1075');
INSERT INTO `wp_area` VALUES ('1208', '丰泽区', '1206', '1076');
INSERT INTO `wp_area` VALUES ('1209', '洛江区', '1206', '1077');
INSERT INTO `wp_area` VALUES ('1210', '泉港区', '1206', '1078');
INSERT INTO `wp_area` VALUES ('1211', '惠安县', '1206', '1079');
INSERT INTO `wp_area` VALUES ('1212', '安溪县', '1206', '1080');
INSERT INTO `wp_area` VALUES ('1213', '永春县', '1206', '1081');
INSERT INTO `wp_area` VALUES ('1214', '德化县', '1206', '1082');
INSERT INTO `wp_area` VALUES ('1215', '金门县', '1206', '1083');
INSERT INTO `wp_area` VALUES ('1216', '石狮市', '1206', '1084');
INSERT INTO `wp_area` VALUES ('1217', '晋江市', '1206', '1085');
INSERT INTO `wp_area` VALUES ('1218', '南安市', '1206', '1086');
INSERT INTO `wp_area` VALUES ('1219', '漳州市', '1165', '120');
INSERT INTO `wp_area` VALUES ('1220', '芗城区', '1219', '1087');
INSERT INTO `wp_area` VALUES ('1221', '龙文区', '1219', '1088');
INSERT INTO `wp_area` VALUES ('1222', '云霄县', '1219', '1089');
INSERT INTO `wp_area` VALUES ('1223', '漳浦县', '1219', '1090');
INSERT INTO `wp_area` VALUES ('1224', '诏安县', '1219', '1091');
INSERT INTO `wp_area` VALUES ('1225', '长泰县', '1219', '1092');
INSERT INTO `wp_area` VALUES ('1226', '东山县', '1219', '1093');
INSERT INTO `wp_area` VALUES ('1227', '南靖县', '1219', '1094');
INSERT INTO `wp_area` VALUES ('1228', '平和县', '1219', '1095');
INSERT INTO `wp_area` VALUES ('1229', '华安县', '1219', '1096');
INSERT INTO `wp_area` VALUES ('1230', '龙海市', '1219', '1097');
INSERT INTO `wp_area` VALUES ('1231', '南平市', '1165', '121');
INSERT INTO `wp_area` VALUES ('1232', '延平区', '1231', '1098');
INSERT INTO `wp_area` VALUES ('1233', '顺昌县', '1231', '1099');
INSERT INTO `wp_area` VALUES ('1234', '浦城县', '1231', '1100');
INSERT INTO `wp_area` VALUES ('1235', '光泽县', '1231', '1101');
INSERT INTO `wp_area` VALUES ('1236', '松溪县', '1231', '1102');
INSERT INTO `wp_area` VALUES ('1237', '政和县', '1231', '1103');
INSERT INTO `wp_area` VALUES ('1238', '邵武市', '1231', '1104');
INSERT INTO `wp_area` VALUES ('1239', '武夷山市', '1231', '1105');
INSERT INTO `wp_area` VALUES ('1240', '建瓯市', '1231', '1106');
INSERT INTO `wp_area` VALUES ('1241', '建阳市', '1231', '1107');
INSERT INTO `wp_area` VALUES ('1242', '龙岩市', '1165', '122');
INSERT INTO `wp_area` VALUES ('1243', '新罗区', '1242', '1108');
INSERT INTO `wp_area` VALUES ('1244', '长汀县', '1242', '1109');
INSERT INTO `wp_area` VALUES ('1245', '永定县', '1242', '1110');
INSERT INTO `wp_area` VALUES ('1246', '上杭县', '1242', '1111');
INSERT INTO `wp_area` VALUES ('1247', '武平县', '1242', '1112');
INSERT INTO `wp_area` VALUES ('1248', '连城县', '1242', '1113');
INSERT INTO `wp_area` VALUES ('1249', '漳平市', '1242', '1114');
INSERT INTO `wp_area` VALUES ('1250', '宁德市', '1165', '123');
INSERT INTO `wp_area` VALUES ('1251', '蕉城区', '1250', '1115');
INSERT INTO `wp_area` VALUES ('1252', '霞浦县', '1250', '1116');
INSERT INTO `wp_area` VALUES ('1253', '古田县', '1250', '1117');
INSERT INTO `wp_area` VALUES ('1254', '屏南县', '1250', '1118');
INSERT INTO `wp_area` VALUES ('1255', '寿宁县', '1250', '1119');
INSERT INTO `wp_area` VALUES ('1256', '周宁县', '1250', '1120');
INSERT INTO `wp_area` VALUES ('1257', '柘荣县', '1250', '1121');
INSERT INTO `wp_area` VALUES ('1258', '福安市', '1250', '1122');
INSERT INTO `wp_area` VALUES ('1259', '福鼎市', '1250', '1123');
INSERT INTO `wp_area` VALUES ('1260', '江西省', '0', '14');
INSERT INTO `wp_area` VALUES ('1261', '南昌市', '1260', '124');
INSERT INTO `wp_area` VALUES ('1262', '东湖区', '1261', '1124');
INSERT INTO `wp_area` VALUES ('1263', '西湖区', '1261', '1125');
INSERT INTO `wp_area` VALUES ('1264', '青云谱区', '1261', '1126');
INSERT INTO `wp_area` VALUES ('1265', '湾里区', '1261', '1127');
INSERT INTO `wp_area` VALUES ('1266', '青山湖区', '1261', '1128');
INSERT INTO `wp_area` VALUES ('1267', '南昌县', '1261', '1129');
INSERT INTO `wp_area` VALUES ('1268', '新建县', '1261', '1130');
INSERT INTO `wp_area` VALUES ('1269', '安义县', '1261', '1131');
INSERT INTO `wp_area` VALUES ('1270', '进贤县', '1261', '1132');
INSERT INTO `wp_area` VALUES ('1271', '景德镇市', '1260', '125');
INSERT INTO `wp_area` VALUES ('1272', '昌江区', '1271', '1133');
INSERT INTO `wp_area` VALUES ('1273', '珠山区', '1271', '1134');
INSERT INTO `wp_area` VALUES ('1274', '浮梁县', '1271', '1135');
INSERT INTO `wp_area` VALUES ('1275', '乐平市', '1271', '1136');
INSERT INTO `wp_area` VALUES ('1276', '萍乡市', '1260', '126');
INSERT INTO `wp_area` VALUES ('1277', '安源区', '1276', '1137');
INSERT INTO `wp_area` VALUES ('1278', '湘东区', '1276', '1138');
INSERT INTO `wp_area` VALUES ('1279', '莲花县', '1276', '1139');
INSERT INTO `wp_area` VALUES ('1280', '上栗县', '1276', '1140');
INSERT INTO `wp_area` VALUES ('1281', '芦溪县', '1276', '1141');
INSERT INTO `wp_area` VALUES ('1282', '九江市', '1260', '127');
INSERT INTO `wp_area` VALUES ('1283', '庐山区', '1282', '1142');
INSERT INTO `wp_area` VALUES ('1284', '浔阳区', '1282', '1143');
INSERT INTO `wp_area` VALUES ('1285', '九江县', '1282', '1144');
INSERT INTO `wp_area` VALUES ('1286', '武宁县', '1282', '1145');
INSERT INTO `wp_area` VALUES ('1287', '修水县', '1282', '1146');
INSERT INTO `wp_area` VALUES ('1288', '永修县', '1282', '1147');
INSERT INTO `wp_area` VALUES ('1289', '德安县', '1282', '1148');
INSERT INTO `wp_area` VALUES ('1290', '星子县', '1282', '1149');
INSERT INTO `wp_area` VALUES ('1291', '都昌县', '1282', '1150');
INSERT INTO `wp_area` VALUES ('1292', '湖口县', '1282', '1151');
INSERT INTO `wp_area` VALUES ('1293', '彭泽县', '1282', '1152');
INSERT INTO `wp_area` VALUES ('1294', '瑞昌市', '1282', '1153');
INSERT INTO `wp_area` VALUES ('1295', '新余市', '1260', '128');
INSERT INTO `wp_area` VALUES ('1296', '渝水区', '1295', '1154');
INSERT INTO `wp_area` VALUES ('1297', '分宜县', '1295', '1155');
INSERT INTO `wp_area` VALUES ('1298', '鹰潭市', '1260', '129');
INSERT INTO `wp_area` VALUES ('1299', '月湖区', '1298', '1156');
INSERT INTO `wp_area` VALUES ('1300', '余江县', '1298', '1157');
INSERT INTO `wp_area` VALUES ('1301', '贵溪市', '1298', '1158');
INSERT INTO `wp_area` VALUES ('1302', '赣州市', '1260', '130');
INSERT INTO `wp_area` VALUES ('1303', '章贡区', '1302', '1159');
INSERT INTO `wp_area` VALUES ('1304', '赣县', '1302', '1160');
INSERT INTO `wp_area` VALUES ('1305', '信丰县', '1302', '1161');
INSERT INTO `wp_area` VALUES ('1306', '大余县', '1302', '1162');
INSERT INTO `wp_area` VALUES ('1307', '上犹县', '1302', '1163');
INSERT INTO `wp_area` VALUES ('1308', '崇义县', '1302', '1164');
INSERT INTO `wp_area` VALUES ('1309', '安远县', '1302', '1165');
INSERT INTO `wp_area` VALUES ('1310', '龙南县', '1302', '1166');
INSERT INTO `wp_area` VALUES ('1311', '定南县', '1302', '1167');
INSERT INTO `wp_area` VALUES ('1312', '全南县', '1302', '1168');
INSERT INTO `wp_area` VALUES ('1313', '宁都县', '1302', '1169');
INSERT INTO `wp_area` VALUES ('1314', '于都县', '1302', '1170');
INSERT INTO `wp_area` VALUES ('1315', '兴国县', '1302', '1171');
INSERT INTO `wp_area` VALUES ('1316', '会昌县', '1302', '1172');
INSERT INTO `wp_area` VALUES ('1317', '寻乌县', '1302', '1173');
INSERT INTO `wp_area` VALUES ('1318', '石城县', '1302', '1174');
INSERT INTO `wp_area` VALUES ('1319', '瑞金市', '1302', '1175');
INSERT INTO `wp_area` VALUES ('1320', '南康市', '1302', '1176');
INSERT INTO `wp_area` VALUES ('1321', '吉安市', '1260', '131');
INSERT INTO `wp_area` VALUES ('1322', '吉州区', '1321', '1177');
INSERT INTO `wp_area` VALUES ('1323', '青原区', '1321', '1178');
INSERT INTO `wp_area` VALUES ('1324', '吉安县', '1321', '1179');
INSERT INTO `wp_area` VALUES ('1325', '吉水县', '1321', '1180');
INSERT INTO `wp_area` VALUES ('1326', '峡江县', '1321', '1181');
INSERT INTO `wp_area` VALUES ('1327', '新干县', '1321', '1182');
INSERT INTO `wp_area` VALUES ('1328', '永丰县', '1321', '1183');
INSERT INTO `wp_area` VALUES ('1329', '泰和县', '1321', '1184');
INSERT INTO `wp_area` VALUES ('1330', '遂川县', '1321', '1185');
INSERT INTO `wp_area` VALUES ('1331', '万安县', '1321', '1186');
INSERT INTO `wp_area` VALUES ('1332', '安福县', '1321', '1187');
INSERT INTO `wp_area` VALUES ('1333', '永新县', '1321', '1188');
INSERT INTO `wp_area` VALUES ('1334', '井冈山市', '1321', '1189');
INSERT INTO `wp_area` VALUES ('1335', '宜春市', '1260', '132');
INSERT INTO `wp_area` VALUES ('1336', '袁州区', '1335', '1190');
INSERT INTO `wp_area` VALUES ('1337', '奉新县', '1335', '1191');
INSERT INTO `wp_area` VALUES ('1338', '万载县', '1335', '1192');
INSERT INTO `wp_area` VALUES ('1339', '上高县', '1335', '1193');
INSERT INTO `wp_area` VALUES ('1340', '宜丰县', '1335', '1194');
INSERT INTO `wp_area` VALUES ('1341', '靖安县', '1335', '1195');
INSERT INTO `wp_area` VALUES ('1342', '铜鼓县', '1335', '1196');
INSERT INTO `wp_area` VALUES ('1343', '丰城市', '1335', '1197');
INSERT INTO `wp_area` VALUES ('1344', '樟树市', '1335', '1198');
INSERT INTO `wp_area` VALUES ('1345', '高安市', '1335', '1199');
INSERT INTO `wp_area` VALUES ('1346', '抚州市', '1260', '133');
INSERT INTO `wp_area` VALUES ('1347', '临川区', '1346', '1200');
INSERT INTO `wp_area` VALUES ('1348', '南城县', '1346', '1201');
INSERT INTO `wp_area` VALUES ('1349', '黎川县', '1346', '1202');
INSERT INTO `wp_area` VALUES ('1350', '南丰县', '1346', '1203');
INSERT INTO `wp_area` VALUES ('1351', '崇仁县', '1346', '1204');
INSERT INTO `wp_area` VALUES ('1352', '乐安县', '1346', '1205');
INSERT INTO `wp_area` VALUES ('1353', '宜黄县', '1346', '1206');
INSERT INTO `wp_area` VALUES ('1354', '金溪县', '1346', '1207');
INSERT INTO `wp_area` VALUES ('1355', '资溪县', '1346', '1208');
INSERT INTO `wp_area` VALUES ('1356', '东乡县', '1346', '1209');
INSERT INTO `wp_area` VALUES ('1357', '广昌县', '1346', '1210');
INSERT INTO `wp_area` VALUES ('1358', '上饶市', '1260', '134');
INSERT INTO `wp_area` VALUES ('1359', '信州区', '1358', '1211');
INSERT INTO `wp_area` VALUES ('1360', '上饶县', '1358', '1212');
INSERT INTO `wp_area` VALUES ('1361', '广丰县', '1358', '1213');
INSERT INTO `wp_area` VALUES ('1362', '玉山县', '1358', '1214');
INSERT INTO `wp_area` VALUES ('1363', '铅山县', '1358', '1215');
INSERT INTO `wp_area` VALUES ('1364', '横峰县', '1358', '1216');
INSERT INTO `wp_area` VALUES ('1365', '弋阳县', '1358', '1217');
INSERT INTO `wp_area` VALUES ('1366', '余干县', '1358', '1218');
INSERT INTO `wp_area` VALUES ('1367', '鄱阳县', '1358', '1219');
INSERT INTO `wp_area` VALUES ('1368', '万年县', '1358', '1220');
INSERT INTO `wp_area` VALUES ('1369', '婺源县', '1358', '1221');
INSERT INTO `wp_area` VALUES ('1370', '德兴市', '1358', '1222');
INSERT INTO `wp_area` VALUES ('1371', '山东省', '0', '15');
INSERT INTO `wp_area` VALUES ('1372', '济南市', '1371', '135');
INSERT INTO `wp_area` VALUES ('1373', '历下区', '1372', '1223');
INSERT INTO `wp_area` VALUES ('1374', '市中区', '1372', '1224');
INSERT INTO `wp_area` VALUES ('1375', '槐荫区', '1372', '1225');
INSERT INTO `wp_area` VALUES ('1376', '天桥区', '1372', '1226');
INSERT INTO `wp_area` VALUES ('1377', '历城区', '1372', '1227');
INSERT INTO `wp_area` VALUES ('1378', '长清区', '1372', '1228');
INSERT INTO `wp_area` VALUES ('1379', '平阴县', '1372', '1229');
INSERT INTO `wp_area` VALUES ('1380', '济阳县', '1372', '1230');
INSERT INTO `wp_area` VALUES ('1381', '商河县', '1372', '1231');
INSERT INTO `wp_area` VALUES ('1382', '章丘市', '1372', '1232');
INSERT INTO `wp_area` VALUES ('1383', '青岛市', '1371', '136');
INSERT INTO `wp_area` VALUES ('1384', '市南区', '1383', '1233');
INSERT INTO `wp_area` VALUES ('1385', '市北区', '1383', '1234');
INSERT INTO `wp_area` VALUES ('1386', '四方区', '1383', '1235');
INSERT INTO `wp_area` VALUES ('1387', '黄岛区', '1383', '1236');
INSERT INTO `wp_area` VALUES ('1388', '崂山区', '1383', '1237');
INSERT INTO `wp_area` VALUES ('1389', '李沧区', '1383', '1238');
INSERT INTO `wp_area` VALUES ('1390', '城阳区', '1383', '1239');
INSERT INTO `wp_area` VALUES ('1391', '胶州市', '1383', '1240');
INSERT INTO `wp_area` VALUES ('1392', '即墨市', '1383', '1241');
INSERT INTO `wp_area` VALUES ('1393', '平度市', '1383', '1242');
INSERT INTO `wp_area` VALUES ('1394', '胶南市', '1383', '1243');
INSERT INTO `wp_area` VALUES ('1395', '莱西市', '1383', '1244');
INSERT INTO `wp_area` VALUES ('1396', '淄博市', '1371', '137');
INSERT INTO `wp_area` VALUES ('1397', '淄川区', '1396', '1245');
INSERT INTO `wp_area` VALUES ('1398', '张店区', '1396', '1246');
INSERT INTO `wp_area` VALUES ('1399', '博山区', '1396', '1247');
INSERT INTO `wp_area` VALUES ('1400', '临淄区', '1396', '1248');
INSERT INTO `wp_area` VALUES ('1401', '周村区', '1396', '1249');
INSERT INTO `wp_area` VALUES ('1402', '桓台县', '1396', '1250');
INSERT INTO `wp_area` VALUES ('1403', '高青县', '1396', '1251');
INSERT INTO `wp_area` VALUES ('1404', '沂源县', '1396', '1252');
INSERT INTO `wp_area` VALUES ('1405', '枣庄市', '1371', '138');
INSERT INTO `wp_area` VALUES ('1406', '市中区', '1405', '1253');
INSERT INTO `wp_area` VALUES ('1407', '薛城区', '1405', '1254');
INSERT INTO `wp_area` VALUES ('1408', '峄城区', '1405', '1255');
INSERT INTO `wp_area` VALUES ('1409', '台儿庄区', '1405', '1256');
INSERT INTO `wp_area` VALUES ('1410', '山亭区', '1405', '1257');
INSERT INTO `wp_area` VALUES ('1411', '滕州市', '1405', '1258');
INSERT INTO `wp_area` VALUES ('1412', '东营市', '1371', '139');
INSERT INTO `wp_area` VALUES ('1413', '东营区', '1412', '1259');
INSERT INTO `wp_area` VALUES ('1414', '河口区', '1412', '1260');
INSERT INTO `wp_area` VALUES ('1415', '垦利县', '1412', '1261');
INSERT INTO `wp_area` VALUES ('1416', '利津县', '1412', '1262');
INSERT INTO `wp_area` VALUES ('1417', '广饶县', '1412', '1263');
INSERT INTO `wp_area` VALUES ('1418', '烟台市', '1371', '140');
INSERT INTO `wp_area` VALUES ('1419', '芝罘区', '1418', '1264');
INSERT INTO `wp_area` VALUES ('1420', '福山区', '1418', '1265');
INSERT INTO `wp_area` VALUES ('1421', '牟平区', '1418', '1266');
INSERT INTO `wp_area` VALUES ('1422', '莱山区', '1418', '1267');
INSERT INTO `wp_area` VALUES ('1423', '长岛县', '1418', '1268');
INSERT INTO `wp_area` VALUES ('1424', '龙口市', '1418', '1269');
INSERT INTO `wp_area` VALUES ('1425', '莱阳市', '1418', '1270');
INSERT INTO `wp_area` VALUES ('1426', '莱州市', '1418', '1271');
INSERT INTO `wp_area` VALUES ('1427', '蓬莱市', '1418', '1272');
INSERT INTO `wp_area` VALUES ('1428', '招远市', '1418', '1273');
INSERT INTO `wp_area` VALUES ('1429', '栖霞市', '1418', '1274');
INSERT INTO `wp_area` VALUES ('1430', '海阳市', '1418', '1275');
INSERT INTO `wp_area` VALUES ('1431', '潍坊市', '1371', '141');
INSERT INTO `wp_area` VALUES ('1432', '潍城区', '1431', '1276');
INSERT INTO `wp_area` VALUES ('1433', '寒亭区', '1431', '1277');
INSERT INTO `wp_area` VALUES ('1434', '坊子区', '1431', '1278');
INSERT INTO `wp_area` VALUES ('1435', '奎文区', '1431', '1279');
INSERT INTO `wp_area` VALUES ('1436', '临朐县', '1431', '1280');
INSERT INTO `wp_area` VALUES ('1437', '昌乐县', '1431', '1281');
INSERT INTO `wp_area` VALUES ('1438', '青州市', '1431', '1282');
INSERT INTO `wp_area` VALUES ('1439', '诸城市', '1431', '1283');
INSERT INTO `wp_area` VALUES ('1440', '寿光市', '1431', '1284');
INSERT INTO `wp_area` VALUES ('1441', '安丘市', '1431', '1285');
INSERT INTO `wp_area` VALUES ('1442', '高密市', '1431', '1286');
INSERT INTO `wp_area` VALUES ('1443', '昌邑市', '1431', '1287');
INSERT INTO `wp_area` VALUES ('1444', '济宁市', '1371', '142');
INSERT INTO `wp_area` VALUES ('1445', '市中区', '1444', '1288');
INSERT INTO `wp_area` VALUES ('1446', '任城区', '1444', '1289');
INSERT INTO `wp_area` VALUES ('1447', '微山县', '1444', '1290');
INSERT INTO `wp_area` VALUES ('1448', '鱼台县', '1444', '1291');
INSERT INTO `wp_area` VALUES ('1449', '金乡县', '1444', '1292');
INSERT INTO `wp_area` VALUES ('1450', '嘉祥县', '1444', '1293');
INSERT INTO `wp_area` VALUES ('1451', '汶上县', '1444', '1294');
INSERT INTO `wp_area` VALUES ('1452', '泗水县', '1444', '1295');
INSERT INTO `wp_area` VALUES ('1453', '梁山县', '1444', '1296');
INSERT INTO `wp_area` VALUES ('1454', '曲阜市', '1444', '1297');
INSERT INTO `wp_area` VALUES ('1455', '兖州市', '1444', '1298');
INSERT INTO `wp_area` VALUES ('1456', '邹城市', '1444', '1299');
INSERT INTO `wp_area` VALUES ('1457', '泰安市', '1371', '143');
INSERT INTO `wp_area` VALUES ('1458', '泰山区', '1457', '1300');
INSERT INTO `wp_area` VALUES ('1459', '岱岳区', '1457', '1301');
INSERT INTO `wp_area` VALUES ('1460', '宁阳县', '1457', '1302');
INSERT INTO `wp_area` VALUES ('1461', '东平县', '1457', '1303');
INSERT INTO `wp_area` VALUES ('1462', '新泰市', '1457', '1304');
INSERT INTO `wp_area` VALUES ('1463', '肥城市', '1457', '1305');
INSERT INTO `wp_area` VALUES ('1464', '威海市', '1371', '144');
INSERT INTO `wp_area` VALUES ('1465', '环翠区', '1464', '1306');
INSERT INTO `wp_area` VALUES ('1466', '文登市', '1464', '1307');
INSERT INTO `wp_area` VALUES ('1467', '荣成市', '1464', '1308');
INSERT INTO `wp_area` VALUES ('1468', '乳山市', '1464', '1309');
INSERT INTO `wp_area` VALUES ('1469', '日照市', '1371', '145');
INSERT INTO `wp_area` VALUES ('1470', '东港区', '1469', '1310');
INSERT INTO `wp_area` VALUES ('1471', '岚山区', '1469', '1311');
INSERT INTO `wp_area` VALUES ('1472', '五莲县', '1469', '1312');
INSERT INTO `wp_area` VALUES ('1473', '莒县', '1469', '1313');
INSERT INTO `wp_area` VALUES ('1474', '莱芜市', '1371', '146');
INSERT INTO `wp_area` VALUES ('1475', '莱城区', '1474', '1314');
INSERT INTO `wp_area` VALUES ('1476', '钢城区', '1474', '1315');
INSERT INTO `wp_area` VALUES ('1477', '临沂市', '1371', '147');
INSERT INTO `wp_area` VALUES ('1478', '兰山区', '1477', '1316');
INSERT INTO `wp_area` VALUES ('1479', '罗庄区', '1477', '1317');
INSERT INTO `wp_area` VALUES ('1480', '河东区', '1477', '1318');
INSERT INTO `wp_area` VALUES ('1481', '沂南县', '1477', '1319');
INSERT INTO `wp_area` VALUES ('1482', '郯城县', '1477', '1320');
INSERT INTO `wp_area` VALUES ('1483', '沂水县', '1477', '1321');
INSERT INTO `wp_area` VALUES ('1484', '苍山县', '1477', '1322');
INSERT INTO `wp_area` VALUES ('1485', '费县', '1477', '1323');
INSERT INTO `wp_area` VALUES ('1486', '平邑县', '1477', '1324');
INSERT INTO `wp_area` VALUES ('1487', '莒南县', '1477', '1325');
INSERT INTO `wp_area` VALUES ('1488', '蒙阴县', '1477', '1326');
INSERT INTO `wp_area` VALUES ('1489', '临沭县', '1477', '1327');
INSERT INTO `wp_area` VALUES ('1490', '德州市', '1371', '148');
INSERT INTO `wp_area` VALUES ('1491', '德城区', '1490', '1328');
INSERT INTO `wp_area` VALUES ('1492', '陵县', '1490', '1329');
INSERT INTO `wp_area` VALUES ('1493', '宁津县', '1490', '1330');
INSERT INTO `wp_area` VALUES ('1494', '庆云县', '1490', '1331');
INSERT INTO `wp_area` VALUES ('1495', '临邑县', '1490', '1332');
INSERT INTO `wp_area` VALUES ('1496', '齐河县', '1490', '1333');
INSERT INTO `wp_area` VALUES ('1497', '平原县', '1490', '1334');
INSERT INTO `wp_area` VALUES ('1498', '夏津县', '1490', '1335');
INSERT INTO `wp_area` VALUES ('1499', '武城县', '1490', '1336');
INSERT INTO `wp_area` VALUES ('1500', '乐陵市', '1490', '1337');
INSERT INTO `wp_area` VALUES ('1501', '禹城市', '1490', '1338');
INSERT INTO `wp_area` VALUES ('1502', '聊城市', '1371', '149');
INSERT INTO `wp_area` VALUES ('1503', '东昌府区', '1502', '1339');
INSERT INTO `wp_area` VALUES ('1504', '阳谷县', '1502', '1340');
INSERT INTO `wp_area` VALUES ('1505', '莘县', '1502', '1341');
INSERT INTO `wp_area` VALUES ('1506', '茌平县', '1502', '1342');
INSERT INTO `wp_area` VALUES ('1507', '东阿县', '1502', '1343');
INSERT INTO `wp_area` VALUES ('1508', '冠县', '1502', '1344');
INSERT INTO `wp_area` VALUES ('1509', '高唐县', '1502', '1345');
INSERT INTO `wp_area` VALUES ('1510', '临清市', '1502', '1346');
INSERT INTO `wp_area` VALUES ('1511', '滨州市', '1371', '150');
INSERT INTO `wp_area` VALUES ('1512', '滨城区', '1511', '1347');
INSERT INTO `wp_area` VALUES ('1513', '惠民县', '1511', '1348');
INSERT INTO `wp_area` VALUES ('1514', '阳信县', '1511', '1349');
INSERT INTO `wp_area` VALUES ('1515', '无棣县', '1511', '1350');
INSERT INTO `wp_area` VALUES ('1516', '沾化县', '1511', '1351');
INSERT INTO `wp_area` VALUES ('1517', '博兴县', '1511', '1352');
INSERT INTO `wp_area` VALUES ('1518', '邹平县', '1511', '1353');
INSERT INTO `wp_area` VALUES ('1519', '荷泽市', '1371', '151');
INSERT INTO `wp_area` VALUES ('1520', '牡丹区', '1519', '1354');
INSERT INTO `wp_area` VALUES ('1521', '曹县', '1519', '1355');
INSERT INTO `wp_area` VALUES ('1522', '单县', '1519', '1356');
INSERT INTO `wp_area` VALUES ('1523', '成武县', '1519', '1357');
INSERT INTO `wp_area` VALUES ('1524', '巨野县', '1519', '1358');
INSERT INTO `wp_area` VALUES ('1525', '郓城县', '1519', '1359');
INSERT INTO `wp_area` VALUES ('1526', '鄄城县', '1519', '1360');
INSERT INTO `wp_area` VALUES ('1527', '定陶县', '1519', '1361');
INSERT INTO `wp_area` VALUES ('1528', '东明县', '1519', '1362');
INSERT INTO `wp_area` VALUES ('1529', '河南省', '0', '16');
INSERT INTO `wp_area` VALUES ('1530', '郑州市', '1529', '152');
INSERT INTO `wp_area` VALUES ('1531', '中原区', '1530', '1363');
INSERT INTO `wp_area` VALUES ('1532', '二七区', '1530', '1364');
INSERT INTO `wp_area` VALUES ('1533', '管城回族区', '1530', '1365');
INSERT INTO `wp_area` VALUES ('1534', '金水区', '1530', '1366');
INSERT INTO `wp_area` VALUES ('1535', '上街区', '1530', '1367');
INSERT INTO `wp_area` VALUES ('1536', '惠济区', '1530', '1368');
INSERT INTO `wp_area` VALUES ('1537', '中牟县', '1530', '1369');
INSERT INTO `wp_area` VALUES ('1538', '巩义市', '1530', '1370');
INSERT INTO `wp_area` VALUES ('1539', '荥阳市', '1530', '1371');
INSERT INTO `wp_area` VALUES ('1540', '新密市', '1530', '1372');
INSERT INTO `wp_area` VALUES ('1541', '新郑市', '1530', '1373');
INSERT INTO `wp_area` VALUES ('1542', '登封市', '1530', '1374');
INSERT INTO `wp_area` VALUES ('1543', '开封市', '1529', '153');
INSERT INTO `wp_area` VALUES ('1544', '龙亭区', '1543', '1375');
INSERT INTO `wp_area` VALUES ('1545', '顺河回族区', '1543', '1376');
INSERT INTO `wp_area` VALUES ('1546', '鼓楼区', '1543', '1377');
INSERT INTO `wp_area` VALUES ('1547', '南关区', '1543', '1378');
INSERT INTO `wp_area` VALUES ('1548', '郊区', '1543', '1379');
INSERT INTO `wp_area` VALUES ('1549', '杞县', '1543', '1380');
INSERT INTO `wp_area` VALUES ('1550', '通许县', '1543', '1381');
INSERT INTO `wp_area` VALUES ('1551', '尉氏县', '1543', '1382');
INSERT INTO `wp_area` VALUES ('1552', '开封县', '1543', '1383');
INSERT INTO `wp_area` VALUES ('1553', '兰考县', '1543', '1384');
INSERT INTO `wp_area` VALUES ('1554', '洛阳市', '1529', '154');
INSERT INTO `wp_area` VALUES ('1555', '老城区', '1554', '1385');
INSERT INTO `wp_area` VALUES ('1556', '西工区', '1554', '1386');
INSERT INTO `wp_area` VALUES ('1557', '廛河回族区', '1554', '1387');
INSERT INTO `wp_area` VALUES ('1558', '涧西区', '1554', '1388');
INSERT INTO `wp_area` VALUES ('1559', '吉利区', '1554', '1389');
INSERT INTO `wp_area` VALUES ('1560', '洛龙区', '1554', '1390');
INSERT INTO `wp_area` VALUES ('1561', '孟津县', '1554', '1391');
INSERT INTO `wp_area` VALUES ('1562', '新安县', '1554', '1392');
INSERT INTO `wp_area` VALUES ('1563', '栾川县', '1554', '1393');
INSERT INTO `wp_area` VALUES ('1564', '嵩县', '1554', '1394');
INSERT INTO `wp_area` VALUES ('1565', '汝阳县', '1554', '1395');
INSERT INTO `wp_area` VALUES ('1566', '宜阳县', '1554', '1396');
INSERT INTO `wp_area` VALUES ('1567', '洛宁县', '1554', '1397');
INSERT INTO `wp_area` VALUES ('1568', '伊川县', '1554', '1398');
INSERT INTO `wp_area` VALUES ('1569', '偃师市', '1554', '1399');
INSERT INTO `wp_area` VALUES ('1570', '平顶山市', '1529', '155');
INSERT INTO `wp_area` VALUES ('1571', '新华区', '1570', '1400');
INSERT INTO `wp_area` VALUES ('1572', '卫东区', '1570', '1401');
INSERT INTO `wp_area` VALUES ('1573', '石龙区', '1570', '1402');
INSERT INTO `wp_area` VALUES ('1574', '湛河区', '1570', '1403');
INSERT INTO `wp_area` VALUES ('1575', '宝丰县', '1570', '1404');
INSERT INTO `wp_area` VALUES ('1576', '叶县', '1570', '1405');
INSERT INTO `wp_area` VALUES ('1577', '鲁山县', '1570', '1406');
INSERT INTO `wp_area` VALUES ('1578', '郏县', '1570', '1407');
INSERT INTO `wp_area` VALUES ('1579', '舞钢市', '1570', '1408');
INSERT INTO `wp_area` VALUES ('1580', '汝州市', '1570', '1409');
INSERT INTO `wp_area` VALUES ('1581', '安阳市', '1529', '156');
INSERT INTO `wp_area` VALUES ('1582', '文峰区', '1581', '1410');
INSERT INTO `wp_area` VALUES ('1583', '北关区', '1581', '1411');
INSERT INTO `wp_area` VALUES ('1584', '殷都区', '1581', '1412');
INSERT INTO `wp_area` VALUES ('1585', '龙安区', '1581', '1413');
INSERT INTO `wp_area` VALUES ('1586', '安阳县', '1581', '1414');
INSERT INTO `wp_area` VALUES ('1587', '汤阴县', '1581', '1415');
INSERT INTO `wp_area` VALUES ('1588', '滑县', '1581', '1416');
INSERT INTO `wp_area` VALUES ('1589', '内黄县', '1581', '1417');
INSERT INTO `wp_area` VALUES ('1590', '林州市', '1581', '1418');
INSERT INTO `wp_area` VALUES ('1591', '鹤壁市', '1529', '157');
INSERT INTO `wp_area` VALUES ('1592', '鹤山区', '1591', '1419');
INSERT INTO `wp_area` VALUES ('1593', '山城区', '1591', '1420');
INSERT INTO `wp_area` VALUES ('1594', '淇滨区', '1591', '1421');
INSERT INTO `wp_area` VALUES ('1595', '浚县', '1591', '1422');
INSERT INTO `wp_area` VALUES ('1596', '淇县', '1591', '1423');
INSERT INTO `wp_area` VALUES ('1597', '新乡市', '1529', '158');
INSERT INTO `wp_area` VALUES ('1598', '红旗区', '1597', '1424');
INSERT INTO `wp_area` VALUES ('1599', '卫滨区', '1597', '1425');
INSERT INTO `wp_area` VALUES ('1600', '凤泉区', '1597', '1426');
INSERT INTO `wp_area` VALUES ('1601', '牧野区', '1597', '1427');
INSERT INTO `wp_area` VALUES ('1602', '新乡县', '1597', '1428');
INSERT INTO `wp_area` VALUES ('1603', '获嘉县', '1597', '1429');
INSERT INTO `wp_area` VALUES ('1604', '原阳县', '1597', '1430');
INSERT INTO `wp_area` VALUES ('1605', '延津县', '1597', '1431');
INSERT INTO `wp_area` VALUES ('1606', '封丘县', '1597', '1432');
INSERT INTO `wp_area` VALUES ('1607', '长垣县', '1597', '1433');
INSERT INTO `wp_area` VALUES ('1608', '卫辉市', '1597', '1434');
INSERT INTO `wp_area` VALUES ('1609', '辉县市', '1597', '1435');
INSERT INTO `wp_area` VALUES ('1610', '焦作市', '1529', '159');
INSERT INTO `wp_area` VALUES ('1611', '解放区', '1610', '1436');
INSERT INTO `wp_area` VALUES ('1612', '中站区', '1610', '1437');
INSERT INTO `wp_area` VALUES ('1613', '马村区', '1610', '1438');
INSERT INTO `wp_area` VALUES ('1614', '山阳区', '1610', '1439');
INSERT INTO `wp_area` VALUES ('1615', '修武县', '1610', '1440');
INSERT INTO `wp_area` VALUES ('1616', '博爱县', '1610', '1441');
INSERT INTO `wp_area` VALUES ('1617', '武陟县', '1610', '1442');
INSERT INTO `wp_area` VALUES ('1618', '温县', '1610', '1443');
INSERT INTO `wp_area` VALUES ('1619', '济源市', '1610', '1444');
INSERT INTO `wp_area` VALUES ('1620', '沁阳市', '1610', '1445');
INSERT INTO `wp_area` VALUES ('1621', '孟州市', '1610', '1446');
INSERT INTO `wp_area` VALUES ('1622', '濮阳市', '1529', '160');
INSERT INTO `wp_area` VALUES ('1623', '华龙区', '1622', '1447');
INSERT INTO `wp_area` VALUES ('1624', '清丰县', '1622', '1448');
INSERT INTO `wp_area` VALUES ('1625', '南乐县', '1622', '1449');
INSERT INTO `wp_area` VALUES ('1626', '范县', '1622', '1450');
INSERT INTO `wp_area` VALUES ('1627', '台前县', '1622', '1451');
INSERT INTO `wp_area` VALUES ('1628', '濮阳县', '1622', '1452');
INSERT INTO `wp_area` VALUES ('1629', '许昌市', '1529', '161');
INSERT INTO `wp_area` VALUES ('1630', '魏都区', '1629', '1453');
INSERT INTO `wp_area` VALUES ('1631', '许昌县', '1629', '1454');
INSERT INTO `wp_area` VALUES ('1632', '鄢陵县', '1629', '1455');
INSERT INTO `wp_area` VALUES ('1633', '襄城县', '1629', '1456');
INSERT INTO `wp_area` VALUES ('1634', '禹州市', '1629', '1457');
INSERT INTO `wp_area` VALUES ('1635', '长葛市', '1629', '1458');
INSERT INTO `wp_area` VALUES ('1636', '漯河市', '1529', '162');
INSERT INTO `wp_area` VALUES ('1637', '源汇区', '1636', '1459');
INSERT INTO `wp_area` VALUES ('1638', '郾城区', '1636', '1460');
INSERT INTO `wp_area` VALUES ('1639', '召陵区', '1636', '1461');
INSERT INTO `wp_area` VALUES ('1640', '舞阳县', '1636', '1462');
INSERT INTO `wp_area` VALUES ('1641', '临颍县', '1636', '1463');
INSERT INTO `wp_area` VALUES ('1642', '三门峡市', '1529', '163');
INSERT INTO `wp_area` VALUES ('1643', '市辖区', '1642', '1464');
INSERT INTO `wp_area` VALUES ('1644', '湖滨区', '1642', '1465');
INSERT INTO `wp_area` VALUES ('1645', '渑池县', '1642', '1466');
INSERT INTO `wp_area` VALUES ('1646', '陕县', '1642', '1467');
INSERT INTO `wp_area` VALUES ('1647', '卢氏县', '1642', '1468');
INSERT INTO `wp_area` VALUES ('1648', '义马市', '1642', '1469');
INSERT INTO `wp_area` VALUES ('1649', '灵宝市', '1642', '1470');
INSERT INTO `wp_area` VALUES ('1650', '南阳市', '1529', '164');
INSERT INTO `wp_area` VALUES ('1651', '宛城区', '1650', '1471');
INSERT INTO `wp_area` VALUES ('1652', '卧龙区', '1650', '1472');
INSERT INTO `wp_area` VALUES ('1653', '南召县', '1650', '1473');
INSERT INTO `wp_area` VALUES ('1654', '方城县', '1650', '1474');
INSERT INTO `wp_area` VALUES ('1655', '西峡县', '1650', '1475');
INSERT INTO `wp_area` VALUES ('1656', '镇平县', '1650', '1476');
INSERT INTO `wp_area` VALUES ('1657', '内乡县', '1650', '1477');
INSERT INTO `wp_area` VALUES ('1658', '淅川县', '1650', '1478');
INSERT INTO `wp_area` VALUES ('1659', '社旗县', '1650', '1479');
INSERT INTO `wp_area` VALUES ('1660', '唐河县', '1650', '1480');
INSERT INTO `wp_area` VALUES ('1661', '新野县', '1650', '1481');
INSERT INTO `wp_area` VALUES ('1662', '桐柏县', '1650', '1482');
INSERT INTO `wp_area` VALUES ('1663', '邓州市', '1650', '1483');
INSERT INTO `wp_area` VALUES ('1664', '商丘市', '1529', '165');
INSERT INTO `wp_area` VALUES ('1665', '梁园区', '1664', '1484');
INSERT INTO `wp_area` VALUES ('1666', '睢阳区', '1664', '1485');
INSERT INTO `wp_area` VALUES ('1667', '民权县', '1664', '1486');
INSERT INTO `wp_area` VALUES ('1668', '睢县', '1664', '1487');
INSERT INTO `wp_area` VALUES ('1669', '宁陵县', '1664', '1488');
INSERT INTO `wp_area` VALUES ('1670', '柘城县', '1664', '1489');
INSERT INTO `wp_area` VALUES ('1671', '虞城县', '1664', '1490');
INSERT INTO `wp_area` VALUES ('1672', '夏邑县', '1664', '1491');
INSERT INTO `wp_area` VALUES ('1673', '永城市', '1664', '1492');
INSERT INTO `wp_area` VALUES ('1674', '信阳市', '1529', '166');
INSERT INTO `wp_area` VALUES ('1675', '浉河区', '1674', '1493');
INSERT INTO `wp_area` VALUES ('1676', '平桥区', '1674', '1494');
INSERT INTO `wp_area` VALUES ('1677', '罗山县', '1674', '1495');
INSERT INTO `wp_area` VALUES ('1678', '光山县', '1674', '1496');
INSERT INTO `wp_area` VALUES ('1679', '新县', '1674', '1497');
INSERT INTO `wp_area` VALUES ('1680', '商城县', '1674', '1498');
INSERT INTO `wp_area` VALUES ('1681', '固始县', '1674', '1499');
INSERT INTO `wp_area` VALUES ('1682', '潢川县', '1674', '1500');
INSERT INTO `wp_area` VALUES ('1683', '淮滨县', '1674', '1501');
INSERT INTO `wp_area` VALUES ('1684', '息县', '1674', '1502');
INSERT INTO `wp_area` VALUES ('1685', '周口市', '1529', '167');
INSERT INTO `wp_area` VALUES ('1686', '川汇区', '1685', '1503');
INSERT INTO `wp_area` VALUES ('1687', '扶沟县', '1685', '1504');
INSERT INTO `wp_area` VALUES ('1688', '西华县', '1685', '1505');
INSERT INTO `wp_area` VALUES ('1689', '商水县', '1685', '1506');
INSERT INTO `wp_area` VALUES ('1690', '沈丘县', '1685', '1507');
INSERT INTO `wp_area` VALUES ('1691', '郸城县', '1685', '1508');
INSERT INTO `wp_area` VALUES ('1692', '淮阳县', '1685', '1509');
INSERT INTO `wp_area` VALUES ('1693', '太康县', '1685', '1510');
INSERT INTO `wp_area` VALUES ('1694', '鹿邑县', '1685', '1511');
INSERT INTO `wp_area` VALUES ('1695', '项城市', '1685', '1512');
INSERT INTO `wp_area` VALUES ('1696', '驻马店市', '1529', '168');
INSERT INTO `wp_area` VALUES ('1697', '驿城区', '1696', '1513');
INSERT INTO `wp_area` VALUES ('1698', '西平县', '1696', '1514');
INSERT INTO `wp_area` VALUES ('1699', '上蔡县', '1696', '1515');
INSERT INTO `wp_area` VALUES ('1700', '平舆县', '1696', '1516');
INSERT INTO `wp_area` VALUES ('1701', '正阳县', '1696', '1517');
INSERT INTO `wp_area` VALUES ('1702', '确山县', '1696', '1518');
INSERT INTO `wp_area` VALUES ('1703', '泌阳县', '1696', '1519');
INSERT INTO `wp_area` VALUES ('1704', '汝南县', '1696', '1520');
INSERT INTO `wp_area` VALUES ('1705', '遂平县', '1696', '1521');
INSERT INTO `wp_area` VALUES ('1706', '新蔡县', '1696', '1522');
INSERT INTO `wp_area` VALUES ('1707', '湖北省', '0', '17');
INSERT INTO `wp_area` VALUES ('1708', '武汉市', '1707', '169');
INSERT INTO `wp_area` VALUES ('1709', '江岸区', '1708', '1523');
INSERT INTO `wp_area` VALUES ('1710', '江汉区', '1708', '1524');
INSERT INTO `wp_area` VALUES ('1711', '硚口区', '1708', '1525');
INSERT INTO `wp_area` VALUES ('1712', '汉阳区', '1708', '1526');
INSERT INTO `wp_area` VALUES ('1713', '武昌区', '1708', '1527');
INSERT INTO `wp_area` VALUES ('1714', '青山区', '1708', '1528');
INSERT INTO `wp_area` VALUES ('1715', '洪山区', '1708', '1529');
INSERT INTO `wp_area` VALUES ('1716', '东西湖区', '1708', '1530');
INSERT INTO `wp_area` VALUES ('1717', '汉南区', '1708', '1531');
INSERT INTO `wp_area` VALUES ('1718', '蔡甸区', '1708', '1532');
INSERT INTO `wp_area` VALUES ('1719', '江夏区', '1708', '1533');
INSERT INTO `wp_area` VALUES ('1720', '黄陂区', '1708', '1534');
INSERT INTO `wp_area` VALUES ('1721', '新洲区', '1708', '1535');
INSERT INTO `wp_area` VALUES ('1722', '黄石市', '1707', '170');
INSERT INTO `wp_area` VALUES ('1723', '黄石港区', '1722', '1536');
INSERT INTO `wp_area` VALUES ('1724', '西塞山区', '1722', '1537');
INSERT INTO `wp_area` VALUES ('1725', '下陆区', '1722', '1538');
INSERT INTO `wp_area` VALUES ('1726', '铁山区', '1722', '1539');
INSERT INTO `wp_area` VALUES ('1727', '阳新县', '1722', '1540');
INSERT INTO `wp_area` VALUES ('1728', '大冶市', '1722', '1541');
INSERT INTO `wp_area` VALUES ('1729', '十堰市', '1707', '171');
INSERT INTO `wp_area` VALUES ('1730', '茅箭区', '1729', '1542');
INSERT INTO `wp_area` VALUES ('1731', '张湾区', '1729', '1543');
INSERT INTO `wp_area` VALUES ('1732', '郧县', '1729', '1544');
INSERT INTO `wp_area` VALUES ('1733', '郧西县', '1729', '1545');
INSERT INTO `wp_area` VALUES ('1734', '竹山县', '1729', '1546');
INSERT INTO `wp_area` VALUES ('1735', '竹溪县', '1729', '1547');
INSERT INTO `wp_area` VALUES ('1736', '房县', '1729', '1548');
INSERT INTO `wp_area` VALUES ('1737', '丹江口市', '1729', '1549');
INSERT INTO `wp_area` VALUES ('1738', '宜昌市', '1707', '172');
INSERT INTO `wp_area` VALUES ('1739', '西陵区', '1738', '1550');
INSERT INTO `wp_area` VALUES ('1740', '伍家岗区', '1738', '1551');
INSERT INTO `wp_area` VALUES ('1741', '点军区', '1738', '1552');
INSERT INTO `wp_area` VALUES ('1742', '猇亭区', '1738', '1553');
INSERT INTO `wp_area` VALUES ('1743', '夷陵区', '1738', '1554');
INSERT INTO `wp_area` VALUES ('1744', '远安县', '1738', '1555');
INSERT INTO `wp_area` VALUES ('1745', '兴山县', '1738', '1556');
INSERT INTO `wp_area` VALUES ('1746', '秭归县', '1738', '1557');
INSERT INTO `wp_area` VALUES ('1747', '长阳土家族自治县', '1738', '1558');
INSERT INTO `wp_area` VALUES ('1748', '五峰土家族自治县', '1738', '1559');
INSERT INTO `wp_area` VALUES ('1749', '宜都市', '1738', '1560');
INSERT INTO `wp_area` VALUES ('1750', '当阳市', '1738', '1561');
INSERT INTO `wp_area` VALUES ('1751', '枝江市', '1738', '1562');
INSERT INTO `wp_area` VALUES ('1752', '襄樊市', '1707', '173');
INSERT INTO `wp_area` VALUES ('1753', '襄城区', '1752', '1563');
INSERT INTO `wp_area` VALUES ('1754', '樊城区', '1752', '1564');
INSERT INTO `wp_area` VALUES ('1755', '襄阳区', '1752', '1565');
INSERT INTO `wp_area` VALUES ('1756', '南漳县', '1752', '1566');
INSERT INTO `wp_area` VALUES ('1757', '谷城县', '1752', '1567');
INSERT INTO `wp_area` VALUES ('1758', '保康县', '1752', '1568');
INSERT INTO `wp_area` VALUES ('1759', '老河口市', '1752', '1569');
INSERT INTO `wp_area` VALUES ('1760', '枣阳市', '1752', '1570');
INSERT INTO `wp_area` VALUES ('1761', '宜城市', '1752', '1571');
INSERT INTO `wp_area` VALUES ('1762', '鄂州市', '1707', '174');
INSERT INTO `wp_area` VALUES ('1763', '梁子湖区', '1762', '1572');
INSERT INTO `wp_area` VALUES ('1764', '华容区', '1762', '1573');
INSERT INTO `wp_area` VALUES ('1765', '鄂城区', '1762', '1574');
INSERT INTO `wp_area` VALUES ('1766', '荆门市', '1707', '175');
INSERT INTO `wp_area` VALUES ('1767', '东宝区', '1766', '1575');
INSERT INTO `wp_area` VALUES ('1768', '掇刀区', '1766', '1576');
INSERT INTO `wp_area` VALUES ('1769', '京山县', '1766', '1577');
INSERT INTO `wp_area` VALUES ('1770', '沙洋县', '1766', '1578');
INSERT INTO `wp_area` VALUES ('1771', '钟祥市', '1766', '1579');
INSERT INTO `wp_area` VALUES ('1772', '孝感市', '1707', '176');
INSERT INTO `wp_area` VALUES ('1773', '孝南区', '1772', '1580');
INSERT INTO `wp_area` VALUES ('1774', '孝昌县', '1772', '1581');
INSERT INTO `wp_area` VALUES ('1775', '大悟县', '1772', '1582');
INSERT INTO `wp_area` VALUES ('1776', '云梦县', '1772', '1583');
INSERT INTO `wp_area` VALUES ('1777', '应城市', '1772', '1584');
INSERT INTO `wp_area` VALUES ('1778', '安陆市', '1772', '1585');
INSERT INTO `wp_area` VALUES ('1779', '汉川市', '1772', '1586');
INSERT INTO `wp_area` VALUES ('1780', '荆州市', '1707', '177');
INSERT INTO `wp_area` VALUES ('1781', '沙市区', '1780', '1587');
INSERT INTO `wp_area` VALUES ('1782', '荆州区', '1780', '1588');
INSERT INTO `wp_area` VALUES ('1783', '公安县', '1780', '1589');
INSERT INTO `wp_area` VALUES ('1784', '监利县', '1780', '1590');
INSERT INTO `wp_area` VALUES ('1785', '江陵县', '1780', '1591');
INSERT INTO `wp_area` VALUES ('1786', '石首市', '1780', '1592');
INSERT INTO `wp_area` VALUES ('1787', '洪湖市', '1780', '1593');
INSERT INTO `wp_area` VALUES ('1788', '松滋市', '1780', '1594');
INSERT INTO `wp_area` VALUES ('1789', '黄冈市', '1707', '178');
INSERT INTO `wp_area` VALUES ('1790', '黄州区', '1789', '1595');
INSERT INTO `wp_area` VALUES ('1791', '团风县', '1789', '1596');
INSERT INTO `wp_area` VALUES ('1792', '红安县', '1789', '1597');
INSERT INTO `wp_area` VALUES ('1793', '罗田县', '1789', '1598');
INSERT INTO `wp_area` VALUES ('1794', '英山县', '1789', '1599');
INSERT INTO `wp_area` VALUES ('1795', '浠水县', '1789', '1600');
INSERT INTO `wp_area` VALUES ('1796', '蕲春县', '1789', '1601');
INSERT INTO `wp_area` VALUES ('1797', '黄梅县', '1789', '1602');
INSERT INTO `wp_area` VALUES ('1798', '麻城市', '1789', '1603');
INSERT INTO `wp_area` VALUES ('1799', '武穴市', '1789', '1604');
INSERT INTO `wp_area` VALUES ('1800', '咸宁市', '1707', '179');
INSERT INTO `wp_area` VALUES ('1801', '咸安区', '1800', '1605');
INSERT INTO `wp_area` VALUES ('1802', '嘉鱼县', '1800', '1606');
INSERT INTO `wp_area` VALUES ('1803', '通城县', '1800', '1607');
INSERT INTO `wp_area` VALUES ('1804', '崇阳县', '1800', '1608');
INSERT INTO `wp_area` VALUES ('1805', '通山县', '1800', '1609');
INSERT INTO `wp_area` VALUES ('1806', '赤壁市', '1800', '1610');
INSERT INTO `wp_area` VALUES ('1807', '随州市', '1707', '180');
INSERT INTO `wp_area` VALUES ('1808', '曾都区', '1807', '1611');
INSERT INTO `wp_area` VALUES ('1809', '广水市', '1807', '1612');
INSERT INTO `wp_area` VALUES ('1810', '恩施土家族苗族自治州', '1707', '181');
INSERT INTO `wp_area` VALUES ('1811', '恩施市', '1810', '1613');
INSERT INTO `wp_area` VALUES ('1812', '利川市', '1810', '1614');
INSERT INTO `wp_area` VALUES ('1813', '建始县', '1810', '1615');
INSERT INTO `wp_area` VALUES ('1814', '巴东县', '1810', '1616');
INSERT INTO `wp_area` VALUES ('1815', '宣恩县', '1810', '1617');
INSERT INTO `wp_area` VALUES ('1816', '咸丰县', '1810', '1618');
INSERT INTO `wp_area` VALUES ('1817', '来凤县', '1810', '1619');
INSERT INTO `wp_area` VALUES ('1818', '鹤峰县', '1810', '1620');
INSERT INTO `wp_area` VALUES ('1819', '神农架', '1707', '182');
INSERT INTO `wp_area` VALUES ('1820', '仙桃市', '1819', '1621');
INSERT INTO `wp_area` VALUES ('1821', '潜江市', '1819', '1622');
INSERT INTO `wp_area` VALUES ('1822', '天门市', '1819', '1623');
INSERT INTO `wp_area` VALUES ('1823', '神农架林区', '1819', '1624');
INSERT INTO `wp_area` VALUES ('1824', '湖南省', '0', '18');
INSERT INTO `wp_area` VALUES ('1825', '长沙市', '1824', '183');
INSERT INTO `wp_area` VALUES ('1826', '芙蓉区', '1825', '1625');
INSERT INTO `wp_area` VALUES ('1827', '天心区', '1825', '1626');
INSERT INTO `wp_area` VALUES ('1828', '岳麓区', '1825', '1627');
INSERT INTO `wp_area` VALUES ('1829', '开福区', '1825', '1628');
INSERT INTO `wp_area` VALUES ('1830', '雨花区', '1825', '1629');
INSERT INTO `wp_area` VALUES ('1831', '长沙县', '1825', '1630');
INSERT INTO `wp_area` VALUES ('1832', '望城县', '1825', '1631');
INSERT INTO `wp_area` VALUES ('1833', '宁乡县', '1825', '1632');
INSERT INTO `wp_area` VALUES ('1834', '浏阳市', '1825', '1633');
INSERT INTO `wp_area` VALUES ('1835', '株洲市', '1824', '184');
INSERT INTO `wp_area` VALUES ('1836', '荷塘区', '1835', '1634');
INSERT INTO `wp_area` VALUES ('1837', '芦淞区', '1835', '1635');
INSERT INTO `wp_area` VALUES ('1838', '石峰区', '1835', '1636');
INSERT INTO `wp_area` VALUES ('1839', '天元区', '1835', '1637');
INSERT INTO `wp_area` VALUES ('1840', '株洲县', '1835', '1638');
INSERT INTO `wp_area` VALUES ('1841', '攸县', '1835', '1639');
INSERT INTO `wp_area` VALUES ('1842', '茶陵县', '1835', '1640');
INSERT INTO `wp_area` VALUES ('1843', '炎陵县', '1835', '1641');
INSERT INTO `wp_area` VALUES ('1844', '醴陵市', '1835', '1642');
INSERT INTO `wp_area` VALUES ('1845', '湘潭市', '1824', '185');
INSERT INTO `wp_area` VALUES ('1846', '雨湖区', '1845', '1643');
INSERT INTO `wp_area` VALUES ('1847', '岳塘区', '1845', '1644');
INSERT INTO `wp_area` VALUES ('1848', '湘潭县', '1845', '1645');
INSERT INTO `wp_area` VALUES ('1849', '湘乡市', '1845', '1646');
INSERT INTO `wp_area` VALUES ('1850', '韶山市', '1845', '1647');
INSERT INTO `wp_area` VALUES ('1851', '衡阳市', '1824', '186');
INSERT INTO `wp_area` VALUES ('1852', '珠晖区', '1851', '1648');
INSERT INTO `wp_area` VALUES ('1853', '雁峰区', '1851', '1649');
INSERT INTO `wp_area` VALUES ('1854', '石鼓区', '1851', '1650');
INSERT INTO `wp_area` VALUES ('1855', '蒸湘区', '1851', '1651');
INSERT INTO `wp_area` VALUES ('1856', '南岳区', '1851', '1652');
INSERT INTO `wp_area` VALUES ('1857', '衡阳县', '1851', '1653');
INSERT INTO `wp_area` VALUES ('1858', '衡南县', '1851', '1654');
INSERT INTO `wp_area` VALUES ('1859', '衡山县', '1851', '1655');
INSERT INTO `wp_area` VALUES ('1860', '衡东县', '1851', '1656');
INSERT INTO `wp_area` VALUES ('1861', '祁东县', '1851', '1657');
INSERT INTO `wp_area` VALUES ('1862', '耒阳市', '1851', '1658');
INSERT INTO `wp_area` VALUES ('1863', '常宁市', '1851', '1659');
INSERT INTO `wp_area` VALUES ('1864', '邵阳市', '1824', '187');
INSERT INTO `wp_area` VALUES ('1865', '双清区', '1864', '1660');
INSERT INTO `wp_area` VALUES ('1866', '大祥区', '1864', '1661');
INSERT INTO `wp_area` VALUES ('1867', '北塔区', '1864', '1662');
INSERT INTO `wp_area` VALUES ('1868', '邵东县', '1864', '1663');
INSERT INTO `wp_area` VALUES ('1869', '新邵县', '1864', '1664');
INSERT INTO `wp_area` VALUES ('1870', '邵阳县', '1864', '1665');
INSERT INTO `wp_area` VALUES ('1871', '隆回县', '1864', '1666');
INSERT INTO `wp_area` VALUES ('1872', '洞口县', '1864', '1667');
INSERT INTO `wp_area` VALUES ('1873', '绥宁县', '1864', '1668');
INSERT INTO `wp_area` VALUES ('1874', '新宁县', '1864', '1669');
INSERT INTO `wp_area` VALUES ('1875', '城步苗族自治县', '1864', '1670');
INSERT INTO `wp_area` VALUES ('1876', '武冈市', '1864', '1671');
INSERT INTO `wp_area` VALUES ('1877', '岳阳市', '1824', '188');
INSERT INTO `wp_area` VALUES ('1878', '岳阳楼区', '1877', '1672');
INSERT INTO `wp_area` VALUES ('1879', '云溪区', '1877', '1673');
INSERT INTO `wp_area` VALUES ('1880', '君山区', '1877', '1674');
INSERT INTO `wp_area` VALUES ('1881', '岳阳县', '1877', '1675');
INSERT INTO `wp_area` VALUES ('1882', '华容县', '1877', '1676');
INSERT INTO `wp_area` VALUES ('1883', '湘阴县', '1877', '1677');
INSERT INTO `wp_area` VALUES ('1884', '平江县', '1877', '1678');
INSERT INTO `wp_area` VALUES ('1885', '汨罗市', '1877', '1679');
INSERT INTO `wp_area` VALUES ('1886', '临湘市', '1877', '1680');
INSERT INTO `wp_area` VALUES ('1887', '常德市', '1824', '189');
INSERT INTO `wp_area` VALUES ('1888', '武陵区', '1887', '1681');
INSERT INTO `wp_area` VALUES ('1889', '鼎城区', '1887', '1682');
INSERT INTO `wp_area` VALUES ('1890', '安乡县', '1887', '1683');
INSERT INTO `wp_area` VALUES ('1891', '汉寿县', '1887', '1684');
INSERT INTO `wp_area` VALUES ('1892', '澧县', '1887', '1685');
INSERT INTO `wp_area` VALUES ('1893', '临澧县', '1887', '1686');
INSERT INTO `wp_area` VALUES ('1894', '桃源县', '1887', '1687');
INSERT INTO `wp_area` VALUES ('1895', '石门县', '1887', '1688');
INSERT INTO `wp_area` VALUES ('1896', '津市市', '1887', '1689');
INSERT INTO `wp_area` VALUES ('1897', '张家界市', '1824', '190');
INSERT INTO `wp_area` VALUES ('1898', '永定区', '1897', '1690');
INSERT INTO `wp_area` VALUES ('1899', '武陵源区', '1897', '1691');
INSERT INTO `wp_area` VALUES ('1900', '慈利县', '1897', '1692');
INSERT INTO `wp_area` VALUES ('1901', '桑植县', '1897', '1693');
INSERT INTO `wp_area` VALUES ('1902', '益阳市', '1824', '191');
INSERT INTO `wp_area` VALUES ('1903', '资阳区', '1902', '1694');
INSERT INTO `wp_area` VALUES ('1904', '赫山区', '1902', '1695');
INSERT INTO `wp_area` VALUES ('1905', '南县', '1902', '1696');
INSERT INTO `wp_area` VALUES ('1906', '桃江县', '1902', '1697');
INSERT INTO `wp_area` VALUES ('1907', '安化县', '1902', '1698');
INSERT INTO `wp_area` VALUES ('1908', '沅江市', '1902', '1699');
INSERT INTO `wp_area` VALUES ('1909', '郴州市', '1824', '192');
INSERT INTO `wp_area` VALUES ('1910', '北湖区', '1909', '1700');
INSERT INTO `wp_area` VALUES ('1911', '苏仙区', '1909', '1701');
INSERT INTO `wp_area` VALUES ('1912', '桂阳县', '1909', '1702');
INSERT INTO `wp_area` VALUES ('1913', '宜章县', '1909', '1703');
INSERT INTO `wp_area` VALUES ('1914', '永兴县', '1909', '1704');
INSERT INTO `wp_area` VALUES ('1915', '嘉禾县', '1909', '1705');
INSERT INTO `wp_area` VALUES ('1916', '临武县', '1909', '1706');
INSERT INTO `wp_area` VALUES ('1917', '汝城县', '1909', '1707');
INSERT INTO `wp_area` VALUES ('1918', '桂东县', '1909', '1708');
INSERT INTO `wp_area` VALUES ('1919', '安仁县', '1909', '1709');
INSERT INTO `wp_area` VALUES ('1920', '资兴市', '1909', '1710');
INSERT INTO `wp_area` VALUES ('1921', '永州市', '1824', '193');
INSERT INTO `wp_area` VALUES ('1922', '芝山区', '1921', '1711');
INSERT INTO `wp_area` VALUES ('1923', '冷水滩区', '1921', '1712');
INSERT INTO `wp_area` VALUES ('1924', '祁阳县', '1921', '1713');
INSERT INTO `wp_area` VALUES ('1925', '东安县', '1921', '1714');
INSERT INTO `wp_area` VALUES ('1926', '双牌县', '1921', '1715');
INSERT INTO `wp_area` VALUES ('1927', '道县', '1921', '1716');
INSERT INTO `wp_area` VALUES ('1928', '江永县', '1921', '1717');
INSERT INTO `wp_area` VALUES ('1929', '宁远县', '1921', '1718');
INSERT INTO `wp_area` VALUES ('1930', '蓝山县', '1921', '1719');
INSERT INTO `wp_area` VALUES ('1931', '新田县', '1921', '1720');
INSERT INTO `wp_area` VALUES ('1932', '江华瑶族自治县', '1921', '1721');
INSERT INTO `wp_area` VALUES ('1933', '怀化市', '1824', '194');
INSERT INTO `wp_area` VALUES ('1934', '鹤城区', '1933', '1722');
INSERT INTO `wp_area` VALUES ('1935', '中方县', '1933', '1723');
INSERT INTO `wp_area` VALUES ('1936', '沅陵县', '1933', '1724');
INSERT INTO `wp_area` VALUES ('1937', '辰溪县', '1933', '1725');
INSERT INTO `wp_area` VALUES ('1938', '溆浦县', '1933', '1726');
INSERT INTO `wp_area` VALUES ('1939', '会同县', '1933', '1727');
INSERT INTO `wp_area` VALUES ('1940', '麻阳苗族自治县', '1933', '1728');
INSERT INTO `wp_area` VALUES ('1941', '新晃侗族自治县', '1933', '1729');
INSERT INTO `wp_area` VALUES ('1942', '芷江侗族自治县', '1933', '1730');
INSERT INTO `wp_area` VALUES ('1943', '靖州苗族侗族自治县', '1933', '1731');
INSERT INTO `wp_area` VALUES ('1944', '通道侗族自治县', '1933', '1732');
INSERT INTO `wp_area` VALUES ('1945', '洪江市', '1933', '1733');
INSERT INTO `wp_area` VALUES ('1946', '娄底市', '1824', '195');
INSERT INTO `wp_area` VALUES ('1947', '娄星区', '1946', '1734');
INSERT INTO `wp_area` VALUES ('1948', '双峰县', '1946', '1735');
INSERT INTO `wp_area` VALUES ('1949', '新化县', '1946', '1736');
INSERT INTO `wp_area` VALUES ('1950', '冷水江市', '1946', '1737');
INSERT INTO `wp_area` VALUES ('1951', '涟源市', '1946', '1738');
INSERT INTO `wp_area` VALUES ('1952', '湘西土家族苗族自治州', '1824', '196');
INSERT INTO `wp_area` VALUES ('1953', '吉首市', '1952', '1739');
INSERT INTO `wp_area` VALUES ('1954', '泸溪县', '1952', '1740');
INSERT INTO `wp_area` VALUES ('1955', '凤凰县', '1952', '1741');
INSERT INTO `wp_area` VALUES ('1956', '花垣县', '1952', '1742');
INSERT INTO `wp_area` VALUES ('1957', '保靖县', '1952', '1743');
INSERT INTO `wp_area` VALUES ('1958', '古丈县', '1952', '1744');
INSERT INTO `wp_area` VALUES ('1959', '永顺县', '1952', '1745');
INSERT INTO `wp_area` VALUES ('1960', '龙山县', '1952', '1746');
INSERT INTO `wp_area` VALUES ('1961', '广东省', '0', '19');
INSERT INTO `wp_area` VALUES ('1962', '广州市', '1961', '197');
INSERT INTO `wp_area` VALUES ('1963', '东山区', '1962', '1747');
INSERT INTO `wp_area` VALUES ('1964', '荔湾区', '1962', '1748');
INSERT INTO `wp_area` VALUES ('1965', '越秀区', '1962', '1749');
INSERT INTO `wp_area` VALUES ('1966', '海珠区', '1962', '1750');
INSERT INTO `wp_area` VALUES ('1967', '天河区', '1962', '1751');
INSERT INTO `wp_area` VALUES ('1968', '芳村区', '1962', '1752');
INSERT INTO `wp_area` VALUES ('1969', '白云区', '1962', '1753');
INSERT INTO `wp_area` VALUES ('1970', '黄埔区', '1962', '1754');
INSERT INTO `wp_area` VALUES ('1971', '番禺区', '1962', '1755');
INSERT INTO `wp_area` VALUES ('1972', '花都区', '1962', '1756');
INSERT INTO `wp_area` VALUES ('1973', '增城市', '1962', '1757');
INSERT INTO `wp_area` VALUES ('1974', '从化市', '1962', '1758');
INSERT INTO `wp_area` VALUES ('1975', '韶关市', '1961', '198');
INSERT INTO `wp_area` VALUES ('1976', '武江区', '1975', '1759');
INSERT INTO `wp_area` VALUES ('1977', '浈江区', '1975', '1760');
INSERT INTO `wp_area` VALUES ('1978', '曲江区', '1975', '1761');
INSERT INTO `wp_area` VALUES ('1979', '始兴县', '1975', '1762');
INSERT INTO `wp_area` VALUES ('1980', '仁化县', '1975', '1763');
INSERT INTO `wp_area` VALUES ('1981', '翁源县', '1975', '1764');
INSERT INTO `wp_area` VALUES ('1982', '乳源瑶族自治县', '1975', '1765');
INSERT INTO `wp_area` VALUES ('1983', '新丰县', '1975', '1766');
INSERT INTO `wp_area` VALUES ('1984', '乐昌市', '1975', '1767');
INSERT INTO `wp_area` VALUES ('1985', '南雄市', '1975', '1768');
INSERT INTO `wp_area` VALUES ('1986', '深圳市', '1961', '199');
INSERT INTO `wp_area` VALUES ('1987', '罗湖区', '1986', '1769');
INSERT INTO `wp_area` VALUES ('1988', '福田区', '1986', '1770');
INSERT INTO `wp_area` VALUES ('1989', '南山区', '1986', '1771');
INSERT INTO `wp_area` VALUES ('1990', '宝安区', '1986', '1772');
INSERT INTO `wp_area` VALUES ('1991', '龙岗区', '1986', '1773');
INSERT INTO `wp_area` VALUES ('1992', '盐田区', '1986', '1774');
INSERT INTO `wp_area` VALUES ('1993', '珠海市', '1961', '200');
INSERT INTO `wp_area` VALUES ('1994', '香洲区', '1993', '1775');
INSERT INTO `wp_area` VALUES ('1995', '斗门区', '1993', '1776');
INSERT INTO `wp_area` VALUES ('1996', '金湾区', '1993', '1777');
INSERT INTO `wp_area` VALUES ('1997', '汕头市', '1961', '201');
INSERT INTO `wp_area` VALUES ('1998', '龙湖区', '1997', '1778');
INSERT INTO `wp_area` VALUES ('1999', '金平区', '1997', '1779');
INSERT INTO `wp_area` VALUES ('2000', '濠江区', '1997', '1780');
INSERT INTO `wp_area` VALUES ('2001', '潮阳区', '1997', '1781');
INSERT INTO `wp_area` VALUES ('2002', '潮南区', '1997', '1782');
INSERT INTO `wp_area` VALUES ('2003', '澄海区', '1997', '1783');
INSERT INTO `wp_area` VALUES ('2004', '南澳县', '1997', '1784');
INSERT INTO `wp_area` VALUES ('2005', '佛山市', '1961', '202');
INSERT INTO `wp_area` VALUES ('2006', '禅城区', '2005', '1785');
INSERT INTO `wp_area` VALUES ('2007', '南海区', '2005', '1786');
INSERT INTO `wp_area` VALUES ('2008', '顺德区', '2005', '1787');
INSERT INTO `wp_area` VALUES ('2009', '三水区', '2005', '1788');
INSERT INTO `wp_area` VALUES ('2010', '高明区', '2005', '1789');
INSERT INTO `wp_area` VALUES ('2011', '江门市', '1961', '203');
INSERT INTO `wp_area` VALUES ('2012', '蓬江区', '2011', '1790');
INSERT INTO `wp_area` VALUES ('2013', '江海区', '2011', '1791');
INSERT INTO `wp_area` VALUES ('2014', '新会区', '2011', '1792');
INSERT INTO `wp_area` VALUES ('2015', '台山市', '2011', '1793');
INSERT INTO `wp_area` VALUES ('2016', '开平市', '2011', '1794');
INSERT INTO `wp_area` VALUES ('2017', '鹤山市', '2011', '1795');
INSERT INTO `wp_area` VALUES ('2018', '恩平市', '2011', '1796');
INSERT INTO `wp_area` VALUES ('2019', '湛江市', '1961', '204');
INSERT INTO `wp_area` VALUES ('2020', '赤坎区', '2019', '1797');
INSERT INTO `wp_area` VALUES ('2021', '霞山区', '2019', '1798');
INSERT INTO `wp_area` VALUES ('2022', '坡头区', '2019', '1799');
INSERT INTO `wp_area` VALUES ('2023', '麻章区', '2019', '1800');
INSERT INTO `wp_area` VALUES ('2024', '遂溪县', '2019', '1801');
INSERT INTO `wp_area` VALUES ('2025', '徐闻县', '2019', '1802');
INSERT INTO `wp_area` VALUES ('2026', '廉江市', '2019', '1803');
INSERT INTO `wp_area` VALUES ('2027', '雷州市', '2019', '1804');
INSERT INTO `wp_area` VALUES ('2028', '吴川市', '2019', '1805');
INSERT INTO `wp_area` VALUES ('2029', '茂名市', '1961', '205');
INSERT INTO `wp_area` VALUES ('2030', '茂南区', '2029', '1806');
INSERT INTO `wp_area` VALUES ('2031', '茂港区', '2029', '1807');
INSERT INTO `wp_area` VALUES ('2032', '电白县', '2029', '1808');
INSERT INTO `wp_area` VALUES ('2033', '高州市', '2029', '1809');
INSERT INTO `wp_area` VALUES ('2034', '化州市', '2029', '1810');
INSERT INTO `wp_area` VALUES ('2035', '信宜市', '2029', '1811');
INSERT INTO `wp_area` VALUES ('2036', '肇庆市', '1961', '206');
INSERT INTO `wp_area` VALUES ('2037', '端州区', '2036', '1812');
INSERT INTO `wp_area` VALUES ('2038', '鼎湖区', '2036', '1813');
INSERT INTO `wp_area` VALUES ('2039', '广宁县', '2036', '1814');
INSERT INTO `wp_area` VALUES ('2040', '怀集县', '2036', '1815');
INSERT INTO `wp_area` VALUES ('2041', '封开县', '2036', '1816');
INSERT INTO `wp_area` VALUES ('2042', '德庆县', '2036', '1817');
INSERT INTO `wp_area` VALUES ('2043', '高要市', '2036', '1818');
INSERT INTO `wp_area` VALUES ('2044', '四会市', '2036', '1819');
INSERT INTO `wp_area` VALUES ('2045', '惠州市', '1961', '207');
INSERT INTO `wp_area` VALUES ('2046', '惠城区', '2045', '1820');
INSERT INTO `wp_area` VALUES ('2047', '惠阳区', '2045', '1821');
INSERT INTO `wp_area` VALUES ('2048', '博罗县', '2045', '1822');
INSERT INTO `wp_area` VALUES ('2049', '惠东县', '2045', '1823');
INSERT INTO `wp_area` VALUES ('2050', '龙门县', '2045', '1824');
INSERT INTO `wp_area` VALUES ('2051', '梅州市', '1961', '208');
INSERT INTO `wp_area` VALUES ('2052', '梅江区', '2051', '1825');
INSERT INTO `wp_area` VALUES ('2053', '梅县', '2051', '1826');
INSERT INTO `wp_area` VALUES ('2054', '大埔县', '2051', '1827');
INSERT INTO `wp_area` VALUES ('2055', '丰顺县', '2051', '1828');
INSERT INTO `wp_area` VALUES ('2056', '五华县', '2051', '1829');
INSERT INTO `wp_area` VALUES ('2057', '平远县', '2051', '1830');
INSERT INTO `wp_area` VALUES ('2058', '蕉岭县', '2051', '1831');
INSERT INTO `wp_area` VALUES ('2059', '兴宁市', '2051', '1832');
INSERT INTO `wp_area` VALUES ('2060', '汕尾市', '1961', '209');
INSERT INTO `wp_area` VALUES ('2061', '城区', '2060', '1833');
INSERT INTO `wp_area` VALUES ('2062', '海丰县', '2060', '1834');
INSERT INTO `wp_area` VALUES ('2063', '陆河县', '2060', '1835');
INSERT INTO `wp_area` VALUES ('2064', '陆丰市', '2060', '1836');
INSERT INTO `wp_area` VALUES ('2065', '河源市', '1961', '210');
INSERT INTO `wp_area` VALUES ('2066', '源城区', '2065', '1837');
INSERT INTO `wp_area` VALUES ('2067', '紫金县', '2065', '1838');
INSERT INTO `wp_area` VALUES ('2068', '龙川县', '2065', '1839');
INSERT INTO `wp_area` VALUES ('2069', '连平县', '2065', '1840');
INSERT INTO `wp_area` VALUES ('2070', '和平县', '2065', '1841');
INSERT INTO `wp_area` VALUES ('2071', '东源县', '2065', '1842');
INSERT INTO `wp_area` VALUES ('2072', '阳江市', '1961', '211');
INSERT INTO `wp_area` VALUES ('2073', '江城区', '2072', '1843');
INSERT INTO `wp_area` VALUES ('2074', '阳西县', '2072', '1844');
INSERT INTO `wp_area` VALUES ('2075', '阳东县', '2072', '1845');
INSERT INTO `wp_area` VALUES ('2076', '阳春市', '2072', '1846');
INSERT INTO `wp_area` VALUES ('2077', '清远市', '1961', '212');
INSERT INTO `wp_area` VALUES ('2078', '清城区', '2077', '1847');
INSERT INTO `wp_area` VALUES ('2079', '佛冈县', '2077', '1848');
INSERT INTO `wp_area` VALUES ('2080', '阳山县', '2077', '1849');
INSERT INTO `wp_area` VALUES ('2081', '连山壮族瑶族自治县', '2077', '1850');
INSERT INTO `wp_area` VALUES ('2082', '连南瑶族自治县', '2077', '1851');
INSERT INTO `wp_area` VALUES ('2083', '清新县', '2077', '1852');
INSERT INTO `wp_area` VALUES ('2084', '英德市', '2077', '1853');
INSERT INTO `wp_area` VALUES ('2085', '连州市', '2077', '1854');
INSERT INTO `wp_area` VALUES ('2086', '东莞市', '1961', '213');
INSERT INTO `wp_area` VALUES ('2087', '中山市', '1961', '214');
INSERT INTO `wp_area` VALUES ('2088', '潮州市', '1961', '215');
INSERT INTO `wp_area` VALUES ('2089', '湘桥区', '2088', '1855');
INSERT INTO `wp_area` VALUES ('2090', '潮安县', '2088', '1856');
INSERT INTO `wp_area` VALUES ('2091', '饶平县', '2088', '1857');
INSERT INTO `wp_area` VALUES ('2092', '揭阳市', '1961', '216');
INSERT INTO `wp_area` VALUES ('2093', '榕城区', '2092', '1858');
INSERT INTO `wp_area` VALUES ('2094', '揭东县', '2092', '1859');
INSERT INTO `wp_area` VALUES ('2095', '揭西县', '2092', '1860');
INSERT INTO `wp_area` VALUES ('2096', '惠来县', '2092', '1861');
INSERT INTO `wp_area` VALUES ('2097', '普宁市', '2092', '1862');
INSERT INTO `wp_area` VALUES ('2098', '云浮市', '1961', '217');
INSERT INTO `wp_area` VALUES ('2099', '云城区', '2098', '1863');
INSERT INTO `wp_area` VALUES ('2100', '新兴县', '2098', '1864');
INSERT INTO `wp_area` VALUES ('2101', '郁南县', '2098', '1865');
INSERT INTO `wp_area` VALUES ('2102', '云安县', '2098', '1866');
INSERT INTO `wp_area` VALUES ('2103', '罗定市', '2098', '1867');
INSERT INTO `wp_area` VALUES ('2104', '广西壮族自治区', '0', '20');
INSERT INTO `wp_area` VALUES ('2105', '南宁市', '2104', '218');
INSERT INTO `wp_area` VALUES ('2106', '兴宁区', '2105', '1868');
INSERT INTO `wp_area` VALUES ('2107', '青秀区', '2105', '1869');
INSERT INTO `wp_area` VALUES ('2108', '江南区', '2105', '1870');
INSERT INTO `wp_area` VALUES ('2109', '西乡塘区', '2105', '1871');
INSERT INTO `wp_area` VALUES ('2110', '良庆区', '2105', '1872');
INSERT INTO `wp_area` VALUES ('2111', '邕宁区', '2105', '1873');
INSERT INTO `wp_area` VALUES ('2112', '武鸣县', '2105', '1874');
INSERT INTO `wp_area` VALUES ('2113', '隆安县', '2105', '1875');
INSERT INTO `wp_area` VALUES ('2114', '马山县', '2105', '1876');
INSERT INTO `wp_area` VALUES ('2115', '上林县', '2105', '1877');
INSERT INTO `wp_area` VALUES ('2116', '宾阳县', '2105', '1878');
INSERT INTO `wp_area` VALUES ('2117', '横县', '2105', '1879');
INSERT INTO `wp_area` VALUES ('2118', '柳州市', '2104', '219');
INSERT INTO `wp_area` VALUES ('2119', '城中区', '2118', '1880');
INSERT INTO `wp_area` VALUES ('2120', '鱼峰区', '2118', '1881');
INSERT INTO `wp_area` VALUES ('2121', '柳南区', '2118', '1882');
INSERT INTO `wp_area` VALUES ('2122', '柳北区', '2118', '1883');
INSERT INTO `wp_area` VALUES ('2123', '柳江县', '2118', '1884');
INSERT INTO `wp_area` VALUES ('2124', '柳城县', '2118', '1885');
INSERT INTO `wp_area` VALUES ('2125', '鹿寨县', '2118', '1886');
INSERT INTO `wp_area` VALUES ('2126', '融安县', '2118', '1887');
INSERT INTO `wp_area` VALUES ('2127', '融水苗族自治县', '2118', '1888');
INSERT INTO `wp_area` VALUES ('2128', '三江侗族自治县', '2118', '1889');
INSERT INTO `wp_area` VALUES ('2129', '桂林市', '2104', '220');
INSERT INTO `wp_area` VALUES ('2130', '秀峰区', '2129', '1890');
INSERT INTO `wp_area` VALUES ('2131', '叠彩区', '2129', '1891');
INSERT INTO `wp_area` VALUES ('2132', '象山区', '2129', '1892');
INSERT INTO `wp_area` VALUES ('2133', '七星区', '2129', '1893');
INSERT INTO `wp_area` VALUES ('2134', '雁山区', '2129', '1894');
INSERT INTO `wp_area` VALUES ('2135', '阳朔县', '2129', '1895');
INSERT INTO `wp_area` VALUES ('2136', '临桂县', '2129', '1896');
INSERT INTO `wp_area` VALUES ('2137', '灵川县', '2129', '1897');
INSERT INTO `wp_area` VALUES ('2138', '全州县', '2129', '1898');
INSERT INTO `wp_area` VALUES ('2139', '兴安县', '2129', '1899');
INSERT INTO `wp_area` VALUES ('2140', '永福县', '2129', '1900');
INSERT INTO `wp_area` VALUES ('2141', '灌阳县', '2129', '1901');
INSERT INTO `wp_area` VALUES ('2142', '龙胜各族自治县', '2129', '1902');
INSERT INTO `wp_area` VALUES ('2143', '资源县', '2129', '1903');
INSERT INTO `wp_area` VALUES ('2144', '平乐县', '2129', '1904');
INSERT INTO `wp_area` VALUES ('2145', '荔蒲县', '2129', '1905');
INSERT INTO `wp_area` VALUES ('2146', '恭城瑶族自治县', '2129', '1906');
INSERT INTO `wp_area` VALUES ('2147', '梧州市', '2104', '221');
INSERT INTO `wp_area` VALUES ('2148', '万秀区', '2147', '1907');
INSERT INTO `wp_area` VALUES ('2149', '蝶山区', '2147', '1908');
INSERT INTO `wp_area` VALUES ('2150', '长洲区', '2147', '1909');
INSERT INTO `wp_area` VALUES ('2151', '苍梧县', '2147', '1910');
INSERT INTO `wp_area` VALUES ('2152', '藤县', '2147', '1911');
INSERT INTO `wp_area` VALUES ('2153', '蒙山县', '2147', '1912');
INSERT INTO `wp_area` VALUES ('2154', '岑溪市', '2147', '1913');
INSERT INTO `wp_area` VALUES ('2155', '北海市', '2104', '222');
INSERT INTO `wp_area` VALUES ('2156', '海城区', '2155', '1914');
INSERT INTO `wp_area` VALUES ('2157', '银海区', '2155', '1915');
INSERT INTO `wp_area` VALUES ('2158', '铁山港区', '2155', '1916');
INSERT INTO `wp_area` VALUES ('2159', '合浦县', '2155', '1917');
INSERT INTO `wp_area` VALUES ('2160', '防城港市', '2104', '223');
INSERT INTO `wp_area` VALUES ('2161', '港口区', '2160', '1918');
INSERT INTO `wp_area` VALUES ('2162', '防城区', '2160', '1919');
INSERT INTO `wp_area` VALUES ('2163', '上思县', '2160', '1920');
INSERT INTO `wp_area` VALUES ('2164', '东兴市', '2160', '1921');
INSERT INTO `wp_area` VALUES ('2165', '钦州市', '2104', '224');
INSERT INTO `wp_area` VALUES ('2166', '钦南区', '2165', '1922');
INSERT INTO `wp_area` VALUES ('2167', '钦北区', '2165', '1923');
INSERT INTO `wp_area` VALUES ('2168', '灵山县', '2165', '1924');
INSERT INTO `wp_area` VALUES ('2169', '浦北县', '2165', '1925');
INSERT INTO `wp_area` VALUES ('2170', '贵港市', '2104', '225');
INSERT INTO `wp_area` VALUES ('2171', '港北区', '2170', '1926');
INSERT INTO `wp_area` VALUES ('2172', '港南区', '2170', '1927');
INSERT INTO `wp_area` VALUES ('2173', '覃塘区', '2170', '1928');
INSERT INTO `wp_area` VALUES ('2174', '平南县', '2170', '1929');
INSERT INTO `wp_area` VALUES ('2175', '桂平市', '2170', '1930');
INSERT INTO `wp_area` VALUES ('2176', '玉林市', '2104', '226');
INSERT INTO `wp_area` VALUES ('2177', '玉州区', '2176', '1931');
INSERT INTO `wp_area` VALUES ('2178', '容县', '2176', '1932');
INSERT INTO `wp_area` VALUES ('2179', '陆川县', '2176', '1933');
INSERT INTO `wp_area` VALUES ('2180', '博白县', '2176', '1934');
INSERT INTO `wp_area` VALUES ('2181', '兴业县', '2176', '1935');
INSERT INTO `wp_area` VALUES ('2182', '北流市', '2176', '1936');
INSERT INTO `wp_area` VALUES ('2183', '百色市', '2104', '227');
INSERT INTO `wp_area` VALUES ('2184', '右江区', '2183', '1937');
INSERT INTO `wp_area` VALUES ('2185', '田阳县', '2183', '1938');
INSERT INTO `wp_area` VALUES ('2186', '田东县', '2183', '1939');
INSERT INTO `wp_area` VALUES ('2187', '平果县', '2183', '1940');
INSERT INTO `wp_area` VALUES ('2188', '德保县', '2183', '1941');
INSERT INTO `wp_area` VALUES ('2189', '靖西县', '2183', '1942');
INSERT INTO `wp_area` VALUES ('2190', '那坡县', '2183', '1943');
INSERT INTO `wp_area` VALUES ('2191', '凌云县', '2183', '1944');
INSERT INTO `wp_area` VALUES ('2192', '乐业县', '2183', '1945');
INSERT INTO `wp_area` VALUES ('2193', '田林县', '2183', '1946');
INSERT INTO `wp_area` VALUES ('2194', '西林县', '2183', '1947');
INSERT INTO `wp_area` VALUES ('2195', '隆林各族自治县', '2183', '1948');
INSERT INTO `wp_area` VALUES ('2196', '贺州市', '2104', '228');
INSERT INTO `wp_area` VALUES ('2197', '八步区', '2196', '1949');
INSERT INTO `wp_area` VALUES ('2198', '昭平县', '2196', '1950');
INSERT INTO `wp_area` VALUES ('2199', '钟山县', '2196', '1951');
INSERT INTO `wp_area` VALUES ('2200', '富川瑶族自治县', '2196', '1952');
INSERT INTO `wp_area` VALUES ('2201', '河池市', '2104', '229');
INSERT INTO `wp_area` VALUES ('2202', '金城江区', '2201', '1953');
INSERT INTO `wp_area` VALUES ('2203', '南丹县', '2201', '1954');
INSERT INTO `wp_area` VALUES ('2204', '天峨县', '2201', '1955');
INSERT INTO `wp_area` VALUES ('2205', '凤山县', '2201', '1956');
INSERT INTO `wp_area` VALUES ('2206', '东兰县', '2201', '1957');
INSERT INTO `wp_area` VALUES ('2207', '罗城仫佬族自治县', '2201', '1958');
INSERT INTO `wp_area` VALUES ('2208', '环江毛南族自治县', '2201', '1959');
INSERT INTO `wp_area` VALUES ('2209', '巴马瑶族自治县', '2201', '1960');
INSERT INTO `wp_area` VALUES ('2210', '都安瑶族自治县', '2201', '1961');
INSERT INTO `wp_area` VALUES ('2211', '大化瑶族自治县', '2201', '1962');
INSERT INTO `wp_area` VALUES ('2212', '宜州市', '2201', '1963');
INSERT INTO `wp_area` VALUES ('2213', '来宾市', '2104', '230');
INSERT INTO `wp_area` VALUES ('2214', '兴宾区', '2213', '1964');
INSERT INTO `wp_area` VALUES ('2215', '忻城县', '2213', '1965');
INSERT INTO `wp_area` VALUES ('2216', '象州县', '2213', '1966');
INSERT INTO `wp_area` VALUES ('2217', '武宣县', '2213', '1967');
INSERT INTO `wp_area` VALUES ('2218', '金秀瑶族自治县', '2213', '1968');
INSERT INTO `wp_area` VALUES ('2219', '合山市', '2213', '1969');
INSERT INTO `wp_area` VALUES ('2220', '崇左市', '2104', '231');
INSERT INTO `wp_area` VALUES ('2221', '江洲区', '2220', '1970');
INSERT INTO `wp_area` VALUES ('2222', '扶绥县', '2220', '1971');
INSERT INTO `wp_area` VALUES ('2223', '宁明县', '2220', '1972');
INSERT INTO `wp_area` VALUES ('2224', '龙州县', '2220', '1973');
INSERT INTO `wp_area` VALUES ('2225', '大新县', '2220', '1974');
INSERT INTO `wp_area` VALUES ('2226', '天等县', '2220', '1975');
INSERT INTO `wp_area` VALUES ('2227', '凭祥市', '2220', '1976');
INSERT INTO `wp_area` VALUES ('2228', '海南省', '0', '21');
INSERT INTO `wp_area` VALUES ('2229', '海口市', '2228', '232');
INSERT INTO `wp_area` VALUES ('2230', '秀英区', '2229', '1977');
INSERT INTO `wp_area` VALUES ('2231', '龙华区', '2229', '1978');
INSERT INTO `wp_area` VALUES ('2232', '琼山区', '2229', '1979');
INSERT INTO `wp_area` VALUES ('2233', '美兰区', '2229', '1980');
INSERT INTO `wp_area` VALUES ('2234', '三亚市', '2228', '233');
INSERT INTO `wp_area` VALUES ('2235', '五指山市', '2234', '1981');
INSERT INTO `wp_area` VALUES ('2236', '琼海市', '2234', '1982');
INSERT INTO `wp_area` VALUES ('2237', '儋州市', '2234', '1983');
INSERT INTO `wp_area` VALUES ('2238', '文昌市', '2234', '1984');
INSERT INTO `wp_area` VALUES ('2239', '万宁市', '2234', '1985');
INSERT INTO `wp_area` VALUES ('2240', '东方市', '2234', '1986');
INSERT INTO `wp_area` VALUES ('2241', '定安县', '2234', '1987');
INSERT INTO `wp_area` VALUES ('2242', '屯昌县', '2234', '1988');
INSERT INTO `wp_area` VALUES ('2243', '澄迈县', '2234', '1989');
INSERT INTO `wp_area` VALUES ('2244', '临高县', '2234', '1990');
INSERT INTO `wp_area` VALUES ('2245', '白沙黎族自治县', '2234', '1991');
INSERT INTO `wp_area` VALUES ('2246', '昌江黎族自治县', '2234', '1992');
INSERT INTO `wp_area` VALUES ('2247', '乐东黎族自治县', '2234', '1993');
INSERT INTO `wp_area` VALUES ('2248', '陵水黎族自治县', '2234', '1994');
INSERT INTO `wp_area` VALUES ('2249', '保亭黎族苗族自治县', '2234', '1995');
INSERT INTO `wp_area` VALUES ('2250', '琼中黎族苗族自治县', '2234', '1996');
INSERT INTO `wp_area` VALUES ('2251', '西沙群岛', '2234', '1997');
INSERT INTO `wp_area` VALUES ('2252', '南沙群岛', '2234', '1998');
INSERT INTO `wp_area` VALUES ('2253', '中沙群岛的岛礁及其海域', '2234', '1999');
INSERT INTO `wp_area` VALUES ('2254', '重庆市', '0', '22');
INSERT INTO `wp_area` VALUES ('2256', '万州区', '2254', '2000');
INSERT INTO `wp_area` VALUES ('2257', '涪陵区', '2254', '2001');
INSERT INTO `wp_area` VALUES ('2258', '渝中区', '2254', '2002');
INSERT INTO `wp_area` VALUES ('2259', '大渡口区', '2254', '2003');
INSERT INTO `wp_area` VALUES ('2260', '江北区', '2254', '2004');
INSERT INTO `wp_area` VALUES ('2261', '沙坪坝区', '2254', '2005');
INSERT INTO `wp_area` VALUES ('2262', '九龙坡区', '2254', '2006');
INSERT INTO `wp_area` VALUES ('2263', '南岸区', '2254', '2007');
INSERT INTO `wp_area` VALUES ('2264', '北碚区', '2254', '2008');
INSERT INTO `wp_area` VALUES ('2265', '万盛区', '2254', '2009');
INSERT INTO `wp_area` VALUES ('2266', '双桥区', '2254', '2010');
INSERT INTO `wp_area` VALUES ('2267', '渝北区', '2254', '2011');
INSERT INTO `wp_area` VALUES ('2268', '巴南区', '2254', '2012');
INSERT INTO `wp_area` VALUES ('2269', '黔江区', '2254', '2013');
INSERT INTO `wp_area` VALUES ('2270', '长寿区', '2254', '2014');
INSERT INTO `wp_area` VALUES ('2271', '綦江县', '2254', '2015');
INSERT INTO `wp_area` VALUES ('2272', '潼南县', '2254', '2016');
INSERT INTO `wp_area` VALUES ('2273', '铜梁县', '2254', '2017');
INSERT INTO `wp_area` VALUES ('2274', '大足县', '2254', '2018');
INSERT INTO `wp_area` VALUES ('2275', '荣昌县', '2254', '2019');
INSERT INTO `wp_area` VALUES ('2276', '璧山县', '2254', '2020');
INSERT INTO `wp_area` VALUES ('2277', '梁平县', '2254', '2021');
INSERT INTO `wp_area` VALUES ('2278', '城口县', '2254', '2022');
INSERT INTO `wp_area` VALUES ('2279', '丰都县', '2254', '2023');
INSERT INTO `wp_area` VALUES ('2280', '垫江县', '2254', '2024');
INSERT INTO `wp_area` VALUES ('2281', '武隆县', '2254', '2025');
INSERT INTO `wp_area` VALUES ('2282', '忠县', '2254', '2026');
INSERT INTO `wp_area` VALUES ('2283', '开县', '2254', '2027');
INSERT INTO `wp_area` VALUES ('2284', '云阳县', '2254', '2028');
INSERT INTO `wp_area` VALUES ('2285', '奉节县', '2254', '2029');
INSERT INTO `wp_area` VALUES ('2286', '巫山县', '2254', '2030');
INSERT INTO `wp_area` VALUES ('2287', '巫溪县', '2254', '2031');
INSERT INTO `wp_area` VALUES ('2288', '石柱土家族自治县', '2254', '2032');
INSERT INTO `wp_area` VALUES ('2289', '秀山土家族苗族自治县', '2254', '2033');
INSERT INTO `wp_area` VALUES ('2290', '酉阳土家族苗族自治县', '2254', '2034');
INSERT INTO `wp_area` VALUES ('2291', '彭水苗族土家族自治县', '2254', '2035');
INSERT INTO `wp_area` VALUES ('2292', '江津市', '2254', '2036');
INSERT INTO `wp_area` VALUES ('2293', '合川市', '2254', '2037');
INSERT INTO `wp_area` VALUES ('2294', '永川市', '2254', '2038');
INSERT INTO `wp_area` VALUES ('2295', '南川市', '2254', '2039');
INSERT INTO `wp_area` VALUES ('2296', '四川省', '0', '23');
INSERT INTO `wp_area` VALUES ('2297', '成都市', '2296', '235');
INSERT INTO `wp_area` VALUES ('2298', '锦江区', '2297', '2040');
INSERT INTO `wp_area` VALUES ('2299', '青羊区', '2297', '2041');
INSERT INTO `wp_area` VALUES ('2300', '金牛区', '2297', '2042');
INSERT INTO `wp_area` VALUES ('2301', '武侯区', '2297', '2043');
INSERT INTO `wp_area` VALUES ('2302', '成华区', '2297', '2044');
INSERT INTO `wp_area` VALUES ('2303', '龙泉驿区', '2297', '2045');
INSERT INTO `wp_area` VALUES ('2304', '青白江区', '2297', '2046');
INSERT INTO `wp_area` VALUES ('2305', '新都区', '2297', '2047');
INSERT INTO `wp_area` VALUES ('2306', '温江区', '2297', '2048');
INSERT INTO `wp_area` VALUES ('2307', '金堂县', '2297', '2049');
INSERT INTO `wp_area` VALUES ('2308', '双流县', '2297', '2050');
INSERT INTO `wp_area` VALUES ('2309', '郫县', '2297', '2051');
INSERT INTO `wp_area` VALUES ('2310', '大邑县', '2297', '2052');
INSERT INTO `wp_area` VALUES ('2311', '蒲江县', '2297', '2053');
INSERT INTO `wp_area` VALUES ('2312', '新津县', '2297', '2054');
INSERT INTO `wp_area` VALUES ('2313', '都江堰市', '2297', '2055');
INSERT INTO `wp_area` VALUES ('2314', '彭州市', '2297', '2056');
INSERT INTO `wp_area` VALUES ('2315', '邛崃市', '2297', '2057');
INSERT INTO `wp_area` VALUES ('2316', '崇州市', '2297', '2058');
INSERT INTO `wp_area` VALUES ('2317', '自贡市', '2296', '236');
INSERT INTO `wp_area` VALUES ('2318', '自流井区', '2317', '2059');
INSERT INTO `wp_area` VALUES ('2319', '贡井区', '2317', '2060');
INSERT INTO `wp_area` VALUES ('2320', '大安区', '2317', '2061');
INSERT INTO `wp_area` VALUES ('2321', '沿滩区', '2317', '2062');
INSERT INTO `wp_area` VALUES ('2322', '荣县', '2317', '2063');
INSERT INTO `wp_area` VALUES ('2323', '富顺县', '2317', '2064');
INSERT INTO `wp_area` VALUES ('2324', '攀枝花市', '2296', '237');
INSERT INTO `wp_area` VALUES ('2325', '东区', '2324', '2065');
INSERT INTO `wp_area` VALUES ('2326', '西区', '2324', '2066');
INSERT INTO `wp_area` VALUES ('2327', '仁和区', '2324', '2067');
INSERT INTO `wp_area` VALUES ('2328', '米易县', '2324', '2068');
INSERT INTO `wp_area` VALUES ('2329', '盐边县', '2324', '2069');
INSERT INTO `wp_area` VALUES ('2330', '泸州市', '2296', '238');
INSERT INTO `wp_area` VALUES ('2331', '江阳区', '2330', '2070');
INSERT INTO `wp_area` VALUES ('2332', '纳溪区', '2330', '2071');
INSERT INTO `wp_area` VALUES ('2333', '龙马潭区', '2330', '2072');
INSERT INTO `wp_area` VALUES ('2334', '泸县', '2330', '2073');
INSERT INTO `wp_area` VALUES ('2335', '合江县', '2330', '2074');
INSERT INTO `wp_area` VALUES ('2336', '叙永县', '2330', '2075');
INSERT INTO `wp_area` VALUES ('2337', '古蔺县', '2330', '2076');
INSERT INTO `wp_area` VALUES ('2338', '德阳市', '2296', '239');
INSERT INTO `wp_area` VALUES ('2339', '旌阳区', '2338', '2077');
INSERT INTO `wp_area` VALUES ('2340', '中江县', '2338', '2078');
INSERT INTO `wp_area` VALUES ('2341', '罗江县', '2338', '2079');
INSERT INTO `wp_area` VALUES ('2342', '广汉市', '2338', '2080');
INSERT INTO `wp_area` VALUES ('2343', '什邡市', '2338', '2081');
INSERT INTO `wp_area` VALUES ('2344', '绵竹市', '2338', '2082');
INSERT INTO `wp_area` VALUES ('2345', '绵阳市', '2296', '240');
INSERT INTO `wp_area` VALUES ('2346', '涪城区', '2345', '2083');
INSERT INTO `wp_area` VALUES ('2347', '游仙区', '2345', '2084');
INSERT INTO `wp_area` VALUES ('2348', '三台县', '2345', '2085');
INSERT INTO `wp_area` VALUES ('2349', '盐亭县', '2345', '2086');
INSERT INTO `wp_area` VALUES ('2350', '安县', '2345', '2087');
INSERT INTO `wp_area` VALUES ('2351', '梓潼县', '2345', '2088');
INSERT INTO `wp_area` VALUES ('2352', '北川羌族自治县', '2345', '2089');
INSERT INTO `wp_area` VALUES ('2353', '平武县', '2345', '2090');
INSERT INTO `wp_area` VALUES ('2354', '江油市', '2345', '2091');
INSERT INTO `wp_area` VALUES ('2355', '广元市', '2296', '241');
INSERT INTO `wp_area` VALUES ('2356', '市中区', '2355', '2092');
INSERT INTO `wp_area` VALUES ('2357', '元坝区', '2355', '2093');
INSERT INTO `wp_area` VALUES ('2358', '朝天区', '2355', '2094');
INSERT INTO `wp_area` VALUES ('2359', '旺苍县', '2355', '2095');
INSERT INTO `wp_area` VALUES ('2360', '青川县', '2355', '2096');
INSERT INTO `wp_area` VALUES ('2361', '剑阁县', '2355', '2097');
INSERT INTO `wp_area` VALUES ('2362', '苍溪县', '2355', '2098');
INSERT INTO `wp_area` VALUES ('2363', '遂宁市', '2296', '242');
INSERT INTO `wp_area` VALUES ('2364', '船山区', '2363', '2099');
INSERT INTO `wp_area` VALUES ('2365', '安居区', '2363', '2100');
INSERT INTO `wp_area` VALUES ('2366', '蓬溪县', '2363', '2101');
INSERT INTO `wp_area` VALUES ('2367', '射洪县', '2363', '2102');
INSERT INTO `wp_area` VALUES ('2368', '大英县', '2363', '2103');
INSERT INTO `wp_area` VALUES ('2369', '内江市', '2296', '243');
INSERT INTO `wp_area` VALUES ('2370', '市中区', '2369', '2104');
INSERT INTO `wp_area` VALUES ('2371', '东兴区', '2369', '2105');
INSERT INTO `wp_area` VALUES ('2372', '威远县', '2369', '2106');
INSERT INTO `wp_area` VALUES ('2373', '资中县', '2369', '2107');
INSERT INTO `wp_area` VALUES ('2374', '隆昌县', '2369', '2108');
INSERT INTO `wp_area` VALUES ('2375', '乐山市', '2296', '244');
INSERT INTO `wp_area` VALUES ('2376', '市中区', '2375', '2109');
INSERT INTO `wp_area` VALUES ('2377', '沙湾区', '2375', '2110');
INSERT INTO `wp_area` VALUES ('2378', '五通桥区', '2375', '2111');
INSERT INTO `wp_area` VALUES ('2379', '金口河区', '2375', '2112');
INSERT INTO `wp_area` VALUES ('2380', '犍为县', '2375', '2113');
INSERT INTO `wp_area` VALUES ('2381', '井研县', '2375', '2114');
INSERT INTO `wp_area` VALUES ('2382', '夹江县', '2375', '2115');
INSERT INTO `wp_area` VALUES ('2383', '沐川县', '2375', '2116');
INSERT INTO `wp_area` VALUES ('2384', '峨边彝族自治县', '2375', '2117');
INSERT INTO `wp_area` VALUES ('2385', '马边彝族自治县', '2375', '2118');
INSERT INTO `wp_area` VALUES ('2386', '峨眉山市', '2375', '2119');
INSERT INTO `wp_area` VALUES ('2387', '南充市', '2296', '245');
INSERT INTO `wp_area` VALUES ('2388', '顺庆区', '2387', '2120');
INSERT INTO `wp_area` VALUES ('2389', '高坪区', '2387', '2121');
INSERT INTO `wp_area` VALUES ('2390', '嘉陵区', '2387', '2122');
INSERT INTO `wp_area` VALUES ('2391', '南部县', '2387', '2123');
INSERT INTO `wp_area` VALUES ('2392', '营山县', '2387', '2124');
INSERT INTO `wp_area` VALUES ('2393', '蓬安县', '2387', '2125');
INSERT INTO `wp_area` VALUES ('2394', '仪陇县', '2387', '2126');
INSERT INTO `wp_area` VALUES ('2395', '西充县', '2387', '2127');
INSERT INTO `wp_area` VALUES ('2396', '阆中市', '2387', '2128');
INSERT INTO `wp_area` VALUES ('2397', '眉山市', '2296', '246');
INSERT INTO `wp_area` VALUES ('2398', '东坡区', '2397', '2129');
INSERT INTO `wp_area` VALUES ('2399', '仁寿县', '2397', '2130');
INSERT INTO `wp_area` VALUES ('2400', '彭山县', '2397', '2131');
INSERT INTO `wp_area` VALUES ('2401', '洪雅县', '2397', '2132');
INSERT INTO `wp_area` VALUES ('2402', '丹棱县', '2397', '2133');
INSERT INTO `wp_area` VALUES ('2403', '青神县', '2397', '2134');
INSERT INTO `wp_area` VALUES ('2404', '宜宾市', '2296', '247');
INSERT INTO `wp_area` VALUES ('2405', '翠屏区', '2404', '2135');
INSERT INTO `wp_area` VALUES ('2406', '宜宾县', '2404', '2136');
INSERT INTO `wp_area` VALUES ('2407', '南溪县', '2404', '2137');
INSERT INTO `wp_area` VALUES ('2408', '江安县', '2404', '2138');
INSERT INTO `wp_area` VALUES ('2409', '长宁县', '2404', '2139');
INSERT INTO `wp_area` VALUES ('2410', '高县', '2404', '2140');
INSERT INTO `wp_area` VALUES ('2411', '珙县', '2404', '2141');
INSERT INTO `wp_area` VALUES ('2412', '筠连县', '2404', '2142');
INSERT INTO `wp_area` VALUES ('2413', '兴文县', '2404', '2143');
INSERT INTO `wp_area` VALUES ('2414', '屏山县', '2404', '2144');
INSERT INTO `wp_area` VALUES ('2415', '广安市', '2296', '248');
INSERT INTO `wp_area` VALUES ('2416', '广安区', '2415', '2145');
INSERT INTO `wp_area` VALUES ('2417', '岳池县', '2415', '2146');
INSERT INTO `wp_area` VALUES ('2418', '武胜县', '2415', '2147');
INSERT INTO `wp_area` VALUES ('2419', '邻水县', '2415', '2148');
INSERT INTO `wp_area` VALUES ('2420', '华蓥市', '2415', '2149');
INSERT INTO `wp_area` VALUES ('2421', '达州市', '2296', '249');
INSERT INTO `wp_area` VALUES ('2422', '通川区', '2421', '2150');
INSERT INTO `wp_area` VALUES ('2423', '达县', '2421', '2151');
INSERT INTO `wp_area` VALUES ('2424', '宣汉县', '2421', '2152');
INSERT INTO `wp_area` VALUES ('2425', '开江县', '2421', '2153');
INSERT INTO `wp_area` VALUES ('2426', '大竹县', '2421', '2154');
INSERT INTO `wp_area` VALUES ('2427', '渠县', '2421', '2155');
INSERT INTO `wp_area` VALUES ('2428', '万源市', '2421', '2156');
INSERT INTO `wp_area` VALUES ('2429', '雅安市', '2296', '250');
INSERT INTO `wp_area` VALUES ('2430', '雨城区', '2429', '2157');
INSERT INTO `wp_area` VALUES ('2431', '名山县', '2429', '2158');
INSERT INTO `wp_area` VALUES ('2432', '荥经县', '2429', '2159');
INSERT INTO `wp_area` VALUES ('2433', '汉源县', '2429', '2160');
INSERT INTO `wp_area` VALUES ('2434', '石棉县', '2429', '2161');
INSERT INTO `wp_area` VALUES ('2435', '天全县', '2429', '2162');
INSERT INTO `wp_area` VALUES ('2436', '芦山县', '2429', '2163');
INSERT INTO `wp_area` VALUES ('2437', '宝兴县', '2429', '2164');
INSERT INTO `wp_area` VALUES ('2438', '巴中市', '2296', '251');
INSERT INTO `wp_area` VALUES ('2439', '巴州区', '2438', '2165');
INSERT INTO `wp_area` VALUES ('2440', '通江县', '2438', '2166');
INSERT INTO `wp_area` VALUES ('2441', '南江县', '2438', '2167');
INSERT INTO `wp_area` VALUES ('2442', '平昌县', '2438', '2168');
INSERT INTO `wp_area` VALUES ('2443', '资阳市', '2296', '252');
INSERT INTO `wp_area` VALUES ('2444', '雁江区', '2443', '2169');
INSERT INTO `wp_area` VALUES ('2445', '安岳县', '2443', '2170');
INSERT INTO `wp_area` VALUES ('2446', '乐至县', '2443', '2171');
INSERT INTO `wp_area` VALUES ('2447', '简阳市', '2443', '2172');
INSERT INTO `wp_area` VALUES ('2448', '阿坝藏族羌族自治州', '2296', '253');
INSERT INTO `wp_area` VALUES ('2449', '汶川县', '2448', '2173');
INSERT INTO `wp_area` VALUES ('2450', '理县', '2448', '2174');
INSERT INTO `wp_area` VALUES ('2451', '茂县', '2448', '2175');
INSERT INTO `wp_area` VALUES ('2452', '松潘县', '2448', '2176');
INSERT INTO `wp_area` VALUES ('2453', '九寨沟县', '2448', '2177');
INSERT INTO `wp_area` VALUES ('2454', '金川县', '2448', '2178');
INSERT INTO `wp_area` VALUES ('2455', '小金县', '2448', '2179');
INSERT INTO `wp_area` VALUES ('2456', '黑水县', '2448', '2180');
INSERT INTO `wp_area` VALUES ('2457', '马尔康县', '2448', '2181');
INSERT INTO `wp_area` VALUES ('2458', '壤塘县', '2448', '2182');
INSERT INTO `wp_area` VALUES ('2459', '阿坝县', '2448', '2183');
INSERT INTO `wp_area` VALUES ('2460', '若尔盖县', '2448', '2184');
INSERT INTO `wp_area` VALUES ('2461', '红原县', '2448', '2185');
INSERT INTO `wp_area` VALUES ('2462', '甘孜藏族自治州', '2296', '254');
INSERT INTO `wp_area` VALUES ('2463', '康定县', '2462', '2186');
INSERT INTO `wp_area` VALUES ('2464', '泸定县', '2462', '2187');
INSERT INTO `wp_area` VALUES ('2465', '丹巴县', '2462', '2188');
INSERT INTO `wp_area` VALUES ('2466', '九龙县', '2462', '2189');
INSERT INTO `wp_area` VALUES ('2467', '雅江县', '2462', '2190');
INSERT INTO `wp_area` VALUES ('2468', '道孚县', '2462', '2191');
INSERT INTO `wp_area` VALUES ('2469', '炉霍县', '2462', '2192');
INSERT INTO `wp_area` VALUES ('2470', '甘孜县', '2462', '2193');
INSERT INTO `wp_area` VALUES ('2471', '新龙县', '2462', '2194');
INSERT INTO `wp_area` VALUES ('2472', '德格县', '2462', '2195');
INSERT INTO `wp_area` VALUES ('2473', '白玉县', '2462', '2196');
INSERT INTO `wp_area` VALUES ('2474', '石渠县', '2462', '2197');
INSERT INTO `wp_area` VALUES ('2475', '色达县', '2462', '2198');
INSERT INTO `wp_area` VALUES ('2476', '理塘县', '2462', '2199');
INSERT INTO `wp_area` VALUES ('2477', '巴塘县', '2462', '2200');
INSERT INTO `wp_area` VALUES ('2478', '乡城县', '2462', '2201');
INSERT INTO `wp_area` VALUES ('2479', '稻城县', '2462', '2202');
INSERT INTO `wp_area` VALUES ('2480', '得荣县', '2462', '2203');
INSERT INTO `wp_area` VALUES ('2481', '凉山彝族自治州', '2296', '255');
INSERT INTO `wp_area` VALUES ('2482', '西昌市', '2481', '2204');
INSERT INTO `wp_area` VALUES ('2483', '木里藏族自治县', '2481', '2205');
INSERT INTO `wp_area` VALUES ('2484', '盐源县', '2481', '2206');
INSERT INTO `wp_area` VALUES ('2485', '德昌县', '2481', '2207');
INSERT INTO `wp_area` VALUES ('2486', '会理县', '2481', '2208');
INSERT INTO `wp_area` VALUES ('2487', '会东县', '2481', '2209');
INSERT INTO `wp_area` VALUES ('2488', '宁南县', '2481', '2210');
INSERT INTO `wp_area` VALUES ('2489', '普格县', '2481', '2211');
INSERT INTO `wp_area` VALUES ('2490', '布拖县', '2481', '2212');
INSERT INTO `wp_area` VALUES ('2491', '金阳县', '2481', '2213');
INSERT INTO `wp_area` VALUES ('2492', '昭觉县', '2481', '2214');
INSERT INTO `wp_area` VALUES ('2493', '喜德县', '2481', '2215');
INSERT INTO `wp_area` VALUES ('2494', '冕宁县', '2481', '2216');
INSERT INTO `wp_area` VALUES ('2495', '越西县', '2481', '2217');
INSERT INTO `wp_area` VALUES ('2496', '甘洛县', '2481', '2218');
INSERT INTO `wp_area` VALUES ('2497', '美姑县', '2481', '2219');
INSERT INTO `wp_area` VALUES ('2498', '雷波县', '2481', '2220');
INSERT INTO `wp_area` VALUES ('2499', '贵州省', '0', '24');
INSERT INTO `wp_area` VALUES ('2500', '贵阳市', '2499', '256');
INSERT INTO `wp_area` VALUES ('2501', '南明区', '2500', '2221');
INSERT INTO `wp_area` VALUES ('2502', '云岩区', '2500', '2222');
INSERT INTO `wp_area` VALUES ('2503', '花溪区', '2500', '2223');
INSERT INTO `wp_area` VALUES ('2504', '乌当区', '2500', '2224');
INSERT INTO `wp_area` VALUES ('2505', '白云区', '2500', '2225');
INSERT INTO `wp_area` VALUES ('2506', '小河区', '2500', '2226');
INSERT INTO `wp_area` VALUES ('2507', '开阳县', '2500', '2227');
INSERT INTO `wp_area` VALUES ('2508', '息烽县', '2500', '2228');
INSERT INTO `wp_area` VALUES ('2509', '修文县', '2500', '2229');
INSERT INTO `wp_area` VALUES ('2510', '清镇市', '2500', '2230');
INSERT INTO `wp_area` VALUES ('2511', '六盘水市', '2499', '257');
INSERT INTO `wp_area` VALUES ('2512', '钟山区', '2511', '2231');
INSERT INTO `wp_area` VALUES ('2513', '六枝特区', '2511', '2232');
INSERT INTO `wp_area` VALUES ('2514', '水城县', '2511', '2233');
INSERT INTO `wp_area` VALUES ('2515', '盘县', '2511', '2234');
INSERT INTO `wp_area` VALUES ('2516', '遵义市', '2499', '258');
INSERT INTO `wp_area` VALUES ('2517', '红花岗区', '2516', '2235');
INSERT INTO `wp_area` VALUES ('2518', '汇川区', '2516', '2236');
INSERT INTO `wp_area` VALUES ('2519', '遵义县', '2516', '2237');
INSERT INTO `wp_area` VALUES ('2520', '桐梓县', '2516', '2238');
INSERT INTO `wp_area` VALUES ('2521', '绥阳县', '2516', '2239');
INSERT INTO `wp_area` VALUES ('2522', '正安县', '2516', '2240');
INSERT INTO `wp_area` VALUES ('2523', '道真仡佬族苗族自治县', '2516', '2241');
INSERT INTO `wp_area` VALUES ('2524', '务川仡佬族苗族自治县', '2516', '2242');
INSERT INTO `wp_area` VALUES ('2525', '凤冈县', '2516', '2243');
INSERT INTO `wp_area` VALUES ('2526', '湄潭县', '2516', '2244');
INSERT INTO `wp_area` VALUES ('2527', '余庆县', '2516', '2245');
INSERT INTO `wp_area` VALUES ('2528', '习水县', '2516', '2246');
INSERT INTO `wp_area` VALUES ('2529', '赤水市', '2516', '2247');
INSERT INTO `wp_area` VALUES ('2530', '仁怀市', '2516', '2248');
INSERT INTO `wp_area` VALUES ('2531', '安顺市', '2499', '259');
INSERT INTO `wp_area` VALUES ('2532', '西秀区', '2531', '2249');
INSERT INTO `wp_area` VALUES ('2533', '平坝县', '2531', '2250');
INSERT INTO `wp_area` VALUES ('2534', '普定县', '2531', '2251');
INSERT INTO `wp_area` VALUES ('2535', '镇宁布依族苗族自治县', '2531', '2252');
INSERT INTO `wp_area` VALUES ('2536', '关岭布依族苗族自治县', '2531', '2253');
INSERT INTO `wp_area` VALUES ('2537', '紫云苗族布依族自治县', '2531', '2254');
INSERT INTO `wp_area` VALUES ('2538', '铜仁地区', '2499', '260');
INSERT INTO `wp_area` VALUES ('2539', '铜仁市', '2538', '2255');
INSERT INTO `wp_area` VALUES ('2540', '江口县', '2538', '2256');
INSERT INTO `wp_area` VALUES ('2541', '玉屏侗族自治县', '2538', '2257');
INSERT INTO `wp_area` VALUES ('2542', '石阡县', '2538', '2258');
INSERT INTO `wp_area` VALUES ('2543', '思南县', '2538', '2259');
INSERT INTO `wp_area` VALUES ('2544', '印江土家族苗族自治县', '2538', '2260');
INSERT INTO `wp_area` VALUES ('2545', '德江县', '2538', '2261');
INSERT INTO `wp_area` VALUES ('2546', '沿河土家族自治县', '2538', '2262');
INSERT INTO `wp_area` VALUES ('2547', '松桃苗族自治县', '2538', '2263');
INSERT INTO `wp_area` VALUES ('2548', '万山特区', '2538', '2264');
INSERT INTO `wp_area` VALUES ('2549', '黔西南布依族苗族自治州', '2499', '261');
INSERT INTO `wp_area` VALUES ('2550', '兴义市', '2549', '2265');
INSERT INTO `wp_area` VALUES ('2551', '兴仁县', '2549', '2266');
INSERT INTO `wp_area` VALUES ('2552', '普安县', '2549', '2267');
INSERT INTO `wp_area` VALUES ('2553', '晴隆县', '2549', '2268');
INSERT INTO `wp_area` VALUES ('2554', '贞丰县', '2549', '2269');
INSERT INTO `wp_area` VALUES ('2555', '望谟县', '2549', '2270');
INSERT INTO `wp_area` VALUES ('2556', '册亨县', '2549', '2271');
INSERT INTO `wp_area` VALUES ('2557', '安龙县', '2549', '2272');
INSERT INTO `wp_area` VALUES ('2558', '毕节地区', '2499', '262');
INSERT INTO `wp_area` VALUES ('2559', '毕节市', '2558', '2273');
INSERT INTO `wp_area` VALUES ('2560', '大方县', '2558', '2274');
INSERT INTO `wp_area` VALUES ('2561', '黔西县', '2558', '2275');
INSERT INTO `wp_area` VALUES ('2562', '金沙县', '2558', '2276');
INSERT INTO `wp_area` VALUES ('2563', '织金县', '2558', '2277');
INSERT INTO `wp_area` VALUES ('2564', '纳雍县', '2558', '2278');
INSERT INTO `wp_area` VALUES ('2565', '威宁彝族回族苗族自治县', '2558', '2279');
INSERT INTO `wp_area` VALUES ('2566', '赫章县', '2558', '2280');
INSERT INTO `wp_area` VALUES ('2567', '黔东南苗族侗族自治州', '2499', '263');
INSERT INTO `wp_area` VALUES ('2568', '凯里市', '2567', '2281');
INSERT INTO `wp_area` VALUES ('2569', '黄平县', '2567', '2282');
INSERT INTO `wp_area` VALUES ('2570', '施秉县', '2567', '2283');
INSERT INTO `wp_area` VALUES ('2571', '三穗县', '2567', '2284');
INSERT INTO `wp_area` VALUES ('2572', '镇远县', '2567', '2285');
INSERT INTO `wp_area` VALUES ('2573', '岑巩县', '2567', '2286');
INSERT INTO `wp_area` VALUES ('2574', '天柱县', '2567', '2287');
INSERT INTO `wp_area` VALUES ('2575', '锦屏县', '2567', '2288');
INSERT INTO `wp_area` VALUES ('2576', '剑河县', '2567', '2289');
INSERT INTO `wp_area` VALUES ('2577', '台江县', '2567', '2290');
INSERT INTO `wp_area` VALUES ('2578', '黎平县', '2567', '2291');
INSERT INTO `wp_area` VALUES ('2579', '榕江县', '2567', '2292');
INSERT INTO `wp_area` VALUES ('2580', '从江县', '2567', '2293');
INSERT INTO `wp_area` VALUES ('2581', '雷山县', '2567', '2294');
INSERT INTO `wp_area` VALUES ('2582', '麻江县', '2567', '2295');
INSERT INTO `wp_area` VALUES ('2583', '丹寨县', '2567', '2296');
INSERT INTO `wp_area` VALUES ('2584', '黔南布依族苗族自治州', '2499', '264');
INSERT INTO `wp_area` VALUES ('2585', '都匀市', '2584', '2297');
INSERT INTO `wp_area` VALUES ('2586', '福泉市', '2584', '2298');
INSERT INTO `wp_area` VALUES ('2587', '荔波县', '2584', '2299');
INSERT INTO `wp_area` VALUES ('2588', '贵定县', '2584', '2300');
INSERT INTO `wp_area` VALUES ('2589', '瓮安县', '2584', '2301');
INSERT INTO `wp_area` VALUES ('2590', '独山县', '2584', '2302');
INSERT INTO `wp_area` VALUES ('2591', '平塘县', '2584', '2303');
INSERT INTO `wp_area` VALUES ('2592', '罗甸县', '2584', '2304');
INSERT INTO `wp_area` VALUES ('2593', '长顺县', '2584', '2305');
INSERT INTO `wp_area` VALUES ('2594', '龙里县', '2584', '2306');
INSERT INTO `wp_area` VALUES ('2595', '惠水县', '2584', '2307');
INSERT INTO `wp_area` VALUES ('2596', '三都水族自治县', '2584', '2308');
INSERT INTO `wp_area` VALUES ('2597', '云南省', '0', '25');
INSERT INTO `wp_area` VALUES ('2598', '昆明市', '2597', '265');
INSERT INTO `wp_area` VALUES ('2599', '五华区', '2598', '2309');
INSERT INTO `wp_area` VALUES ('2600', '盘龙区', '2598', '2310');
INSERT INTO `wp_area` VALUES ('2601', '官渡区', '2598', '2311');
INSERT INTO `wp_area` VALUES ('2602', '西山区', '2598', '2312');
INSERT INTO `wp_area` VALUES ('2603', '东川区', '2598', '2313');
INSERT INTO `wp_area` VALUES ('2604', '呈贡县', '2598', '2314');
INSERT INTO `wp_area` VALUES ('2605', '晋宁县', '2598', '2315');
INSERT INTO `wp_area` VALUES ('2606', '富民县', '2598', '2316');
INSERT INTO `wp_area` VALUES ('2607', '宜良县', '2598', '2317');
INSERT INTO `wp_area` VALUES ('2608', '石林彝族自治县', '2598', '2318');
INSERT INTO `wp_area` VALUES ('2609', '嵩明县', '2598', '2319');
INSERT INTO `wp_area` VALUES ('2610', '禄劝彝族苗族自治县', '2598', '2320');
INSERT INTO `wp_area` VALUES ('2611', '寻甸回族彝族自治县', '2598', '2321');
INSERT INTO `wp_area` VALUES ('2612', '安宁市', '2598', '2322');
INSERT INTO `wp_area` VALUES ('2613', '曲靖市', '2597', '266');
INSERT INTO `wp_area` VALUES ('2614', '麒麟区', '2613', '2323');
INSERT INTO `wp_area` VALUES ('2615', '马龙县', '2613', '2324');
INSERT INTO `wp_area` VALUES ('2616', '陆良县', '2613', '2325');
INSERT INTO `wp_area` VALUES ('2617', '师宗县', '2613', '2326');
INSERT INTO `wp_area` VALUES ('2618', '罗平县', '2613', '2327');
INSERT INTO `wp_area` VALUES ('2619', '富源县', '2613', '2328');
INSERT INTO `wp_area` VALUES ('2620', '会泽县', '2613', '2329');
INSERT INTO `wp_area` VALUES ('2621', '沾益县', '2613', '2330');
INSERT INTO `wp_area` VALUES ('2622', '宣威市', '2613', '2331');
INSERT INTO `wp_area` VALUES ('2623', '玉溪市', '2597', '267');
INSERT INTO `wp_area` VALUES ('2624', '红塔区', '2623', '2332');
INSERT INTO `wp_area` VALUES ('2625', '江川县', '2623', '2333');
INSERT INTO `wp_area` VALUES ('2626', '澄江县', '2623', '2334');
INSERT INTO `wp_area` VALUES ('2627', '通海县', '2623', '2335');
INSERT INTO `wp_area` VALUES ('2628', '华宁县', '2623', '2336');
INSERT INTO `wp_area` VALUES ('2629', '易门县', '2623', '2337');
INSERT INTO `wp_area` VALUES ('2630', '峨山彝族自治县', '2623', '2338');
INSERT INTO `wp_area` VALUES ('2631', '新平彝族傣族自治县', '2623', '2339');
INSERT INTO `wp_area` VALUES ('2632', '元江哈尼族彝族傣族自治县', '2623', '2340');
INSERT INTO `wp_area` VALUES ('2633', '保山市', '2597', '268');
INSERT INTO `wp_area` VALUES ('2634', '隆阳区', '2633', '2341');
INSERT INTO `wp_area` VALUES ('2635', '施甸县', '2633', '2342');
INSERT INTO `wp_area` VALUES ('2636', '腾冲县', '2633', '2343');
INSERT INTO `wp_area` VALUES ('2637', '龙陵县', '2633', '2344');
INSERT INTO `wp_area` VALUES ('2638', '昌宁县', '2633', '2345');
INSERT INTO `wp_area` VALUES ('2639', '昭通市', '2597', '269');
INSERT INTO `wp_area` VALUES ('2640', '昭阳区', '2639', '2346');
INSERT INTO `wp_area` VALUES ('2641', '鲁甸县', '2639', '2347');
INSERT INTO `wp_area` VALUES ('2642', '巧家县', '2639', '2348');
INSERT INTO `wp_area` VALUES ('2643', '盐津县', '2639', '2349');
INSERT INTO `wp_area` VALUES ('2644', '大关县', '2639', '2350');
INSERT INTO `wp_area` VALUES ('2645', '永善县', '2639', '2351');
INSERT INTO `wp_area` VALUES ('2646', '绥江县', '2639', '2352');
INSERT INTO `wp_area` VALUES ('2647', '镇雄县', '2639', '2353');
INSERT INTO `wp_area` VALUES ('2648', '彝良县', '2639', '2354');
INSERT INTO `wp_area` VALUES ('2649', '威信县', '2639', '2355');
INSERT INTO `wp_area` VALUES ('2650', '水富县', '2639', '2356');
INSERT INTO `wp_area` VALUES ('2651', '丽江市', '2597', '270');
INSERT INTO `wp_area` VALUES ('2652', '古城区', '2651', '2357');
INSERT INTO `wp_area` VALUES ('2653', '玉龙纳西族自治县', '2651', '2358');
INSERT INTO `wp_area` VALUES ('2654', '永胜县', '2651', '2359');
INSERT INTO `wp_area` VALUES ('2655', '华坪县', '2651', '2360');
INSERT INTO `wp_area` VALUES ('2656', '宁蒗彝族自治县', '2651', '2361');
INSERT INTO `wp_area` VALUES ('2657', '思茅市', '2597', '271');
INSERT INTO `wp_area` VALUES ('2658', '翠云区', '2657', '2362');
INSERT INTO `wp_area` VALUES ('2659', '普洱哈尼族彝族自治县', '2657', '2363');
INSERT INTO `wp_area` VALUES ('2660', '墨江哈尼族自治县', '2657', '2364');
INSERT INTO `wp_area` VALUES ('2661', '景东彝族自治县', '2657', '2365');
INSERT INTO `wp_area` VALUES ('2662', '景谷傣族彝族自治县', '2657', '2366');
INSERT INTO `wp_area` VALUES ('2663', '镇沅彝族哈尼族拉祜族自治县', '2657', '2367');
INSERT INTO `wp_area` VALUES ('2664', '江城哈尼族彝族自治县', '2657', '2368');
INSERT INTO `wp_area` VALUES ('2665', '孟连傣族拉祜族佤族自治县', '2657', '2369');
INSERT INTO `wp_area` VALUES ('2666', '澜沧拉祜族自治县', '2657', '2370');
INSERT INTO `wp_area` VALUES ('2667', '西盟佤族自治县', '2657', '2371');
INSERT INTO `wp_area` VALUES ('2668', '临沧市', '2597', '272');
INSERT INTO `wp_area` VALUES ('2669', '临翔区', '2668', '2372');
INSERT INTO `wp_area` VALUES ('2670', '凤庆县', '2668', '2373');
INSERT INTO `wp_area` VALUES ('2671', '云县', '2668', '2374');
INSERT INTO `wp_area` VALUES ('2672', '永德县', '2668', '2375');
INSERT INTO `wp_area` VALUES ('2673', '镇康县', '2668', '2376');
INSERT INTO `wp_area` VALUES ('2674', '双江拉祜族佤族布朗族傣族自治县', '2668', '2377');
INSERT INTO `wp_area` VALUES ('2675', '耿马傣族佤族自治县', '2668', '2378');
INSERT INTO `wp_area` VALUES ('2676', '沧源佤族自治县', '2668', '2379');
INSERT INTO `wp_area` VALUES ('2677', '楚雄彝族自治州', '2597', '273');
INSERT INTO `wp_area` VALUES ('2678', '楚雄市', '2677', '2380');
INSERT INTO `wp_area` VALUES ('2679', '双柏县', '2677', '2381');
INSERT INTO `wp_area` VALUES ('2680', '牟定县', '2677', '2382');
INSERT INTO `wp_area` VALUES ('2681', '南华县', '2677', '2383');
INSERT INTO `wp_area` VALUES ('2682', '姚安县', '2677', '2384');
INSERT INTO `wp_area` VALUES ('2683', '大姚县', '2677', '2385');
INSERT INTO `wp_area` VALUES ('2684', '永仁县', '2677', '2386');
INSERT INTO `wp_area` VALUES ('2685', '元谋县', '2677', '2387');
INSERT INTO `wp_area` VALUES ('2686', '武定县', '2677', '2388');
INSERT INTO `wp_area` VALUES ('2687', '禄丰县', '2677', '2389');
INSERT INTO `wp_area` VALUES ('2688', '红河哈尼族彝族自治州', '2597', '274');
INSERT INTO `wp_area` VALUES ('2689', '个旧市', '2688', '2390');
INSERT INTO `wp_area` VALUES ('2690', '开远市', '2688', '2391');
INSERT INTO `wp_area` VALUES ('2691', '蒙自县', '2688', '2392');
INSERT INTO `wp_area` VALUES ('2692', '屏边苗族自治县', '2688', '2393');
INSERT INTO `wp_area` VALUES ('2693', '建水县', '2688', '2394');
INSERT INTO `wp_area` VALUES ('2694', '石屏县', '2688', '2395');
INSERT INTO `wp_area` VALUES ('2695', '弥勒县', '2688', '2396');
INSERT INTO `wp_area` VALUES ('2696', '泸西县', '2688', '2397');
INSERT INTO `wp_area` VALUES ('2697', '元阳县', '2688', '2398');
INSERT INTO `wp_area` VALUES ('2698', '红河县', '2688', '2399');
INSERT INTO `wp_area` VALUES ('2699', '金平苗族瑶族傣族自治县', '2688', '2400');
INSERT INTO `wp_area` VALUES ('2700', '绿春县', '2688', '2401');
INSERT INTO `wp_area` VALUES ('2701', '河口瑶族自治县', '2688', '2402');
INSERT INTO `wp_area` VALUES ('2702', '文山壮族苗族自治州', '2597', '275');
INSERT INTO `wp_area` VALUES ('2703', '文山县', '2702', '2403');
INSERT INTO `wp_area` VALUES ('2704', '砚山县', '2702', '2404');
INSERT INTO `wp_area` VALUES ('2705', '西畴县', '2702', '2405');
INSERT INTO `wp_area` VALUES ('2706', '麻栗坡县', '2702', '2406');
INSERT INTO `wp_area` VALUES ('2707', '马关县', '2702', '2407');
INSERT INTO `wp_area` VALUES ('2708', '丘北县', '2702', '2408');
INSERT INTO `wp_area` VALUES ('2709', '广南县', '2702', '2409');
INSERT INTO `wp_area` VALUES ('2710', '富宁县', '2702', '2410');
INSERT INTO `wp_area` VALUES ('2711', '西双版纳傣族自治州', '2597', '276');
INSERT INTO `wp_area` VALUES ('2712', '景洪市', '2711', '2411');
INSERT INTO `wp_area` VALUES ('2713', '勐海县', '2711', '2412');
INSERT INTO `wp_area` VALUES ('2714', '勐腊县', '2711', '2413');
INSERT INTO `wp_area` VALUES ('2715', '大理白族自治州', '2597', '277');
INSERT INTO `wp_area` VALUES ('2716', '大理市', '2715', '2414');
INSERT INTO `wp_area` VALUES ('2717', '漾濞彝族自治县', '2715', '2415');
INSERT INTO `wp_area` VALUES ('2718', '祥云县', '2715', '2416');
INSERT INTO `wp_area` VALUES ('2719', '宾川县', '2715', '2417');
INSERT INTO `wp_area` VALUES ('2720', '弥渡县', '2715', '2418');
INSERT INTO `wp_area` VALUES ('2721', '南涧彝族自治县', '2715', '2419');
INSERT INTO `wp_area` VALUES ('2722', '巍山彝族回族自治县', '2715', '2420');
INSERT INTO `wp_area` VALUES ('2723', '永平县', '2715', '2421');
INSERT INTO `wp_area` VALUES ('2724', '云龙县', '2715', '2422');
INSERT INTO `wp_area` VALUES ('2725', '洱源县', '2715', '2423');
INSERT INTO `wp_area` VALUES ('2726', '剑川县', '2715', '2424');
INSERT INTO `wp_area` VALUES ('2727', '鹤庆县', '2715', '2425');
INSERT INTO `wp_area` VALUES ('2728', '德宏傣族景颇族自治州', '2597', '278');
INSERT INTO `wp_area` VALUES ('2729', '瑞丽市', '2728', '2426');
INSERT INTO `wp_area` VALUES ('2730', '潞西市', '2728', '2427');
INSERT INTO `wp_area` VALUES ('2731', '梁河县', '2728', '2428');
INSERT INTO `wp_area` VALUES ('2732', '盈江县', '2728', '2429');
INSERT INTO `wp_area` VALUES ('2733', '陇川县', '2728', '2430');
INSERT INTO `wp_area` VALUES ('2734', '怒江傈僳族自治州', '2597', '279');
INSERT INTO `wp_area` VALUES ('2735', '泸水县', '2734', '2431');
INSERT INTO `wp_area` VALUES ('2736', '福贡县', '2734', '2432');
INSERT INTO `wp_area` VALUES ('2737', '贡山独龙族怒族自治县', '2734', '2433');
INSERT INTO `wp_area` VALUES ('2738', '兰坪白族普米族自治县', '2734', '2434');
INSERT INTO `wp_area` VALUES ('2739', '迪庆藏族自治州', '2597', '280');
INSERT INTO `wp_area` VALUES ('2740', '香格里拉县', '2739', '2435');
INSERT INTO `wp_area` VALUES ('2741', '德钦县', '2739', '2436');
INSERT INTO `wp_area` VALUES ('2742', '维西傈僳族自治县', '2739', '2437');
INSERT INTO `wp_area` VALUES ('2743', '西藏自治区', '0', '26');
INSERT INTO `wp_area` VALUES ('2744', '拉萨市', '2743', '281');
INSERT INTO `wp_area` VALUES ('2745', '城关区', '2744', '2438');
INSERT INTO `wp_area` VALUES ('2746', '林周县', '2744', '2439');
INSERT INTO `wp_area` VALUES ('2747', '当雄县', '2744', '2440');
INSERT INTO `wp_area` VALUES ('2748', '尼木县', '2744', '2441');
INSERT INTO `wp_area` VALUES ('2749', '曲水县', '2744', '2442');
INSERT INTO `wp_area` VALUES ('2750', '堆龙德庆县', '2744', '2443');
INSERT INTO `wp_area` VALUES ('2751', '达孜县', '2744', '2444');
INSERT INTO `wp_area` VALUES ('2752', '墨竹工卡县', '2744', '2445');
INSERT INTO `wp_area` VALUES ('2753', '昌都地区', '2743', '282');
INSERT INTO `wp_area` VALUES ('2754', '昌都县', '2753', '2446');
INSERT INTO `wp_area` VALUES ('2755', '江达县', '2753', '2447');
INSERT INTO `wp_area` VALUES ('2756', '贡觉县', '2753', '2448');
INSERT INTO `wp_area` VALUES ('2757', '类乌齐县', '2753', '2449');
INSERT INTO `wp_area` VALUES ('2758', '丁青县', '2753', '2450');
INSERT INTO `wp_area` VALUES ('2759', '察雅县', '2753', '2451');
INSERT INTO `wp_area` VALUES ('2760', '八宿县', '2753', '2452');
INSERT INTO `wp_area` VALUES ('2761', '左贡县', '2753', '2453');
INSERT INTO `wp_area` VALUES ('2762', '芒康县', '2753', '2454');
INSERT INTO `wp_area` VALUES ('2763', '洛隆县', '2753', '2455');
INSERT INTO `wp_area` VALUES ('2764', '边坝县', '2753', '2456');
INSERT INTO `wp_area` VALUES ('2765', '山南地区', '2743', '283');
INSERT INTO `wp_area` VALUES ('2766', '乃东县', '2765', '2457');
INSERT INTO `wp_area` VALUES ('2767', '扎囊县', '2765', '2458');
INSERT INTO `wp_area` VALUES ('2768', '贡嘎县', '2765', '2459');
INSERT INTO `wp_area` VALUES ('2769', '桑日县', '2765', '2460');
INSERT INTO `wp_area` VALUES ('2770', '琼结县', '2765', '2461');
INSERT INTO `wp_area` VALUES ('2771', '曲松县', '2765', '2462');
INSERT INTO `wp_area` VALUES ('2772', '措美县', '2765', '2463');
INSERT INTO `wp_area` VALUES ('2773', '洛扎县', '2765', '2464');
INSERT INTO `wp_area` VALUES ('2774', '加查县', '2765', '2465');
INSERT INTO `wp_area` VALUES ('2775', '隆子县', '2765', '2466');
INSERT INTO `wp_area` VALUES ('2776', '错那县', '2765', '2467');
INSERT INTO `wp_area` VALUES ('2777', '浪卡子县', '2765', '2468');
INSERT INTO `wp_area` VALUES ('2778', '日喀则地区', '2743', '284');
INSERT INTO `wp_area` VALUES ('2779', '日喀则市', '2778', '2469');
INSERT INTO `wp_area` VALUES ('2780', '南木林县', '2778', '2470');
INSERT INTO `wp_area` VALUES ('2781', '江孜县', '2778', '2471');
INSERT INTO `wp_area` VALUES ('2782', '定日县', '2778', '2472');
INSERT INTO `wp_area` VALUES ('2783', '萨迦县', '2778', '2473');
INSERT INTO `wp_area` VALUES ('2784', '拉孜县', '2778', '2474');
INSERT INTO `wp_area` VALUES ('2785', '昂仁县', '2778', '2475');
INSERT INTO `wp_area` VALUES ('2786', '谢通门县', '2778', '2476');
INSERT INTO `wp_area` VALUES ('2787', '白朗县', '2778', '2477');
INSERT INTO `wp_area` VALUES ('2788', '仁布县', '2778', '2478');
INSERT INTO `wp_area` VALUES ('2789', '康马县', '2778', '2479');
INSERT INTO `wp_area` VALUES ('2790', '定结县', '2778', '2480');
INSERT INTO `wp_area` VALUES ('2791', '仲巴县', '2778', '2481');
INSERT INTO `wp_area` VALUES ('2792', '亚东县', '2778', '2482');
INSERT INTO `wp_area` VALUES ('2793', '吉隆县', '2778', '2483');
INSERT INTO `wp_area` VALUES ('2794', '聂拉木县', '2778', '2484');
INSERT INTO `wp_area` VALUES ('2795', '萨嘎县', '2778', '2485');
INSERT INTO `wp_area` VALUES ('2796', '岗巴县', '2778', '2486');
INSERT INTO `wp_area` VALUES ('2797', '那曲地区', '2743', '285');
INSERT INTO `wp_area` VALUES ('2798', '那曲县', '2797', '2487');
INSERT INTO `wp_area` VALUES ('2799', '嘉黎县', '2797', '2488');
INSERT INTO `wp_area` VALUES ('2800', '比如县', '2797', '2489');
INSERT INTO `wp_area` VALUES ('2801', '聂荣县', '2797', '2490');
INSERT INTO `wp_area` VALUES ('2802', '安多县', '2797', '2491');
INSERT INTO `wp_area` VALUES ('2803', '申扎县', '2797', '2492');
INSERT INTO `wp_area` VALUES ('2804', '索县', '2797', '2493');
INSERT INTO `wp_area` VALUES ('2805', '班戈县', '2797', '2494');
INSERT INTO `wp_area` VALUES ('2806', '巴青县', '2797', '2495');
INSERT INTO `wp_area` VALUES ('2807', '尼玛县', '2797', '2496');
INSERT INTO `wp_area` VALUES ('2808', '阿里地区', '2743', '286');
INSERT INTO `wp_area` VALUES ('2809', '普兰县', '2808', '2497');
INSERT INTO `wp_area` VALUES ('2810', '札达县', '2808', '2498');
INSERT INTO `wp_area` VALUES ('2811', '噶尔县', '2808', '2499');
INSERT INTO `wp_area` VALUES ('2812', '日土县', '2808', '2500');
INSERT INTO `wp_area` VALUES ('2813', '革吉县', '2808', '2501');
INSERT INTO `wp_area` VALUES ('2814', '改则县', '2808', '2502');
INSERT INTO `wp_area` VALUES ('2815', '措勤县', '2808', '2503');
INSERT INTO `wp_area` VALUES ('2816', '林芝地区', '2743', '287');
INSERT INTO `wp_area` VALUES ('2817', '林芝县', '2816', '2504');
INSERT INTO `wp_area` VALUES ('2818', '工布江达县', '2816', '2505');
INSERT INTO `wp_area` VALUES ('2819', '米林县', '2816', '2506');
INSERT INTO `wp_area` VALUES ('2820', '墨脱县', '2816', '2507');
INSERT INTO `wp_area` VALUES ('2821', '波密县', '2816', '2508');
INSERT INTO `wp_area` VALUES ('2822', '察隅县', '2816', '2509');
INSERT INTO `wp_area` VALUES ('2823', '朗县', '2816', '2510');
INSERT INTO `wp_area` VALUES ('2824', '陕西省', '0', '27');
INSERT INTO `wp_area` VALUES ('2825', '西安市', '2824', '288');
INSERT INTO `wp_area` VALUES ('2826', '新城区', '2825', '2511');
INSERT INTO `wp_area` VALUES ('2827', '碑林区', '2825', '2512');
INSERT INTO `wp_area` VALUES ('2828', '莲湖区', '2825', '2513');
INSERT INTO `wp_area` VALUES ('2829', '灞桥区', '2825', '2514');
INSERT INTO `wp_area` VALUES ('2830', '未央区', '2825', '2515');
INSERT INTO `wp_area` VALUES ('2831', '雁塔区', '2825', '2516');
INSERT INTO `wp_area` VALUES ('2832', '阎良区', '2825', '2517');
INSERT INTO `wp_area` VALUES ('2833', '临潼区', '2825', '2518');
INSERT INTO `wp_area` VALUES ('2834', '长安区', '2825', '2519');
INSERT INTO `wp_area` VALUES ('2835', '蓝田县', '2825', '2520');
INSERT INTO `wp_area` VALUES ('2836', '周至县', '2825', '2521');
INSERT INTO `wp_area` VALUES ('2837', '户县', '2825', '2522');
INSERT INTO `wp_area` VALUES ('2838', '高陵县', '2825', '2523');
INSERT INTO `wp_area` VALUES ('2839', '铜川市', '2824', '289');
INSERT INTO `wp_area` VALUES ('2840', '王益区', '2839', '2524');
INSERT INTO `wp_area` VALUES ('2841', '印台区', '2839', '2525');
INSERT INTO `wp_area` VALUES ('2842', '耀州区', '2839', '2526');
INSERT INTO `wp_area` VALUES ('2843', '宜君县', '2839', '2527');
INSERT INTO `wp_area` VALUES ('2844', '宝鸡市', '2824', '290');
INSERT INTO `wp_area` VALUES ('2845', '渭滨区', '2844', '2528');
INSERT INTO `wp_area` VALUES ('2846', '金台区', '2844', '2529');
INSERT INTO `wp_area` VALUES ('2847', '陈仓区', '2844', '2530');
INSERT INTO `wp_area` VALUES ('2848', '凤翔县', '2844', '2531');
INSERT INTO `wp_area` VALUES ('2849', '岐山县', '2844', '2532');
INSERT INTO `wp_area` VALUES ('2850', '扶风县', '2844', '2533');
INSERT INTO `wp_area` VALUES ('2851', '眉县', '2844', '2534');
INSERT INTO `wp_area` VALUES ('2852', '陇县', '2844', '2535');
INSERT INTO `wp_area` VALUES ('2853', '千阳县', '2844', '2536');
INSERT INTO `wp_area` VALUES ('2854', '麟游县', '2844', '2537');
INSERT INTO `wp_area` VALUES ('2855', '凤县', '2844', '2538');
INSERT INTO `wp_area` VALUES ('2856', '太白县', '2844', '2539');
INSERT INTO `wp_area` VALUES ('2857', '咸阳市', '2824', '291');
INSERT INTO `wp_area` VALUES ('2858', '秦都区', '2857', '2540');
INSERT INTO `wp_area` VALUES ('2859', '杨凌区', '2857', '2541');
INSERT INTO `wp_area` VALUES ('2860', '渭城区', '2857', '2542');
INSERT INTO `wp_area` VALUES ('2861', '三原县', '2857', '2543');
INSERT INTO `wp_area` VALUES ('2862', '泾阳县', '2857', '2544');
INSERT INTO `wp_area` VALUES ('2863', '乾县', '2857', '2545');
INSERT INTO `wp_area` VALUES ('2864', '礼泉县', '2857', '2546');
INSERT INTO `wp_area` VALUES ('2865', '永寿县', '2857', '2547');
INSERT INTO `wp_area` VALUES ('2866', '彬县', '2857', '2548');
INSERT INTO `wp_area` VALUES ('2867', '长武县', '2857', '2549');
INSERT INTO `wp_area` VALUES ('2868', '旬邑县', '2857', '2550');
INSERT INTO `wp_area` VALUES ('2869', '淳化县', '2857', '2551');
INSERT INTO `wp_area` VALUES ('2870', '武功县', '2857', '2552');
INSERT INTO `wp_area` VALUES ('2871', '兴平市', '2857', '2553');
INSERT INTO `wp_area` VALUES ('2872', '渭南市', '2824', '292');
INSERT INTO `wp_area` VALUES ('2873', '临渭区', '2872', '2554');
INSERT INTO `wp_area` VALUES ('2874', '华县', '2872', '2555');
INSERT INTO `wp_area` VALUES ('2875', '潼关县', '2872', '2556');
INSERT INTO `wp_area` VALUES ('2876', '大荔县', '2872', '2557');
INSERT INTO `wp_area` VALUES ('2877', '合阳县', '2872', '2558');
INSERT INTO `wp_area` VALUES ('2878', '澄城县', '2872', '2559');
INSERT INTO `wp_area` VALUES ('2879', '蒲城县', '2872', '2560');
INSERT INTO `wp_area` VALUES ('2880', '白水县', '2872', '2561');
INSERT INTO `wp_area` VALUES ('2881', '富平县', '2872', '2562');
INSERT INTO `wp_area` VALUES ('2882', '韩城市', '2872', '2563');
INSERT INTO `wp_area` VALUES ('2883', '华阴市', '2872', '2564');
INSERT INTO `wp_area` VALUES ('2884', '延安市', '2824', '293');
INSERT INTO `wp_area` VALUES ('2885', '宝塔区', '2884', '2565');
INSERT INTO `wp_area` VALUES ('2886', '延长县', '2884', '2566');
INSERT INTO `wp_area` VALUES ('2887', '延川县', '2884', '2567');
INSERT INTO `wp_area` VALUES ('2888', '子长县', '2884', '2568');
INSERT INTO `wp_area` VALUES ('2889', '安塞县', '2884', '2569');
INSERT INTO `wp_area` VALUES ('2890', '志丹县', '2884', '2570');
INSERT INTO `wp_area` VALUES ('2891', '吴旗县', '2884', '2571');
INSERT INTO `wp_area` VALUES ('2892', '甘泉县', '2884', '2572');
INSERT INTO `wp_area` VALUES ('2893', '富县', '2884', '2573');
INSERT INTO `wp_area` VALUES ('2894', '洛川县', '2884', '2574');
INSERT INTO `wp_area` VALUES ('2895', '宜川县', '2884', '2575');
INSERT INTO `wp_area` VALUES ('2896', '黄龙县', '2884', '2576');
INSERT INTO `wp_area` VALUES ('2897', '黄陵县', '2884', '2577');
INSERT INTO `wp_area` VALUES ('2898', '汉中市', '2824', '294');
INSERT INTO `wp_area` VALUES ('2899', '汉台区', '2898', '2578');
INSERT INTO `wp_area` VALUES ('2900', '南郑县', '2898', '2579');
INSERT INTO `wp_area` VALUES ('2901', '城固县', '2898', '2580');
INSERT INTO `wp_area` VALUES ('2902', '洋县', '2898', '2581');
INSERT INTO `wp_area` VALUES ('2903', '西乡县', '2898', '2582');
INSERT INTO `wp_area` VALUES ('2904', '勉县', '2898', '2583');
INSERT INTO `wp_area` VALUES ('2905', '宁强县', '2898', '2584');
INSERT INTO `wp_area` VALUES ('2906', '略阳县', '2898', '2585');
INSERT INTO `wp_area` VALUES ('2907', '镇巴县', '2898', '2586');
INSERT INTO `wp_area` VALUES ('2908', '留坝县', '2898', '2587');
INSERT INTO `wp_area` VALUES ('2909', '佛坪县', '2898', '2588');
INSERT INTO `wp_area` VALUES ('2910', '榆林市', '2824', '295');
INSERT INTO `wp_area` VALUES ('2911', '榆阳区', '2910', '2589');
INSERT INTO `wp_area` VALUES ('2912', '神木县', '2910', '2590');
INSERT INTO `wp_area` VALUES ('2913', '府谷县', '2910', '2591');
INSERT INTO `wp_area` VALUES ('2914', '横山县', '2910', '2592');
INSERT INTO `wp_area` VALUES ('2915', '靖边县', '2910', '2593');
INSERT INTO `wp_area` VALUES ('2916', '定边县', '2910', '2594');
INSERT INTO `wp_area` VALUES ('2917', '绥德县', '2910', '2595');
INSERT INTO `wp_area` VALUES ('2918', '米脂县', '2910', '2596');
INSERT INTO `wp_area` VALUES ('2919', '佳县', '2910', '2597');
INSERT INTO `wp_area` VALUES ('2920', '吴堡县', '2910', '2598');
INSERT INTO `wp_area` VALUES ('2921', '清涧县', '2910', '2599');
INSERT INTO `wp_area` VALUES ('2922', '子洲县', '2910', '2600');
INSERT INTO `wp_area` VALUES ('2923', '安康市', '2824', '296');
INSERT INTO `wp_area` VALUES ('2924', '汉滨区', '2923', '2601');
INSERT INTO `wp_area` VALUES ('2925', '汉阴县', '2923', '2602');
INSERT INTO `wp_area` VALUES ('2926', '石泉县', '2923', '2603');
INSERT INTO `wp_area` VALUES ('2927', '宁陕县', '2923', '2604');
INSERT INTO `wp_area` VALUES ('2928', '紫阳县', '2923', '2605');
INSERT INTO `wp_area` VALUES ('2929', '岚皋县', '2923', '2606');
INSERT INTO `wp_area` VALUES ('2930', '平利县', '2923', '2607');
INSERT INTO `wp_area` VALUES ('2931', '镇坪县', '2923', '2608');
INSERT INTO `wp_area` VALUES ('2932', '旬阳县', '2923', '2609');
INSERT INTO `wp_area` VALUES ('2933', '白河县', '2923', '2610');
INSERT INTO `wp_area` VALUES ('2934', '商洛市', '2824', '297');
INSERT INTO `wp_area` VALUES ('2935', '商州区', '2934', '2611');
INSERT INTO `wp_area` VALUES ('2936', '洛南县', '2934', '2612');
INSERT INTO `wp_area` VALUES ('2937', '丹凤县', '2934', '2613');
INSERT INTO `wp_area` VALUES ('2938', '商南县', '2934', '2614');
INSERT INTO `wp_area` VALUES ('2939', '山阳县', '2934', '2615');
INSERT INTO `wp_area` VALUES ('2940', '镇安县', '2934', '2616');
INSERT INTO `wp_area` VALUES ('2941', '柞水县', '2934', '2617');
INSERT INTO `wp_area` VALUES ('2942', '甘肃省', '0', '28');
INSERT INTO `wp_area` VALUES ('2943', '兰州市', '2942', '298');
INSERT INTO `wp_area` VALUES ('2944', '城关区', '2943', '2618');
INSERT INTO `wp_area` VALUES ('2945', '七里河区', '2943', '2619');
INSERT INTO `wp_area` VALUES ('2946', '西固区', '2943', '2620');
INSERT INTO `wp_area` VALUES ('2947', '安宁区', '2943', '2621');
INSERT INTO `wp_area` VALUES ('2948', '红古区', '2943', '2622');
INSERT INTO `wp_area` VALUES ('2949', '永登县', '2943', '2623');
INSERT INTO `wp_area` VALUES ('2950', '皋兰县', '2943', '2624');
INSERT INTO `wp_area` VALUES ('2951', '榆中县', '2943', '2625');
INSERT INTO `wp_area` VALUES ('2952', '嘉峪关市', '2942', '299');
INSERT INTO `wp_area` VALUES ('2953', '金昌市', '2942', '300');
INSERT INTO `wp_area` VALUES ('2954', '金川区', '2953', '2626');
INSERT INTO `wp_area` VALUES ('2955', '永昌县', '2953', '2627');
INSERT INTO `wp_area` VALUES ('2956', '白银市', '2942', '301');
INSERT INTO `wp_area` VALUES ('2957', '白银区', '2956', '2628');
INSERT INTO `wp_area` VALUES ('2958', '平川区', '2956', '2629');
INSERT INTO `wp_area` VALUES ('2959', '靖远县', '2956', '2630');
INSERT INTO `wp_area` VALUES ('2960', '会宁县', '2956', '2631');
INSERT INTO `wp_area` VALUES ('2961', '景泰县', '2956', '2632');
INSERT INTO `wp_area` VALUES ('2962', '天水市', '2942', '302');
INSERT INTO `wp_area` VALUES ('2963', '秦城区', '2962', '2633');
INSERT INTO `wp_area` VALUES ('2964', '北道区', '2962', '2634');
INSERT INTO `wp_area` VALUES ('2965', '清水县', '2962', '2635');
INSERT INTO `wp_area` VALUES ('2966', '秦安县', '2962', '2636');
INSERT INTO `wp_area` VALUES ('2967', '甘谷县', '2962', '2637');
INSERT INTO `wp_area` VALUES ('2968', '武山县', '2962', '2638');
INSERT INTO `wp_area` VALUES ('2969', '张家川回族自治县', '2962', '2639');
INSERT INTO `wp_area` VALUES ('2970', '武威市', '2942', '303');
INSERT INTO `wp_area` VALUES ('2971', '凉州区', '2970', '2640');
INSERT INTO `wp_area` VALUES ('2972', '民勤县', '2970', '2641');
INSERT INTO `wp_area` VALUES ('2973', '古浪县', '2970', '2642');
INSERT INTO `wp_area` VALUES ('2974', '天祝藏族自治县', '2970', '2643');
INSERT INTO `wp_area` VALUES ('2975', '张掖市', '2942', '304');
INSERT INTO `wp_area` VALUES ('2976', '甘州区', '2975', '2644');
INSERT INTO `wp_area` VALUES ('2977', '肃南裕固族自治县', '2975', '2645');
INSERT INTO `wp_area` VALUES ('2978', '民乐县', '2975', '2646');
INSERT INTO `wp_area` VALUES ('2979', '临泽县', '2975', '2647');
INSERT INTO `wp_area` VALUES ('2980', '高台县', '2975', '2648');
INSERT INTO `wp_area` VALUES ('2981', '山丹县', '2975', '2649');
INSERT INTO `wp_area` VALUES ('2982', '平凉市', '2942', '305');
INSERT INTO `wp_area` VALUES ('2983', '崆峒区', '2982', '2650');
INSERT INTO `wp_area` VALUES ('2984', '泾川县', '2982', '2651');
INSERT INTO `wp_area` VALUES ('2985', '灵台县', '2982', '2652');
INSERT INTO `wp_area` VALUES ('2986', '崇信县', '2982', '2653');
INSERT INTO `wp_area` VALUES ('2987', '华亭县', '2982', '2654');
INSERT INTO `wp_area` VALUES ('2988', '庄浪县', '2982', '2655');
INSERT INTO `wp_area` VALUES ('2989', '静宁县', '2982', '2656');
INSERT INTO `wp_area` VALUES ('2990', '酒泉市', '2942', '306');
INSERT INTO `wp_area` VALUES ('2991', '肃州区', '2990', '2657');
INSERT INTO `wp_area` VALUES ('2992', '金塔县', '2990', '2658');
INSERT INTO `wp_area` VALUES ('2993', '安西县', '2990', '2659');
INSERT INTO `wp_area` VALUES ('2994', '肃北蒙古族自治县', '2990', '2660');
INSERT INTO `wp_area` VALUES ('2995', '阿克塞哈萨克族自治县', '2990', '2661');
INSERT INTO `wp_area` VALUES ('2996', '玉门市', '2990', '2662');
INSERT INTO `wp_area` VALUES ('2997', '敦煌市', '2990', '2663');
INSERT INTO `wp_area` VALUES ('2998', '庆阳市', '2942', '307');
INSERT INTO `wp_area` VALUES ('2999', '西峰区', '2998', '2664');
INSERT INTO `wp_area` VALUES ('3000', '庆城县', '2998', '2665');
INSERT INTO `wp_area` VALUES ('3001', '环县', '2998', '2666');
INSERT INTO `wp_area` VALUES ('3002', '华池县', '2998', '2667');
INSERT INTO `wp_area` VALUES ('3003', '合水县', '2998', '2668');
INSERT INTO `wp_area` VALUES ('3004', '正宁县', '2998', '2669');
INSERT INTO `wp_area` VALUES ('3005', '宁县', '2998', '2670');
INSERT INTO `wp_area` VALUES ('3006', '镇原县', '2998', '2671');
INSERT INTO `wp_area` VALUES ('3007', '定西市', '2942', '308');
INSERT INTO `wp_area` VALUES ('3008', '安定区', '3007', '2672');
INSERT INTO `wp_area` VALUES ('3009', '通渭县', '3007', '2673');
INSERT INTO `wp_area` VALUES ('3010', '陇西县', '3007', '2674');
INSERT INTO `wp_area` VALUES ('3011', '渭源县', '3007', '2675');
INSERT INTO `wp_area` VALUES ('3012', '临洮县', '3007', '2676');
INSERT INTO `wp_area` VALUES ('3013', '漳县', '3007', '2677');
INSERT INTO `wp_area` VALUES ('3014', '岷县', '3007', '2678');
INSERT INTO `wp_area` VALUES ('3015', '陇南市', '2942', '309');
INSERT INTO `wp_area` VALUES ('3016', '武都区', '3015', '2679');
INSERT INTO `wp_area` VALUES ('3017', '成县', '3015', '2680');
INSERT INTO `wp_area` VALUES ('3018', '文县', '3015', '2681');
INSERT INTO `wp_area` VALUES ('3019', '宕昌县', '3015', '2682');
INSERT INTO `wp_area` VALUES ('3020', '康县', '3015', '2683');
INSERT INTO `wp_area` VALUES ('3021', '西和县', '3015', '2684');
INSERT INTO `wp_area` VALUES ('3022', '礼县', '3015', '2685');
INSERT INTO `wp_area` VALUES ('3023', '徽县', '3015', '2686');
INSERT INTO `wp_area` VALUES ('3024', '两当县', '3015', '2687');
INSERT INTO `wp_area` VALUES ('3025', '临夏回族自治州', '2942', '310');
INSERT INTO `wp_area` VALUES ('3026', '临夏市', '3025', '2688');
INSERT INTO `wp_area` VALUES ('3027', '临夏县', '3025', '2689');
INSERT INTO `wp_area` VALUES ('3028', '康乐县', '3025', '2690');
INSERT INTO `wp_area` VALUES ('3029', '永靖县', '3025', '2691');
INSERT INTO `wp_area` VALUES ('3030', '广河县', '3025', '2692');
INSERT INTO `wp_area` VALUES ('3031', '和政县', '3025', '2693');
INSERT INTO `wp_area` VALUES ('3032', '东乡族自治县', '3025', '2694');
INSERT INTO `wp_area` VALUES ('3033', '积石山保安族东乡族撒拉族自治县', '3025', '2695');
INSERT INTO `wp_area` VALUES ('3034', '甘南藏族自治州', '2942', '311');
INSERT INTO `wp_area` VALUES ('3035', '合作市', '3034', '2696');
INSERT INTO `wp_area` VALUES ('3036', '临潭县', '3034', '2697');
INSERT INTO `wp_area` VALUES ('3037', '卓尼县', '3034', '2698');
INSERT INTO `wp_area` VALUES ('3038', '舟曲县', '3034', '2699');
INSERT INTO `wp_area` VALUES ('3039', '迭部县', '3034', '2700');
INSERT INTO `wp_area` VALUES ('3040', '玛曲县', '3034', '2701');
INSERT INTO `wp_area` VALUES ('3041', '碌曲县', '3034', '2702');
INSERT INTO `wp_area` VALUES ('3042', '夏河县', '3034', '2703');
INSERT INTO `wp_area` VALUES ('3043', '青海省', '0', '29');
INSERT INTO `wp_area` VALUES ('3044', '西宁市', '3043', '312');
INSERT INTO `wp_area` VALUES ('3045', '城东区', '3044', '2704');
INSERT INTO `wp_area` VALUES ('3046', '城中区', '3044', '2705');
INSERT INTO `wp_area` VALUES ('3047', '城西区', '3044', '2706');
INSERT INTO `wp_area` VALUES ('3048', '城北区', '3044', '2707');
INSERT INTO `wp_area` VALUES ('3049', '大通回族土族自治县', '3044', '2708');
INSERT INTO `wp_area` VALUES ('3050', '湟中县', '3044', '2709');
INSERT INTO `wp_area` VALUES ('3051', '湟源县', '3044', '2710');
INSERT INTO `wp_area` VALUES ('3052', '海东地区', '3043', '313');
INSERT INTO `wp_area` VALUES ('3053', '平安县', '3052', '2711');
INSERT INTO `wp_area` VALUES ('3054', '民和回族土族自治县', '3052', '2712');
INSERT INTO `wp_area` VALUES ('3055', '乐都县', '3052', '2713');
INSERT INTO `wp_area` VALUES ('3056', '互助土族自治县', '3052', '2714');
INSERT INTO `wp_area` VALUES ('3057', '化隆回族自治县', '3052', '2715');
INSERT INTO `wp_area` VALUES ('3058', '循化撒拉族自治县', '3052', '2716');
INSERT INTO `wp_area` VALUES ('3059', '海北藏族自治州', '3043', '314');
INSERT INTO `wp_area` VALUES ('3060', '门源回族自治县', '3059', '2717');
INSERT INTO `wp_area` VALUES ('3061', '祁连县', '3059', '2718');
INSERT INTO `wp_area` VALUES ('3062', '海晏县', '3059', '2719');
INSERT INTO `wp_area` VALUES ('3063', '刚察县', '3059', '2720');
INSERT INTO `wp_area` VALUES ('3064', '黄南藏族自治州', '3043', '315');
INSERT INTO `wp_area` VALUES ('3065', '同仁县', '3064', '2721');
INSERT INTO `wp_area` VALUES ('3066', '尖扎县', '3064', '2722');
INSERT INTO `wp_area` VALUES ('3067', '泽库县', '3064', '2723');
INSERT INTO `wp_area` VALUES ('3068', '河南蒙古族自治县', '3064', '2724');
INSERT INTO `wp_area` VALUES ('3069', '海南藏族自治州', '3043', '316');
INSERT INTO `wp_area` VALUES ('3070', '共和县', '3069', '2725');
INSERT INTO `wp_area` VALUES ('3071', '同德县', '3069', '2726');
INSERT INTO `wp_area` VALUES ('3072', '贵德县', '3069', '2727');
INSERT INTO `wp_area` VALUES ('3073', '兴海县', '3069', '2728');
INSERT INTO `wp_area` VALUES ('3074', '贵南县', '3069', '2729');
INSERT INTO `wp_area` VALUES ('3075', '果洛藏族自治州', '3043', '317');
INSERT INTO `wp_area` VALUES ('3076', '玛沁县', '3075', '2730');
INSERT INTO `wp_area` VALUES ('3077', '班玛县', '3075', '2731');
INSERT INTO `wp_area` VALUES ('3078', '甘德县', '3075', '2732');
INSERT INTO `wp_area` VALUES ('3079', '达日县', '3075', '2733');
INSERT INTO `wp_area` VALUES ('3080', '久治县', '3075', '2734');
INSERT INTO `wp_area` VALUES ('3081', '玛多县', '3075', '2735');
INSERT INTO `wp_area` VALUES ('3082', '玉树藏族自治州', '3043', '318');
INSERT INTO `wp_area` VALUES ('3083', '玉树县', '3082', '2736');
INSERT INTO `wp_area` VALUES ('3084', '杂多县', '3082', '2737');
INSERT INTO `wp_area` VALUES ('3085', '称多县', '3082', '2738');
INSERT INTO `wp_area` VALUES ('3086', '治多县', '3082', '2739');
INSERT INTO `wp_area` VALUES ('3087', '囊谦县', '3082', '2740');
INSERT INTO `wp_area` VALUES ('3088', '曲麻莱县', '3082', '2741');
INSERT INTO `wp_area` VALUES ('3089', '海西蒙古族藏族自治州', '3043', '319');
INSERT INTO `wp_area` VALUES ('3090', '格尔木市', '3089', '2742');
INSERT INTO `wp_area` VALUES ('3091', '德令哈市', '3089', '2743');
INSERT INTO `wp_area` VALUES ('3092', '乌兰县', '3089', '2744');
INSERT INTO `wp_area` VALUES ('3093', '都兰县', '3089', '2745');
INSERT INTO `wp_area` VALUES ('3094', '天峻县', '3089', '2746');
INSERT INTO `wp_area` VALUES ('3095', '宁夏回族自治区', '0', '30');
INSERT INTO `wp_area` VALUES ('3096', '银川市', '3095', '320');
INSERT INTO `wp_area` VALUES ('3097', '兴庆区', '3096', '2747');
INSERT INTO `wp_area` VALUES ('3098', '西夏区', '3096', '2748');
INSERT INTO `wp_area` VALUES ('3099', '金凤区', '3096', '2749');
INSERT INTO `wp_area` VALUES ('3100', '永宁县', '3096', '2750');
INSERT INTO `wp_area` VALUES ('3101', '贺兰县', '3096', '2751');
INSERT INTO `wp_area` VALUES ('3102', '灵武市', '3096', '2752');
INSERT INTO `wp_area` VALUES ('3103', '石嘴山市', '3095', '321');
INSERT INTO `wp_area` VALUES ('3104', '大武口区', '3103', '2753');
INSERT INTO `wp_area` VALUES ('3105', '惠农区', '3103', '2754');
INSERT INTO `wp_area` VALUES ('3106', '平罗县', '3103', '2755');
INSERT INTO `wp_area` VALUES ('3107', '吴忠市', '3095', '322');
INSERT INTO `wp_area` VALUES ('3108', '利通区', '3107', '2756');
INSERT INTO `wp_area` VALUES ('3109', '盐池县', '3107', '2757');
INSERT INTO `wp_area` VALUES ('3110', '同心县', '3107', '2758');
INSERT INTO `wp_area` VALUES ('3111', '青铜峡市', '3107', '2759');
INSERT INTO `wp_area` VALUES ('3112', '固原市', '3095', '323');
INSERT INTO `wp_area` VALUES ('3113', '原州区', '3112', '2760');
INSERT INTO `wp_area` VALUES ('3114', '西吉县', '3112', '2761');
INSERT INTO `wp_area` VALUES ('3115', '隆德县', '3112', '2762');
INSERT INTO `wp_area` VALUES ('3116', '泾源县', '3112', '2763');
INSERT INTO `wp_area` VALUES ('3117', '彭阳县', '3112', '2764');
INSERT INTO `wp_area` VALUES ('3118', '中卫市', '3095', '324');
INSERT INTO `wp_area` VALUES ('3119', '沙坡头区', '3118', '2765');
INSERT INTO `wp_area` VALUES ('3120', '中宁县', '3118', '2766');
INSERT INTO `wp_area` VALUES ('3121', '海原县', '3118', '2767');
INSERT INTO `wp_area` VALUES ('3122', '新疆维吾尔自治区', '0', '31');
INSERT INTO `wp_area` VALUES ('3123', '乌鲁木齐市', '3122', '325');
INSERT INTO `wp_area` VALUES ('3124', '天山区', '3123', '2768');
INSERT INTO `wp_area` VALUES ('3125', '沙依巴克区', '3123', '2769');
INSERT INTO `wp_area` VALUES ('3126', '新市区', '3123', '2770');
INSERT INTO `wp_area` VALUES ('3127', '水磨沟区', '3123', '2771');
INSERT INTO `wp_area` VALUES ('3128', '头屯河区', '3123', '2772');
INSERT INTO `wp_area` VALUES ('3129', '达坂城区', '3123', '2773');
INSERT INTO `wp_area` VALUES ('3130', '东山区', '3123', '2774');
INSERT INTO `wp_area` VALUES ('3131', '乌鲁木齐县', '3123', '2775');
INSERT INTO `wp_area` VALUES ('3132', '克拉玛依市', '3122', '326');
INSERT INTO `wp_area` VALUES ('3133', '独山子区', '3132', '2776');
INSERT INTO `wp_area` VALUES ('3134', '克拉玛依区', '3132', '2777');
INSERT INTO `wp_area` VALUES ('3135', '白碱滩区', '3132', '2778');
INSERT INTO `wp_area` VALUES ('3136', '乌尔禾区', '3132', '2779');
INSERT INTO `wp_area` VALUES ('3137', '吐鲁番地区', '3122', '327');
INSERT INTO `wp_area` VALUES ('3138', '吐鲁番市', '3137', '2780');
INSERT INTO `wp_area` VALUES ('3139', '鄯善县', '3137', '2781');
INSERT INTO `wp_area` VALUES ('3140', '托克逊县', '3137', '2782');
INSERT INTO `wp_area` VALUES ('3141', '哈密地区', '3122', '328');
INSERT INTO `wp_area` VALUES ('3142', '哈密市', '3141', '2783');
INSERT INTO `wp_area` VALUES ('3143', '巴里坤哈萨克自治县', '3141', '2784');
INSERT INTO `wp_area` VALUES ('3144', '伊吾县', '3141', '2785');
INSERT INTO `wp_area` VALUES ('3145', '昌吉回族自治州', '3122', '329');
INSERT INTO `wp_area` VALUES ('3146', '昌吉市', '3145', '2786');
INSERT INTO `wp_area` VALUES ('3147', '阜康市', '3145', '2787');
INSERT INTO `wp_area` VALUES ('3148', '米泉市', '3145', '2788');
INSERT INTO `wp_area` VALUES ('3149', '呼图壁县', '3145', '2789');
INSERT INTO `wp_area` VALUES ('3150', '玛纳斯县', '3145', '2790');
INSERT INTO `wp_area` VALUES ('3151', '奇台县', '3145', '2791');
INSERT INTO `wp_area` VALUES ('3152', '吉木萨尔县', '3145', '2792');
INSERT INTO `wp_area` VALUES ('3153', '木垒哈萨克自治县', '3145', '2793');
INSERT INTO `wp_area` VALUES ('3154', '博尔塔拉蒙古自治州', '3122', '330');
INSERT INTO `wp_area` VALUES ('3155', '博乐市', '3154', '2794');
INSERT INTO `wp_area` VALUES ('3156', '精河县', '3154', '2795');
INSERT INTO `wp_area` VALUES ('3157', '温泉县', '3154', '2796');
INSERT INTO `wp_area` VALUES ('3158', '巴音郭楞蒙古自治州', '3122', '331');
INSERT INTO `wp_area` VALUES ('3159', '库尔勒市', '3158', '2797');
INSERT INTO `wp_area` VALUES ('3160', '轮台县', '3158', '2798');
INSERT INTO `wp_area` VALUES ('3161', '尉犁县', '3158', '2799');
INSERT INTO `wp_area` VALUES ('3162', '若羌县', '3158', '2800');
INSERT INTO `wp_area` VALUES ('3163', '且末县', '3158', '2801');
INSERT INTO `wp_area` VALUES ('3164', '焉耆回族自治县', '3158', '2802');
INSERT INTO `wp_area` VALUES ('3165', '和静县', '3158', '2803');
INSERT INTO `wp_area` VALUES ('3166', '和硕县', '3158', '2804');
INSERT INTO `wp_area` VALUES ('3167', '博湖县', '3158', '2805');
INSERT INTO `wp_area` VALUES ('3168', '阿克苏地区', '3122', '332');
INSERT INTO `wp_area` VALUES ('3169', '阿克苏市', '3168', '2806');
INSERT INTO `wp_area` VALUES ('3170', '温宿县', '3168', '2807');
INSERT INTO `wp_area` VALUES ('3171', '库车县', '3168', '2808');
INSERT INTO `wp_area` VALUES ('3172', '沙雅县', '3168', '2809');
INSERT INTO `wp_area` VALUES ('3173', '新和县', '3168', '2810');
INSERT INTO `wp_area` VALUES ('3174', '拜城县', '3168', '2811');
INSERT INTO `wp_area` VALUES ('3175', '乌什县', '3168', '2812');
INSERT INTO `wp_area` VALUES ('3176', '阿瓦提县', '3168', '2813');
INSERT INTO `wp_area` VALUES ('3177', '柯坪县', '3168', '2814');
INSERT INTO `wp_area` VALUES ('3178', '克孜勒苏柯尔克孜自治州', '3122', '333');
INSERT INTO `wp_area` VALUES ('3179', '阿图什市', '3178', '2815');
INSERT INTO `wp_area` VALUES ('3180', '阿克陶县', '3178', '2816');
INSERT INTO `wp_area` VALUES ('3181', '阿合奇县', '3178', '2817');
INSERT INTO `wp_area` VALUES ('3182', '乌恰县', '3178', '2818');
INSERT INTO `wp_area` VALUES ('3183', '喀什地区', '3122', '334');
INSERT INTO `wp_area` VALUES ('3184', '喀什市', '3183', '2819');
INSERT INTO `wp_area` VALUES ('3185', '疏附县', '3183', '2820');
INSERT INTO `wp_area` VALUES ('3186', '疏勒县', '3183', '2821');
INSERT INTO `wp_area` VALUES ('3187', '英吉沙县', '3183', '2822');
INSERT INTO `wp_area` VALUES ('3188', '泽普县', '3183', '2823');
INSERT INTO `wp_area` VALUES ('3189', '莎车县', '3183', '2824');
INSERT INTO `wp_area` VALUES ('3190', '叶城县', '3183', '2825');
INSERT INTO `wp_area` VALUES ('3191', '麦盖提县', '3183', '2826');
INSERT INTO `wp_area` VALUES ('3192', '岳普湖县', '3183', '2827');
INSERT INTO `wp_area` VALUES ('3193', '伽师县', '3183', '2828');
INSERT INTO `wp_area` VALUES ('3194', '巴楚县', '3183', '2829');
INSERT INTO `wp_area` VALUES ('3195', '塔什库尔干塔吉克自治县', '3183', '2830');
INSERT INTO `wp_area` VALUES ('3196', '和田地区', '3122', '335');
INSERT INTO `wp_area` VALUES ('3197', '和田市', '3196', '2831');
INSERT INTO `wp_area` VALUES ('3198', '和田县', '3196', '2832');
INSERT INTO `wp_area` VALUES ('3199', '墨玉县', '3196', '2833');
INSERT INTO `wp_area` VALUES ('3200', '皮山县', '3196', '2834');
INSERT INTO `wp_area` VALUES ('3201', '洛浦县', '3196', '2835');
INSERT INTO `wp_area` VALUES ('3202', '策勒县', '3196', '2836');
INSERT INTO `wp_area` VALUES ('3203', '于田县', '3196', '2837');
INSERT INTO `wp_area` VALUES ('3204', '民丰县', '3196', '2838');
INSERT INTO `wp_area` VALUES ('3205', '伊犁哈萨克自治州', '3122', '336');
INSERT INTO `wp_area` VALUES ('3206', '伊宁市', '3205', '2839');
INSERT INTO `wp_area` VALUES ('3207', '奎屯市', '3205', '2840');
INSERT INTO `wp_area` VALUES ('3208', '伊宁县', '3205', '2841');
INSERT INTO `wp_area` VALUES ('3209', '察布查尔锡伯自治县', '3205', '2842');
INSERT INTO `wp_area` VALUES ('3210', '霍城县', '3205', '2843');
INSERT INTO `wp_area` VALUES ('3211', '巩留县', '3205', '2844');
INSERT INTO `wp_area` VALUES ('3212', '新源县', '3205', '2845');
INSERT INTO `wp_area` VALUES ('3213', '昭苏县', '3205', '2846');
INSERT INTO `wp_area` VALUES ('3214', '特克斯县', '3205', '2847');
INSERT INTO `wp_area` VALUES ('3215', '尼勒克县', '3205', '2848');
INSERT INTO `wp_area` VALUES ('3216', '塔城地区', '3122', '337');
INSERT INTO `wp_area` VALUES ('3217', '塔城市', '3216', '2849');
INSERT INTO `wp_area` VALUES ('3218', '乌苏市', '3216', '2850');
INSERT INTO `wp_area` VALUES ('3219', '额敏县', '3216', '2851');
INSERT INTO `wp_area` VALUES ('3220', '沙湾县', '3216', '2852');
INSERT INTO `wp_area` VALUES ('3221', '托里县', '3216', '2853');
INSERT INTO `wp_area` VALUES ('3222', '裕民县', '3216', '2854');
INSERT INTO `wp_area` VALUES ('3223', '和布克赛尔蒙古自治县', '3216', '2855');
INSERT INTO `wp_area` VALUES ('3224', '阿勒泰地区', '3122', '338');
INSERT INTO `wp_area` VALUES ('3225', '阿勒泰市', '3224', '2856');
INSERT INTO `wp_area` VALUES ('3226', '布尔津县', '3224', '2857');
INSERT INTO `wp_area` VALUES ('3227', '富蕴县', '3224', '2858');
INSERT INTO `wp_area` VALUES ('3228', '福海县', '3224', '2859');
INSERT INTO `wp_area` VALUES ('3229', '哈巴河县', '3224', '2860');
INSERT INTO `wp_area` VALUES ('3230', '青河县', '3224', '2861');
INSERT INTO `wp_area` VALUES ('3231', '吉木乃县', '3224', '2862');
INSERT INTO `wp_area` VALUES ('3232', '石河子市', '3122', '339');
INSERT INTO `wp_area` VALUES ('3233', '阿拉尔市', '3122', '340');
INSERT INTO `wp_area` VALUES ('3234', '图木舒克市', '3122', '341');
INSERT INTO `wp_area` VALUES ('3235', '五家渠市', '3122', '342');
INSERT INTO `wp_area` VALUES ('3236', '香港特别行政区', '0', '32');
INSERT INTO `wp_area` VALUES ('3237', '香港特别行政区', '3236', '343');
INSERT INTO `wp_area` VALUES ('3238', '澳门特别行政区', '0', '33');
INSERT INTO `wp_area` VALUES ('3239', '澳门特别行政区', '3238', '344');
INSERT INTO `wp_area` VALUES ('3240', '台湾省', '0', '34');
INSERT INTO `wp_area` VALUES ('3241', '台湾省', '3240', '345');

-- ----------------------------
-- Table structure for `wp_attachment`
-- ----------------------------
DROP TABLE IF EXISTS `wp_attachment`;
CREATE TABLE `wp_attachment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `title` char(30) NOT NULL DEFAULT '' COMMENT '附件显示名',
  `type` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '附件类型',
  `source` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '资源ID',
  `record_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '关联记录ID',
  `download` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '下载次数',
  `size` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '附件大小',
  `dir` int(12) unsigned NOT NULL DEFAULT '0' COMMENT '上级目录ID',
  `sort` int(8) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`id`),
  KEY `idx_record_status` (`record_id`,`status`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='附件表';

-- ----------------------------
-- Records of wp_attachment
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_attr`
-- ----------------------------
DROP TABLE IF EXISTS `wp_attr`;
CREATE TABLE `wp_attr` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `type_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '类型id',
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '名称',
  `input_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '输入类型 0,1,2',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '属性类型 0,1,2',
  `index` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否可以筛选 0,1,2',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `islink` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '相关属性商品是否关联',
  `group` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '属性分组',
  PRIMARY KEY (`id`),
  KEY `cat_id` (`type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_attr
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_attribute`
-- ----------------------------
DROP TABLE IF EXISTS `wp_attribute`;
CREATE TABLE `wp_attribute` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '' COMMENT '字段名',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '字段注释',
  `field` varchar(100) NOT NULL DEFAULT '' COMMENT '字段定义',
  `type` varchar(20) NOT NULL DEFAULT '' COMMENT '数据类型',
  `value` varchar(100) NOT NULL DEFAULT '' COMMENT '字段默认值',
  `remark` varchar(100) NOT NULL DEFAULT '' COMMENT '备注',
  `is_show` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示',
  `extra` varchar(255) NOT NULL DEFAULT '' COMMENT '参数',
  `model_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '模型id',
  `is_must` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否必填',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '状态',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `validate_rule` varchar(255) NOT NULL DEFAULT '',
  `validate_time` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `error_info` varchar(100) NOT NULL DEFAULT '',
  `validate_type` varchar(25) NOT NULL DEFAULT '',
  `auto_rule` varchar(100) NOT NULL DEFAULT '',
  `auto_time` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `auto_type` varchar(25) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `model_id` (`model_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=513 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='模型属性表';

-- ----------------------------
-- Records of wp_attribute
-- ----------------------------
INSERT INTO `wp_attribute` VALUES ('35', 'logo', '图片', 'int(10) UNSIGNED NOT NULL', 'picture', '', '', '1', '', '5', '0', '1', '1447429011', '1447429011', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('36', 'url', '链接地址', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '5', '0', '1', '1447429025', '1447429025', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('37', 'sort', '排序', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '5', '0', '1', '1447429036', '1447429036', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('38', 'title', '名称', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '5', '0', '1', '1463762163', '1447429051', 'require', '3', '必须', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('42', 'type_id', '商品类型id', 'int(11) NOT NULL ', 'string', '', '', '1', '', '7', '0', '1', '1463812218', '1463812218', '', '0', '', '', '', '0', '');
INSERT INTO `wp_attribute` VALUES ('43', 'name', '属性名称', 'varchar(255) NOT NULL ', 'string', '', '', '1', '', '7', '0', '1', '1463812218', '1463812218', '', '0', '', '', '', '0', '');
INSERT INTO `wp_attribute` VALUES ('44', 'input_type', '属性添加类别 0：手 1输入 2：多行输入', 'int(11) NOT NULL ', 'string', '1', '', '1', '', '7', '0', '1', '1463812218', '1463812218', '', '0', '', '', '', '0', '');
INSERT INTO `wp_attribute` VALUES ('47', 'sort', '属性显示顺序', 'int(11) NOT NULL ', 'string', '0', '', '1', '', '7', '0', '1', '1463812218', '1463812218', '', '0', '', '', '', '0', '');
INSERT INTO `wp_attribute` VALUES ('48', 'is_linked', '是否关联  0不关联 1关联', 'int(11) NOT NULL ', 'string', '0', '', '1', '', '7', '0', '1', '1463812218', '1463812218', '', '0', '', '', '', '0', '');
INSERT INTO `wp_attribute` VALUES ('167', 'content', '文章内容', 'text NOT NULL', 'editor', '', '', '1', '', '20', '0', '1', '1465614378', '1465614378', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('177', 'title', '广告标题', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '21', '0', '1', '1466233361', '1466233361', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('178', 'stime', '开始时间', 'int(10) NOT NULL', 'datetime', '', '', '1', '', '21', '0', '1', '1473733584', '1466233421', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('179', 'etime', '结束时间', 'int(10) NOT NULL', 'datetime', '', '', '1', '', '21', '0', '1', '1466233442', '1466233442', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('180', 'position', '广告位置', 'varchar(255) NOT NULL', 'string', '', '', '1', '1:下载页_左边\r\n2:下载页_右边\r\n3:下载页_左下\r\n4:下载页_右下\r\n5:下载页_下载说明\r\n6:下载页_精彩推荐\r\n7:下载页_中间图片广告\r\n8:下载页_中间文字广告\r\n9:网盘首页_右边文字广告\r\n10:手机版下载页顶部图片广告\r\n11:手机版下载页中间图片广告\r\n12:手机版下载页文字广告', '21', '0', '1', '1520908109', '1466233906', '', '3', '', 'regex', '', '3', 'callback');
INSERT INTO `wp_attribute` VALUES ('183', 'category_id', '栏目id', 'varchar(255) NOT NULL', '', '', '', '1', '', '21', '0', '1', '1517475884', '1466234671', '', '3', '', 'regex', '', '3', 'callback');
INSERT INTO `wp_attribute` VALUES ('197', 'nickname', '昵称', 'char(16) NOT NULL ', 'string', '', '', '1', '', '27', '0', '1', '1471575217', '1471575217', '', '0', '', '', '', '0', '');
INSERT INTO `wp_attribute` VALUES ('202', 'login', '登录次数', 'int(10) UNSIGNED NOT NULL', 'num', '0', '', '1', '', '27', '0', '1', '1471576089', '1471575217', '', '0', '', 'regex', '', '0', 'function');
INSERT INTO `wp_attribute` VALUES ('203', 'reg_ip', '注册IP', 'bigint(20) NOT NULL ', 'string', '0', '', '1', '', '27', '0', '1', '1517852493', '1471575217', '', '3', '', 'regex', 'get_client_ip', '1', 'function');
INSERT INTO `wp_attribute` VALUES ('204', 'ctime', '注册时间', 'int(10) NOT NULL', 'datetime', '0', '', '1', '', '27', '0', '1', '1471576604', '1471575217', '', '0', '', 'regex', 'time', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('205', 'last_login_ip', '最后登录IP', 'int(10) NOT NULL', 'datetime', '0', '', '1', '', '27', '0', '1', '1471576036', '1471575217', '', '0', '', 'regex', '', '0', 'function');
INSERT INTO `wp_attribute` VALUES ('206', 'last_login_time', '最后登录时间', 'int(10) NOT NULL', 'datetime', '0', '', '1', '', '27', '0', '1', '1471576021', '1471575217', '', '0', '', 'regex', '', '0', 'function');
INSERT INTO `wp_attribute` VALUES ('207', 'status', '会员状态', 'char(50) NOT NULL', 'select', '0', '', '1', '-1:禁止\r\n0:正常', '27', '0', '1', '1471575978', '1471575217', '', '0', '', 'regex', '', '0', 'function');
INSERT INTO `wp_attribute` VALUES ('208', 'email', '邮箱', 'text NOT NULL', 'textarea', '', '', '1', '', '27', '0', '1', '1471576135', '1471576135', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('209', 'mobile', '手机号', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '27', '0', '1', '1471576150', '1471576150', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('210', 'password', '密码', 'varchar(50) NOT NULL', 'password', '', '', '1', '', '27', '0', '1', '1471576321', '1471576261', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('211', 'username', '用户名', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '27', '0', '1', '1471595333', '1471595333', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('216', 'content', '详情', 'text NOT NULL', 'editor', '', '', '1', '', '21', '0', '1', '1517475963', '1473733796', '', '3', '', 'regex', '_content', '3', 'callback');
INSERT INTO `wp_attribute` VALUES ('220', 'face', '头像', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '27', '0', '1', '1489550915', '1489550915', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('221', 'no', '订单号', 'varchar(100) NOT NULL ', 'string', '', '', '1', '', '30', '0', '1', '1500603548', '1500603548', '', '0', '', '', '', '0', '');
INSERT INTO `wp_attribute` VALUES ('222', 'notes', '备注', 'text NOT NULL', 'textarea', '', '', '1', '', '30', '0', '1', '1500603792', '1500603548', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('223', 'amount', '金额', 'decimal(10,2) UNSIGNED NOT NULL', 'price', '', '', '1', '', '30', '0', '1', '1500603765', '1500603548', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('224', 'status', '状态', 'char(50) NOT NULL', 'select', '0', '', '1', '0:待付款\r\n1:已付款\r\n2:已发货\r\n3:已收货', '30', '0', '1', '1500603741', '1500603548', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('225', 'ctime', '下单时间', 'int(10) NOT NULL', 'datetime', '', '', '1', '', '30', '0', '1', '1500603664', '1500603548', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('226', 'buyer_uid', ' 买家id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '30', '0', '1', '1500603643', '1500603548', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('227', 'address_id', '地址id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '30', '0', '1', '1500603598', '1500603548', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('228', 'seller_uid', '卖家id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '30', '0', '1', '1500603814', '1500603814', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('229', 'pay_id', '支付流水号', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '30', '0', '1', '1500603840', '1500603840', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('230', 'pay_type', '支付方式', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '30', '0', '1', '1500603871', '1500603871', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('231', 'pay_time', '支付时间', 'int(10) NOT NULL', 'datetime', '', '', '1', '', '30', '0', '1', '1500603886', '1500603886', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('232', 'group', '分组', 'char(50) NOT NULL', 'select', '0', '', '1', '0:普通会员\r\n1:开发者', '27', '0', '1', '1513734204', '1500618313', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('233', 'title', '标题', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '31', '0', '1', '1508744544', '1508744544', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('234', 'content', '内容', 'text NOT NULL', 'editor', '', '', '1', '', '31', '0', '1', '1508744556', '1508744556', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('235', 'ctime', '发布时间', 'int(10) NOT NULL', 'datetime', '', '', '0', '', '31', '0', '1', '1508744697', '1508744570', '', '3', '', 'regex', 'time', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('236', 'category', '分类', 'tinyint(4) NOT NULL', 'select', '', '', '1', '1:新闻\r\n2:帮助中心', '31', '0', '1', '1513835854', '1508744676', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('237', 'description', '摘要', 'text NOT NULL', 'textarea', '', '', '1', '', '31', '0', '1', '1508744942', '1508744846', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('238', 'problem', '问题', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '32', '0', '1', '1509588514', '1509588514', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('239', 'answer', '回答', 'text NOT NULL', 'textarea', '', '', '1', '', '32', '0', '1', '1509588564', '1509588564', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('240', 'sort', '排序', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '32', '0', '1', '1509589246', '1509589246', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('241', 'uid', '用户id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '0', '', '33', '0', '1', '1517750860', '1509589365', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('242', 'truename', '用户名', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '33', '0', '1', '1517733658', '1509589384', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('243', 'amount', '提现金额', 'decimal(10,2) UNSIGNED NOT NULL', 'price', '', '', '1', '', '33', '0', '1', '1509589406', '1509589406', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('244', 'status', '状态', 'tinyint(4) NOT NULL', 'select', '0', '', '1', '-1:审核未通过\r\n0:等待审核\r\n1:审核通过\r\n2:支付失败\r\n3:支付成功', '33', '0', '1', '1517754055', '1509589447', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('245', 'ctime', '申请时间', 'int(10) NOT NULL', 'datetime', '', '', '1', '', '33', '0', '1', '1517751201', '1509589479', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('247', 'cash_card', '提现账号', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '33', '0', '1', '1516071060', '1509589608', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('248', 'name', '文件名', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '34', '0', '1', '1509589815', '1509589815', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('249', 'ctime', '上传时间', 'int(10) NOT NULL', 'datetime', '', '', '1', '', '34', '0', '1', '1509590528', '1509589936', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('250', 'uid', '用户id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '34', '0', '1', '1509589973', '1509589973', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('251', 'nickname', '用户名', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '34', '0', '1', '1509589994', '1509589994', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('252', 'price', '价格', 'decimal(10,2) UNSIGNED NOT NULL', 'price', '', '', '1', '', '34', '0', '1', '1509590033', '1509590033', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('253', 'url', '下载地址', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '34', '0', '1', '1509590068', '1509590068', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('254', 'number', '下载次数', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '34', '0', '1', '1509590451', '1509590451', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('255', 'status', '状态', 'varchar(255) NOT NULL', 'string', '', '', '1', '-1:冻结\r\n0:审核\r\n1:正常', '34', '0', '1', '1509590620', '1509590620', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('256', 'ftime', '冻结时间', 'int(10) UNSIGNED NOT NULL', 'num', '', '单位/天', '1', '', '34', '0', '1', '1509590747', '1509590747', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('257', 'connect', '连接', 'tinyint(4) NOT NULL', 'select', '', '', '1', '', '34', '0', '1', '1509590833', '1509590833', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('258', 'uid', '用户id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '35', '0', '1', '1509591176', '1509591176', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('259', 'no', '订单号', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '35', '0', '1', '1512439464', '1509591200', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('260', 'ctime', '充值时间', 'int(10) NOT NULL', 'datetime', '', '', '1', '', '35', '0', '1', '1509591254', '1509591254', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('261', 'amount', '充值金额', 'decimal(10,2) UNSIGNED NOT NULL', 'price', '', '', '1', '', '35', '0', '1', '1509763028', '1509591283', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('262', 'pay_way', '支付方式', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '35', '0', '1', '1509591351', '1509591351', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('263', 'pay_price', '扣费', 'decimal(10,2) UNSIGNED NOT NULL', 'price', '', '', '1', '', '35', '0', '1', '1517726604', '1509591383', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('264', 'status', '充值状态', 'tinyint(4) NOT NULL', 'select', '', '', '1', '0:等待支付\r\n1:充值成功', '35', '0', '1', '1514253423', '1509591451', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('265', 'cash_price', '手续费', 'decimal(10,2) UNSIGNED NOT NULL', 'price', '', '', '1', '', '33', '0', '1', '1509592736', '1509592736', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('267', 'order_no', '订单号', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '36', '0', '1', '1509594405', '1509594405', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('268', 'buyer_id', '买家id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '36', '0', '1', '1509594493', '1509594427', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('269', 'seller_id', '卖家id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '36', '0', '1', '1509594500', '1509594462', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('270', 'ctime', '添加时间', 'int(10) NOT NULL', 'datetime', '', '', '1', '', '36', '0', '1', '1509594521', '1509594521', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('271', 'amount', '金额', 'decimal(10,2) UNSIGNED NOT NULL', 'price', '', '', '1', '', '36', '0', '1', '1509594539', '1509594539', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('272', 'pay_way', '支付方式', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '36', '0', '1', '1509594563', '1509594563', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('273', 'pttc', '平台提成', 'decimal(10,2) UNSIGNED NOT NULL', 'price', '', '', '1', '', '36', '0', '1', '1509594601', '1509594601', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('274', 'shtc', '商户提成', 'decimal(10,2) UNSIGNED NOT NULL', 'price', '', '', '1', '', '36', '0', '1', '1509594640', '1509594640', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('275', 'ptlr', '平台利润', 'decimal(10,2) UNSIGNED NOT NULL', 'price', '', '', '1', '', '36', '0', '1', '1509594665', '1509594665', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('276', 'dlfc', '代理分成', 'decimal(10,2) UNSIGNED NOT NULL', 'price', '', '', '1', '', '36', '0', '1', '1509594688', '1509594688', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('277', 'is_kou', '是否扣掉此单', 'tinyint(4) NOT NULL', 'select', '', '', '1', '0:是\r\n1:否', '36', '0', '1', '1509594756', '1509594756', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('278', 'is_success', '是否成功下载', 'tinyint(4) NOT NULL', 'select', '', '', '1', '0:否\r\n1:是', '36', '0', '1', '1509594830', '1509594830', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('279', 'status', '状态', 'tinyint(4) NOT NULL', 'select', '', '', '1', '0:等待付款\r\n1:已支付\r\n2:等待下载\r\n3:下载成功', '36', '0', '1', '1509594937', '1509594937', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('280', 'order_no', '订单号', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '37', '0', '1', '1509595152', '1509595152', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('281', 'buyer_id', '买家id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '37', '0', '1', '1509595172', '1509595172', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('282', 'seller_id', '卖家id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '37', '0', '1', '1509595189', '1509595189', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('283', 'ctime', '添加时间', 'int(10) NOT NULL', 'datetime', '', '', '1', '', '37', '0', '1', '1509595219', '1509595219', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('284', 'name', '插件名称', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '37', '0', '1', '1509602748', '1509602748', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('285', 'pay_way', '支付方式', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '37', '0', '1', '1509602768', '1509602768', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('286', 'amount', '金额', 'decimal(10,2) UNSIGNED NOT NULL', 'price', '', '', '1', '', '37', '0', '1', '1509602789', '1509602789', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('287', 'pttc', '平台提成', 'decimal(10,2) UNSIGNED NOT NULL', 'price', '', '', '1', '', '37', '0', '1', '1509602813', '1509602813', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('288', 'shtc', '商户提成', 'decimal(10,2) UNSIGNED NOT NULL', 'price', '', '', '1', '', '37', '0', '1', '1509602850', '1509602850', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('289', 'ptlr', '平台利润', 'decimal(10,2) UNSIGNED NOT NULL', 'price', '', '', '1', '', '37', '0', '1', '1509602870', '1509602870', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('290', 'status', '状态', 'tinyint(4) NOT NULL', 'select', '', '', '1', '1:等待支付\r\n2:支付成功', '37', '0', '1', '1509953713', '1509602896', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('291', 'order_no', '订单号', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '38', '0', '1', '1509603221', '1509603221', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('292', 'uid', '用户id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '38', '0', '1', '1509603262', '1509603262', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('293', 'taocan', '购买套餐', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '38', '0', '1', '1509603311', '1509603311', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('294', 'amount', '金额', 'decimal(10,2) UNSIGNED NOT NULL', 'price', '', '', '1', '', '38', '0', '1', '1509603327', '1509603327', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('295', 'url', '网盘地址', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '38', '0', '1', '1509603350', '1509603350', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('296', 'status', '状态', 'tinyint(4) NOT NULL', 'select', '', '', '1', '1:等待支付\r\n2:支付成功', '38', '0', '1', '1509953346', '1509603391', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('297', 'type', '分类', 'tinyint(4) NOT NULL', 'select', '', '', '1', '1:免费\r\n2:付费\r\n3:回收站', '34', '0', '1', '1509604071', '1509604071', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('298', 'ctime', '购买时间', 'int(10) NOT NULL', 'datetime', '', '', '1', '', '38', '0', '1', '1509606234', '1509606234', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('299', 'pay_way', '支付方式', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '38', '0', '1', '1509606265', '1509606265', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('300', 'title', '标题', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '39', '0', '1', '1509610541', '1509610541', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('301', 'ctime', '发布时间', 'int(10) NOT NULL', 'datetime', '', '', '1', '', '39', '0', '1', '1509610573', '1509610573', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('302', 'content', '内容', 'text NOT NULL', 'editor', '', '', '1', '', '39', '0', '1', '1509610597', '1509610597', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('303', 'notes', '备注', 'text NOT NULL', 'textarea', '', '', '1', '', '34', '0', '1', '1509612844', '1509612844', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('304', 'type', '举报类型', 'tinyint(4) NOT NULL', 'select', '', '', '1', '1:色情\r\n2:暴恐\r\n3:版权\r\n4:其它', '40', '0', '1', '1518364156', '1509613763', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('306', 'notes', '备注', 'text NOT NULL', 'textarea', '', '', '1', '', '40', '0', '1', '1509613802', '1509613802', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('307', 'uid', '被举报人id', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '40', '0', '1', '1518364452', '1509613843', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('308', 'ctime', '举报时间', 'int(10) NOT NULL', 'datetime', '', '', '1', '', '40', '0', '1', '1509613892', '1509613892', '', '3', '', 'regex', 'time', '1', 'function');
INSERT INTO `wp_attribute` VALUES ('309', 'status', '状态', 'tinyint(4) NOT NULL', 'select', '0', '', '1', '0:待处理\r\n1:已处理', '40', '0', '1', '1518363886', '1509613978', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('310', 'uid', '用户id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '41', '0', '1', '1509615725', '1509615725', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('311', 'bank', '开户行', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '41', '0', '1', '1509615744', '1509615744', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('312', 'card', '卡号', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '41', '0', '1', '1509615759', '1509615759', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('313', 'nickname', '开户名', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '41', '0', '1', '1509615774', '1509615774', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('314', 'address', '开户地区', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '41', '0', '1', '1509615798', '1509615798', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('315', 'folder_id', '网盘id', 'varchar(255) NOT NULL', 'type', '', '', '1', 'table:folder', '34', '0', '1', '1509956138', '1509956138', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('316', 'name', '', 'varchar(255) NOT NULL ', 'string', '', '', '1', '', '43', '0', '1', '1509956184', '1509956184', '', '0', '', '', '', '0', '');
INSERT INTO `wp_attribute` VALUES ('317', 'reid', '', 'int(10) unsigned NOT NULL ', 'string', '0', '', '1', '', '43', '0', '1', '1509956184', '1509956184', '', '0', '', '', '', '0', '');
INSERT INTO `wp_attribute` VALUES ('318', 'reids', '', 'varchar(255) NOT NULL ', 'string', '', '', '1', '', '43', '0', '1', '1509956184', '1509956184', '', '0', '', '', '', '0', '');
INSERT INTO `wp_attribute` VALUES ('319', 'disorder', '', 'int(10) unsigned NULL ', 'string', '', '', '1', '', '43', '0', '1', '1509956184', '1509956184', '', '0', '', '', '', '0', '');
INSERT INTO `wp_attribute` VALUES ('320', 'uid', '用户id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '43', '0', '1', '1509956208', '1509956208', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('321', 'is_index', '是否首页显示', 'tinyint(4) NOT NULL', 'select', '1', '', '1', '1:是\r\n2:否', '43', '0', '1', '1509960619', '1509960619', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('322', 'pay_time', '支付时间', 'int(10) NOT NULL', 'datetime', '', '', '1', '', '35', '0', '1', '1512440667', '1512440667', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('323', 'pay_no', '支付流水号', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '35', '0', '1', '1512440683', '1512440683', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('324', 'ctime', '时间', 'int(10) NOT NULL', 'datetime', '', '', '1', '', '44', '0', '1', '1512446980', '1512446793', '', '3', '', 'regex', 'time', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('325', 'amount', '总金额', 'decimal(10,5) NOT NULL', 'price', '', '', '1', '', '44', '0', '1', '1523748593', '1512446923', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('326', 'about', '说明', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '44', '0', '1', '1512446966', '1512446966', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('327', 'type', '分类', 'tinyint(4) NOT NULL', 'select', '', '', '1', '1:软件销售\r\n2:账户充值\r\n3:网盘购买\r\n4:资金提现\r\n5:系统入账\r\n6:软件订单退款\r\n7:推广分成\r\n8:软件订单冻结\r\n', '44', '0', '1', '1529247075', '1512457226', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('328', 'status', '状态', 'tinyint(4) NOT NULL', 'select', '0', '', '1', '-1:删除\r\n0:正常\r\n1:首页推荐', '43', '0', '1', '1512576514', '1512576514', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('329', 'title', '标题', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '45', '0', '1', '1512963280', '1512963280', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('330', 'img', '效果图', 'varchar(255) NOT NULL', 'picture', '', '', '1', '', '45', '0', '1', '1512973167', '1512963304', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('331', 'uid', '用id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '45', '0', '1', '1512963322', '1512963322', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('332', 'author', '作者', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '45', '0', '1', '1512963340', '1512963340', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('333', 'index_js', '首页js', 'text NOT NULL', 'textarea', '', '一行一条，全路径http://(https://)开头', '1', '', '45', '0', '1', '1512963577', '1512963577', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('334', 'index_css', '首页css', 'text NOT NULL', 'textarea', '', '一行一个，全路径http://(https://)开头', '1', '', '45', '0', '1', '1512963611', '1512963611', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('335', 'category', '分类', 'tinyint(4) NOT NULL', 'select', '1', '', '1', '1:简约\r\n2:奢华', '45', '0', '1', '1512963713', '1512963713', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('336', 'sort', '排序', 'int(10) UNSIGNED NOT NULL', 'num', '', '从大到小', '1', '', '45', '0', '1', '1512974910', '1512974910', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('337', 'url', '预览地址', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '45', '0', '1', '1512975095', '1512975095', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('338', 'static', '状态', 'tinyint(4) NOT NULL', 'select', '0', '', '1', '0:待审核\r\n1:上架\r\n2:下架', '45', '0', '1', '1512976131', '1512976124', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('339', 'uid', '用户id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '46', '0', '1', '1512976376', '1512976376', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('340', 'index', '首页css', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '46', '0', '1', '1512976389', '1512976389', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('341', 'download', '下载页css', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '46', '0', '1', '1512976405', '1512976405', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('342', 'domain', '二级域名', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '27', '0', '1', '1513732859', '1513732859', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('343', 'uid', '用户id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '48', '0', '1', '1513733706', '1513733706', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('344', 'developer_id', '开发者id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '48', '0', '1', '1513733749', '1513733749', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('345', 'index', '主页模板', 'text NOT NULL', 'textarea', '', '', '1', '', '48', '0', '1', '1513733779', '1513733779', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('346', 'download', '下载页模板', 'text NOT NULL', 'textarea', '', '', '1', '', '48', '0', '1', '1513733794', '1513733794', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('347', 'etime', '授权截止时间', 'int(10) NOT NULL', 'datetime', '', '', '1', '', '48', '0', '1', '1514369504', '1513734041', '', '3', '', 'regex', 'time', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('348', 'domain', '二级域名', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '48', '0', '1', '1513734445', '1513734445', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('349', 'uid', '用户id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '49', '0', '1', '1513741129', '1513741129', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('350', 'status', '状态', 'tinyint(4) NOT NULL', 'select', '', '', '1', '-3:禁止开发\r\n-2:已退款\r\n-1:审核未通过\r\n0:等待付款\r\n1:待审核 \r\n2:审核通过 \r\n3:过期', '49', '0', '1', '1514021938', '1513741172', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('351', 'etime', '过期时间', 'int(10) NOT NULL', 'datetime', '', '', '1', '', '49', '0', '1', '1513741267', '1513741267', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('352', 'name', '姓名', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '49', '0', '1', '1513741290', '1513741290', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('353', 'mobile', '手机', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '49', '0', '1', '1513741351', '1513741351', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('354', 'qq', 'QQ', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '49', '0', '1', '1513741362', '1513741362', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('355', 'weixin', '微信', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '49', '0', '1', '1513741380', '1513741380', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('356', 'ctime', '申请时间', 'int(10) NOT NULL', 'datetime', '', '', '1', '', '49', '0', '1', '1513741420', '1513741420', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('357', 'days', '时长（/天）', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '49', '0', '1', '1513761795', '1513741479', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('358', 'status', '状态', 'tinyint(4) NOT NULL', 'select', '0', '', '1', '0:未启用 \r\n1:启用', '48', '0', '1', '1513751854', '1513751722', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('359', 'download_wap', 'wap版下载页模板', 'text NOT NULL', 'textarea', '', '', '1', '', '48', '0', '1', '1513751806', '1513751806', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('360', 'index_wap', 'wap版主页模板', 'text NOT NULL', 'textarea', '', '', '1', '', '48', '0', '1', '1513751844', '1513751844', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('361', 'logo', 'logo', 'varchar(255) NOT NULL', 'picture', '', '', '1', '', '49', '0', '1', '1513757045', '1513757045', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('362', 'title', '标题', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '50', '0', '1', '1513757115', '1513757115', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('363', 'img', '图片', 'varchar(255) NOT NULL', 'picture', '', '', '1', '', '50', '0', '1', '1513757137', '1513757137', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('364', 'sort', '排序', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '50', '0', '1', '1513757163', '1513757163', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('365', 'uid', '用户id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '50', '0', '1', '1513757187', '1513757187', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('366', 'url', '链接', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '50', '0', '1', '1513763501', '1513757214', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('367', 'uid', '用户id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '31', '0', '1', '1513836313', '1513836313', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('368', 'uid', '图片地址', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '51', '0', '1', '1530271422', '1513844572', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('369', 'ctime', '发布时间', 'int(10) NOT NULL', 'datetime', '', '', '1', '', '51', '0', '1', '1513844594', '1513844594', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('370', 'title', '标题', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '51', '0', '1', '1513844615', '1513844615', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('371', 'url', '视频地址', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '51', '0', '1', '1513844637', '1513844637', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('372', 'uid', '用户id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '52', '0', '1', '1513906605', '1513906605', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('373', 'imgs', '图集', 'varchar(255) NOT NULL', 'pics', '', '', '1', '', '52', '0', '1', '1513906641', '1513906641', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('374', 'wangpan_type', '网盘类型', 'tinyint(4) NOT NULL', 'select', '1', '', '1', '1:免费型\r\n2:普通VIP\r\n3:黄金VIP\r\n6:钻石VIP\r\n11:终身VIP代理', '27', '0', '1', '1530932323', '1513911641', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('375', 'name', '空间类型', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '53', '0', '1', '1513921642', '1513911897', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('376', 'size', '空间大小', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '53', '0', '1', '1513912187', '1513911923', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('377', 'max', '单个文件最大', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '53', '0', '1', '1513912198', '1513911961', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('378', 'top_menu', '顶级目录限制', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '53', '0', '1', '1513912175', '1513912175', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('379', 'two_menu', '二级目录限制', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '53', '0', '1', '1513912263', '1513912263', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('380', 'download', '是否有下载页面', 'tinyint(4) NOT NULL', 'select', '', '', '0', '1:有\r\n2:无', '53', '0', '1', '1517762247', '1513912324', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('381', 'advert', '广告', 'tinyint(4) NOT NULL', 'select', '', '', '0', '0:无\r\n1:有/带弹窗\r\n2:有/无弹窗\r\n', '53', '0', '1', '1517762277', '1513912460', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('382', 'texiao', '自定义特效', 'tinyint(4) NOT NULL', 'select', '', '', '1', '0:不支持\r\n1:支持', '53', '0', '1', '1513912580', '1513912580', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('384', 'two_hour', '一小时内下载量', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '53', '0', '1', '1513912721', '1513912721', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('385', 'seo', 'SEO优化', 'tinyint(4) NOT NULL', 'select', '0', '', '0', '0:不支持\r\n1:支持', '53', '0', '1', '1517762291', '1513912820', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('386', 'pay', '付费文件', 'tinyint(4) NOT NULL', 'select', '0', '', '1', '0:不支持\r\n1:支持', '53', '0', '1', '1516630941', '1513912893', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('387', 'type_id', '网盘分类', 'int(10) NOT NULL', 'type_id', '', '', '1', '', '54', '0', '1', '1513921841', '1513921841', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('388', 'shichang', '名称 ', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '54', '0', '1', '1516635741', '1513921894', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('389', 'price', '价格', 'decimal(10,2) UNSIGNED NOT NULL', 'price', '', '', '1', '', '54', '0', '1', '1513921932', '1513921932', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('390', 'ctime', '购买时间', 'int(10) NOT NULL', 'datetime', '', '', '1', '', '55', '0', '1', '1513927455', '1513927455', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('391', 'status', '状态', 'tinyint(4) NOT NULL', 'select', '', '', '1', '0:待支付\r\n1:已升级\r\n2:已入账', '55', '0', '1', '1522053848', '1513927564', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('392', 'price', '价格', 'decimal(10,2) UNSIGNED NOT NULL', 'price', '', '', '1', '', '55', '0', '1', '1513927588', '1513927588', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('393', 'wangpan_id', '网盘id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '55', '0', '1', '1513927617', '1513927617', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('394', 'shichang', '时长', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '55', '0', '1', '1513927758', '1513927758', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('395', 'no', '订单号', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '55', '0', '1', '1513927778', '1513927778', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('396', 'days', '天数', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '54', '0', '1', '1513929820', '1513929820', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('397', 'uid', '用户id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '55', '0', '1', '1513929488', '1513929488', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('398', 'pay_way', '支付方式', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '55', '0', '1', '1513929573', '1513929573', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('399', 'days', '购买天数', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '55', '0', '1', '1513932043', '1513932043', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('400', 'guoqi_time', '网盘过期时间', 'int(10) NOT NULL', 'datetime', '', '', '1', '', '27', '0', '1', '1517849019', '1513934093', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('401', 'ctime', '下载时间', 'int(10) NOT NULL', 'datetime', '', '', '1', '', '56', '0', '1', '1513934796', '1513934796', '', '3', '', 'regex', 'time', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('402', 'file_id', '文件id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '56', '0', '1', '1513934814', '1513934814', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('403', 'size', '文件大小', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '56', '0', '1', '1513934834', '1513934834', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('404', 'uid', '上传者id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '56', '0', '1', '1513936242', '1513936242', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('405', 'url', '下载地址', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '56', '0', '1', '1513936261', '1513936261', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('406', 'no', '订单号', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '57', '0', '1', '1513999417', '1513999417', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('407', 'ctime', '购买时间', 'int(10) NOT NULL', 'datetime', '', '', '1', '', '57', '0', '1', '1513999458', '1513999458', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('408', 'status', '状态', 'tinyint(4) NOT NULL', 'select', '', '', '1', '0:待支付\r\n1:支付成功', '57', '0', '1', '1513999608', '1513999608', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('409', 'days', '时长', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '57', '0', '1', '1513999794', '1513999794', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('410', 'price', '价格', 'decimal(10,2) UNSIGNED NOT NULL', 'price', '', '', '1', '', '57', '0', '1', '1514013143', '1514013143', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('411', 'uid', '用户id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '57', '0', '1', '1514013280', '1514013280', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('412', 'type', '分类', 'tinyint(4) NOT NULL', 'select', '', '', '1', '1:购买\r\n2:续费\r\n3:升级', '55', '0', '1', '1514173124', '1514173124', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('413', 'no', '订单号', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '58', '0', '1', '1514273155', '1514273155', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('414', 'uid', '用户id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '58', '0', '1', '1514273307', '1514273307', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('415', 'ctime', '购买时间', 'int(10) NOT NULL', 'datetime', '', '', '1', '', '58', '0', '1', '1514273329', '1514273329', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('416', 'status', '状态', 'tinyint(4) NOT NULL', 'select', '', '', '1', '0:等待支付\r\n1:支付成功\r\n2:已退款\r\n3:冻结', '58', '0', '1', '1529245561', '1514273402', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('417', 'amount', '合计', 'decimal(10,2) UNSIGNED NOT NULL', 'price', '', '', '1', '', '58', '0', '1', '1517598022', '1514273433', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('418', 'pay_way', '支付方式', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '58', '0', '1', '1514273521', '1514273521', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('419', 'file_pk', '文件主键', 'text NOT NULL', 'string', '', '', '0', '', '58', '0', '1', '1517982488', '1514280596', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('420', 'amount', '金额', 'decimal(10,2) NOT NULL', 'price', '', '', '1', '', '59', '0', '1', '1514367094', '1514364835', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('421', 'no', '订单号', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '59', '0', '1', '1514364856', '1514364856', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('422', 'ctime', '时间', 'int(10) NOT NULL', 'datetime', '', '', '1', '', '59', '0', '1', '1514364888', '1514364888', '', '3', '', 'regex', 'time', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('423', 'notes', '资金备注', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '59', '0', '1', '1514364935', '1514364935', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('424', 'uid', '用户id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '59', '0', '1', '1514364957', '1514364957', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('425', 'weixin', '微信', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '27', '0', '1', '1516068638', '1516068638', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('426', 'alipay', '支付宝', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '27', '0', '1', '1516068670', '1516068670', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('427', 'qq', 'QQ', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '27', '0', '1', '1516068726', '1516068726', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('428', 'pay_way', '提现方式', 'tinyint(4) NOT NULL', 'select', '', '', '1', '1:alipay\r\n2:wxpay', '33', '0', '1', '1517736005', '1516071616', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('429', 'rate', '软件销售费率', 'decimal(10,4) UNSIGNED NOT NULL', 'price', '', '', '1', '', '53', '0', '1', '1521182499', '1516072374', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('430', 'cash_amount', '到账金额', 'decimal(10,2) UNSIGNED NOT NULL', 'price', '', '', '1', '', '33', '0', '1', '1516072756', '1516072736', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('431', 'no', '订单号', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '33', '0', '1', '1516074002', '1516074002', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('432', 'name', '配置标示', 'varchar(30) NOT NULL ', 'string', '', '', '1', '', '86', '0', '1', '1516262935', '1516261718', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('433', 'type', '配置类型', 'tinyint(4) NOT NULL', 'select', '0', '', '1', '0:数字\r\n1:字符\r\n2:文本\r\n3:数组\r\n4:枚举\r\n5:图片', '86', '0', '1', '1516262549', '1516261718', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('434', 'title', '配置名称', 'varchar(50) NOT NULL ', 'string', '', '', '1', '', '86', '0', '1', '1516262954', '1516261719', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('435', 'group', '配置分组', 'tinyint(4) NOT NULL', 'select', '1', '', '1', '1:站点设置\r\n2:域名设置\r\n3:优化设置\r\n4:客服设置\r\n5:禁止设置\r\n6:页面设置\r\n7:支付接口\r\n9:短信接口\r\n10:微信设置\r\n11:邮箱设置\r\n12:储存设置\r\n13:提现设置', '86', '0', '1', '1519346432', '1516261719', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('436', 'extra', '配置项', 'text NOT NULL', 'textarea', '', '如果是枚举型需要配置该项', '1', '', '86', '0', '1', '1517972391', '1516261719', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('437', 'remark', '配置备注', 'varchar(100) NOT NULL ', 'string', '', '', '1', '', '86', '0', '1', '1516262441', '1516261719', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('438', 'create_time', '创建时间', 'int(10) NOT NULL', 'datetime', '0', '', '0', '', '86', '0', '1', '1516262347', '1516261719', '', '3', '', 'regex', 'time', '1', 'function');
INSERT INTO `wp_attribute` VALUES ('439', 'update_time', '更新时间', 'int(10) NOT NULL', 'datetime', '0', '', '0', '', '86', '0', '1', '1516262339', '1516261720', '', '3', '', 'regex', 'time', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('440', 'status', '状态', 'tinyint(4) NOT NULL', 'select', '1', '', '1', '0:禁用\r\n1:启用', '86', '0', '1', '1516262147', '1516261720', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('441', 'value', '配置值', 'text NOT NULL', 'textarea', '', '', '1', '', '86', '0', '1', '1517980742', '1516261720', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('442', 'sort', '排序', 'int(10) UNSIGNED NOT NULL', 'num', '0', '', '1', '', '86', '0', '1', '1516261866', '1516261720', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('443', 'index_jiyu', '首页寄语', 'text NOT NULL', 'textarea', '', '', '0', '', '27', '0', '1', '1530956177', '1516429661', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('444', 'pay_qq', '支付qq', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '27', '0', '1', '1516429754', '1516429754', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('445', 'pay_mobile', '支付页面电话', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '27', '0', '1', '1516429805', '1516429805', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('446', 'pay_email', '支付页面邮箱', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '0', '0', '1', '1516429861', '1516429861', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('447', 'pay_email', '支付页面邮箱', 'varchar(255) NOT NULL', 'string', '', '', '0', '', '27', '0', '1', '1517851599', '1516429899', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('448', 'wangpan_title', '网盘标题', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '27', '0', '1', '1516429979', '1516429979', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('449', 'wangpan_background', '网盘背景', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '27', '0', '1', '1516430052', '1516430021', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('450', 'is_pwd', '显示是否需要密码', 'varchar(255) NOT NULL', 'string', '', '', '1', '1:否\r\n2:是', '27', '0', '1', '1516430175', '1516430175', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('451', 'menu', '目录顺序', 'tinyint(4) NOT NULL', 'select', '2', '', '1', '1:按时间顺序\r\n2:按标题顺序\r\n3:按目录备注顺序', '27', '0', '1', '1516430281', '1516430281', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('452', 'model', '模板选着', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '27', '0', '1', '1516430372', '1516430372', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('453', 'type', '分类', 'tinyint(4) NOT NULL', 'select', '0', '', '1', '1:用户申请\r\n2:系统提现', '33', '0', '1', '1517733601', '1516610241', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('454', 'sort', '排序', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '54', '0', '1', '1516635961', '1516635961', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('456', 'sort', '排序', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '21', '0', '1', '1520915416', '1517475813', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('457', 'mobile', '手机', 'varchar(15) NOT NULL', 'string', '', '', '1', '', '58', '0', '1', '1517503594', '1517503594', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('458', 'idcard', '身份证号', 'varchar(20) NOT NULL', 'string', '', '', '1', '', '27', '0', '1', '1517565101', '1517565101', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('459', 'truename', '姓名', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '27', '0', '1', '1517849030', '1517587463', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('460', 'price', '价格', 'decimal(10,2) UNSIGNED NOT NULL', 'price', '', '', '1', '', '58', '0', '1', '1517598037', '1517598037', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('461', 'email', '邮箱', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '58', '0', '1', '1517677489', '1517677489', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('462', 'name', '软件名称', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '58', '0', '1', '1517677539', '1517677539', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('463', 'type', '分类', 'tinyint(4) NOT NULL', 'select', '0', '', '1', '1:软件销售\r\n2:账户充值\r\n3:网盘购买', '59', '0', '1', '1517681462', '1517681462', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('464', 'no', '订单号', 'varchar(50) NOT NULL', 'string', '', '', '1', '', '44', '0', '1', '1517725784', '1517725784', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('465', 'uid', '用户id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '44', '0', '1', '1517725820', '1517725820', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('466', 'pay_time', '支付时间', 'int(10) NOT NULL', 'datetime', '', '', '0', '', '33', '0', '1', '1517750921', '1517734101', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('467', 'charge', '手续费', 'decimal(10,5) UNSIGNED NOT NULL', 'price', '', '', '1', '', '44', '0', '1', '1517738756', '1517737440', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('468', 'price', '会员金额', 'decimal(10,5) NOT NULL', 'price', '', '', '1', '', '44', '0', '1', '1523748584', '1517738127', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('469', 'about', '备注', 'text NOT NULL', 'textarea', '', '', '1', '', '33', '0', '1', '1517750831', '1517750831', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('470', 'ip', 'IP', 'varchar(50) NOT NULL', 'string', '', '', '1', '', '58', '0', '1', '1517763835', '1517763558', '', '3', '', 'regex', '_get_client_ip', '1', 'callback');
INSERT INTO `wp_attribute` VALUES ('471', 'downtime', '下载时间', 'int(10) NOT NULL', 'datetime', '', '', '1', '', '58', '0', '1', '1517764196', '1517764196', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('472', 'closemsg', '关闭提示', 'varchar(255) NOT NULL', 'textarea', '', '', '1', '', '27', '0', '1', '1517852336', '1517852318', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('473', 'pk', '被举报文件id', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '40', '0', '1', '1518366313', '1518365906', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('474', 'linkinfo', '举报人信息', 'text NOT NULL', 'textarea', '', '', '1', '', '40', '0', '1', '1518367303', '1518367303', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('475', 'from', '推荐人id', 'int(10) UNSIGNED NOT NULL', 'num', '0', '', '1', '', '27', '0', '1', '1518510164', '1518448784', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('476', 'uid', '用户id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '88', '0', '1', '1518449384', '1518449384', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('477', 'about', '说明', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '88', '0', '1', '1518449404', '1518449404', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('478', 'score', '积分', 'int(10) NOT NULL', 'num', '', '', '1', '', '88', '0', '1', '1518449432', '1518449432', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('479', 'ctime', '时间', 'int(10) NOT NULL', 'datetime', '0', '', '0', '', '88', '0', '1', '1518510174', '1518451041', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('480', 'score', '积分', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '27', '0', '1', '1518452735', '1518452735', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('481', 'cate', '分类', 'tinyint(4) NOT NULL', 'select', '', '', '1', '1:站内公告\r\n2:视频教程\r\n3:站内新闻\r\n4:结算公告\r\n5:帮助中心\r\n6:其他公告', '39', '0', '1', '1530324414', '1518484085', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('482', 'password2', '二级密码', 'varchar(50) NOT NULL', 'password', '', '', '1', '', '27', '0', '1', '1519367933', '1519367933', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('483', 'weixin_bind_time', '微信绑定时间', 'int(10) NOT NULL', 'datetime', '', '', '0', '', '27', '0', '1', '1519525417', '1519525417', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('484', 'card', '赠送卡密', 'text NOT NULL', 'textarea', '', '', '1', '', '58', '0', '1', '1520844430', '1520844430', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('486', 'isrand', '是否随机', 'tinyint(4) NOT NULL', 'select', '0', '', '1', '0:不随机\r\n1:随机', '21', '0', '1', '1521019979', '1521019979', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('487', 'feilv', '平台提成', 'decimal(10,2) UNSIGNED NOT NULL', 'price', '', '', '1', '', '58', '0', '1', '1521287469', '1521276602', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('488', 'money', '商户提成', 'decimal(10,2) UNSIGNED NOT NULL', 'price', '', '', '1', '', '58', '0', '1', '1521287449', '1521276637', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('489', 'price', '到账金额', 'decimal(10,2) UNSIGNED NOT NULL', 'price', '', '', '1', '', '35', '0', '1', '1521297050', '1521297050', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('490', 'title', '标题', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '89', '0', '1', '1522724317', '1522724317', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('491', 'name', '标示', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '89', '0', '1', '1522724337', '1522724337', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('492', 'lilv', '利率', 'decimal(10,4) UNSIGNED NOT NULL', 'price', '', '小数，例如 0.006', '1', '', '89', '0', '1', '1522724387', '1522724367', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('493', 'status', '是否开启', 'tinyint(4) NOT NULL', 'select', '', '', '1', '0:关闭\r\n1:开启', '89', '0', '1', '1522724436', '1522724436', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('494', 'category', '支付分类', 'tinyint(4) NOT NULL', 'select', '', '', '1', '1:文件购买\r\n2:网盘购买\r\n3:会员充值', '89', '0', '1', '1522724676', '1522724526', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('495', 'type', '使用环境', 'tinyint(4) NOT NULL', 'select', '', '', '1', '1:pc\r\n2:wap', '89', '0', '1', '1522724704', '1522724704', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('496', 'sort', '排序', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '89', '0', '1', '1522761418', '1522761418', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('497', 'title1', '支付名称', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '89', '0', '1', '1522923287', '1522923213', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('498', 'orderprice', '订单金额', 'decimal(10,2) UNSIGNED NOT NULL', 'price', '', '', '1', '', '44', '0', '1', '1523802594', '1523802594', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('500', 'subuser', '推广会员ID', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '44', '0', '1', '1523805309', '1523805309', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('501', 'wenjianjiatongbu', '文件夹同步', 'tinyint(4) NOT NULL', 'select', '', '', '1', '0:不支持\r\n1:支持', '53', '0', '1', '1523845538', '1523845538', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('502', 'fufeifencheng', '付费分成', 'decimal(10,5) UNSIGNED NOT NULL', 'price', '', '', '1', '', '53', '0', '1', '1523846520', '1523846520', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('503', 'xiaoshoufencheng', '销售分成', 'decimal(10,5) UNSIGNED NOT NULL', 'price', '', '', '1', '', '53', '0', '1', '1523846549', '1523846549', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('504', 'ip', 'ip', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '40', '0', '1', '1526286445', '1526286445', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('505', 'num', '数量', 'int(10) UNSIGNED NOT NULL', 'num', '0', '', '1', '', '58', '0', '1', '1526804484', '1526804441', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('506', 'pk', 'PK', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '90', '0', '1', '1530025499', '1530025499', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('508', 'iszhongshen', '是否终身', 'tinyint(4) NOT NULL', 'select', '0', '', '1', '0:否\r\n1:是', '53', '0', '1', '1530774404', '1530774315', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('509', 'title', '标题', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '91', '0', '1', '1531666012', '1531666012', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('510', 'url', '地址', 'varchar(255) NOT NULL', 'string', '', '', '1', '', '91', '0', '1', '1531666031', '1531666031', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('511', 'menuid', '菜单id', 'int(10) UNSIGNED NOT NULL', 'num', '', '', '1', '', '91', '0', '1', '1531666249', '1531666249', '', '3', '', 'regex', '', '3', 'function');
INSERT INTO `wp_attribute` VALUES ('512', 'ctime', '时间', 'int(10) NOT NULL', 'datetime', '', '', '1', '', '91', '0', '1', '1531666712', '1531666712', '', '3', '', 'regex', '', '3', 'function');

-- ----------------------------
-- Table structure for `wp_attr_type`
-- ----------------------------
DROP TABLE IF EXISTS `wp_attr_type`;
CREATE TABLE `wp_attr_type` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '名称',
  `group` varchar(255) NOT NULL COMMENT '分组，一行一个',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_attr_type
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_attr_value`
-- ----------------------------
DROP TABLE IF EXISTS `wp_attr_value`;
CREATE TABLE `wp_attr_value` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `value` varchar(255) NOT NULL DEFAULT '' COMMENT '值',
  `attr_id` int(10) NOT NULL COMMENT '属性id',
  `sort` int(11) NOT NULL COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_attr_value
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_auth_extend`
-- ----------------------------
DROP TABLE IF EXISTS `wp_auth_extend`;
CREATE TABLE `wp_auth_extend` (
  `group_id` mediumint(10) unsigned NOT NULL COMMENT '用户id',
  `extend_id` mediumint(8) unsigned NOT NULL COMMENT '扩展表中数据的id',
  `type` tinyint(1) unsigned NOT NULL COMMENT '扩展类型标识 1:栏目分类权限;2:模型权限',
  UNIQUE KEY `group_extend_type` (`group_id`,`extend_id`,`type`) USING BTREE,
  KEY `uid` (`group_id`) USING BTREE,
  KEY `group_id` (`extend_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='用户组与分类的对应关系表';

-- ----------------------------
-- Records of wp_auth_extend
-- ----------------------------
INSERT INTO `wp_auth_extend` VALUES ('1', '1', '1');
INSERT INTO `wp_auth_extend` VALUES ('1', '1', '2');
INSERT INTO `wp_auth_extend` VALUES ('1', '2', '1');
INSERT INTO `wp_auth_extend` VALUES ('1', '2', '2');
INSERT INTO `wp_auth_extend` VALUES ('1', '3', '1');
INSERT INTO `wp_auth_extend` VALUES ('1', '3', '2');
INSERT INTO `wp_auth_extend` VALUES ('1', '4', '1');
INSERT INTO `wp_auth_extend` VALUES ('1', '37', '1');

-- ----------------------------
-- Table structure for `wp_auth_group`
-- ----------------------------
DROP TABLE IF EXISTS `wp_auth_group`;
CREATE TABLE `wp_auth_group` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户组id,自增主键',
  `module` varchar(20) NOT NULL DEFAULT '' COMMENT '用户组所属模块',
  `type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '组类型',
  `title` char(20) NOT NULL DEFAULT '' COMMENT '用户组中文名称',
  `description` varchar(80) NOT NULL DEFAULT '' COMMENT '描述信息',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '用户组状态：为1正常，为0禁用,-1为删除',
  `rules` varchar(500) NOT NULL DEFAULT '' COMMENT '用户组拥有的规则id，多个规则 , 隔开',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_auth_group
-- ----------------------------
INSERT INTO `wp_auth_group` VALUES ('6', 'admin', '1', '会计专区', '主要资金，订单，以及结算方面', '1', '228,242,250,251,256,261,264');
INSERT INTO `wp_auth_group` VALUES ('7', 'admin', '1', '审核组', '投诉、举报、订单审核、会员审核等', '1', '3,88,228,240,242,246,250,251,257,258,260,263,300');

-- ----------------------------
-- Table structure for `wp_auth_group_access`
-- ----------------------------
DROP TABLE IF EXISTS `wp_auth_group_access`;
CREATE TABLE `wp_auth_group_access` (
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `group_id` mediumint(8) unsigned NOT NULL COMMENT '用户组id',
  UNIQUE KEY `uid_group_id` (`uid`,`group_id`) USING BTREE,
  KEY `uid` (`uid`) USING BTREE,
  KEY `group_id` (`group_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_auth_group_access
-- ----------------------------
INSERT INTO `wp_auth_group_access` VALUES ('2', '2');
INSERT INTO `wp_auth_group_access` VALUES ('4', '2');
INSERT INTO `wp_auth_group_access` VALUES ('3', '6');
INSERT INTO `wp_auth_group_access` VALUES ('3', '7');

-- ----------------------------
-- Table structure for `wp_auth_rule`
-- ----------------------------
DROP TABLE IF EXISTS `wp_auth_rule`;
CREATE TABLE `wp_auth_rule` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '规则id,自增主键',
  `module` varchar(20) NOT NULL COMMENT '规则所属module',
  `type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '1-url;2-主菜单',
  `name` char(80) NOT NULL DEFAULT '' COMMENT '规则唯一英文标识',
  `title` char(20) NOT NULL DEFAULT '' COMMENT '规则中文描述',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否有效(0:无效,1:有效)',
  `condition` varchar(300) NOT NULL DEFAULT '' COMMENT '规则附加条件',
  PRIMARY KEY (`id`),
  KEY `module` (`module`,`status`,`type`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=302 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_auth_rule
-- ----------------------------
INSERT INTO `wp_auth_rule` VALUES ('1', 'admin', '2', 'Admin/Index/index', '首页', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('2', 'admin', '2', 'Admin/Article/index', '网站内容', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('3', 'admin', '2', 'admin/User/index', '会员管理', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('4', 'admin', '2', 'Admin/Addons/index', '扩展', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('5', 'admin', '2', 'admin/Config/group', '系统设置', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('7', 'admin', '1', 'admin/article/add', '新增', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('8', 'admin', '1', 'admin/article/edit', '编辑', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('9', 'admin', '1', 'admin/article/setStatus', '改变状态', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('10', 'admin', '1', 'admin/article/update', '保存', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('11', 'admin', '1', 'admin/article/autoSave', '保存草稿', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('12', 'admin', '1', 'admin/article/move', '移动', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('13', 'admin', '1', 'admin/article/copy', '复制', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('14', 'admin', '1', 'admin/article/paste', '粘贴', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('15', 'admin', '1', 'admin/article/permit', '还原', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('16', 'admin', '1', 'admin/article/clear', '清空', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('17', 'admin', '1', 'admin/Article/examine', '审核列表', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('18', 'admin', '1', 'admin/article/recycle', '回收站', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('19', 'admin', '1', 'admin/User/addaction', '新增用户行为', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('20', 'admin', '1', 'admin/User/editaction', '编辑用户行为', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('21', 'admin', '1', 'admin/User/saveAction', '保存用户行为', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('22', 'admin', '1', 'admin/User/setStatus', '变更行为状态', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('23', 'admin', '1', 'admin/User/changeStatus?method=forbidUser', '禁用会员', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('24', 'admin', '1', 'admin/User/changeStatus?method=resumeUser', '启用会员', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('25', 'admin', '1', 'admin/User/changeStatus?method=deleteUser', '删除会员', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('26', 'admin', '1', 'Admin/User/index', '用户信息', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('27', 'admin', '1', 'Admin/User/action', '用户行为', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('28', 'admin', '1', 'admin/AuthManager/changeStatus?method=deleteGroup', '删除', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('29', 'admin', '1', 'admin/AuthManager/changeStatus?method=forbidGroup', '禁用', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('30', 'admin', '1', 'admin/AuthManager/changeStatus?method=resumeGroup', '恢复', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('31', 'admin', '1', 'admin/AuthManager/createGroup', '新增', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('32', 'admin', '1', 'admin/AuthManager/editGroup', '编辑', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('33', 'admin', '1', 'admin/AuthManager/writeGroup', '保存用户组', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('34', 'admin', '1', 'admin/AuthManager/group', '授权', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('35', 'admin', '1', 'admin/AuthManager/access', '访问授权', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('36', 'admin', '1', 'admin/AuthManager/user', '成员授权', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('37', 'admin', '1', 'admin/AuthManager/removeFromGroup', '解除授权', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('38', 'admin', '1', 'admin/AuthManager/addToGroup', '保存成员授权', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('39', 'admin', '1', 'admin/AuthManager/category', '分类授权', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('40', 'admin', '1', 'admin/AuthManager/addToCategory', '保存分类授权', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('41', 'admin', '1', 'admin/authmanager/index', '用户组管理', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('42', 'admin', '1', 'admin/Addons/create', '创建', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('43', 'admin', '1', 'admin/Addons/checkForm', '检测创建', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('44', 'admin', '1', 'admin/Addons/preview', '预览', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('45', 'admin', '1', 'admin/Addons/build', '快速生成插件', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('46', 'admin', '1', 'admin/Addons/config', '设置', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('47', 'admin', '1', 'admin/Addons/disable', '禁用', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('48', 'admin', '1', 'admin/Addons/enable', '启用', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('49', 'admin', '1', 'admin/Addons/install', '安装', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('50', 'admin', '1', 'admin/Addons/uninstall', '卸载', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('51', 'admin', '1', 'admin/Addons/saveconfig', '更新配置', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('52', 'admin', '1', 'admin/Addons/adminList', '插件后台列表', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('53', 'admin', '1', 'admin/Addons/execute', 'URL方式访问插件', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('54', 'admin', '1', 'admin/Addons/index', '插件管理', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('55', 'admin', '1', 'admin/Addons/hooks', '钩子管理', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('56', 'admin', '1', 'admin/model/add', '新增', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('57', 'admin', '1', 'admin/model/edit', '编辑', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('58', 'admin', '1', 'admin/model/setStatus', '改变状态', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('59', 'admin', '1', 'admin/model/update', '保存数据', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('60', 'admin', '1', 'admin/model/index', '模型管理', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('61', 'admin', '1', 'admin/Config/edit', '编辑', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('62', 'admin', '1', 'admin/Config/del', '删除', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('63', 'admin', '1', 'admin/Config/add', '新增', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('64', 'admin', '1', 'admin/Config/save', '保存', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('65', 'admin', '1', 'admin/config/group', '网站设置', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('66', 'admin', '1', 'Admin/Config/index', '配置管理', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('67', 'admin', '1', 'admin/Channel/add', '新增', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('68', 'admin', '1', 'admin/Channel/edit', '编辑', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('69', 'admin', '1', 'admin/Channel/del', '删除', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('70', 'admin', '1', 'admin/Channel/index', '导航管理', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('71', 'admin', '1', 'admin/Category/edit', '编辑', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('72', 'admin', '1', 'admin/Category/add', '新增', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('73', 'admin', '1', 'admin/Category/remove', '删除', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('74', 'admin', '1', 'admin/Category/index', '分类管理', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('75', 'admin', '1', 'Admin/file/upload', '上传控件', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('76', 'admin', '1', 'Admin/file/uploadPicture', '上传图片', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('77', 'admin', '1', 'Admin/file/download', '下载', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('79', 'admin', '1', 'admin/article/batchOperate', '导入', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('80', 'admin', '1', 'admin/Database/index?type=export', '备份数据库', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('81', 'admin', '1', 'admin/Database/index?type=import', '还原数据库', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('82', 'admin', '1', 'admin/Database/export', '备份', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('83', 'admin', '1', 'admin/Database/optimize', '优化表', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('84', 'admin', '1', 'admin/Database/repair', '修复表', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('86', 'admin', '1', 'admin/Database/import', '恢复', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('87', 'admin', '1', 'admin/Database/del', '删除', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('88', 'admin', '1', 'admin/User/add', '新增用户', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('89', 'admin', '1', 'Admin/Attribute/index', '属性管理', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('90', 'admin', '1', 'admin/Attribute/add', '新增', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('91', 'admin', '1', 'admin/Attribute/edit', '编辑', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('92', 'admin', '1', 'admin/Attribute/setStatus', '改变状态', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('93', 'admin', '1', 'admin/Attribute/update', '保存数据', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('94', 'admin', '1', 'admin/AuthManager/modelauth', '模型授权', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('95', 'admin', '1', 'admin/AuthManager/addToModel', '保存模型授权', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('96', 'admin', '1', 'Admin/Category/move', '移动', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('97', 'admin', '1', 'Admin/Category/merge', '合并', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('98', 'admin', '1', 'Admin/Config/menu', '后台菜单管理', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('99', 'admin', '1', 'Admin/Article/mydocument', '内容', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('100', 'admin', '1', 'admin/menu/index', '菜单管理', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('101', 'admin', '1', 'Admin/other', '其他', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('102', 'admin', '1', 'admin/Menu/add', '新增', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('103', 'admin', '1', 'admin/Menu/edit', '编辑', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('104', 'admin', '1', 'Admin/Think/lists?model=article', '文章管理', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('105', 'admin', '1', 'Admin/Think/lists?model=download', '下载管理', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('106', 'admin', '1', 'Admin/Think/lists?model=config', '配置管理', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('107', 'admin', '1', 'Admin/Action/actionlog', '行为日志', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('108', 'admin', '1', 'Admin/User/updatePassword', '修改密码', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('109', 'admin', '1', 'Admin/User/updateNickname', '修改昵称', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('110', 'admin', '1', 'admin/action/edit', '查看行为日志', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('111', 'admin', '2', 'Admin/article/index', '文档列表', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('112', 'admin', '2', 'Admin/article/add', '新增', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('113', 'admin', '2', 'Admin/article/edit', '编辑', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('114', 'admin', '2', 'Admin/article/setStatus', '改变状态', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('115', 'admin', '2', 'Admin/article/update', '保存', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('116', 'admin', '2', 'Admin/article/autoSave', '保存草稿', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('117', 'admin', '2', 'Admin/article/move', '移动', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('118', 'admin', '2', 'Admin/article/copy', '复制', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('119', 'admin', '2', 'Admin/article/paste', '粘贴', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('120', 'admin', '2', 'Admin/article/batchOperate', '导入', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('121', 'admin', '2', 'Admin/article/recycle', '回收站', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('122', 'admin', '2', 'Admin/article/permit', '还原', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('123', 'admin', '2', 'Admin/article/clear', '清空', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('124', 'admin', '2', 'Admin/User/add', '新增用户', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('125', 'admin', '2', 'Admin/User/action', '用户行为', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('126', 'admin', '2', 'Admin/User/addAction', '新增用户行为', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('127', 'admin', '2', 'Admin/User/editAction', '编辑用户行为', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('128', 'admin', '2', 'Admin/User/saveAction', '保存用户行为', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('129', 'admin', '2', 'Admin/User/setStatus', '变更行为状态', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('130', 'admin', '2', 'Admin/User/changeStatus?method=forbidUser', '禁用会员', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('131', 'admin', '2', 'Admin/User/changeStatus?method=resumeUser', '启用会员', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('132', 'admin', '2', 'Admin/User/changeStatus?method=deleteUser', '删除会员', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('133', 'admin', '2', 'Admin/AuthManager/index', '权限管理', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('134', 'admin', '2', 'Admin/AuthManager/changeStatus?method=deleteGroup', '删除', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('135', 'admin', '2', 'Admin/AuthManager/changeStatus?method=forbidGroup', '禁用', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('136', 'admin', '2', 'Admin/AuthManager/changeStatus?method=resumeGroup', '恢复', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('137', 'admin', '2', 'Admin/AuthManager/createGroup', '新增', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('138', 'admin', '2', 'Admin/AuthManager/editGroup', '编辑', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('139', 'admin', '2', 'Admin/AuthManager/writeGroup', '保存用户组', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('140', 'admin', '2', 'Admin/AuthManager/group', '授权', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('141', 'admin', '2', 'Admin/AuthManager/access', '访问授权', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('142', 'admin', '2', 'Admin/AuthManager/user', '成员授权', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('143', 'admin', '2', 'Admin/AuthManager/removeFromGroup', '解除授权', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('144', 'admin', '2', 'Admin/AuthManager/addToGroup', '保存成员授权', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('145', 'admin', '2', 'Admin/AuthManager/category', '分类授权', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('146', 'admin', '2', 'Admin/AuthManager/addToCategory', '保存分类授权', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('147', 'admin', '2', 'Admin/AuthManager/modelauth', '模型授权', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('148', 'admin', '2', 'Admin/AuthManager/addToModel', '保存模型授权', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('149', 'admin', '2', 'Admin/Addons/create', '创建', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('150', 'admin', '2', 'Admin/Addons/checkForm', '检测创建', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('151', 'admin', '2', 'Admin/Addons/preview', '预览', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('152', 'admin', '2', 'Admin/Addons/build', '快速生成插件', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('153', 'admin', '2', 'Admin/Addons/config', '设置', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('154', 'admin', '2', 'Admin/Addons/disable', '禁用', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('155', 'admin', '2', 'Admin/Addons/enable', '启用', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('156', 'admin', '2', 'Admin/Addons/install', '安装', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('157', 'admin', '2', 'Admin/Addons/uninstall', '卸载', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('158', 'admin', '2', 'Admin/Addons/saveconfig', '更新配置', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('159', 'admin', '2', 'Admin/Addons/adminList', '插件后台列表', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('160', 'admin', '2', 'Admin/Addons/execute', 'URL方式访问插件', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('161', 'admin', '2', 'Admin/Addons/hooks', '钩子管理', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('162', 'admin', '2', 'Admin/Model/index', '模型管理', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('163', 'admin', '2', 'Admin/model/add', '新增', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('164', 'admin', '2', 'Admin/model/edit', '编辑', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('165', 'admin', '2', 'Admin/model/setStatus', '改变状态', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('166', 'admin', '2', 'Admin/model/update', '保存数据', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('167', 'admin', '2', 'Admin/Attribute/index', '属性管理', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('168', 'admin', '2', 'Admin/Attribute/add', '新增', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('169', 'admin', '2', 'Admin/Attribute/edit', '编辑', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('170', 'admin', '2', 'Admin/Attribute/setStatus', '改变状态', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('171', 'admin', '2', 'Admin/Attribute/update', '保存数据', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('172', 'admin', '2', 'Admin/Config/index', '配置管理', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('173', 'admin', '2', 'Admin/Config/edit', '编辑', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('174', 'admin', '2', 'Admin/Config/del', '删除', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('175', 'admin', '2', 'Admin/Config/add', '新增', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('176', 'admin', '2', 'Admin/Config/save', '保存', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('177', 'admin', '2', 'Admin/Menu/index', '菜单管理', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('178', 'admin', '2', 'Admin/Channel/index', '导航管理', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('179', 'admin', '2', 'Admin/Channel/add', '新增', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('180', 'admin', '2', 'Admin/Channel/edit', '编辑', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('181', 'admin', '2', 'Admin/Channel/del', '删除', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('182', 'admin', '2', 'Admin/Category/index', '分类管理', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('183', 'admin', '2', 'Admin/Category/edit', '编辑', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('184', 'admin', '2', 'Admin/Category/add', '新增', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('185', 'admin', '2', 'Admin/Category/remove', '删除', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('186', 'admin', '2', 'Admin/Category/move', '移动', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('187', 'admin', '2', 'Admin/Category/merge', '合并', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('188', 'admin', '2', 'Admin/Database/index?type=export', '备份数据库', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('189', 'admin', '2', 'Admin/Database/export', '备份', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('190', 'admin', '2', 'Admin/Database/optimize', '优化表', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('191', 'admin', '2', 'Admin/Database/repair', '修复表', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('192', 'admin', '2', 'Admin/Database/index?type=import', '还原数据库', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('193', 'admin', '2', 'Admin/Database/import', '恢复', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('194', 'admin', '2', 'Admin/Database/del', '删除', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('195', 'admin', '2', 'Admin/other', '其他', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('196', 'admin', '2', 'Admin/Menu/add', '新增', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('197', 'admin', '2', 'Admin/Menu/edit', '编辑', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('198', 'admin', '2', 'Admin/Think/lists?model=article', '应用', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('199', 'admin', '2', 'Admin/Think/lists?model=download', '下载管理', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('200', 'admin', '2', 'Admin/Think/lists?model=config', '应用', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('201', 'admin', '2', 'Admin/Action/actionlog', '行为日志', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('202', 'admin', '2', 'Admin/User/updatePassword', '修改密码', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('203', 'admin', '2', 'Admin/User/updateNickname', '修改昵称', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('204', 'admin', '2', 'Admin/action/edit', '查看行为日志', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('205', 'admin', '1', 'admin/think/add', '新增数据', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('206', 'admin', '1', 'admin/think/edit', '编辑数据', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('207', 'admin', '1', 'admin/Menu/import', '导入', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('208', 'admin', '1', 'admin/Model/generate', '生成', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('209', 'admin', '1', 'admin/Addons/addHook', '新增钩子', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('210', 'admin', '1', 'admin/Addons/edithook', '编辑钩子', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('211', 'admin', '1', 'admin/Article/sort', '文档排序', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('212', 'admin', '1', 'admin/Config/sort', '排序', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('213', 'admin', '1', 'admin/Menu/sort', '排序', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('214', 'admin', '1', 'admin/Channel/sort', '排序', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('215', 'admin', '1', 'admin/Category/operate/type/move', '移动', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('216', 'admin', '1', 'admin/Category/operate/type/merge', '合并', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('217', 'admin', '1', 'admin/think/lists', '数据列表', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('218', 'admin', '1', 'Admin/Type/index?table=typecs&typename=分类测试', '分类测试', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('219', 'admin', '1', 'admin/Think/lists?model=advert', '广告管理', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('220', 'admin', '1', 'admin/Goods/lists', '商品管理', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('221', 'admin', '1', 'admin/Think/lists?model=goods_cate', '商品分类', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('222', 'admin', '1', 'Admin/Think/lists?model=goods_type', '商品类型', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('223', 'admin', '2', 'Admin/left', '商城', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('224', 'admin', '1', 'Admin/AttrType/index', '产品类型', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('225', 'admin', '1', 'Admin/Type/index/table/goods_category/typename/商品分类', '商品分类', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('226', 'admin', '1', 'admin/User/lists', '管理员管理', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('227', 'admin', '1', 'Admin/Index/index', '后台首页', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('228', 'admin', '1', 'admin/v/lists?model_id=27', '会员列表', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('229', 'admin', '1', 'admin/V/lists?model_id=34', '文件管理', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('230', 'admin', '1', 'admin/V/lists?model_id=34/type/3', '回收站文件', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('231', 'admin', '1', 'admin/V/lists?model_id=31', '新闻文章', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('232', 'admin', '1', 'admin/V/lists?model_id=5', '友情链接', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('233', 'admin', '1', 'admin/Cash/lists?model_id=33', '提现记录', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('234', 'admin', '1', 'admin/V/lists?model_id=32', '站点帮助', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('235', 'admin', '1', 'admin/V/lists?model_id=35', '充值记录', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('236', 'admin', '1', 'admin/V/lists?model_id=36', '', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('237', 'admin', '1', 'admin/V/lists?model_id=37', '', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('238', 'admin', '1', 'admin/V/lists?model_id=38', '', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('239', 'admin', '1', 'admin/v/lists?model_id=39', '新闻公告', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('240', 'admin', '1', 'admin/v/lists?model_id=40', '举报管理', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('241', 'admin', '1', 'admin/V/lists?model_id=41', '银行卡绑定', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('242', 'admin', '1', 'admin/v/lists?model_id=21', '广告管理', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('243', 'admin', '1', 'admin/Type/index?table=folder&typename=网盘目录', '网盘目录', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('244', 'admin', '1', 'admin/V/lists?model_id=45', '风格管理', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('245', 'admin', '1', 'admin/V/lists?model_id=49', '开发者管理', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('246', 'admin', '1', 'admin/v/lists?model_id=53', '网盘类型', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('247', 'admin', '1', 'admin/V/lists?model_id=54', '网盘价格', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('248', 'admin', '1', 'admin/V/lists?model_id=57', '开发者购买记录', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('249', 'admin', '1', 'admin/V/lists?model_id=59', '资金明细', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('250', 'admin', '1', 'admin/v/lists?model_id=58', '软件购买订单', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('251', 'admin', '1', 'admin/v/lists?model_id=55', '网盘充值订单', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('252', 'admin', '1', 'admin/V/lists?model_id=56', '下载记录', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('253', 'admin', '1', 'admin/V/lists?model_id=51', '教学视频', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('254', 'admin', '1', 'admin/v/lists/model_id/33/type/1/status/0', '用户申请', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('255', 'admin', '1', 'admin/V/lists?model_id=33&amp;type=2&amp;status=0', '系统提现', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('256', 'admin', '1', 'admin/v/lists?model_id=33&amp;today=1', '提现记录', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('257', 'admin', '1', 'admin/Folder/lists', '目录管理', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('258', 'admin', '1', 'admin/File/lists', '文件管理', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('259', 'admin', '1', 'admin/File/recycle', '文件回收站', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('260', 'admin', '1', 'admin/v/lists?model_id=88', '积分日志', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('261', 'admin', '1', 'admin/config/group?id=13', '提现设置', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('262', 'admin', '1', 'admin/v/lists?model_id=86', '配置管理', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('263', 'admin', '2', 'admin/', '站内资讯', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('264', 'admin', '1', 'admin/v/lists?model_id=89', '支付通道', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('265', 'admin', '2', 'admin/V/lists?model_id=21', '广告设置', '-1', '');
INSERT INTO `wp_auth_rule` VALUES ('266', 'admin', '1', 'admin/User/changeStatus/method/forbidUser', '禁用会员', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('267', 'admin', '1', 'admin/User/changeStatus/method/resumeUser', '启用会员', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('268', 'admin', '1', 'admin/User/changeStatus/method/deleteUser', '删除会员', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('269', 'admin', '1', 'admin/AuthManager/changeStatus/method/deleteGroup', '删除', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('270', 'admin', '1', 'admin/AuthManager/changeStatus/method/forbidGroup', '禁用', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('271', 'admin', '1', 'admin/AuthManager/changeStatus/method/resumeGroup', '恢复', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('272', 'admin', '1', 'admin/Think/lists/model/advert', '广告管理', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('273', 'admin', '1', 'admin/Think/lists/model/goods_cate', '商品分类', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('274', 'admin', '1', 'admin/V/lists/model_id/34', '文件管理', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('275', 'admin', '1', 'admin/V/lists/model_id/34/type/3', '回收站文件', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('276', 'admin', '1', 'admin/V/lists/model_id/31', '新闻文章', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('277', 'admin', '1', 'admin/V/lists/model_id/5', '友情链接', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('278', 'admin', '1', 'admin/Cash/lists/model_id/33', '提现记录', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('279', 'admin', '1', 'admin/V/lists/model_id/32', '站点帮助', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('280', 'admin', '1', 'admin/V/lists/model_id/35', '充值记录', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('281', 'admin', '1', 'admin/V/lists/model_id/36', '', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('282', 'admin', '1', 'admin/V/lists/model_id/37', '', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('283', 'admin', '1', 'admin/V/lists/model_id/38', '', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('284', 'admin', '1', 'admin/V/lists/model_id/39', '公告管理', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('285', 'admin', '1', 'admin/V/lists/model_id/40', '举报管理', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('286', 'admin', '1', 'admin/V/lists/model_id/41', '银行卡绑定', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('287', 'admin', '1', 'admin/V/lists/model_id/21', '广告管理', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('288', 'admin', '1', 'admin/Type/index/table/folder/typename/网盘目录', '网盘目录', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('289', 'admin', '1', 'admin/V/lists/model_id/45', '风格管理', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('290', 'admin', '1', 'admin/V/lists/model_id/49', '开发者管理', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('291', 'admin', '1', 'admin/V/lists/model_id/53', '网盘类型', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('292', 'admin', '1', 'admin/V/lists/model_id/54', '网盘价格', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('293', 'admin', '1', 'admin/V/lists/model_id/57', '开发者购买记录', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('294', 'admin', '1', 'admin/V/lists/model_id/59', '资金明细', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('295', 'admin', '1', 'admin/V/lists/model_id/58', '文件购买记录', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('296', 'admin', '1', 'admin/V/lists/model_id/55', '网盘升级记录', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('297', 'admin', '1', 'admin/V/lists/model_id/56', '下载记录', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('298', 'admin', '1', 'admin/V/lists/model_id/51', '教学视频', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('299', 'admin', '1', 'admin/Database/index/type/import', '还原数据库', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('300', 'admin', '2', 'admin/V/lists/model_id/21', '广告设置', '1', '');
INSERT INTO `wp_auth_rule` VALUES ('301', 'admin', '1', 'admin/Database/index/type/export', '备份数据库', '1', '');

-- ----------------------------
-- Table structure for `wp_bank`
-- ----------------------------
DROP TABLE IF EXISTS `wp_bank`;
CREATE TABLE `wp_bank` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `bank` varchar(255) NOT NULL COMMENT '开户行',
  `card` varchar(255) NOT NULL COMMENT '卡号',
  `nickname` varchar(255) NOT NULL COMMENT '开户名',
  `address` varchar(255) NOT NULL COMMENT '开户地区',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_bank
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_banner`
-- ----------------------------
DROP TABLE IF EXISTS `wp_banner`;
CREATE TABLE `wp_banner` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `imgs` varchar(255) NOT NULL COMMENT '图集',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_banner
-- ----------------------------
INSERT INTO `wp_banner` VALUES ('1', '0', '34', '1100,1101,1102,1103');
INSERT INTO `wp_banner` VALUES ('2', '0', '34', '0');
INSERT INTO `wp_banner` VALUES ('3', '0', '34', '0');

-- ----------------------------
-- Table structure for `wp_case`
-- ----------------------------
DROP TABLE IF EXISTS `wp_case`;
CREATE TABLE `wp_case` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `title` varchar(255) NOT NULL COMMENT '标题',
  `img` varchar(255) NOT NULL COMMENT '图片',
  `sort` int(10) unsigned NOT NULL COMMENT '排序',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `url` varchar(255) NOT NULL COMMENT '链接',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_case
-- ----------------------------
INSERT INTO `wp_case` VALUES ('1', '0', '案件名称', '/Uploads/201712/91/60/91603f0cd517f623cef964c61cdc01cc.jpg', '2', '34', 'https://613600010.docs.qq.com/3XGWNZAE2GT?type=2#BB08J2');
INSERT INTO `wp_case` VALUES ('2', '0', '案件名称', '/Uploads/201712/91/60/91603f0cd517f623cef964c61cdc01cc.jpg', '2', '34', 'https://613600010.docs.qq.com/3XGWNZAE2GT?type=2#BB08J2');

-- ----------------------------
-- Table structure for `wp_cash`
-- ----------------------------
DROP TABLE IF EXISTS `wp_cash`;
CREATE TABLE `wp_cash` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `truename` varchar(255) NOT NULL COMMENT '用户名',
  `amount` decimal(10,2) unsigned NOT NULL COMMENT '提现金额',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态',
  `ctime` int(10) NOT NULL COMMENT '申请时间',
  `cash_card` varchar(255) NOT NULL COMMENT '提现账号',
  `cash_price` decimal(10,2) unsigned NOT NULL COMMENT '手续费',
  `pay_way` tinyint(4) NOT NULL COMMENT '提现方式',
  `cash_amount` decimal(10,2) unsigned NOT NULL COMMENT '到账金额',
  `no` varchar(255) NOT NULL COMMENT '订单号',
  `type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '分类',
  `pay_time` int(10) NOT NULL COMMENT '支付时间',
  `about` text NOT NULL COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_cash
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_cash_copy`
-- ----------------------------
DROP TABLE IF EXISTS `wp_cash_copy`;
CREATE TABLE `wp_cash_copy` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `truename` varchar(255) NOT NULL COMMENT '用户名',
  `amount` decimal(10,2) unsigned NOT NULL COMMENT '提现金额',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态',
  `ctime` int(10) NOT NULL COMMENT '申请时间',
  `cash_card` varchar(255) NOT NULL COMMENT '提现账号',
  `cash_price` decimal(10,2) unsigned NOT NULL COMMENT '手续费',
  `pay_way` tinyint(4) NOT NULL COMMENT '提现方式',
  `cash_amount` decimal(10,2) unsigned NOT NULL COMMENT '到账金额',
  `no` varchar(255) NOT NULL COMMENT '订单号',
  `type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '分类',
  `pay_time` int(10) NOT NULL COMMENT '支付时间',
  `about` text NOT NULL COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_cash_copy
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_category`
-- ----------------------------
DROP TABLE IF EXISTS `wp_category`;
CREATE TABLE `wp_category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `name` varchar(30) NOT NULL COMMENT '标志',
  `title` varchar(50) NOT NULL COMMENT '标题',
  `title_en` varchar(50) NOT NULL COMMENT '英文标题',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级分类ID',
  `showtype` varchar(50) NOT NULL,
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序（同级有效）',
  `list_row` tinyint(3) unsigned NOT NULL DEFAULT '10' COMMENT '列表每页行数',
  `meta_title` varchar(50) NOT NULL DEFAULT '' COMMENT 'SEO的网页标题',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '描述',
  `template_index` varchar(100) NOT NULL DEFAULT '' COMMENT '频道页模板',
  `template_lists` varchar(100) NOT NULL DEFAULT '' COMMENT '列表页模板',
  `template_show` varchar(255) NOT NULL COMMENT '详情页模板',
  `template_add` varchar(255) NOT NULL COMMENT '会员发布模板',
  `template_mod` varchar(255) NOT NULL COMMENT '会员编辑模板',
  `template_edit` varchar(100) NOT NULL DEFAULT '' COMMENT '编辑页模板',
  `template_my` varchar(255) NOT NULL COMMENT '会员管理模板',
  `model` varchar(100) NOT NULL DEFAULT '' COMMENT '列表绑定模型',
  `model_sub` varchar(100) NOT NULL DEFAULT '' COMMENT '子文档绑定模型',
  `model_id` int(10) NOT NULL DEFAULT '0' COMMENT '列表绑定模型',
  `type` varchar(100) NOT NULL DEFAULT '' COMMENT '允许发布的内容类型',
  `link_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '外链',
  `allow_publish` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否允许发布内容',
  `display` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '可见性',
  `reply` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否允许回复',
  `check` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '发布的文章是否需要审核',
  `reply_model` varchar(100) NOT NULL DEFAULT '',
  `extend` text COMMENT '扩展设置',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '数据状态',
  `icon` varchar(255) NOT NULL DEFAULT '0' COMMENT '分类图标',
  `about` text NOT NULL COMMENT '分类介绍',
  `groups` varchar(255) NOT NULL DEFAULT '' COMMENT '分组定义',
  `list_data` varchar(50) NOT NULL COMMENT '列表数据模型',
  `list_field` varchar(255) NOT NULL COMMENT '列表字段',
  `url` varchar(255) NOT NULL COMMENT '外链',
  `fields` text NOT NULL COMMENT '栏目启用的字段',
  `fields_home` text NOT NULL COMMENT '前台栏目启用的字段',
  `list_grid` varchar(255) NOT NULL COMMENT '列表定义',
  `list_grid_honme` varchar(255) NOT NULL COMMENT '前台列表字段定义',
  `list_grid_search` varchar(255) NOT NULL COMMENT '搜索字段定义',
  `list_grid_search_home` varchar(255) NOT NULL COMMENT '前台搜索字段定义',
  `model_name` varchar(255) NOT NULL COMMENT '数据处理模型',
  `model_list_name` varchar(255) NOT NULL COMMENT '列表模型',
  `order` varchar(255) NOT NULL COMMENT '列表排序',
  `model_lists` varchar(50) NOT NULL COMMENT '列表模型',
  `model_show` varchar(50) NOT NULL COMMENT '详情页模型',
  `model_add` varchar(50) NOT NULL COMMENT '数据添加模型，默认为name',
  `model_mod` varchar(50) NOT NULL COMMENT '数据修改模型，默认为name',
  `model_del` varchar(50) NOT NULL COMMENT '数据删除模型，默认为name',
  `model_order` varchar(255) NOT NULL COMMENT '列表排序',
  `model_allow` tinyint(4) NOT NULL DEFAULT '0' COMMENT '允许发布数据类型,0禁止，1仅允许后台，2前台允许登录发布，3前台允许不登录发布',
  `field_lists` text NOT NULL COMMENT '列表字段',
  `field_add` varchar(255) NOT NULL COMMENT '添加字段',
  `field_mod` varchar(255) NOT NULL COMMENT '编辑字段',
  `field_search` varchar(255) NOT NULL COMMENT '搜索字段',
  `field_lists_front` varchar(255) NOT NULL COMMENT '前台列表字段',
  `field_add_front` varchar(255) NOT NULL COMMENT '前台添加字段',
  `field_mod_front` varchar(255) NOT NULL COMMENT '前台编辑字段',
  `field_search_front` varchar(255) NOT NULL COMMENT '前台搜索字段',
  `field_form` varchar(255) NOT NULL COMMENT '表单字段',
  `template` varchar(255) NOT NULL COMMENT '模板',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`) USING BTREE,
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='分类表';

-- ----------------------------
-- Records of wp_category
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_chajian_order`
-- ----------------------------
DROP TABLE IF EXISTS `wp_chajian_order`;
CREATE TABLE `wp_chajian_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `order_no` varchar(255) NOT NULL COMMENT '订单号',
  `buyer_id` int(10) unsigned NOT NULL COMMENT '买家id',
  `seller_id` int(10) unsigned NOT NULL COMMENT '卖家id',
  `ctime` int(10) NOT NULL COMMENT '添加时间',
  `name` varchar(255) NOT NULL COMMENT '插件名称',
  `pay_way` varchar(255) NOT NULL COMMENT '支付方式',
  `amount` decimal(10,2) unsigned NOT NULL COMMENT '金额',
  `pttc` decimal(10,2) unsigned NOT NULL COMMENT '平台提成',
  `shtc` decimal(10,2) unsigned NOT NULL COMMENT '商户提成',
  `ptlr` decimal(10,2) unsigned NOT NULL COMMENT '平台利润',
  `status` tinyint(4) NOT NULL COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_chajian_order
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_channel`
-- ----------------------------
DROP TABLE IF EXISTS `wp_channel`;
CREATE TABLE `wp_channel` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '频道ID',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级频道ID',
  `title` char(30) NOT NULL COMMENT '频道标题',
  `url` char(100) NOT NULL COMMENT '频道连接',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '导航排序',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态',
  `target` tinyint(2) unsigned NOT NULL DEFAULT '0' COMMENT '新窗口打开',
  `type` varchar(255) NOT NULL DEFAULT '' COMMENT '分类',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_channel
-- ----------------------------
INSERT INTO `wp_channel` VALUES ('1', '0', '首页', 'Index/index', '1', '1379475111', '1379923177', '1', '0', 'nav');
INSERT INTO `wp_channel` VALUES ('2', '0', '博客', 'Article/index?category=blog', '2', '1379475131', '1379483713', '1', '0', 'nav');
INSERT INTO `wp_channel` VALUES ('3', '0', '官网', 'http://www.onethink.cn', '3', '1379475154', '1387163458', '1', '0', 'nav');

-- ----------------------------
-- Table structure for `wp_comment`
-- ----------------------------
DROP TABLE IF EXISTS `wp_comment`;
CREATE TABLE `wp_comment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `pid` int(10) unsigned NOT NULL COMMENT '父级id',
  `tid` int(10) unsigned NOT NULL COMMENT '栏目id',
  `aid` int(10) unsigned NOT NULL COMMENT '文章id',
  `content` text NOT NULL COMMENT '内容',
  `good` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '顶',
  `bad` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '踩',
  `ctime` int(10) unsigned NOT NULL COMMENT '发布时间',
  `ishow` tinyint(2) NOT NULL COMMENT '是否显示',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_comment
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_config`
-- ----------------------------
DROP TABLE IF EXISTS `wp_config`;
CREATE TABLE `wp_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `name` varchar(30) NOT NULL COMMENT '配置标示',
  `type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '配置类型',
  `title` varchar(50) NOT NULL COMMENT '配置名称',
  `group` tinyint(4) NOT NULL DEFAULT '1' COMMENT '配置分组',
  `extra` text NOT NULL COMMENT '配置项',
  `remark` varchar(100) NOT NULL COMMENT '配置备注',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '状态',
  `value` text NOT NULL COMMENT '配置值',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_name` (`name`) USING BTREE,
  KEY `type` (`type`) USING BTREE,
  KEY `group` (`group`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=152 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_config
-- ----------------------------
INSERT INTO `wp_config` VALUES ('1', 'WEB_SITE_TITLE', '1', '网站标题', '1', '', '网站标题前台显示标题', '1378898976', '1517452535', '1', '106云自动发卡平台-云网盘自动软件销售-发卡平台网盘-源码软件商城云盘-企业网盘-同步妙传-断点续传-备份-无限空间-免费网络硬盘-企业云盘-赚钱网盘-文件付费下载-文件共享|特效网盘', '1');
INSERT INTO `wp_config` VALUES ('2', 'WEB_SITE_DESCRIPTION', '2', '网站描述', '1', '', '网站搜索引擎描述', '1378898976', '1517452569', '1', '106网盘是一个大型云储存免费网盘，可免费上传下载文件分享、同时也是一个大型网络交易平台支持软件文件源码等在线支付提取码下载，支持自动卡密销售发卡，上传文件支持断点续传、同步妙传、文件在线更新等功能。', '3');
INSERT INTO `wp_config` VALUES ('3', 'WEB_SITE_KEYWORD', '2', '网站关键字', '1', '', '网站搜索引擎关键字', '1378898976', '1517452553', '1', '网盘,自动发卡平台,付费自动发卡,提取码下载,企业网盘,云盘,网络硬盘,同步,备份,分享,同步盘,网络U盘,免费,文件,跨平台,协同办公,无限空间,最快,Dropbox,Box,106云盘,永硕E盘,百度云,快盘,酷盘，106网盘,付费网盘,付费下载,网赚网盘', '2');
INSERT INTO `wp_config` VALUES ('10', 'WEB_SITE_ICP', '1', '网站备案号', '1', '', '设置在网站底部显示的备案号，如“沪ICP备12007941号-2', '1378900335', '1458909815', '1', '', '5');
INSERT INTO `wp_config` VALUES ('33', 'ALLOW_VISIT', '3', '不受限控制器方法', '0', '', '', '1386644047', '1386644741', '1', '0:article/draftbox\r\n1:article/mydocument\r\n2:Category/tree\r\n3:Index/verify\r\n4:file/upload\r\n5:file/download\r\n6:user/updatePassword\r\n7:user/updateNickname\r\n8:user/submitPassword\r\n9:user/submitNickname\r\n10:file/uploadpicture', '0');
INSERT INTO `wp_config` VALUES ('34', 'DENY_VISIT', '3', '超管专限控制器方法', '0', '', '仅超级管理员可访问的控制器方法', '1386644141', '1386644659', '1', '0:Addons/addhook\r\n1:Addons/edithook\r\n2:Addons/delhook\r\n3:Addons/updateHook\r\n4:Admin/getMenus\r\n5:Admin/recordList\r\n6:AuthManager/updateRules\r\n7:AuthManager/tree', '0');
INSERT INTO `wp_config` VALUES ('39', 'WEB_SITE_STATIC_DOAMIN', '1', '静态资源域名', '2', '', '例如 http://static.abc.com', '1434202490', '1517452454', '1', 'http://jt.qqqpan.com', '4');
INSERT INTO `wp_config` VALUES ('46', 'TEL', '1', '电话', '1', '', '官方联系电话', '0', '1525513141', '1', '', '5');
INSERT INTO `wp_config` VALUES ('47', 'EMAIL', '1', '投诉邮箱', '1', '', '邮箱', '0', '1525514655', '1', '', '5');
INSERT INTO `wp_config` VALUES ('48', 'DOWNLOAD_KEYWORD', '2', '下载页面附加关键词', '3', '', '下载页面附加关键词', '0', '1517453231', '1', ' _ 网络硬盘,免费网络硬盘,免费网盘,网盘,网络U盘,免费网络U盘,网盘下载(www.106pan.com)', '0');
INSERT INTO `wp_config` VALUES ('49', 'DOWNLOAD_TITLE', '2', '下载页面附加标题', '3', '', '下载页面附加标题', '0', '1517453260', '1', ' _  在线高速下载-106云盘-超大网盘(www.a8tg.com)', '1');
INSERT INTO `wp_config` VALUES ('50', 'FREE_TITLE', '2', '网盘附加标题', '3', '', '免费网盘附加标题', '0', '1525593024', '1', '106云盘|易极云盘是扎兰屯市姝妍计算机服务有限公司旗下产品，我公司最安全、稳定、快速的云盘/网盘/企业网盘/独立宣传页面，文件同步、备份、分享服务。存储空间、速度最快的局域网同步为特', '2');
INSERT INTO `wp_config` VALUES ('51', 'COPYRIGHT', '1', '公司名称', '1', '', '版权信息', '0', '1525512548', '1', '扎兰屯市姝妍计算机服务有限公司', '6');
INSERT INTO `wp_config` VALUES ('52', 'ADDRESS', '1', '联系地址', '1', '', '联系地址', '0', '1517452788', '1', '', '7');
INSERT INTO `wp_config` VALUES ('57', 'DOMAIN_INDEX', '1', '推广域名', '2', '', '以http://开头', '0', '1525569346', '1', 'http://www.106pan.com', '0');
INSERT INTO `wp_config` VALUES ('58', 'DOMAIN_USER', '1', '会员中心域名', '2', '', '会员中心域名', '0', '1525488097', '0', 'member.eeepan.com', '2');
INSERT INTO `wp_config` VALUES ('59', 'DOMAIN_WANGPAN', '1', '免费网盘二级域名', '2', '', '会员网盘二级域名  一行一个', '0', '1518486428', '1', '106pan.com', '5');
INSERT INTO `wp_config` VALUES ('60', 'DOMAIN_DOWNLOAD', '1', '下载页面域名', '2', '', '下载页面域名', '0', '1517453159', '1', 'pan.106pan.com', '3');
INSERT INTO `wp_config` VALUES ('63', 'KEFUQQ_01', '0', '在线咨询', '4', '', '在线客服', '0', '1525659887', '1', '', '1');
INSERT INTO `wp_config` VALUES ('64', 'CASH_SWITCH', '4', '提现开关', '13', '1:开启\r\n2:关闭', '提现开关', '0', '1521088815', '1', '1', '11');
INSERT INTO `wp_config` VALUES ('65', 'CASH_CLOSE', '1', '提现关闭提示', '13', '', '提现关闭提示', '0', '1516607572', '1', '节假日不结算，对您造成的不变我们表示歉意；', '0');
INSERT INTO `wp_config` VALUES ('66', 'CASH_MIN', '1', '最低提现资金', '13', '', '最低提现资金', '0', '1516607564', '1', '5', '0');
INSERT INTO `wp_config` VALUES ('67', 'CASH_NUM', '1', '每日最多提现次数', '13', '', '每日最多提现次数', '0', '1516607555', '1', '2', '0');
INSERT INTO `wp_config` VALUES ('68', 'CASH_STIME', '1', '提现开始时间', '13', '', '提现开始时间', '0', '1516607546', '1', '8.00', '0');
INSERT INTO `wp_config` VALUES ('69', 'CASH_ETIME', '1', '提现结束时间', '13', '', '提现结束时间', '0', '1516607533', '1', '18.00', '0');
INSERT INTO `wp_config` VALUES ('70', 'CASH_FREE', '1', '满多少免提现手续费', '13', '', '满多少免提现手续费', '0', '1516607520', '1', '100', '0');
INSERT INTO `wp_config` VALUES ('71', 'PROHIBIT_FORMAT', '1', '禁止上传文件格式', '12', '', '禁止上传文件格式', '0', '1517506352', '0', '', '0');
INSERT INTO `wp_config` VALUES ('72', 'SENSITIVE_WORDS', '2', '敏感词设置', '1', '', '敏感词设置', '0', '1517452123', '0', '', '0');
INSERT INTO `wp_config` VALUES ('77', 'EMAIL_EMAIL', '1', '发件箱', '11', '', '', '0', '1517386934', '1', '', '0');
INSERT INTO `wp_config` VALUES ('78', 'EMAIL_PWD', '1', '发件箱密码', '11', '', '', '0', '1517386906', '1', '', '0');
INSERT INTO `wp_config` VALUES ('80', 'QINIU_FILE1', '3', '七牛文件存储空间1', '12', '', '', '1516265505', '1516606884', '1', 'accessKey:\r\nsecretKey:\r\nbuket:ruanjian\r\ndomain:s.a8tg.com', '3');
INSERT INTO `wp_config` VALUES ('81', 'QINIU_STATIC', '3', '七牛静态资源存储空间', '12', '', '', '1516266997', '1516606779', '1', 'accessKey:\r\nsecretKey:\r\nbuket:ziyuan\r\ndomain:z.a8tg.com', '1');
INSERT INTO `wp_config` VALUES ('82', 'QINIU_NUM', '0', '七牛文件存储空间数量', '12', '', '', '1516267427', '1516606768', '1', '2', '2');
INSERT INTO `wp_config` VALUES ('83', 'QINIU_FILE2', '3', '七牛文件存储空间2', '12', '', '', '1516267531', '1516606758', '1', 'accessKey:\r\nsecretKey:\r\nbuket:wangpan-file2\r\ndomain:xz.qqqpan.com', '4');
INSERT INTO `wp_config` VALUES ('84', 'ALIPAY_appId', '1', '支付宝appid', '7', '', '', '1516627941', '1516628147', '1', '', '1');
INSERT INTO `wp_config` VALUES ('85', 'ALIPAY_rsaPrivateKey', '2', '支付宝私钥', '7', '', '', '1516628053', '1516628155', '1', '7PL2LNdAPLNSxcZA6KgOGFtGbYWf7Ft2M5lAwWpAqU1JzKmattMcYNHmOifugPK1hnitM4IxOop39hJMYH6ikQo8qVBtmBE/F3L1HB26ooYPE5hHLIciRilNZtSS8YwF9/afFC6Txah4YCB+uqS5+EZah5WhR+ZSYot10eaXXtdO6Fa6wlOpAc34GlYBpGSrEIHTa4E7UObq7VEH7tFukz+AQVxDv838jxTXqsyAOoZ7Z/c64OoSC3+DkwoU38G4PDl3/atT/Lj1RYK74ZGQIDAQABAoIBAFVv7iwdRSLclwuIMK5A12UsK7Xp3Za9gwtMcFBwGzxf4gJ94bqPVXnfMVqDtc0KosNIOadKb6cqe7M3TEhLRHVQ9CCsupZ4g2Pi8iamVi71mUoQLgdI2tWetXaDi/uf4ILUg8WvxA3TaX8XH3duVAATNoBOq8qWrvdrdLAut1lmMg9jIj9J28jye2WnoZo+GYWGZmOJZHF7CXb/hPLNbmWVpcOch3IlbkliX/9RYjIj4bD6WeKQhuYaoWjqNxJN3iNtznvjRicdC3eg3ipGMjG9SgBuniZ+iTeEoEBmV3RlVU8zHSKKRJLL63Eizmhrpqe1mFcVucl0pcZsLxfdz9ECgYEA0dWtG58uqtQQaa1A9A6ZTHKZ4lcEUbZ0oTMwb5SxAcRIUisohXWy929eaB477wgnIHW8Ot6ybPaIlHfaQxGGyC4+f3vE3Irc/7UcEd/7Su1GR8ENdMzzTFfReHLppPU1xsUeol1NQbZdeCBbrHtfxD0QIfsNJdov3QtUvA4aii0CgYEAzJHNzlD95lJ2pmQ06DrXJbATw6av41qiKtIbejjixztj9TfiJFZ6p2e6DL3ypZcQKye4Vk3BlXDPz3Wd9GBPB4TqitNWt/e8M5RGN1z50C0XF4Ap9yJRMZW2qcOxh24/TmR8Rx1b6JOT+Dl0gczwn/dxG9RRw/T2l8dgsQ1Peh0CgYEAxGjdwB0f8YbOVhx1z/xaQdSDdfk9cb73LGxdyhPEG4M+rqr3IvUor7LvC0ZBk1xuQ1Pw/Km3GYcqEM6e3mhpYLboiSuw+T6B3lgIDjM5ZMj0H/X0QoAUvED3MWdei6l6zLN2GUR8LCYnF2oyZSCWY3lEwIndpLC2XJFenygUb4ECgYEAjrsUW2VLIY5b1pCIEZgsUNFfmN0OT5UHHNVn8okKQXQAtDF/iVcFURQgTY+iY0LZNyMJjL3H2ZrSg69OvBkOSvLEKoR2NvmUyHAl5a7rZgJv4Ce+H/5DpFMPFbfCf/m+FdYql/u2CrodPc3oqj/xi8s7ke0793tNKm0j26Sr1UkCgYEAjiGAB30C7GL5wzJGttrl6B4z98JTpGZuedbQbkXZ1JwLomi7Yq3UdAAYgSNGFrTn8DW8MDma3m1pbu3QbuInWSRngbzS08CioNmfRRInj36sPhDRE5lbzpH2rVJny5kT2V9sZauFq6v1tnn+nQW5xLDWPV/9Lr09fYdSuOzKqck=', '2');
INSERT INTO `wp_config` VALUES ('86', 'ALIPAY_alipayrsaPublicKey', '2', '支付宝公钥', '7', '', '', '1516628090', '1516628161', '1', 'qhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAjeeenKrBQeCQfmkaXZTr6uI/Zp03kr1cxX+2CpPDbeMictKOcM3Dbi2TmhF0kxWkAxF1/46tYvt1xLnM6MA8w28pVBvcoy0HKs6nywDr0Dm4trrwdXeacxREJTSzGvz2en/WFN2ORQ2Knkxw3W834EEOR4aKqFi7WovlqbW+hHP3IpZ2DcG412Mbt/lNzuXKlkx6Ey4FFdojTSZ/kVMeBvkmD2y1dCBdc7MiEtXLLTcweewExX9EbPELD0KVNjdvYaqLRU6C7peeFfbOBxl/XcQIQFn+Lambl08BEsJQRoHOkayT5QAJITKrK6U/QLyPG+Rve8a53Mw3nfPHVyeLqQIDAQAB', '3');
INSERT INTO `wp_config` VALUES ('87', 'EMAIL_HOST', '1', '发件箱主机', '11', '', 'smtp地址', '1517386992', '1517387014', '1', 'ssl://smtp.exmail.qq.com', '0');
INSERT INTO `wp_config` VALUES ('89', 'FUFEI_WANGPAN', '1', '付费网盘二级域名', '2', '', '付费网盘二级域名设置', '1517453059', '1517627824', '1', '106pan.com', '5');
INSERT INTO `wp_config` VALUES ('90', 'SMS_ALIYUN', '3', '阿里云Access Key', '9', '', '聚合短信支付接口', '1517453492', '1517498569', '1', 'accessKeyId:\r\naccessKeySecret:', '1');
INSERT INTO `wp_config` VALUES ('91', 'WEIXIN-CHENGGONG', '1', '提现成功通知', '10', '', '微信提现成功消息通知', '1517453583', '1529897276', '1', '1-jtwwU3u6IlPpFFXeQsU8bTsO4iYbxRiYRZ9yOb_qY', '6');
INSERT INTO `wp_config` VALUES ('92', 'WEIXIN-DENGLU', '1', '用户登录提醒', '10', '', '微信用户登录提醒', '1517453632', '1529897294', '1', 'dESF4v_gqo6BQz9t19dYxyoFS45PeLOyqnvcWq6KUF0', '7');
INSERT INTO `wp_config` VALUES ('93', 'WEIXIN-SHIBAI', '1', '提现失败提醒', '10', '', '微信提现失败提醒', '1517453674', '1521518428', '1', 'jHU3s7_6Ru_beJqAJdzVxWQczCDmkBSjA-zf0EZXtfw', '8');
INSERT INTO `wp_config` VALUES ('94', 'WEIXIN-SHOUKUAN', '1', '收款成功通知', '10', '', '微信收款成功通知', '1517453722', '1529897254', '1', 'qYoBSaJNiCY6Yl-mQDajBw7pgTY6FT5cmSbywyMFll0', '9');
INSERT INTO `wp_config` VALUES ('95', 'SMS_TPL_REG', '1', '注册验证码模板', '9', '', '', '1517498644', '1517498644', '1', 'SMS_123798973', '0');
INSERT INTO `wp_config` VALUES ('96', 'SMS_SIGN', '1', '短信签名', '9', '', '', '1517498681', '1517503845', '1', '106云盘', '2');
INSERT INTO `wp_config` VALUES ('97', 'YONGHUZHUCEXIEYI', '2', '用户注册协议', '6', '', '', '1517502640', '1525676655', '1', '<h1 align=\"center\">106云盘服务条款</h1>\r\n<br>\r\n<h3>1. 特别提示</h3><br>\r\n106云盘是扎兰屯市姝妍计算机服务有限公司旗下产品（称：网盘、云盘）、106云盘是面向所有注册用户，提供数据的同步、备份、分享、下载、页面展示等功能并帮助协同办公的个人以及企业云存储服务。“便捷安全”是106云盘的服务宗旨。请您仔细阅读106云盘服务条款（下称“本条款”），如果您同意本条款，那么您可以注册成为106云盘的用户（下称“用户”），使用106云盘提供给您的服务；如果您不同意本条款，那么请您立即停止使用106云盘。本条款适用于任何106云盘提供的服务。\r\n<h3>2. 注册</h3><br>\r\n用户通过106云盘的注册程序点击“注册”后，则表示用户与106云盘双方接受本条款且完成注册，成为106云盘的用户。如果访客不同意本条款或不填写相关资料，则不能完成注册，无法成为106云盘的用户。<br>\r\n如果用户提供的注册资料不准确，不真实，不合法，106云盘有权终止向该用户提供服务，并有权注销其帐号。因此产生的一切损失由用户自行承担。\r\n<h3>3. 帐号和密码</h3><br>\r\n如果访客注册成功，则拥有106云盘的一个用户帐号及相应密码。用户应妥善保管帐号和密码，106云盘不对用户帐号和密码的保管承担任何责任。\r\n用户有权随时更改密码，若发现任何安全漏洞或非法使用用户帐号的情况，应当立即通知106云盘。若用户非法访问其他用户帐号，则承担一切因此产生的法律后果。<br>\r\n用户同意在未经授权的情况下，不得使用其他成员的帐户、用户名或密码，由此产生的一切损失由该用户自行承担。<br>\r\n用户需保证注册的106云盘账户为合法和可达的邮箱以及合法到达的手机短信，用户授权106云盘运营方向用户邮箱或手机发送和106云盘服务相关的信息和通知。<br>\r\n<h3>4. 使用规则</h3><br>\r\n用户在使用106云盘时，应当遵守相关的法律规则，包括但不限于《中华人民共和国宪法》、《中华人民共和国刑法》、《中华人民共和国民法通则》、《中华人民共和国合同法》、《中华人民共和国著作权法》、《中华人民共和国电信条例》、《互联网信息服务管理办法》、《互联网电子公告服务管理规定》、《中华人民共和国保守国家秘密法》、《中华人民共和国计算机信息系统安全保护条例》、《计算机信息网络国际联网安全保护管理办法》、《全国人民代表大会常务委员会关于维护互联网安全的决定》及其相关的司法解释。<br>\r\n用户在使用106云盘的过程中，必须遵循以下原则：<br>\r\n(1)遵守所有与本网络服务有关的网络协议、规定和程序；<br>\r\n(2)不得利用106云盘进行任何可能对互联网的正常运转造成不利影响的行为；<br>\r\n(3)不得利用106云盘进行任何不利于106云盘的行为。<br>\r\n(4)不得利用106云盘传输任何骚扰性的、中伤他人的、辱骂性的、恐吓性的、庸俗淫秽的或其他任何非法的信息资料。<br>\r\n(5)不得试图利用技术或非技术手段, 未经106云盘授权, 访问106云盘中其他用户账号中的信息资料.<br>\r\n(6)不得上传抵制反动、暴力、色情、违法及侵权内容的文件，发现将立即停止网盘使用情节严重会交给有关部门进行处理。<br>\r\n106云盘仅提供与云存储相关的网络服务，除此之外与网络服务有关的设备（包括但不限于个人电脑、手机、及其他与接入互联网或移动网有关的装置）及所需要的费用（包括但不限于为接入互联网而支付的电话费及上网费、为使用移动网而支付的手机费）均应由用户自行承担。<br>\r\n如用户在使用过程中注册资料发生变更，则用户应当及时更新准确的、详细的注册资料。<br>\r\n用户应当对以其用户帐号进行的任何行为承担法律责任，包括但不限于用户上传或散播文本、音频、视频、图片、软件或其它资料，以及本人或他人利用其帐号和密码所进行的一切行为。如因用户未保管好其帐号和密码而给106云盘、第三方造成损失，用户应当赔偿106云盘和第三方因此造成的一切损失，并消除影响。<br>\r\n用户理解并同意在使用106云盘提供的各项服务时，接受106云盘和第三方提供的各类信息服务。用户理解在使用106云盘提供的服务时可能有来自第三方的非法内容，包括但不限于威胁、诽谤，用户同意自行承担前述风险。<br>\r\n为了合理地保护未成年人的身心健康、远离有害信息，如用户是未成年人，则须在监护人的指导与监督下使用106云盘及接受106云盘的服务，否则请立即停止注册或终止使用106云盘。<br>\r\n<h3>5. 服务变更、中断或终止</h3><br>\r\n由于106云盘网络服务的特殊性，用户同意106云盘有权随时变更、中断或终止部分或全部的网络服务。如变更、中断或终止的网络服务属于免费服务项目，106云盘无需提前通知用户，也无需对任何用户或任何第三方承担任何责任。如系付费服务项目，则须提前一个月通知用户，并协商解决任何已付未使用或未付款项的事宜。一旦服务取消或终止，用户使用本服务的权利立即终止，且在本服务中储存的任何信息可能无法恢复。<br>\r\n106云盘需要定期或不定期地对提供网络服务的平台或相关的设备进行检修或者维护，如因此类情况而造成免费网络服务中断，106云盘无需为此承担任何责任。 如收费服务在合理时间内中断, 106云盘无须为此承担任何责任,  但应尽可能事先进行通告。<br>\r\n106云盘对于因为自然灾害, 其他信息服务商故障，相关信息设备和软件故障， 或者任何不可阻挡因素导致服务中断或终止， 不承担任何责任， 但应尽可能减少该因素对用户的影响。<br>\r\n对于其他任何非上述因素导致的用户服务中断或终止， 对于免费服务， 106云盘不承担任何责任。 对于付费服务， 106云盘可以在平等协商公平的原则下， 在不超过用户总付费金额的前提下, 进行赔偿解决。 如果用户采取按月付费的模式， 总赔偿金额不得超过服务中断和终止当月付费金额。 如果用户采取年付费的模式，总赔偿金额不得超过服务中断和终止当年付费金额。<br>\r\n为避免服务器资源浪费，如免费用户超过三个月未登录使用106云盘服务，106云盘保留在未经通知的情况下终止该用户的免费服务，并删除该用户在服务器上保存的数据的权利。但106云盘在行使该权利前，应尽可能的通知用户以减少该权利行使对用户的影响。<br>\r\n为避免服务器资源浪费，付费用户如果超过三个月未及时续费或者转化为免费服务，106云盘保留在未经通知的情况下终止该用户的付费服务，并删除该用户在服务器上保存的数据的权利。但106云盘在行使该权利前，应尽可能的通知用户以减少该权利行使对用户的影响。<br>\r\n<h3>6. 禁止行为</h3><br>\r\n用户不得利用106云盘以任何方式传播敏感信息和违反国家法律、政策的信息，包括但不限于下列信息：<br>\r\n(1)反对宪法确定的基本原则的；<br>\r\n(2)危害国家统一、主权和领土完整的；<br>\r\n(3)泄露国家秘密、危害国家安全或者损害国家荣誉和利益的；<br>\r\n(4)煽动民族仇恨、民族歧视，破坏民族团结，或者侵害民族风俗、习惯的；<br>\r\n(5)宣扬邪教、迷信的；<br>\r\n(6)散布谣言，扰乱社会秩序，破坏社会稳定的；<br>\r\n(7)宣扬淫秽、赌博、暴力或者教唆犯罪的；<br>\r\n(8)侮辱或者诽谤他人，侵害他人合法权益的；<br>\r\n(9)危害社会公德或者民族优秀文化传统的；<br>\r\n(10)有法律、行政法规和国家规定禁止的其他内容的。<br>\r\n<h3>7. 费用</h3><br>\r\n除106云盘明确规定收费的服务项目外，106云盘是免费注册、使用的。<br>\r\n用户理解并同意106云盘有权根据实际的需要对某些目前免费的服务项目收取合理的服务费，如用户不同意106云盘收取此项目费用，则用户有权退出使用该项服务或终止使用106云盘。<br>\r\n用户理解并同意106云盘对新增服务项目有权决定是否收费，用户有权选择接受或拒绝该项目服务。<br>\r\n如用户接受106云盘的收费项目，则用户应当按106云盘的收费规定支付费用；如用户未支付费用或欠费，则106云盘有权不向用户提供此项服务或停止向用户提供此项服务。106云盘有权根据实际需要调整收费项目的资费,用户有权选择接受或拒绝使用。<br>\r\n<h3>8. 隐私保护</h3><br>\r\n保护用户隐私是106云盘的一项基本政策，106云盘保证不会公开或向第三方提供单个用户的注册资料以及用户在使用网络服务时存储在106云盘 中的非公开内容，除非有下列情况出现：<br>\r\n(1)有关法律规定或106云盘合法服务程序规定；<br>\r\n(2)在紧急情况下，为维护用户及公众的权益；<br>\r\n(3)为维护106云盘的商标权、专利权及其他任何合法权益；<br>\r\n(4)其他依法需要公开、编辑或透露个人信息的情况。<br>\r\n<h3>9. 知识产权</h3><br>\r\n用户和106云盘双方理解并同意106云盘为向用户提供服务而开发或从第三方合法获得的技术成果或方案的全部知识产权，包括但不限于，商标、商号、以及106云盘的平台、版面设计均归106云盘或该第三方所有。未经106云盘许可，用户不得以任何形式对前述知识产权或其任何部分进行使用、修改等。<br>\r\n除上述规定外，用户在106云盘中储存的任何作品，包括但不限于，图片、音乐、视频的知识产权归用户所有（“用户作品”）或第三方所有（“第三方作品”）。用户保证对前述用户作品享有完全知识产权；如系第三方作品，用户应当获得第三方的许可或未获得第三方许可但有权合法使用第三方作品。<br>\r\n除法律法规另有规定外，未获得第三方作品所有人的事先许可，用户不得以任何方式使用第三方作品。如果106云盘收到任何第三方作品所有人或其合法代表发给106云盘的合理通知后，106云盘有权移除相应侵权作品；用户也有权对前述侵权指控提出反通知。<br>\r\n<h3>10. 知识产权侵权</h3><br>\r\n用户保证，在106云盘中储存的用户作品或第三方作品不侵犯任何第三方知识产权，包括但不限于商标权、版权和商业秘密。<br>\r\n若用户在106云盘中储存的用户作品或第三方作品导致第三方主张前述作品侵犯其知识产权，用户应当负责处理前述第三方的权利主张，承担由此招致的全部费用，包括但不限于律师费和侵权赔偿，并保证106云盘不会因此而遭受任何损失。用户同意，若发生上述侵权行为，106云盘有权移除上述侵权作品。<br>\r\n<h3>11. 免责和不保证</h3><br>\r\n在适用法允许的最大范围内，106云盘在任何情况下不对用户因使用或不能使用106云盘提供的服务所发生的特殊的、意外的、直接或间接的损失承担任何责任。<br>\r\n106云盘不对提供的服务作任何明示或暗示的保证，包括但不限于不保证106云盘提供的服务一定能满足用户的要求，也不保证服务是否会中断、及时性、安全性。<br>\r\n<h3>12. 违约责任</h3><br>\r\n用户因违反国家法律法规或本条款的约定而给106云盘造成损失的，用户应赔偿106云盘因此而造成的一切损失，并消除影响。<br>\r\n<h3>13. 不可抗力</h3><br>\r\n由于不可抗力事件，致使用户不能使用106云盘提供的服务时，106云盘不对用户的任何损失承担责任。不可抗力事件包括但不限于（1）自然灾害、如台风、洪水、冰雹；（2）政府行为，如征收、征用；（3）社会异常事件，如罢工、骚乱；（4） 计算机病毒或黑客攻击、互联网络、通信线路等原因造成服务中断。<br>\r\n<h3>14. 生效和期限</h3><br>\r\n本条款自用户点击注册程序中的“我接受”时开始生效。用户注销其用户名或106云盘终止您的用户资格时，用户使用权利终止。此后，第9、10、11、12、15和16条继续有效。<br>\r\n<h3>15. 法律适用和争议解决</h3><br>\r\n本条款应受中华人民共和国法律解释和管辖，并不考虑法律冲突。<br>\r\n有关本条款的任何争议应由双方秉承善意友好协商解决。若三十日内协商不成，双方同意将争议提交仲裁委员会依据其当时有效的仲裁规则仲裁解决。仲裁裁决是终局的，对双方均有法律约束力。除非仲裁裁决另有规定，仲裁费用应由仲裁败诉方承担。<br>\r\n<h3>16. 一般条款</h3><br>\r\n用户和106云盘在履行本条款的过程中，应遵从所有适用的法律。<br>\r\n106云盘有权通过在106云盘上发布通知或发送电子邮件等方式向用户发送通知、广告等。<br>\r\n本条款所载任何内容不应被解释为在用户和106云盘之间创设合资、合伙、代理或任何其它本条款目的以外的关系。<br>\r\n\r\n用户理解并同意106云盘有权根据实际需要修改本条款。如果您不同意变更，则用户有权退出106云盘，终止服务关系；如用户继续使用106云盘提供的服务，则表示用户同意本条款的修改。<br>\r\n若本条款中部分条款因任何原因而被认定无效，此种无效条款并不影响其他条款的有效性，且此种无效条款应自始视为不存在。\r\n106云盘有权转让其在本条款下的任何权利或义务。<br>\r\n本条款中所有标题仅为方便阅读所设置，并不影响本条款任何部分的含义或解释。<br>', '0');
INSERT INTO `wp_config` VALUES ('98', 'SMS_TPL_FILE', '1', '文件提取码模板', '9', '', '', '1517503065', '1517503807', '1', 'SMS_123674142', '0');
INSERT INTO `wp_config` VALUES ('101', 'SMS_TPL_FINDPWD', '1', '忘记密码模板', '9', '', '', '1517504263', '1517504802', '1', 'SMS_123669140', '0');
INSERT INTO `wp_config` VALUES ('102', 'ZHUCEYOUJIAN', '2', '绑定邮箱模板', '11', '', '注册会员发送邮件内容', '1517506435', '1517983675', '1', '<h3>106云盘邮箱绑定验证码</h3>\r\n<p> </p>\r\n<h2>验证码：<span style=\"color:#ff0000;\">{code}</span></h2>\r\n<p><span style=\"color:#ff0000;\"><br />\r\n</span></p>\r\n<p>官方网址：<a href=\"http://www.106pan.com\" target=\"_blank\">http://www.106pan.com</a></p>\r\n<p> </p>\r\n<p>会员中心：<a href=\"http://member.106pan.com/member/email\" target=\"_blank\">点击进入</a></p>\r\n<p><span style=\"color:#ff0000;\"><br />\r\n</span></p>', '3');
INSERT INTO `wp_config` VALUES ('103', 'ZHAOHUIMIMYOUJIAN', '2', '找回密码模板', '11', '', '找回密码发信邮件', '1517506472', '1517983661', '1', '<h3>106云盘您的新密码为：</h3>\r\n<p> </p>\r\n<h2>新密码：<span style=\"color:#ff0000;\">{password}</span></h2>\r\n<p> </p>\r\n<p>进入会员中心进行修改：<a href=\"http://member.106pan.com/member/safe\" target=\"_blank\">http://member.106pan.com/member/safe</a>  <a href=\"http://member.106pan.com/member/email\" target=\"_blank\">点击进入</a>修改密码</p>\r\n<p> </p>\r\n<p><span style=\"line-height:19.6px;\">官方网址：</span><a href=\"http://www.106pan.com\" target=\"_blank\">http://www.106pan.com</a></p>', '4');
INSERT INTO `wp_config` VALUES ('104', 'TIQUMAFAJIAN', '2', '文件提取码模板', '11', '', '提取码发送邮箱', '1517506537', '1517983645', '1', '<h3>亲爱的用户您好：</h3>\r\n<h3>购买商品名为：<span style=\"color:#3300ff;\">{softname}</span></h3>\r\n<h3>软件订单号为：<span style=\"color:#3300ff;\">{orderno}</span></h3>\r\n<h3>软件提取码为：<span style=\"color:#ff0000;\">{code}</span></h3>\r\n<h3>提取码有效为：<span style=\"color:#3300ff;\">{youxiaoqi}</span></h3>\r\n<h3>成功支付时间：<span style=\"color:#3300ff;\">{shijian}</span></h3>\r\n<hr />\r\n<h2><span style=\"color:#FF0000;\">产品（卡密）：</span></h2>\r\n<h3><span style=\"color:#3300ff;\">{kami}</span></h3>\r\n<hr />\r\n<h3>感谢您在106云盘购买客户产品，如果发现上当受骗可以在交易的第二天早8点前联系官方客服人员为您处理相关订单</h3>\r\n<h3>如果卖家附赠产品错误或无法使用（虚假）请联系卖家进行协商，本站只对购买的软件保证正确性以及可使用性。</h3>\r\n<h3>106云盘官方网址：<a href=\"http://www.106pan.com\" target=\"_blank\">http://www.106pan.com</a></h3>', '5');
INSERT INTO `wp_config` VALUES ('106', 'KEFU_MEMBER', '2', '会员客户中心', '4', '', '', '1517563925', '1525569488', '1', '<p><a href=\"tencent://message/?uin=244656508\"><img src=\"/static/uhome/images/qq-qq.png\" border=\"0\"></a> \r\n<a href=\"tencent://message/?uin=351075088\"><img src=\"/static/uhome/images/qq-qq.png\" border=\"0\"></a> \r\n<a target=\"_blank\" href=\"//shang.qq.com/wpa/qunwpa?idkey=0b3246ac2dfbed50f309087756868887d357464e414bc3b4f6bd1bbf1422a0ed\"><img border=\"0\" src=\"//pub.idqqimg.com/wpa/images/group.png\" alt=\"106云盘1群\" title=\"106云盘1群\"></a></p>\r\n\r\n<p>每天上午8点至下午16点申请提现2小时内到账，其他时间段申请提现资金部分时间会等到早8点结算</p>\r\n', '4');
INSERT INTO `wp_config` VALUES ('107', 'TIQUMA_OUTTIME', '0', '提取码过期时间', '12', '', '天数', '1517581865', '1525469205', '1', '1', '0');
INSERT INTO `wp_config` VALUES ('108', 'SMS_TPL_BIND', '1', '绑定手机短信模板', '9', '', '', '1517593934', '1517593934', '1', 'SMS_123798973', '0');
INSERT INTO `wp_config` VALUES ('109', 'MONEY_JIESUANZHOUQI', '0', '结算周期', '13', '', 'T+1 就写1', '1517729402', '1521088790', '1', '1', '9');
INSERT INTO `wp_config` VALUES ('110', 'ALIPAY_RATE', '0', '支付宝费率', '7', '', '', '1517737257', '1531794286', '0', '0.006', '0');
INSERT INTO `wp_config` VALUES ('111', 'OPENFILE', '3', '直连文件格式', '12', '', '', '1518426977', '1518426990', '1', 'image/png\r\nimage/gif\r\nimage/jpeg\r\ntext/plain', '0');
INSERT INTO `wp_config` VALUES ('112', 'SCORE_REG', '0', '注册积分', '1', '', '成功邀请注册送多少积分', '1518452601', '1525513153', '1', '1', '6');
INSERT INTO `wp_config` VALUES ('113', 'WX_APPID', '1', '微信APPID', '10', '', '', '1519346533', '1519346533', '1', '', '1');
INSERT INTO `wp_config` VALUES ('114', 'WX_APPSECRET', '1', '微信APPSECRET', '10', '', '', '1519346579', '1519346579', '1', '', '2');
INSERT INTO `wp_config` VALUES ('115', 'WX_TOKEN', '1', '微信TOKEN', '10', '', '', '1519346761', '1519346761', '1', '', '3');
INSERT INTO `wp_config` VALUES ('116', 'WEIXIN-KUCHUN', '1', '库存预警通知', '10', '', '库存不足通知', '1520727239', '1521525116', '1', 'AOqjV2L3wv4niSZd9OrPY0MZO5EYgjmtsqFKUGm3ISM', '10');
INSERT INTO `wp_config` VALUES ('117', 'TIXIANFEILV', '0', '提现费率', '13', '', '提现费率按%计算', '1521088760', '1521088842', '1', '0', '10');
INSERT INTO `wp_config` VALUES ('118', 'WEIXIN-GAOJING', '1', '流量告警', '10', '', '', '1521525904', '1521525904', '1', 'VqnB41YWWckZ7QGv5EYI78Ph7bBeDppwELGyoe0hMMw', '11');
INSERT INTO `wp_config` VALUES ('119', 'QINIU_TU', '3', '七牛用户图片存储', '12', '', '', '1521819404', '1521820142', '1', 'accessKey:\r\nsecretKey:\r\nbuket:tupian\r\ndomain:tu.a8tg.com', '0');
INSERT INTO `wp_config` VALUES ('120', 'WXPAY_RATE', '0', '微信支付费率', '7', '', '', '1522033344', '1531794258', '0', '0.006', '0');
INSERT INTO `wp_config` VALUES ('121', 'FILE_ZHIFUTONGDAO', '3', '文件购买支付通道', '7', '', '', '1522651666', '1531794228', '0', 'alipay:支付宝\r\nwxpay:微信', '0');
INSERT INTO `wp_config` VALUES ('122', 'WEB_SITE_MINGCHENG', '2', '网盘名称', '1', '', 'QQ宣传广告显示标题', '1525511804', '1525511804', '1', '106云盘-网盘文件共享-数据储存-免费网络硬盘-付费文件下载-网赚网盘', '4');
INSERT INTO `wp_config` VALUES ('123', 'BEN_BZUSR', '1', '本站域名', '2', '', '本站域名不要带http://www ，请输入 顶级域名 如  106pan.com', '1525512006', '1525512039', '1', 'www.106pan.com', '0');
INSERT INTO `wp_config` VALUES ('124', 'WEB_SITE_ZZICP', '1', '增值业务许可证', '1', '', '电信增值业务许可证', '1525512486', '1525512486', '1', '', '8');
INSERT INTO `wp_config` VALUES ('127', 'WEB_ZDBT_ZNXC', '1', '网站标题', '1', '', '网站标题，如：106网盘 ', '1525514299', '1525514308', '1', '106网盘', '0');
INSERT INTO `wp_config` VALUES ('128', 'EMAILKEFU', '0', '客服邮箱', '1', '', '客服邮箱', '1525514680', '1525515374', '1', '', '5');
INSERT INTO `wp_config` VALUES ('129', 'KEFUQQ_02', '0', '投诉客服', '4', '', '投诉客服', '1525514907', '1525659909', '1', '', '2');
INSERT INTO `wp_config` VALUES ('130', 'KEFUQQ_03', '0', '财务客服', '4', '', '财务客服', '1525514932', '1525659897', '1', '', '3');
INSERT INTO `wp_config` VALUES ('131', 'COPYRIGHTDIZHI', '1', '公司地址', '1', '', '公司地址', '1525515822', '1525515822', '1', '', '6');
INSERT INTO `wp_config` VALUES ('132', 'BAIDU_DITU', '0', '百度地图地址', '1', '', '百度地图地址', '1525515938', '1525515938', '1', '', '9');
INSERT INTO `wp_config` VALUES ('133', 'WEB_TJDM', '2', '统计代码（首页）', '1', '', '首页统计代码', '1525571875', '1525574763', '1', '<script src=\"https://s19.cnzz.com/z_stat.php?id=1272896447&web_id=1272896447\" language=\"JavaScript\"></script>', '20');
INSERT INTO `wp_config` VALUES ('134', 'WEB_TJDM_DM1', '2', '统计代码（下载）', '1', '', '下载页面统计代码', '1525572001', '1525574756', '1', '<script src=\"https://s19.cnzz.com/z_stat.php?id=1272896447&web_id=1272896447\" language=\"JavaScript\"></script>	', '22');
INSERT INTO `wp_config` VALUES ('135', 'WEB_ZDYDM_DM', '2', '自定义代码', '1', '', '自定义代码', '1525572077', '1525572077', '1', ' <a target=\"_blank\" href=\"http://www.beian.gov.cn/portal/registerSystemInfo?recordcode=15078302000155\" style=\"display:inline-block;text-decoration:none;height:20px;line-height:20px;\"><img src=\"/static/home/images/beian.png\" style=\"float:left;\"/>\r\n<p style=\"float:left;height:20px;line-height:20px;margin: 0px 0px 0px 5px; color:#939393;\">蒙公网安备 15078302000155号</p> </a>\r\n<a target=\"_blank\" href=\"http://www.beian.gov.cn/portal/registerSystemInfo?recordcode=15078302000156\" style=\"display:inline-block;text-decoration:none;height:20px;line-height:20px;\"><img src=\"/static/home/images/beian.png\" style=\"float:left;\"/>\r\n<p style=\"float:left;height:20px;line-height:20px;margin: 0px 0px 0px 5px; color:#939393;\">蒙公网安备 15078302000156号</p></a>\r\n				<br><br>\r\n				\r\n<!--可信网站图片LOGO安装开始-->\r\n<script src=\"http://kxlogo.knet.cn/seallogo.dll?sn=e18032711010672662vj4x000000&size=0\"></script>\r\n<!--可信网站图片LOGO安装结束-->\r\n\r\n<a target=\"_blank\" href=\"https://v.pinpaibao.com.cn/cert/site/?site=www.106pan.com&at=business\" ><img src=\"http://jt.qqqpan.com/static/home/images/hy_124x47.png\" width=\"124\" height=\"47\" border=\"0\"></img></a><a target=\"_blank\" href=\"http://www.cn-ecusc.org.cn/cert/aqkx/site/?site=www.106pan.com\" ><img src=\"/static/home/images/kxwz.png\" width=\"124\" height=\"47\" border=\"0\"></a>', '23');
INSERT INTO `wp_config` VALUES ('136', 'WEB_MF_FJDM', '2', '免费网盘附加代码', '3', '', '免费网盘附加内容', '1525589412', '1525589412', '1', '<a href=\"http://www.106pan.com\" target=\"_blank\">106网盘</a>© 版权：扎兰屯市姝妍计算机服务有限    网址：<a href=\"http://www.106pan.com\" target=\"_blank\">http://www.106pan.com </a>  \r\n<script src=\"https://s19.cnzz.com/z_stat.php?id=1272896447&web_id=1272896447\" language=\"JavaScript\"></script> \r\n    <a href=\"http://member.106pan.com/\" target=\"_blank\">登录</a>     |     <a href=\"http://member.106pan.com/reg\" target=\"_blank\">注册</a>', '4');
INSERT INTO `wp_config` VALUES ('137', 'KEFUQQ_04', '0', '广告客服', '1', '', '广告添加客服QQ', '1525659945', '1525659945', '1', '', '5');
INSERT INTO `wp_config` VALUES ('138', 'WEB_DJYM_RJ', '2', '软件冻结页面', '6', '', '软件冻结页面', '1525677382', '1525679874', '1', '<div class=\"demo\">\r\n	<p><span>该</span><span>文</span><span>件</span><span>被</span><span>限</span><span>制</span><span>下</span><span>载</span><span>及</span><span>转</span><span>载</span></p>\r\n   <br> <br> <br>\r\n   <p>该文件违国家有关条款已被106网盘禁止下载以及转载</p>\r\n <br><br><br>\r\n<h2> 特别提示</h2><br>\r\n106云盘是扎兰屯市姝妍计算机服务有限公司旗下产品（称：网盘、云盘）、106云盘是面向所有注册用户，提供数据的同步、备份、分享、下载、页面展示等功能并帮助协同办公的个人以及企业云存储服务。“便捷安全”是106云盘的服务宗旨。请您仔细阅读106云盘服务条款（下称“本条款”），如果您同意本条款，那么您可以注册成为106云盘的用户（下称“用户”），使用106云盘提供给您的服务；如果您不同意本条款，那么请您立即停止使用106云盘。本条款适用于任何106云盘提供的服务。\r\n<br>\r\n用户在使用106云盘时，应当遵守相关的法律规则，包括但不限于《中华人民共和国宪法》、《中华人民共和国刑法》、《中华人民共和国民法通则》、《中华人民共和国合同法》、《中华人民共和国著作权法》、《中华人民共和国电信条例》、《互联网信息服务管理办法》、《互联网电子公告服务管理规定》、《中华人民共和国保守国家秘密法》、《中华人民共和国计算机信息系统安全保护条例》、《计算机信息网络国际联网安全保护管理办法》、《全国人民代表大会常务委员会关于维护互联网安全的决定》及其相关的司法解释。<br>\r\n用户在使用106云盘的过程中，必须遵循以下原则：<br>\r\n(1)遵守所有与本网络服务有关的网络协议、规定和程序；<br>\r\n(2)不得利用106云盘进行任何可能对互联网的正常运转造成不利影响的行为；<br>\r\n(3)不得利用106云盘进行任何不利于106云盘的行为。<br>\r\n(4)不得利用106云盘传输任何骚扰性的、中伤他人的、辱骂性的、恐吓性的、庸俗淫秽的或其他任何非法的信息资料。<br>\r\n(5)不得试图利用技术或非技术手段, 未经106云盘授权, 访问106云盘中其他用户账号中的信息资料.<br>\r\n(6)不得上传抵制反动、暴力、色情、违法及侵权内容的文件，发现将立即停止网盘使用情节严重会交给有关部门进行处理。<br>\r\n106云盘仅提供与云存储相关的网络服务，除此之外与网络服务有关的设备（包括但不限于个人电脑、手机、及其他与接入互联网或移动网有关的装置）及所需要的费用（包括但不限于为接入互联网而支付的电话费及上网费、为使用移动网而支付的手机费）均应由用户自行承担。<br>\r\n如用户在使用过程中注册资料发生变更，则用户应当及时更新准确的、详细的注册资料。<br>\r\n用户应当对以其用户帐号进行的任何行为承担法律责任，包括但不限于用户上传或散播文本、音频、视频、图片、软件或其它资料，以及本人或他人利用其帐号和密码所进行的一切行为。如因用户未保管好其帐号和密码而给106云盘、第三方造成损失，用户应当赔偿106云盘和第三方因此造成的一切损失，并消除影响。<br>\r\n用户理解并同意在使用106云盘提供的各项服务时，接受106云盘和第三方提供的各类信息服务。用户理解在使用106云盘提供的服务时可能有来自第三方的非法内容，包括但不限于威胁、诽谤，用户同意自行承担前述风险。<br>\r\n为了合理地保护未成年人的身心健康、远离有害信息，如用户是未成年人，则须在监护人的指导与监督下使用106云盘及接受106云盘的服务，否则请立即停止注册或终止使用106云盘。<br>\r\n<br>\r\n用户不得利用106云盘以任何方式传播敏感信息和违反国家法律、政策的信息，包括但不限于下列信息：<br>\r\n(1)反对宪法确定的基本原则的；<br>\r\n(2)危害国家统一、主权和领土完整的；<br>\r\n(3)泄露国家秘密、危害国家安全或者损害国家荣誉和利益的；<br>\r\n(4)煽动民族仇恨、民族歧视，破坏民族团结，或者侵害民族风俗、习惯的；<br>\r\n(5)宣扬邪教、迷信的；<br>\r\n(6)散布谣言，扰乱社会秩序，破坏社会稳定的；<br>\r\n(7)宣扬淫秽、赌博、暴力或者教唆犯罪的；<br>\r\n(8)侮辱或者诽谤他人，侵害他人合法权益的；<br>\r\n(9)危害社会公德或者民族优秀文化传统的；<br>\r\n(10)有法律、行政法规和国家规定禁止的其他内容的。<br>\r\n<br>\r\n用户和106云盘双方理解并同意106云盘为向用户提供服务而开发或从第三方合法获得的技术成果或方案的全部知识产权，包括但不限于，商标、商号、以及106云盘的平台、版面设计均归106云盘或该第三方所有。未经106云盘许可，用户不得以任何形式对前述知识产权或其任何部分进行使用、修改等。<br>\r\n除上述规定外，用户在106云盘中储存的任何作品，包括但不限于，图片、音乐、视频的知识产权归用户所有（“用户作品”）或第三方所有（“第三方作品”）。用户保证对前述用户作品享有完全知识产权；如系第三方作品，用户应当获得第三方的许可或未获得第三方许可但有权合法使用第三方作品。<br>\r\n除法律法规另有规定外，未获得第三方作品所有人的事先许可，用户不得以任何方式使用第三方作品。如果106云盘收到任何第三方作品所有人或其合法代表发给106云盘的合理通知后，106云盘有权移除相应侵权作品；用户也有权对前述侵权指控提出反通知。<br>\r\n<br>\r\n用户保证，在106云盘中储存的用户作品或第三方作品不侵犯任何第三方知识产权，包括但不限于商标权、版权和商业秘密。<br>\r\n若用户在106云盘中储存的用户作品或第三方作品导致第三方主张前述作品侵犯其知识产权，用户应当负责处理前述第三方的权利主张，承担由此招致的全部费用，包括但不限于律师费和侵权赔偿，并保证106云盘不会因此而遭受任何损失。用户同意，若发生上述侵权行为，106云盘有权移除上述侵权作品。<br>\r\n', '2');
INSERT INTO `wp_config` VALUES ('139', 'WEB_DJYM_WPAN', '2', '网盘冻结页面', '6', '', '网盘被冻结的页面', '1525679911', '1525680064', '1', '<div class=\"demo\">\r\n	<p><span>您</span><span>访</span><span>问</span><span>的</span><span>盘</span><span>违</span><span>规</span><span>已</span><span>被</span><span>冻</span><span>结</span></p>\r\n   <p>由于该网盘违反106云盘服务协议以及国家有关条款已被冻结，具体详情咨询客服</p>\r\n   \r\n<table width=\"960\" border=\"0\" align=\"center\">\r\n  <tr>\r\n    <td>\r\n	<h1 align=\"center\">106云盘服务条款</h1><br>\r\n<h3>1. 特别提示</h3><br>\r\n106云盘是扎兰屯市姝妍计算机服务有限公司旗下产品（称：网盘、云盘）、106云盘是面向所有注册用户，提供数据的同步、备份、分享、下载、页面展示等功能并帮助协同办公的个人以及企业云存储服务。“便捷安全”是106云盘的服务宗旨。请您仔细阅读106云盘服务条款（下称“本条款”），如果您同意本条款，那么您可以注册成为106云盘的用户（下称“用户”），使用106云盘提供给您的服务；如果您不同意本条款，那么请您立即停止使用106云盘。本条款适用于任何106云盘提供的服务。\r\n<h3>2. 注册</h3><br>\r\n用户通过106云盘的注册程序点击“注册”后，则表示用户与106云盘双方接受本条款且完成注册，成为106云盘的用户。如果访客不同意本条款或不填写相关资料，则不能完成注册，无法成为106云盘的用户。<br>\r\n如果用户提供的注册资料不准确，不真实，不合法，106云盘有权终止向该用户提供服务，并有权注销其帐号。因此产生的一切损失由用户自行承担。\r\n<h3>3. 帐号和密码</h3><br>\r\n如果访客注册成功，则拥有106云盘的一个用户帐号及相应密码。用户应妥善保管帐号和密码，106云盘不对用户帐号和密码的保管承担任何责任。\r\n用户有权随时更改密码，若发现任何安全漏洞或非法使用用户帐号的情况，应当立即通知106云盘。若用户非法访问其他用户帐号，则承担一切因此产生的法律后果。<br>\r\n用户同意在未经授权的情况下，不得使用其他成员的帐户、用户名或密码，由此产生的一切损失由该用户自行承担。<br>\r\n用户需保证注册的106云盘账户为合法和可达的邮箱以及合法到达的手机短信，用户授权106云盘运营方向用户邮箱或手机发送和106云盘服务相关的信息和通知。<br>\r\n<h3>4. 使用规则</h3><br>\r\n用户在使用106云盘时，应当遵守相关的法律规则，包括但不限于《中华人民共和国宪法》、《中华人民共和国刑法》、《中华人民共和国民法通则》、《中华人民共和国合同法》、《中华人民共和国著作权法》、《中华人民共和国电信条例》、《互联网信息服务管理办法》、《互联网电子公告服务管理规定》、《中华人民共和国保守国家秘密法》、《中华人民共和国计算机信息系统安全保护条例》、《计算机信息网络国际联网安全保护管理办法》、《全国人民代表大会常务委员会关于维护互联网安全的决定》及其相关的司法解释。<br>\r\n用户在使用106云盘的过程中，必须遵循以下原则：<br>\r\n(1)遵守所有与本网络服务有关的网络协议、规定和程序；<br>\r\n(2)不得利用106云盘进行任何可能对互联网的正常运转造成不利影响的行为；<br>\r\n(3)不得利用106云盘进行任何不利于106云盘的行为。<br>\r\n(4)不得利用106云盘传输任何骚扰性的、中伤他人的、辱骂性的、恐吓性的、庸俗淫秽的或其他任何非法的信息资料。<br>\r\n(5)不得试图利用技术或非技术手段, 未经106云盘授权, 访问106云盘中其他用户账号中的信息资料.<br>\r\n(6)不得上传抵制反动、暴力、色情、违法及侵权内容的文件，发现将立即停止网盘使用情节严重会交给有关部门进行处理。<br>\r\n106云盘仅提供与云存储相关的网络服务，除此之外与网络服务有关的设备（包括但不限于个人电脑、手机、及其他与接入互联网或移动网有关的装置）及所需要的费用（包括但不限于为接入互联网而支付的电话费及上网费、为使用移动网而支付的手机费）均应由用户自行承担。<br>\r\n如用户在使用过程中注册资料发生变更，则用户应当及时更新准确的、详细的注册资料。<br>\r\n用户应当对以其用户帐号进行的任何行为承担法律责任，包括但不限于用户上传或散播文本、音频、视频、图片、软件或其它资料，以及本人或他人利用其帐号和密码所进行的一切行为。如因用户未保管好其帐号和密码而给106云盘、第三方造成损失，用户应当赔偿106云盘和第三方因此造成的一切损失，并消除影响。<br>\r\n用户理解并同意在使用106云盘提供的各项服务时，接受106云盘和第三方提供的各类信息服务。用户理解在使用106云盘提供的服务时可能有来自第三方的非法内容，包括但不限于威胁、诽谤，用户同意自行承担前述风险。<br>\r\n为了合理地保护未成年人的身心健康、远离有害信息，如用户是未成年人，则须在监护人的指导与监督下使用106云盘及接受106云盘的服务，否则请立即停止注册或终止使用106云盘。<br>\r\n<h3>5. 服务变更、中断或终止</h3><br>\r\n由于106云盘网络服务的特殊性，用户同意106云盘有权随时变更、中断或终止部分或全部的网络服务。如变更、中断或终止的网络服务属于免费服务项目，106云盘无需提前通知用户，也无需对任何用户或任何第三方承担任何责任。如系付费服务项目，则须提前一个月通知用户，并协商解决任何已付未使用或未付款项的事宜。一旦服务取消或终止，用户使用本服务的权利立即终止，且在本服务中储存的任何信息可能无法恢复。<br>\r\n106云盘需要定期或不定期地对提供网络服务的平台或相关的设备进行检修或者维护，如因此类情况而造成免费网络服务中断，106云盘无需为此承担任何责任。 如收费服务在合理时间内中断, 106云盘无须为此承担任何责任,  但应尽可能事先进行通告。<br>\r\n106云盘对于因为自然灾害, 其他信息服务商故障，相关信息设备和软件故障， 或者任何不可阻挡因素导致服务中断或终止， 不承担任何责任， 但应尽可能减少该因素对用户的影响。<br>\r\n对于其他任何非上述因素导致的用户服务中断或终止， 对于免费服务， 106云盘不承担任何责任。 对于付费服务， 106云盘可以在平等协商公平的原则下， 在不超过用户总付费金额的前提下, 进行赔偿解决。 如果用户采取按月付费的模式， 总赔偿金额不得超过服务中断和终止当月付费金额。 如果用户采取年付费的模式，总赔偿金额不得超过服务中断和终止当年付费金额。<br>\r\n为避免服务器资源浪费，如免费用户超过三个月未登录使用106云盘服务，106云盘保留在未经通知的情况下终止该用户的免费服务，并删除该用户在服务器上保存的数据的权利。但106云盘在行使该权利前，应尽可能的通知用户以减少该权利行使对用户的影响。<br>\r\n为避免服务器资源浪费，付费用户如果超过三个月未及时续费或者转化为免费服务，106云盘保留在未经通知的情况下终止该用户的付费服务，并删除该用户在服务器上保存的数据的权利。但106云盘在行使该权利前，应尽可能的通知用户以减少该权利行使对用户的影响。<br>\r\n<h3>6. 禁止行为</h3><br>\r\n用户不得利用106云盘以任何方式传播敏感信息和违反国家法律、政策的信息，包括但不限于下列信息：<br>\r\n(1)反对宪法确定的基本原则的；<br>\r\n(2)危害国家统一、主权和领土完整的；<br>\r\n(3)泄露国家秘密、危害国家安全或者损害国家荣誉和利益的；<br>\r\n(4)煽动民族仇恨、民族歧视，破坏民族团结，或者侵害民族风俗、习惯的；<br>\r\n(5)宣扬邪教、迷信的；<br>\r\n(6)散布谣言，扰乱社会秩序，破坏社会稳定的；<br>\r\n(7)宣扬淫秽、赌博、暴力或者教唆犯罪的；<br>\r\n(8)侮辱或者诽谤他人，侵害他人合法权益的；<br>\r\n(9)危害社会公德或者民族优秀文化传统的；<br>\r\n(10)有法律、行政法规和国家规定禁止的其他内容的。<br>\r\n<h3>7. 费用</h3><br>\r\n除106云盘明确规定收费的服务项目外，106云盘是免费注册、使用的。<br>\r\n用户理解并同意106云盘有权根据实际的需要对某些目前免费的服务项目收取合理的服务费，如用户不同意106云盘收取此项目费用，则用户有权退出使用该项服务或终止使用106云盘。<br>\r\n用户理解并同意106云盘对新增服务项目有权决定是否收费，用户有权选择接受或拒绝该项目服务。<br>\r\n如用户接受106云盘的收费项目，则用户应当按106云盘的收费规定支付费用；如用户未支付费用或欠费，则106云盘有权不向用户提供此项服务或停止向用户提供此项服务。106云盘有权根据实际需要调整收费项目的资费,用户有权选择接受或拒绝使用。<br>\r\n<h3>8. 隐私保护</h3><br>\r\n保护用户隐私是106云盘的一项基本政策，106云盘保证不会公开或向第三方提供单个用户的注册资料以及用户在使用网络服务时存储在106云盘 中的非公开内容，除非有下列情况出现：<br>\r\n(1)有关法律规定或106云盘合法服务程序规定；<br>\r\n(2)在紧急情况下，为维护用户及公众的权益；<br>\r\n(3)为维护106云盘的商标权、专利权及其他任何合法权益；<br>\r\n(4)其他依法需要公开、编辑或透露个人信息的情况。<br>\r\n<h3>9. 知识产权</h3><br>\r\n用户和106云盘双方理解并同意106云盘为向用户提供服务而开发或从第三方合法获得的技术成果或方案的全部知识产权，包括但不限于，商标、商号、以及106云盘的平台、版面设计均归106云盘或该第三方所有。未经106云盘许可，用户不得以任何形式对前述知识产权或其任何部分进行使用、修改等。<br>\r\n除上述规定外，用户在106云盘中储存的任何作品，包括但不限于，图片、音乐、视频的知识产权归用户所有（“用户作品”）或第三方所有（“第三方作品”）。用户保证对前述用户作品享有完全知识产权；如系第三方作品，用户应当获得第三方的许可或未获得第三方许可但有权合法使用第三方作品。<br>\r\n除法律法规另有规定外，未获得第三方作品所有人的事先许可，用户不得以任何方式使用第三方作品。如果106云盘收到任何第三方作品所有人或其合法代表发给106云盘的合理通知后，106云盘有权移除相应侵权作品；用户也有权对前述侵权指控提出反通知。<br>\r\n<h3>10. 知识产权侵权</h3><br>\r\n用户保证，在106云盘中储存的用户作品或第三方作品不侵犯任何第三方知识产权，包括但不限于商标权、版权和商业秘密。<br>\r\n若用户在106云盘中储存的用户作品或第三方作品导致第三方主张前述作品侵犯其知识产权，用户应当负责处理前述第三方的权利主张，承担由此招致的全部费用，包括但不限于律师费和侵权赔偿，并保证106云盘不会因此而遭受任何损失。用户同意，若发生上述侵权行为，106云盘有权移除上述侵权作品。<br>\r\n<h3>11. 免责和不保证</h3><br>\r\n在适用法允许的最大范围内，106云盘在任何情况下不对用户因使用或不能使用106云盘提供的服务所发生的特殊的、意外的、直接或间接的损失承担任何责任。<br>\r\n106云盘不对提供的服务作任何明示或暗示的保证，包括但不限于不保证106云盘提供的服务一定能满足用户的要求，也不保证服务是否会中断、及时性、安全性。<br>\r\n<h3>12. 违约责任</h3><br>\r\n用户因违反国家法律法规或本条款的约定而给106云盘造成损失的，用户应赔偿106云盘因此而造成的一切损失，并消除影响。<br>\r\n<h3>13. 不可抗力</h3><br>\r\n由于不可抗力事件，致使用户不能使用106云盘提供的服务时，106云盘不对用户的任何损失承担责任。不可抗力事件包括但不限于（1）自然灾害、如台风、洪水、冰雹；（2）政府行为，如征收、征用；（3）社会异常事件，如罢工、骚乱；（4） 计算机病毒或黑客攻击、互联网络、通信线路等原因造成服务中断。<br>\r\n<h3>14. 生效和期限</h3><br>\r\n本条款自用户点击注册程序中的“我接受”时开始生效。用户注销其用户名或106云盘终止您的用户资格时，用户使用权利终止。此后，第9、10、11、12、15和16条继续有效。<br>\r\n<h3>15. 法律适用和争议解决</h3><br>\r\n本条款应受中华人民共和国法律解释和管辖，并不考虑法律冲突。<br>\r\n有关本条款的任何争议应由双方秉承善意友好协商解决。若三十日内协商不成，双方同意将争议提交仲裁委员会依据其当时有效的仲裁规则仲裁解决。仲裁裁决是终局的，对双方均有法律约束力。除非仲裁裁决另有规定，仲裁费用应由仲裁败诉方承担。<br>\r\n<h3>16. 一般条款</h3><br>\r\n用户和106云盘在履行本条款的过程中，应遵从所有适用的法律。<br>\r\n106云盘有权通过在106云盘上发布通知或发送电子邮件等方式向用户发送通知、广告等。<br>\r\n本条款所载任何内容不应被解释为在用户和106云盘之间创设合资、合伙、代理或任何其它本条款目的以外的关系。<br>\r\n\r\n用户理解并同意106云盘有权根据实际需要修改本条款。如果您不同意变更，则用户有权退出106云盘，终止服务关系；如用户继续使用106云盘提供的服务，则表示用户同意本条款的修改。<br>\r\n若本条款中部分条款因任何原因而被认定无效，此种无效条款并不影响其他条款的有效性，且此种无效条款应自始视为不存在。\r\n106云盘有权转让其在本条款下的任何权利或义务。<br>\r\n本条款中所有标题仅为方便阅读所设置，并不影响本条款任何部分的含义或解释。<br>\r\n	\r\n	</td>\r\n  </tr>\r\n</table>', '3');
INSERT INTO `wp_config` VALUES ('140', 'WEB_DAOQI_DQ', '2', '网盘到期页面', '6', '', '网盘到期提示', '1525680145', '1525680224', '1', '<div class=\"demo\">\r\n	<p><span>您</span><span>的</span><span>网</span><span>盘</span><span>已</span><span>到</span><span>期</span></p>\r\n	<p>进入官方会员中心进行续费升级（<a href=\"http://member.106pan.com/wangpan_config\" target=\"_blank\">点击进入</a>）</p>\r\n</div>', '5');
INSERT INTO `wp_config` VALUES ('142', 'NOKEYWORDS', '2', '非法关键词', '5', '', '', '1526712128', '1526712128', '1', '破处\r\n外挂\r\nAV女\r\nAV片\r\nA片\r\nAV电影\r\n炸药制作\r\n原子弹\r\n法轮功\r\nfa轮功\r\nqiang支\r\n虐待\r\n炸弹制作方法\r\n炸弹制作\r\n冰毒\r\n少女\r\n淫女\r\n操你妈\r\n操你娘\r\n草你妈\r\n成人表演\r\n成人电影\r\n成人卡通\r\n成人录像\r\n成人漫画\r\n成人书库\r\n成人贴图\r\n成人图片\r\n成人文学\r\n成人小说\r\n成人笑话\r\n出售弹药\r\n出售发票\r\n出售假币\r\n出售雷管\r\n出售雷管炸药自制炸弹\r\n出售枪支\r\n出售手枪\r\n出售炸药\r\n处女\r\n春药\r\n催情春药\r\n催情粉\r\n催情水\r\n催情药\r\n三箭气枪\r\n手拉狗\r\n英国b50\r\ngamo枪\r\nb50套件\r\n54木仓\r\n美制勃朗宁\r\n工字QB6\r\n工字管\r\nwg702左轮\r\n温切斯特800x\r\n金钟1911\r\n金钟m92\r\n槽化枪管\r\n俄罗斯mp\r\n枪托\r\nfx气皇\r\ngamo竞技之王\r\n秃鹰膛线管\r\n铅弹\r\nCO2狗\r\n消音器\r\n瓦尔特\r\n花山fk77\r\n气弹枪\r\n火狗\r\npcp秃鹰\r\n92式手木仓\r\n64式手木仓\r\n64式气木仓\r\n狗管\r\n54式手木仓\r\n汽狗配件\r\n美秃套件\r\n无声手枪\r\n气狗\r\n仿真电狗\r\n德版PPK\r\n军用枪支\r\n钢珠弹\r\n秃鹰套件\r\n五四式手枪\r\n汽枪铅弹\r\n枪支配件\r\n发射药\r\n金弓m4\r\n工字牌配件\r\n伯莱塔\r\n英国骚本\r\n短枪\r\n改装发令枪\r\n狙击步狗\r\nCFX气枪\r\npcp汽枪\r\npcp气枪\r\n气狗配件\r\n一比一枪模\r\n手狗配件\r\nM300狙击\r\n气枪\r\n12号猎枪\r\n锡锋牌B8\r\npcp新贵\r\n12号弹壳\r\ned50套件\r\n国产秃子\r\n双鹰M50\r\n工字汽枪\r\n长枪\r\n双管猎枪\r\n运动步枪\r\n打鸟气枪\r\n仿真气枪\r\n枪模\r\n制式手枪\r\n瓦斯枪\r\n冲锋枪\r\n微冲\r\n步枪\r\n气步枪\r\n仿真枪\r\n军用手枪\r\n麻醉枪\r\n狙击枪\r\n火枪\r\n火药枪\r\n真枪\r\n手枪\r\n猎枪\r\n警用枪支\r\n汽步枪\r\n平式枪\r\n打鸟枪\r\n打鸟汽枪\r\n电击枪\r\n来复枪\r\n枪械\r\n改装射钉枪\r\n热兵器\r\n双筒猎枪\r\n微型冲锋枪\r\n微声手枪\r\n三箭内脏\r\n广东三箭\r\n中握SB-50\r\nm99狙击\r\n扳机\r\nFXtyphoon台风\r\n仿真钢弹枪\r\n工字QB\r\n快排打气筒\r\n锦江b58\r\n山猫pcp\r\n左轮手狗\r\n左轮枪\r\n三棱军刺\r\n三箭牌汽枪\r\n高压汽枪\r\n峨眉气枪\r\n汽步狗\r\n气狗子弹\r\nPCP汽狗\r\n猎枪弹壳\r\n韩国AR6猎人王\r\n88式狙击\r\n霰弹枪\r\n工字牌lqb19\r\n金弓hk416\r\n迷彩秃鹰\r\n温彻斯特1000x\r\n本杰明392\r\n华特霸者\r\n德国夜鹰\r\n无声猫\r\n瓦尔特统治者5.5\r\n金弓电狗\r\n仿真汽枪\r\n秃鹰狗\r\n工字牌QB19\r\n德国台风汽枪\r\n工字lqb18\r\n瓦尔特夜鹰\r\n工字牌lqb4\r\n工字牌qb51\r\n温彻斯特1000\r\nhd50中握\r\n工字牌ss2\r\n手狗\r\nbb弹狗\r\n秃子55\r\n花山n306\r\n蟒蛇586六寸\r\n泰瑟枪\r\nfxt12耳语\r\n本杰明掠夺者\r\n燕尾套件\r\n秃鹰握把\r\nfx叛逆者\r\n雄鹰m007\r\n广州三箭牌\r\n火药钢珠枪\r\n动力手枪\r\n锡峰b8\r\n钢珠汽枪\r\n台湾加强版BabyHi\r\n工字牌lar\r\n金钟m700\r\n司马028u\r\n黑星54式\r\n工字汽狗\r\n钢珠猎狗\r\n秃鹰汽长狗\r\n仿真长狗\r\n特级运动长弹\r\n花山N306\r\n西班牙gamo\r\nfx革命者\r\n五四式手狗\r\n俄版654k\r\n花山fs99\r\n超级雷克\r\n手拉长狗\r\n华山道具\r\n温切斯特1100x\r\n西班牙cfx\r\nPCZ山猪\r\n进口手狗\r\n单管猎狗\r\n77军用手狗\r\n瓦尔特统治者\r\n猎木仓\r\nL新型火箭\r\n金钟汽枪\r\n金钟气狗\r\n秃鹰图纸\r\n瑞典fx\r\n台湾kwc\r\n本杰明katana\r\n54军狗\r\n仿真AK\r\n工字狗\r\n雷明顿m870\r\n德国cp88\r\n雄鹰m05A\r\n锡锋牌6630\r\n工字牌LQB362\r\n三箭牌AA0090\r\n工字牌qb23\r\nawp狙击\r\n西班牙夜鹰\r\n雷鸣登LX937\r\n秃鹰击锤\r\n工字牌B34\r\n松鼠牌单管\r\n中握B50\r\n手拉鸡\r\n三箭b5\r\n台湾秃鹰\r\nAuto5半自动\r\n汽枪\r\n工字牌qb\r\n道尔m8045\r\n气皇400\r\n工字牌qb88\r\n工字牌qb57\r\n猎枪弹\r\n秃鹰配件\r\n西德ks316\r\n654K气枪\r\n92式手狗\r\n77式手狗\r\n77式手枪\r\n654k手枪\r\n45MM铅弹\r\n45MM狗粮\r\n三角牌气枪\r\n汽手狗\r\n54式手枪\r\n手拉狙\r\n柯尔特m1911\r\n海豹M9\r\n进口气狗\r\n运动枪\r\n韩国叛逆者\r\n柯尔特1911\r\n狗配件\r\n大口径PCP\r\n牛头702\r\n防暴枪\r\n三箭牌\r\n瓦尔特P99\r\n司马AK\r\n子弹模具\r\n工字牌qb36\r\n柯尔特巨蟒\r\n金弓\r\n英国s410\r\n健卫8\r\n锡锋\r\n贝瑞塔\r\n勃朗宁m1911\r\n英国EV2\r\n终极猎人\r\n秃鹰全套\r\n工字气qiang\r\n汽狗狗粮\r\n七七式手枪\r\n工字LAR1000\r\n道尔M8045\r\n金弓电动狗\r\n暴雪s10\r\n德国beretta\r\n金钟m10\r\n哈默利750\r\n台湾PCZ\r\n鲁格p85\r\n汔狗\r\npcp图纸\r\n小蜜蜂连发\r\n秃鹰枪\r\n气动短狗\r\npcp屠龙手\r\n雄鹰M008\r\n工字牌lqb31\r\n工字牌qb34\r\n工字b33\r\n猎狗粮\r\n狙击之王M300\r\n德瓦管\r\n手拉98K\r\nEvanixRainstorm暴雨\r\nEvanixWindyCity风城\r\n雄鹰SVD\r\n工字侧拉折叠式QB\r\n夜莺cp99版\r\n德版cp88\r\n汤普森M1928\r\n三箭汽狗\r\n锡锋汽枪\r\n猎狗铅弹\r\n仿真气木仓\r\n仿真气狗\r\n三箭气狗\r\n上海工字牌气狗\r\n三箭汽枪\r\n1比1仿真枪\r\n格洛克\r\n巴雷特\r\n雷鸣顿\r\n铅弹狗\r\n射钉狗\r\n德国colt\r\n秃套件\r\n汽抢\r\nw管\r\n本杰明发现者\r\n工字牌qb78\r\nBOYI手拉98K\r\n工字牌R32\r\nFX季侯风半自动\r\n美国柯尔特M1917型左轮手枪\r\n雷鸣登七连发\r\nfn2000突击\r\n英国B9-10\r\nar6猎人王\r\n台湾火箭秃\r\n峨眉牌立式12号\r\n工字牌qb41\r\n三箭配件\r\n工字牌lqb34\r\n工字牌LQB\r\n折叠气枪\r\n汽枪图纸\r\n侧拉式气枪\r\n汽狗图纸\r\n54手狗\r\n仿真64\r\n瓦尔特cp99\r\n钢珠狗\r\n92式手枪\r\n铅弹枪\r\n左轮手枪\r\n汽短狗\r\n汽长狗\r\n雷明顿猎枪\r\n台秃\r\n土制猎枪\r\n狙击狗\r\n中握秃鹰\r\n上海工字气狗\r\n骚本气枪\r\n国秃\r\n雷鸣七连发\r\n广州三箭\r\n秃鹰\r\n毛瑟c96\r\n洛克KJ900\r\nfx季候风\r\n5.5母鸡模具\r\n锡锋牌b51\r\nCP99夜鹰版\r\n工字牌XS\r\n德国586\r\n温彻斯特m1887\r\n弹轮\r\n健卫步枪\r\n秃鹰汽枪\r\n高压步枪\r\n高压打鸟枪\r\n自制手枪\r\n金属枪模\r\n金属仿真枪\r\n雷鸣登汽枪\r\n雷鸣登猎枪\r\n汽枪消声器\r\n猎枪配件\r\n单管猎枪\r\n上海工字汽狗\r\n锡锋牌气枪\r\n骚本套件\r\n汽枪配件\r\n气狗狗粮\r\n上海工字气枪\r\n气枪枪管\r\n高压鸟枪\r\n20号弹壳\r\n健卫20小口径\r\n双鹰m1911\r\n三箭B5-2\r\n雄鹰m05\r\n司马042\r\n毛瑟98\r\n上海工字牌\r\n54式\r\nkj900洛克\r\n92式\r\n锡锋B8折叠\r\n汽狗\r\n气皇\r\n短秃\r\n金钟m1911\r\n卡宾枪\r\nPCP枪管膛线\r\n秃鹰扳机\r\n铅弹母鸡\r\n5.1英寸A银龙版\r\n内脏全套\r\n雷明顿700\r\n沙漠之鹰\r\n钢珠枪\r\n国产气枪\r\n进口汽枪\r\n温彻斯特1100x\r\nm110狙击\r\n雄鹰awp\r\nfx农夫\r\n土铳\r\n鲁格\r\n瓦斯手枪\r\n秃鹰气枪\r\n秃鹰气瓶\r\n绿瓦管\r\n峨眉牌汽枪\r\n东京丸井MARUIPSG1\r\n奥运会比赛手狗\r\n花山左轮\r\n气枪瞄准镜\r\n汽狗铅弹\r\n气枪子弹\r\n猎枪铅弹\r\n骚本\r\n气抢\r\n五连发\r\n温切斯特气枪\r\n气枪铅弹\r\n老妖狩猎论坛\r\npcp论坛\r\n扳机组装图\r\n手枪械构造原理图纸\r\n中握侧拉b50完整图\r\n猎枪扳机构造图\r\n秃鹰五件扳机组装图\r\n钢珠汽枪结构图\r\n单管猎枪退壳装置图\r\n仿真枪网\r\n手拉鸡腾讯军工\r\n弹簧活塞气枪分解图\r\n一体阀气狗\r\n工字qb\r\npcp气枪打猎论坛\r\n亚洲打猎网\r\n秃鹰pcp气瓶\r\nPCP板球气步枪\r\n中握秃结构图\r\n工字QB88\r\n猎枪零件够造图\r\n亚洲猎坛\r\n改秃\r\n西点军品\r\n改火套件\r\n上海产汽气枪厂\r\n汽枪635十年精品老店\r\n猎枪构造图解\r\n香港气枪厂\r\n钢珠吹尘狗制作视频\r\n气枪猎枪专网\r\n小口径猎枪\r\n气枪网\r\n猎枪网\r\n工字气枪网\r\n三箭气枪网\r\n进口气枪网\r\n气狗专卖\r\n猎枪销售网\r\n小六改火\r\n3d打印枪支图纸\r\n中华狩猎网\r\n猎友之家论坛\r\n终极狩猎家园\r\n至诚枪狗\r\n仿真狗械专卖网\r\n手狗网\r\n秃鹰狙击气枪零部件图\r\n秃鹰气动气枪构造原理图\r\n气枪专卖网\r\n仿真枪械网\r\n枪模网\r\nPCP气枪网\r\n正品枪支\r\n阻击狗\r\n猎狗专卖网\r\n汽枪店\r\n枪狗论坛\r\n打鸟汽枪淘宝\r\n猎人汽狗网\r\n汽抢专买网\r\n气狗网\r\nPCP狩猎论坛\r\n世纪打猎论坛\r\n镇远猎友会\r\n猎枪专买网\r\n狩猎用品网\r\n兄弟打猎网\r\n燧发枪结构图\r\n狗友网\r\n手抢网\r\n高压气狗可退壳\r\n军用手狗论坛\r\n真枪黑市交易网\r\nAR6猎人王\r\n双管猎图纸\r\n鸟枪弹弓枪图片\r\n防真抢打钢珠\r\n打钢珠弹簧抢图片\r\n军迷购枪天堂\r\n手抢哪里有卖\r\n上海工字牌气枪官网\r\n尚奇将网\r\n秃鹰网\r\n打鸟枪网\r\n台秃网\r\n猎狗网\r\n预充气压枪网\r\n亿千军工\r\n狗支论坛\r\n工字QB57图纸\r\n枪械交易吧\r\n弹簧活塞图纸\r\n国际狩猎联盟网\r\n中华猎人网\r\n秃鹰pcp型材\r\n秃鹰身子加工\r\n狩猎网\r\n秃鹰三气木仓\r\n秃鹰论坛\r\n鸟枪网\r\n信誉枪行\r\n诚信枪行\r\n秃鹰高压快排阀\r\n手狗吧\r\n好枪网\r\n天朝狩猎论坛\r\n54式图纸\r\n汽枪专卖网\r\n枪械制造方法\r\n手枪见面交易\r\n秃鹰cad图纸\r\n钢珠枪网\r\n打鸟枪网站\r\n秃鹰气瓶阀门第一官方\r\n45狗粮网\r\npcp配件店\r\n狗粮模具网\r\n鸟枪店网\r\n54式手枪客服网\r\n打猎器抢网\r\npcp图纸网\r\n猎友之家网\r\n中国爱猎论坛\r\n狩猎论坛网\r\n打鸟工具大全\r\n火狗猎抢网\r\n火狗枪狗配件网\r\n电狗图纸网\r\n打鸟抢网\r\n大漠狩猎\r\n气枪军品网\r\n槽化枪管网\r\n秃鹰内脏图纸\r\n东方狩猎\r\n中国枪支网\r\n枪狗狩猎论坛\r\n打猎论坛\r\n五狐狩猎网\r\n中折式气枪图片\r\n工字汽枪打鸟视频\r\n淘宝秃鹰全套配件\r\n秃鹰扳机图纸\r\n步枪结构图解剖图\r\n国产秃鹰第一官方\r\n中国汽枪打猎论坛\r\n尚將軍品\r\n搔本套件淘宝\r\n气步枪专业网\r\n气枪专业配件网\r\n气弩官方网站\r\n气枪专业网\r\n清流气枪官网\r\n三箭气枪官网\r\n狗友枪\r\n我想买枪网站\r\n灭火器瓶改枪\r\n汽gou论坛\r\n今天军品\r\n三哥好枪网\r\n秃鹰气步枪论坛\r\n手拉鸡狗论坛\r\n军品之家\r\n上海气枪厂\r\n广州气枪厂\r\ntiger111hk野战\r\n一体阀扳机\r\n气狗图纸\r\n枪友网\r\n气抢网\r\n电狗专卖网\r\n亚洲狩猎论坛\r\n枪械交易网\r\n秃鹰燕尾套件\r\n4.5狗粮模具\r\n弩枪网\r\n秃鹰打气筒\r\n汽枪官网\r\n工字改装图\r\n火机吹钢珠\r\n百度军品\r\n三箭论坛\r\n铜底火\r\n秃鹰过桥与阀门连接图\r\n5.5狗粮模具\r\n红王蓝商城\r\n军品气枪店\r\n秃鹰配件之家\r\n户外军品气枪店\r\n高压打钢珠\r\n钢珠发射枪\r\nbb狗打钢珠\r\n发射钢珠BB打鸟\r\n镀镍狗粮\r\n军火酷论坛\r\n火狐狩猎论坛\r\n天地狩猎\r\n内脏套件\r\n骚本论坛\r\n自制机匣\r\n灭火器改枪\r\n泰山第一护具\r\n老狗管\r\n军方制品\r\n衡山护具\r\n秃鹰组装详细分解图\r\n扳机结构图\r\n猎狗配件\r\n仿真抢专卖店军用\r\n气同枪\r\n中国猎枪网\r\n击锤图纸\r\n扑猎网\r\n手狗论坛\r\n中华猎坛网\r\n中国猎人网\r\n猎友之家狩猎论坛\r\n中华打猎网\r\n五狐狩猎\r\n快乐猎人论坛\r\n弹簧活塞狗\r\n短秃套件\r\n美秃气瓶\r\n秃子组装\r\n枪械网站\r\n手狗专卖网\r\n手狗论坛官网\r\n真抢械网\r\n农夫气枪\r\n汽抢网\r\n手拉狗站\r\n飞鸿护卫\r\n自制pcp\r\n中华狩猎用品\r\n电狗网\r\n高压气瓶枪的分解图\r\n打鸟网\r\n军火专卖店\r\n精诚枪械网\r\n中华猎坛\r\n麻醉枪网\r\n真枪网\r\n逆战户外官网\r\n秃身图纸\r\n三箭改\r\n秃鹰官网\r\n国际狩猎联盟\r\n长狗短狗专卖网\r\n爱枪网\r\n真枪械军品店\r\n淘枪网\r\n唯品枪网\r\n吹尘论坛\r\n卖枪网\r\n汽抢专卖网\r\n秃狗\r\n滑膛弹弓枪\r\n铅弹铗\r\n打猎工具出售论坛\r\n图鹰最新推荐\r\n气狗出气伐解剖图\r\nb50结构图\r\n弹簧活塞气枪结构图\r\n狙击枪网\r\n秃鹰汽枪网\r\n凸鹰\r\n秃鹰后握图纸\r\n猎枪结构扳机图\r\n信誉枪店\r\n黑市枪行\r\n307射钉枪改猎枪\r\n骚本枪\r\n中国汽枪网\r\n中华狩猎论坛\r\n诚信汽枪网\r\n中华打猎论坛\r\n新千秋狩猎论坛\r\n风云猎坛网站\r\n打鸟工具买卖网\r\n民用枪械交易网站\r\n阿里枪行\r\n秀鹰汽枪\r\n大漠狩猎论坛\r\n快排吹图纸\r\n兄弟打猎论坛\r\n亚洲打猎论坛\r\n钢珠汽枪网\r\n打鸟汽枪网\r\n汽枪网\r\n气枪免定金\r\n秃鹰组装教程\r\n千秋狩猎论坛\r\n秃鹰狩猎论坛\r\n华夏狩猎论坛\r\n飘红户外狩猎论坛\r\n猎友之家打猎论坛\r\n北山枪行\r\n枪械网\r\n山水狩猎论坛\r\n管改秃\r\n真狗网\r\n打鸟气枪网\r\n星空户外商城\r\n中文秃鹰官网\r\n联盟狩猎论坛\r\n东方狩猎论坛\r\n高爆炸药\r\n军用雷管\r\n工业雷管\r\n电子炸弹\r\n导火索\r\n定时炸弹\r\n鱼雷\r\n遥控炸弹\r\n土炸药\r\nTNT炸药\r\n内裤炸弹\r\n乳化炸药\r\n太恩\r\n烟雾弹\r\n黑索今\r\n催泪弹\r\n汽油弹\r\n巡航导弹\r\n氢弹\r\n导弹\r\n炸弹\r\n雷管\r\n燃烧瓶\r\n塑料炸弹\r\n过氧丙酮\r\n硝铵炸药\r\n迫击炮弹\r\n黑火药\r\n闪光弹\r\n火药\r\n火雷管\r\n空气炮\r\n苦味酸\r\n黑梯铝\r\n地雷\r\n爆炸装置\r\n土雷\r\n硝酸盐炸药\r\n高氯酸铵\r\n击发药\r\n引爆系统\r\n硝酸肼\r\n雷汞\r\n三硝基苯酚\r\n三硝基甲苯\r\n手榴弹\r\n水胶炸药\r\n太安\r\n硝酸胺炸药\r\n硝胺炸药\r\n液体炸弹\r\n黄色炸药\r\n硅烷炸弹\r\n土炸弹\r\n手雷\r\n黑索金\r\n莫洛托夫鸡尾酒\r\n炸药\r\n硝化甘油\r\n季戊四醇四硝酸酯\r\n铵梯炸药\r\n铵油炸药\r\n导爆索\r\n燃烧弹\r\n原子弹\r\n自制炸弹\r\n爆破剂\r\n液体炸药\r\n火箭弹\r\n延期器材\r\n自制炸药\r\nC4橡胶炸药\r\n土制火药\r\n土制燃烧弹\r\n火焰喷射器\r\n引爆装置\r\n单质猛炸药\r\n起爆器\r\n简易爆炸物\r\n环三亚甲基三硝胺\r\n土制炸弹\r\n土制手榴弹\r\n土制手雷\r\n起爆药\r\n塑胶炸药\r\n太恩炸药\r\n低爆药\r\n高爆药\r\n点火药\r\n爆破器材\r\n掌心雷\r\n起爆具\r\n白磷弹\r\n水雷\r\n开花弹\r\n硝酸脲\r\n诡雷\r\n环三亚甲基三硝铵\r\n榴弹\r\n硝基脲\r\nHMTD\r\n硝酸甘油炸药\r\n起爆装置\r\n环三次甲基三硝胺\r\n氢叠氮酸\r\n特屈儿\r\n三硝基苯甲硝胺\r\nTATP\r\n三过氧化三丙酮\r\n引爆药\r\n爆炸物\r\n硝化棉炸药\r\n红烧兔子大餐\r\n铵油炸药制备\r\n特屈儿制备\r\n苦味酸的配制\r\nrdx制备\r\n苦味酸配制\r\ntatp的合成方法\r\nTATP制作工艺\r\n三过氧化三丙酮制取\r\n三过氧化三丙酮结晶\r\ntatp如何制作\r\n三过氧化三丙酮制作\r\n合成三过氧化三丙酮\r\nTATP制作\r\ntatp合成\r\nTATP制备\r\n熵炸药制备\r\n三过氧化三丙酮制备\r\n无政府主义者食谱\r\n莫洛托夫鸡尾酒\r\n恐怖分子手册\r\n液体炸药比例\r\n液体炸药配方\r\n炸弹DIY\r\ntatp制作文档下载\r\n撒旦之母制作\r\ntatp详制方法\r\ntatp制作教程\r\n烟雾弹制备\r\ntatp制作免费文档\r\n撒旦之母配方\r\nTATP炸药的研制\r\n黑索金制备方法\r\n硝化棉的制作\r\n土炸弹制作流程\r\n火药配方大全\r\nDIY原子弹教程\r\n土炸药配方\r\n仿制警服\r\n警用催泪剂\r\n警用电击器\r\n警用安全指示牌\r\n警用标志\r\n警察肩章\r\n警用肩章\r\n警察徽章\r\n警用电击棒\r\n高压警棍\r\n假警官证\r\n高仿军官证\r\n高仿警察证\r\n警用手铐\r\n警用电棒\r\n警用催泪弹\r\n警官证\r\n警察证\r\n警察胸标\r\n警察作训服\r\n警灯\r\n警用钢叉\r\n手铐\r\n特警作战服\r\n警帽\r\n警用器材\r\n警用臂章\r\n电警棍\r\n高仿警服\r\n高压电警棍\r\n交警警服\r\n警察执勤服\r\n警服\r\n警衔\r\n警用甩棍\r\n武警作战服\r\n仿真警服\r\n警徽\r\n高仿警官证\r\n警服肩章\r\n警用电棍\r\n正规警服卖店\r\n特码\r\n赌马\r\n棋牌\r\n梭哈\r\n扎金花\r\n德州扑克\r\n博彩\r\n百家乐\r\n赌球\r\n轮盘\r\n乐透\r\n六合彩\r\n长治筋\r\n盐酸羟亚胺\r\n盐酸麻黄素\r\n亚甲基二氧苯基\r\n替马西泮\r\n沙菲片\r\n去氧麻黄碱\r\n普拉西泮\r\n莫达非尼\r\n麦司卡林\r\n伪麻黄素\r\n麦角乙二胺\r\n麻黄素羟亚胺\r\n麻黄素\r\n麻黄浸膏\r\n麻黄碱\r\n麻果\r\n黎城辣面\r\n可卡因\r\n甲硝西泮\r\n甲卡西酮\r\n海洛因\r\n海乐神\r\n古柯碱\r\n氟硝西泮\r\n大麻\r\n冰毒\r\n白粉\r\nK粉\r\n副甲氧基安非他明\r\n2,5-二甲氧基-4-溴苯乙胺\r\n醋氢可待因\r\n阿法甲基芬太尼\r\n二乙噻丁\r\n贝齐米特\r\n黄樟素\r\n麦角新碱\r\n麦角二乙胺\r\n2,5-二甲氧基苯乙胺\r\n三氯甲烷\r\n地索吗啡\r\n硫代芬太尼\r\n右吗拉胺\r\n1－苯基－2－丙酮\r\n乙醚\r\n异黄樟素\r\n黄樟油\r\nγ-羟基丁酸\r\nk粉\r\n二亚甲基双氧苯丙胺\r\n季戊四醇\r\n麻古制作技术\r\n喷他佐辛\r\n苯甲曲秦\r\n哌苯甲醇\r\n四氢西泮\r\n丙己君\r\n扎来普隆\r\n罂粟壳\r\n氢吗啡醇\r\n舒芬太尼\r\n对氟芬太尼\r\n去甲吗啡\r\n非那丙胺\r\n大麻树脂\r\n可多克辛\r\n杜冷丁\r\n邻氯苯基环戊酮\r\n氯硝西泮\r\n氯氨酮\r\n六氢大麻酚\r\n力月西片\r\n卡西酮\r\n咖啡因\r\n甲基苯丙胺\r\n甲基安非他明\r\n酣乐欣\r\n二甲基安非他明\r\n地西泮\r\n苯巴比妥\r\n安钠咖\r\n安非他明\r\nghb水\r\n盐酸麻黄碱\r\n香港GHB粉\r\n香港ghb\r\n天然咖啡因\r\n三唑仑\r\n去甲伪麻黄碱\r\n去甲麻黄素\r\n普斯普剂\r\n尼美西泮\r\n麦角酸\r\n麻古\r\n氯胺酮\r\n盐酸氯胺酮\r\n安眠酮\r\n盐酸曲马多\r\n甲基麻黄素\r\n胡椒醛\r\n缅古制作技术\r\n缅古配方\r\n麦角酸提炼技术\r\n缅古制作方法\r\n咖啡碱\r\n甲基苯丙胺制作方法\r\n海洛因制作方法\r\n冰毒技术\r\n苯基甲酮\r\n冰砖\r\n麦角酸二乙酰胺\r\n大麻烟\r\n缅果\r\nGHB原液\r\n香料精灵\r\n倍它洛尔\r\n苯丙胺\r\n天然可卡因\r\n去氧麻黄素\r\n麦角酸二乙胺\r\n麦角胺\r\n盐酸羟亚胺?\r\n摇头丸配方\r\n二乙酰吗啡\r\n丁丙诺啡\r\n氟硝安定\r\n安纳咖\r\n摇头丸\r\n戊巴比妥\r\n甲米雷司\r\n芬乙茶碱\r\n瑞芬太尼\r\n甲基苯丙胺合成方法\r\n氯胺酮制作配方\r\nk粉制作方法\r\nk粉制作技术\r\n麻古制作方法\r\n鸦片\r\n左旋麻黄素\r\n甲基安非他命\r\n甲苯喹唑酮\r\n邻氨基苯甲酸\r\n麻果配方\r\n相思红娘粉\r\n云南情蛊\r\n亚甲二氧基甲基苯丙胺\r\ny 羟基丁酸\r\n燃料飞行员\r\n飞行燃料weed\r\n异戊巴比妥\r\n去甲麻黄碱\r\n左旋麻黃素\r\nLSD迷幻药\r\nGHB水\r\n胡椒基甲酮\r\n麻黃素\r\n伪麻黄碱\r\n羟考酮\r\n二亚甲基双氧安非他明\r\n芬美曲秦\r\n哌啶\r\n情蛊\r\n美托酮\r\n二甲氧基乙基安非他明\r\n苯乙酸\r\n醋酸酐\r\nN－乙酰邻氨基苯酸\r\n地洛西泮\r\n乙氯维诺\r\n芬普雷司\r\n卤沙唑仑\r\n咪达唑仑\r\n匹莫林\r\n阿芬太尼\r\n芬太尼\r\n癸硼烷\r\n阿片\r\n埃托啡\r\n飞叶子燃料\r\n冰毒提炼教程\r\n甲氧麻黄酮\r\n甲基甲卡西酮\r\n布苯丙胺\r\n二乙基色胺\r\n哌醋甲酯\r\n依他喹酮\r\n唛可奈因\r\n苯环利定\r\n迷幻蘑菇\r\n美沙酮\r\n恩华三唑仑\r\n硝甲西泮\r\n植物冰\r\n二甲氧基安非他明\r\n三甲氧基安非他明\r\n巴比妥\r\n溴西泮\r\n奥列巴文\r\n哌腈米特\r\n吗啡\r\n右丙氧芬\r\n古可叶\r\n甲基乙基酮\r\n朝鲜冰\r\n麻古配方\r\n罂粟碱\r\n摇头丸制作方法\r\n脱氧麻黄碱\r\n黄牙签\r\n森西大芽\r\nweed叶子\r\n氯胺酮制作方法\r\n咕噜壶\r\n溜冰壶\r\n吸毒冰壶\r\n钻石冰\r\n朝鲜冰\r\n黄冰\r\n飞叶子\r\n纯缅麻古\r\n冰毒的制作方法\r\n沙菲片\r\n福寿膏\r\n麻果壶\r\n迷糊蘑菇尼\r\nweed燃料\r\n自制K粉教程\r\n冰妹陪玩\r\n麻古壶\r\n飞行员燃料\r\n白粉妹陪玩\r\nweed种植\r\n警官证\r\n军官证\r\n户口本\r\n工作证\r\n国安证\r\n行驶证\r\n证件\r\n英语等级证\r\n假言正\r\n假卫生许可证\r\n假退伍证\r\n假会计证\r\n假牌照\r\n士兵证\r\n居民户口本\r\n军人证\r\n高仿证\r\n警察证\r\n假文凭\r\n高仿学位证\r\n假结婚证\r\n高仿户口本\r\n假户办证公司网\r\n办证刻章公司\r\n证件制作网\r\n真实民办学历\r\n高仿证件网\r\n汇乐教育\r\n东南亚证件集团\r\n本地办证网\r\n假毕业证在哪里办\r\n高仿学位证多少钱\r\n网上办证学历\r\n刻章办证公司\r\n专业办证公司\r\n文凭代办网\r\n办证刻章\r\n办证网\r\n证件网\r\n办证服务公司\r\n假身份证\r\n高仿身份证\r\n假军官证\r\n军官证样本\r\n学历证书\r\n假证件\r\n国外文凭\r\n假车牌\r\n军车套牌\r\n假出生证\r\n毕业文凭\r\n假学士学位\r\n四六级证书\r\n毕业证书\r\n会计师证\r\n资质证书\r\n假职业资格证\r\n机动车登记证\r\n假死亡证明\r\n假特种操作证\r\n驾驶证\r\n记者证\r\n言正\r\n驾照\r\n公文\r\n护照\r\n车辆牌照\r\njia币\r\n假钞\r\n假币\r\n钞票\r\n纸币\r\n硬币模具\r\n高仿钞\r\n高仿人民币\r\n假钱\r\n伪钞\r\n伪币\r\n硬币\r\n假币模具\r\n假rmb\r\n假钱官网\r\n假钱货源网\r\n假钞货源网\r\n黑市集团看货网站\r\n假币货源网\r\n正规真票\r\nfa票\r\n发票\r\n发嘌\r\n发缥\r\n发剽\r\n发漂\r\n土木工程发票\r\n哪里可以弄到正规发票\r\n开宿迁咨询费\r\n代开建材票\r\n100%真票\r\n机打发票\r\n普通增值税发票\r\n仿真发票网\r\n开票公司代理\r\n百分百真票\r\n哪里可以开票\r\n开票公司\r\n上海开票公司\r\n代理开票公司\r\n发嘌\r\n代办发票公司\r\n发漂\r\n发缥\r\n发剽\r\n代理发票公司\r\n医疗设备费发票\r\n装修费发票电微\r\n轴承不锈钢发票\r\n卧底窃听软件\r\nxwodi软件\r\n手机定位监听软件\r\n手机监听设备\r\n手机GSM监听设备\r\n监听器软件\r\n手机007间谍软件\r\n偷听软件\r\n监听软件\r\n手机卧底监听软件\r\n潜伏者手机监听软件\r\n手机偷听软件\r\n手机监听定位软件\r\n手机远程卧底软件\r\n手机监控软件\r\n手机偷听器软件\r\n手机X卧底软件\r\n安卓手机卧底软件\r\n手机窃听软件\r\n手机远程监控软件\r\n移动电话卧底软件\r\n智能偷听软件\r\n手机卧底软件\r\n卧底监控软件\r\n手机间谍软件\r\n手机监听软件\r\nx卧底软件\r\nspyera软件\r\n特洛伊卧底软件\r\n卧底定位软件\r\n手机监听王\r\nGSM监听设备\r\n烈鹰手机监听\r\n手机监听官网\r\nlurker软件\r\nX卧底\r\n特洛伊卧底软件官方网\r\nx手机卧底软件官网\r\n报仇公司\r\n找人报仇网\r\n帮人复仇\r\n打手网\r\n杀手网\r\n找杀手公司\r\n报仇公司\r\n报仇网\r\n雇人制造意外\r\n专业报仇网\r\n帮忙报仇免定金\r\n提供打手\r\n帮人复仇网\r\n替人报仇网\r\n雇打手网\r\n替人报仇\r\n买凶杀人\r\n替人复仇\r\n雇人复仇\r\n替人追债\r\n替人出气\r\n帮人出气\r\n找职业杀手\r\n替人消灾\r\n职业报仇\r\n专业报仇\r\n替人了仇\r\n帮人报仇\r\n秃鹰内脏全套\r\n高考答案\r\n四六级考中答案\r\n防屏蔽耳机\r\n反屏蔽考试作弊设备\r\n自考考前答案\r\n考试答案\r\n考试作弊器\r\n考试作弊设备\r\n考中答案\r\n中考考中答案\r\n高考考中答案\r\n考试题\r\n无线电作弊器材\r\n中考考前答案\r\n高考考前答案\r\n国考答案\r\n考研答案\r\n公务员考试答案\r\n英语等级考试答案\r\n针孔作弊器\r\n考试作弊工具\r\n考前答案\r\n四六级答案\r\n反屏蔽考试设备\r\n考试作弊器材\r\nTK发射器\r\n云六橡皮科技有限公司\r\n无人值守发射器\r\n橡皮擦短信接收器\r\n成人高考考前答案\r\n枪手网站\r\n枪手替考\r\n四六级替考\r\n四六级助考\r\n替考网站\r\n英语替考\r\n云六橡皮擦\r\n军用折叠弩\r\n军用弓弩\r\n追风弓弩\r\n弓弩\r\n二手弩\r\n小飞狼弩\r\n战神弓弩\r\n力斯曼弩\r\n折叠手弓弩\r\n弩箭\r\n军用钢珠弩\r\n手弩\r\n踏弩\r\n阻击弩\r\n弩枪\r\n十字弩\r\n钢弩\r\n狩猎弩\r\n警用弩\r\n大黑鹰弓弩\r\n黑曼巴弩\r\n三利达弓弩\r\n赵氏弓弩\r\n眼镜蛇弩\r\n进口弓弩\r\n弩弓\r\n秦氏弓弩\r\n森林之狼弓弩\r\n反恐弩\r\n军用弩箭\r\n猎豹弓弩\r\n森林之鹰\r\n小飞狼\r\n森林之狼\r\n气枪弩\r\n精品弓弩\r\n弩弓制作图纸\r\n黑森林弓弩\r\n三健弓弩\r\n弓弩麻醉箭\r\n麻醉枪弩\r\n手枪弩\r\n钢珠弩\r\n枪弩\r\n小黑豹2005A\r\n猎豹M4\r\n麻醉弩箭\r\n弩\r\n气弩\r\n麻醉弩枪\r\n打狗箭\r\n十字弓弩\r\n森林之虎\r\n猎弩\r\n军用弩\r\n麻醉箭弩\r\n三利达追月\r\n三利达大黑鹰\r\n麻醉弩\r\n麻醉弓弩\r\n八方狩猎论坛（福州）\r\n弓弩网\r\n弩弓官网\r\n三利达官网\r\n赵氏猎鹰弩官方网站\r\n猎鹰弩官网店\r\n弩弓店\r\n弓弩官网\r\n驽专卖网\r\n驽弓专买网\r\n新一代弓弩官方网站\r\n正品弓弩旗舰店\r\n弓弩狩猎网\r\n风云打猎论坛\r\n弓驽专卖网\r\n中国弩弓网\r\n森林之虎\r\n大黑鹰\r\n三利达\r\n弓弩维修网\r\n弩商城\r\n名弩网\r\n名弩商城\r\n落日弓弩官网\r\n逐鹿弓弩官网\r\n中国传统猎法狩猎论坛\r\n弩弓网\r\n打狗箭网\r\n八方狩猎论坛\r\n打猎论坛\r\n弓弩专卖网\r\n赵氏弓弩有限公司\r\n银行卡生成器\r\n最新银行卡复制器\r\n磁条数据\r\n信用卡复制器\r\n银行卡\r\n银行卡复制器\r\n磁道内码\r\n黑卡\r\n银行卡磁条\r\n信用卡磁条\r\n借记卡磁条\r\n磁道信息\r\n储蓄卡\r\n银行卡解码器\r\n磁条信息\r\n银行卡号信息\r\n信用卡\r\n借记卡\r\n银联卡\r\n磁道内码信息\r\n网络电视棒\r\nUSB电视棒成人版\r\n成人影视棒\r\n高清3d成人电视棒\r\n高清成人电视棒\r\n3D网络电视棒成人版\r\n成人3d电视棒\r\n成人3d网络电视棒\r\n成人AV电视棒\r\n成人电视棒\r\nAV电视棒\r\n成人版电视棒\r\n客户数据\r\n客户信息\r\n老年人资料\r\n联通客户资料\r\n楼盘业主名单\r\n楼盘业主资料\r\n期货客户资料\r\n全球通用户资料\r\n收藏品客户资料\r\n收藏品数据\r\n顺丰快递数据\r\n网购数据\r\n网购客户资料\r\n物流客户资料\r\n信用卡客户资料\r\n学生家长资料\r\n业主身份信息\r\n业主身份资料\r\n业主信息\r\n业主资源\r\n业主资料\r\n银行卡用户资料\r\n银行开户数据\r\n宅急送数据\r\n电信用户资料\r\n股民联系方式\r\n客户名单\r\n法人数据\r\n高消费人群名录\r\n小区业主名录\r\n金融客户资料\r\n男性数据\r\n股民资源\r\n股民资料\r\n家长资料\r\n家长数据\r\n保险客户名录\r\n保险客户资料\r\n毕业生简历\r\n车主信息\r\n车主名录\r\n车主资料\r\n股民个人资料\r\n股民开户数据\r\n股民名录\r\n股民信息\r\n户主信息\r\n金融客户资源\r\n考生资源\r\n客户资料\r\n老板通讯录\r\n老年人信息\r\n楼盘业主数据\r\n落榜考生名单\r\n女性数据\r\n女性资料\r\n拍拍用户资料\r\n期货客户名单\r\n期货客户资源\r\n社保资料\r\n顺丰面单数据\r\n物流客户数据\r\n学生档案\r\n学生家长名单\r\n业主名单\r\n银行卡用户信息\r\n银行客户名录\r\n婴儿信息\r\n富豪数据\r\n高考学生信息\r\n股民电话号码\r\n股民电话资源\r\n股民个人信息\r\n别墅业主信息\r\n车主资源\r\n电视购物名录\r\n电视购物资源\r\n法人资料\r\n房主数据\r\n房地产客户资料\r\n服刑人员资料\r\n学生家长名录\r\n车主数据\r\n保健品客户资料\r\n保险客户名单\r\n客户资源\r\n老板手机号码\r\n老年人数据\r\n老人资料\r\n学生数据\r\n学生资料\r\n物流成单数据\r\n电购资料\r\n开户资源\r\n银行客户名单\r\n高考学生资料\r\n小区业主资料\r\n车主保险数据\r\n小区业主信息\r\n企业老板资料\r\n老板资料\r\n股民数据\r\n老人数据\r\n银行客户数据\r\n高考考生资料\r\n车主信息资料\r\n保健品数据\r\n电视购物数据\r\n快递面单数据\r\n快递面单资料\r\n业主数据\r\n贷款客户名单\r\n电视购物资料\r\n保险客户数据\r\n进线数据\r\n小区住户资料\r\n小区业主名单\r\n股民开户资料\r\n金融客户数据\r\n户主资料\r\n考生数据\r\n电购面单数据\r\n电购数据\r\n法人手机号码\r\n犯人数据\r\n富人数据\r\n富人信息\r\n富人资料\r\n高官名录\r\n股民名单\r\n自制烟花\r\n礼花弹\r\nshen源\r\n唯美人皮面具网\r\n人皮面具实体店\r\nGFX面具\r\n美女连体人皮面具产品\r\n乳胶人皮面具\r\n仿真硅胶面具\r\n硅胶人皮\r\n人皮面具\r\nGFX面具\r\n硅胶面具\r\n高仿真人皮面具\r\n易容面具\r\n高仿真脸皮\r\n香港牛魔王管家婆彩图\r\n博狗集团\r\n双赢彩票网\r\n7彩27\r\n六合公益论坛\r\n三肖中特期期准免费\r\n王中王铁算盘开奖\r\n3438铁算盘开奖\r\n铁算盘一句解特马\r\n博彩送彩金网址\r\na8娱乐平台\r\n云博国际娱乐\r\n白小姐一肖中特马\r\n白小姐中特玄机图\r\n4887铁算盘开奖\r\n淘金盈国际娱乐\r\n正彩娱乐\r\n皇冠平台\r\n香港惠泽社群\r\n六合心水论坛\r\n神算子中特网\r\n送码图\r\n玄机诗\r\n送码诗\r\n必中特码\r\n特码诗\r\n新报跑狗图\r\n下彩彩票\r\n竞彩足球比分直播\r\n趣彩彩票手机版\r\n澳客网\r\n澳客网比分直播\r\n球探网\r\n球探网即时比分\r\n47333香港财神网\r\n金财神网站\r\n111六合彩主论坛\r\n第一心水论坛\r\n买料卖料网\r\n杏彩娱乐官网\r\nK彩娱乐平台\r\n必博在线娱乐\r\n王中王玄机\r\n捷报比分网\r\n166888导航\r\n九州国际娱乐注册\r\n美人鱼娱乐国际网站\r\n曾道人中特网\r\n奇人中特网\r\n香港赛马会\r\n金财神玄机网\r\n利来国际娱乐平台\r\n中后付款\r\n博彩心水\r\n中特网\r\n皇冠国际投注网手机版\r\n香港最准一肖一码\r\n白小姐中特玄机449999\r\n2017挂牌全篇最完整篇\r\n香港挂牌正版彩图\r\n东方心经马报资料2017\r\n381818白小姐一肖中特\r\n中彩堂\r\n诺亚平台\r\n香港彩霸王\r\n爱赢彩票\r\n彩改单\r\n顺8娱乐\r\n4887铁算盘开奖结果\r\n33374财神网站开奖\r\nww3374财神资料网站\r\n今晚六给彩开奖结果\r\n123kjcom手机开奖结果\r\n98彩票官方网站\r\n2017香港开奖现场直播\r\n168开奖现场\r\n手机最快开奖现场直播\r\n手机看开奖233kjcom\r\n手机看开奖找1616kjcom\r\n看开奖结果找1616kjcom\r\n16799kj手机开奖结果\r\n手机开奖找777588kjcom\r\n777588kjcom现场直播亅\r\n手机看开奖777588kicom\r\n3608kjcom开奖直播现场\r\n手机开奖找1616kjcnm\r\n手机看开奖找233kjcom\r\n4887铁算盘四肖中特\r\n六合资料大全\r\n四肖八码免费长期公开\r\n233kjcom手机最快开奖l\r\n天下彩免费资料大全\r\n香港牛魔王管家婆彩图i\r\nm3608kj手机看开奖结果\r\nm233kjom手机开奖结果\r\n茗彩娱乐\r\n金牛国际线上娱乐官网\r\n香港开奖结果历史记录\r\n查看六肖\r\n四肖期期准摇钱树心水\r\n本港台开奖现场直播室1\r\n949494开奖结果今晚\r\n493333王中王免费提供\r\n三肖中特期期准黄大仙\r\n六合皇冠彩票\r\n金马堂\r\n太湖字谜\r\n晚秋和值谜\r\n丹东一句定三码\r\n乐彩论坛\r\n牛彩网\r\n排三试机号\r\n超级大乐透\r\n金码走势图\r\n易彩在线\r\n香港六合伯乐\r\n财神报码\r\n通博彩票网\r\n亚洲赌博娱乐平台\r\n海燕策略研究论坛\r\n博久策略论坛\r\n六合玄机\r\n一码中特\r\n嘻嘻撸\r\n99bt工厂\r\n山柳村的寡妇情史\r\n清风不独眠\r\n诱欢，误惹纨绔军痞\r\n宠妃撩人：王爷爱来暖床\r\n黑道总裁独宠残妻\r\n囧囧法师综漫游\r\n小月阿姨\r\n欲魔艳史\r\n风流花少\r\n龙战士传说\r\n大陆港台演艺圈明星系列\r\n秀色直播\r\n妓初屋\r\n姐也色\r\n台湾妹中文网\r\n美国十次撸\r\n第三书包网\r\n夜夜必搜\r\n凤姐导航\r\n恋幼阁\r\n呦呦王朝\r\n我爱幼幼\r\n爱幼网\r\n51呦吧\r\n色迷谜中文社区\r\n狠恨干\r\n淫落公主\r\n我的爆乳巨臀专用肉便器\r\n轮x毕业旅行\r\n热热网\r\n撸色逼\r\n撸撸踏\r\n得得村\r\n性奴美母\r\n都市品香录\r\n爽爽啪\r\navtt天堂\r\n撸白金\r\n恋上嫂子的床\r\n抚玉\r\n久久鲁\r\n日本撸多宝\r\n淫民色色\r\n淫图\r\n裸聊\r\n逃亡艳旅\r\n江湖淫娘传\r\n金麟岂是池中物\r\n焚天愤天淫魔阴魔\r\n激情视频聊天室\r\n撸撸碰\r\n撸弟弟\r\n狂野美色\r\n妖女榨汁\r\n搞色网\r\n撸中撸\r\n哥哥碰\r\n暴露女友\r\n天龙风流之替身段誉\r\n色空阁\r\n7tav在线视频\r\n最原始欲望\r\n花都秘语\r\n花间浪子\r\n色久久桃花综合\r\n遍地诱惑\r\n仲夏梦之女配\r\n斯文禽兽\r\n神龙仙缘\r\n色天使色偷偷\r\n五月香福利网\r\n聚色网\r\n撸师爷\r\n嗨皮鲁\r\n撸撸爽\r\n穿越天龙八部之风流虚雨\r\n咪咪碰\r\n色必射\r\n夜夜插\r\n哥必操\r\n撸妹子\r\n色蝴蝶\r\n四房色\r\n色必撸\r\n淫嗖嗖\r\n撸撸黄\r\n搞色网影院\r\n暗暗鲁\r\n天天射影视\r\nAV社区\r\n射了撸\r\n上错电梯进错门\r\n我妻小雅\r\n女色网\r\n撸友网\r\n安子轩撸\r\n俺去撸\r\n久久加热视频哪里\r\n热中文热国产热综合\r\n色色资源站\r\n夜色王朝论坛\r\n淫欲阁\r\n乡村的诱惑\r\n色尼玛\r\n热热撸\r\n风流小警察\r\n性都花花世界网\r\n藏姬阁\r\n骆冰霪传\r\n草榴导航\r\n父皇哥哥们爱我\r\n影音先锋资源男人站\r\n狠狠社\r\n后宫群芳谱\r\n乡村艳事\r\n玉色阁\r\n草榴社区\r\n溜溜看片\r\n撸在线视频\r\n夜撸在线影院\r\n色人格影院\r\n男人书城\r\n情欲两极\r\n无翼鸟漫画全集之小恶魔\r\n凌辱学校\r\n痴汉电车\r\n狼后传奇\r\n红杏社区\r\n牛B叉\r\n邪情花少\r\n黑日撸\r\n涩涩网\r\n撸姥姥\r\n狼国成人网\r\n嗨嗨撸\r\n催眠眼镜\r\n放荡教师妈妈\r\n十口井\r\n妖宠\r\n飘飘欲仙\r\n西北大通炕\r\n犬交兄弟\r\n暗黑下品\r\n大侠魂之花间浪子\r\n狐媚\r\n玩火\r\n《花落伴官途》\r\n天涯帝王\r\n冷淡经理求欢身下记\r\n就去射\r\n淫淫网\r\n午夜爽片\r\n成人电子书?\r\n淫妻俱乐部\r\n天龙八部淫传\r\n色中色论坛\r\n现代艳帝传奇\r\n星光伴我淫\r\n我的性启蒙老师\r\n东方在线AV\r\nAV发电站\r\n就爱啪啪官网\r\n欧美AV怡春院\r\n好吊日AV在线视频\r\n日本毛片基地\r\n丝足伊人\r\n1024BT核工厂\r\n女官韵事\r\n咪咪影院\r\n撸射网\r\n撸撸管在线\r\n亚洲久草色鲁鲁\r\n亲亲草鲁鲁在线\r\n亚洲鲁鲁射\r\n国产日a在线\r\n医院里的淫虐盛宴\r\n夜来香社区\r\nH漫\r\n都市少妇的沉沦\r\n日日嫂\r\n4虎影库\r\n大色堂\r\n日夜撸\r\n清淫苑\r\n色无极影院\r\n七七色原网\r\n好撸网\r\n撸妹妹\r\n春色阁\r\n日日射\r\n品色堂\r\n色大姐综合网\r\n巨棒出击\r\n与兽缠绵\r\n兩穴姦\r\n宅男神奇影院\r\n18禁漫画\r\n玲珑孽缘\r\n乱云少妇\r\n幼色窝\r\n85st\r\n先锋av\r\n合欢宫记事\r\n豪门风流史\r\n壹哥撸播放器\r\n遮天有爱番外篇之梵仙篇：怒空摘星\r\n琪琪色原网\r\n都市淫狐传\r\n小米的性玩具羞辱日记\r\n青春之放纵高H\r\n情欲超市\r\n极品丝袜小说集合\r\n禁品乱欲\r\n蝌蚪窝在线视频\r\n王老撸26uuu\r\n春乱香野\r\n鲁大妈成人色情视频\r\n约啪秀\r\n玉女阁\r\n蚊香社\r\n朱颜血\r\n风流岁月\r\n淫荡女秘书\r\n魔卵公主\r\nABO之强制受孕\r\n风流艳侠传奇\r\n羽衣传说\r\n小熊的性事\r\n风流教师\r\n天欲神功\r\n步兵撸在线\r\n第一会所论坛\r\n女警文洁\r\n绿帽文经典大合集\r\n哥去爱\r\n得得啪\r\n爽爽撸\r\n哥去吻\r\n嗷嗷啪\r\n沉欲之小西的美母教师\r\n人妻教师的淫情地狱\r\n美人沟一窝驴\r\n乡村乱情\r\n警花白艳妮\r\n仕舞妻\r\n乡村春潮\r\n武汉夜网\r\n春暖花开性吧有你\r\n夜夜笙歌之强要绝色小奴\r\n撸撸鸟AV\r\n射她淫B網\r\n年轻的母亲3高清中字\r\n男女的命相在线观看\r\n火辣监狱完整版下载\r\n五感图完整版\r\n绿色椅子电影完整版\r\n於宇同无主之花在线观看\r\n《勾当2红色骆驼》迅雷下载\r\n哥哥们的玩物\r\n古剑淫谭\r\n红楼梦淫传\r\n乡村野疯狂\r\n少女之心\r\n与家人一起淫乱的日子\r\n岛国影院\r\n骆冰淫传\r\n逍遥父女\r\n色蝎子\r\n哈起码A片\r\n撸一哈\r\n拈花网\r\n哥妹啪\r\n哥也爱\r\n蕾丝兔宝宝\r\n啪啪撸\r\n色五天月\r\n王老撸\r\n色哥撸\r\n总裁爸爸的啪啪啪日常\r\n淫荡女友筱夕\r\nuu论坛\r\n萝莉家园\r\n酒色网\r\n爱色网\r\n狠狠爱夜夜撸\r\n爸射网\r\n涩情网\r\n琪琪涩\r\n校园浪荡史\r\n逍遥阁\r\n涩中涩\r\n床上xoxoxo视频日本\r\n884tt四虎影库大通知\r\n色姐妹插姐姐\r\n久草在线福利资源站久草在线免费视频在线观看\r\n页面升级访问\r\n久草在线福利资源总站\r\n插妹妹a片96\r\n天天啪在线视频\r\n桃花色在线影院\r\n郭美美性爱视频下载\r\n十景缎\r\n倚天屠龙别记\r\n哥哥日\r\n撸踏踏\r\n诱宠萝莉小情人\r\n四大名著成人版精品集\r\n山村美色之韦小宝\r\n快穿之娇花难养\r\n淫荡老师系列\r\nav天堂网\r\n爽爽影片\r\n深爱基情网\r\n哥也射\r\n大色比影院\r\n第二书包网\r\n黄sei\r\n色悠悠\r\n千涩bt核工厂\r\n师生淫乱\r\n快穿之玉体横陈\r\n卧底女侠受辱记\r\n风流成性\r\n久热视频\r\n六色草导航\r\n大公鸡福利导航\r\n柠檬福利导航\r\n毛片综合网\r\n亚洲天堂AV2017\r\n色狼五月综合网\r\n亚洲萌帝国\r\n凹凸AV\r\n小西的美母教师\r\n肉肉小剧场之涌泉洞\r\n警花堕落记\r\n聚色冈网\r\n小雄的故事\r\n思思色集百万\r\n淫男乱女\r\n伊人成人\r\n撸师妹\r\n鲁鲁色\r\n醉地撸\r\n都市逍遥风流记\r\n藏妃阁\r\n风流校医\r\n小M日记\r\n渔港春夜\r\n罪恶都市女警炼狱\r\n娇艳青春之放纵\r\n妈妈的护肤液\r\n淫妻网\r\nUU福利社\r\n撸客综合网\r\n凹凸视频\r\n爱色堂\r\n就去撸\r\n撸一撸\r\n红楼遗秘\r\n骑妹妹\r\n大香蕉网\r\n父女戏春水\r\n情语潮湿\r\n催眠魔手\r\n男人天堂第四色\r\n最高的初体验\r\n风月征途猎美\r\n囚爱玩少女\r\n寡妇村猎美致富记\r\n柳依依雪霏霏\r\n56pao免费在线视频\r\n九爱城\r\n众里寻她千百撸\r\n色人格影视\r\n第七色\r\n色天使影音先锋\r\n周杰撸\r\n快奸\r\n淫人阁\r\n无修\r\n卡片少女召唤脱衣大战\r\n情和欲的两极\r\n开心色情站\r\n怡春园院\r\n正品蓝福利导航\r\n奇幻之国\r\n色你玛\r\n色尼姐\r\n姐也搞\r\n得得日\r\n深夜操\r\n爱撸撸\r\n成都逍遥网\r\n小色比\r\n阴户舔\r\n得得佬\r\n芭普普\r\n色册册\r\n爱上撸\r\n淫色的皇都\r\n大阴户\r\n爱撸色\r\n谷露影院\r\n悠悠资源站\r\n射逼逼\r\n姆姆啪\r\n婷婷网\r\n爱撸吧\r\n爆鸟吧\r\n99av\r\n色鲁鲁\r\n幼幼合集\r\n嘚嘚啪\r\n可可啪\r\n鲁鲁色播网\r\n后宫春色\r\n兰花撸\r\n淫民导航\r\n婷婷五月\r\n狼人阁\r\n色酷色\r\n啵啵网\r\n色你妹\r\n狠狠爱影院\r\n涩悠悠\r\n色哥哥\r\n色奇艺\r\n涩蝴蝶\r\n狠痕撸\r\n人人撸\r\n怡红电影网\r\n色人居\r\n鲁斯屋\r\n鬼畜中出\r\n哥也色\r\n我爱我爱色\r\n色也色\r\n艳情短篇合集\r\n骑妹网\r\n得得爱\r\n夜夜日\r\n色列漫画网\r\n好属曰\r\n1024小草\r\n色七七桃花综合网站\r\n东京热在线视频\r\n爱搞淫妹妹\r\n五姑娘导航\r\n久久6热在线视频\r\n妖媚福利网\r\n欧美哥哥妹妹乱插图\r\n爱媚萝莉\r\n色五哥免费视频\r\n得得爱在线视频\r\n狼客娱乐网\r\n色狼集中营\r\n啪必搜\r\n夜夜橾妹子\r\n色3P\r\n夫妻3P\r\n乱伦之荡艳岳母篇\r\n乡村之大被同眠\r\n我爱呦呦论坛\r\n爱幽幽社区\r\n呦呦同好网\r\n天天色综合区\r\n邪恶少女漫画\r\n借贷宝裸条门压缩包\r\n2016裸条门\r\n裸贷照片合集\r\n金利美影院\r\n快活林论坛\r\n操b网\r\n都市寻艳录\r\n我的性奴老婆\r\n白洁高义\r\n红楼绮梦\r\n重生之春怀缱绻\r\n蝌蚪窝\r\n撸爷网\r\n偷色阁\r\n淫淫碰\r\n纯肉文\r\n撸尔山\r\nav五月色桃色激情\r\n淘精网\r\n秦青的幸福生活\r\n夫妻交换系列\r\n旧年艳曲\r\n东方花园爱唯论坛\r\n一品楼论坛\r\n干岳母影院\r\n猎美玉龙\r\n月亮白的图书集\r\n蹂躏警花柳婷婷\r\n附体记\r\n哥去射\r\n藏色阁\r\n狐狸色\r\n性乐汇\r\n上帝撸\r\n偷撸网\r\n十九楼的爱\r\n我爱呦呦\r\nu15天堂\r\n青青草在线视频\r\n嗷嗷鲁\r\n刀刀撸\r\n播乐子\r\n偷偷色\r\n性趣阁\r\n乱伦王中王\r\n波波撸影院\r\n熬熬撸\r\n荒村活寡留守女人们的春天\r\n91电影网\r\n夜趣福利导航\r\n狂人色导航\r\n夜猫导航\r\n千百撸导航\r\n一点啪福利导航\r\n桃花村上野色多村色无边\r\n源君物语\r\n兽交集合\r\n哥哥射\r\n裸条借贷资源种子\r\n天天色综合网\r\n色笔屋\r\n悠悠综合\r\n日日夜夜撸\r\n四色房\r\n夜夜播\r\n鲁大妈\r\n龙欲都市\r\n淫秽网\r\n好好日\r\n撸天乐\r\n插逼网\r\n集美舍\r\n面瘫社字幕组\r\n欲女阁\r\n色春阁\r\n准夫妻性事\r\n警探姐妹花\r\n小村女人香\r\n纵欲的紫筠\r\n吟语低喃\r\n第一次没穿内衣裤及小穴被插著东\r\n欲妻如肉\r\n色狗影院\r\n爱逼网\r\n关照你的花蕾\r\n仓库里的秘密情事\r\n思思热\r\n夜夜摈\r\n情迷小晚香\r\n邻家少妇\r\n折翼天使\r\n强占之暴王的夜宠\r\n我要的生活[H]\r\n深宅旧梦\r\n色色闷骚男\r\n按摩后我狂插母亲和姐姐\r\n在健身房被教练们轮奸的肉丝老婆\r\n乡村猎艳记\r\n品幼阁\r\n去射网\r\n亚洲色网\r\n乡艳小村医\r\n风月太监采花录\r\n第一版主\r\n刺激撸\r\n肏白虎\r\n任性撸\r\n板扎福利网\r\n十次啦中文网\r\n男人站\r\n8888色大全夜夜骑\r\n肉便器\r\n师娘的诱惑\r\n幽兰露\r\n乡野欲潮绝色村嫂的泛滥春情\r\n小天风流史\r\n腐书网\r\n恶女芙蓉番外篇红茵篇\r\n同涩网\r\n撸飞哥\r\n噜噜射\r\n涩玉撸\r\n撸丝屋\r\n瑞碧综合网\r\n色猫网\r\n噜噜网\r\n我的娇妻\r\n懒女婚嫁记\r\n红杏社区论坛\r\njapanese在线home中国\r\n四虎影视库紧急大通知\r\n老司机精品视lsj\r\n91日逼网\r\n515zy导航\r\n仙人谷导航\r\n第一會所\r\n95撸导航\r\n绿色无毒成人网站\r\n色狼福利导航\r\n极品哥导航\r\n绿加白福利导航\r\n蓝鸟福利导航\r\n点幼阁\r\nJJ福利导航\r\n痴汉导航\r\n1024导航\r\n婷婷激情成年人影视\r\n撸撸撸\r\n疼爱家园\r\n踩踏部落\r\n大学生交换女友\r\n天鹅绒之吻\r\n恋着的她X爱着的她\r\n交个护士女友的方法\r\n黑猫男友的填满方法\r\n妻为谁奴\r\n暗暗撸\r\n北安书网\r\n小姐威客网\r\nfc2免费视频\r\n窝窝色\r\n一介撸夫\r\n情色阁\r\n日本撸十次啦\r\n工口漫\r\n夫妻成长日记\r\n哥哥碰在线视频\r\n射人阁\r\n有码原创\r\n日日色\r\n狠撸撸\r\n哥要搞蝴蝶谷\r\n蜜蜂妖纪\r\n难言之欲\r\n师父不要啊\r\n草柳社区\r\n撸撸侠\r\n孽情桃花村\r\n幼女全集\r\n禾奶绿\r\n出轨的诱惑\r\n沧澜曲\r\n色久久综合网\r\n大色哥导航\r\n东京热N991\r\n草裙社区\r\n色狼窝成人导航\r\n姐夫的七日兽宠\r\n幽幽碧资源站\r\n三日缠绵\r\n山村美色\r\n巾帼红颜:悍妃太嚣张\r\n惩罚的夜晚\r\n嫖父子\r\n禁忌情妇\r\n纯爷们与巧媳妇\r\n乳妾\r\n智姜\r\n红颜劫番外\r\n三级片地址\r\n3级片\r\n2级片\r\n1级片\r\n3ji片\r\n2ji片\r\n1ji片\r\n毛片网址\r\n我想爱爱网\r\n快活林性息论坛\r\n艳母\r\n久久爱网站\r\n爱幼图论坛\r\n风流乱情录\r\n风流老师\r\n大爷射\r\n日夜射\r\n颜射中出\r\n肉欲满堂\r\n工口肉番漫画\r\n色洛洛中文网\r\n桃花族\r\n哥也色中文\r\n小色哥奇米\r\n思思色\r\n知天下资源吧\r\n肉番漫画网\r\n爱必射\r\n上帝撸在线视频\r\n果条资源\r\n好屌妞\r\n榆树湾的故事\r\n落花若雨\r\n一色逼毛片\r\n操操射\r\n姐夫的荣耀\r\n小公主追夫记\r\n吾爱sp乐园\r\n好吊日\r\n色姥姥\r\n恩恩撸\r\n撸在线影院\r\n山野孽债\r\n穿越风流之情深深雨蒙蒙\r\n穿越之还珠风流\r\n手操屄\r\n色木木坏哥哥图片\r\n萝莉城\r\n群交大家族\r\n侍将\r\n捆绑之后再爱你\r\n色色\r\n绝色中出影院\r\n色久久综合网站\r\n我要爱久久影视\r\n无码成人影院\r\n国产A片下载\r\n千白撸\r\n小雄性事\r\n山村猎艳\r\n侠女的悲哀\r\n神雕风流\r\n吟言语色\r\n绿龙红凤\r\n穿越成低档妓女\r\n海盗船宅男\r\n少妇白洁\r\n性奴隶服务公司\r\n乡野春色\r\n乡野春床\r\n私色房\r\n全色网\r\n情燃今生\r\n艳霸后宫天下\r\n中心行里的少妇们\r\n重生富贵公子\r\n贱女淫心\r\n乱情家庭王玉霞\r\n撸一撸导航\r\n姥姥撸成人网\r\n好吊草\r\n英格尔的手扎\r\n郭美美不雅视频种子\r\n嘛淫斛\r\nCL社区\r\n奇摩女孩聊天室\r\n成人阁\r\n萝莉社区\r\n啪啪资源社区\r\n得得的爱\r\n萝莉资源\r\n百性色\r\n极乐宝盒\r\n橾射在线\r\n操幼幼吧\r\n猫色综合\r\n猫咪社区\r\n男人的天堂东京热\r\n山炮香艳乡村\r\n青年调教手册\r\n暗恋师傅的日常\r\n好莱坞艳照门种子\r\n淫人谷\r\n冷情阁\r\n三十岁衰人\r\n红绿江湖\r\n小次郎收藏家\r\n狼人干综合\r\n岛鹿视频\r\n嗯撸撸\r\n聚色伦网\r\n摁摁撸\r\n嗨皮撸\r\n日加撸\r\n插妹妹综合网\r\n我爱插洞网\r\n猫色网\r\n撸撸管在线影院\r\n便器林小薇的污秽人生\r\n阿里布达年代祭\r\n风流村妇的山村野事\r\n清欲超市\r\n色色王国\r\n好骚终合\r\n安子轩色\r\n落花星雨\r\n风月征途\r\n好屌妹\r\n我和妻子江湖行\r\n色色阁\r\n色欲影视\r\n新色区\r\n撸图阁\r\n去干网\r\n得得撸影院\r\n她也撸网\r\n四虎影庫\r\n好操屌\r\n苍井空\r\n撸啵啵\r\n日日爱\r\n撸妹子电影网\r\n簧色大片全黄\r\n安安阁\r\n大色鱼影院\r\nAVlang\r\n操逼逼\r\n龙腾小说网\r\n宝宝穿越记\r\n亚洲性夜夜射\r\n草你综合\r\n呦呦萌帝国\r\n操你啦视频\r\n七七影音先锋\r\n爱色影视\r\n99re在这里只有精品\r\n爱妃网\r\n大学里的五朵淫花\r\n好色村妇\r\n仙剑淫侠传\r\n唯思影城\r\n希灵淫国\r\n绿帽系列\r\n老师轻一点\r\n好屌日\r\n陈皮皮的斗争\r\n心灵家园论坛\r\n邪恶萝莉工口\r\n色我网\r\n狠狠路\r\n美国撸\r\n色克斯5\r\n91福利屋\r\n超色网\r\n爱碧网\r\n佳色网\r\nsex8杂志\r\nAV小四郎\r\n人妻乱伦\r\ngo2av\r\n琪琪热热色原无码\r\n我爱avhoe01\r\n爽歪歪视频网站\r\n色久久综合桃花网\r\n97超碰社区\r\n好屌妞视频\r\n色嫂嫂\r\n狼色淫窝\r\n妮妮撸\r\n爽撸撸\r\n炸天鲁\r\n司空论坛\r\n裸条门全套资源\r\n用爱调教\r\n绝配娇妻小秋\r\n天使的淫落\r\n美国十次啦\r\n桃花色影院\r\n第四色空婷婷\r\n人人色在线视频\r\n撸儿园\r\n摇乐子\r\n机机干\r\n撸色宝\r\n色库全书\r\n九色腾\r\n双重快感\r\n女奴网\r\n革命逸事\r\n欲望少年期\r\n宠眷的稚齿情人\r\n交通淫色\r\n淫水狂流\r\nA9AV红番阁\r\n品幼宫\r\n红灯综干区\r\n美女犬系列\r\n缚美传\r\n马小虎的放荡生涯\r\n孽障\r\n山村情事\r\n阿木小说网\r\n狠很射\r\n狠狠橹\r\nav小次郎\r\n华人网上乐园\r\n五月丁香网址\r\n涩涩爱夜夜撸社区\r\n85街\r\n淫色谷\r\n狠鲁鲁\r\n啪酷酷\r\n红番阁\r\n囡囡色\r\n骑骑射\r\n妹妹爱上蜜桃\r\n一色屋视频\r\n骑兵射区\r\n女肉畜俱乐部\r\n史莱姆契约公主\r\n魔法少女小爱\r\n夜操逼\r\n狠痕橹\r\n狼国色\r\n夜色撸\r\n白白色在线\r\n撸嗷嗷\r\n淫狼窝\r\n哥要搞影院\r\n春暖花开性吧\r\nyeye撸\r\n奇米影院\r\n暴爽撸片\r\nav撸\r\n她也色在线\r\n我老婆的两个表妹\r\n女偶像私下的淫荡生活\r\n丽图天堂\r\n耕不完的女人\r\n小萝莉论坛\r\n呦呦论坛\r\n老鸭窝视频\r\n野兽眷恋的百合香\r\n神雕云雨\r\n1024基地\r\n村官艳满杏花村\r\n幼幼论坛\r\n萝莉资源论坛\r\n花都太子\r\n女文工团员最后的下落\r\n都市娇妻之美女后宫\r\n制服侵略之浸淫蓝天\r\n色友霸三国\r\n禁忌之旅\r\n开心小色网\r\n裙下臣之万人拥宠\r\n小白兔的蜕变史\r\n爹爹我要和你双修\r\n淫荡家家酒\r\n卿本风流\r\n豪门少爷猎艳记\r\n农门辣妻\r\n他也撸网\r\n豪欲家族\r\n姐脱\r\n情色电影\r\n红潮情色网\r\n你全家都是肉文女主\r\n亿性家\r\n夜里干\r\n寂处阁\r\n都市小钢炮\r\n色幼阁\r\n色奶奶偷偷撸\r\n绝色导航\r\n第一福利导航\r\n第七色综合网\r\n救国论坛p2p\r\n肉文小说网\r\nMCC色站\r\n淫民共和国\r\n免費線上A片\r\n後宮情色av網\r\n后宫视讯情色网\r\n远古狂情\r\n人贩王五系列\r\n性奴小洁的日记\r\n武林盟私密记事\r\n海上弄菊记\r\n孽伦情缘\r\n成熟淫乱的家庭美妇\r\n第七色影院\r\n夜夜射\r\n色之阁\r\n桃花色综合网\r\n桃隐社区\r\n嫖妓系列\r\n亚洲桃色网\r\n一骑欢色网\r\n得哥撸\r\n撸入口\r\n热热鲁\r\n太子撸\r\n华娱性都花花世界\r\n淫爱网\r\n天天日\r\n1024核工厂\r\n鲁鲁涩\r\n征服美艳的护士妈妈\r\n色婷阁\r\n坑爹的一妻多夫\r\n漂亮妈妈王艳的故事\r\n销魂艳婢\r\n用身体说爱\r\n梦龙Y传\r\nT大校花沉沦记\r\n春满香夏\r\n霸占全村美妇山村美娇娘\r\n换母俱乐部\r\n淫梦\r\n御女天下\r\n四大名著成人版\r\nav撸色soso\r\nntrfun\r\n御女阁在线视频\r\n人人摸\r\n色狼窝\r\n兔兔体验网\r\n蝴蝶谷娱乐\r\n小熊性事\r\n高树三姐妹\r\n醉也撸\r\n歪歪色\r\n得得搜\r\n辣文网\r\n撸先锋\r\n日夜肏\r\n恨恨鲁\r\n四次郎\r\n老色哥网\r\n撸飘飘影院\r\n依依情色网\r\n嗯嗯撸\r\n狠狠碰\r\n哥哥啪\r\n炸天撸\r\n淫色淫香\r\n日韩撸片\r\n聚色伦\r\n撸必射\r\n唐人社电影\r\n123操逼网\r\n看喔噜\r\n私人会所：富豪私生活\r\n我和美女同事的那些事儿\r\n萌幻之乡\r\n亚洲色站\r\n成人电影\r\n乡村美娇娘\r\n撸撸鲁射\r\n第四色播播\r\n性吧网电\r\n性吧杂志\r\n狠狠噜\r\n吉吉撸\r\n盛世淫风录\r\n妞妞五月天\r\n紫仙秀\r\n草樱免费av在线\r\n撸之撸\r\n撸撸社\r\n撸撸看\r\n爱上丝宝论坛\r\n好席妞\r\n色妹妹導航\r\n你弟撸\r\n逍遥花都百香宫\r\n文革监狱乱伦\r\n日日射日一日\r\n美妙人妻系列\r\n恋夜影院\r\n色七七亚洲AV\r\n风流乡村\r\n夜撸吧影院\r\n撸妹子在线影院\r\n操嫩B电影网\r\n热热色原站\r\n撸一撸在线影院\r\n多加撸\r\n恋夜秀场\r\n插插插综合网\r\n射一嘴\r\n幼人阁\r\n迷乱禁忌\r\n娇妻与爱女\r\n爱似流火\r\n魔魅\r\n色中色影院\r\n恋足电影\r\n母子乱伦\r\n撸管网\r\nyeye撸在线影院\r\n大色窝\r\n欲望列车\r\n女生宿舍506\r\n杨野的禁脔\r\n撸匹夫\r\n撸骑阁\r\n快播爽吧\r\n同色网\r\n俺去色\r\n首撸影城\r\n大色鱼\r\n色吧社\r\n欲香屋\r\n操干妈\r\n景鲁阁\r\n壹哥擼\r\n哥也搞\r\n色姐妹综合网\r\n草碧第一区\r\n超碰吧\r\n哥去射中文网\r\n嗷嗷啪影院\r\n狠噜噜\r\n噜一噜\r\n狠痕撸2015\r\n沑沑啪\r\n涩欲撸\r\n久久资源站\r\n思思啪\r\n色必爱\r\n脚操者\r\n射射网\r\n不撸网\r\n偷香\r\n永乐町69号\r\n激情雪色\r\n公子绿\r\n楠楠的暴露\r\n红杏家园\r\n秋日天空\r\n妻孝\r\n一库福利导航\r\n色就是色\r\n色五月\r\n爱草成人\r\n深爱激情网\r\n鹿镇逸事\r\n不良教授之欢乐生活系列\r\n鲁二哥男人\r\n365日稳定更新\r\n绿色华人视频\r\n开心五月五月深深爱\r\n惩罚军服系列\r\n5510a成人网\r\n亚洲OXOX情色网\r\n第九色激情网\r\n久久色\r\n嘻嘻色\r\n马色堂社区\r\n爱色阁影院\r\n聚色冈\r\n撸巨基\r\n纯爷们x\r\n鲁琪阁\r\n色狗狗中文综合网\r\n色狼岛\r\n97色中阁\r\n色你姐\r\n成人色情\r\n色色偶\r\n大黑吊\r\n坏嫂嫂\r\n宬人电影网\r\n四色阁\r\n色屌爽\r\n三千美娇娘之纵欢\r\n都市夜语\r\n乡村欲孽\r\n老鸡窝在线\r\n陷入H游戏\r\n牛b叉AⅤ欧美\r\nAV天堂A\r\n可乐操在线视频\r\n色狼狈集中营\r\n逍遥宫论坛\r\n操逼网\r\n发发操\r\n岳不撸\r\n撸女神\r\n色你我\r\n撸撸睡\r\n色色谷影院\r\n超碰网\r\n很很射\r\n赤裸色宫\r\n天天好逼网\r\n恒润影院\r\n狠狠爽\r\n爱色岛\r\n华娱情色网\r\n西门庆导航\r\n江湖淫娘\r\n水浴晨光\r\n撸撸射\r\n师傅搞tv\r\n色播网\r\n色撸橹\r\n百岁撸\r\n爸爸去撸\r\n奇艺色\r\n生奸中出\r\n明星凌辱系列\r\n银鸾学院\r\n少年的肉玩具\r\n可爱女友和她的家人被轮奸调教\r\n咔得撸\r\n邪琉璃神社\r\n门房秦大爷的故事\r\n蜜桃95撸管天堂\r\n波波撸\r\n欲色屋\r\n聚色阁\r\n蟑螂社区\r\na漫集散地\r\n玖玖资源\r\n就是色影院\r\n全裸自拍表演\r\n女扮男装坐江山\r\n亿性家·\r\n女公务员的日记\r\n老色哥68vvv\r\n得得啪尼尼撸\r\n抱妹妹a片网\r\n媚媚的幸福生活\r\n采花团\r\n来吧综合网\r\n骚麦\r\n撸妞妞\r\n不良少女日记\r\n性吧之声\r\n一品楼\r\n草驴社区\r\n性8春暖花开\r\n四房色播影音先锋电影\r\n久久热在线\r\n妈妈的乱欲故事\r\n仙童下地狱\r\n苍老师的超时空双飞之旅\r\n叉叉叉综合网\r\n韩国撸\r\n手淫屋\r\n星空男孩\r\n妄想系列\r\n性感的美腿女神（合集）\r\n卵蛋网\r\n敌缘\r\n借贷宝10g压缩包\r\n女大学生裸贷照片合集\r\n香港风流之电影大亨\r\n绿帽奴论坛\r\n乱奸警妞\r\n红杏暗香\r\n好日日网\r\n邪恶少女漫画之熟睡中的姐姐\r\n邪恶少女漫画之单人双打\r\n乃汁包治百病，药到病除\r\n放课后h放课后濡湿的制服\r\n青楼骚货养成日记\r\n爱萝莉社区\r\n撸管天堂\r\n恋宅屋\r\n乡村精品h文合集\r\nyy小说网\r\n东凛30p无码\r\n米奇在线影院在线视频\r\n鲁大爷在线视频\r\n鲁大妈色情网在线视频\r\n免费视频播放器女人\r\n宜春院射死你天天日\r\n桃花阁在线视频\r\n浪情侠女\r\n无敌YY之猎艳后宫\r\n藏姬阁在线导航\r\nGAV在线视频\r\n琪琪热热色原AV\r\n久久播\r\n男人天堂网新地址\r\n怡红院电影论坛\r\nA9影院\r\n佛佛撸\r\n踏踏撸\r\n额要撸\r\n色撸撸影院\r\n第四色影院\r\n色咪咪\r\n兽奴的幸福生活\r\n和嫂子同居的日子\r\n乡野春事\r\n色诱王道\r\n婚婚欲醉\r\n赤裸娇妻\r\n黄警官沦陷记\r\n干一炮爱上你\r\n杜尚论坛\r\n秋色之空\r\n撸特特\r\n撸佳佳\r\n也好波\r\n五月天激情网\r\n额来撸\r\n额多撸\r\n天天射\r\n王爷和长工的啪啪\r\n轮奸\r\n色比影院\r\n玉不撸\r\n猎艳谱群芳\r\n亚洲人妻伦理\r\n犀利体福利网\r\n兼职妹妹\r\n丝袜美女\r\n肉文\r\n得得日\r\n得得色\r\n色尼玛综合网\r\n嗷嗷啪在线影院\r\n色天使论坛\r\n寻乐论坛\r\n龙腾小说网\r\n紫色蜜桃网\r\n性息平台\r\n夜射猫\r\n奇热色\r\n首撸影城\r\n搞色网\r\n爱色岛\r\n空空撸\r\n第四涩\r\n撸必搜\r\n色璱虎\r\n色偶偶影院\r\n两位艺术系女生的大学生活\r\n好屌色\r\n聚色客\r\n晚晚干\r\n色色男\r\nav撸\r\n撸儿所\r\n聚色伦网\r\n青瓜妹\r\n撸撸妻\r\n撸大客\r\n偶夜网\r\n夜色阁\r\n狠狠啪\r\n亚洲无码转帖区\r\n天天色网\r\n撸骑阁社区\r\n俄罗斯幼嫩av\r\n夜夜干\r\n窝窝色\r\n狠狠草\r\n琪琪色原网站\r\n千花坊论坛\r\n全色资源站\r\n97资源站\r\n性盈盈在线影院\r\n肉感继母奸淫录\r\n淫源物语\r\n撸到爆\r\n楼凤信息\r\n久久热青青草\r\n奇米成人社区\r\n肉欲山庄\r\n露思屋\r\n星飞色\r\n人人色\r\n轻轻射\r\n看我撸\r\n丐帮情色论坛\r\n伊人在线大香蕉\r\n肏骚屄\r\n蛋尽良绝\r\n佳色网\r\n色木木\r\n哥哥色\r\n哥去色\r\n俺也去\r\n娜娜啪\r\n肉漫\r\n色姐妹插姐姐\r\n人人操\r\n晓晓影院\r\n旺旺撸\r\n豆豆色\r\n淫老婆影院\r\n七七色\r\n天天射av综合网\r\nav狠狠干爱橾射在线\r\nAV网址\r\n奇奇色\r\n荷包网\r\n书包网\r\n哪里有小姐\r\n依依社区\r\n加多撸影院\r\n大香蕉伊人久草\r\n百撸社区\r\n乱奸警妞合集\r\n我爱撸\r\n桃花色\r\n色窝窝影院\r\n老鸭窝成人在线\r\n少年少女18禁\r\n丝袜恋足会所\r\n蓝天航空公司的空姐\r\n初恋双人组\r\n大香蕉网\r\n妹妹综合网\r\n色大姐夜夜撸得得\r\n哥哥碰在线\r\n嘻嘻色网\r\n纯爷们影院\r\n第七色成人网\r\n风艳阁\r\n桃色网\r\n四色四房\r\n绿海淫妻\r\n笑看淫生外传\r\n淫妻生涯\r\n蝴蝶八姬\r\n天天色影视\r\n萝莉涩\r\n日嫂嫂\r\n蝴蝶谷娱乐网\r\n伊人综合网\r\n色蝎子电影网\r\n妹爽网\r\n爱操操\r\n色小姐\r\n私爱阁\r\n鲁大妈网影院\r\n东方a∨在线\r\n亚洲久草色鲁鲁\r\n春色网\r\n色人党\r\n全色资源网\r\n撸撸吧\r\n撸客网\r\n哥哥撸\r\n色奶奶\r\n扣逼网\r\n夜夜啪\r\n得得射\r\n撸噜射\r\nA片资源吧\r\n热热网\r\n嘿咻影院\r\nyellow字幕网\r\n草绿茶导航\r\n久久热大香蕉\r\nFreeXX性欧美\r\n爱操网\r\n色久久\r\n色插插\r\n色去吧\r\n哥也撸\r\n天天干\r\n撸色soso\r\n窝窝全色资源网\r\n万花楼\r\n好逼网\r\n农夫色\r\n嫂嫂色\r\n嗷嗷撸\r\n伊人成人\r\n哥哥社\r\n哥去也\r\n色哥哥妹妹综合网\r\n全肉彩漫\r\n撸尼玛\r\n撸射射\r\n呦吧论坛\r\n鲁鲁阁\r\n爱撸网\r\n十次啦中文网\r\n奇米小色哥\r\n狼人干伊人网\r\n弟也骚\r\n色无极影院网\r\nav色大妈综合网\r\n怡红院资源网\r\nAV种子\r\n小色哥\r\n成人首页干妹妹\r\n哥哥操\r\n请君撸\r\n奇艺色\r\n第4色\r\n影音先锋av\r\n妓处阁\r\n琪琪色原\r\n啵啵网\r\n老色哥影院\r\n就去操\r\n性爱电影\r\n日夜干\r\n色爱区综合网\r\n久久色综合影院\r\nAv在线伊人影院\r\n蝌蚪窝最新播放视频\r\n用力草\r\n皇城娱乐城\r\n狼客娱乐网\r\n馒头逼\r\n干嫂嫂影院\r\n安安阁\r\n拈花网\r\n哥干网\r\n菊色宫\r\n色天堂娱乐论坛\r\n撸管图\r\n夜夜骑影院\r\n鲁大妈在线\r\n御女阁\r\n蒲友之家\r\n艳照门全集\r\n情色艺术中心网\r\n青青草在线\r\n儿子专用肉便器\r\n任性JK调教\r\n伊人电影网\r\n办公室诱与惑\r\n迷失少女天堂\r\n幼香帝国\r\n撸镥液\r\n顶色综合网\r\n爱上海论坛\r\n约炮情人网\r\n同涩网\r\n色酷网\r\n一品楼论坛\r\n噜噜网\r\n色猫网\r\n俺去也新网\r\n色女孩X网\r\n宅男色影视\r\n爱色窝\r\n香丁基地\r\n鲁鸡妞\r\n领先撸\r\n纵欲返古\r\n狼国成人网\r\n插插综合网\r\n草熘最新2015\r\n色悠悠综合网\r\n第七色影院\r\n色人居\r\n操木耳\r\n大黑逼\r\n色天堂\r\n入肉网\r\n我要撸\r\n骑姐姐\r\n撩妹\r\n全国娱乐信息\r\n酒店开房\r\n淫骚\r\n爆乳\r\n嫖妓\r\n外围女\r\n撸口\r\n大鸡巴\r\n偷拍\r\n乱伦\r\n奶子\r\n不要射\r\n老婆淫妻\r\n淫妻\r\n淫乱\r\n逼洞\r\n自慰\r\n精油\r\n自摸\r\n高潮\r\n偷情\r\n骚妹\r\n激情浪叫\r\n猛操\r\nAV大片\r\n骚货\r\n床上\r\n星级宾馆\r\n内射\r\n约炮\r\n美乳\r\n极品美乳\r\n淫叫', '0');
INSERT INTO `wp_config` VALUES ('143', 'WEIXIN_TOUSHU_OPENID', '1', '投诉处理openid', '10', '', '', '1527133915', '1529897365', '1', 'ohS730dYymeYyvV734aWfPKS9FDI', '12');
INSERT INTO `wp_config` VALUES ('146', 'WEIXIN_TIXIAN_OPENID', '1', '提现处理openid', '10', '', '', '1527134018', '1529897356', '1', 'ohS730dYymeYyvV734aWfPKS9FDI', '13');
INSERT INTO `wp_config` VALUES ('147', 'WEB_MF_01', '2', '免费用户提示', '6', '', '免费用户提示内容', '1527992338', '1527992338', '1', '<a href=\"http://member.106pan.com/wangpan_config\" title=您当前免费型，如超过3个月没有登录106网盘会员中心系统会清空您网盘文件，免费型系统根据您最后一次登录时间计算为您保留3个月的文件。 ><img src=\"http://www.106pan.com/static/member/images/39.png\" width=\"100%\" border=\"0\"></a>', '5');
INSERT INTO `wp_config` VALUES ('149', 'PAY_CODEPAY', '3', '码支付', '7', '', '', '1531821773', '1531821773', '1', 'codepay_id:80305\r\ncodepay_key:op6cmorugfuvvECDQUAiTaRXHj2ekIsM', '0');
INSERT INTO `wp_config` VALUES ('150', 'WX_MCHID', '1', '微信支付商户号', '10', '', '', '1532056594', '1532056594', '1', '', '4');
INSERT INTO `wp_config` VALUES ('151', 'WX_KEY', '1', '微信支付密钥', '10', '', '', '1532056647', '1532056647', '1', '', '5');

-- ----------------------------
-- Table structure for `wp_developer`
-- ----------------------------
DROP TABLE IF EXISTS `wp_developer`;
CREATE TABLE `wp_developer` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `status` tinyint(4) NOT NULL COMMENT '状态',
  `etime` int(10) NOT NULL COMMENT '过期时间',
  `name` varchar(255) NOT NULL COMMENT '姓名',
  `mobile` varchar(255) NOT NULL COMMENT '手机',
  `qq` varchar(255) NOT NULL COMMENT 'QQ',
  `weixin` varchar(255) NOT NULL COMMENT '微信',
  `ctime` int(10) NOT NULL COMMENT '申请时间',
  `days` int(10) unsigned NOT NULL COMMENT '时长（/天）',
  `logo` varchar(255) NOT NULL COMMENT 'logo',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_developer
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_developer_log`
-- ----------------------------
DROP TABLE IF EXISTS `wp_developer_log`;
CREATE TABLE `wp_developer_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `no` varchar(255) NOT NULL COMMENT '订单号',
  `ctime` int(10) NOT NULL COMMENT '购买时间',
  `status` tinyint(4) NOT NULL COMMENT '状态',
  `days` int(10) unsigned NOT NULL COMMENT '时长',
  `price` decimal(10,2) unsigned NOT NULL COMMENT '价格',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_developer_log
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_download_log`
-- ----------------------------
DROP TABLE IF EXISTS `wp_download_log`;
CREATE TABLE `wp_download_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `ctime` int(10) NOT NULL COMMENT '下载时间',
  `file_id` int(10) unsigned NOT NULL COMMENT '文件id',
  `size` varchar(255) NOT NULL COMMENT '文件大小',
  `uid` int(10) unsigned NOT NULL COMMENT '上传者id',
  `url` varchar(255) NOT NULL COMMENT '下载地址',
  `email` varchar(255) DEFAULT NULL COMMENT '邮箱',
  `code` varchar(255) DEFAULT NULL COMMENT '提取码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_download_log
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_file`
-- ----------------------------
DROP TABLE IF EXISTS `wp_file`;
CREATE TABLE `wp_file` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文件ID',
  `name` char(30) NOT NULL DEFAULT '' COMMENT '原始文件名',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '远程地址',
  `ctime` int(10) NOT NULL COMMENT '上传时间',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `nickname` varchar(255) NOT NULL COMMENT '用户名',
  `price` decimal(10,2) unsigned NOT NULL COMMENT '价格',
  `number` int(10) unsigned NOT NULL COMMENT '下载次数',
  `status` varchar(255) NOT NULL COMMENT '状态',
  `ftime` int(10) unsigned NOT NULL COMMENT '冻结时间',
  `connect` tinyint(4) NOT NULL COMMENT '连接',
  `type` tinyint(4) NOT NULL COMMENT '分类',
  `notes` text NOT NULL COMMENT '备注',
  `folder_id` varchar(255) NOT NULL COMMENT '网盘id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='文件表';

-- ----------------------------
-- Records of wp_file
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_file_index`
-- ----------------------------
DROP TABLE IF EXISTS `wp_file_index`;
CREATE TABLE `wp_file_index` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `pk` varchar(255) NOT NULL COMMENT 'PK',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_file_index
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_file_log`
-- ----------------------------
DROP TABLE IF EXISTS `wp_file_log`;
CREATE TABLE `wp_file_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `no` varchar(255) NOT NULL COMMENT '订单号',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `ctime` int(10) NOT NULL COMMENT '购买时间',
  `status` tinyint(4) NOT NULL COMMENT '状态',
  `amount` decimal(10,2) unsigned NOT NULL COMMENT '合计',
  `pay_way` varchar(255) NOT NULL COMMENT '支付方式',
  `file_pk` text NOT NULL COMMENT '文件主键',
  `email` varchar(255) NOT NULL COMMENT '邮箱',
  `code` varchar(255) DEFAULT NULL COMMENT '提取码',
  `file_id` int(10) DEFAULT NULL COMMENT '文件id',
  `mobile` varchar(15) NOT NULL COMMENT '手机',
  `price` decimal(10,2) unsigned NOT NULL COMMENT '价格',
  `name` varchar(255) NOT NULL COMMENT '软件名称',
  `ip` varchar(50) NOT NULL COMMENT 'IP',
  `downtime` int(10) NOT NULL COMMENT '下载时间',
  `card` text NOT NULL COMMENT '赠送卡密',
  `feilv` decimal(10,2) unsigned NOT NULL COMMENT '平台提成',
  `money` decimal(10,2) unsigned NOT NULL COMMENT '商户提成',
  `num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '数量',
  PRIMARY KEY (`id`),
  KEY `shourutongji` (`uid`,`ctime`,`status`,`price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_file_log
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_flink`
-- ----------------------------
DROP TABLE IF EXISTS `wp_flink`;
CREATE TABLE `wp_flink` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) NOT NULL,
  `logo` varchar(255) NOT NULL COMMENT '图片',
  `url` varchar(255) NOT NULL COMMENT '链接地址',
  `sort` int(10) unsigned NOT NULL COMMENT '排序',
  `title` varchar(255) NOT NULL COMMENT '名称',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_flink
-- ----------------------------
INSERT INTO `wp_flink` VALUES ('16', '0', '', 'http://www.106pan.com', '1', '106网盘');
INSERT INTO `wp_flink` VALUES ('17', '0', '', 'http://www.chunge188.com', '0', '永硕E盘装饰网');
INSERT INTO `wp_flink` VALUES ('18', '0', '', 'http://www.a8tg.com', '0', '爱发科技论坛');
INSERT INTO `wp_flink` VALUES ('19', '0', '', 'http://www.170lt.com/', '0', '卡商论坛');
INSERT INTO `wp_flink` VALUES ('20', '0', '', 'http://www.sofiazsx.cn/', '0', '柱子哥微博');

-- ----------------------------
-- Table structure for `wp_folder`
-- ----------------------------
DROP TABLE IF EXISTS `wp_folder`;
CREATE TABLE `wp_folder` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `reid` int(10) unsigned NOT NULL DEFAULT '0',
  `reids` varchar(255) NOT NULL DEFAULT '',
  `disorder` int(10) unsigned DEFAULT NULL,
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `is_index` tinyint(4) NOT NULL DEFAULT '1' COMMENT '是否首页显示',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_folder
-- ----------------------------
INSERT INTO `wp_folder` VALUES ('9', '数学', '0', '', '2', '18', '1', '0');
INSERT INTO `wp_folder` VALUES ('11', '阅读', '8', '', '2', '18', '1', '0');

-- ----------------------------
-- Table structure for `wp_gonggao`
-- ----------------------------
DROP TABLE IF EXISTS `wp_gonggao`;
CREATE TABLE `wp_gonggao` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `title` varchar(255) NOT NULL COMMENT '标题',
  `ctime` int(10) NOT NULL COMMENT '发布时间',
  `content` text NOT NULL COMMENT '内容',
  `cate` tinyint(4) NOT NULL COMMENT '分类',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_gonggao
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_help`
-- ----------------------------
DROP TABLE IF EXISTS `wp_help`;
CREATE TABLE `wp_help` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `problem` varchar(255) NOT NULL COMMENT '问题',
  `answer` text NOT NULL COMMENT '回答',
  `sort` int(10) unsigned NOT NULL COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_help
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_hooks`
-- ----------------------------
DROP TABLE IF EXISTS `wp_hooks`;
CREATE TABLE `wp_hooks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(40) NOT NULL DEFAULT '' COMMENT '钩子名称',
  `description` text COMMENT '描述',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '类型',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `addons` varchar(255) NOT NULL DEFAULT '' COMMENT '钩子挂载的插件 ''，''分割',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_hooks
-- ----------------------------
INSERT INTO `wp_hooks` VALUES ('1', 'pageHeader', '页面header钩子，一般用于加载插件CSS文件和代码', '1', '0', '', '1');
INSERT INTO `wp_hooks` VALUES ('2', 'pageFooter', '页面footer钩子，一般用于加载插件JS文件和JS代码', '1', '0', 'ReturnTop', '1');
INSERT INTO `wp_hooks` VALUES ('3', 'documentEditForm', '添加编辑表单的 扩展内容钩子', '1', '0', 'Attachment', '1');
INSERT INTO `wp_hooks` VALUES ('4', 'documentDetailAfter', '文档末尾显示', '1', '0', 'Attachment,SocialComment', '1');
INSERT INTO `wp_hooks` VALUES ('5', 'documentDetailBefore', '页面内容前显示用钩子', '1', '0', '', '1');
INSERT INTO `wp_hooks` VALUES ('6', 'documentSaveComplete', '保存文档数据后的扩展钩子', '2', '0', 'Attachment', '1');
INSERT INTO `wp_hooks` VALUES ('7', 'documentEditFormContent', '添加编辑表单的内容显示钩子', '1', '0', 'Editor', '1');
INSERT INTO `wp_hooks` VALUES ('8', 'adminArticleEdit', '后台内容编辑页编辑器', '1', '1378982734', 'EditorForAdmin', '1');
INSERT INTO `wp_hooks` VALUES ('13', 'AdminIndex', '首页小格子个性化显示', '1', '1382596073', 'SiteStat,SystemInfo,DevTeam', '1');
INSERT INTO `wp_hooks` VALUES ('14', 'topicComment', '评论提交方式扩展钩子。', '1', '1380163518', 'Editor', '1');
INSERT INTO `wp_hooks` VALUES ('16', 'app_begin', '应用开始', '2', '1384481614', '', '1');
INSERT INTO `wp_hooks` VALUES ('19', 'WdForm', 'WdForm', '1', '1445073685', 'WdForm', '1');

-- ----------------------------
-- Table structure for `wp_member`
-- ----------------------------
DROP TABLE IF EXISTS `wp_member`;
CREATE TABLE `wp_member` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `mobile` char(15) NOT NULL COMMENT '手机号',
  `nickname` char(20) NOT NULL DEFAULT '' COMMENT '昵称',
  `face` varchar(255) NOT NULL COMMENT '头像',
  `email` char(50) NOT NULL COMMENT '邮箱',
  `login` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '登录次数',
  `reg_ip` varchar(20) NOT NULL DEFAULT '0' COMMENT '注册IP',
  `ctime` int(10) NOT NULL DEFAULT '0' COMMENT '注册时间',
  `last_login_ip` int(10) NOT NULL DEFAULT '0' COMMENT '最后登录IP',
  `last_login_time` int(10) NOT NULL DEFAULT '0' COMMENT '最后登录时间',
  `status` char(50) NOT NULL DEFAULT '0' COMMENT '会员状态',
  `password` varchar(50) NOT NULL COMMENT '密码',
  `username` char(20) NOT NULL COMMENT '用户名',
  `group` char(50) NOT NULL DEFAULT '0' COMMENT '分组',
  `domain` varchar(255) NOT NULL COMMENT '二级域名',
  `wangpan_type` tinyint(4) NOT NULL DEFAULT '1' COMMENT '网盘类型',
  `guoqi_time` int(10) NOT NULL COMMENT '网盘过期时间',
  `weixin` varchar(255) NOT NULL COMMENT '微信',
  `alipay` varchar(255) NOT NULL COMMENT '支付宝',
  `qq` varchar(255) NOT NULL COMMENT 'QQ',
  `index_jiyu` text NOT NULL COMMENT '首页寄语',
  `pay_qq` varchar(255) NOT NULL COMMENT '支付qq',
  `pay_mobile` varchar(255) NOT NULL COMMENT '支付页面电话',
  `pay_email` varchar(255) NOT NULL COMMENT '支付页面邮箱',
  `wangpan_title` varchar(255) NOT NULL COMMENT '网盘标题',
  `wangpan_background` varchar(255) NOT NULL COMMENT '网盘背景',
  `is_pwd` varchar(255) NOT NULL COMMENT '显示是否需要密码',
  `menu` tinyint(4) NOT NULL DEFAULT '2' COMMENT '目录顺序',
  `model` varchar(255) NOT NULL COMMENT '模板选着',
  `idcard` varchar(20) NOT NULL COMMENT '身份证号',
  `truename` varchar(255) NOT NULL COMMENT '姓名',
  `closemsg` varchar(255) NOT NULL COMMENT '关闭提示',
  `from` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '推荐人id',
  `score` int(10) unsigned NOT NULL COMMENT '积分',
  `password2` varchar(50) NOT NULL COMMENT '二级密码',
  `weixin_bind_time` int(10) NOT NULL COMMENT '微信绑定时间',
  PRIMARY KEY (`id`),
  KEY `status` (`status`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='会员表';

-- ----------------------------
-- Records of wp_member
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_member_admin`
-- ----------------------------
DROP TABLE IF EXISTS `wp_member_admin`;
CREATE TABLE `wp_member_admin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户ID',
  `username` char(16) NOT NULL COMMENT '用户名',
  `password` char(32) NOT NULL COMMENT '密码',
  `email` char(32) NOT NULL COMMENT '用户邮箱',
  `mobile` char(15) NOT NULL DEFAULT '' COMMENT '用户手机',
  `last_login_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最后登录时间',
  `last_login_ip` bigint(20) NOT NULL DEFAULT '0' COMMENT '最后登录IP',
  `ctime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '用户状态 -1禁用',
  `group` tinyint(4) NOT NULL DEFAULT '0',
  `utime` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`) USING BTREE,
  UNIQUE KEY `email` (`email`) USING BTREE,
  KEY `status` (`status`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='用户表';

-- ----------------------------
-- Records of wp_member_admin
-- ----------------------------
INSERT INTO `wp_member_admin` VALUES ('1', 'admin', '0c7540eb7e65b553ec1ba6b20de79608', 'admin@69kz.com', '18700000000', '1532168805', '2130706433', '1440304209', '1', '0', '1531895121');
INSERT INTO `wp_member_admin` VALUES ('5', 'wangjian', 'c5473a384e43347840cfa7ef2b9097f3', '', '', '1529542519', '795357716', '0', '0', '0', '1528076373');

-- ----------------------------
-- Table structure for `wp_member_bind_info`
-- ----------------------------
DROP TABLE IF EXISTS `wp_member_bind_info`;
CREATE TABLE `wp_member_bind_info` (
  `uid` mediumint(8) unsigned NOT NULL,
  `type` char(10) NOT NULL,
  `openid` char(50) NOT NULL,
  `unionid` char(50) NOT NULL COMMENT '微信开放平台公众号共用id',
  `username` char(50) NOT NULL COMMENT '企业微信用户名',
  `apptoken` char(50) NOT NULL COMMENT 'app用',
  `nickname` char(50) NOT NULL,
  `face` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_member_bind_info
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_member_order`
-- ----------------------------
DROP TABLE IF EXISTS `wp_member_order`;
CREATE TABLE `wp_member_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `order_no` varchar(255) NOT NULL COMMENT '订单号',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `taocan` varchar(255) NOT NULL COMMENT '购买套餐',
  `amount` decimal(10,2) unsigned NOT NULL COMMENT '金额',
  `url` varchar(255) NOT NULL COMMENT '网盘地址',
  `status` tinyint(4) NOT NULL COMMENT '状态',
  `ctime` int(10) NOT NULL COMMENT '购买时间',
  `pay_way` varchar(255) NOT NULL COMMENT '支付方式',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_member_order
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_member_tpl`
-- ----------------------------
DROP TABLE IF EXISTS `wp_member_tpl`;
CREATE TABLE `wp_member_tpl` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `developer_id` int(10) unsigned NOT NULL COMMENT '开发者id',
  `index` text NOT NULL COMMENT '主页模板',
  `download` text NOT NULL COMMENT '下载页模板',
  `etime` int(10) NOT NULL COMMENT '授权截止时间',
  `domain` varchar(255) NOT NULL COMMENT '二级域名',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态',
  `download_wap` text NOT NULL COMMENT 'wap版下载页模板',
  `index_wap` text NOT NULL COMMENT 'wap版主页模板',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_member_tpl
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_menu`
-- ----------------------------
DROP TABLE IF EXISTS `wp_menu`;
CREATE TABLE `wp_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文档ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '标题',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级分类ID',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序（同级有效）',
  `url` char(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `hide` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否隐藏',
  `tip` varchar(255) NOT NULL DEFAULT '' COMMENT '提示',
  `group` varchar(50) DEFAULT '' COMMENT '分组',
  `is_dev` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否仅开发者模式可见',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`) USING BTREE,
  KEY `status` (`status`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=247 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_menu
-- ----------------------------
INSERT INTO `wp_menu` VALUES ('3', '网站栏目', '2', '0', 'Category/index', '1', '', '内容', '0', '1');
INSERT INTO `wp_menu` VALUES ('4', '新增', '3', '0', 'article/add', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('5', '编辑', '3', '0', 'article/edit', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('6', '改变状态', '3', '0', 'article/setStatus', '1', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('7', '保存', '3', '0', 'article/update', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('8', '保存草稿', '3', '0', 'article/autoSave', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('9', '移动', '3', '0', 'article/move', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('10', '复制', '3', '0', 'article/copy', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('11', '粘贴', '3', '0', 'article/paste', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('12', '导入', '3', '0', 'article/batchOperate', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('13', '回收站', '2', '0', 'article/recycle', '1', '', '内容', '0', '1');
INSERT INTO `wp_menu` VALUES ('14', '还原', '13', '0', 'article/permit', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('15', '清空', '13', '0', 'article/clear', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('16', '会员管理', '0', '2', 'User/index', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('17', '会员列表', '16', '0', 'v/lists?model_id=27', '0', '', '用户管理', '0', '1');
INSERT INTO `wp_menu` VALUES ('18', '新增用户', '17', '0', 'User/add', '0', '添加新用户', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('20', '新增用户行为', '19', '0', 'User/addaction', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('21', '编辑用户行为', '19', '0', 'User/editaction', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('22', '保存用户行为', '19', '0', 'User/saveAction', '0', '\"用户->用户行为\"保存编辑和新增的用户行为', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('23', '变更行为状态', '19', '0', 'User/setStatus', '0', '\"用户->用户行为\"中的启用,禁用和删除权限', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('24', '禁用会员', '19', '0', 'User/changeStatus/method/forbidUser', '0', '\"用户->用户信息\"中的禁用', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('25', '启用会员', '19', '0', 'User/changeStatus/method/resumeUser', '0', '\"用户->用户信息\"中的启用', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('26', '删除会员', '19', '0', 'User/changeStatus/method/deleteUser', '0', '\"用户->用户信息\"中的删除', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('28', '删除', '27', '0', 'AuthManager/changeStatus/method/deleteGroup', '0', '删除用户组', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('29', '禁用', '27', '0', 'AuthManager/changeStatus/method/forbidGroup', '0', '禁用用户组', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('30', '恢复', '27', '0', 'AuthManager/changeStatus/method/resumeGroup', '0', '恢复已禁用的用户组', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('31', '新增', '27', '0', 'AuthManager/createGroup', '0', '创建新的用户组', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('32', '编辑', '27', '0', 'AuthManager/editGroup', '0', '编辑用户组名称和描述', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('33', '保存用户组', '27', '0', 'AuthManager/writeGroup', '0', '新增和编辑用户组的\"保存\"按钮', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('34', '授权', '27', '0', 'AuthManager/group', '0', '\"后台 \\ 用户 \\ 用户信息\"列表页的\"授权\"操作按钮,用于设置用户所属用户组', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('35', '访问授权', '27', '0', 'AuthManager/access', '0', '\"后台 \\ 用户 \\ 权限管理\"列表页的\"访问授权\"操作按钮', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('36', '成员授权', '27', '0', 'AuthManager/user', '0', '\"后台 \\ 用户 \\ 权限管理\"列表页的\"成员授权\"操作按钮', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('37', '解除授权', '27', '0', 'AuthManager/removeFromGroup', '0', '\"成员授权\"列表页内的解除授权操作按钮', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('38', '保存成员授权', '27', '0', 'AuthManager/addToGroup', '0', '\"用户信息\"列表页\"授权\"时的\"保存\"按钮和\"成员授权\"里右上角的\"添加\"按钮)', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('39', '分类授权', '27', '0', 'AuthManager/category', '0', '\"后台 \\ 用户 \\ 权限管理\"列表页的\"分类授权\"操作按钮', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('40', '保存分类授权', '27', '0', 'AuthManager/addToCategory', '0', '\"分类授权\"页面的\"保存\"按钮', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('41', '模型授权', '27', '0', 'AuthManager/modelauth', '0', '\"后台 \\ 用户 \\ 权限管理\"列表页的\"模型授权\"操作按钮', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('42', '保存模型授权', '27', '0', 'AuthManager/addToModel', '0', '\"分类授权\"页面的\"保存\"按钮', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('44', '插件管理', '43', '1', 'Addons/index', '0', '', '扩展', '0', '1');
INSERT INTO `wp_menu` VALUES ('45', '创建', '44', '0', 'Addons/create', '0', '服务器上创建插件结构向导', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('46', '检测创建', '44', '0', 'Addons/checkForm', '0', '检测插件是否可以创建', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('47', '预览', '44', '0', 'Addons/preview', '0', '预览插件定义类文件', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('48', '快速生成插件', '44', '0', 'Addons/build', '0', '开始生成插件结构', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('49', '设置', '44', '0', 'Addons/config', '0', '设置插件配置', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('50', '禁用', '44', '0', 'Addons/disable', '0', '禁用插件', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('51', '启用', '44', '0', 'Addons/enable', '0', '启用插件', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('52', '安装', '44', '0', 'Addons/install', '0', '安装插件', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('53', '卸载', '44', '0', 'Addons/uninstall', '0', '卸载插件', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('54', '更新配置', '44', '0', 'Addons/saveconfig', '0', '更新插件配置处理', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('55', '插件后台列表', '44', '0', 'Addons/adminList', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('56', 'URL方式访问插件', '44', '0', 'Addons/execute', '0', '控制是否有权限通过url访问插件控制器方法', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('57', '钩子管理', '43', '2', 'Addons/hooks', '0', '', '扩展', '0', '1');
INSERT INTO `wp_menu` VALUES ('58', '模型管理', '68', '3', 'Model/index', '0', '', '系统设置', '0', '1');
INSERT INTO `wp_menu` VALUES ('59', '新增', '58', '0', 'model/add', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('60', '编辑', '58', '0', 'model/edit', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('61', '改变状态', '58', '0', 'model/setStatus', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('62', '保存数据', '58', '0', 'model/update', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('64', '新增', '63', '0', 'Attribute/add', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('65', '编辑', '63', '0', 'Attribute/edit', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('66', '改变状态', '63', '0', 'Attribute/setStatus', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('67', '保存数据', '63', '0', 'Attribute/update', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('69', '网站设置', '68', '1', 'Config/group', '0', '', '系统设置', '0', '1');
INSERT INTO `wp_menu` VALUES ('71', '编辑', '70', '0', 'Config/edit', '0', '新增编辑和保存配置', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('72', '删除', '70', '0', 'Config/del', '0', '删除配置', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('73', '新增', '70', '0', 'Config/add', '0', '新增配置', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('74', '保存', '70', '0', 'Config/save', '0', '保存配置', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('75', '菜单管理', '68', '4', 'Menu/index', '0', '', '系统设置', '0', '1');
INSERT INTO `wp_menu` VALUES ('76', '导航管理', '68', '6', 'Channel/index', '1', '', '系统设置', '0', '1');
INSERT INTO `wp_menu` VALUES ('77', '新增', '76', '0', 'Channel/add', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('78', '编辑', '76', '0', 'Channel/edit', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('79', '删除', '76', '0', 'Channel/del', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('80', '分类管理', '68', '2', 'Category/index', '1', '', '系统设置', '0', '1');
INSERT INTO `wp_menu` VALUES ('81', '编辑', '80', '0', 'Category/edit', '0', '编辑和保存栏目分类', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('82', '新增', '80', '0', 'Category/add', '0', '新增栏目分类', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('83', '删除', '80', '0', 'Category/remove', '0', '删除栏目分类', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('84', '移动', '80', '0', 'Category/operate/type/move', '0', '移动栏目分类', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('85', '合并', '80', '0', 'Category/operate/type/merge', '0', '合并栏目分类', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('86', '备份数据库', '68', '9', 'Database/index/type/export', '1', '', '数据备份', '0', '1');
INSERT INTO `wp_menu` VALUES ('87', '备份', '86', '0', 'Database/export', '0', '备份数据库', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('88', '优化表', '86', '0', 'Database/optimize', '0', '优化数据表', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('89', '修复表', '86', '0', 'Database/repair', '0', '修复数据表', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('90', '还原数据库', '68', '8', 'Database/index/type/import', '1', '', '数据备份', '0', '1');
INSERT INTO `wp_menu` VALUES ('91', '恢复', '90', '0', 'Database/import', '0', '数据库恢复', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('92', '删除', '90', '0', 'Database/del', '0', '删除备份文件', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('96', '新增', '75', '0', 'Menu/add', '0', '', '系统设置', '0', '1');
INSERT INTO `wp_menu` VALUES ('98', '编辑', '75', '0', 'Menu/edit', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('110', '查看行为日志', '106', '0', 'action/edit', '1', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('112', '新增数据', '58', '0', 'think/add', '1', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('113', '编辑数据', '58', '0', 'think/edit', '1', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('114', '导入', '75', '0', 'Menu/import', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('115', '生成', '58', '0', 'Model/generate', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('116', '新增钩子', '57', '0', 'Addons/addHook', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('117', '编辑钩子', '57', '0', 'Addons/edithook', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('118', '文档排序', '3', '0', 'Article/sort', '1', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('119', '排序', '70', '0', 'Config/sort', '1', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('120', '排序', '75', '0', 'Menu/sort', '1', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('121', '排序', '76', '0', 'Channel/sort', '1', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('122', '数据列表', '58', '0', 'think/lists', '1', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('123', '审核列表', '3', '0', 'Article/examine', '1', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('126', '广告管理', '2', '0', 'Think/lists/model/advert', '1', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('127', '商品管理', '130', '0', 'Goods/lists', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('128', '商品分类', '130', '0', 'Think/lists/model/goods_cate', '1', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('132', '管理员管理', '68', '0', 'User/lists', '1', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('181', '文件管理', '209', '0', 'V/lists/model_id/34', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('182', '回收站文件', '209', '0', 'V/lists/model_id/34/type/3', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('183', '新闻文章', '2', '0', 'V/lists/model_id/31', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('184', '友情链接', '2', '0', 'V/lists/model_id/5', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('185', '提现记录', '203', '0', 'Cash/lists/model_id/33', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('186', '站点帮助', '2', '0', 'V/lists/model_id/32', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('187', '充值记录', '203', '0', 'V/lists/model_id/35', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('188', '', '203', '0', 'V/lists/model_id/36', '1', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('189', '', '203', '0', 'V/lists/model_id/37', '1', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('190', '', '203', '0', 'V/lists/model_id/38', '1', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('191', '公告管理', '2', '0', 'V/lists/model_id/39', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('192', '举报管理', '2', '0', 'V/lists/model_id/40', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('193', '银行卡绑定', '209', '0', 'V/lists/model_id/41', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('194', '广告管理', '2', '0', 'V/lists/model_id/21', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('195', '网盘目录', '2', '0', 'Type/index/table/folder/typename/网盘目录', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('196', '风格管理', '2', '0', 'V/lists/model_id/45', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('198', '开发者管理', '209', '0', 'V/lists/model_id/49', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('199', '网盘类型', '2', '0', 'V/lists/model_id/53', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('200', '网盘价格', '2', '0', 'V/lists/model_id/54', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('202', '开发者购买记录', '203', '0', 'V/lists/model_id/57', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('204', '资金明细', '203', '0', 'V/lists/model_id/59', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('205', '文件购买记录', '203', '0', 'V/lists/model_id/58', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('206', '网盘升级记录', '203', '0', 'V/lists/model_id/55', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('207', '下载记录', '209', '0', 'V/lists/model_id/56', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('208', '教学视频', '209', '0', 'V/lists/model_id/51', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('210', '提现管理', '0', '3', '', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('211', '网盘管理', '0', '4', '', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('212', '订单管理', '0', '5', '', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('213', '站内资讯', '0', '6', '', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('215', '系统设置', '0', '1', 'Config/group', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('216', '菜单管理', '215', '4', 'menu/index', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('217', '网站设置', '215', '1', 'config/group', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('218', '模型管理', '215', '3', 'model/index', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('219', '配置管理', '215', '2', 'v/lists?model_id=86', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('220', '软件购买订单', '212', '1', 'v/lists?model_id=58', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('222', '提现设置', '210', '1', 'config/group?id=13', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('224', '提现记录', '210', '0', 'v/lists?model_id=33&amp;today=1', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('225', '网盘类型', '211', '1', 'v/lists?model_id=53', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('227', '网盘充值订单', '212', '2', 'v/lists?model_id=55', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('228', '广告设置', '0', '8', 'V/lists/model_id/21', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('229', '广告管理', '228', '0', 'v/lists?model_id=21', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('230', '目录管理', '211', '0', 'Folder/lists', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('231', '文件管理', '211', '0', 'File/lists', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('233', '举报管理', '211', '0', 'v/lists?model_id=40', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('234', '积分日志', '16', '0', 'v/lists?model_id=88', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('235', '新闻公告', '213', '0', 'v/lists?model_id=39', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('236', '管理员管理', '16', '0', 'User/lists', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('237', '支付通道', '215', '6', 'v/lists?model_id=89', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('241', '用户组管理', '16', '0', 'authmanager/index', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('242', '微信设置', '217', '0', '', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('245', '友情连接', '213', '0', 'admin/V/lists/model_id/5', '0', '', '', '0', '1');
INSERT INTO `wp_menu` VALUES ('246', '教学视频', '213', '0', 'admin/V/lists/model_id/51', '0', '', '', '0', '1');

-- ----------------------------
-- Table structure for `wp_menu_often`
-- ----------------------------
DROP TABLE IF EXISTS `wp_menu_often`;
CREATE TABLE `wp_menu_often` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `title` varchar(255) NOT NULL COMMENT '标题',
  `url` varchar(255) NOT NULL COMMENT '地址',
  `menuid` int(10) unsigned NOT NULL COMMENT '菜单id',
  `ctime` int(10) NOT NULL COMMENT '时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_menu_often
-- ----------------------------
INSERT INTO `wp_menu_often` VALUES ('67', '0', '网站设置', 'config/group', '217', '1531819989');
INSERT INTO `wp_menu_often` VALUES ('71', '0', '会员列表', 'v/lists?model_id=27', '17', '1531821239');
INSERT INTO `wp_menu_often` VALUES ('72', '0', '支付通道', 'v/lists?model_id=89', '237', '1531821354');
INSERT INTO `wp_menu_often` VALUES ('73', '0', '配置管理', 'v/lists?model_id=86', '219', '1531821775');
INSERT INTO `wp_menu_often` VALUES ('74', '0', '菜单管理', 'menu/index', '216', '1531837009');
INSERT INTO `wp_menu_often` VALUES ('75', '0', '模型管理', 'model/index', '218', '1531837009');
INSERT INTO `wp_menu_often` VALUES ('76', '0', '软件购买订单', 'v/lists?model_id=58', '220', '1531837821');
INSERT INTO `wp_menu_often` VALUES ('77', '0', '管理员管理', 'User/lists', '236', '1531895117');

-- ----------------------------
-- Table structure for `wp_model`
-- ----------------------------
DROP TABLE IF EXISTS `wp_model`;
CREATE TABLE `wp_model` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '模型ID',
  `name` char(30) NOT NULL DEFAULT '' COMMENT '模型标识',
  `title` char(30) NOT NULL DEFAULT '' COMMENT '模型名称',
  `extend` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '继承的模型',
  `relation` varchar(30) NOT NULL DEFAULT '' COMMENT '继承与被继承模型的关联字段',
  `need_pk` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '新建表时是否需要主键字段',
  `field_sort` text COMMENT '表单字段排序',
  `field_group` varchar(255) NOT NULL DEFAULT '1:基础' COMMENT '字段分组',
  `attribute_list` text COMMENT '属性列表（表的字段）',
  `attribute_alias` varchar(255) NOT NULL DEFAULT '' COMMENT '属性别名定义',
  `list_grid` text COMMENT '列表定义',
  `list_grid_home` text COMMENT '前台列表定义',
  `list_grid_search` text COMMENT '后台搜索字段',
  `list_grid_search_home` text COMMENT '前台搜索字段',
  `list_row` smallint(2) unsigned NOT NULL DEFAULT '10' COMMENT '列表数据长度',
  `search_key` varchar(50) NOT NULL DEFAULT '' COMMENT '默认搜索字段',
  `search_list` varchar(255) NOT NULL DEFAULT '' COMMENT '高级搜索的字段',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  `engine_type` varchar(25) NOT NULL DEFAULT 'MyISAM' COMMENT '数据库引擎',
  `model_name` varchar(255) NOT NULL COMMENT '模型名称',
  `model_list_name` varchar(255) NOT NULL COMMENT '列表模型名称',
  `order` varchar(100) NOT NULL,
  `model` varchar(255) NOT NULL,
  `model_lists` varchar(50) NOT NULL COMMENT '列表模型',
  `model_show` varchar(50) NOT NULL COMMENT '详情页模型',
  `model_add` varchar(50) NOT NULL COMMENT '数据添加模型，默认为name',
  `model_mod` varchar(50) NOT NULL COMMENT '数据修改模型，默认为name',
  `model_del` varchar(50) NOT NULL COMMENT '数据删除模型，默认为name',
  `model_order` varchar(255) NOT NULL COMMENT '列表排序',
  `model_allow` tinyint(4) NOT NULL DEFAULT '1' COMMENT '允许发布数据类型,0禁止，1仅允许后台，2前台允许登录发布，3前台允许不登录发布',
  `field_lists` text NOT NULL COMMENT '列表字段',
  `field_add` varchar(255) NOT NULL COMMENT '添加字段',
  `field_mod` varchar(255) NOT NULL COMMENT '编辑字段',
  `field_search` varchar(255) NOT NULL COMMENT '搜索字段',
  `field_lists_front` varchar(255) NOT NULL COMMENT '前台列表字段',
  `field_add_front` varchar(255) NOT NULL COMMENT '前台添加字段',
  `field_mod_front` varchar(255) NOT NULL COMMENT '前台编辑字段',
  `field_search_front` varchar(255) NOT NULL COMMENT '前台搜索字段',
  `field_form` text NOT NULL COMMENT '添加字段',
  `template` varchar(255) NOT NULL COMMENT '模板',
  `field_set` text NOT NULL COMMENT '字段设置',
  `pk` varchar(20) NOT NULL COMMENT '主键',
  `prefix` varchar(20) NOT NULL COMMENT '表前缀',
  PRIMARY KEY (`id`),
  KEY `extend` (`name`,`extend`)
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='文档模型表';

-- ----------------------------
-- Records of wp_model
-- ----------------------------
INSERT INTO `wp_model` VALUES ('5', 'flink', '友情链接', '0', '', '1', '{\"1\":[\"38\",\"36\",\"35\",\"37\"]}', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', '', null, null, '50', '', '', '1447428981', '1530270495', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '3', 'field:id,title:ID,width:100,class:tc\r\nfield:title,title:标题,search_exp:like,class:tl,search_title:标题\r\nfield:url,title:链接,class:tl', '', '', '', '', '', '', '', '', '', '{\"title\":{\"title\":\"\",\"url\":\"\",\"logo\":\"\",\"sort\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('21', 'advert', '广告', '0', '', '1', '{\"1\":[\"177\",\"180\",\"456\",\"486\",\"216\",\"178\",\"179\"],\"2\":[\"183\"]}', '1:基础,2:高级', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', '', 'title|like|广告标题\r\nposition|position|广告位置\r\n', '', '50', '', '', '1466233265', '1525573346', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '1', 'field:id,title:ID,width:100,class:tc\r\nfield:title,title:广告名称,class:tl\r\nfield:position,title:广告位置,class:tl,search_exp:like,search_title:广告位置\r\nfield:sort,title:排序,width:100,class:tc\r\nfield:stime,title:开始时间,width:100,class:tc,fun:wd_date(Y-m-d,###)\r\nfield:etime,title:截止时间,width:100,class:tc,fun:wd_date(Y-m-d,###)', '', '', '', '', '', '', '', '', '', '{\"title\":{\"title\":\"\",\"position\":\"\",\"sort\":\"\",\"isrand\":\"\",\"content\":\"\",\"stime\":\"\",\"etime\":\"\",\"category_id\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('27', 'member', '会员', '0', '', '1', '{\"1\":[\"209\",\"204\",\"342\",\"482\",\"208\",\"203\",\"459\",\"458\",\"426\",\"425\",\"210\",\"207\",\"472\",\"374\",\"400\",\"480\",\"205\",\"206\"],\"2\":[\"451\",\"475\",\"211\",\"232\",\"220\",\"197\",\"452\",\"449\",\"202\",\"450\",\"448\",\"445\",\"427\",\"444\"]}', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', '', '', '', '20', '', '', '1471575216', '1530956430', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '3', 'field:id,title:ID,search_exp:eq_input,width:50,class:tc,search_title:会员ID\r\nfield:truename,title:真实姓名,search_exp:like,class:tl,search_title:用户姓名,width:100,class:tc\r\nfield:mobile,title:电话,search_exp:like,class:tl,search_title:电话,width:120,class:tc\r\nfield:email,title:邮箱,class:tl,search_exp:like,search_title:邮箱\r\nfield:score,title:积分,width:50,class:tc\r\nfield:qq,title:QQ,width:120,class:tc\r\nfield:reg_ip,title:注册IP,class:tl,hidden:true\r\nfield:domain,title:域名,class:tl,search_exp:eq_input,search_title:域名,fun:get_user_domain(###)\r\nfield:wangpan_type,title:网盘类型,fun:get_status(###,wangpan_type,27),width:100,class:tc,search_exp:eq,search_title:网盘类型\r\nfield:status,title:状态,search_exp:eq,search_title:状态,class:tc,fun:get_status(###,status,27),width:100,class:tc\r\nfield:guoqi_time,title:过期时间,fun:wd_date(Y-m-d,###),width:100,class:tc\r\nfield:id,title:余额,fun:userconfig_get(###,member_money),width:100,class:tc\r\nfield:last_login_time,title:最后登录时间,fun:date(Y-m-d,###),width:120,class:tc', '', '', '', '', '', '', '', 'field:id,title:ID,width:100\r\nfield:nickname,title:用户名\r\nfield:mobile,title:电话\r\nfield:email,title:邮箱\r\nfield:reg_ip,title:注册IP\r\nfield:domain,title:域名\r\nfield:weixin,title:微信\r\nfield:status,title:状态\r\nfield:wangpan_type,title:网盘类型\r\nfield:alipay,title:支付宝', 'lists:Member_lists', '{\"title\":{\"mobile\":\"\",\"ctime\":\"\",\"domain\":\"\",\"password2\":\"\",\"email\":\"\",\"reg_ip\":\"\",\"truename\":\"\",\"idcard\":\"\",\"alipay\":\"\",\"weixin\":\"\",\"password\":\"\",\"status\":\"\",\"closemsg\":\"\",\"wangpan_type\":\"\",\"guoqi_time\":\"\",\"score\":\"\",\"last_login_ip\":\"\",\"last_login_time\":\"\",\"menu\":\"\",\"from\":\"\",\"username\":\"\",\"group\":\"\",\"face\":\"\",\"nickname\":\"\",\"model\":\"\",\"wangpan_background\":\"\",\"login\":\"\",\"is_pwd\":\"\",\"wangpan_title\":\"\",\"pay_mobile\":\"\",\"qq\":\"\",\"pay_qq\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('30', 'order', '订单', '0', '', '1', '', '1:基础', '', '', null, null, null, null, '50', '', '', '1500603547', '1500603547', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '1', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `wp_model` VALUES ('31', 'news', '文章', '0', '', '1', '{\"1\":[\"367\",\"233\",\"236\",\"237\",\"234\"]}', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', null, null, null, '50', '', '', '1508744527', '1513841422', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '1', 'field:id,title:ID,width:100,class:tc\r\nfield:title,title:标题,class:tl,search_exp:like,search_title:标题\r\nfield:category,title:分类,fun:get_status(###,category,31),width:150,class:tc,search_exp:eq,search_title:分类,class:tl\r\nfield:description,hidden:true\r\nfield:ctime,title:发布时间,fun:date(Y-m-d H:i:s,###),class:tl', '', '', '', '', '', '', '', '', '', '{\"title\":{\"uid\":\"\",\"title\":\"\",\"category\":\"\",\"description\":\"\",\"content\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('32', 'help', '站点帮助', '0', '', '1', '{\"1\":[\"240\",\"239\",\"238\"]}', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', null, null, null, '50', '', '', '1509588482', '1509609646', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '1', 'field:id,title:ID,width:100,class:tc\r\nfield:problem,title:问题,class:tl', '', '', '', '', '', '', '', '', '', '{\"title\":{\"sort\":\"\",\"answer\":\"\",\"problem\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('33', 'cash', '提现记录', '0', '', '1', '{\"1\":[\"245\",\"242\",\"247\",\"244\",\"453\",\"431\",\"428\",\"243\",\"265\",\"430\",\"469\"]}', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', null, null, null, '50', '', '', '1509589310', '1521365045', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '1', 'field:id,title:ID,width:50,class:tc,hidden:true\r\nfield:no,title:订单号,search_exp:like,search_title:订单号,width:170,class:tc\r\nfield:truename,title:姓名\r\nfield:cash_card,title:提现账号,class:tl,search_exp:like,search_title:提现账号\r\nfield:amount,title:提现金额,class:tc,width:80\r\nfield:pay_way,title:支付方式,class:tl,fun:get_status(###,pay_way,33),search_exp:eq,search_title:结算方式,hidden:true\r\nfield:ctime,title:申请时间,fun:wd_date(m-d H:i,###),class:tc,width:100,search_exp:between,search_title1:起始时间,search_title2:结束时间\r\nfield:status,title:状态,fun:get_status(###,status,33),class:tl,search_exp:eq,search_title:状态\r\nfield:type,title:分类,fun:get_status(###,type,33),class:tl,search_exp:eq,search_title:分类,hidden:true\r\nfield:uid,title:UID,search_exp:eq_input,search_title:用户ID,hidden:true\r\nfield:pay_time,title:支付时间,fun:wd_date(m-d H:i,###),width:100,class:tc\r\nfield:about,title:备注,width:160\r\n\r\n', '', '', '', '', '', '', '', '', 'lists:Cash_lists', '{\"title\":{\"ctime\":\"\",\"truename\":\"\",\"cash_card\":\"\",\"status\":\"\",\"type\":\"\",\"no\":\"\",\"pay_way\":\"\",\"amount\":\"\",\"cash_price\":\"\",\"cash_amount\":\"\",\"about\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('34', 'file', '文件', '0', '', '1', '{\"1\":[\"255\",\"303\",\"256\",\"257\",\"297\",\"254\",\"253\",\"249\",\"250\",\"251\",\"252\",\"248\"]}', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', null, null, null, '50', '', '', '1509589675', '1509938151', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '3', 'field:id,title:ID,width:100,class:tc\r\nfield:name,title:文件名,class:tl,search_exp:like,search_title:文件名\r\nfield:url,title:下载地址,class:tl\r\nfield:type,title:分类,fun:get_status(###,type,34),class:tl,search_exp:eq,search_title:分类\r\nfield:nickname,title:上传人,class:tl\r\nfield:ctime,title:上传时间,fun:date(Y-m-d H:i:s,###),class:tl\r\nfield:price,title:价格,class:tl\r\nfield:number,title:下载次数,class:tl\r\nfield:status,title:状态,fun:get_status(###,status,34),class:tl,search_exp:eq,search_title:状态', '', '', '', '', '', '', '', '', '', '{\"title\":{\"status\":\"\",\"notes\":\"\",\"ftime\":\"\",\"connect\":\"\",\"type\":\"\",\"number\":\"\",\"url\":\"\",\"ctime\":\"\",\"uid\":\"\",\"nickname\":\"\",\"price\":\"\",\"name\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('35', 'recharge', '充值记录', '0', '', '1', '{\"1\":[\"489\",\"322\",\"323\",\"263\",\"264\",\"262\",\"261\",\"259\",\"260\",\"258\"]}', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', null, null, null, '50', '', '', '1509591106', '1521297732', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '3', 'field:id,title:ID,width:100,class:tc\r\nfield:no,title:订单号,class:tl,search_exp:like,search_title:订单号\r\nfield:uid,title:会员帐号,class:tl,hidden:true,search_exp:eq,search_hidden_admin:true\r\nfield:amount,title:充值金额,class:tc\r\nfield:pay_way,title:支付方式,class:tc,search_exp:eq,search_hidden_admin:true\r\nfield:pay_price,title:充值扣费,class:tc\r\nfield:status,title:状态,fun:get_status(###,status,35),search_exp:eq,search_title:状态,class:tc\r\nfield:ctime,title:充值时间,fun:date(Y-m-d H:i:s,###),class:tc\r\nfield:pay_time,title:支付时间,hidden:true\r\nfield:pay_no,title:支付流水,hidden:true\r\nfield:price,hidden:true', '', '', '', '', '', '', '', '', '', '{\"title\":{\"price\":\"\",\"pay_time\":\"\",\"pay_no\":\"\",\"pay_price\":\"\",\"status\":\"\",\"pay_way\":\"\",\"amount\":\"\",\"no\":\"\",\"ctime\":\"\",\"uid\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('36', 'software_order', '软件购买订单', '0', '', '1', '{\"1\":[\"276\",\"275\",\"277\",\"278\",\"279\",\"274\",\"273\",\"269\",\"268\",\"270\",\"271\",\"272\",\"267\"]}', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', null, null, null, '50', '', '', '1509594347', '1509616247', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '1', 'field:id,title:ID,width:100,class:tc\r\nfield:order_no,title:订单号,class:tl\r\nfield:seller_id,title:卖家账号,class:tl\r\nfield:buyer_id,title:买家帐号,class:tl\r\nfield:ctime,title:购买时间,fun:date(Y-m-d H:i:s,###),class:tl\r\nfield:amount,title:金额,class:tl\r\nfield:pay_way,title:支付方式,class:tl\r\nfield:pttc,title:平台提成,class:tl\r\nfield:shtc,title:商户提成,class:tl\r\nfield:ptlr,title:平台利润,class:tl\r\nfield:dlfc,title:代理分成,class:tl\r\nfield:is_success,title:是否下载成功,fun:get_status(###,is_success,36),width:100,class:tc,search_exp:eq,search_title:是否下载成功\r\nfield:status,title:状态,fun:get_status(###,status,36),search_exp:eq,search_title:状态', '', '', '', '', '', '', '', '', '', '{\"title\":{\"dlfc\":\"\",\"ptlr\":\"\",\"is_kou\":\"\",\"is_success\":\"\",\"status\":\"\",\"shtc\":\"\",\"pttc\":\"\",\"seller_id\":\"\",\"buyer_id\":\"\",\"ctime\":\"\",\"amount\":\"\",\"pay_way\":\"\",\"order_no\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('37', 'chajian_order', '插件订单', '0', '', '1', '{\"1\":[\"287\",\"288\",\"289\",\"290\",\"286\",\"285\",\"281\",\"282\",\"283\",\"284\",\"280\"]}', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', null, null, null, '50', '', '', '1509595091', '1509615464', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '1', 'field:id,title:ID,width:100,class:tc\r\nfield:order_no,title:订单号,class:tl\r\nfield:name,title:插件名称,class:tl,search_exp:like,search_title:插件名称\r\nfield:seller_id,title:卖家账号,class:tl\r\nfield:buyer_id,title:买家帐号,class:tl\r\nfield:ctime,title:购买时间,fun:date(Y-m-d H:i:s,###),class:tl\r\nfield:amount,title:金额,class:tl\r\nfield:pay_way,title:支付方式,class:tl\r\nfield:pttc,title:平台提成,class:tl\r\nfield:shtc,title:商户提成,class:tl\r\nfield:ptlr,title:平台利润,class:tl\r\nfield:status,title:状态,fun:get_status(###,status,37),search_exp:eq,search_title:状态\r\n', '', '', '', '', '', '', '', '', '', '{\"title\":{\"pttc\":\"\",\"shtc\":\"\",\"ptlr\":\"\",\"status\":\"\",\"amount\":\"\",\"pay_way\":\"\",\"buyer_id\":\"\",\"seller_id\":\"\",\"ctime\":\"\",\"name\":\"\",\"order_no\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('38', 'member_order', '会员购买订单', '0', '', '1', '{\"1\":[\"298\",\"299\",\"295\",\"296\",\"294\",\"293\",\"292\",\"291\"]}', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', null, null, null, '50', '', '', '1509603168', '1509615498', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '1', 'field:id,title:ID,width:100,class:tc\r\nfield:order_no,title:订单号,class:tl\r\nfield:taocan,title:套餐,class:tl,search_exp:like,search_title:套餐名\r\nfield:uid,title:买家帐号,class:tl\r\nfield:ctime,title:购买时间,fun:date(Y-m-d H:i:s,###),class:tl\r\nfield:amount,title:金额,class:tl\r\nfield:pay_way,title:支付方式,class:tl\r\nfield:url,title:网盘地址,class:tl\r\nfield:status,title:状态,fun:get_status(###,status,38),class:tl,search_exp:eq,search_title:状态\r\n', '', '', '', '', '', '', '', '', '', '{\"title\":{\"ctime\":\"\",\"pay_way\":\"\",\"url\":\"\",\"status\":\"\",\"amount\":\"\",\"taocan\":\"\",\"uid\":\"\",\"order_no\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('39', 'gonggao', '公告', '0', '', '1', '{\"1\":[\"300\",\"481\",\"301\",\"302\"]}', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', null, null, null, '50', '', '', '1509610485', '1518484910', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '1', 'field:id,title:ID,width:100,class:tc\r\nfield:title,title:标题,class:tl,search_exp:like,search_title:标题\r\nfield:ctime,title:发布时间,fun:date(Y-m-d H:i:s,###),class:tl,width:150', '', '', '', '', '', '', '', '', '', '{\"title\":{\"title\":\"\",\"cate\":\"\",\"ctime\":\"\",\"content\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('40', 'report', '举报', '0', '', '1', '{\"1\":[\"309\",\"308\",\"473\",\"307\",\"304\",\"306\",\"474\"]}', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', null, null, null, '50', '', '', '1509613605', '1518367349', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '3', 'field:id,title:ID,width:100,class:tc\r\nfield:uid,title:被举报用户id,width:100,class:tc\r\nfield:ctime,title:举报时间,fun:date(Y-m-d H:i:s,###),class:tl\r\nfield:status,title:状态,search_exp:eq,fun:get_status(###,status,40),class:tl,search_title:状态\r\nfield:notes,title:内容\r\nfield:linkinfo,title:举报人', '', '', '', '', '', '', '', '', '', '{\"title\":{\"status\":\"\",\"ctime\":\"\",\"pk\":\"\",\"uid\":\"\",\"type\":\"\",\"notes\":\"\",\"linkinfo\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('41', 'bank', '银行卡绑定', '0', '', '1', '{\"1\":[\"314\",\"313\",\"312\",\"311\",\"310\"]}', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', null, null, null, '50', '', '', '1509615698', '1509615957', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '1', 'field:id,title:ID,width:100,class:tc\r\nfield:card,title:卡号,class:tl\r\nfield:bank,title:开户行,class:tl,search_exp:eq,search_title:开户银行\r\nfield:nickname,title:开户名,class:tl\r\nfield:address,title:开户地区,class:tl', '', '', '', '', '', '', '', '', '', '{\"title\":{\"address\":\"\",\"nickname\":\"\",\"card\":\"\",\"bank\":\"\",\"uid\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('43', 'folder', '网盘目录', '0', '', '1', '{\"1\":[\"321\",\"328\",\"320\",\"319\",\"318\",\"317\",\"316\"]}', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', null, null, null, '50', '', '', '1509956184', '1512578748', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '3', 'field:id,title:ID,width:100,class:tc\r\nfield:name,title:名称\r\nfield:status,title:状态,fun:get_status(###,43,status),width:100,class:tc,search_exp:eq,search_hidden_admin:true\r\nfield:disorder,title:排序,width:100,class:tc\r\nfield:reid,search_exp:eq_input,search_hidden_admin:true,hidden_admin:true\r\nfield:uid,search_exp:eq_input,search_hidden_admin:true,hidden_admin:true', '', '', '', '', '', '', '', '', '', '{\"title\":{\"is_index\":\"\",\"status\":\"\",\"uid\":\"\",\"disorder\":\"\",\"reids\":\"\",\"reid\":\"\",\"name\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('44', 'money', '收支明细', '0', '', '1', '{\"1\":[\"498\",\"326\",\"467\",\"468\",\"327\",\"325\",\"324\",\"464\",\"465\"]}', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', null, null, null, '50', '', '', '1512446714', '1523805189', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '1', 'field:id,title:ID,width:100,class:tc\r\nfield:type,title:分类,fun:get_status(###,type,44),search_exp:eq\r\nfield:amount,title:总金额\r\nfield:price,title:价格\r\nfield:uid,title:UID,search_exp:eq_input,search_title:UID\r\nfield:no,title:订单号,search_exp:eq_input\r\nfield:ctime,title:时间,fun:date(Y-m-d,###),search_exp:egt\r\nfield:orderprice,hidden:true\r\nfield:about,hidden:true\r\nfield:subuser,hidden:true', '', '', '', '', '', '', '', '', '', '{\"title\":{\"orderprice\":\"\",\"about\":\"\",\"charge\":\"\",\"price\":\"\",\"type\":\"\",\"amount\":\"\",\"ctime\":\"\",\"no\":\"\",\"uid\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('45', 'style', '风格', '0', '', '1', '', '1:基础', '', '', null, null, null, null, '50', '', '', '1512960251', '1512960251', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '1', '\r\n\r\nfield:id,title:ID,width:100,class:tc\r\nfield:title,title:标题,class:tl\r\nfield:author,title:作者,class:tl\r\nfield:category,title:分类,fun:get_status(###,category,45),class:tl,search_exp:eq,search_title:分类\r\nfield:url,title:预览地址,class:tl\r\nfield:static,title:状态,fun:get_status(###,static,45),class:tl,search_exp:eq,search_title:状态\r\n', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `wp_model` VALUES ('46', 'mycss', '自定义css', '0', '', '1', '', '1:基础', '', '', null, null, null, null, '50', '', '', '1512976342', '1512976342', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '1', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `wp_model` VALUES ('47', 'download', '下载日志', '0', '', '1', '', '1:基础', '', '', null, null, null, null, '50', '', '', '1512986671', '1512986671', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '1', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `wp_model` VALUES ('48', 'member_tpl', '会员模板', '0', '', '1', '{\"1\":[\"348\",\"343\",\"347\",\"346\",\"345\",\"344\"]}', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', null, null, null, '50', '', '', '1513733586', '1513737944', '1', 'MyISAM', '', '', '', 'lists:Pub/MemberTpl', '', '', '', '', '', '', '3', '', '', '', '', '', '', '', '', '', '', '{\"title\":{\"domain\":\"\",\"uid\":\"\",\"etime\":\"\",\"download\":\"\",\"index\":\"\",\"developer_id\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('49', 'developer', '开发者', '0', '', '1', '{\"1\":[\"351\",\"352\",\"353\",\"349\",\"350\",\"354\",\"357\",\"356\",\"355\",\"361\"]}', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', null, null, null, '50', '', '', '1513741057', '1514021469', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '1', 'field:id,title:ID,width:100,class:tc\r\nfield:name,title:名称,class:tl\r\nfield:weixin,title:微信,class:tl\r\nfield:qq,title:QQ,class:tl\r\nfield:mobile,title:手机,class:tl\r\nfield:logo,hidden:true\r\nfield:status,title:状态,fun:get_status(###,status,49),search_exp:eq,search_title:状态,class:tl', '', '', '', '', '', '', '', '', '', '{\"title\":{\"etime\":\"\",\"name\":\"\",\"mobile\":\"\",\"uid\":\"\",\"status\":\"\",\"qq\":\"\",\"days\":\"\",\"ctime\":\"\",\"weixin\":\"\",\"logo\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('50', 'case', '开发者案例', '0', '', '1', '', '1:基础', '', '', null, null, null, null, '50', '', '', '1513757016', '1513757016', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '1', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `wp_model` VALUES ('51', 'video', '教学视频', '0', '', '1', '{\"1\":[\"\",\"370\",\"\",\"371\",\"369\",\"\",\"368\"]}', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', null, null, null, '50', '', '', '1513844556', '1513844656', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '3', 'field:id,title:ID,width:100,class:tc\r\nfield:title,title:标题,class:tl\r\nfield:url,title:地址,class:tl\r\nfield:uid,title:买家帐号,class:tl,hidden:true\r\nfield:ctime,title:发布时间,fun:date(Y-m-d H:i:s,###),class:tl', '', '', '', '', '', '', '', '', '', '{\"title\":{\"ctime\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('52', 'banner', '轮播', '0', '', '1', '', '1:基础', '', '', null, null, null, null, '50', '', '', '1513906565', '1513906565', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '1', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `wp_model` VALUES ('53', 'wangpan_config', '网盘类型', '0', '', '1', '{\"1\":[\"429\",\"382\",\"384\",\"386\",\"376\",\"377\",\"378\",\"379\",\"375\",\"501\",\"502\",\"503\",\"508\"]}', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', null, null, null, '50', '', '', '1513911680', '1530774355', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', 'id asc', '1', 'field:id,title:ID,width:100,class:tc\r\nfield:name,title:网盘类型,class:tl\r\nfield:size,title:空间大小,class:tl\r\nfield:max,title:单个文件最大,class:tl\r\nfield:top_menu,title:顶级目录,class:tl\r\nfield:two_menu,title:二级目录,class:tl\r\nfield:advert,hidden:true\r\nfield:download,hidden:true\r\nfield:texiao,hidden:true\r\nfield:two_hour,hidden:true\r\nfield:seo,hidden:true\r\nfield:pay,hidden:true\r\nfield:rate,title:提现利率\r\nfield:wenjianjiatongbu,title:文件夹同步\r\nfield:fufeifencheng,title:付费分成\r\nfield:xiaoshoufencheng,title:销售分成', '', '', '', '', '', '', '', '', 'lists:Wangpan_config_lists', '{\"title\":{\"rate\":\"\",\"texiao\":\"\",\"two_hour\":\"\",\"pay\":\"\",\"size\":\"\",\"max\":\"\",\"top_menu\":\"\",\"two_menu\":\"\",\"name\":\"\",\"wenjianjiatongbu\":\"\",\"fufeifencheng\":\"\",\"xiaoshoufencheng\":\"\",\"iszhongshen\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('54', 'wangpan_price', '网盘价格', '0', '', '1', '{\"1\":[\"388\",\"387\",\"396\",\"389\",\"454\"]}', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', null, null, null, '50', '', '', '1513912988', '1516636050', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', 'sort asc', '1', 'field:id,title:ID,width:100,class:tc\r\nfield:shichang,title:名称\r\nfield:price,title:价格,width:100,class:tc\r\nfield:days,title:天数,width:100,class:tc\r\nfield:type_id,title:网盘类型,class:tl,width:100,search_exp:eq,search_hidden_admin:true,hidden:true\r\n', '', '', '', '', '', '', '', '', '', '{\"title\":{\"shichang\":\"\",\"type_id\":\"\",\"days\":\"\",\"price\":\"\",\"sort\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('55', 'wangpan_log', '网盘升级记录', '0', '', '1', '{\"1\":[\"397\",\"412\",\"398\",\"399\",\"395\",\"394\",\"391\",\"392\",\"393\",\"390\"]}', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', null, null, null, '50', '', '', '1513927426', '1521446883', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '3', 'field:id,title:ID,width:100,class:tc\r\nfield:no,title:订单号,class:tl\r\nfield:type,title:分类,fun:get_status(###,type,55),class:tl,search_exp:eq,search_title:分类\r\nfield:uid,title:会员ID,class:tc,width:50,search_exp:eq_input,search_title:会员ID\r\nfield:price,title:金额,class:tl\r\nfield:days,title:购买天数,class:tl\r\nfield:wangpan_id,title:网盘id,class:tl,hidden:true\r\nfield:shichang,title:时长,class:tl,hidden:true\r\nfield:status,title:状态,fun:get_status(###,status,55),class:tl,search_exp:eq,search_title:状态\r\nfield:ctime,title:购买时间,fun:date(Y-m-d H:i:s,###),class:tl,search_exp:between,search_title1:起始时间,search_title2:结束时间', '', '', '', '', '', '', '', '', 'lists:Wangpan_log_lists', '{\"title\":{\"uid\":\"\",\"type\":\"\",\"pay_way\":\"\",\"days\":\"\",\"no\":\"\",\"shichang\":\"\",\"status\":\"\",\"price\":\"\",\"wangpan_id\":\"\",\"ctime\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('56', 'download_log', '下载记录', '0', '', '1', '{\"1\":[\"405\",\"404\",\"403\",\"402\",\"401\"]}', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', null, null, null, '50', '', '', '1513934753', '1514280343', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '3', 'field:id,title:ID,width:100,class:tc\r\nfield:uid,title:买家帐号,class:tl,hidden:true\r\nfield:size,title:文件大小,class:tl\r\nfield:file_id,title:文件id,class:tl,hidden:true\r\nfield:ctime,title:下载时间,fun:date(Y-m-d H:i:s,###),class:tl', '', '', '', '', '', '', '', '', '', '{\"title\":{\"url\":\"\",\"uid\":\"\",\"size\":\"\",\"file_id\":\"\",\"ctime\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('57', 'developer_log', '开发者购买记录', '0', '', '1', '{\"1\":[\"410\",\"411\",\"409\",\"408\",\"407\",\"406\"]}', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', null, null, null, '50', '', '', '1513999393', '1516066690', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '1', 'field:id,title:ID,width:100,class:tc\r\nfield:no,title:订单号,class:tl\r\nfield:uid,title:买家帐号,class:tl,hidden:true\r\nfield:price,title:金额,class:tl\r\nfield:days,title:时长,class:tl\r\nfield:status,title:状态,fun:get_status(###,status,57),class:tl,search_exp:eq,search_title:状态\r\nfield:ctime,title:购买时间,fun:date(Y-m-d H:i:s,###),class:tl', '', '', '', '', '', '', '', '', '', '{\"title\":{\"price\":\"\",\"uid\":\"\",\"days\":\"\",\"status\":\"\",\"ctime\":\"\",\"no\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('58', 'file_log', '文件购买记录', '0', '', '1', '{\"1\":[\"487\",\"505\",\"484\",\"488\",\"418\",\"470\",\"471\",\"462\",\"457\",\"461\",\"460\",\"417\",\"416\",\"414\",\"415\",\"413\"]}', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', null, null, null, '50', '', '', '1514273077', '1529246427', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '3', 'field:id,title:ID,width:100,class:tc,hidden:true\r\nfield:no,title:订单号,search_exp:like,search_title:订单号,width:150,class:tc\r\nfield:ctime,title:购买时间,fun:date(Y-m-d H:i,###),class:tc,search_exp:between,search_title1:起始时间,search_title2:结束时间\r\nfield:amount,title:订单金额,width:80,class:tc\r\nfield:money,title:会员分成,width:80,class:tc\r\nfield:feilv,title:平台分成,width:80,class:tc\r\nfield:price,title:软件价格,class:tl\r\nfield:pay_way,title:支付方式,search_exp:eq,search_hidden_admin:true,width:80,class:tc\r\nfield:status,title:状态,fun:get_status(###,status,58),search_exp:eq,search_title:状态,width:80,class:tc\r\nfield:uid,title:UID,search_exp:eq_input,search_title:UID,width:70,class:tc\r\nfield:code,hidden:true,search_exp:eq\r\nfield:card,hidden:true\r\nfield:name,title:软件名称', '', '', '', '', '', '', '', '', 'show:File_log_show\r\nlists:File_log_lists', '{\"title\":{\"feilv\":\"\",\"num\":\"\",\"card\":\"\",\"money\":\"\",\"pay_way\":\"\",\"ip\":\"\",\"downtime\":\"\",\"name\":\"\",\"mobile\":\"\",\"email\":\"\",\"price\":\"\",\"amount\":\"\",\"status\":\"\",\"uid\":\"\",\"ctime\":\"\",\"no\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('59', 'money_details', '资金明细', '0', '', '1', '{\"1\":[\"463\",\"424\",\"423\",\"422\",\"421\",\"420\"]}', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', null, null, null, '50', '', '', '1514364793', '1517681821', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '1', 'field:id,title:ID,width:100,class:tc\r\nfield:no,title:订单号,class:tl\r\nfield:uid,title:商家,class:tl,hidden:true,search_exp:eq\r\nfield:amount,title:金额,class:tl\r\nfield:notes,title:资金备注,class:tl\r\nfield:ctime,title:时间,fun:date(Y-m-d H:i:s,###),class:tl,search_exp:egt', '', '', '', '', '', '', '', '', '', '{\"title\":{\"type\":\"\",\"uid\":\"\",\"notes\":\"\",\"ctime\":\"\",\"no\":\"\",\"amount\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('86', 'config', '系统配置', '0', '', '1', '{\"1\":[\"434\",\"432\",\"433\",\"435\",\"441\",\"\",\"436\",\"437\",\"440\",\"442\"]}', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', null, null, null, '50', '', '', '1516261717', '1517977160', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', 'sort asc', '1', 'field:id,title:ID,width:50,class:tc\r\nfield:title,title: 标题,class:tl\r\nfield:name,title:标示,width:200,class:tc\r\nfield:group,title:分组,fun:get_status(###,group,86),width:100,class:tc,search_exp:eq,search_title:分组', '', '', '', '', '', '', '', '', '', '{\"title\":{\"title\":\"\",\"name\":\"\",\"type\":\"\",\"group\":\"\",\"value\":\"\",\"remark\":\"\",\"status\":\"\",\"sort\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('87', 'userconfig', '用户网盘设置', '0', '', '1', '', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', null, null, null, '50', '', '', '1516525746', '1516540005', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '2', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `wp_model` VALUES ('88', 'scorelog', '积分日志', '0', '', '1', '{\"1\":[\"476\",\"478\",\"477\",\"\",\"479\"]}', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', null, null, null, '10', '', '', '1518449365', '1518451054', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '1', 'field:id,title:ID,width:50,class:tc\r\nfield:uid,title:UID,width:100,class:tc,search_exp:eq_input,search_title:UID\r\nfield:score,title:积分,width:100,class:tc\r\nfield:about,title:事由\r\nfield:ctime,title:时间,width:150,class:tc,fun:date(Y-m-d H:i:s,###)\r\n', '', '', '', '', '', '', '', '', '', '{\"title\":{\"uid\":\"\",\"score\":\"\",\"about\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('89', 'zhifutongdao', '支付通道', '0', '', '1', '{\"1\":[\"490\",\"497\",\"491\",\"496\",\"492\",\"494\",\"495\",\"493\"]}', '1:基础', '', '', 'title:标题:[EDIT]\r\nid:操作:[EDIT]|编辑,[DEL]|删除:100:tc', null, null, null, '50', '', '', '1522724300', '1523849087', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '1', 'field:id,title:ID,width:50,class:tc\r\nfield:title,title:标题,class:tl\r\nfield:title1,title:支付名称,width:100,class:tc\r\nfield:name,title:标示,width:100,class:tc\r\nfield:lilv,title:利率,width:100,class:tc\r\nfield:category,title:支付分类,width:100,class:tc,fun:get_status(###,category,89),search_exp:eq,search_title:支付分类\r\nfield:type,title:支付场景,width:100,class:tc,fun:get_status(###,type,89)\r\nfield:status,title:状态,fun:get_status(###,status,89),width:100,class:tc', '', '', '', '', '', '', '', '', '', '{\"title\":{\"title\":\"\",\"title1\":\"\",\"name\":\"\",\"sort\":\"\",\"lilv\":\"\",\"category\":\"\",\"type\":\"\",\"status\":\"\"}}', '', '');
INSERT INTO `wp_model` VALUES ('90', 'file_index', '文件索引', '0', '', '1', '', '1:基础', '', '', null, null, null, null, '10', '', '', '1530025334', '1530025334', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '1', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `wp_model` VALUES ('91', 'menu_often', '常用菜单', '0', '', '1', '', '1:基础', '', '', null, null, null, null, '10', '', '', '1531665996', '1531665996', '1', 'MyISAM', '', '', '', '', '', '', '', '', '', '', '1', '', '', '', '', '', '', '', '', '', '', '', '', '');

-- ----------------------------
-- Table structure for `wp_money`
-- ----------------------------
DROP TABLE IF EXISTS `wp_money`;
CREATE TABLE `wp_money` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `ctime` int(10) NOT NULL COMMENT '时间',
  `amount` decimal(10,5) NOT NULL COMMENT '总金额',
  `about` varchar(255) NOT NULL COMMENT '说明',
  `type` tinyint(4) NOT NULL COMMENT '分类',
  `no` varchar(50) NOT NULL COMMENT '订单号',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `charge` decimal(10,5) unsigned NOT NULL COMMENT '手续费',
  `price` decimal(10,5) NOT NULL COMMENT '会员金额',
  `orderprice` decimal(10,2) unsigned NOT NULL COMMENT '订单金额',
  `subuser` int(10) unsigned NOT NULL COMMENT '推广会员ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_money
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_money_details`
-- ----------------------------
DROP TABLE IF EXISTS `wp_money_details`;
CREATE TABLE `wp_money_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `amount` decimal(10,2) NOT NULL COMMENT '金额',
  `no` varchar(255) NOT NULL COMMENT '订单号',
  `ctime` int(10) NOT NULL COMMENT '时间',
  `notes` varchar(255) NOT NULL COMMENT '资金备注',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '分类',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_money_details
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_mycss`
-- ----------------------------
DROP TABLE IF EXISTS `wp_mycss`;
CREATE TABLE `wp_mycss` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `index` varchar(255) NOT NULL COMMENT '首页css',
  `download` varchar(255) NOT NULL COMMENT '下载页css',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_mycss
-- ----------------------------
INSERT INTO `wp_mycss` VALUES ('5', '0', '26', 'a{color:#f00;}', 'a{color:#0f0;}');
INSERT INTO `wp_mycss` VALUES ('6', '0', '143', '11', '11');

-- ----------------------------
-- Table structure for `wp_news`
-- ----------------------------
DROP TABLE IF EXISTS `wp_news`;
CREATE TABLE `wp_news` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `title` varchar(255) NOT NULL COMMENT '标题',
  `content` text NOT NULL COMMENT '内容',
  `ctime` int(10) NOT NULL COMMENT '发布时间',
  `category` tinyint(4) NOT NULL COMMENT '分类',
  `description` text NOT NULL COMMENT '摘要',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_news
-- ----------------------------
INSERT INTO `wp_news` VALUES ('4', '0', '帮助中心', '帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心', '1513836038', '2', '帮助中心帮助中心', '34');
INSERT INTO `wp_news` VALUES ('5', '0', '新闻', '新闻新闻新闻新闻', '1513836008', '1', '新闻新闻新闻', '34');
INSERT INTO `wp_news` VALUES ('6', '0', '帮助中心', '帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心', '1513836038', '2', '帮助中心帮助中心', '34');
INSERT INTO `wp_news` VALUES ('7', '0', '新闻', '新闻新闻新闻新闻', '1513836008', '1', '新闻新闻新闻', '34');
INSERT INTO `wp_news` VALUES ('8', '0', '帮助中心', '帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心', '1513836038', '2', '帮助中心帮助中心', '34');
INSERT INTO `wp_news` VALUES ('18', '0', '帮助中心', '帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心帮助中心', '1513836038', '2', '帮助中心帮助中心', '34');

-- ----------------------------
-- Table structure for `wp_order`
-- ----------------------------
DROP TABLE IF EXISTS `wp_order`;
CREATE TABLE `wp_order` (
  `id` int(8) NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `no` varchar(100) NOT NULL COMMENT '订单号',
  `notes` text NOT NULL COMMENT '备注',
  `amount` decimal(10,2) unsigned NOT NULL COMMENT '金额',
  `status` char(50) NOT NULL DEFAULT '0' COMMENT '状态',
  `ctime` int(10) NOT NULL COMMENT '下单时间',
  `buyer_uid` int(10) unsigned NOT NULL COMMENT ' 买家id',
  `address_id` int(10) unsigned NOT NULL COMMENT '地址id',
  `seller_uid` int(10) unsigned NOT NULL COMMENT '卖家id',
  `pay_id` varchar(255) NOT NULL COMMENT '支付流水号',
  `pay_type` varchar(255) NOT NULL COMMENT '支付方式',
  `pay_time` int(10) NOT NULL COMMENT '支付时间',
  PRIMARY KEY (`id`),
  KEY `uid` (`buyer_uid`),
  KEY `no` (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of wp_order
-- ----------------------------
INSERT INTO `wp_order` VALUES ('8', '575fb545b06c4', '', '0.00', '0', '1465890117', '31', '0', '0', '', '', '0');
INSERT INTO `wp_order` VALUES ('9', '575fb9f111466', '', '0.00', '0', '1465891313', '31', '0', '0', '', '', '0');
INSERT INTO `wp_order` VALUES ('10', '575fba9fc79c4', '', '0.00', '0', '1465891487', '31', '0', '0', '', '', '0');
INSERT INTO `wp_order` VALUES ('11', '575fbaf08303e', '', '0.00', '0', '1465891568', '31', '0', '0', '', '', '0');
INSERT INTO `wp_order` VALUES ('12', '575fbc6654498', '', '0.00', '0', '1465891942', '31', '0', '0', '', '', '0');
INSERT INTO `wp_order` VALUES ('13', '575fc98559fd6', '', '0.00', '0', '1465895301', '37', '0', '0', '', '', '0');
INSERT INTO `wp_order` VALUES ('14', '575fc9aa061fb', '', '0.00', '0', '1465895338', '37', '0', '0', '', '', '0');
INSERT INTO `wp_order` VALUES ('15', '5760a4ef4066d', '', '0.00', '0', '1465951471', '31', '0', '0', '', '', '0');
INSERT INTO `wp_order` VALUES ('16', '5760a52ee8a8c', '', '0.00', '0', '1465951534', '31', '0', '0', '', '', '0');
INSERT INTO `wp_order` VALUES ('17', '5760a564cf341', '', '0.00', '0', '1465951588', '31', '0', '0', '', '', '0');
INSERT INTO `wp_order` VALUES ('18', '5760a579e2119', '', '0.00', '0', '1465951609', '31', '0', '0', '', '', '0');
INSERT INTO `wp_order` VALUES ('19', '576105faeabe5', '', '0.00', '0', '1465976314', '37', '0', '0', '', '', '0');
INSERT INTO `wp_order` VALUES ('20', '5761140f1f436', '', '0.00', '0', '1465979919', '31', '0', '0', '', '', '0');

-- ----------------------------
-- Table structure for `wp_order_goods`
-- ----------------------------
DROP TABLE IF EXISTS `wp_order_goods`;
CREATE TABLE `wp_order_goods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL COMMENT '订单id',
  `uid` int(11) NOT NULL COMMENT '用户id',
  `goods_id` int(11) NOT NULL DEFAULT '0' COMMENT '产品id',
  `status` int(11) NOT NULL DEFAULT '0' COMMENT '商品配送情况，0， 未发货，1：已发货，2：已收货，3：备货中',
  `goods_attr` varchar(255) NOT NULL DEFAULT '0' COMMENT '属性',
  `goods_number` smallint(6) NOT NULL COMMENT '数量',
  `goods_price` decimal(10,2) NOT NULL COMMENT '价格',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of wp_order_goods
-- ----------------------------
INSERT INTO `wp_order_goods` VALUES ('1', '12', '31', '118', '0', '0', '1', '0.00');
INSERT INTO `wp_order_goods` VALUES ('2', '13', '31', '119', '0', '0', '1', '0.00');
INSERT INTO `wp_order_goods` VALUES ('3', '14', '31', '119', '0', '0', '1', '0.00');
INSERT INTO `wp_order_goods` VALUES ('4', '14', '31', '119', '0', '0', '1', '0.00');
INSERT INTO `wp_order_goods` VALUES ('5', '15', '31', '122', '0', '0', '1', '0.00');
INSERT INTO `wp_order_goods` VALUES ('6', '15', '31', '118', '0', '0', '1', '0.00');
INSERT INTO `wp_order_goods` VALUES ('7', '16', '31', '122', '0', '0', '1', '0.00');
INSERT INTO `wp_order_goods` VALUES ('8', '16', '31', '118', '0', '0', '1', '0.00');
INSERT INTO `wp_order_goods` VALUES ('9', '17', '31', '122', '0', '0', '1', '0.00');
INSERT INTO `wp_order_goods` VALUES ('10', '17', '31', '118', '0', '0', '1', '0.00');
INSERT INTO `wp_order_goods` VALUES ('11', '18', '31', '122', '0', '0', '1', '0.00');
INSERT INTO `wp_order_goods` VALUES ('12', '18', '31', '118', '0', '0', '1', '0.00');
INSERT INTO `wp_order_goods` VALUES ('13', '20', '31', '118', '0', '0', '1', '0.00');

-- ----------------------------
-- Table structure for `wp_picture`
-- ----------------------------
DROP TABLE IF EXISTS `wp_picture`;
CREATE TABLE `wp_picture` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键id自增',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT '路径',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '图片链接',
  `md5` char(32) NOT NULL DEFAULT '' COMMENT '文件md5',
  `sha1` char(40) NOT NULL DEFAULT '' COMMENT '文件 sha1编码',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '状态',
  `ctime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `about` text NOT NULL,
  `disorder` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `water` varchar(255) NOT NULL DEFAULT '' COMMENT '水印图片',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1104 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_picture
-- ----------------------------
INSERT INTO `wp_picture` VALUES ('1099', '/Uploads/201712/07/6e/076e3caed758a1c18c91a0e9cae3368f.jpg', '/Uploads/201712/07/6e/076e3caed758a1c18c91a0e9cae3368f.jpg', '076e3caed758a1c18c91a0e9cae3368f', '', '0', '0', '', '0', 'Chrysanthemum', '');
INSERT INTO `wp_picture` VALUES ('1100', '/Uploads/201712/1e/4f/1e4fdfed37077db0a4782637a0dade25.jpg', '/Uploads/201712/1e/4f/1e4fdfed37077db0a4782637a0dade25.jpg', '1e4fdfed37077db0a4782637a0dade25', '', '0', '0', '', '0', 'Koala', '');
INSERT INTO `wp_picture` VALUES ('1101', '/Uploads/201712/91/60/91603f0cd517f623cef964c61cdc01cc.jpg', '/Uploads/201712/91/60/91603f0cd517f623cef964c61cdc01cc.jpg', '91603f0cd517f623cef964c61cdc01cc', '', '0', '0', '', '0', 'Penguins', '');
INSERT INTO `wp_picture` VALUES ('1102', '/Uploads/201712/84/51/8451b6706b6c936773b9e994e8342efe.jpg', '/Uploads/201712/84/51/8451b6706b6c936773b9e994e8342efe.jpg', '8451b6706b6c936773b9e994e8342efe', '', '0', '0', '', '0', 'Tulips', '');
INSERT INTO `wp_picture` VALUES ('1103', '/Uploads/201712/51/72/5172ca243f91b5c103260dd5c4e7a85f.jpg', '/Uploads/201712/51/72/5172ca243f91b5c103260dd5c4e7a85f.jpg', '5172ca243f91b5c103260dd5c4e7a85f', '', '0', '0', '', '0', 'Jellyfish', '');

-- ----------------------------
-- Table structure for `wp_recharge`
-- ----------------------------
DROP TABLE IF EXISTS `wp_recharge`;
CREATE TABLE `wp_recharge` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `no` varchar(255) NOT NULL COMMENT '订单号',
  `ctime` int(10) NOT NULL COMMENT '充值时间',
  `amount` decimal(10,2) unsigned NOT NULL COMMENT '充值金额',
  `pay_way` varchar(255) NOT NULL COMMENT '支付方式',
  `pay_price` decimal(10,2) unsigned NOT NULL COMMENT '扣费',
  `status` tinyint(4) NOT NULL COMMENT '充值状态',
  `pay_time` int(10) NOT NULL COMMENT '支付时间',
  `pay_no` varchar(255) NOT NULL COMMENT '支付流水号',
  `price` decimal(10,2) unsigned NOT NULL COMMENT '到账金额',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_recharge
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_report`
-- ----------------------------
DROP TABLE IF EXISTS `wp_report`;
CREATE TABLE `wp_report` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `type` tinyint(4) NOT NULL COMMENT '举报类型',
  `notes` text NOT NULL COMMENT '备注',
  `uid` varchar(255) NOT NULL COMMENT '被举报人id',
  `ctime` int(10) NOT NULL COMMENT '举报时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态',
  `pk` varchar(255) NOT NULL COMMENT '被举报文件id',
  `linkinfo` text NOT NULL COMMENT '举报人信息',
  `ip` varchar(255) NOT NULL COMMENT 'ip',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_report
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_scorelog`
-- ----------------------------
DROP TABLE IF EXISTS `wp_scorelog`;
CREATE TABLE `wp_scorelog` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `about` varchar(255) NOT NULL COMMENT '说明',
  `score` int(10) NOT NULL COMMENT '积分',
  `ctime` int(10) NOT NULL DEFAULT '0' COMMENT '时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_scorelog
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_session`
-- ----------------------------
DROP TABLE IF EXISTS `wp_session`;
CREATE TABLE `wp_session` (
  `session_id` varchar(255) NOT NULL,
  `session_expire` int(11) NOT NULL,
  `session_data` blob,
  UNIQUE KEY `session_id` (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of wp_session
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_software_order`
-- ----------------------------
DROP TABLE IF EXISTS `wp_software_order`;
CREATE TABLE `wp_software_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `order_no` varchar(255) NOT NULL COMMENT '订单号',
  `buyer_id` int(10) unsigned NOT NULL COMMENT '买家id',
  `seller_id` int(10) unsigned NOT NULL COMMENT '卖家id',
  `ctime` int(10) NOT NULL COMMENT '添加时间',
  `amount` decimal(10,2) unsigned NOT NULL COMMENT '金额',
  `pay_way` varchar(255) NOT NULL COMMENT '支付方式',
  `pttc` decimal(10,2) unsigned NOT NULL COMMENT '平台提成',
  `shtc` decimal(10,2) unsigned NOT NULL COMMENT '商户提成',
  `ptlr` decimal(10,2) unsigned NOT NULL COMMENT '平台利润',
  `dlfc` decimal(10,2) unsigned NOT NULL COMMENT '代理分成',
  `is_kou` tinyint(4) NOT NULL COMMENT '是否扣掉此单',
  `is_success` tinyint(4) NOT NULL COMMENT '是否成功下载',
  `status` tinyint(4) NOT NULL COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_software_order
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_style`
-- ----------------------------
DROP TABLE IF EXISTS `wp_style`;
CREATE TABLE `wp_style` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `title` varchar(255) NOT NULL COMMENT '标题',
  `img` varchar(255) NOT NULL COMMENT '效果图',
  `uid` int(10) unsigned NOT NULL COMMENT '用id',
  `author` varchar(255) NOT NULL COMMENT '作者',
  `index_js` text NOT NULL COMMENT '首页js',
  `index_css` text NOT NULL COMMENT '首页css',
  `category` tinyint(4) NOT NULL DEFAULT '1' COMMENT '分类',
  `sort` int(10) unsigned NOT NULL COMMENT '排序',
  `url` varchar(255) NOT NULL COMMENT '预览地址',
  `static` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_style
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_type`
-- ----------------------------
DROP TABLE IF EXISTS `wp_type`;
CREATE TABLE `wp_type` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `reid` int(10) unsigned NOT NULL DEFAULT '0',
  `disorder` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_type
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_typecs`
-- ----------------------------
DROP TABLE IF EXISTS `wp_typecs`;
CREATE TABLE `wp_typecs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `reid` int(10) unsigned NOT NULL DEFAULT '0',
  `disorder` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_typecs
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_url`
-- ----------------------------
DROP TABLE IF EXISTS `wp_url`;
CREATE TABLE `wp_url` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '链接唯一标识',
  `url` char(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `short` char(100) NOT NULL DEFAULT '' COMMENT '短网址',
  `status` tinyint(2) NOT NULL DEFAULT '2' COMMENT '状态',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_url` (`url`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='链接表';

-- ----------------------------
-- Records of wp_url
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_userdata`
-- ----------------------------
DROP TABLE IF EXISTS `wp_userdata`;
CREATE TABLE `wp_userdata` (
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `type` tinyint(3) unsigned NOT NULL COMMENT '类型标识',
  `target_id` int(10) unsigned NOT NULL COMMENT '目标id',
  UNIQUE KEY `uid` (`uid`,`type`,`target_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_userdata
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_video`
-- ----------------------------
DROP TABLE IF EXISTS `wp_video`;
CREATE TABLE `wp_video` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `uid` varchar(255) NOT NULL COMMENT '图片地址',
  `ctime` int(10) NOT NULL COMMENT '发布时间',
  `title` varchar(255) NOT NULL COMMENT '标题',
  `url` varchar(255) NOT NULL COMMENT '视频地址',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_video
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_wangpan_config`
-- ----------------------------
DROP TABLE IF EXISTS `wp_wangpan_config`;
CREATE TABLE `wp_wangpan_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `name` varchar(255) NOT NULL COMMENT '空间类型',
  `size` int(10) unsigned NOT NULL COMMENT '空间大小',
  `max` int(10) unsigned NOT NULL COMMENT '单个文件最大',
  `top_menu` int(10) unsigned NOT NULL COMMENT '顶级目录限制',
  `two_menu` int(10) unsigned NOT NULL COMMENT '二级目录限制',
  `download` tinyint(4) NOT NULL COMMENT '是否有下载页面',
  `advert` tinyint(4) NOT NULL COMMENT '广告',
  `texiao` tinyint(4) NOT NULL COMMENT '自定义特效',
  `two_hour` int(10) unsigned NOT NULL COMMENT '两小时内下载量',
  `seo` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'SEO优化',
  `pay` tinyint(4) NOT NULL DEFAULT '0' COMMENT '付费文件',
  `rate` decimal(10,4) unsigned NOT NULL COMMENT '软件销售费率',
  `wenjianjiatongbu` tinyint(4) NOT NULL COMMENT '文件夹同步',
  `fufeifencheng` decimal(10,5) unsigned NOT NULL COMMENT '付费分成',
  `xiaoshoufencheng` decimal(10,5) unsigned NOT NULL COMMENT '销售分成',
  `iszhongshen` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否终身',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_wangpan_config
-- ----------------------------
INSERT INTO `wp_wangpan_config` VALUES ('1', '0', '免费型', '1000', '20', '15', '30', '1', '1', '0', '400', '0', '1', '0.0250', '0', '0.00000', '0.00000', '0');
INSERT INTO `wp_wangpan_config` VALUES ('2', '0', '普通VIP', '3000', '80', '80', '500', '1', '2', '1', '1000', '1', '1', '0.0180', '1', '0.10000', '0.00100', '0');
INSERT INTO `wp_wangpan_config` VALUES ('3', '0', '黄金VIP', '10000', '100', '150', '1000', '1', '2', '1', '4000', '1', '1', '0.0160', '1', '0.12000', '0.00200', '0');
INSERT INTO `wp_wangpan_config` VALUES ('6', '0', '钻石VIP', '50000', '150', '200', '2000', '0', '0', '1', '999999999', '0', '1', '0.0160', '1', '0.15000', '0.00250', '0');
INSERT INTO `wp_wangpan_config` VALUES ('11', '0', '终身VIP代理', '10000', '120', '500', '2000', '0', '0', '1', '9999999', '0', '1', '0.0150', '1', '0.15000', '0.00200', '1');

-- ----------------------------
-- Table structure for `wp_wangpan_log`
-- ----------------------------
DROP TABLE IF EXISTS `wp_wangpan_log`;
CREATE TABLE `wp_wangpan_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `ctime` int(10) NOT NULL COMMENT '购买时间',
  `status` tinyint(4) NOT NULL COMMENT '状态',
  `price` decimal(10,2) unsigned NOT NULL COMMENT '价格',
  `wangpan_id` int(10) unsigned NOT NULL COMMENT '网盘id',
  `shichang` int(10) unsigned NOT NULL COMMENT '时长',
  `no` varchar(255) NOT NULL COMMENT '订单号',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `pay_way` varchar(255) NOT NULL COMMENT '支付方式',
  `days` int(10) unsigned NOT NULL COMMENT '购买天数',
  `type` tinyint(4) NOT NULL COMMENT '分类',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_wangpan_log
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_wangpan_price`
-- ----------------------------
DROP TABLE IF EXISTS `wp_wangpan_price`;
CREATE TABLE `wp_wangpan_price` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `type_id` int(10) NOT NULL COMMENT '网盘分类',
  `shichang` varchar(255) NOT NULL COMMENT '名称 ',
  `price` decimal(10,2) unsigned NOT NULL COMMENT '价格',
  `days` int(10) unsigned NOT NULL COMMENT '天数',
  `sort` int(10) unsigned NOT NULL COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_wangpan_price
-- ----------------------------
INSERT INTO `wp_wangpan_price` VALUES ('35', '0', '4', '半年', '400.00', '182', '3');
INSERT INTO `wp_wangpan_price` VALUES ('36', '0', '4', '一年', '700.00', '365', '2');
INSERT INTO `wp_wangpan_price` VALUES ('39', '0', '4', '两年', '1300.00', '730', '1');
INSERT INTO `wp_wangpan_price` VALUES ('49', '0', '3', '1个月', '30.00', '28', '1');
INSERT INTO `wp_wangpan_price` VALUES ('50', '0', '3', '半年', '100.00', '180', '2');
INSERT INTO `wp_wangpan_price` VALUES ('51', '0', '3', '1年', '180.00', '365', '3');
INSERT INTO `wp_wangpan_price` VALUES ('52', '0', '3', '2年', '300.00', '730', '4');
INSERT INTO `wp_wangpan_price` VALUES ('53', '0', '6', '1月', '50.00', '30', '1');
INSERT INTO `wp_wangpan_price` VALUES ('55', '0', '6', '半年', '260.00', '182', '3');
INSERT INTO `wp_wangpan_price` VALUES ('56', '0', '6', '1年', '500.00', '365', '5');
INSERT INTO `wp_wangpan_price` VALUES ('57', '0', '2', '1月', '8.80', '30', '1');
INSERT INTO `wp_wangpan_price` VALUES ('59', '0', '2', '半年', '35.00', '182', '4');
INSERT INTO `wp_wangpan_price` VALUES ('60', '0', '2', '1年', '45.00', '365', '1');
INSERT INTO `wp_wangpan_price` VALUES ('61', '0', '8', '一年代理', '2000.00', '365', '0');
INSERT INTO `wp_wangpan_price` VALUES ('62', '0', '9', '平均日交易量超500元以上可兑换联系客户兑换', '1000.00', '365', '0');
INSERT INTO `wp_wangpan_price` VALUES ('63', '0', '10', '平均日交易量超1000元以上可兑换联系客户兑换', '3000.00', '365', '0');
INSERT INTO `wp_wangpan_price` VALUES ('64', '0', '11', '终身', '2000.00', '4294967295', '1');
INSERT INTO `wp_wangpan_price` VALUES ('65', '0', '12', '购买终身VIP送广告位', '1.00', '0', '0');
INSERT INTO `wp_wangpan_price` VALUES ('67', '0', '13', '测试', '1.00', '0', '0');

-- ----------------------------
-- Table structure for `wp_wd_maillog`
-- ----------------------------
DROP TABLE IF EXISTS `wp_wd_maillog`;
CREATE TABLE `wp_wd_maillog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mailtitle` varchar(255) DEFAULT NULL,
  `mailbody` text,
  `sendtime` int(11) DEFAULT NULL,
  `mailto` varchar(255) DEFAULT NULL,
  `msg` varchar(255) DEFAULT NULL,
  `state` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_wd_maillog
-- ----------------------------

-- ----------------------------
-- Table structure for `wp_zhifutongdao`
-- ----------------------------
DROP TABLE IF EXISTS `wp_zhifutongdao`;
CREATE TABLE `wp_zhifutongdao` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目id',
  `title` varchar(255) NOT NULL COMMENT '标题',
  `name` varchar(255) NOT NULL COMMENT '标示',
  `lilv` decimal(10,4) unsigned NOT NULL COMMENT '利率',
  `status` tinyint(4) NOT NULL COMMENT '是否开启',
  `category` tinyint(4) NOT NULL COMMENT '支付分类',
  `type` tinyint(4) NOT NULL COMMENT '使用环境',
  `sort` int(10) unsigned NOT NULL COMMENT '排序',
  `title1` varchar(255) NOT NULL COMMENT '支付名称',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wp_zhifutongdao
-- ----------------------------
INSERT INTO `wp_zhifutongdao` VALUES ('1', '0', '官方支付宝', 'alipay', '0.0060', '1', '3', '1', '0', '支付宝');
INSERT INTO `wp_zhifutongdao` VALUES ('2', '0', '官方微信', 'wxpay', '0.0060', '1', '3', '1', '0', '微信支付');
INSERT INTO `wp_zhifutongdao` VALUES ('3', '0', '官方支付宝', 'alipay', '0.0060', '1', '2', '1', '1', '支付宝');
INSERT INTO `wp_zhifutongdao` VALUES ('4', '0', '官方微信', 'wxpay', '0.0060', '1', '2', '1', '2', '微信支付');
INSERT INTO `wp_zhifutongdao` VALUES ('5', '0', '点缀微信', 'dzwxpay', '0.0060', '0', '3', '1', '1', '微信支付');
INSERT INTO `wp_zhifutongdao` VALUES ('6', '0', '点缀QQ钱包', 'dzqqpay', '0.0060', '1', '3', '1', '1', 'QQ钱包');
INSERT INTO `wp_zhifutongdao` VALUES ('7', '0', '官方支付宝', 'alipay', '0.0060', '0', '1', '1', '1', '支付宝');
INSERT INTO `wp_zhifutongdao` VALUES ('8', '0', '官方微信', 'wxpay', '0.0060', '0', '1', '1', '2', '微信支付');
INSERT INTO `wp_zhifutongdao` VALUES ('9', '0', '点缀QQ钱包', 'dzqqpay', '0.0060', '0', '1', '1', '1', 'QQ钱包');
INSERT INTO `wp_zhifutongdao` VALUES ('10', '0', '点缀微信支付', 'dzwxpay', '0.0060', '0', '1', '1', '2', '微信支付');
INSERT INTO `wp_zhifutongdao` VALUES ('11', '0', '点缀QQ钱包支付', 'dzqqpay', '0.0060', '1', '2', '1', '3', 'QQ钱包');
INSERT INTO `wp_zhifutongdao` VALUES ('12', '0', '网盘购买余额支付', 'yue', '0.0000', '1', '2', '1', '1', '余额支付');
INSERT INTO `wp_zhifutongdao` VALUES ('13', '0', '点缀微信支付', 'dzwxpay', '0.0060', '1', '2', '1', '5', '微信支付（备用）');
INSERT INTO `wp_zhifutongdao` VALUES ('14', '0', '支付宝wap', 'alipay', '0.0060', '0', '1', '2', '0', '支付宝');
INSERT INTO `wp_zhifutongdao` VALUES ('15', '0', '微信wap', 'wxpay', '0.0100', '0', '1', '2', '0', '微信');
INSERT INTO `wp_zhifutongdao` VALUES ('16', '0', '码支付支付宝', 'codealipay', '0.0060', '1', '1', '1', '1', '支付宝');
INSERT INTO `wp_zhifutongdao` VALUES ('17', '0', '码支付微信', 'codewxpay', '0.0060', '1', '1', '1', '2', '微信');
