﻿/*!
* jQuery pinable Plugin v1.1
* http://buildmypinnedsite.com
*
* Copyright 2011, Microsoft
* Licensed under MS-PL.
*
* Date: Friday May 11 2011 12:22:44 -04
* Legal Notice: Any code provided on this site is "sample code" subject to the MSDN Terms of Use (). Using this code means you agree to it.
*/
(function ($) {
    var settings = {};

    var methods = {
        init: function (callerSettings) {
            settings = $.extend(settings, callerSettings);
            settings.element = this;
            showBannerIfNeed();
        },
        destroy: function () {
            settings.element.find('.pinningClose').unbind('click');
            settings.element.find('.pinningClose').show();

            settings.element = undefined;
        }
    };

    function showBannerIfNeed() {
        try {
            if (!window.external.msIsSiteMode()) {
                settings.element.find('.pinningClose').click(function () {
                    settings.element.slideUp('fast');
                    $(this).slideUp('fast');
                });
                settings.element.css('display', 'block');
            } else {
                //we are in pinned moded
            }
        }
        catch (ex) {
            //browsers is not IE9
        }
    }

    $.fn.pinable = function (method) {
        if (methods[method]) {
            return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
        } else if (typeof method === 'object' || !method) {
            return methods.init.apply(this, arguments);
        } else {
            $.error('Method ' + method + ' does not exist on jQuery.tooltip');
        }
    }
})(jQuery);