--
-- 表的结构 `hs_admins`
--

DROP TABLE `hs_admins`;
CREATE TABLE `hs_admins` (
  `f_id` int(5) NOT NULL auto_increment COMMENT '编号',
  `f_userName` varchar(255) NOT NULL COMMENT '用户名',
  `f_userPwd` varchar(255) NOT NULL COMMENT '密码',
  PRIMARY KEY  (`f_id`),
  KEY `f_userName` (`f_userName`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='管理员';

-- --------------------------------------------------------

--
-- 表的结构 `hs_ads`
--

DROP TABLE `hs_ads`;
CREATE TABLE `hs_ads` (
  `f_id` int(10) NOT NULL auto_increment COMMENT '编号',
  `f_name` varchar(255) NOT NULL COMMENT '广告位名称',
  `f_code` text COMMENT '广告代码',
  PRIMARY KEY  (`f_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='广告';

-- --------------------------------------------------------

--
-- 表的结构 `hs_applies`
--

DROP TABLE `hs_applies`;
CREATE TABLE `hs_applies` (
  `f_id` int(10) NOT NULL auto_increment COMMENT '编号',
  `f_name` varchar(255) NOT NULL COMMENT '网站名称',
  `f_url` varchar(255) NOT NULL COMMENT '网址',
  `f_description` text NOT NULL COMMENT '说明',
  `f_category` varchar(255) NOT NULL COMMENT '分类',
  `f_buildTime` varchar(255) NOT NULL COMMENT '建站时间',
  `f_ips` varchar(255) NOT NULL COMMENT '日IP访问量',
  `f_contact` varchar(255) NOT NULL COMMENT '联系人',
  `f_tel` varchar(255) NOT NULL COMMENT '电话',
  `f_qq` varchar(255) NOT NULL COMMENT 'QQ',
  `f_linked` tinyint(1) NOT NULL default '0' COMMENT '是否已经做好友情链接',
  `f_addTime` int(10) NOT NULL COMMENT '申请时间',
  `f_addIp` varchar(255) NOT NULL COMMENT '申请IP',
  PRIMARY KEY  (`f_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='收录申请';

-- --------------------------------------------------------

--
-- 表的结构 `hs_categories`
--

DROP TABLE `hs_categories`;
CREATE TABLE `hs_categories` (
  `f_id` int(10) NOT NULL auto_increment COMMENT '编号',
  `f_sort` int(10) NOT NULL default '0' COMMENT '排好的总顺序',
  `f_parentId` int(10) NOT NULL default '0' COMMENT '父类编号',
  `f_haveChild` tinyint(1) NOT NULL default '0' COMMENT '是否有子分类',
  `f_autoList` tinyint(1) NOT NULL default '1' COMMENT '是否自动列出',
  `f_indent` tinyint(1) NOT NULL default '1' COMMENT '缩进',
  `f_order` int(10) NOT NULL default '1000' COMMENT '顺序，越小越靠前',
  `f_name` varchar(255) NOT NULL COMMENT '名称',
  `f_englishName` varchar(255) default NULL COMMENT '英文名，用于网址文件名',
  `f_url` varchar(255) default NULL COMMENT '网址',
  `f_keywords` varchar(255) default NULL COMMENT '关键词',
  `f_description` text COMMENT '描述',
  PRIMARY KEY  (`f_id`),
  KEY `f_parentId` (`f_parentId`,`f_indent`,`f_order`),
  KEY `f_sort` (`f_sort`),
  KEY `f_autoList` (`f_autoList`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='分类';

-- --------------------------------------------------------

--
-- 表的结构 `hs_sites`
--

DROP TABLE `hs_sites`;
CREATE TABLE `hs_sites` (
  `f_id` int(10) NOT NULL auto_increment COMMENT '编号',
  `f_categoryId` int(10) NOT NULL COMMENT '分类编号',
  `f_expireTime` int(10) NOT NULL default '0' COMMENT '过期时间',
  `f_isRecommend` tinyint(1) NOT NULL default '0' COMMENT '推荐',
  `f_order` int(10) NOT NULL default '1000' COMMENT '顺序，越小越靠前',
  `f_name` varchar(255) NOT NULL COMMENT '名称',
  `f_url` varchar(255) NOT NULL COMMENT '网址',
  `f_color` varchar(7) default NULL COMMENT '字色',
  `f_description` text COMMENT '说明',
  `f_clickScore` int(10) NOT NULL default '0' COMMENT '净点入数',
  `f_clickIn` int(10) NOT NULL default '0' COMMENT '点入数',
  `f_clickOut` int(10) NOT NULL default '0' COMMENT '点出数',
  PRIMARY KEY  (`f_id`),
  KEY `f_categoryId` (`f_categoryId`),
  KEY `f_expireTime` (`f_expireTime`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='网址';

-- --------------------------------------------------------

--
-- 表的结构 `hs_users`
--

DROP TABLE `hs_users`;
CREATE TABLE `hs_users` (
  `f_id` int(10) NOT NULL auto_increment COMMENT '编号',
  `f_status` tinyint(1) NOT NULL default '1' COMMENT '状态。1-正常；0-屏蔽',
  `f_userName` varchar(50) NOT NULL COMMENT '用户名',
  `f_pwd` varchar(50) NOT NULL COMMENT '密码',
  `f_regTime` int(10) NOT NULL COMMENT '注册时间',
  `f_regIp` varchar(255) NOT NULL COMMENT '注册IP',
  `f_lastTime` int(10) NOT NULL default '0' COMMENT '最后登录时间',
  `f_lastIp` varchar(255) default NULL COMMENT '最后登录IP',
  `f_loginTimes` int(10) NOT NULL default '0' COMMENT '登录次数',
  PRIMARY KEY  (`f_id`),
  KEY `f_userName` (`f_userName`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='用户';

-- --------------------------------------------------------

--
-- 表的结构 `hs_usersites`
--

DROP TABLE `hs_usersites`;
CREATE TABLE `hs_usersites` (
  `f_id` int(10) NOT NULL auto_increment COMMENT '编号',
  `f_userId` int(10) NOT NULL COMMENT '用户编号',
  `f_order` int(10) NOT NULL default '1000' COMMENT '顺序，越小越靠前',
  `f_name` varchar(255) NOT NULL COMMENT '名称',
  `f_url` varchar(255) NOT NULL COMMENT '网址',
  `f_addTime` int(10) NOT NULL COMMENT '添加时间',
  PRIMARY KEY  (`f_id`),
  KEY `f_userId` (`f_userId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='用户收藏的网址';
