<?php


require_once( $dRootDir."inc/classes/smarty/Smarty.class.php" );
class template extends smarty
{

	function template( $arrParams = "" )
	{
		if ( is_array( $arrParams ) )
		{
			$this->template_dir = $arrParams['templateDir'];
			$this->config_dir = $arrParams['configDir'];
			$this->compile_dir = $arrParams['compileDir'];
			$this->cache_dir = $arrParams['cacheDir'];
			$this->left_delimiter = $arrParams['leftDelimiter'];
			$this->right_delimiter = $arrParams['rightDelimiter'];
			$this->compile_id = $_SERVER['PHP_SELF'];
		}
		else
		{
			$this->template_dir = "./";
			$this->config_dir = "./";
			$this->compile_dir = "./tmp/compile/";
			$this->cache_dir = "./tmp/cache/";
			$this->left_delimiter = "{";
			$this->right_delimiter = "}";
			$this->compile_id = $_SERVER['PHP_SELF'];
		}
		$this->use_sub_dirs = false;
	}

	function fetch( $templateFile = "", $cacheId = null, $compileId = null, $display = false )
	{
		$templateFile = trim( $templateFile );
		if ( empty( $templateFile ) )
		{
			$templateFile = $this->gettemplatefilename( );
		}
		return smarty::fetch( $templateFile, $cacheId, $compileId, $display );
	}

	function display( $templateFile = "", $cacheId = null, $compileId = null )
	{
		$templateFile = trim( $templateFile );
		if ( empty( $templateFile ) )
		{
			$templateFile = $this->gettemplatefilename( );
		}
		smarty::display( $templateFile, $cacheId, $compileId );
	}

	function gettemplatefilename( )
	{
		$path = !empty( $_SERVER['SCRIPT_FILENAME'] ) ? $_SERVER['SCRIPT_FILENAME'] : $_SERVER['PATH_TRANSLATED'];
		$templateFile = basename( $path );
		$templateFile = eregi_replace( ".php\$", ".tpl", $templateFile );
		return $templateFile;
	}

}

?>
