/*
 * 获取日志信息js
 */

var client = function(){
    //rendering engines
    var engine = {            
        ie: 0,
        gecko: 0,
        webkit: 0,
        khtml: 0,
        opera: 0,

        //complete version
        ver: null  
    };
    
    //browsers
    var browser = {
        
        //browsers
        ie: 0,
        firefox: 0,
        safari: 0,
        konq: 0,
        opera: 0,
        chrome: 0,
        safari: 0,

        //specific version
        ver: null
    };

    
    //platform/device/OS
    var system = {
        win: false,
        mac: false,
        x11: false,
        
        //mobile devices
        iphone: false,
        ipod: false,
        nokiaN: false,
        winMobile: false,
        macMobile: false,
        
        //game systems
        wii: false,
        ps: false 
    };    

    //detect rendering engines/browsers
    var ua = navigator.userAgent;    
    if (window.opera){
        engine.ver = browser.ver = window.opera.version();
        engine.opera = browser.opera = parseFloat(engine.ver);
    } else if (/AppleWebKit\/(\S+)/.test(ua)){
        engine.ver = RegExp["$1"];
        engine.webkit = parseFloat(engine.ver);
        
        //figure out if it's Chrome or Safari
        if (/Chrome\/(\S+)/.test(ua)){
            browser.ver = RegExp["$1"];
            browser.chrome = parseFloat(browser.ver);
        } else if (/Version\/(\S+)/.test(ua)){
            browser.ver = RegExp["$1"];
            browser.safari = parseFloat(browser.ver);
        } else {
            //approximate version
            var safariVersion = 1;
            if (engine.webkit < 100){
                safariVersion = 1;
            } else if (engine.webkit < 312){
                safariVersion = 1.2;
            } else if (engine.webkit < 412){
                safariVersion = 1.3;
            } else {
                safariVersion = 2;
            }   
            
            browser.safari = browser.ver = safariVersion;        
        }
    } else if (/KHTML\/(\S+)/.test(ua) || /Konqueror\/([^;]+)/.test(ua)){
        engine.ver = browser.ver = RegExp["$1"];
        engine.khtml = browser.konq = parseFloat(engine.ver);
    } else if (/rv:([^\)]+)\) Gecko\/\d{8}/.test(ua)){    
        engine.ver = RegExp["$1"];
        engine.gecko = parseFloat(engine.ver);
        
        //determine if it's Firefox
        if (/Firefox\/(\S+)/.test(ua)){
            browser.ver = RegExp["$1"];
            browser.firefox = parseFloat(browser.ver);
        }
    } else if (/MSIE ([^;]+)/.test(ua)){    
        engine.ver = browser.ver = RegExp["$1"];
        engine.ie = browser.ie = parseFloat(engine.ver);
    }
    
    //detect browsers
    browser.ie = engine.ie;
    browser.opera = engine.opera;

    //detect platform
    var p = navigator.platform;
    system.win = p.indexOf("Win") == 0;
    system.mac = p.indexOf("Mac") == 0;
    system.x11 = (p == "X11") || (p.indexOf("Linux") == 0);

    //detect windows operating systems
    if (system.win){
        if (/Win(?:dows )?([^do]{2})\s?(\d+\.\d+)?/.test(ua)){
            if (RegExp["$1"] == "NT"){
                switch(RegExp["$2"]){
                    case "5.0":
                        system.win = "2000";
                        break;
                    case "5.1":
                        system.win = "XP";
                        break;
                    case "6.0":
                        system.win = "Vista";
                        break;
					case "6.1":
                        system.win = "Windows7";
                        break;
                    default:
                        system.win = "NT";
                        break;                
                }                            
            } else if (RegExp["$1"] == "9x"){
                system.win = "ME";
            } else {
                system.win = RegExp["$1"];
            }
        }
    }
    
    //mobile devices
    system.iphone = ua.indexOf("iPhone") > -1;
    system.ipod = ua.indexOf("iPod") > -1;
    system.nokiaN = ua.indexOf("NokiaN") > -1;
    system.winMobile = (system.win == "CE");
    system.macMobile = (system.iphone || system.ipod);
    
    //gaming systems
    system.wii = ua.indexOf("Wii") > -1;
    system.ps = /playstation/i.test(ua);
    
    //return it
    return {
        engine:     engine,
        browser:    browser,
        system:     system        
    };
}();
function getBrowser(){
	if(client.browser.ie){
		return "ie";
	}else if(client.browser.firefox){
		return "firefox";
	}else if(client.browser.konq){
		return "konq";
	}else if(client.browser.oprea){
		return "oprea";
	}else if(client.browser.chrome){
		return "chrome";
	}else if(client.browser.safari){
		return "safari";
	}
}

function getPlatform(){
	if(client.system.win){
		return client.system.win;
	}else if(client.system.mac){
		return "mac";
	}else if(client.system.x11){
		return "Linux";
	}else if(client.system.iphone){
		return "iphone";
	}else if(client.system.ipod){
		return "ipod";
	}else if(client.system.nokiaN){
		return "nokiaN";
	}else if(client.system.winMobile){
		return "winMobile";
	}else if(client.system.wii){
		return "wii";
	}else if(client.system.ps){
		return "ps";
	}
}
var inTime = new Date().getTime();
var jikeLog ={
	page:function(t){
		var time = new Date().getTime();
		var lt = time - inTime;
		if(arguments.length==0){
			var url = $lUrl+"p.gif?t="+$type+"&bt="+getBrowser()+"&r="+encodeURIComponent(document.referrer)+"&bv="+getBrowserVer()+"&ot="+getPlatform()+"&u="+encodeURIComponent(location.href)+"&dp="+getResolution()+"&temp="+time;
		}else{
			var url = $lUrl+"p.gif?t="+$type+"&bt="+getBrowser()+"&r="+encodeURIComponent(document.referrer)+"&bv="+getBrowserVer()+"&ot="+getPlatform()+"&u="+encodeURIComponent(location.href)+"&dp="+getResolution()+"&lt="+lt+"&temp="+time;
		}
		var img=window["JK_LOG_P"+time]=new Image();
		img.src = url;
	},
	list:function(i,rt){
		var time = new Date().getTime();
		var url = $lUrl+"c.gif?t="+$type+"&i="+i+"&rt="+rt+"&u="+encodeURIComponent(location.href)+"&temp="+time;
		var img=window["JK_LOG_C"+time]=new Image();
		img.src = url;
	},
	relation:function(n,rn){
		var time = new Date().getTime();
		var url = $lUrl+"r.gif?t="+$type+"&n="+n+"&rn="+rn+"&u="+encodeURIComponent(location.href)+"&temp="+time;
		var img=window["JK_LOG_R"+time]=new Image();
		img.src = url;
	},
	search:function(sid){
		var time = new Date().getTime();
		var url = $lUrl+"se.gif?t="+$type+"&bt="+getBrowser()+"&sid="+sid+"&u="+encodeURIComponent(location.href)+"&r="+encodeURIComponent(document.referrer)+"&bv="+getBrowserVer()+"&ot="+getPlatform()+"&dp="+getResolution()+"&sruuid="+query_md5+"&temp="+time;
		var img=window["JK_LOG_SE"+time]=new Image();
		img.src = url;
	}
}

function getResolution(){
	var w = window.screen.width;
	var h = window.screen.height;
	return w+"*"+h;
}
function getBrowserVer(){
	return client.browser.ver;
}

function fss(num,type){
	jikeLog.list(num,type);
}

function frs(num,name){
	jikeLog.relation(num,name);
}


