<?php

/*
*	this file contains the main actions done after user interaction :
*	'addfeed' : inserting a website feed to database
*	'delfeed' : deleting a feed from database
*	'accept' : validating a pending website; state-> 4
*	'dead' : sets a link as dead (verification page can do this) and deletes pending validation for this website if existing ; state-> 3
*	'refuse' : bans the selected website ; state-> 2
*	'delete': deletes the selected website and his thumbnail if file exists
*	'add_cat', 'del_cat', 'edit_cat' : performs insert, delete and update of the specified category
*	'edit_link' : updates the specified link
*	'repair_link' : sets link broken attribute to 0 (not broken)
*/


if(!defined("SCRIPT_ROOT_PATH"))
{
	exit();
}

if (isset($_GET["action"]))
{
	if (isset($_GET["id"]))	($id = $_GET["id"]);
	if (isset($_GET["feedid"])) ($feed_id = $_GET["feedid"]);
	if (isset($_POST["cat_name"])) ($cat_name =  ucfirst ($_POST["cat_name"]));
	if (isset($_POST["category"])) ($category = $_POST["category"]);
	if (isset($_POST["useful"])) ($useful = $_POST["useful"]);
	if (isset($_POST["name"])) ($name = $_POST["name"]);
	if (isset($_POST["url"])) ($url = $_POST["url"]);
	if (isset($_POST["description"])) ($description = $_POST["description"]);
	if (isset($_POST["id_link"])) ($id_link = $_POST["id_link"]);
	if (isset($_POST["url_image"])) ($url_image = $_POST["url_image"]);
	if (isset($_POST["hits"])) ($hits = $_POST["hits"]);
	if (isset($_POST["prio"])) ($prio = $_POST["prio"]);
	if (isset($_POST["vote"])) ($vote = $_POST["vote"]);
	if (isset($_POST["email"])) ($email = $_POST["email"]);

	switch ($_GET["action"])
	{
		case 'addfeed':
			$smarty =& TemplateEngine::getInstance();
			$feed_url = isset($_POST['feed']) ? $_POST['feed'] : "";

			if(!empty($feed_url) && $id != 0)
			{
				$fm =& get_manager('feed');
				$feed = $fm->create(true);

				$attributes = array('id' => '',
									'name' => $name,
									'linkid' => $id,
									'feed' => $feed_url);

				$feed->setVars($attributes);

				$fm->insert($feed);

				$smarty->assign("message",$lang['submit_ok']);
			}
			break;

		case 'delfeed':
			if(isset($feed_id) && $feed_id != 0)
			{
				$criteria = new Criteria('id',$feed_id,'=');
				$criteria->setLimit(1);
				$fm =& get_manager('feed');
				$fm->deleteAll($criteria);
			}
			break;

		case "accept":
		if(isset($id))
		{
			$lm =& get_manager("link");

			$criteria = new Criteria('id',$id,'=');
			$criteria->setLimit(1);

			$lm->update($criteria,array('state' => 4));

			$link =& $lm->get($id);

			$link_image = $link->getVar("image");

			if($CONFIG['rapatrier_thumbs'] && !empty($link_image) && $link_image != 'http://')
			{
				$im = file_get_contents($link_image);
				if($im)
				{
					$handle = fopen(SCRIPT_ROOT_PATH.'/public/thumbs/'.$id.'.jpg','w');
					fwrite($handle, $im);
					fclose($handle);

					$lm->update($criteria,array('image' => $CONFIG['site_url']."/thumbs/".$id.".jpg"));
					unset($criteria);
				}
			}

			$mailm = new MailManager();
			$mailm->setTemplate('subject','accept_mail_subject.html');
			$mailm->setTemplate('body','accept_mail_body.html');
			$mailm->assignArray(array('link_name' => $link->getVar('name')));
			$mailm->setFrom($CONFIG['site_mail']);
			$mailm->setTo($link->getVar('email'));
			$mailm->sendMail();

			$vm =& get_manager("validation");
			$criteria = new Criteria('url',$link->getVar('url'),'=');
			$criteria->setLimit(1);

			$vm->deleteAll($criteria);

			// Attributing points to user
			$links =& $lm->getObjects(new Criteria('id',$id,'='),array('uid'));
			if(count($links) > 0)
			{
				$um =& get_manager('user');
				foreach($links as $link)
				{
					$uid = $link->getVar('uid');
					$um->incrementPoints(new Criteria('id',$uid,'='),$CONFIG['points_per_submit']);
				}
			}

		}
		$smarty->assign("message",$lang['link_validated']);
		break;

		case "dead":
		if(isset($id))
		{
			$lm =& get_manager("link");
			$link =& $lm->get($id,array('url'));
			if ($link && count($link) == 1)
			{
				$vm =& get_manager("validation");
				$criteria = new Criteria('url',$link->getVar('url'),'=');
				$criteria->setLimit(1);
				$vm->deleteAll($criteria);
			}
			$lm->update(new Criteria('id',$id,'='),array('state' => 3));
		}
		break;

		case "refuse":
		if(isset($id))
		{
			$lm =& get_manager("link");
			$link =& $lm->get($id,array('name','url','email'));
			if ($link && count($link) == 1)
			{
				$vm =& get_manager("validation");
				$criteria = new Criteria('url',$link->getVar('url'),'=');
				$criteria->setLimit(1);
				$vm->deleteAll();

				$mailm = new MailManager();
				$mailm->setTemplate('subject','refuse_mail_subject.html');
				$mailm->setTemplate('body','refuse_mail_body.html');
				$mailm->assignArray(array('link_name' => $link->getVar('name')));
				$mailm->setFrom($CONFIG['site_mail']);
				$mailm->setTo($link->getVar('email'));
				$mailm->sendMail();
			}
			$lm->update(new Criteria('id',$id,'='),array('state' => 2));
		}
		$smarty->assign("message",$lang['link_refused']);
		break;

		case "delete":
		if(isset($id))
		{
			$lm =& get_manager("link");
			$fm =& get_manager('feed');
			$tm =& get_manager('tag');

			$link =& $lm->get($id,array('name', 'url','image','email'));
			if ($link && count($link) == 1)
			{
				$vm =& get_manager("validation");
				$criteria = new Criteria('url',$link->getVar('url'),'=');
				$criteria->setLimit(1);
				$vm->deleteAll($criteria);
			}

			$mailm = new MailManager();
			$mailm->setTemplate('subject','delete_mail_subject.html');
			$mailm->setTemplate('body','delete_mail_body.html');
			$mailm->assignArray(array('link_name' => $link->getVar('name')));
			$mailm->setFrom($CONFIG['site_mail']);
			$mailm->setTo($link->getVar('email'));
			$mailm->sendMail();

			$criteria = new Criteria('id',$id,'=');
			$criteria->setLimit(1);
			$lm->deleteAll($criteria);

			$image = $link->getVar('image');
			if(!empty($image) && $image != 'http://')
			{
				$image_url = parse_url($image);
				if($image_url['host'] == $_SERVER['SERVER_NAME'])
				{
					$file = SCRIPT_ROOT_PATH."/public/thumbs/".$id.".jpg";
					if(file_exists($file))
					{
						$suppr = unlink(SCRIPT_ROOT_PATH."/public/thumbs/".$id.".jpg");
					}
				}
			}

			$fm->deleteAll(new Criteria('linkid',$id,'='));

			$tm->deleteLinkTags($id);

		}
		$smarty->assign("message",$lang['link_deleted']);
 		break;

		case "add_cat":
		if (isset($cat_name) && !empty($cat_name))
		{
			$cm =& get_manager("category");

			$criteria = new CriteriaCompo(new Criteria('name',$cat_name,'='),'AND');
			$criteria->add(new Criteria('root',$category,'='),'AND');
			$criteria->setLimit(1);
			$count_existing = $cm->getCount($criteria);

			if($count_existing == 0)
			{
				$mycategory = null;
				$mycategory = $cm->create(true);
				$attributes = array('id' => '', 'name' => $cat_name, 'root' => $category, 'usable' => intval($useful));
				$mycategory->setVars($attributes);

				if($cm->insert($mycategory))
				{
					$smarty->assign("message",$lang['cat_added']);
				}
				else
				{
					$smarty->assign("message",$lang['cat_added_ko']);
				}
			}
			else
			{
				$smarty->assign("message",$lang['cat_alreadyexisting']);
			}
		}
		break;

		case "del_cat":
		if(isset($id))
		{
			$fm =& get_manager('feed');
			$criteria = new Criteria('id',$id,'=');
			$criteria->setLimit(1);
			$cm =& get_manager("category");
			$cm->deleteAll($criteria);
			unset($criteria);

			$criteria = new Criteria('category',$id,'=');
			$lm =& get_manager("link");
			$links =& $lm->getObjects($criteria,array('id','image'));

			if($links && count($links) > 0)
			{
				foreach($links as $link)
				{
					$image = $link->getVar('image');
					$id = $link->getVar('id');
					if(!empty($image) && $image != 'http://')
					{
						$image_url = parse_url($image);
						if($image_url['host'] == $_SERVER['SERVER_NAME'])
						{
							$file = SCRIPT_ROOT_PATH."/public/thumbs/".$id.".jpg";
							if(file_exists($file))
							{
								$suppr = unlink(SCRIPT_ROOT_PATH."/public/thumbs/".$id.".jpg");
							}
						}
					}
					$fm->deleteAll(new Criteria('linkid',$id,'='));
				}
				$lm->deleteAll($criteria);
			}
		}

		$smarty->assign("message",$lang['cat_deleted']);
		break;

		case "edit_cat":
		if (isset($_POST["id_cat"]))
		{
			$cm =& get_manager("category");

			$criteria = new Criteria('id',$_POST["id_cat"],'=');
			$criteria->setLimit(1);
			$cm->update($criteria,array('root' => intval($category), 'name' => $cat_name, 'usable' => intval($useful)));
		}

		$smarty->assign("message",$lang['cat_updated']);
		break;

		case "edit_link":
		$id = isset($_POST["id_link"]) ? $_POST["id_link"] : 0;
		if ($id != 0)
		{
            $con =& Database::getInstance();
			$lm =& get_manager("link");

			$criteria = new Criteria('id',$id,'=');
			$criteria->setLimit(1);

			$updates = array('name' => $con->escapeStr($name),
							'url' => $url,
							'category' => $category,
							'description' => $con->escapeStr($description),
							'image' => $url_image,
							'hits' => $hits,
							'prio' => $prio,
							'vote' => $vote,
							'email' => $email);

			$lm->update($criteria,$updates);

			if($CONFIG['rapatrier_thumbs'] && !empty($url_image) && $url_image != 'http://')
			{
				$im = file_get_contents($url_image);
				if($im)
				{
					$handle = fopen(SCRIPT_ROOT_PATH.'/public/thumbs/'.$id.'.jpg','w');
					fwrite($handle, $im);
					fclose($handle);

					$lm->update($criteria,array('image' => $CONFIG['site_url']."/public/thumbs/".$id.".jpg"));
				}
			}
		}

		foreach($_POST as $key => $value)
		{
			unset($_POST[$key]);
		}

		$smarty->assign("message",$lang['link_updated']);
		break;

		// Sets link broken attribute to 0
		case 'repair_link':
		$lm =& get_manager('link');
		if(isset($id) && $id != 0)
		{
			$criteria = new Criteria('id',$id,'=');
			$criteria->setLimit(1);
			$lm->update($criteria,array('broken' => 0));
		}
		break;
	}
}
?>