<?php
$url = "index.php?cat=directory";

/*
*	Displays the way to the current edited category
*	@param $racine : id of the current category
*	@return void
*/
function getWay($racine = 0,$url = "index.php?cat=directory")
{
	global $lang;
	$smarty =& TemplateEngine::getInstance();
	$myts =& MyTextSanitizer::getInstance();
	$chemin = '';

	$cm =& get_manager("category");
	$cols = array('id','name','root');

	while ($racine != 0)
	{
		$category =& $cm->get($racine,$cols);

		$racine = $category->getVar('root');
		$chemin = ' > <a href="'.$url.'&amp;dir='.$category->getVar('id').'">'.$category->getVar('name').'</a>'.$chemin;
	}
	$chemin = '<a href="'.$url.'">'.$lang['home'].'</a>'.$chemin;
	return $chemin;
}

/*
*	assigns all the cats listed in category with id racine
*	@param int racine
*	@param string url (optional)
*	@return void
*/
function getCatsInDir($racine = 0, $url = "index.php?cat=directory")
{
	global $lang;
	$smarty =& TemplateEngine::getInstance();
	$myts =& MyTextSanitizer::getInstance();
	$cm =& get_manager("category");

	$smarty->assign("way_to_cat",getWay($racine));

	$criteria = new Criteria('root',$racine,'=');
	$criteria->setSort('name');
	$criteria->setOrder('ASC');
	$categories =& $cm->getObjects($criteria,array('id','name','usable'));

	$smarty->assign("nb_sites_in_cat",getNbSiteAndCats($racine));

	if(count($categories) > 0)
	{
		foreach($categories as $category)
		{
			$id = $category->getVar('id');
			$name = $category->getVar('name');

			$criteria = new Criteria('root',$id,'=');
			$count_cats = $cm->getCount($criteria);
			if ($count_cats == 0)
			{
				$js_url = $url."&amp;dir=".$racine."&amp;action=del_cat&amp;id=".$id;
				$js_avert = $lang['jsavert1'];
			}
			else
			{
				$js_url = $url."&amp;dir=".$racine;
				$js_avert = $lang['jsavert2'];
			}

			if ($count_cats < 2)
			{
				$subcats = "(".$count_cats." ".$lang['subcat'].")";
			}
			else
			{
				$subcats = "(".$count_cats." ".$lang['subcats'].")";
			}

			$image = $category->getVar('usable') == 1 ? "yes.gif" : "no.gif";

			$smarty->append("categories",array('id' => $id, 'name' => $name, 'usage_image' => $image, 'subcats' => $subcats, 'js_url' => $js_url, 'js_avert' => $js_avert));
		}
	}
}

/*
*	Returns a string which displays the count of websites contained in the current category
*	@param int racine : id of the current category
*	@param string url (optional)
*	@return string
*/
function getNbSiteAndCats($racine = 0, $url = "index.php?cat=directory")
{
	global $lang;
	$str = "";
	$lm =& get_manager("link");
	$cm =& get_manager("category");

	if($racine == 0)
	{
		$catCount = $cm->getCount();
		$linkCount = $lm->getcount(new Criteria('state',4,'='));
		$str .= $linkCount.' '.$lang['sites'].' '.$lang['in'].' '.$catCount.' '.$lang['cats'];
	}
	else
	{
		$criteria = new CriteriaCompo(new Criteria('category',$racine,'='),'AND');
		$criteria->add(new Criteria('state',4,'='),'AND');
		$linkCount = $lm->getCount($criteria);
		$str .= $linkCount['count'].' '.$lang['sitesincat'];
	}
	return $str;
}

/**
*	displays the form which allows to add a category
*	@param int racine : id of the category in which you want to create the category
*	@param string url (optional)
*	@return void
**/
function getCreateCatForm($racine = 0, $url = "index.php?cat=directory")
{

}

/*
*	Add website form
*	@param int racine : id of the current category
*	@param string url (optional)
*	@return void
*/
function getAddSiteInCatForm($racine = 0, $url = "index.php?cat=directory")
{
	global $CONFIG, $lang;
	$smarty =& TemplateEngine::getInstance();
	$myts =& MyTextSanitizer::getInstance();
	$cm =& get_manager("category");

	if(isset($_GET['action']))
	{
		$name = "";
		$url_posted = "http://";
		$url_image = "";
		$description = "";
		$category = isset($_POST['category']) ? $_POST['category'] : 0;
		$hits = 0;
		$prio = 0;
		$vote = 0;
		$email = '';
	}
	else
	{
		$name = isset($_POST['name']) ? $_POST['name'] : "";
		$url_posted = isset($_POST['url']) ? $_POST['url'] : "http://";
		$description = isset($_POST['description']) ? $_POST['description'] : "";
		$url_image = isset($_POST['url_image']) ? $_POST['url_image'] : "";
		$hits = isset($_POST['hits']) ? $_POST['hits'] : 0;
		$category = isset($_POST['category']) ? $_POST['category'] : 0;
		$prio = isset($_POST['prio']) ? $_POST['prio'] : 0;
		$vote = isset($_POST['vote']) ? $_POST['vote'] : 0;
		$email = isset($_POST['email']) ? $_POST['email'] : '';
	}

	if(isset($_POST['Metas']) && $url_posted != '' && $url_posted != 'http://')
	{
		list($url_posted,$url_image,$nom_proprio,$email,$name,$description) = preremplir_formulaire($url_posted,true);
	}

	$category =& $cm->get($racine,array('name'));

	$smarty->assign('name',$name);
	$smarty->assign('url_posted',$url_posted);
	$smarty->assign('url_image',$url_image);
	$smarty->assign('hits',$hits);
	$smarty->assign('category',$category);
	$smarty->assign('prio',$prio);
	$smarty->assign('vote',$vote);
	$smarty->assign('email',$email);
	$smarty->assign('cat_name',$category->getVar('name'));
	if(empty($url_image) || $url_image == 'http://')
	{
		$url_image = $CONFIG['site_url']."/themes/admin/images/nothumb.gif";
	}
	$smarty->assign("thumb_site",$url_image);

	// Creating fckEditor Description field
	displayFckEditor($description);
}

/*
*	Adds a new website to database
*	@param string url (optional)
*	@return void
*/
function addNewSiteToCat($url = "index.php?cat=directory")
{
	global $CONFIG, $lang;
	$smarty =& TemplateEngine::getInstance();
	$myts =& MyTextSanitizer::getInstance();
	$lm =& get_manager("link");

	$name = isset($_POST['name']) ? $_POST['name'] : "";
	$url_posted = isset($_POST['url']) ? $_POST['url'] : "";
	$description = isset($_POST['description']) ? $_POST['description'] : "";
	$category = isset($_POST['category']) ? $_POST['category'] : 0;
	$url_image = isset($_POST['url_image']) ? $_POST['url_image'] : "";
	$hits = isset($_POST['hits']) ? $_POST['hits'] : 0;
	$prio = isset($_POST['prio']) ? $_POST['prio'] : 0;
	$vote = isset($_POST['vote']) ? $_POST['vote'] : 0;
	$email = isset($_POST['email']) ? $_POST['email'] : '';
	$uid = isset($_COOKIE['uid']) ? $_COOKIE['uid'] : 0;
	// Test des champs
	if(!isset($_POST['Metas']))
	{
		if (empty($name))
		{
			$smarty->assign("message",$lang['incomplete_name']);
		}
		else if(empty($description))
		{
			$smarty->assign("message",$lang['incomplete_desc']);
		}
		else
		{
			if($category == 0)
			{
				$smarty->assign("message",$lang['invalid_cat']);
			}
			else
			{
				if($CONFIG['check_url'])
				{
					$test_url = checkurl($url_posted);
				}
				else
				{
					$test_url = true;
				}
				if ($test_url)
				{
					$link = $lm->create(true);
					$attributes = array('id' => '',
										'uid' => $uid,
										'name' => $name,
										'url' => $url_posted,
										'description' => $description,
										'state' => 4,
										'category' => intval($category),
										'pr' => 0,
										'image' => $url_image,
										'hits' => intval($hits),
										'prio' => intval($prio),
										'vote' => intval($vote),
										'broken' => 0,
										'email' => $email);
					$link->setVars($attributes);

					if($lm->insert($link))
					{
						$feed_name = isset($_POST['feed_name']) ? $_POST['feed_name'] : "";
						$feed_url = isset($_POST['feed_url']) ? $_POST['feed_url'] : "";
						if(!empty($feed_name) && !empty($feed_url))
						{
							$fm =& get_manager('feed');
							$attributes = array('name' => $feed_name,
												'linkid' => $link->getVar('id'),
												'feed' => $feed_url);

							$feed = $fm->create(true);
							$feed->setVars($attributes);
							$fm->insert($feed);
						}

						if($CONFIG['rapatrier_thumbs'] && !empty($url_image) && $url_image != 'http://')
						{
							$im = file_get_contents($url_image);
							if($im)
							{
								$id = $link->getVar('id');
								$handle = fopen(SCRIPT_ROOT_PATH.'/public/thumbs/'.$id.'.jpg','w');
								fwrite($handle, $im);
								fclose($handle);

								$criteria = new Criteria('id',$id,'=');
								$criteria->SetLimit(1);
								$updates = array('image' => $CONFIG['site_url']."/public/thumbs/".$id.".jpg");

								if($lm->update($criteria,$updates))
								{
									$smarty->assign("message",$lang['submit_ok']);
								}
								else
								{
									$smarty->assign("message",$lang['thumbupdate_ko']);
								}
							}
							else
							{
								$smarty->assign("message",$lang['rapat_ko']);
							}
						}
						else
						{
							$smarty->assign("message",$lang['submit_success']);
						}

						foreach($_POST as $key => $value)
						{
							unset($_POST[$key]);
						}
					}
					else
					{
						$smarty->assign("message",$lang['submit_failed']);
					}
				}
				else
				{
					$smarty->assign("message",$lang['url_notresponding']);
				}
			}
		}
	}
}

/*
*	Edit Cat form
*	@param int racine : id of the cat to edit
*	@param string url
*	@return void
*/
function getEditCatForm($racine = 0, $url = "index.php?cat=directory")
{
	$smarty =& TemplateEngine::getInstance();
	$myts =& MyTextSanitizer::getInstance();
	$cm =& get_manager("category");

	$cols = array('name','root','usable');
	$main_category = $cm->get($racine,$cols);

	$root_selected = $main_category->getVar('root');
	$name_selected = $main_category->getVar('name');
	$useful_selected = $main_category->getVar('usable');

	$smarty->assign("cat_name",$main_category->getVar('name'));

	$criteria = new Criteria('id',$racine,'!=');
	$cols = array('id');
	$categories =& $cm->getObjects($criteria,$cols);

	foreach($categories as $category)
	{
		$id = $category->getVar('id');
		$name = show_me_the_way($id);
		if ($id == $main_category->getVar('root'))
		{
			$smarty->append("categories",array('name' => $name, 'id' => $id, 'selected' => 'selected="selected"'));
		}
		else
		{
			$smarty->append("categories",array('name' => $name, 'id' => $id, 'selected' => ''));
		}
	}
	$smarty->assign("useful",$main_category->getVar('usable'));
}

/*
*	Displays the links listed in the category with id 'racine'
*	@param int racine : id of the cat containing the websites
*	@param string url
*	@return void
*/
function getSitesInCurrentCat($racine = 0, $url = "index.php?cat=directory")
{
	global $CONFIG;
	$smarty =& TemplateEngine::getInstance();
	$myts =& MyTextSanitizer::getInstance();
	$cm =& get_manager("category");
	$lm =& get_manager("link");

	$cols = array('id','name','url','description','category','state','image');
	$criteria = new CriteriaCompo(new Criteria('category',$racine,'='),'AND');
	$criteria->add(new Criteria('state',4,'='),'AND');
	$criteria->setOrder('ASC');
	$criteria->setSort('name');
	$links =& $lm->getObjects($criteria,$cols);

	if ($links && count($links) > 0)
	{
		foreach($links as $link)
		{
			$url_affichee = str_replace("http://","",$link->getVar('url'));

			$title_root = $link->getVar('category');
			$title_chemin = '';

			while ($title_root != 0)
			{
				$cols = array('name','root');
				$category =& $cm->get($title_root,$cols);

				$title_root = $category->getVar('root');
				$title_chemin = ' > '.$category->getVar('name').$title_chemin;
			}

			$img = $link->getVar('image');
			if(!empty($img) && $img != 'http://')
			{
				$image = $link->getVar('image');
			}
			else
			{
				$image = $CONFIG['site_url']."/themes/".$CONFIG['theme_dir']."/admin/images/nothumb.gif";
			}
			$smarty->append("sites",array('id' => $link->getVar('id'), 'name' => $link->getVar('name'), 'url' => $link->getVar('url'), 'description' => $link->getVar('description') , 'image' => $image, 'displayed_url' => $url_affichee, 'way_to_cat' => $title_chemin));
		}
	}
}

/*
*	Pre-fills Edit site form
*	@param int racine : id of the category which is currently selected
*	@param string url
*	@return void
*/
function getEditSiteForm($racine = 0, $url = "index.php?cat=directory")
{
	global $CONFIG;
	$smarty =& TemplateEngine::getInstance();
	$myts =& MyTextSanitizer::getInstance();
	$lm =& get_manager("link");
	$cm =& get_manager("category");

	$str = "";
	$id = isset($_GET["id"]) ? $_GET["id"] : (isset($_POST['id']) ? $_POST['id'] : 0);
	$url_posted = isset($_REQUEST['url']) ? $_REQUEST['url'] : "";
	$description = "";
	$link =& $lm->get($id);

	if(isset($_GET['Metas']) && $url_posted != '' && $url_posted != 'http://')
	{
		list($url_posted,$url_image,$nom_proprio,$email,$name,$description) = preremplir_formulaire($url_posted,true);

		$category_selected = $link->getVar('category');
		$description = !empty($description) ? $description : $link->getVar('description');
		$email = !empty($email) ? $email : $link->getVar('email');

		$smarty->assign("name",$name);
		$smarty->assign("url_site",$url_posted);
		$smarty->assign("id",$link->getVar('id'));
		$smarty->assign("hits",$link->getVar('hits'));
		$smarty->assign("prio",$link->getVar('prio'));
		$smarty->assign("vote",$link->getVar('vote'));
		$smarty->assign("email",$email);
		$smarty->assign("url_image",$url_image);
	}
	else
	{
		$category_selected = $link->getVar('category');
		$url_image = $link->getVar('image');

		$smarty->assign("name",$link->getVar('name'));
		$smarty->assign("url_site",$link->getVar('url'));
		$smarty->assign("id",$link->getVar('id'));
		$smarty->assign("hits",$link->getVar('hits'));
		$smarty->assign("prio",$link->getVar('prio'));
		$smarty->assign("vote",$link->getVar('vote'));
		$smarty->assign("email",$link->getVar('email'));
		$smarty->assign("url_image",$link->getVar('image'));

		$description = $link->getVar('description');
	}

	$cols = array('id','name');
	$categories =& $cm->getObjects(new Criteria('usable',1,'='),$cols);

	if(count($categories) > 0)
	{
		foreach($categories as $category)
		{
			$id = $category->getVar('id');
			$name = show_me_the_way($id);

			if ($id == $category_selected)
			{
				$smarty->append("categories",array('name' => $name, 'value' => $id, 'selected' => 'selected="selected"'));
			}
			else
			{
				$smarty->append("categories",array('name' => $name, 'value' => $id, 'selected' => ''));
			}
		}
	}

	if($url_image != '' && $url_image != 'http://')
	{
		$smarty->assign("site_image",$url_image);
	}
	else
	{
		$smarty->assign("site_image",$CONFIG['site_url']."/themes/".$CONFIG['theme_dir']."/admin/images/nothumb.gif");
	}

	// Creating fckEditor Description field
	displayFckEditor($description);
}

/*
*	Display the feeds linked to the website which is currently edited
*	 @param void
*	@return void
*/
function displayFeeds()
{
	$smarty =& TemplateEngine::getInstance();
	$id = isset($_GET['id']) ? $_GET['id'] : 0;

	if($id != 0)
	{
		$fm =& get_manager('feed');
		$criteria = new Criteria('linkid',$id,'=');

		$feeds =& $fm->getObjects($criteria);

		foreach($feeds as $feed)
		{
			$smarty->append("feeds",array('id' => $feed->getVar('id'),
										'name' => $feed->getVar('name'),
										'linkid' => $feed->getVar('linkid'),
										'feed' => $feed->getVar('feed')));
		}
	}
}

?>