<?php

/*
*	displays search results if any
*	@param string url (deprecated)
*	@param string seek : string to search in database
*	@return void
*/
function getSearchResults($url, $seek = "")
{
	global $CONFIG;
	$smarty =& TemplateEngine::getInstance();
	$lm =& get_manager("link");
	$cm =& get_manager("category");

	$recherche = $_POST["seek"];
	$recherche = strtolower($recherche);
	$mots = str_replace('+', ' ', trim($recherche));
	$mots = str_replace('\'', ' ', $mots);
	$mots = str_replace(',', ' ', $mots);
	$mots = str_replace(':', ' ', $mots);
	$tab = explode(' ' , $mots);
	$nb = count($tab);
	$cols = array('id','name','url','description','category');

	$criteriacompo = new CriteriaCompo(null,'OR');

	for($i = 0; $i < $nb; $i++)
	{
		if(strlen($tab[$i]) >= $CONFIG['search_minlength'])
		{
			$criteriacompo->add(new Criteria('name',"%".$tab[$i]."%",'LIKE'),'OR');
		}
	}

	$criteriacompo->setOrder('ASC');
	$criteriacompo->setSort('name');

	$links =& $lm->getObjects($criteriacompo,$cols);

	if ($links && count($links) > 0)
	{
		foreach($links as $link)
		{
			$url_affichee = str_replace("http://","",$link->getVar('url'));

			$title_root = $link->getVar('category');
			$title_chemin = '';

			while ($title_root != 0)
			{
				$cols = array('name','root');
				$category =& $cm->get($title_root,$cols);

				$title_root = $category->getVar('root');
				$title_chemin = ' > '.$category->getVar('name').$title_chemin;
			}

			$smarty->append("search_results", array('id' => $link->getVar('id'),
													'name' => $link->getVar('name'),
													'url' => $link->getVar('url'),
													'image' => $link->getVar('image'),
													'description' => $link->getVar('description'),
													'displayed_url' => $url_affichee,
													'category' => $title_chemin));
		}
	}
	if (isset($_POST["seek"]) and !empty($_POST["seek"]))
	{
		$smarty->assign("nb_results",count($links));
		$smarty->assign("searched_words",$recherche);
		$smarty->assign("site_image", $CONFIG['site_url']."/themes/".$CONFIG['theme_dir']."/admin/images/nothumb.gif");
	}
}

/*
*	Displays either Add link or edit link form
*	@param string url
*	@param int id : default value is 0 (new site); id of the site to edit (editing a website)
*	@return void
*/
function getLinkForm($url, $id = 0)
{
	global $CONFIG, $lang;
	$smarty =& TemplateEngine::getInstance();
	$lm =& get_manager("link");
	$cm =& get_manager("category");

	if($id == 0)
	{
		$name = isset($_POST['name']) ? $_POST['name'] : "";
		$url_posted = isset($_POST['url']) ? $_POST['url'] : "http://";
		$description = isset($_POST['description']) ? $_POST['description'] : "";
		$category = isset($_POST['category']) ? $_POST['category'] : 0;
		$url_image = isset($_POST['url_image']) ? $_POST['url_image'] : "";
		$hits = isset($_POST['hits']) ? $_POST['hits'] : 0;
		$prio = isset($_POST['prio']) ? $_POST['prio'] : 0;
		$vote = isset($_POST['vote']) ? $_POST['vote'] : 0;
		$email = isset($_POST['email']) ? $_POST['email'] : '';

		if(isset($_POST['Metas']) && $url_posted != '' && $url_posted != 'http://')
		{
			list($url_posted,$url_image,$nom_proprio,$email,$name,$description) = preremplir_formulaire($url_posted,true);
		}

		$smarty->assign("form_action",$url);
		$smarty->assign("bouton",$lang['submit']);
		$smarty->assign('title',$lang['yessubmit']);
		$allow = $CONFIG['get_meta_tags'] == 1 ? true : false;
		$smarty->assign('allow_metadetection',$allow);
	}
	else
	{
		$link =& $lm->get($id);

		$category = $link->getVar('category');
		$name = $link->getVar('name');
		$description = $link->getVar('description');
		$url_posted = $link->getVar('url');
		$url_image = $link->getVar('image');
		$hits = $link->getVar('hits');
		$prio = $link->getVar('prio');
		$vote = $link->getVar('vote');
		$email = $link->getVar('email');
		$smarty->assign('title',$lang['linkedition']);
		$smarty->assign("bouton",$lang['edit']);
		$smarty->assign("form_action",$url."&amp;action=edit_link");
		$smarty->assign("link_id",$id);
		$smarty->assign('allow_metadetection',false);
	}

	$smarty->assign('name',$name);
	$smarty->assign('url_posted',$url_posted);
	$smarty->assign('description',$description);
	$smarty->assign('image',$url_image);
	$smarty->assign('hits',$hits);
	$smarty->assign('prio',$prio);
	$smarty->assign('vote',$vote);
	$smarty->assign('email',$email);

	$categories =& $cm->getObjects(new Criteria('usable',1,'='),array('id'));

	if($categories && count($categories) > 0)
	{
		foreach($categories as $single_category)
		{
			$cid = $single_category->getVar('id');
			$name = show_me_the_way($cid);
			if ($cid == $category)
			{
				$smarty->append("categories", array('name' => $name, 'id' => $cid, 'selected' => 'selected="selected"'));
			}
			else
			{
				$smarty->append("categories", array('name' => $name, 'id' => $cid, 'selected' => ''));
			}
		}
	}
	if($url_image != '' && $url_image != 'http://')
	{
		$image = $url_image;
	}
	else
	{
		$image = $CONFIG['site_url']."/themes/admin/images/nothumb.gif";
	}
	displayFckEditor($description);
	$smarty->assign("site_image", $image);
}

/*
*	Checks if all the fields submited were filled in correctly; then adds the website to database
*	@param string url : useful for setting form action url
*	@return void
*/
function addSite($url)
{
	global $CONFIG, $lang;
	$smarty =& TemplateEngine::getInstance();
	$lm =& get_manager("link");

	$name = isset($_POST['name']) ? $_POST['name'] : "";
	$url_posted = isset($_POST['url']) ? $_POST['url'] : "http://";
	$description = isset($_POST['description']) ? $_POST['description'] : "";
	$category = isset($_POST['category']) ? $_POST['category'] : 0;
	$url_image = isset($_POST['url_image']) ? $_POST['url_image'] : "";
	$hits = isset($_POST['hits']) ? $_POST['hits'] : 0;
	$prio = isset($_POST['prio']) ? $_POST['prio'] : 0;
	$vote = isset($_POST['vote']) ? $_POST['vote'] : 0;
	$email = isset($_POST['email']) ? $_POST['email'] : '';
	$uid = isset($_COOKIE['uid']) ? $_COOKIE['uid'] : 0;

	if ((!empty($name)) and (!empty($description)))
	{
		if($CONFIG['check_url'])
		{
			$test_url = checkurl($url_posted);
		}
		else
		{
			$test_url = true;
		}

		if ($test_url)
		{
			$link =& $lm->create(true);
			$attributes = array('id' => '',
								'uid' => $uid,
								'name' => $name,
								'url' => $url_posted,
								'description' => $description,
								'state' => 4,
								'category' => intval($category),
								'pr' => 0,
								'image' => $url_image,
								'hits' => intval($hits),
								'prio' => intval($prio),
								'vote' => intval($vote),
								'email' => $email);
			$link->setVars($attributes);
			$lm->insert($link);

			if($CONFIG['rapatrier_thumbs'] && !empty($url_image) && $url_image != 'http://')
			{
				$im = file_get_contents($url_image);
				if($im)
				{
					$id = $link->getVar('id');
					$handle = fopen(SCRIPT_ROOT_PATH.'/public/thumbs/'.$id.'.jpg','w');
					fwrite($handle, $im);
					fclose($handle);

					$criteria = new Criteria('id',$id,'=');
					$criteria->setLimit(1);
					$updates = array('image' => $CONFIG['site_url']."/thumbs/".$id.".jpg");

					if($lm->update($criteria,$updates))
					{
						$smarty->assign("link_warning",$lang['submit_ok']);
					}
					else
					{
						$smarty->assign("link_warning",$lang['thumbupdate_ko']);
					}
				}
				else
				{
					$smarty->assign("link_warning",$lang['rapat_ko']);
				}
			}
			else
			{
				$smarty->assign("link_warning",$lang['submit_ok']);
			}

			foreach($_POST as $key => $value)
			{
				unset($_POST[$key]);
			}
		}
		else
		{
			$smarty->assign("link_warning",$lang['url_notresponding']);
		}
	}
	else if (empty($name) xor empty($description))
	{
		$smarty->assign("link_warning",$lang['fill_allfields']);
	}
}

/*
*	Displays the feeds of the website edited
*	@param void (form value checked : $_GET['id'] : id of the website edited )
*	@return void
*/
function displayFeeds()
{
	$smarty =& TemplateEngine::getInstance();
	$id = isset($_GET['id']) ? $_GET['id'] : 0;

	if($id != 0)
	{
		$fm =& get_manager('feed');
		$criteria = new Criteria('linkid',$id,'=');

		$feeds =& $fm->getObjects($criteria);

		foreach($feeds as $feed)
		{
			$smarty->append("feeds",array('id' => $feed->getVar('id'),
										'name' => $feed->getVar('name'),
										'linkid' => $feed->getVar('linkid'),
										'feed' => $feed->getVar('feed')));
		}
	}
}

?>