<?php

function updateLinkState($id,$new_state)
{
	global $CONFIG, $lang;
	$lm =& get_manager('link');
	$criteria = new Criteria('id',$id,'=');
	$criteria->setLimit(1);

	if($id != 0 && $CONFIG['inform_user_by_mail'] == 1)
	{
		$link =& $lm->get($id);
		$mailm = new MailManager();

		if($new_state == 4)
		{
			$mailm->setTemplate('subject','accept_mail_subject.html');
			$mailm->setTemplate('body','accept_mail_body.html');

			$image = $link->getVar('image');
			$image_infos = parse_url($image);

			if($CONFIG['rapatrier_thumbs'] && !empty($image) && $image != 'http://' && $image_infos['host'] != $_SERVER['SERVER_NAME'])
			{
				$im = @file_get_contents($image);

				if($im)
				{
					$id = $link->getVar('id');
					$handle = fopen(SCRIPT_ROOT_PATH.'/public/thumbs/'.$id.'.jpg','w');
					fwrite($handle, $im);
					fclose($handle);

					$criteria = new Criteria('id',$id,'=');
					$criteria->setLimit(1);
					$updates = array('image' => $CONFIG['site_url']."/public/thumbs/".$id.".jpg");

					$lm->update($criteria,$updates);
				}
			}
		}
		else if($new_state == 2)
		{
			$mailm->setTemplate('subject','refuse_mail_subject.html');
			$mailm->setTemplate('body','refuse_mail_body.html');
		}

		$mailm->assignArray(array('link_name' => $link->getVar('name')));
		$mailm->setFrom($CONFIG['site_mail']);
		$mailm->setTo($link->getVar('email'));
		$mailm->sendMail();
	}

	$to_update = array('state' => $new_state);
	$lm->update($criteria,$to_update);
}

function deleteLink($id)
{
	global $CONFIG, $lang;
	$lm =& get_manager('link');
	$tm =& get_manager('tag');
	$criteria = new Criteria('id',$id,'=');
	$criteria->setLimit(1);

	if($id != 0 && $CONFIG['inform_user_by_mail'] == 1)
	{
		$link =& $lm->get($id);
		$mailm = new MailManager();

		$mailm->setTemplate('subject','delete_mail_subject.html');
		$mailm->setTemplate('body','delete_mail_body.html');

		$mailm->assignArray(array('link_name' => $link->getVar('name')));
		$mailm->setFrom($CONFIG['site_mail']);
		$mailm->setTo($link->getVar('email'));
		$mailm->sendMail();
	}

	$tm->deleteAll(new Criteria('lid',$id,'='));
	$lm->deleteAll($criteria);
}

function deleteValidation($id)
{
	$vm =& get_manager('validation');
	$criteria = new Criteria('id_site',$id,'=');
	$criteria->setLimit(1);

	$vm->deleteAll($criteria);
}

/**
*	displays links taking in consideration their state
*	@param int state
*	@param string accept : string value of the 'accept' button
*	@return : void
**/
function display_links($state, $accept = '',$premium=false)
{
	global $lang;
	$smarty =& TemplateEngine::getInstance();
	$lm =& get_manager("link");
	$cm =& get_manager("category");

	$accept = empty($accept) ? $lang['restablish'] : $accept;

	$criteria = new CriteriaCompo(new Criteria('state',$state,'='),'AND');
	if($premium) {
		$criteria->add(new Criteria('prio',1,'>='),'AND');
	} else {
		$criteria->add(new Criteria('prio',0,'='),'AND');
	}
	$criteria->setSort('date');

	$order = $premium == false ? 'ASC' : 'DESC';
	$criteria->setOrder($order);

	$links =& $lm->getObjects($criteria);

	if(count($links) > 0)
	{
		foreach($links as $link)
		{
			$url_affichee = str_replace("http://","",$link->getVar('url'));

			$title_root = $link->getVar('category');
			$title_chemin = '';

			while ($title_root != 0)
			{
				$cols = array('name','root');
				$category =& $cm->get($title_root,$cols);
				$title_root = $category->getVar('root');
				$title_chemin = ' > '.$category->getVar('name').$title_chemin;
			}

			switch($state)
			{
				// Not confimed
				case 0:
					$assign = "links_notconfirmed";
					break;

				// Pending links
				case 1:
					if($premium)
					{
						$assign = "premium_links_in_wait";
					}
					else
					{
						$assign = "links_in_wait";
					}

					break;

				// Refused, banned links
				case 2:
					$assign = "links_banned";
					break;

				// Dead links
				case 3:
					$assign = "links_dead";
					break;
			}

			$smarty->append($assign,array('id' => $link->getVar('id'),
															'name' => $link->getVar('name'),
															'image' => $link->getVar('image'),
															'date' => $link->getVar('date'),
															'url' => $link->getVar('url'),
															'displayed_url' => $url_affichee,
															'description' => $link->getVar('description'),
															'accept' => $accept,
															'way_to_cat' => $title_chemin) );
		}
	}
}

/**
*	displays broken links
*	@param void
*	@return void
**/
function displayBrokenLinks()
{
	global $lang;
	$smarty =& TemplateEngine::getInstance();
	$lm =& get_manager("link");
	$cm =& get_manager("category");

	$criteria = new Criteria('broken',1,'=');
	$criteria->setSort('id');
	$criteria->setOrder('ASC');

	//$cols = array('id','name','image','url','description','category');
	$links =& $lm->getObjects($criteria);

	if(count($links) > 0)
	{
		foreach($links as $link)
		{
			$url_affichee = str_replace("http://","",$link->getVar('url'));

			$title_root = $link->getVar('category');
			$title_chemin = '';

			while ($title_root != 0)
			{
				$cols = array('name','root');
				$category =& $cm->get($title_root,$cols);
				$title_root = $category->getVar('root');
				$title_chemin = ' > '.$category->getVar('name').$title_chemin;
			}

			$smarty->append("links_broken",array('id' => $link->getVar('id'),
															'name' => $link->getVar('name'),
															'url' => $link->getVar('url'),
															'image' > $link->getVar('image'),
															'displayed_url' => $url_affichee,
															'description' => $link->getVar('description'),
															'way_to_cat' => $title_chemin));
		}
	}

}

?>