<?php

// Updating config and cleaning smarty cache and compile directories
if (isset($_POST["ok"]))
{
	// writing /conf/config.php file
	$config_manager =& MyconfigManager::getInstance();
	foreach($_POST as $key => $value)
	{
		$myts =& MyTextSanitizer::getInstance();
		$value = $myts->stripSlashesGPC($value);
		if($key != 'ok')
		{
			$config_manager->setVar($key,$value);
		}
	}
	
	if($config_manager->updateConfig())
	{
		// Smarty cache cleanup
		$smarty->clear_all_cache();
		$smarty->clear_compiled_tpl();
		
		$smarty->assign('CONFIG',$config_manager->getConfig());
		
		$smarty->append('warning',$lang['config_updated_ok']);
	}
	else
	{
		$smarty->append('warning',$lang['config_updated_ko']);
	}
}

// Number of links to be displayed per page
for ($i=10; $i<=30; $i+=5)
{
	if ($i == $CONFIG['links'])
	{
		$smarty->append("links",array('value' => $i, 'selected' => "selected='selected'"));
	}
	else
	{
		$smarty->append("links",array('value' => $i, 'selected' => ""));
	}
}

// Number of subcats to display for each category
$choix = array('0','1','2','3','4','5', '10', '15', '20','50','100');
foreach ($choix AS $v)
{
	if ($v == $CONFIG['subdirs'])
	{
		$smarty->append("subdirs",array('value' => $v, 'selected' => "selected='selected'"));
	}
	else
	{
		$smarty->append("subdirs",array('value' => $v, 'selected' => ""));
	}
}

// Default category
$cm =& get_manager("category");
$categories =& $cm->getObjects(new Criteria('usable',1,'='),array('id'));
if(count($categories) > 0)
{
	foreach($categories as $category)
	{
		$id = $category->getVar('id');
		$name = show_me_the_way($id);
		if ($id == $CONFIG['cat_defaut'])
		{
			$smarty->append("cats",array('name' => $myts->htmlSpecialChars($name), 'value' => $id, 'selected' => "selected='selected'"));
		}
		else
		{
			$smarty->append("cats",array('name' => $myts->htmlSpecialChars($name), 'value' => $id, 'selected' => ""));
		}
	}
}

// Site language
$d = dir("../language");
$nodir = " --- ";
$directory = dirname(__FILE__);
$directory = ereg_replace("admin.include","",$directory);
$unelangue = false;
while(false !== ($file = $d->read()))
{
	if(is_dir($directory."/language/".$file) && $file != ".." && $file != ".")
	{
		$unelangue = true;
		if($CONFIG['language'] == $file)
		{
			$smarty->append("languages",array('title' => $file, 'value' => $file, 'selected' => "selected='selected'"));
		}
		else
		{
			$smarty->append("languages",array('title' => $file, 'value' => $file, 'selected' => ""));
		}
	}
}
if ($unelangue == false)
{
	$smarty->append("languages",array('title' => $nodir, 'value' => "", 'selected' => ""));
}
$d->close();

// Keyword count to display on keyword page
for($i = 1;$i <= 10;$i++)
{
	$max = $i*50;
	if($CONFIG['max_keywords'] == $max)
	{
		$smarty->append("max_keywords",array('title' => $max, 'value' => $max, 'selected' => 'selected="selected"'));
	}
	else
	{
		$smarty->append("max_keywords",array('title' => $max, 'value' => $max, 'selected' => ''));
	}
}

?>
