<?php

$plugins_root = SCRIPT_ROOT_PATH.'/plugins/';

$plugins = new plugins($plugins_root);
$plugins->getPlugins(true);
$plugins_list = $plugins->getPluginsList();

$p = isset($_REQUEST['p']) ? $_REQUEST['p'] : "";

// Loading specific plugin page
if ((!empty($p) && !empty($plugins_list[$p]) && $plugins_list[$p]['active']))
{
	include_once(SCRIPT_ROOT_PATH.'/class/libs/lib.buffer.php');
	
	// Load plugin language and content
	if (file_exists(SCRIPT_ROOT_PATH.'/plugins/'.$p.'/language/'.$CONFIG['language'].'/lang.php'))
	{
		require_once(SCRIPT_ROOT_PATH.'/plugins/'.$p.'/language/'.$CONFIG['language'].'/lang.php');
	}
	
	if(!defined("PLUGIN_ROOT_PATH"))
	{
		define("PLUGIN_ROOT_PATH",SCRIPT_ROOT_PATH.'/plugins/'.$p);
	}
	
	Buffer::init();
	include_once (SCRIPT_ROOT_PATH.'/plugins/'.$p.'/index.php');
	$smarty->assign("content",Buffer::getContent());
	Buffer::clean();
	
	$template = "admin_plugin_content.html";
}
else
{
	// Loading plugin list
	if (count($plugins_list) == 0)
	{
		$smarty->append("message",$lang['noplugin']);
	}
	else
	{
		// Sorting plugins by name
		uasort($plugins_list,create_function('$a,$b','return strcmp($a["label"],$b["label"]);'));
		
		// PLugins list
		foreach ($plugins_list as $k => $v)
		{
			if (file_exists(SCRIPT_ROOT_PATH.'/plugins/'.$k.'/language/'.$CONFIG['language'].'/lang.php'))
			{
				require_once(SCRIPT_ROOT_PATH.'/plugins/'.$k.'/language/'.$CONFIG['language'].'/lang.php');
			}
			
			$plink = '<a href="index.php?cat=plugins&amp;p='.$k.'">%s</a>';
			$plabel = (!empty($v['label'])) ? $lang[$v['label']] : $v['name'];
			$plug_link = sprintf($plink,$plabel);
			
			$plugin_image = '';
			if (file_exists($plugins_root.$k.'/icon.png'))
			{
				$plugin_image = '<img alt="" src="'.$CONFIG['site_url'].'/plugins/'.$k.'/icon.png" />';
			}
			$smarty->append("plugins",array('admin' => "index.php?cat=plugins&amp;p=".$k, 'name' => $plabel, 'image' => $plugin_image, 'description' => $lang[$v['desc']]));
		}
	}
	$template = "admin_plugins.html";
}

?>
