<?php

include_once dirname(__FILE__)."/functions/validate.php";

if(isset($_POST['do']))
{
	$do = $_POST['do'];
	$sites = isset($_POST['sites']) ? $_POST['sites'] : array();
	
	if(count($sites) > 0)
	{
		$lm =& get_manager('link');
		$vm =& get_manager('validation');
		
		foreach($sites as $id => $action)
		{
			$criteria = new Criteria('id',$id,'=');
			$criteria->setLimit(1);
			
			switch($do)
			{
				case 'accept':
					$to_update = array('state' => 4);
					$lm->update($criteria,$to_update);
					updateLinkState($id,4);
					deleteValidation($id);
					break;
				
				case 'refuse':
					updateLinkState($id,2);
					deleteValidation($id);
					break;
					
				case 'delete':
					deleteLink($id);
					deleteValidation($id);
					break;
			}
		}
		
		$smarty->append('warning',$lang['operation_ok']);
	}
}

// Deleting pending websites
if (isset($_POST["delete_attente"]))
{
	$lm =& get_manager("link");
	$vm =& get_manager("validation");
	
	$criteria = new Criteria('state',0,'=');
	$criteria->setSort('id');
	$criteria->setOrder('ASC');
	$cols = array('id');
	$links =& $lm->getObjects($criteria,$cols);
	unset($criteria);
	
	if(count($links) > 0)
	{
		foreach($links as $link)
		{
			$criteria = new Criteria('id',$link->getVar('id'),'=');
			$criteria->setLimit(1);
			$lm->deleteAll($criteria);
			unset($criteria);
			
			$criteria = new Criteria('id_site',$link->getVar('id'),'=');
			$criteria->setLimit(1);
			$vm->deleteAll($criteria);
			unset($criteria);
		}
	}
}

// Premium pending websites
display_links(1, $lang['accept'],true);

// Basic pending websites
display_links(1, $lang['accept'],false);

// Dead Links
display_links(3);

// Banned links
display_links(2);

// Links that haven't been confirmed
display_links(0);

// Links reported by users
displayBrokenLinks();
?>