<?php
include_once ('init.php');

$login = isset($_COOKIE['login']) ? $_COOKIE['login'] : '';
$pass = isset($_COOKIE['pass']) ? $_COOKIE['pass'] : '';

$auth =& AuthFactory::getAuthConnection();
$authentified = $auth->authentificate($login,$pass,1);

if(!$authentified)
{
	// trying then to authentify by form information
	$login = isset($_POST['login']) ? $_POST['login'] : '';
	$pass = isset($_POST['pass']) ? md5($_POST['pass']) : '';
	$authentified = $auth->authentificate($login,$pass,1);
}

if ($authentified)
{
	$smarty->assign("onload",'onload="Fat.fade_all(); dragndrop();"');

	if(file_exists(SCRIPT_ROOT_PATH."/install"))
	{
		$smarty->append("warning",$lang['install_warn']);
	}
	if(!is_writable(SCRIPT_ROOT_PATH."/conf/config.php"))
	{
		$smarty->append("warning",$lang['config_warn']);
	}

	include (dirname(__FILE__).'/include/actions.php');

	$cat = isset($_GET['cat']) ? $_GET['cat'] : "";

	switch ($cat)
	{
		case 'directory':
			include(dirname(__FILE__).'/include/directory.php');
			break;
		case 'link':
			include(dirname(__FILE__).'/include/link.php');
			$template = 'admin_link.html';
			break;
		case 'verification':
			include(dirname(__FILE__).'/include/verification.php');
			$template = 'admin_verification.html';
			break;
		case 'informations':
			include(dirname(__FILE__).'/include/informations.php');
			$template = 'admin_informations.html';
			break;
		case 'keyword':
			include(dirname(__FILE__).'/include/keyword.php');
			$template = 'admin_keyword.html';
			break;

		case 'validate':
			include(dirname(__FILE__).'/include/validate.php');
			$template = 'admin_validate.html';
			break;

		case 'plugins':
			include(dirname(__FILE__).'/include/plugins.php');
			break;

		case 'logout':
			setcookie("login","",time(),'/');
			setcookie("pass","",time(),'/');
			$template = 'admin_connexion.html';
			// Do not display warnings on logout
			$smarty->clear_assign('warning');
			break;

		// Admin control panel
		default:
			$template = 'admin_panel.html';
			break;
	}

	// Template cache reload
	if($CONFIG['use_smartycache'])
	{
		$smarty->clear_cache($template);
	}
}
else
{
	if(!empty($login) && !empty($pass))
	{
		$smarty->append('warning',$lang['authent_ko']);
	}

	include (dirname(__FILE__).'/include/login.php');
}

include (SCRIPT_ROOT_PATH.'/disconnect.php');

$smarty->display($template);
?>