<?php

/*
*	Displays ATOM Feed of the directory
*/

include (dirname(__FILE__).'/init.php');
include (dirname(__FILE__).'/class/class.atom.php');

$lm =& get_manager("Link");

$criteria = new Criteria("state",4,'=');
$criteria->setOrder('DESC');
$criteria->setSort('id');
$criteria->setLimit(10);

$cols = array('name','url','description');
$sites = $lm->getObjects($criteria,$cols);

$O = new AtomCreator();
$O->AddTitle(utf8_encode($CONFIG['site_name']).' > Atom');
$O->AddLink('CSP', $CONFIG['site_url'], 'alternate', 'text/html');
$O->AddId($CONFIG['site_url'].'/atom.php');
$O->AddTagline('text/plain', 'escaped',utf8_encode($CONFIG['site_name']));
$O->AddCopyright('FreeGlobes');

if (count($sites) != 0)
{
	$re =& MyRewriteEngine::getInstance();

	foreach($sites as $site)
	{
		$nb = $O->NewEntry(htmlspecialchars(utf8_encode($site->getVar('name'))));
		$O->AddEntryLink($nb, utf8_encode($site->getVar('name')), 'alternate', $site->getVar('url'), 'text/html');
		$O->AddEntryContent($nb, '<![CDATA['.utf8_encode($site->getVar('description')).']]>', 'text/html', 'escaped');
		$O->AddEntryCreated($nb, date("Y-m-d"));
		$O->AddEntryId($nb, $re->buildUrl('single',array('id' => $site->getVar('id'), 'name' => $site->getVar('name'))));
	}
}

if($feed = $O->GenerateFeed())
{
    header('content-type: text/xml');
    echo $feed;
}
else
{
    echo $O->ErrorLog;
}

include(dirname(__FILE__).'/disconnect.php');
?>