<?php

if(!defined('SCRIPT_ROOT_PATH'))
{
	echo 'SCRIPT_ROOT_PATH not defined in AuthFactory class';
	exit();
}

/*
*	Authentification Factory
*	@class		AuthFactory
*	@package		Kernel
*	@subpackage	Authentification
*	@author		Jerome Loisel
*/
class AuthFactory
{
	/*
	*	Returns a unique instance of authentification manager
	*	@function	getConnection
	*	@return	reference on Object {@link Auth}
	*/
	function &getAuthConnection()
	{
		static $auth_instance;
		$config_manager =& MyConfigManager::getInstance();
		$CONFIG =& $config_manager->getconfig();
		$auth_method = '';
		
		if(!isset($auth_instance))
		{
			require_once SCRIPT_ROOT_PATH.'/class/auth/class.auth.php';
			
			if(isset($CONFIG))
			{
				if(isset($CONFIG['auth_method']))
				{
					$auth_method = $CONFIG['auth_method'];
				}
				else
				{
					$auth_method = 'my';
				}
			}
			else
			{
				$auth_method = 'my';
			}
			
			$file = SCRIPT_ROOT_PATH.'/class/auth/class.'.$auth_method.'auth.php';
			
			if(!is_readable($file))
			{
				$auth_method = 'my';
			}
			else
			{
				require_once $file;
			}
			$class = ucfirst($auth_method).'Auth';
			$auth_instance = new $class();
		}
		
		return $auth_instance;
	}
}

?>