<?php 
error_reporting(E_ALL);

class AtomBase {
	
	var $ClassVersion = 0.1;
	var $AtomVersion = 0.3;
	var $ErrorLog = '';
	
	
	function __call($name, $args) {
		$this->ErrorLog = $name . ' Method does not exists !';
	}
	
	function VerifyUri($uri) {
		$uri = trim($uri);
		if(preg_match('`^http://.*?$`', $uri)) {
			return $uri;
		} else {
			return '';
		}
	}
	
	function VerifyW3cDateFormat($date) {
		$date = trim($date);
		if(preg_match('`^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}\+\d{2}:\d{2}$`', $date)) {
			return $date;
		} else {
			return '';
		}
	}
	
}

class AtomCreator extends AtomBase {
	
	var $Encoding = 'iso-8859-1';	
	var $Feed = array();
	var $XmlLang = 'fr';
	
	var $I = 0;
	
	function AtomCreator()
	{
	
	}
	
	function CreateFeed($lang='en') {
		$this->Feed['lang'] = $lang;
		$this->Feed['version'] = $this->AtomVersion;
		
	}
	
	function AddTitle($title) {
		$this->Feed['title'] = $title;
	}
	
	function AddLink($title, $url , $rel, $type) {
		
		if($rel == 'alternate') {
			$this->Feed['alternatelink']['title'] = $title;
			$this->Feed['alternatelink']['url'] = $url;
			$this->Feed['alternatelink']['type'] = $type;
		} else {
			
		}
	}
	
	function AddAuthor($name, $url='', $email='') {
		$this->Feed['author']['name'] = $name;
		$this->Feed['author']['url'] = $this->VerifyUri($url);
		$this->Feed['author']['email'] = $email;
		
		$this->Feed['author'] = $this->AddPersonElement($name,$url,$email);
		
	}
	
	function AddContributor($name, $url='',$email='') {
		$this->Feed['contributor'][] = $this->AddPersonElement($name,$url,$email);
	}
	
	function AddTagline($type, $mode, $description='') {
		$this->Feed['tagline']['type'] = $type;
		$this->Feed['tagline']['mode'] = $mode;
		$this->Feed['tagline']['description'] = $description;
	}
	
	function AddId($url) {
		$this->Feed['id'] = $this->VerifyUri($url);
		
	}
	
	function AddGenerator($generator , $url='', $version='') {
		$this->Feed['generator']['name'] = $generator;
		$this->Feed['generator']['url'] = $url;
		$this->Feed['generator']['version'] = $version;
	}
	
	function AddCopyright($copy) {
		$this->Feed['copyright'] = $copy;
	}
	
	function AddInfo($info, $type, $mode) {
		$this->Feed['info']['type'] = $type;
		$this->Feed['info']['mode'] = $mode;
		$this->Feed['info']['info'] = $info;
	}
	
	function AddModified() {
		$this->Feed['modified'] = date('Y-m-d\TH:i:s+00:00');
	}

	function NewEntry($title) {
		$this->I++;
		$this->Feed['entry'][$this->I]['title'] = $title;
		return $this->I;
	}
	
	function AddEntryLink($i, $title, $rel, $url, $type) {
		$this->Feed['entry'][$i]['alternatelink']['title'] = $title;
		$this->Feed['entry'][$i]['alternatelink']['rel'] = $rel;
		$this->Feed['entry'][$i]['alternatelink']['url'] = $url;
		$this->Feed['entry'][$i]['alternatelink']['type'] = $type;
		
	}
	
	
	function AddEntrySummary($i , $summary, $type, $mode) {
		$this->Feed['entry'][$i]['summary']['type'] = $type;
		$this->Feed['entry'][$i]['summary']['mode'] = $mode;
		$this->Feed['entry'][$i]['summary']['summary'] = $summary;
	}
	
	function AddEntryContent($i , $content, $type, $mode) {
		$this->Feed['entry'][$i]['content']['type'] = $type;
		$this->Feed['entry'][$i]['content']['mode'] = $mode;
		$this->Feed['entry'][$i]['content']['content'] = $content;
	}
	
	function AddEntryAuthor($i, $name, $url='', $email='') {
		$this->Feed['entry'][$i]['author']['name'] = $name;
		$this->Feed['entry'][$i]['author']['url'] = $this->VerifyUri($url);
		$this->Feed['entry'][$i]['author']['email'] = $email;
	}
	
	function AddEntryModified($i, $modified) {
		$this->Feed['entry'][$i]['modified'] = $modified;
	}
	
	function AddEntryIssued($i, $issued) {
		$this->Feed['entry'][$i]['issued'] = $issued;
	}
	
	function AddEntryCreated($i, $created) {
		$this->Feed['entry'][$i]['created'] = $created;
	}
	
	function AddEntryId($i, $url) {
		$this->Feed['entry'][$i]['id'] = $this->VerifyUri($url);
	}
	
	
	
	
	
	
	function GenerateFeed($intofile='') {
		
		if(!isset($this->Feed['lang'])) {
			$this->CreateFeed($this->XmlLang);
		}
		$r = '';
		/*$r .= '<?xml version="1.0" encoding="'.$this->Encoding.'">'; */
		$r .= '<feed  xmlns="http://purl.org/atom/ns#"  
		version="'.$this->Feed['version'].'" xml:lang="'.$this->Feed['lang'].'">';
		
		if(!isset($this->Feed['title'])) {
			$this->ErrorLog = 'Title element not indicated';
			return false;
		}
		$r .= '<title>'.$this->Feed['title'].'</title>';
		
		if(!isset($this->Feed['alternatelink'])) {
			$this->ErrorLog = 'Link element not indicated';
			return false;
		}
		$r .= '<link rel="alternate" 
		type="'.$this->Feed['alternatelink']['type'].'" href="'.$this->Feed['alternatelink']['url'].'" 
		title="'.$this->Feed['alternatelink']['title'].'"/>';
		
		// author
		if(isset($this->Feed['author'])) {
			$r .= '<author>';
			$r .= '<name>'.$this->Feed['author']['name'].'</name>';
			if(isset($this->Feed['author']['url'])) {
				$r .= '<url>'.$this->Feed['author']['url'].'</url>';
			}
			if(isset($this->Feed['author']['email'])) {
				$r .= '<email>'.$this->Feed['author']['email'].'</email>';
			}
			$r .= '</author>';
			
		}
		
		// tagline
		if(isset($this->Feed['tagline'])) {
			$r .= '<tagline type="'.$this->Feed['tagline']['type'].'" mode="'.$this->Feed['tagline']['mode'].'"';
			if(isset($this->Feed['tagline']['description'])) {
				$r .= '>'.$this->Feed['tagline']['description'].'</tagline>';
			} else {
				$r .= '/>';
			}
		}
		
		// contributor
		if(isset($this->Feed['contributor'])) {
			
			foreach($this->Feed['contributor'] as $val) {
				$r .= '<contributor>';
				$r .= '<name>'.$val['name'].'</name>';
				if(isset($val['url'])) {
					$r .= '<url>'.$val['url'].'</url>';
				}
				if(isset($val['email'])) {
					$r .= '<email>'.$val['email'].'</email>';
				}
				$r .= '</contributor>';
			}
			
		}
		
		// id
		if(isset($this->Feed['id']) && $this->Feed['id'] != '') {
			$r .= '<id>'.$this->Feed['id'].'</id>';
		}
		
		$this->AddGenerator('AtomCreator', 'http://classes.scriptsphp.net/doc.Atom', $this->ClassVersion);
		$r .= '<generator url="'.$this->Feed['generator']['url'].'" version="'.$this->Feed['generator']['version'].'">
		'.$this->Feed['generator']['name'].'</generator>';
		
		// info
		if(isset($this->Feed['info'])) {
			$r .= '<info type="'.$this->Feed['info']['type'].'" mode="'.$this->Feed['info']['mode'].'">
			'.$this->Feed['info']['info'].'</info>';
		}
		
		// copyright
		if(isset($this->Feed['copyright'])) {
			$r .= '<copyright>'.$this->Feed['copyright'].'</copyright>';		
		}
		
		// modified
		$this->AddModified();
		$r .= '<modified>'.$this->Feed['modified'].'</modified>';
		
		
		// entry
		if(isset($this->Feed['entry'])) {
			foreach($this->Feed['entry'] as $val) {
				if(!isset($val['alternatelink'])) {
					continue;
				}
				$r .= '<entry>';
				$r .= '<title>'.$val['title'].'</title>';
				$r .= '<link rel="alternate" 
				type="'.$val['alternatelink']['type'].'" href="'.$val['alternatelink']['url'].'" 
				title="'.$val['alternatelink']['title'].'"/>';
				if(isset($val['author'])) {
					$r .= '<author>';
					$r .= '<name>'.$val['author']['name'].'</name>';
					if($val['author']['url'] != '') {
						$r .= '<url>'.$val['author']['url'].'</url>';
					}
					if($val['author']['email'] != '') {
						$r .= '<email>'.$val['author']['email'].'</email>';
					}
					$r .= '</author>';
				}
				if(isset($val['modified'])) {
					$r .= '<modified>'.$val['modified'].'</modified>';
				}
				if(isset($val['issued'])) {
					$r .= '<issued>'.$val['issued'].'</issued>';
				}
				if(isset($val['created'])) {
					$r .= '<created>'.$val['created'].'</created>';
				}
				if(isset($val['id'])) {
					$r .= '<id>'.$val['id'].'</id>';
				}
				
				if(isset($val['summary'])) {
					$r .= '<summary type="'.$val['summary']['type'].'" mode="'.$val['summary']['mode'].'">
					'.$val['summary']['summary'].'</summary>';
				}
				if(isset($val['content'])) {
					$r .= '<content type="'.$val['content']['type'].'" mode="'.$val['content']['mode'].'">
					'.$val['content']['content'].'</content>';
				}
				$r .= '</entry>';
			}
		}
		
		$r .= '</feed>';
		
		if($intofile) {
			if(!@file_put_contents($intofile, $r)) {
				$this->ErrorLog = 'Unable to write into file';
				return false;
			}
		}
		
		
		return $r;
	}
	
	function AddPersonElement($name, $url='', $email='') {
		return array('name'=>$name, 'url'=>$url, 'email'=>$email);
	}
	
	function AddContentElement() {
		
	}
	
}// end class

class AtomReader extends AtomBase {
	
}


?>