<?php

/*
*	Benchmark utility
*	@class	Bench
*	@package	Kernel
*	@author	fablezouave	<webmaster@scriptsphp.net>
*/
class Bench {

    var $start;
    var $decimals;
    var $Result;

    /*
     Constructeur de la classe
     (initialisation des variables)
     */

    function Bench() {

        $this->start = 0;
        // Nombre de chiffres aprs la virgule
        // pour l' affichage des rsultats
        $this->decimals = 3;
        $this->Result = array();
        }

    /*
     Cette mthode marque le dbut du benchmark
     */

    function startBench() {
        $this->start = bench::getMicrotime();
        }

    /*
     Cette mthode marque la fin du benchmark
     */

    function endBench() {
        $end = bench::getMicrotime() - $this->start;
        $this->Result['End'] = $end;
        }


    /*
     Cette mthode sert  rcuprer
     des temps intermdiaires
     */

    function addFlag($txt) {
        $flag = bench::getMicrotime() - $this->start;
        $this->Result[$txt] = $flag;
        }

    /*
     Cette mthode retourne un temps exploitable.
     */

    function getMicrotime(){
        $T = explode(' ', microtime());
        $time = $T[1].substr($T[0], 1);
        return (float)$time;
        }

    /*
     Cette mthode retourne le nombre $value
     format avec n chiffres aprs la virgule
     */

    function format($value, $n=0) {
        $dec = $n==0 ? $this->decimals : $n;
        return number_format((float)$value, $dec);
        }

    /*
     Cette mthode retourne le rsultat des benchs
     sous la forme d' un tableau HTML.
     */

    function returnResult() {
        $prec  = 0;
        $inter = 0;

        $ret  = '<table bordercolor="black" border="1">';
        $ret .= '<tr bgcolor="#cccccc">';
        $ret .= '<td>Evnement</td>';
        $ret .= '<td>Temps depuis le dbut</td>';
        $ret .= '<td>Temps depuis le dernier flag</td>';
        $ret .= '<td> - Pourcentage - </td>';
        $ret .= '</tr>';

        foreach($this->Result as $key => $val) {
            $inter = $val - $prec;
            $prec = $val;
            $percent = ($inter/$this->Result['End'])*100;

            $ret .= '<tr>';
            $ret .= '<td>'.$key.'</td>';
            $ret .= '<td>'.bench::format($val).' s</td>';
            $ret .= '<td>'.bench::format($inter).' s</td>';
            $ret .= '<td>'.bench::format($percent, 2).' % </td>';
            $ret .= '</tr>';
            }

        $ret .= '</table>';

        return $ret;
        }

    /*
     Cette mthode retourne un simple rsultat
     correspondant au temps pass entre
     start_bench() et end_bench()
     */

    function returnSimpleResult() {
        $r = bench::format($this->Result['End']) ;
        $ret = " $r sec";
        return $ret;
        }


    } // end class

?>
