<?php

if(!defined("SCRIPT_ROOT_PATH"))
{
	echo 'SCRIPT_ROOT_PATH not defined in class.config.php';
	exit();
}

/*
*	Configuration file manager
*	@class ConfigManager
*	@package Kernel
*/
class ConfigManager
{
	// Config file by absolut path
	var $file = "";
	// config values loaded into class member
	var $config = array();
	// Has anyone of the config values been modified ?
	var $is_dirty = false;
	// has the config file been loaded successfully
	var $loaded = false;
	
	/*
	*	Constructor with 1 parameter
	*	@param string file : config file indicated by absolut path
	*/
	function ConfigManager($file = "")
	{
		if (!empty($file) && file_exists($file))
		{
			$this->file = $file;
		}
		$this->loadConfig();
	}
	
	/*
	*	Loads the config file after it has been specified
	*	@param void
	*	@return bool : TRUE if success
	*/
	function loadConfig()
	{
		if(!$this->loaded)
		{
			include_once($this->file);
			if(isset($CONFIG))
			{
				$this->config =& $CONFIG;
				$this->loaded = true;
				return true;
			}
			else
			{
				include_once(SCRIPT_ROOT_PATH.'/conf/default.php');
				$this->config =& $default;
				return false;
			}
		}
		else if($this->loaded)
		{
			return true;
		}
		else
		{
			include_once(SCRIPT_ROOT_PATH.'/conf/default.php');
			$this->config =& $default;
			return false;
		}
	}
	
	/*
	*	Method allowing to modify a specific config value, if it exists
	*	@param string key
	*	@param string value
	*	@return bool : TRUE if success
	*/
	function setVar($key, $value)
	{
		if(!empty($key) && isset($this->config[$key]))
		{
			if(!$this->isDirty())
			{
				$this->setDirty();
			}
			$this->config[$key] = $value;
			return true;
		}
		return false;
	}
	
	/*
	*	Method allowing to modify a couple of config values
	*	@param array : key is name of the config item, value is the new value
	*	@return bool : TRUE if success
	*/
	function setVars($array)
	{
		if(isset($array) && count($array) > 0)
		{
			foreach($array as $key => $value)
			{
				$this->setVar($key,$value);
			}
			return true;
		}
		return false;
	}

	/*
	*	Method allowing to modify a couple of config values
	*	@param array : key is name of the config item, value is the new value
	*	@return bool : the requested value, else FALSE
	*/
	function getVar($key)
	{
		if(isset($this->config[$key]))
		{
			return $this->config[$key];
		}
		return false;
	}
	
	/*
	*	Returns the config array
	*	@param void
	*	@return &array : associative array defined in config file
	*/
	function &getConfig()
	{
		return $this->config;
	}
	
	/*
	*	Sets the config file as dirty
	*	@param void
	*	@return void
	*/
	function setDirty()
	{
		$this->is_dirty = true;
	}
	
	/*
	*	Checks if the config file is dirty
	*	@param void
	*	@return bool : true if dirty
	*/
	function isDirty()
	{
		return $this->is_dirty;
	}
	
	/*
	*	Returns the config file absolut path
	*	@param void
	*	@return string file
	*/
	function getFile()
	{
		return $this->file;
	}

	/*
	*	Updates the config file if it's dirty and writeable
	*	@param void
	*	@return bool : true if success
	*/
	function updateConfig()
	{
		if($this->isDirty())
		{
			$file_string = "<"."?php\n\n";

			foreach ($this->config as $cle => $valeur)
			{
				$file_string .= '$CONFIG['."'".$cle."'".']'."\t=\t\"".$valeur."\";\n";
			}
			
			$file_string .= "\n".'?'.'>';
			
			$fh = fopen( $this->file,'w');
			
			if ($fh)
			{
				fputs($fh, $file_string, strlen($file_string) );
				fclose($fh);
				return true;
			}
			else
			{
				return false;
			}
		}
		else
		{
			return true;
		}
	}
}

/*
*	Singleton class used to instanciate a config Manager
*	@class MyConfigManager
*	@package Kernel
*/
class MyConfigManager
{
	/*
	*	reference on a static instance
	*	@function getInstance
	*	@return void
	*/
	function &getInstance()
	{
		static $config_manager;
		if(!isset($config_manager))
		{
			$config_manager = new ConfigManager(SCRIPT_ROOT_PATH.'/conf/config.php');
		}
		return $config_manager;
	}
}

?>