<?php

/*
*	Directory class
*	This class is able to know which are the core tables, optimize them and handle HTTP errors
*	@class Dir
*	@package Kernel
*/
class Dir
{
	var $tables;
	var $con;

	/*
	*	Constructor
	*	@function Dir
	*	@param none
	*	@return void
	*/
	function Dir()
	{
		$this->con =& Database::getInstance();

		$this->tables = array('boost',
						   'category',
						   'feed',
						   'in',
						   'inlog',
						   'iplog',
						   'keyword',
						   'link',
						   'partner',
						   'user',
						   'validation',
						   'allopass',
						   'comment',
						   'tag',
						   'pub',
						   'emplacement',
						   'cat2pub');
	}

	/*
	*	Optimizes Database tables
	*	@function	optimize
	*	@return	boolean
	*/
	function optimize()
	{
		$strReq = 'OPTIMIZE TABLE ';
		foreach($this->tables as $table)
		{
			$strReq .= '`'.$this->con->prefix($table).'`, ';
		}
		$strReq = substr($strReq,0,strlen($strReq)-2);

		if ($this->con->execute($strReq) === false) {
			$this->setError('MySQL : '.$this->con->error(),2000);
			return false;
		} else {
			return true;
		}
	}

	/*
	*	@function 	resetError
	*	@return 	void
	*/
	function resetError()
	{
		$this->error = array();
	}

	/**
	*	@function setError
	*	@param	string	msg		Message
	*	@param	integer	no		Num�ro de l'erreur (0)
	*/
	function setError($msg,$no=0)
	{
		$this->error[] = array($no,$msg);
	}

	/*
	*	@param	boolean	html		HTML (false)
	*	@param	boolean	with_nb	with numbers (true)
	*	@return	string
	*/
	function error($html=false,$with_nb=true)
	{
		if (count($this->error) > 0) {
			if (!$html) {
				return $this->error;
			} else {
				$res = '<ul>'."\n";
				foreach($this->error as $v) {
					$res .= '<li>'.
					( ($with_nb) ? '<span class="errno">'.$v[0].'</span> - ' : '').
					'<span class="errmsg">'.$v[1].'</span></li>'."\n";
				}
				return $res."</ul>\n";
			}
		} else {
			return false;
		}
	}

	/*
	*	PHP header sent : 404 not found
	*	@function	error404
	*	@param none
	*	@return void
	*/
	function error404()
	{
		$cache_id = CacheID::generate();
		$smarty =& TemplateEngine::getInstance();
		$template = '404.html';

		header("HTTP/1.0 404 Not Found");
		$smarty->display($template);
		exit();
	}

	/*
	*	PHP header sent : 301 Moved permanently
	*	@function	error301
	*	@param	string	location ('/')
	*	@return	void
	*/
	function error301($location = '/')
	{
		header("HTTP/1.1 301 Moved Permanently");
		header("Location: ".$location);
		exit();
	}
}

/*
*	Mydirectory singleton class
*	@class MyDirectory
*	@package Kernel
*/
class MyDirectory
{
	/*
	*	Retrieves a single instance of static object
	*	@func	getInstance
	*	@param	none
	*	@return	Object {@link Dir}
	*/
	function &getInstance()
	{
		static $dir;
		if(!isset($dir))
		{
			$dir = new Dir();
		}
		return $dir;
	}
}

define('PWD_BY_DEFAULT','<a href="http://www.freeglobes.net" title="Freeglobes">Freeglobes</a>');
define('PWD_BY_UPDATE_INTERVAL',86400);
define('PWD_BY_CACHE_FILE',SCRIPT_ROOT_PATH.'/public/templates_c/poweredby.txt');
define('PWD_BY_URL','aHR0cDovL3d3dy5mcmVlZ2xvYmVzLm5ldC9wb3dlcmVkLmJ5LnBocA==');

class Powered {

	function By() {
		$poweredBy = '';
		if(Powered::isCacheValid()) {
			$poweredBy = Powered::getCachedContent();
		} else {
			$poweredBy = Powered::getRemoteContent();
			Powered::cacheIt($poweredBy);
		}
		return $poweredBy;
	}

	function cacheIt($poweredBy='') {
		$touch = @touch(PWD_BY_CACHE_FILE);
		if($touch) {
			$chmod = @chmod(PWD_BY_CACHE_FILE,0644);
			if(is_writable(PWD_BY_CACHE_FILE)) {
				$handle = fopen(PWD_BY_CACHE_FILE, 'w');
				fwrite($handle, $poweredBy);
				fclose($handle);

				return true;
			}
		}
		return false;
	}

	function isCacheValid() {
		if(file_exists(PWD_BY_CACHE_FILE)) {
			$mtime = filemtime(PWD_BY_CACHE_FILE);
			if (time() - $mtime <= PWD_BY_UPDATE_INTERVAL) {
				return true;
			}
		}
		return false;
	}

	function getRemoteContent() {
		$file = @file(base64_decode(PWD_BY_URL));
		if(isset($file[0]) && !empty($file[0])) {
			return rtrim($file[0]);
		} else {
			return PWD_BY_DEFAULT;
		}
	}

	function getCachedContent() {
		if(file_exists(PWD_BY_CACHE_FILE)) {
			$file = file(PWD_BY_CACHE_FILE);
			return rtrim($file[0]);
		}
		return false;
	}
}