<?php
/*
*	inifile manager : read, modify and write config file
*	@class	inifile
*	@package	Kernel
*	@author	Olivier Meunier
*/
class iniFile
{
	var $content;
	var $var_reg = '/^[\s]*(%s)[\s]*?=[\s*](.*)$/m';
	
	/*
	*	Constructor
	*	@function	iniFile
	*	@param	string file	ini File to load
	*	@return	void
	*/
	function iniFile($file)
	{
		if (file_exists($file)) {
			$this->file = $file;
			$this->content = implode('',file($file));
		} else {
			$this->file = false;
		}
	}
	
	/*
	*	Edits a var
	*	@function	editVar
	*	@param	string name		name of the var to edit
	*	@param	string value		new value of the edited var
	*	@return	void
	*/
	function editVar($name,$value)
	{
		if ($this->file !== false)
		{
			$match = sprintf($this->var_reg,preg_quote($name));
			
			if (preg_match($match,$this->content))
			{
				$replace = '$1 = '.$value;
				$this->content = preg_replace($match,$replace,$this->content);
			}
			else
			{
				$this->createVar($name,$value);
			}
		}
	}
	
	/*
	*	Creates a new Var
	*	@function	createVar
	*	@param	string name	Name of the new var
	*	@param	string value	Value of this var
	*	@param	string comment	Any comment ?
	*/
	function createVar($name,$value,$comment='')
	{
		$match = sprintf($this->var_reg,preg_quote($name));
		
		if ($comment != '') {
			$comment = '; '.str_replace("\n","\n; ",$comment)."\n";
		}
		
		if (!preg_match($match,$this->content))	{
			$this->content .= "\n\n".$comment.$name.' = '.$value;
		}
	}
	
	/* sauvegarde du fichier */
	function saveFile()
	{
		if (($fp = @fopen($this->file,'w')) !== false) {
			if (@fwrite($fp,$this->content,strlen($this->content)) !== false) {
				$res = true;
			} else {
				$res = false;
			}
			fclose($fp);
			return $res;
		} else {
			return false;
		}
	}
	
	/*
	Static method that puts ini vars in constants or returns array
	*/
	function read($file,$return=false)
	{
		if (!file_exists($file)) {
			trigger_error('No config file',E_USER_ERROR);
			exit;
		}
		
		$f = file($file);
		
		if ($return) {
			$res = array();
		}
		
		foreach ($f as $v)
		{
			$v = trim ($v);
			if (substr($v,0,1) != ';' && $v != '') {
				$p = strpos($v,'=');
				$K = (string) trim(substr($v,0,$p));
				$V = (string) trim(substr($v,($p+1)));
				
				if (substr($V,0,1) == '"' && substr($V,-1) == '"') {
					$V = substr(substr($V,1),0,-1);
				}
				
				if ($V === 'yes' || $V === 'true' || $V === '1') {
					$V = true;
				}
				
				if ($V === 'no' || $V === 'false' || $V === '0') {
					$V = false;
				}
				
				if ($return) {
					$res[$K] = $V;
				} elseif (!defined($K)) {
					define($K,$V);
				}
			}
		}
		
		if ($return) {
			return $res;
		}
	}
}


?>