<?php

/**
*	Language Manager. This Manager selects and loads a specified language.
*	@class	LanguageManager
*	@package	Kernel
*	@author	Jerome Loisel
**/
class LanguageManager
{
	// Langue
	var $lang;
	// Absolut path
	var $path;
	// fichier langue  charger
	var $file;
	
	// constructeur
	function LanguageManager($path, $language, $file)
	{
		$this->setLang($language);
		if(!empty($path))
		{
			$this->setPath($path);
		}
		$this->setFile($file);
	}
	
	// Setter
	function setLang($language)
	{
		$this->lang = $language;
	}
	
	function setPath($path)
	{
		$this->path = $path;
	}
	
	function setFile($file)
	{
		$this->file = $file;
	}
	
	// Getter
	function &getLang()
	{
		return $this->lang;
	}
	
	function getPath()
	{
		return $this->path;
	}
	
	function getFile()
	{
		return $this->file;
	}
	
	// Chargeur de langue
	function loadLang()
	{
		global $CONFIG, $lang;
		$smarty =& TemplateEngine::getInstance();
		
		include($this->path.'/'.$this->lang.'/'.$this->file);
		
		if(isset($lang))
		{
			$this->lang =& $lang;
			$smarty->assign("lang",$lang);
			return true;
		}
		else
		{
			return false;
		}
	}
}