<?php

class MailManager
{
	var $smarty;
	var $template = array('subject' => '','body' => '');
	var $from = '';
	var $to = '';
	var $subject = '';
	var $body = '';

	function MailManager()
	{
		global $CONFIG;
		$this->smarty = new Smarty;

		$this->smarty->compile_dir = SCRIPT_ROOT_PATH."/public/templates_c";
		$this->smarty->cache_dir = SCRIPT_ROOT_PATH."/public/cache";
		$this->smarty->left_delimiter = '<{';
		$this->smarty->right_delimiter = '}>';

		$template_dir = SCRIPT_ROOT_PATH."/language/".$CONFIG['language']."/mail";
		$this->smarty->template_dir = $template_dir;
		$this->smarty->assign("CONFIG",$CONFIG);
	}

	function setTemplate($key,$template)
	{
		$this->template[$key] = $template;
	}

	function setFrom($from)
	{
		$this->from = $from;
	}

	function setTo($to)
	{
		$this->to = $to;
	}

	function assignValue($name,$value)
	{
		$this->smarty->assign($name,$value);
	}

	function assignArray($array)
	{
		$this->smarty->assign($array);
	}

	function generateMail()
	{
		$subject_tpl = $this->template['subject'];
		$body_tpl = $this->template['body'];

		if(!empty($subject_tpl) && !empty($body_tpl))
		{
			$this->subject = $this->smarty->fetch($subject_tpl);
			$this->body = $this->smarty->fetch($body_tpl);
			return true;
		}
		return false;
	}

	function sendMail()
	{
		global $CONFIG;
		if($this->generateMail())
		{
			// Mail headers
			$headers  = 'MIME-Version: 1.0' . "\r\n";
			$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
			$headers .= "From: ".$CONFIG['site_mail']."\r\n";

			mail($this->to,$this->subject,$this->body,$headers);
			return true;
		}
		else
		{
			return false;
		}

	}
}

?>