<?php
/**
 * Class to facilitate navigation in a multi page document/list
 */
class PageNav
{
    /**#@+
    * @access	private
    */
    var $total;
    var $perpage;
    var $current;
    var $url;
    /**#@-*/

    /**
	 * Constructor
	 *
	 * @param   int     $total_items    Total number of items
	 * @param   int     $items_perpage  Number of items per page
	 * @param   int     $current_start  First item on the current page
	 * @param   string  $start_name     Name for "start" or "offset"
	 * @param   string  $extra_arg      Additional arguments to pass in the URL
	 **/
    function PageNav($total_items, $items_perpage, $current_start, $myurl = "")
    {
		global $CONFIG;
		$start_name = "start";
		$extra_arg = "";
		
        $this->total = intval($total_items);
        $this->perpage = intval($items_perpage);
        $this->current = intval($current_start);
        if ( $extra_arg != '' && ( substr($extra_arg, -5) != '&amp;' || substr($extra_arg, -1) != '&' ) ) {
            $extra_arg .= '&amp;';
        }
		
		$this->url = $myurl;
    }
	
	    /**
	 * Create text navigation
	 *
	 * @param   integer $offset
	 * @return  string
	 **/
    function renderNavNormal($offset = 4)
    {
        $ret = '';
        if ( $this->total <= $this->perpage ) {
            return $ret;
        }
        $total_pages = ceil($this->total / $this->perpage);
        if ( $total_pages > 1 ) {
            $prev = $this->current - $this->perpage;
            if ( $prev > 0 ) {
                $ret .= '<a href="'.$this->url.'&amp;start='.$prev.'">&laquo;</a> ';
            }
			else if($prev == 0)
			{
				$ret .= '<a href="'.$this->url.'">&laquo;</a> ';
			}
			
            $counter = 1;
            $current_page = intval(floor(($this->current + $this->perpage) / $this->perpage));
            while ( $counter <= $total_pages ) {
                if ( $counter == $current_page ) {
                    $ret .= '<b>('.$counter.')</b> ';
                } elseif ( ($counter > $current_page-$offset && $counter < $current_page + $offset ) || $counter == 1 || $counter == $total_pages ) {
                    if ( $counter == $total_pages && $current_page < $total_pages - $offset ) {
                        $ret .= '... ';
                    }
					if($counter == 1)
					{
						$ret .= '<a href="'.$this->url.'">'.$counter.'</a> ';
					}
					else
					{
						$ret .= '<a href="'.$this->url.'&amp;start='.(($counter - 1) * $this->perpage).'">'.$counter.'</a> ';
					}
                    if ( $counter == 1 && $current_page > 1 + $offset ) {
                        $ret .= '... ';
                    }
                }
                $counter++;
            }
            $next = $this->current + $this->perpage;
            if ( $this->total > $next ) {
                $ret .= '<a href="'.$this->url.'&amp;start='.$next.'">&raquo;</a> ';
            }
        }
        return $ret;
    }
	
	    /**
	 * Create text navigation
	 *
	 * @param   integer $offset
	 * @return  string
	 **/
    function renderNavRewrite($offset = 4)
    {
        $ret = '';
        if ( $this->total <= $this->perpage ) {
            return $ret;
        }
        $total_pages = ceil($this->total / $this->perpage);
        if ( $total_pages > 1 ) {
            $prev = $this->current - $this->perpage;
            if ( $prev > 0 ) {
                $ret .= '<a href="'.$this->url.'-'.$prev.'.html">&laquo;</a> ';
            }
			else if($prev == 0)
			{
				$ret .= '<a href="'.$this->url.'.html">&laquo;</a> ';
			}
			
            $counter = 1;
            $current_page = intval(floor(($this->current + $this->perpage) / $this->perpage));
            while ( $counter <= $total_pages ) {
                if ( $counter == $current_page ) {
                    $ret .= '<b>('.$counter.')</b> ';
                } elseif ( ($counter > $current_page-$offset && $counter < $current_page + $offset ) || $counter == 1 || $counter == $total_pages ) {
                    if ( $counter == $total_pages && $current_page < $total_pages - $offset ) {
                        $ret .= '... ';
                    }
					if($counter == 1)
					{
						$ret .= '<a href="'.$this->url.'.html">'.$counter.'</a> ';
					}
					else
					{
						$ret .= '<a href="'.$this->url.'-'.(($counter - 1) * $this->perpage).'.html">'.$counter.'</a> ';
					}
                    if ( $counter == 1 && $current_page > 1 + $offset ) {
                        $ret .= '... ';
                    }
                }
                $counter++;
            }
            $next = $this->current + $this->perpage;
            if ( $this->total > $next ) {
                $ret .= '<a href="'.$this->url.'-'.$next.'.html">&raquo;</a> ';
            }
        }
        return $ret;
    }
	
	function renderNav()
	{
		return $this->renderNavNormal();
	}

    /**
	 * Create a navigational dropdown list
	 *
	 * @param   boolean     $showbutton Show the "Go" button?
	 * @return  string
	 **/
    function renderSelect($showbutton = false)
    {
        if ( $this->total < $this->perpage ) {
            return;
        }
        $total_pages = ceil($this->total / $this->perpage);
        $ret = '';
        if ( $total_pages > 1 ) {
            $ret = '<form name="pagenavform">';
            $ret .= '<select name="pagenavselect" onchange="location=this.options[this.options.selectedIndex].value;">';
            $counter = 1;
            $current_page = intval(floor(($this->current + $this->perpage) / $this->perpage));
            while ( $counter <= $total_pages ) {
                if ( $counter == $current_page ) {
                    $ret .= '<option value="'.$this->url.(($counter - 1) * $this->perpage).'" selected="selected">'.$counter.'</option>';
                } else {
                    $ret .= '<option value="'.$this->url.(($counter - 1) * $this->perpage).'">'.$counter.'</option>';
                }
                $counter++;
            }
            $ret .= '</select>';
            if ($showbutton) {
                $ret .= '&nbsp;<input type="submit" value="'._GO.'" />';
            }
            $ret .= '</form>';
        }
        return $ret;
    }

    /**
	 * Create navigation with images
	 *
	 * @param   integer     $offset
	 * @return  string
	 **/
    function renderImageNav($offset = 4)
    {
        if ( $this->total < $this->perpage ) {
            return;
        }
        $total_pages = ceil($this->total / $this->perpage);
        $ret = '';
        if ( $total_pages > 1 ) {
            $prev = $this->current - $this->perpage;
            if ( $prev >= 0 ) {
                $ret .= '<div class="pagneutral" style="float: left;"><a href="'.$this->url.$prev.'">&lt;</a></div>';
            }
            $ret .= '<div style="float: left;"><img src="'.XOOPS_URL.'/images/blank.gif" width="6" alt="" /></div>';
            $counter = 1;
            $current_page = intval(floor(($this->current + $this->perpage) / $this->perpage));
            while ( $counter <= $total_pages ) {
                if ( $counter == $current_page ) {
                    $ret .= '<div style="float:left;" class="pagact"><b>'.$counter.'</b></div>';
                } elseif ( ($counter > $current_page-$offset && $counter < $current_page + $offset ) || $counter == 1 || $counter == $total_pages ) {
                    if ( $counter == $total_pages && $current_page < $total_pages - $offset ) {
                        $ret .= '<div style="float: left;" class="paginact">...</div>';
                    }
                    $ret .= '<div style="float: left;" class="paginact"><a href="'.$this->url.(($counter - 1) * $this->perpage).'">'.$counter.'</a></div>';
                    if ( $counter == 1 && $current_page > 1 + $offset ) {
                        $ret .= '<div style="float: left;" class="paginact">...</div>';
                    }
                }
                $counter++;
            }
            $ret .= '<div style="float: left;"><img src="'.XOOPS_URL.'/images/blank.gif" width="6" alt="" /></div>';
            $next = $this->current + $this->perpage;
            if ( $this->total > $next ) {
                $ret .= '<div style="float: left;" class="pagneutral"><a href="'.$this->url.$next.'">&gt;</a></div>';
            }
            else {
                $ret .= '<div style="float: left;">&nbsp;</div>';

            }
        }
        $ret .= '<br style="clear: both;" />';
        return $ret;
    }
}

?>