<?php

if(!defined("SCRIPT_ROOT_PATH"))
{
	echo "Cannot load Plugin class : SCRIPT_ROOT_PATH not defined";
	exit();
}
else
{
	require_once (SCRIPT_ROOT_PATH.'/class/libs/lib.files.php');
}

/*
*	Plugin and Theme manager
*	@class	plugins
*	@package	Kernel
*	@author	Olivier Meunier
*/
class plugins
{
	//	Location of the extended features
	var $location;
	//	Type of the extended features (Plugin or theme)
	var $type;
	//	Content of the desc.xml file; this file describes a theme or a plugin
	var $_xml;
	//	Extended features list
	var $p_list = array();
	
	/*
	*	Constructor
	*	@function	plugins
	*	@param	string	location
	*	@param	string	type
	*	@return	void
	*/
	function plugins($location,$type='plugin')
	{
		if (is_dir($location)) {
			$this->location = $location.'/';
		} else {
			$this->location = NULL;
		}
		
		$this->type = $type;
	}
	
	/*
	*	Retrieves plugin list by plugin directory name in plugin directory
	*	@function	getPlugins
	*	@param	boolean	active_only		TRUE if only actives plugins or themes
	*	@return	boolean	TRUE if success
	*/
	function getPlugins($active_only = true)
	{
		if (($list_files = $this->_readDir()) !== false)
		{
			$this->p_list = array();
			foreach ($list_files as $entry => $pfile)
			{
				if (($info = $this->_getPluginInfo($pfile)) !== false) { 
					if (($active_only && $info['active']) || !$active_only) {
						$this->p_list[$entry] = $info;
					}
				}
			}
			ksort($this->p_list);
			return true;
		}
		else
		{
			return false;
		}
	}
	
	/*
	*	Returns plugin list
	*	@function	getPluginList
	*	@return	array
	*/
	function getPluginsList()
	{
		return $this->p_list;
	}
	
	/*
	*	Loads plugin functions by including plugin $f file
	*	@function	getFunctions
	*	@param	string	file to load existing in plugin path
	*	@return	array		functions
	*/
	function getFunctions($f='functions.php')
	{
		$res = array();
		
		if (($list_files = $this->_readDir()) !== false)
		{
			foreach ($list_files as $entry => $pfile)
			{
				if (file_exists(dirname($pfile).'/'.$f)) {
					$res[] = dirname($pfile).'/'.$f;
				}
			}
		}
		return $res;
	}
	
	/*
	*	Enables/disables a plugin
	*	@function	switchStatus
	*	@param	string	p : plugin name
	*	@return	boolean	TRUE if success
	*/
	function switchStatus($p)
	{
		$xml_path = $this->location.$p.'/desc.xml';
		$p_info = $this->_getPluginInfo($xml_path);
		$xml = implode('',file($xml_path));
		
		$active = (integer) !$p_info['active'];
		
		$xml = preg_replace('|(<'.$this->type.'[^>]*?active=)"([^"]+)([^>]*>)|ms',
			'$1"'.$active.'$3',$xml);
		
		if (!files::putContent($xml_path,$xml)) {
			return false;
		}
		return true;
	}
	
	
	/*
	*	Plugin/Theme installation method
	*	@function	install
	*	@param	string	url : URL of the package file containing the plugin
	*	@return	boolean	TRUE if success
	*/
	function install($url)
	{
		$dest = $this->location.'/'.basename($url);
		if (($err = files::copyRemote($url,$dest)) !== true)
		{
			return $err;
		}
		else
		{
			if (($content = @implode('',@gzfile($dest))) === false) {
				return 'Cannot open file';
			} else {
				if (($list = unserialize($content)) === false)
				{
					return 'Plugin not valid';
				}
				else
				{
					if (is_dir($this->location.'/'.$list['name']))
					{
						unlink($dest);
						return 'This plugin still exists. Delete it before.';
					}
					
					foreach ($list['dirs'] as $d)
					{
						mkdir ($this->location.'/'.$d,fileperms($this->location));
						chmod($this->location.'/'.$d,fileperms($this->location));
					}
					
					foreach ($list['files'] as $f => $v)
					{
						$v = base64_decode($v);
						$fp = fopen($this->location.'/'.$f,'w');
						fwrite($fp,$v,strlen($v));
						fclose($fp);
						chmod($this->location.'/'.$f,fileperms($this->location) & ~0111);
					}
					
					unlink($dest);
				}
			}
		}
		return true;
	}
	
	/*
	*	Reads the content of a directory and looks for desc.xml files
	*	@function	_readDir
	*	@return	array		plugin list
	*/
	function _readDir()
	{
		if ($this->location === NULL) {
			return false;
		}
		
		$res = array();
		
		$d = dir($this->location);
		
		# Liste du rpertoire des plugins
		while (($entry = $d->read()) !== false)
		{
			if ($entry != '.' && $entry != '..' &&
			is_dir($this->location.$entry) && file_exists($this->location.$entry.'/desc.xml'))
			{
				$res[$entry] = $this->location.$entry.'/desc.xml';
			}
		}
		
		return $res;
	}
	
	/*
	*	Parses the desc.xml of a plugin or a theme
	*	@function _getPluginInfo
	*	@param	string	p : plugin name
	*	@return	array, boolean	Array if success, FALSE in other case
	*/
	function _getPluginInfo($p)
	{
		if (file_exists($p))
		{
			$this->_current_tag_cdata = '';
			$this->_p_info = array('name'=>NULL,'version'=>NULL,
						'active'=>NULL,'author'=>NULL,'label'=>NULL,
						'desc'=>NULL,'callbacks'=>array());
			
			$this->_xml = xml_parser_create('ISO-8859-1');
			xml_parser_set_option($this->_xml, XML_OPTION_CASE_FOLDING, false);
			xml_set_object($this->_xml, $this);
			xml_set_element_handler($this->_xml,'_openTag','_closeTag');
			xml_set_character_data_handler($this->_xml, '_cdata');
			
			xml_parse($this->_xml,implode('',file($p)));
			xml_parser_free($this->_xml);
			
			if (!empty($this->_p_info['name'])) {
				return $this->_p_info;
			} else {
				return false;
			}
		}
	}
	
	/*
	*	Opens a tag while parsing XML
	*	@function _openTag
	*	@param	string	p : name of the plugin
	*	@param	string	tag : name of the tag
	*	@param	string	attribute : name of the attribute
	*	@return	void
	*/
	function _openTag($p,$tag,$attr)
	{
		if ($tag == $this->type && !empty($attr['name']))
		{
			$this->_p_info['name'] = $attr['name'];
			$this->_p_info['version'] = (!empty($attr['version'])) ? $attr['version'] : NULL;
			$this->_p_info['active'] = (!empty($attr['active'])) ? (boolean) $attr['active'] : false;
		}
		
		if ($tag == 'callback') {
			$this->_p_info['callbacks'][] = array($attr['event'],$attr['function']);
		}
	}
	
	/*
	*	Closes a tag while parsing XML
	*	@function	_closeTag
	*	@param	string	p : name of the plugin
	*	@param	string	tag : name of the tag opened
	*/
	function _closeTag($p,$tag)
	{
		switch ($tag)
		{
			case 'author':
			case 'label':
			case 'desc':
				$this->_p_info[$tag] = $this->_current_tag_cdata;
				break;
		}
	}
	
	/*
	*	Data of the current tag is assigned to member data
	*	@function	_cdata
	*	@param	string	p : name of the plugin
	*	@param	string	cdata : content of the tag
	*	@return	void
	*/
	function _cdata($p,$cdata)
	{
		$this->_current_tag_cdata = $cdata;
	}
}

?>