<?php
 class TagCloud
 {
	 var $taillepolice_min; // La plus petite taille de police
	 var $taillepolice_max; // La plus grande taille de police

	 // function classe_nuagemot initialise la classe
	 // Par dfaut la plus petite taille de police sera 8 et la plus grand 20
	 function TagCloud ($taillepolice_min = 10, $taillepolice_max = 20)
	 {
		 $this -> taillepolice_min = $taillepolice_min;
		 $this -> taillepolice_max = $taillepolice_max;
	 }

	 function addElement($id, $name, $score)
	 {
		 // Ajout de donnes au tableau
		 $this -> element_liste [$name]['score'] = $score;
		 $this -> element_liste [$name]['id'] = $id;
	 }
	 
	 function getMin()
	 {
		$min = pow(2,32);
		foreach($this -> element_liste as $key => $array)
		{
			if($array['score'] < $min)
			{
				$min = $array['score'];
			}
		}
		return $min;
	 }
	 
	 function getMax()
	 {
		$max = 0;
		foreach($this -> element_liste as $key => $array)
		{
			if($array['score'] > $max)
			{
				$max = $array['score'];
			}
		}
		return $max;
	 }

	 function generateCloud ()
	 {
		 // Calcul du coefficent de proportionalit
		 $smarty =& TemplateEngine::getInstance();
		 $re =& MyRewriteEngine::getInstance();
		 
		 $min_qty = $this->getMin ();
		 $max_qty = $this->getMax ();

		 $min_size = $this -> taillepolice_min;
		 $max_size = $this -> taillepolice_max;
		 
		 $spread = $max_qty - $min_qty;
		 $spread = $spread == 0 ? 1 : $spread;

		 $step = ($max_size - $min_size) / $spread;

		 // On parcours la liste des dones entres
		 foreach ($this -> element_liste as $name => $array)
		 {
			$score = $array['score'];
			 // Calcul me permettant d'obtenir la taille de police de chaque lment
			 $size = $min_size + (($score - $min_qty) * $step);

			 $smarty->append('tagcloud',array ('name' => $name, 'score' => $score, 'size' => $size, 'url' => $re->buildUrl('tag', array('id' => $array['id'],'tag' => $name))));
		 }
	 }
 }
?>