<?php

if(!defined("SCRIPT_ROOT_PATH"))
{
	echo 'SCRIPT_ROOT_PATH not defined in class.templateengine.php';
	exit();
}

include_once(SCRIPT_ROOT_PATH.'/class/smarty/Smarty.class.php');

/*
*	Singleton class to manage Smarty Template manager
*	@class		TemplateEngine
*	@package		Kernel
*	@subpackage	Human Interface
*	@author		Jerome Loisel
*/
class TemplateEngine
{
	/*
	*	Returns single instance of template engine
	*	@function 	getInstance
	*	@return	reference on Object {@link Smarty}
	*/
	function &getInstance()
	{
		static $smarty;

		if(!isset($smarty))
		{
			$smarty = new Smarty;
			$smarty->compile_dir = SCRIPT_ROOT_PATH."/public/templates_c";
			$smarty->cache_dir = SCRIPT_ROOT_PATH."/public/cache";
			$smarty->left_delimiter = '<{';
			$smarty->right_delimiter = '}>';
		}
		return $smarty;
	}
}

?>