<?php
/**
 *	Class to "clean up" text for various uses
 *	@class	MyTextSanitizer
 *	@package	Kernel
 *	@author	Kazumi Ono
 *	@author	Goghs Cheng
 */
class MyTextSanitizer
{

	/*
	* Constructor of this class
	*
	* Gets allowed html tags from admin config settings
	* <br> should not be allowed since nl2br will be used
	* when storing data.
	*
	* @access	private
	*
	* @todo Sofar, this does nuttin' ;-)
	*/
	function MyTextSanitizer()
	{

	}

	/**
	 * Access the only instance of this class
	 *
	 * @return	object
	 *
	 * @static
	 * @staticvar   object
	 */
	function &getInstance()
	{
		static $instance;
		if (!isset($instance)) {
			$instance = new MyTextSanitizer();
		}
		return $instance;
	}


	/**
	 * Convert linebreaks to <br /> tags
	 *
	 * @param	string  $text
	 *
	 * @return	string
	 */
	function nl2Br($text)
	{
		return preg_replace("/(\015\012)|(\015)|(\012)/","<br />",$text);
	}

	/**
	 * Add slashes to the text if magic_quotes_gpc is turned off.
	 *
	 * @param   string  $text
	 * @return  string
	 **/
	function addSlashes($text)
	{
		return ( get_magic_quotes_gpc() ? $text : addslashes( $text ) );
	}
	
	
	/*
	* if magic_quotes_gpc is on, stirip back slashes
	*
	* @param	string  $text
	*
	* @return	string
	*/
	function stripSlashesGPC($text)
	{
		return ( get_magic_quotes_gpc() ? stripslashes($text) : $text );
	}

	/*
	*  for displaying data in html textbox forms
	*
	* @param	string  $text
	*
	* @return	string
	*/
	function htmlSpecialChars( $text )
	{
		//return preg_replace("/&amp;/i", '&', htmlspecialchars($text, ENT_QUOTES));
		return preg_replace(array("/&amp;/i", "/&nbsp;/i"), array('&', '&amp;nbsp;'), htmlspecialchars($text, ENT_QUOTES));
	}

	/**
	 * Reverses {@link htmlSpecialChars()}
	 *
	 * @param   string  $text
	 * @return  string
	 **/
	function undoHtmlSpecialChars( $text )
	{
		return preg_replace(array("/&gt;/i", "/&lt;/i", "/&quot;/i", "/&#039;/i"), array(">", "<", "\"", "'"), $text);
	}
	
	/**
	 * htmlentities
	 *
	 * @param   string  $text
	 * @return  string
	 **/
	function htmlEntities($text)
	{
		return htmlentities($text);
	}
	
	/**
	 * decodes htmlentities
	 *
	 * @param   string  $text
	 * @param int quote style : php code for quote style
	 * @return  string
	 **/
	function decodeEntities($text, $quote_style = ENT_COMPAT)
	{
		if (function_exists('html_entity_decode'))
		{
			$text = html_entity_decode($text, $quote_style, 'ISO-8859-1'); // NOTE: UTF-8 does not work!
		}
		else
		{
			$trans_tbl = get_html_translation_table(HTML_ENTITIES, $quote_style);
			$trans_tbl = array_flip($trans_tbl);
			$text = strtr($text, $trans_tbl);
		}
		$text = preg_replace('~&#x([0-9a-f]+);~ei', 'chr(hexdec("\\1"))', $text);
		$text = preg_replace('~&#([0-9]+);~e', 'chr("\\1")', $text);
		return $text;
	}
	
	function utf8Encode($string)
	{
		global $CONFIG;
		if(strtolower($CONFIG['encoding']) == 'utf-8' )
		{
			$string = utf8_encode($string);
		}
		return $string;
	}
	
	function utf8Decode($string)
	{
		return utf8_decode($string);
	}
}
?>