<?php

// Base class for Database driver
require_once dirname(__FILE__).'/class.mydatabase.php';
// Base type for objects returned by database driver
require_once dirname(__FILE__).'/class.recordset.php';
// Criteria class : no more hard-coded database queries in Controller
require_once dirname(__FILE__).'/class.criteria.php';
// Database driver logging engine
require_once dirname(__FILE__).'/class.logger.php';

/*
*	Database Factory : selects the right Database connection and returns it
*	@class		DatabaseFactory
*	@package		Kernel
*	@subpackage	Database
*	@author		Jerome Loisel
*/
class DatabaseFactory
{
	/*
	*	Constructor
	*	@function	DatabaseFactory
	*	@return	void
	*/
	function DatabaseFactory()
	{
	
	}
	
	/*
	*	Loads correct Database Driver
	*	@function	getConnection
	*	@return	Reference on Object {@link MyDatabase}
	*/
	function &getConnection()
	{
		static $database;
		$config_manager =& MyConfigManager::getInstance();
		$CONFIG =& $config_manager->getconfig();
		$db_type = '';
		
		if (!isset($database))
		{
			if(isset($CONFIG) && $CONFIG['database'] != '')
			{
				$db_type = $CONFIG['database'];
			}
			else
			{
				$db_type = 'mysql';
			}
			
			$file = SCRIPT_ROOT_PATH.'/class/database/driver/class.'.$db_type.'.php';
			
			if(!is_readable($file))
			{
				$db_type = 'mysql';
			}
			else
			{
				require_once $file;
			}
			$class = ucfirst($db_type).'Database';
			$database = new $class($CONFIG['db_login'],$CONFIG['db_pass'],$CONFIG['db_host'],$CONFIG['db_name'], $CONFIG['db_prefix']);
		}

		return $database;
	}
}


/*
*	Database class is implemented using singleton design pattern
*	@class		Database (deprecated)
* 	@package		Kernel
*	@subpackage	Database
*/
class Database
{
	/*
	*	Gets an instance of Database driver through DatabaseFactory
	*	@function	getInstance
	*	@return	Reference on Object {@link MyDatabase}
	*/
	function &getInstance()
	{
		return DatabaseFactory::getConnection();
	}
	
	/*
	*	Closes database connection
	*	@function	closeIntance
	*	@return	void
	*/
	function closeInstance()
	{
		$database =& Database::getInstance();
		$database->close();
	}
}
?>
