<?php

/*
*	Logger counts total number of Database queries made for loading a page.
*	@class		Logger
*	@package		Kernel
*	@subpackage	Logger
*	@author		Jerome Loisel
*/
class Logger
{
	var $query_count;
	
	/*
	*	Constructor
	*	@function	Logger
	*	@return	void
	*/
	function Logger()
	{
		$this->query_count = 0;
	}
	
	/*
	*	Increments the query counter
	*	@function	addQuery
	*	@return	void
	*/
	function addQuery()
	{
		$this->query_count = $this->query_count + 1;
	}
	
	/*
	*	Returns the count of queries made at this time
	*	@function	getQueryCount
	*	@return	int	query count
	*/
	function getQueryCount()
	{
		return $this->query_count;
	}
}

/*
*	this class gives you a unique instance of Logger
*	@class		MyLogger
*	@package		Kernel
*	@subpackage	Logger
*	@author		Jerome Loisel
*/
class MyLogger
{
	/*
	*	Returns a unique instance of object Logger
	*	@function	getInstance
	*	@return	Object {@link Logger}
	*/
	function &getInstance()
	{
		static $instance;
        if (!isset($instance))
		{
            $instance = new Logger();
        }
        return $instance;
	}
}
?>