<?php

class MyDatabase
{
	/*
	*	Database driver logging engine
	*	@type	object {@link logger}
	*/
	var $logger;
	/*
	*	database table's prefix
	*	@type	string
	*/
	var $prefix;
	
	/*
	*	Error string
	*	@type	string
	*/
	var $error;
	
	/*
	*	Error number
	*	@type	int
	*/
	var $errno;
	
	/*
	*	Constructor
	*	@function MyDatabase
	*	@return void
	*/
	function MyDatabase()
	{
		$this->setLogger();
	}
	
	/**
	 * Returns escaped string text with single quotes around it to be safely stored in database
	 * 
	 * @param string $str unescaped string text
	 * @return string escaped string text with single quotes around
	 */	
	function quoteString($str)
	{
		return ( "'" . str_replace('\\"', '"', addslashes($str) ) . "'" );
    }
	
	/**
	 * Returns database query logger
	 * 
	 * @return object {@logger}
	 */	
	function &getLogger()
	{
		return $this->logger;
	}
	
	/*
	*	Sets a database logger
	*	@function	setLogger
	*	@return	void
	*/
	function setLogger()
	{
		$this->logger =& Logger::getInstance();
	}
	
	/*
	*	Sets table name prefix
	*	@function	setPrefix
	*	@param	string	prefix
	*	@return	void
	*/
	function setPrefix($value)
	{
		$this->prefix = $value;
	}
	
	
	/*
	*	Prefixes table name
	*	@function	prefix
	*	@param	string	table name
	*	@return	string	prefixed table name
	*/
	function prefix($tablename = '')
	{
		if ( ($tablename && $this->prefix) != '' )
		{
			return $this->prefix .'_'. $tablename;
		}
		else
		{
			return $this->prefix;
		}
	}
	
	/*
	*	Returns error code and error string if not empty
	*	@function error
	*	@return string	error number - error designation
	*/
	function error()
	{
		if ($this->error != '') {
			return $this->errno.' - '.$this->error;
		} else {
			return false;
		}
	}
	
	/*
	*	This method returns the ID of the last affected row.
	*	To overload in child class
	*	@function	getLastID
	*	@return	mixed	FALSE if failure
	*/
	function getLastID()
	{
		return false;
	}
	
	/*
	*	Executes a query and returns selected rows. Needs To be overloaded in child class
	*	@function	select
	*	@return	mixed	FALSE if failure
	*/
	function select()
	{
		return false;
	}
	
	/*
	*	Execute a query without returning any result, just false if error; Ex : UPDATE, DELETE, INSERT
	*	To overload in child class
	*	@function	execute
	*	@return	mixed
	*/
	function execute()
	{
		return false;
	}
	
	/*
	*	closing Database connection. Needs to be overloaded
	*	@function	close
	*	@return	boolean	TRUE
	*/
	function close()
	{
		return true;
	}
}

?>