<?php
/*
*	this is the base object sent by Database instance
*	@class	recordset
*	@package	Database
*	@author	Olivier Meunier
*/

/*
@param	array	arry_data		array of data
@param	integer	int_index		position of the iterator
@param	integer	int_row_count	data count
@param	integer	int_col_count	column count
@param	integer	fetch_index	private index for iterator
*/

class recordset
{
	var $arry_data;
	var $int_index;
	
	var $int_row_count;
	var $int_col_count;
	var $fetch_index;
	
	/** @doc
	=== Methods === */
	
	/**
	@function recordset
	
	'Constructor'
	
	Example of use :
	
	{{{
	#!php
	<?php
	$d = array(
		array('f1' => 'v01', 'f2' => 'v02'),
		array('f1' => 'v11', 'f2' => 'v12'),
		array('f1' => 'v21', 'f2' => 'v22')
	);
	$rs = new recordset($d);
	
	while ($rs->fetch()) {
		echo $rs->f('f1').' - '.$rs->f('f2').'<br />';
	}
	?>
	}}}
	
	@param	array	data			array of data
	*/
	function recordset($data)
	{
		$this->int_index = 0;
		$this->fetch_index = NULL;
		
		if(is_array($data))
		{
			$this->arry_data = $data;
			
			$this->int_row_count = count($this->arry_data);
			
			if ($this->int_row_count == 0)
			{
				$this->int_col_count = 0;
			}
			else
			{
				$this->int_col_count = count($this->arry_data[0]);
			}
		}
	}
	
	/**
	@function field
	
	Returns a specific field of the object
	
	@param	mixed	c			Nom ou numro du champ
	@return	string
	*/
	function field($c)
	{
		if(!empty($this->arry_data))
		{
			if(is_integer($c))
			{
				$T = array_values($this->arry_data[$this->int_index]);
				return (isset($T[($c)])) ? $T[($c)] : false;
			}
			else
			{
				$c = strtolower($c);
				if(isset($this->arry_data[$this->int_index][$c]))
				{
					if (!is_array($this->arry_data[$this->int_index][$c])) {
						return trim($this->arry_data[$this->int_index][$c]);
					} else {
						return $this->arry_data[$this->int_index][$c];
					}
				}
				else
				{
					return false;
				}
			}
		}
	}
	
	/**
	@function f
	
	Same as function field()
	
	@param	mixed	c			Nom ou numro du champ
	@return	string
	*/
	function f($c)
	{
		return $this->field($c);
	}
	

	/**
	@function setField
	
	changes the current value of field 'c' by new value 'v'
	
	@param	string	c			Nom du champ
	@param	string	v			Valeur du champ
	*/
	function setField($c,$v)
	{
		$c = strtolower($c);
		$this->arry_data[$this->int_index][$c] = $v;
	}
	
	/**
	@function moveStart
	
	sets iterator at the beginning and returns TRUE
	
	@return	boolean
	*/
	function moveStart()
	{
		$this->int_index = 0;
		return true;
	}
	
	/**
	@function moveEnd
	
	sets iterator at the end and returns true
	
	@return	boolean
	*/
	function moveEnd()
	{
		$this->int_index = ($this->int_row_count-1);
		return true;
	}
	
	/**
	@function moveNext
	
	Increments the iterator
	
	@return	boolean
	*/
	function moveNext()
	{
		if (!empty($this->arry_data) && !$this->EOF()) {
	 		$this->int_index++;
			return true;
		} else {
			return false;
		}
	}
	
	/**
	@function movePrev
	
	Decrements the iterator and return TRUE if success
	
	@return	boolean
	*/
	function movePrev()
	{
		if (!empty($this->arry_data) && $this->int_index > 0) {
			$this->int_index--;
			return true;
		} else {
			return false;
		}
	}
	
	/**
	@function move
	
	Moves iterator to 'index'.
	
	@param	integer	index		Indice
	@return	boolean
	*/
	function move($index)
	{
		if (!empty($this->arry_data) && $this->int_index >= 0 && $index < $this->int_row_count) {
			$this->int_index = $index;
			return true;
		} else {
			return false;
		}
	}
	
	/**
	@function fetch
	
	increments iterator and returns TRUE while you haven't reached the end of the array.
	
	@return	boolean
	*/
	function fetch()
	{
		if ($this->fetch_index === NULL) {
			$this->fetch_index = 0;
			$this->int_index = -1;
		}
		
		if ($this->fetch_index+1 > $this->int_row_count) {
			$this->fetch_index = NULL;
			$this->int_index = 0;
			return false;
		}
		
		$this->fetch_index++;
		$this->int_index++;
		
		return true;
	}
	
	/**
	@function BOF
	
	Is the iterator at the beginning of the array ?
	
	@return	boolean
	*/
	function BOF()
	{
		return ($this->int_index == -1 || $this->int_row_count == 0);
	}
	
	/**
	@function EOF
	
	Is the iterator at the end of the array ?
	
	@return	boolean
	*/
	function EOF()
	{
		return ($this->int_index == $this->int_row_count);
	}
	
	/**
	@function isEmpty
	
	Is the array empty ?
	
	@return	boolean
	*/
	function isEmpty()
	{
		return ($this->int_row_count == 0);
	}
	
	/**
	@function getData
	
	Returns the data array
	
	@return	array
	*/
	function getData()
	{
		return $this->arry_data;
	}
	
	/**
	@function nbRow
	
	Returns row count
	
	@return	integer
	*/
	function nbRow()
	{
		return $this->int_row_count;
	}
}
?>