<?php
# MySQL Connection Class

/**
@class connection

@param	ressource	con_id		Identifiant de connexion
@param	string	error		Dernire erreur de la base de donnes
@param	integer	errorno		Numro de la dernire erreur
*/

class MysqlDatabase extends MyDatabase
{
	var $con_id;
	
	// Query cache to avoid querying database 
	// with the same query more than one time
	var $queries = array();
	
	/** @doc
	=== Mthodes === */
	
	/**
	@function connection
	
	'''Constructeur'''. Initialise la connection  la base de donnes.
	
	@param	string	user			ID de l'utilisateur
	@param	string	pwd			Mot de passe
	@param	string	alias		Serveur auquel se connecter
	@param	string	dbname		Nom de la base de donnes
	*/
	function MysqlDatabase($user, $pwd , $alias='', $dbname, $db_prefix = '')
	{
		$this->error = '';
		$this->con_id = mysql_connect($alias, $user, $pwd) or die(mysql_error());
		
		if (!$this->con_id) {
			$this->setError();
		} else {
			$this->database($dbname);
		}
		
		$this->prefix = $db_prefix;
		
		$this->logger =& MyLogger::getInstance();
	}
	
	/**
	@function database
	
	Change de base de donnes. Renvoie vrai en cas de succs.
	
	@param	string	dbname		Nom de la base de donnes
	@return	boolean
	*/
	function database($dbname)
	{
		$db = mysql_select_db($dbname) or die(mysql_error());
		if(!$db) {
			$this->setError();
			return false;
		} else {
			return true;
		}
	}
	
	/**
	@function close
	
	Ferme la connection  la base de donnes et renvoie vrai en cas de succs.
	
	@return	boolean
	*/
	function close()
	{
		if ($this->con_id) {
			mysql_close($this->con_id);
			return true;
		} else {
			return false;
		}
	}
	
	/**
	@function select
	
	Execute une requte SQL et renvoie le resultat dans une instance de l'objet
	dont le type est dfini par $class. Le type d'objet par dfaut est un
	recordset.
	
	N'importe quel objet peut-tre utilis  la place du recordset du moment
	qu'il prend un tableau multidimmensionel comme premier argument de son
	constructeur.
	
	Cette mthode renvoie false en cas d'erreur.
	
	@param	string	query		Requte SQL
	@param	string	class		Type d'objet  renvoyer ('recordset')
	@return	recordset
	*/
	function select($query,$class='recordset')
	{
		$hashedQuery = md5($query);
		if (!$this->con_id) {
			return false;
		}
		
		if(!isset($this->queries[$hashedQuery]))
		{
			$cur = mysql_unbuffered_query($query, $this->con_id);
			
			// Logging Queries
			$this->logger->addQuery();
			
			if ($cur)
			{
				# Insertion dans le reccordset
				$i = 0;
				$arryRes = array();
				while($res = mysql_fetch_row($cur))
				{
					for($j=0; $j<count($res); $j++)
					{
						$arryRes[$i][strtolower(mysql_field_name($cur, $j))] = $res[$j];		
					}
					$i++;
				}
				
				$this->queries[$hashedQuery] = new $class($arryRes);
			}
			else
			{
				$this->setError();
				$this->queries[$hashedQuery] = false;
			}
		}
		return $this->queries[$hashedQuery];
	}
	
	/**
	@function execute
	
	Cette mthode excute la requte $query et renvoi vrai si aucune erreur
	ne s'est produite, faux dans le cas contraire.
	
	@param	string	query		Requte SQL
	@return	boolean
	*/
	function execute($query)
	{
		if (!$this->con_id) {
			return false;
		}

		$cur = mysql_query($query, $this->con_id);
		
		// Logging Queries
		$this->logger->addQuery();
		
		if (!$cur) {
			$this->setError();
			return false;
		} else {
			return true;
		}
		
	}
	
	/*
	*	This method returns the ID of the last affected row.
	*	@function	getLastID
	*	@return	mixed	FALSE if failure
	*/
	function getLastID()
	{
		if ($this->con_id) {
			return mysql_insert_id($this->con_id);
		} else {
			return false;
		}
	}
	
	/**
	@function rowCount
	
	Cette mthode indique le nombre de lignes affectes par la dernire
	opration en DELETE, INSERT, UPDATE.
	
	@return	integer
	*/
	function rowCount()
	{
		if ($this->con_id) {
			return mysql_affected_rows($this->con_id);
		} else {
			return false;
		}
	}
	
	/**
	@function setError
	
	Cette mthode rfrence la dernire erreur du moteur de base de donnes
	dans les proprits '''error''' et '''errorno'''.
	
	Le rsultat de cette mthode prive est exploitable par la mthode
	''error''.
	*/
	function setError()
	{
		if ($this->con_id) {
			$this->error = mysql_error($this->con_id);
			$this->errno = mysql_errno($this->con_id);
		} else {
			$this->error = (mysql_error() !== false) ? mysql_error() : 'Unknown error';
			$this->errno = (mysql_errno() !== false) ? mysql_errno() : 0;
		}
	}
	
	/**
	@function escapeStr
	
	Cette mthode formate une chane de caractres pour la protger lors de
	son insertion dans une requte SQL.
	
	@param	string	str			Chane  protger
	@return	string
	*/
	function escapeStr($str)
    {
        if (get_magic_quotes_gpc()) {
            $str = stripslashes($str);
        }
        return mysql_escape_string($str);
    }
}

?>
