<?php

require_once SCRIPT_ROOT_PATH.'/class/date/datelang.php';

class HDAdate extends HDAdate_lang {

	var $date;
	var $date_elements;
	var $timestamp;
	var $format;
	var $error_log;
	var $date_lang;
	
	function HDAdate() {
	
		$this->date_elements = array();
		$this->format = array();
		$this->date_lang = 'en';
		
		// get the prefered language
		// en , fr
		parent::Set_lang('fr');
	}
	
	function Get_date_elements($date, $lg='en') {
	
		// is it a Timestamp ?
		if(preg_match('`^[0-9]+$`', $date)) {
			$this->timestamp = $date;
			$this->format[] = 'TS';
			return TRUE;
		}
	
		$this->date_elements = array();
		$this->format = array();
		
		// DO You like REGsEXe ?
	
		// Delimiter 
		$d = '[-.,;:/_# ]*';
	
		// EN ::: An English format like 2003-12-25
		if($this->date_lang === 'en'){
			$start = 	'([a-z]* *)?((?:19|20)?[0-9]{1,2})('.$d.')'.
						'([0-1][0-9])('.$d.')'.
						'([0-3][0-9])';}
			
		// FR ::: A French format like 25-12-2003
		else		
			$start = 	'([a-z]* *)?([0-3][0-9])('.$d.')'.
						'([0-1][0-9])('.$d.')'.
						'((?:19|20)?[0-9]{1,2})';
					
		// hours, minutes & seconds
		// if necessary
		$end = 	' *(([0-2][0-9])('.$d.')([0-5][0-9])('.$d.')([0-5][0-9]))?';
		
		/**
		 The Complete MASK of the REGEX
		 
		 	([a-z]* *)? => match optiannly the day write in letters like Sunday or DIM
			EN version :
			((?:19|20)?[0-9]{1,2}) => match the Complete Year --- *1
				- (?:19|20)? => start with 19 or 20 optiannaly, non capturant (?:)
				- (..[0-9]{1,2}) => so,  Year like 03 for 2003
			FR version :
				- ([0-3][0-9]) match the DAY like 01 or 31 --- *2
			('.$d.') => it breaks date -> [-.,;:/_# ]*, can be found later
			([0-1][0-9]) => match the MONTH like 01 or 12
			EN version :
				- ([0-3][0-9]) --- *2
		 	FR version 
				((?:19|20)?[0-9]{1,2}) --- *1
				
			---------------------------------
			Hours, Minutes & Seconds .... Optiannals (?)
			
			([0-2][0-9]) => match Hours like 01 to 23
			([0-5][0-9]) => match minutes like 00 to 59
			([0-5][0-9]) => match seconds like 00 to 59
			
			
			it' s done, we get all :)
		 */
		
		preg_match(	'`^' . $start . $end . '$`i', $date, $regs);
		
		// Mask was found :)
		if(isset($regs[0])) {
		
			// Day in letters (optionnal)
			if(isset($regs[1]) && !empty($regs[1])) 
				$this->format[] = strlen($regs[1]) <= 3 ? 'SD ' : 'LD ';
			else $this->format[] = '';
			
			if($this->date_lang === 'en'){
			
				$this->date_elements['year'] = $regs[2];
				$this->format[] = strlen($regs[2]) <= 3 ? 'SY' : 'LY';
			}
			else {
				$this->date_elements['day'] = $regs[2];
				$this->format[] = 'ND';
			}
				
				$this->format[] = $regs[3];
			
				$this->date_elements['month'] = $regs[4];
				$this->format[] = 'NM';
			
				$this->format[] = $regs[5];
				
			if($this->date_lang === 'en'){
					$this->date_elements['day'] = $regs[6];
					$this->format[] = 'ND';
				}
			else {
					$this->date_elements['year'] = $regs[6];
					$this->format[] = strlen($regs[6]) <= 3 ? 'SY' : 'LY';
				}
				
			// Hours, minutes & seconds are found
			if(isset($regs[7])) {
			
				// put a space to separe
				// match it ????
				$this->format[] = ' ';
			
				$this->date_elements['hour'] = $regs[8];
				$this->format[] = 'LH';
				
				$this->format[] = $regs[9];
				
				$this->date_elements['minute'] = $regs[10];
				$this->format[] = 'NI';
				
				$this->format[] = $regs[11];
				
				$this->date_elements['second'] = $regs[12];
				$this->format[] = 'NS';
				
			
			}
			else {
			
				$this->date_elements['hour'] 	= 0;
				$this->date_elements['minute'] 	= 0;
				$this->date_elements['second'] 	= 0;
					
			}
			

			
			
			
			/*
			
			For debugs ...
			
			echo '<pre>';
			echo print_r($regs);
			
			echo '<pre>';
			echo print_r($this->date_elements);
			
			echo '<pre>';
			echo print_r($this->format);
			*/
			
			
			$this->timestamp = $this->Get_timestamp(
											$this->date_elements['year'],
											$this->date_elements['month'],
											$this->date_elements['day'],
											$this->date_elements['hour'],
											$this->date_elements['minute'],
											$this->date_elements['second']
											);
			
			return TRUE;
		}
		
		return FALSE;
	}
	
	/**
	 *
	 * Return timestamp
	 *
	 * @ACCESS Private
	 *
	 */
	function Get_timestamp($years=0, $mon=0, $days=0, $hours=0, $min=0, $sec=0) {
	
		return  mktime($hours, $min, $sec, $mon, $days, $years);
	}
	
	
		
	/**
	 * Return Date formated from a Timestamp
	 *
	 * *** Second Parameter :::
	 *
	 * lexic :
	 * FIRST Letter (N:numeric : S:short : L:long) 
	 * SECOND Letter (D:day : M:month : Y:year : H:hour : I:minutes : S:seconds)
	 * OTHERS :
	 * TS => timestamp
	 *
	 * - ND - Day of month like 12, 03
	 * - SD - Short Day in 3 letters & in the specified lang like Sat (saturday) or Lun (Lundi)
	 * - LD - Long Day in letters like Saturday or Dimanche
	 * - NM - Month like 03
	 * - SM - Short Month in 3 letters
	 * - LM - Long Month in 3 letters
	 * - SY - Year like 03 (for 2003)
	 * - LY - Year like 2001
	 *
	 * - SH - Hour 0 -> 12
	 * - LH - Hour 0 -> 24
	 * - NI - Minutes
	 * - NS - Seconds
	 *
	 * - TS - Timestamp
	 *
	 * @ACCESS Private
	 *
	 */
	function Convert($ts, $format) {
		
			$D = getdate($ts);
			
			$in = array(
						'ND', 
						'SD', 
						'LD',
						'NM',
						'SM',
						'LM',
						'SY',
						'LY',
						'LH',
						'SH',
						'NI',
						'NS',
						'TS'
						);
						
			$out = array(
						date('d', $ts), 
						$this->lg['SD'][number_format($D['wday'])], 
						$this->lg['D'][number_format($D['wday'])],
						date('m', $ts), 
						$this->lg['SM'][number_format($D['mon'])], 
						$this->lg['M'][number_format($D['mon'])],
						date('y', $ts), 
						date('Y', $ts),
						date('H', $ts),
						date('h', $ts),
						date('i', $ts),
						date('s', $ts),
						$ts
						);

			return str_replace($in, $out, $format);
	
	}
	
	function Add_Sub_time($date, $ops, $days=0, $hours=0, $minutes=0, $seconds=0) {
	
		if($this->Get_date_elements($date, $this->date_lang)) {
		
			$tmp =  strtotime(	$ops.
								$days.'days '.$ops.
								$hours.'hours '.$ops.
								$minutes.'minutes '.$ops.
								$seconds.'seconds', 
								$this->timestamp
							);
		
			return $this->Convert($tmp, implode('', $this->format));
		}
		
	return FALSE;
	}
	
	
	/****************************
	*							*
	* 		PUBLIC ACCESS       *
	*							*
	****************************/
	
	
	/**
	 * 
	 * Set the date format
	 *
	 * (YY)YY MM DD ==> en
	 * DD MM (YY)YY ==> fr
	 *
	 * en | fr
	 *
	 * @ACCESS Public
	 *
	 */
	function Set_date_lang($lg) {
	
		$this->date_lang = $lg;
	}
	
	/**
	 * LIKE date() function
	 *
	 * expects than the second parameter accepts date STRING format
	 *
	 */
	function _Date($format, $date=0) {
	
		if($date !== 0) {
			if($this->Get_date_elements($date, $this->date_lang))		
				$date = $this->timestamp;	
		}
		else $date = time();

		$ret = date($format, $date);
		return $ret;
	}
	
	
	/**
	 *
	 * Return date formated
	 * Arguments may be left out in order from right to left;
	 *
	 *
	 * @ACCESS Public
	 *
	 */
	function Add_time($date, $days=0, $hours=0, $minutes=0, $seconds=0) {
	
		$tmp = $this->Add_Sub_time($date, '+', $days, $hours, $minutes, $seconds);
		if($tmp)
			return $tmp;
			
		else {
			$this->error_log = "La date $date n' est pas au bon format!!";
			return FALSE;
		}
	}
		
	/**
	 *
	 * Return date formated
	 * Arguments may be left out in order from right to left;
	 *
	 *
	 * @ACCESS Public
	 *
	 */
	function Sub_time($date, $days=0, $hours=0, $minutes=0, $seconds=0) {
	
		$tmp = $this->Add_Sub_time($date, '-', $days, $hours, $minutes, $seconds);
		if($tmp)
			return $tmp;
			
		else {
			$this->error_log = "La date $date n' est pas au bon format!!";
			return FALSE;
		}		
	}




} // end class


?>