<?php

require_once SCRIPT_ROOT_PATH.'/class/object/class.object.php';

/*
*	Allopass object class
* 
*	@author	Jerome Loisel
*	@copyright	Jerome Loisel
*	@package	Kernel
*/
class Allopass extends MyObject
{
	/**
	 * Allopass constructor
	 * 
	 * @param array of vars to assign to Validation attributes
	 * 
	 * @return void
	 */
	function Allopass($vars = null)
	{
		$table = 'allopass';
		$this->MyObject($table, $vars);
		
		$attributes = array(
		'ip' => array('data_type' => XOBJ_DTYPE_TXTBOX, 'value' => null, 'maxlength' => '15'), 
		'code' => array('data_type' => XOBJ_DTYPE_TXTBOX, 'value' => '', 'maxlength' => '8'),
		'action' => array('data_type' => XOBJ_DTYPE_TXTBOX, 'value' => '', 'maxlength' => '50'), 
		'date' => array('data_type' => XOBJ_DTYPE_OTHER, 'value' => time(), 'maxlength' => '0') );
		
		$this->setAttributes($attributes);
	}
}


/*
*	Allopass Manager class
* 
*	@author	Jerome Loisel
*	@copyright	Jerome Loisel
*	@package	Kernel
*/
class AllopassManager extends MyObjectManager
{
	/**
	 * Allopass Manager constructor
	 * 
	 * do not instanciate this object directly
	 * use : get_manager("Allopass"); instead
	 * 
	 * @return void
	 */
	function AllopassManager()
	{
		$specs = array(
		'table' => 'allopass', 
		'keyName' => array('ip','code'), 
		'className' => 'Allopass' );
		
		$this->MyObjectManager($specs);
	}
	
	/*
	*	Deletes Premium access by removing IP from allopass table
	*	If user has entered many codes, it only deletes one code, others are still available :-)
	*	@func	deletePremiumAccess
	*	@return	boolean
	*/
	function deletePremiumAccess($action)
	{
		if(!empty($action))
		{
			$ip = $_SERVER['REMOTE_ADDR'];
			$criteria = new CriteriaCompo(new Criteria('ip',$ip,'='),'AND');
			$criteria->add(new Criteria('action',$action,'='),'AND');
			$criteria->setLimit(1);
			
			return($this->deleteAll($criteria));
		}
		else
		{
			return false;
		}
	}
	
	/*
	*	Checks if logued in user has premium access
	*	@func	hasPremiumAccess
	*	@param	string	action
	*	@return	boolean
	*/
	function hasPremiumAccess($action)
	{
		global $CONFIG;
		if(!empty($action))
		{
			$ip = $_SERVER['REMOTE_ADDR'];
			$now = time ();
			$expiration_time = $CONFIG ['allopass_expiration_time'];
			$criteria = new CriteriaCompo(new Criteria('ip',$ip,'='),'AND');
			$criteria->add(new Criteria('action',$action,'='),'AND');
			$criteria->add ( new Criteria ( 'date', $now - $expiration_time, '>=' ), 'AND' );
			$criteria->setLimit(1);
			
			return $this->getCount($criteria);
		}
		else
		{
			return false;
		}
	}
}

?>