<?php

require_once SCRIPT_ROOT_PATH.'/class/object/class.object.php';

/*
*	Boost object class
* 
*	@author	Jerome Loisel
*	@copyright	Jerome Loisel
*	@package	Kernel
*/
class Boost extends MyObject
{
	/**
	 * In  constructor
	 * 
	 * @param array of vars to assign to Boost attributes
	 * 
	 * @return void
	 */
	function Boost($vars = null)
	{
		$table = "boost";
		$this->MyObject($table, $vars);
		
		$attributes = array(
		'id' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '10'),
		'date' => array('data_type' => XOBJ_DTYPE_OTHER, 'value' => date("Y-m-d H:i:s"), 'maxlength' => '0'),
		'is_allopass' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '1') ); 
		
		$this->setAttributes($attributes);
	}
}


/*
*	Boost Manager class
* 
*	@author	Jerome Loisel
*	@copyright	Jerome Loisel
*	@package	Kernel
*/
class BoostManager extends MyObjectManager
{
	/**
	 * Boost Manager constructor
	 * 
	 * do not instanciate this object directly
	 * use : get_manager("Boost"); instead
	 * 
	 * @return void
	 */
	function BoostManager()
	{
		$specs = array(
		'table' => "boost", 
		'keyName' => 'id', 
		'className' => 'Boost' );
		
		$this->MyObjectManager($specs);
	}
	
	function &getBoostedWebsites($cols = array())
	{
		$ret = array();
		$lm =& get_manager('link');
		$limit = 1;
		$sql = "SELECT ";
		if(count($cols) > 0)
		{
			$sql .= $lm->table.".`".implode('`,'.$lm->table.'.`',$cols)."`";
		}
		else
		{
			$sql .= $lm->table.".*";
		}
		$sql .= " FROM `".$lm->table."`,`".$this->table."` WHERE ".$this->table.".`id`=".$lm->table.".`id` LIMIT ".$limit;
		
		$result = $this->con->select($sql);
		$this->displayDebugQuery($sql,$result);
		
		if ($result)
		{
			$array = $result->getData();

			foreach($array as $key => $objectattr)
			{
				$object = new $lm->classname();
				$object->unsetNew();
				$object->assignVars($objectattr);
				$ret[] = $object;
				unset($object);
			}
		}
		return $ret;
	}
}

?>