<?php

require_once SCRIPT_ROOT_PATH.'/class/object/class.object.php';

/*
*	Cat2Pub object class
* 
*	@author	Jerome Loisel
*	@copyright	Jerome Loisel
*	@package	Kernel
*/
class Cat2Pub extends MyObject
{
	/**
	 * Cat2Pub constructor
	 * 
	 * @param array of vars to assign to Cat2Pub attributes
	 * 
	 * @return void
	 */
	function Cat2Pub($vars = null)
	{
		$table = "cat2pub";
		$this->MyObject($table, $vars);
		
		$attributes = array(
		'idcat' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '11'), 
		'idpub' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '11') ); 
		
		$this->setAttributes($attributes);
	}
}


/*
*	Cat2Pub Manager class
* 
*	@author	Jerome Loisel
*	@copyright	Jerome Loisel
*	@package	Kernel
*/
class Cat2PubManager extends MyObjectManager
{
	/**
	 * Cat2Pub Manager constructor
	 * 
	 * do not instanciate this object directly
	 * use : get_manager("Cat2Pub"); instead
	 * 
	 * @return void
	 */
	function Cat2PubManager()
	{
		$specs = array(
		'table' => "cat2pub", 
		'keyName' => array('idcat','idpub'), 
		'className' => 'Cat2Pub' );
		
		$this->MyObjectManager($specs);
	}
}

?>