<?php

require_once SCRIPT_ROOT_PATH.'/class/object/class.object.php';

/**
 * Category object class
 * 
 * @author Jerome Loisel
 * @copyright Jerome Loisel
 * @package kernel
 **/
class Category extends MyObject
{
	/**
	 * Category constructor
	 * 
	 * @param array of vars to assign to category attributes
	 * 
	 * @return void
	 */
	function Category($vars = null)
	{
		$table = "category";
		$this->MyObject($table, $vars);
		
		$attributes = array(
		'id' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '4'), 
		'name' => array('data_type' => XOBJ_DTYPE_TXTBOX, 'value' => null, 'maxlength' => '255'),  
		'root' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '4'), 
		'usable' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '1') ); 
		
		$this->setAttributes($attributes);
	}
}


/**
 * Category Manager class
 * 
 * @author Jerome Loisel
 * @copyright Jerome Loisel
 * @package kernel
 **/
class CategoryManager extends MyObjectManager
{
	/**
	 * Category Manager constructor
	 * 
	 * do not instanciate this object directly
	 * use : get_manager("category"); instead
	 * 
	 * @return void
	 */
	function CategoryManager()
	{
		$specs = array(
		'table' => "category", 
		'keyName' => 'id', 
		'className' => 'Category' );
		
		$this->MyObjectManager($specs);
	}
}

?>