<?php

require_once SCRIPT_ROOT_PATH.'/class/object/class.object.php';

/**
 * Comment object class
 * 
 * @author Jerome Loisel
 * @copyright Jerome Loisel
 * @package kernel
 **/
class Comment extends MyObject
{
	/**
	 * Comment constructor
	 * 
	 * @param array of vars to assign to Comment attributes
	 * 
	 * @return void
	 */
	function Comment($vars = null)
	{
		$table = "comment";
		$this->MyObject($table, $vars);
		
		$attributes = array(
		'id' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '11'), 
		'lid' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '11'), 
		'uid' => array('data_type' => XOBJ_DTYPE_INT, 'value' => 0, 'maxlength' => '10'), 
		'message' => array('data_type' => XOBJ_DTYPE_TXTBOX, 'value' => '', 'maxlength' => '0'), 
		'date' => array('data_type' => XOBJ_DTYPE_OTHER, 'value' => date("Y-m-d"), 'maxlength' => '0'), 
		'approved' => array('data_type' => XOBJ_DTYPE_INT, 'value' => 0, 'maxlength' => '1') ); 
		
		$this->setAttributes($attributes);
	}
}


/**
 * Comment Manager class
 * 
 * @author Jerome Loisel
 * @copyright Jerome Loisel
 * @package kernel
 **/
class CommentManager extends MyObjectManager
{
	/**
	 * Comment Manager constructor
	 * 
	 * do not instanciate this object directly
	 * use : get_manager("Comment"); instead
	 * 
	 * @return void
	 */
	function CommentManager()
	{
		$specs = array(
		'table' => "comment", 
		'keyName' => 'id', 
		'className' => 'Comment' );
		
		$this->MyObjectManager($specs);
	}
}