<?php

require_once SCRIPT_ROOT_PATH.'/class/object/class.object.php';

/*
*	Emplacement object class
* 
*	@author	Jerome Loisel
*	@copyright	Jerome Loisel
*	@package	Kernel
*/
class Emplacement extends MyObject
{
	/**
	 * Emplacement constructor
	 * 
	 * @param array of vars to assign to Emplacement attributes
	 * 
	 * @return void
	 */
	function Emplacement($vars = null)
	{
		$table = "emplacement";
		$this->MyObject($table, $vars);
		
		$attributes = array(
		'id' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '11'), 
		'name' => array('data_type' => XOBJ_DTYPE_TXTBOX, 'value' => null, 'maxlength' => '255'),  
		'width' => array('data_type' => XOBJ_DTYPE_INT, 'value' => 468, 'maxlength' => '4'), 
		'height' => array('data_type' => XOBJ_DTYPE_INT, 'value' => 60, 'maxlength' => '4') ); 
		
		$this->setAttributes($attributes);
	}
}


/*
*	Emplacement Manager class
* 
*	@author	Jerome Loisel
*	@copyright	Jerome Loisel
*	@package	Kernel
*/
class EmplacementManager extends MyObjectManager
{
	/**
	 * Emplacement Manager constructor
	 * 
	 * do not instanciate this object directly
	 * use : get_manager("Emplacement"); instead
	 * 
	 * @return void
	 */
	function EmplacementManager()
	{
		$specs = array(
		'table' => "emplacement", 
		'keyName' => 'id', 
		'className' => 'Emplacement' );
		
		$this->MyObjectManager($specs);
	}
}

?>