<?php

require_once SCRIPT_ROOT_PATH.'/class/object/class.object.php';

/**
 * Feed object class
 * 
 * @author Jerome Loisel
 * @copyright Jerome Loisel
 * @package kernel
 **/
class Feed extends MyObject
{
	/*
	*	Feed constructor
	* 	@param	array of vars to assign to Feed attributes
	*	@return	void
	*/
	function Feed($vars = null)
	{
		$table = "feed";
		$this->MyObject($table, $vars);
		
		$attributes = array(
		'id' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '10'), 
		'name' => array('data_type' => XOBJ_DTYPE_TXTBOX, 'value' => null, 'maxlength' => '100'), 
		'linkid' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '10'), 
		'feed' => array('data_type' => XOBJ_DTYPE_TXTBOX, 'value' => null, 'maxlength' => '250') );
		
		$this->setAttributes($attributes);
	}
}


/**
 * Feed Manager class
 * 
 * @author Jerome Loisel
 * @copyright Jerome Loisel
 * @package kernel
 **/
class FeedManager extends MyObjectManager
{
	/**
	 * Feed Manager constructor
	 * 
	 * do not instanciate this object directly
	 * use : get_manager("Feed"); instead
	 * 
	 * @return void
	 */
	function FeedManager()
	{
		$specs = array(
		'table' => "feed", 
		'keyName' => 'id', 
		'className' => 'Feed' );
		
		$this->MyObjectManager($specs);
	}
}

?>