<?php

require_once SCRIPT_ROOT_PATH.'/class/object/class.object.php';

/*
*	Validation object class
* 
*	@author	Jerome Loisel
*	@copyright	Jerome Loisel
*	@package	Kernel
*/
class In extends MyObject
{
	/**
	 * In  constructor
	 * 
	 * @param array of vars to assign to Validation attributes
	 * 
	 * @return void
	 */
	function In($vars = null)
	{
		$table = "in";
		$this->MyObject($table, $vars);
		
		$attributes = array(
		'uid' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '9'),
		'date' => array('data_type' => XOBJ_DTYPE_OTHER, 'value' => date("Y-m-d"), 'maxlength' => '0'), 
		'ins' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '6') ); 
		
		$this->setAttributes($attributes);
	}
}


/*
*	In Manager class
* 
*	@author	Jerome Loisel
*	@copyright	Jerome Loisel
*	@package	Kernel
*/
class InManager extends MyObjectManager
{
	/**
	 * In Manager constructor
	 * 
	 * do not instanciate this object directly
	 * use : get_manager("In"); instead
	 * 
	 * @return void
	 */
	function InManager()
	{
		$specs = array(
		'table' => "in", 
		'keyName' => array('uid','date'), 
		'className' => 'In' );
		
		$this->MyObjectManager($specs);
	}
	
	function incrementIns($criteria = null)
	{
		if (isset($criteria) && is_subclass_of($criteria, 'criteriaelement'))
		{
			$sql = "UPDATE `".$this->table."` SET `ins`=ins+1 ".$criteria->renderWhere();
			$limit = $criteria->getLimit() == 0 ? 1 : $criteria->getLimit();
			$sql .= " LIMIT ".$limit;
			return $this->con->execute($sql);
		}
		return false;
	}
}

?>