<?php

require_once SCRIPT_ROOT_PATH.'/class/object/class.object.php';

/*
*	InLog object class
* 
*	@author	Jerome Loisel
*	@copyright	Jerome Loisel
*	@package	Kernel
*/
class Inlog extends MyObject
{
	/**
	 * Inlog constructor
	 * 
	 * @param array of vars to assign to Validation attributes
	 * 
	 * @return void
	 */
	function Inlog($vars = null)
	{
		$table = "inlog";
		$this->MyObject($table, $vars);
		
		$attributes = array(
		'ip' => array('data_type' => XOBJ_DTYPE_TXTBOX, 'value' => '', 'maxlength' => '16'), 
		'uid' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '11'),
		'date' => array('data_type' => XOBJ_DTYPE_OTHER, 'value' => date("Y-m-d"), 'maxlength' => '0') ); 
		
		$this->setAttributes($attributes);
	}
}


/*
*	Inlog Manager class
* 
*	@author	Jerome Loisel
*	@copyright	Jerome Loisel
*	@package	Kernel
*/
class InlogManager extends MyObjectManager
{
	/**
	 * Inlog Manager constructor
	 * 
	 * do not instanciate this object directly
	 * use : get_manager("inlog"); instead
	 * 
	 * @return void
	 */
	function InlogManager()
	{
		$specs = array(
		'table' => "inlog", 
		'keyName' => 'ip', 
		'className' => 'Inlog' );
		
		$this->MyObjectManager($specs);
	}
}

?>