<?php

require_once SCRIPT_ROOT_PATH.'/class/object/class.object.php';

/**
 * Iplog object class
 * 
 * @author Jerome Loisel
 * @copyright Jerome Loisel
 * @package kernel
 **/
class Iplog extends MyObject
{
	/**
	 * Iplog constructor
	 * 
	 * @param array of vars to assign to Validation attributes
	 * 
	 * @return void
	 */
	function Iplog($vars = null)
	{
		$table = "iplog";
		$this->MyObject($table, $vars);
		
		$attributes = array(
		'ip' => array('data_type' => XOBJ_DTYPE_TXTBOX, 'value' => '', 'maxlength' => '16'), 
		'linkid' => array('data_type' => XOBJ_DTYPE_TXTBOX, 'value' => null, 'maxlength' => '10'),  
		'clic' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '70'), 
		'vote' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '40'), 
		'date' => array('data_type' => XOBJ_DTYPE_OTHER, 'value' => date("Y-m-d"), 'maxlength' => '0'));
		
		$this->setAttributes($attributes);
	}
}


/**
 * Iplog Manager class
 * 
 * @author Jerome Loisel
 * @copyright Jerome Loisel
 * @package kernel
 **/
class IplogManager extends MyObjectManager
{
	/**
	 * Iplog Manager constructor
	 * 
	 * do not instanciate this object directly
	 * use : get_manager("iplog"); instead
	 * 
	 * @return void
	 */
	function IplogManager()
	{
		$specs = array(
		'table' => "iplog", 
		'keyName' => 'ip', 
		'className' => 'Iplog' );
		
		$this->MyObjectManager($specs);
	}
}

?>