<?php

require_once SCRIPT_ROOT_PATH.'/class/object/class.object.php';

/**
 * Keyword object class
 * 
 * @author Jerome Loisel
 * @copyright Jerome Loisel
 * @package kernel
 **/
class Keyword extends MyObject
{
	/**
	 * Keyword constructor
	 * 
	 * @param array of vars to assign to Keyword attributes
	 * 
	 * @return void
	 */
	function Keyword($vars = null)
	{
		$table = "keyword";
		$this->MyObject($table, $vars);
		
		$attributes = array(
		'id' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '10'), 
		'word' => array('data_type' => XOBJ_DTYPE_TXTBOX, 'value' => null, 'maxlength' => '200'),  
		'occurence' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '6'), 
		'date' => array('data_type' => XOBJ_DTYPE_OTHER, 'value' => date("Y-m-d"), 'maxlength' => '0'), 
		'hasresults' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '1')); 
		
		$this->setAttributes($attributes);
	}
}


/**
 * Keyword Manager class
 * 
 * @author Jerome Loisel
 * @copyright Jerome Loisel
 * @package kernel
 **/
class KeywordManager extends MyObjectManager
{
	/**
	 * Keyword Manager constructor
	 * 
	 * do not instanciate this object directly
	 * use : get_manager("keyword"); instead
	 * 
	 * @return void
	 */
	function KeywordManager()
	{
		$specs = array(
		'table' => "keyword", 
		'keyName' => 'id', 
		'className' => 'Keyword' );
		
		$this->MyObjectManager($specs);
	}
}

?>