<?php

require_once SCRIPT_ROOT_PATH.'/class/object/class.object.php';

/**
 * Link object class
 * 
 * @author Jerome Loisel
 * @copyright Jerome Loisel
 * @package kernel
 **/
class Link extends MyObject
{
	/**
	 * Link constructor
	 * 
	 * @param array of vars to assign to link attributes
	 * 
	 * @return void
	 */
	function Link($vars = null)
	{
		$table = "link";
		$this->MyObject($table, $vars);
		
		$attributes = array(
		'id' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '10'), 
		'uid' => array('data_type' => XOBJ_DTYPE_INT, 'value' => 0, 'maxlength' => '10'), 
		'name' => array('data_type' => XOBJ_DTYPE_TXTBOX, 'value' => '', 'maxlength' => '255'),  
		'url' => array('data_type' => XOBJ_DTYPE_URL, 'value' => '', 'maxlength' => '150'), 
		'description' => array('data_type' => XOBJ_DTYPE_TXTBOX, 'value' => '', 'maxlength' => '0'), 
		'state' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '1'), 
		'category' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '4'), 
		'pr' => array('data_type' => XOBJ_DTYPE_INT, 'value' => 0, 'maxlength' => '2'), 
		'image' => array('data_type' => XOBJ_DTYPE_URL, 'value' => '', 'maxlength' => '200'), 
		'hits' => array('data_type' => XOBJ_DTYPE_INT, 'value' => 0, 'maxlength' => '6'), 
		'prio' => array('data_type' => XOBJ_DTYPE_INT, 'value' => 0, 'maxlength' => '1'), 
		'vote' => array('data_type' => XOBJ_DTYPE_INT, 'value' => 0, 'maxlength' => '4'), 
		'broken' => array('data_type' => XOBJ_DTYPE_INT, 'value' => 0, 'maxlength' => '1'),
		'email' => array('data_type' => XOBJ_DTYPE_EMAIL, 'value' => '', 'maxlength' => '255'), 
		'date' => array('data_type' => XOBJ_DTYPE_OTHER, 'value' => date("Y-m-d"), 'maxlength' => '0') ); 
		
		$this->setAttributes($attributes);
	}
}


/**
 * Link Manager class
 * 
 * @author Jerome Loisel
 * @copyright Jerome Loisel
 * @package kernel
 **/
class LinkManager extends MyObjectManager
{
	/**
	 * Link Manager constructor
	 * 
	 * do not instanciate this object directly
	 * use : get_manager("link"); instead
	 * 
	 * @return void
	 */
	function LinkManager()
	{
		$specs = array(
		'table' => "link", 
		'keyName' => 'id', 
		'className' => 'Link' );
		
		$this->MyObjectManager($specs);
	}
	
	/**
	 * Increments hits of a link by 1
	 * 
	 * @param object $criteria {@criteria}
	 * 
	 * @return bool : TRUE if success
	 */
	function incrementHits($criteria = null)
	{
		if (isset($criteria) && is_subclass_of($criteria, 'criteriaelement'))
		{
			$sql = "UPDATE `".$this->table."` SET `hits`=hits+1 ".$criteria->renderWhere();
			$limit = $criteria->getLimit() == 0 ? 1 : $criteria->getLimit();
			$sql .= " LIMIT ".$limit;
			return $this->con->execute($sql);
		}
		return false;
	}
	
	/**
	 * Increments votes of a link by 1
	 * 
	 * @param object $criteria {@criteria}
	 * 
	 * @return bool : TRUE if success
	 */
	function incrementVotes($criteria = null)
	{
		if (isset($criteria) && is_subclass_of($criteria, 'criteriaelement'))
		{
			$sql = "UPDATE `".$this->table."` SET `vote`=vote+1 ".$criteria->renderWhere();
			$limit = $criteria->getLimit() == 0 ? 1 : $criteria->getLimit();
			$sql .= " LIMIT ".$limit;
			return $this->con->execute($sql);
		}
		return false;
	}
}