<?php

require_once SCRIPT_ROOT_PATH.'/class/object/class.object.php';

/**
 * Link2Tag object class
 * 
 * @author Jerome Loisel
 * @copyright Jerome Loisel
 * @package kernel
 **/
class Link2Tag extends MyObject
{
	/**
	 * Link2Tag constructor
	 * 
	 * @param array of vars to assign to Tag attributes
	 * 
	 * @return void
	 */
	function Link2Tag($vars = null)
	{
		$table = "link2tag";
		$this->MyObject($table, $vars);
		
		$attributes = array(
		'lid' => array('data_type' => XOBJ_DTYPE_INT, 'value' => 0, 'maxlength' => '11'), 
		'tid' => array('data_type' => XOBJ_DTYPE_INT, 'value' => 0, 'maxlength' => '11') ); 
		
		$this->setAttributes($attributes);
	}
}


/**
 * Link2Tag Manager class
 * 
 * @author Jerome Loisel
 * @copyright Jerome Loisel
 * @package kernel
 **/
class Link2TagManager extends MyObjectManager
{
	/**
	 * Link2Tag Manager constructor
	 * 
	 * do not instanciate this object directly
	 * use : get_manager("Link2Tag"); instead
	 * 
	 * @return void
	 */
	function Link2TagManager()
	{
		$specs = array(
		'table' => "link2tag", 
		'keyName' => array('lid','tid'), 
		'className' => 'Link2Tag' );
		
		$this->MyObjectManager($specs);
	}
}