<?php

require_once SCRIPT_ROOT_PATH.'/class/object/class.object.php';

/*
*	Pub object class
* 
*	@author	Jerome Loisel
*	@copyright	Jerome Loisel
*	@package	Kernel
*/
class Pub extends MyObject
{
	/**
	 * Pub constructor
	 * 
	 * @param array of vars to assign to Pub attributes
	 * 
	 * @return void
	 */
	function Pub($vars = null)
	{
		$table = "pub";
		$this->MyObject($table, $vars);
		
		$attributes = array(
		'id' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '11'), 
		'name' => array('data_type' => XOBJ_DTYPE_TXTBOX, 'value' => null, 'maxlength' => '255'), 
		'id_emp' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '11'),  
		'code' => array('data_type' => XOBJ_DTYPE_TXTAREA, 'value' => '', 'maxlength' => '0') ); 
		
		$this->setAttributes($attributes);
	}
}


/*
*	Pub Manager class
* 
*	@author	Jerome Loisel
*	@copyright	Jerome Loisel
*	@package	Kernel
*/
class PubManager extends MyObjectManager
{
	/**
	 * Pub Manager constructor
	 * 
	 * do not instanciate this object directly
	 * use : get_manager("Pub"); instead
	 * 
	 * @return void
	 */
	function PubManager()
	{
		$specs = array(
		'table' => "pub", 
		'keyName' => 'id', 
		'className' => 'Pub' );
		
		$this->MyObjectManager($specs);
	}
	
	/*
	*	Loads from database the advertisement associated to the emplacement and category
	*	specified in parameters
	*	@func	getAssociatedPub
	*	@param	int $id_emp : id emplacement
	*	@param	int $idcat : id category
	*	@return	array of Objects {@link Pub}
	*/
	function getAssociatedPubs($id_emp,$idcat)
	{
		$ret = array();
		if($id_emp != 0)
		{
			$cat2pubm =& get_manager('cat2pub');
			// selecting ads which are belonging to emplacement $id_emp, 
			// and associated to $idcat category
			$query = "SELECT A.`code` FROM "
					.$this->table." AS A, "
					.$cat2pubm->table." AS B".
					" WHERE A.`id_emp`=".$id_emp.
					" AND A.`id`=B.`idpub`";
			
			$query .= $idcat != 0 ? " AND B.`idcat`=".$idcat : '';
			
			$result = $this->con->select($query);
			if ($result)
			{
				$array = $result->getData();
				foreach($array as $key => $objectattr)
				{
					$object = new $this->classname();
					$object->unsetNew();
					$object->assignVars($objectattr);
					$ret[] = $object;
					unset($object);
				}
			}
		}
		return $ret;
	}
}

?>