<?php

require_once SCRIPT_ROOT_PATH.'/class/object/class.object.php';
require_once SCRIPT_ROOT_PATH.'/class/object/class.tag.php';

/**
 * ScoredTag object class
 * 
 * @author Jerome Loisel
 * @copyright Jerome Loisel
 * @package kernel
 **/
class ScoredTag extends Tag
{
	/**
	 * ScoredTag constructor
	 * 
	 * @param array of vars to assign to Tag attributes
	 * 
	 * @return void
	 */
	function ScoredTag($vars = null)
	{
		$this->Tag();
		
		$attributes = array(
		'score' => array('data_type' => XOBJ_DTYPE_INT, 'value' => 0, 'maxlength' => '10') ); 
		
		$this->addAttribute($attributes);
	}
}


/**
 * ScoredTag Manager class
 * 
 * @author Jerome Loisel
 * @copyright Jerome Loisel
 * @package kernel
 **/
class ScoredTagManager extends TagManager
{
	/**
	 * ScoredTag Manager constructor
	 * 
	 * do not instanciate this object directly
	 * use : get_manager("ScoredTag"); instead
	 * 
	 * @return void
	 */
	function ScoredTagManager()
	{
		$this->TagManager();
		$this->setClass('ScoredTag');
	}
	
	/*
	*	Most popular Tags
	*	@func	getMostPopularTags
	*	@return	array of Objects {@link ScoredTag}
	*/
	function &getMostPopularTags()
	{
		$l2tm =& get_manager('link2tag');
		$ret = array();
		$limit = 50;
		$query = "SELECT `id`,`tag`, COUNT(`lid`) AS `score` FROM `".$this->table."`, `".$l2tm->table."`
					WHERE `approved`='1' 
					AND `id`=`tid` 
					GROUP BY `tag` ASC ORDER BY `score` DESC LIMIT ".$limit;
		$result = $this->con->select($query);
		
		$this->displayDebugQuery($query,$result);
		
		if ($result)
		{
			$array = $result->getData();
			foreach($array as $key => $objectattr)
			{
				$object = new $this->classname();
				$object->unsetNew();
				$object->assignVars($objectattr);
				$ret[] = $object;
				unset($object);
			}
		}
		return $ret;
	}
}